<?php
    require_once("../account00_00/header.php");
    $ret  = array('ok'=>0, 'msg'=>'');

    $PegInput->addVar(new peg_input_alphanumeric('mode'));
    $PegInput->addVar(new peg_input_alphanumeric('tbl'));
    $PegInput->addVar(new peg_input_number('tbl_nr01'));
    $PegInput->addVar(new peg_input_number('hota04_nr01'));
    $PegInput->addVar(new peg_input_number('payment'));
    $PegInput->addVar(new peg_input_number('collected'));
    $PegInput->addVar(new peg_input_number('amount'));

    
    $mode        = $PegInput->getRequest('mode');
    $tbl         = $PegInput->getRequest('tbl');
    $tbl_nr01    = $PegInput->getRequest('tbl_nr01');
    $hota04_nr01 = $PegInput->getRequest('hota04_nr01');


    pegasus_mysql_use('SELECT * FROM ' .$tbl. ' WHERE nr01=?', $data, array($tbl_nr01));

    $data['payment']     = $PegInput->getRequest('payment');
    $data['amount']      = $PegInput->getRequest('amount');
    $data['collected']   = $PegInput->getRequest('collected');
    $data['tbl']         = $PegInput->getRequest('tbl');
    $data['tbl_nr01']    = $PegInput->getRequest('tbl_nr01');
    $data['hota04_nr01'] = $PegInput->getRequest('hota04_nr01');
    

    $ret['data'] = $data;


    //* Αν το "Εισπράχθηκε" είναι μικρότερο του "Ποσού", τότε δίνω το "Εισχπράχθηκε" στην Κίνηση.
    //* Σημειώνω ότι το "Εισπράχθηκε" μπορεί να έρθει γεμάτο μόνο αν έχουμε τρόπο είσπραξης μετρητών, σε κάθε άλλη περίπτωση είναι 0.
    if($data['collected']>0 && ($data['collected']<$data['amount'])) {
        $data['amount'] = $data['collected'];
    }

    if(empty($data['payment'])) {
        $ret['ok']  = 0;
        $ret['msg'] = 'Ο Τρόπος Είσπραξης είναι κενός';
    }elseif(!($hota04_nr01>0)) {
        $ret['ok']  = 0;
        $ret['msg'] = $_SESSION['peg_dic_account00_pay_select_room_reservation'];
    }else{
        $remainder      = invoices_calc_a55_aneisprakto($data['tbl_nr01'], $mode, false, true);
        $is_epi_pistosi = account00_is_epi_pistosi_a14($data['payment']);

        if($is_epi_pistosi==1) {
            //Στην περίπτωση που θα έχω "Χρεωση σε Δωμάτιο θα εχω παντα $is_epi_pistosi==0            
        }else{
            if($data['amount']>$remainder) {
                $ret['msg'] = $_SESSION['peg_dic_account00_pay_amount_exceeds_remainder'];
                $ret['remainder'] = $remainder;
                $ret['ok'] = 0;
            }else{
                $ret['remainder'] = account00_add_hota17($data);
                if($ret['remainder']>0) {
                    $ret['msg'] = $_SESSION['peg_dic_account00_pay_hota17_saved_amount_updated'];
                }
                $ret['ok'] = 1;
            }
        }
    }

    echo json_encode($ret);