<?php

class AccountAppHealthCheckT35 extends AppHealthScenario
{

    public function check()
    {
        $ret_array = array();
        $ret_array['data'] = array('status'=>true,'message'=>$_SESSION['peg_dic_account_app_health_ok_t35']);
        $ret_array['ok'] = 1;
        $ret_array['msg'] = 'Pass';
        $has_error= false;

        $extra_union = '';
        if(pegasus_module_exists('account01')){
            $extra_union = " UNION ALL
                        
                        SELECT 
                            t06.p04 AS tbl, 
                            t01.p302 AS tbl_nr,
                            0  as t01_ypol, 
                            sum(t38.p03-t38.p04)  as t38_ypol		 
                        FROM t38 
                        LEFT JOIN t01 ON t38.p01 = t01.nr01
                        LEFT JOIN t06 ON t06.p01 = t01.p303
                        WHERE
						    t01.p302 > 0 AND t01.p302 IS NOT NULL
                        GROUP BY t38.p01 ";
        }

        //* Τροποποίησα το query με δυο εξωτερικά union για να μπορώ να συγκρίνω και τις διαφορές στα υπόλοιπα, αλλά και τις διαφορές στις εγγραφές μεταξύ t35 και του αποτελέσματος των υπολοίπων.
        //* Αυτό με καλύπτει αν δεν έχει τρέξει ποτέ ο αυτοματισμός και δεν έχω καθόλου t35, ή και αν έχει διαγραφεί κάποιο t35.
        $query = "SELECT COUNT(*) AS cnt
        FROM (
          -- Rows in t35 that do not have a matching row in tbl01
          SELECT t35.tbl, t35.tbl_nr, t35.p03 AS t35_p03, tbl01.p03 AS tbl01_p03
          FROM t35
          LEFT JOIN (
            SELECT 
              ttt.tbl AS tbl,
              ttt.tbl_nr AS tbl_nr,
              SUM((ttt.t01_ypol + ttt.t38_ypol)) AS p03 
            FROM (
              SELECT 
                t06.p04 AS tbl,
                t01.p302 AS tbl_nr,
                SUM(t01.p03 - t01.p04) AS t01_ypol, 
                0 AS t38_ypol
              FROM t06
              LEFT JOIN t01 ON t06.p01 = t01.p303 
              LEFT JOIN t02 ON t02.p01 = t01.p07
              WHERE IF(t06.p04 = 't08', t02.p012 <> 1, 1 = 1)
              GROUP BY t06.p04, t01.p302
              ".$extra_union."
            ) AS ttt 
            WHERE ttt.tbl IN ('a55', 'a56', 't08', 'tran01')
            GROUP BY ttt.tbl, ttt.tbl_nr 
          ) AS tbl01 
          ON t35.tbl_nr = tbl01.tbl_nr AND t35.tbl = tbl01.tbl
          WHERE tbl01.tbl_nr IS NULL OR t35.p03 != tbl01.p03
          
          UNION
          
          -- Rows in tbl01 that do not have a matching row in t35
          SELECT tbl01.tbl, tbl01.tbl_nr, t35.p03 AS t35_p03, tbl01.p03 AS tbl01_p03
          FROM (
            SELECT 
              ttt.tbl AS tbl,
              ttt.tbl_nr AS tbl_nr,
              SUM((ttt.t01_ypol + ttt.t38_ypol)) AS p03 
            FROM (
              SELECT 
                t06.p04 AS tbl,
                t01.p302 AS tbl_nr,
                SUM(t01.p03 - t01.p04) AS t01_ypol, 
                0 AS t38_ypol
              FROM t06
              LEFT JOIN t01 ON t06.p01 = t01.p303 
              LEFT JOIN t02 ON t02.p01 = t01.p07
              WHERE IF(t06.p04 = 't08', t02.p012 <> 1, 1 = 1)
              GROUP BY t06.p04, t01.p302
              ".$extra_union."
            ) AS ttt 
            WHERE ttt.tbl IN ('a55', 'a56', 't08', 'tran01')
            GROUP BY ttt.tbl, ttt.tbl_nr 
          ) AS tbl01
          LEFT JOIN t35 ON t35.tbl_nr = tbl01.tbl_nr AND t35.tbl = tbl01.tbl
          WHERE t35.tbl_nr IS NULL OR t35.p03 != tbl01.p03
        ) AS mismatches
        WHERE tbl_nr IS NOT NULL;";

        pegasus_mysql_use($query,$i47tot_p05);
        if($i47tot_p05['cnt']>0){
            $has_error = true;
        }

        if($has_error){
            $ret_array['msg'] = 'Fail';
            $ret_array['data'] =array(
                'status' => false,
                'message' => $_SESSION['peg_dic_account_app_health_error_t35'],
                'p92' => '140000009000004'
            );
            
        }
        
        return $ret_array;
    }
        
}
