<?php

class AccountDashboardShowPanel extends DashboardShowPanel
{

    protected function InitializeFromType()
    {
        //Για κάθε panel πρέπει να σετάρουμε: 
        //1. $textPHP : Θα πρέπει να κάνει return το strval του αριθμού
        //2. $ajax_request_path : Είναι το path του ajax που κάνει το refresh του panel
        //3. $ajax_response_field_name : Είναι το όνομα του πεδίου στο json που γυρνάει το ajax
        //4. $header_link: Είναι το link που θα ανοίγει το συγκεκριμένο panel από το header

        if (
            $this->dashboard00_11_row['dashboard00_12'] == 140000007000000 ||  ///Προγραμματισμένες Εισπράξεις
            $this->dashboard00_11_row['dashboard00_12'] == 140000028000000 //Προγραμματισμένες Πληρωμές
        ) {

            if ($this->dashboard00_11_row['dashboard00_12'] == 140000007000000) {
                $textPHP = 'return strval(peg_account__t5_d2_query_sum(date(\'Y-m-d\'), date(\'Y-m-d\'), "a01"));' . "\n";
                $ajax_request_path = '/account01/a01_t5_d2_query_sum.php';
                /**Refresh panel */
                $ajax_response_field_name = 'sum';
                /**Link from header */
                $header_link = "peg_windowShow_d('', '_t5_d', 'account', '', '', 0, '', '', {t_type: 'a01'});";
            } else if ($this->dashboard00_11_row['dashboard00_12'] == 140000028000000) {
                $textPHP = 'return strval( peg_account__t5_d2_query_sum(date(\'Y-m-d\'), date(\'Y-m-d\'), "a00"));' . "\n";
                $ajax_request_path = '/account01/a00_t5_d2_query_sum.php';
                /**Refresh panel */
                $ajax_response_field_name = 'sum';
                /**Link from header */
                $header_link = "peg_windowShow_d('', '_t5_d', 'account', '', '', 0, '', '', {t_type: 'a00'});";
            }
        } else  if (
            $this->dashboard00_11_row['dashboard00_12'] == 140000009000000 || //Πωλήσεις Ημέρας (module account)
            $this->dashboard00_11_row['dashboard00_12'] == 140000009000001 || //Αγορές Ημέρας (module account)
            $this->dashboard00_11_row['dashboard00_12'] == 140000009000002 || //Εισπράξεις Ημέρας (module account)
            $this->dashboard00_11_row['dashboard00_12'] == 140000009000003 || //Πληρωμές Ημέρας (module account)
            $this->dashboard00_11_row['dashboard00_12'] == 140000009000004 || //ΦΠΑ Πωλήσεων (module account)
            $this->dashboard00_11_row['dashboard00_12'] == 140000009000005 || //ΦΠΑ Αγορών (module account)
            $this->dashboard00_11_row['dashboard00_12'] == 140000009000006 || //ΦΠΑ Απόδοσης (module account)
            $this->dashboard00_11_row['dashboard00_12'] == 140000009000007 || //Υπόλοιπα Πελατών (module account)
            $this->dashboard00_11_row['dashboard00_12'] == 140000009000008 || //Υπόλοιπα Προμηθευτών (module account)
            $this->dashboard00_11_row['dashboard00_12'] == 140000009000009 || //Αρνητικά Υπόλοιπα Πελατών (module account)
            $this->dashboard00_11_row['dashboard00_12'] == 140000009000010  //Θετικά Υπόλοιπα Προμηθευτών (module account)
        ) {
            $textPHP = '$apo_katasthma = pegasus_module_exists(\'stores\') ? pegasus_mysql_printfld(\'cor003\', \'p301\', \'p01=?\', array($_SESSION[\'pegasus_client_uid\'])) : 0;' . "\n";
            $textPHP .= '$eos_katasthma = pegasus_module_exists(\'stores\') ? pegasus_mysql_printfld(\'cor003\', \'p302\', \'p01=?\', array($_SESSION[\'pegasus_client_uid\'])) : 9999999;' . "\n";
            $textPHP .= '$res_array =  peg_account_calculate_mis001(date(\'Y-m-d\'), date(\'Y-m-d\'), $apo_katasthma, $eos_katasthma);' . "\n";
            switch ($this->dashboard00_11_row['dashboard00_12']) {
                case '140000009000000':
                    /**Initial text */
                    $textPHP .= 'return strval(peg002_format_number($res_array[\'p02\'], 2));';
                    $account_fld_name = 'p02';
                    $header_link = 'dashboard00_button_open_report(140000009000000);';
                    break;
                case '140000009000001':
                    /**Initial text */
                    $textPHP .=  'return strval(peg002_format_number($res_array[\'p09\'], 2));';
                    $account_fld_name = 'p09';
                    $header_link = 'dashboard00_button_open_report(140000009000004);';
                    break;
                case '140000009000002':
                    /**Initial text */
                    $textPHP .=  'return strval(peg002_format_number($res_array[\'p03\'], 2));';
                    $account_fld_name = 'p03';
                    $header_link = 'dashboard00_button_open_report(140000009000001);';
                    break;
                case '140000009000003':
                    /**Initial text */
                    $textPHP .=  'return strval(peg002_format_number($res_array[\'p010\'], 2));';
                    $account_fld_name = 'p010';
                    $header_link = 'dashboard00_button_open_report(140000009000005);';
                    break;
                case '140000009000004':
                    /**Initial text */
                    $textPHP .=  'return strval(peg002_format_number($res_array[\'p301\'], 2));';
                    $account_fld_name = 'p301';
                    $header_link = '';
                    break;
                case '140000009000005':
                    /**Initial text */
                    $textPHP .=  'return strval(peg002_format_number($res_array[\'p302\'], 2));';
                    $account_fld_name = 'p302';
                    $header_link = '';
                    break;
                case '140000009000006':
                    /**Initial text */
                    $textPHP .=  'return strval(peg002_format_number($res_array[\'p303\'], 2));';
                    $account_fld_name = 'p303';
                    $header_link = '';
                    break;
                case '140000009000007':
                    /**Initial text */
                    $textPHP .=  'return strval(peg002_format_number($res_array[\'p05\'], 2));';
                    $account_fld_name = 'p05';
                    pegasus_mysql_use('select * from p80 where cd = ?', $p80, array('customers._t3_d1'));
                    $header_link = dashboard00_open_menu_item_JScode($p80['nr01']);
                    break;
                case '140000009000008':
                    /**Initial text */
                    $textPHP .=  'return strval(peg002_format_number($res_array[\'abs_p07\'], 2));';
                    $account_fld_name = 'abs_p07';
                    pegasus_mysql_use('select * from p80 where cd = ?', $p80, array('suppliers._t3_d1'));
                    $header_link = dashboard00_open_menu_item_JScode($p80['nr01']);
                    break;
                case '140000009000009':
                    /**Initial text */
                    $textPHP .=  'return strval(peg002_format_number($res_array[\'abs_p05_1\'], 2));';
                    $account_fld_name = 'abs_p05_1';
                    pegasus_mysql_use('select * from p80 where cd = ?', $p80, array('customers._t3_d1'));
                    $header_link = 'dashboard00_button_open_report(140000009000022);';
                    break;
                case '140000009000010':
                    /**Initial text */
                    $textPHP .=  'return strval(peg002_format_number($res_array[\'p07_1\'], 2));';
                    $account_fld_name = 'p07_1';
                    pegasus_mysql_use('select * from p80 where cd = ?', $p80, array('suppliers._t3_d1'));
                    $header_link = 'dashboard00_button_open_report(140000028000001);';
                    break;
                default:
                    break;
            }
            $ajax_request_path = '/account01/mis001_find_today_totals.php';
            $ajax_response_field_name = $account_fld_name;
        }

        if (!empty($ajax_request_path)) {
            $header_refresh_handler = $this->refresh_ajax_setData_to_field($ajax_request_path, $ajax_response_field_name);
            $this->p52['header_refresh'] = array('par_val' => $header_refresh_handler, 'code' => 0);
        }
        if (!empty($header_link)) {
            $this->p52['header_link'] = array('par_val' => $header_link, 'code' => 0);
        }

        $this->p52['text'] = array('par_val' => $textPHP, 'code' => 1);
    }
}
