<?php

class App_healthAppHealthUseremail extends AppHealthScenario
{
	public function check()
	{
		$data = array(
			'status'	=> true,
			'message'	=> $_SESSION['peg_dic_app_health_app_health_useremail_pass']
		);
		//
		try {
			$json_response = pegasus_curl_request('https://services00.pegcloud.io/is_alive.php', false,  array(), array(CURLOPT_TIMEOUT => 4));
		} catch (Exception $ex) {
			$json_response = false;
		}

		if (!empty($json_response) and  $json_response == 'true') {
			$url = "https://services00.pegcloud.io/peg_app_info/execute.php";
		} else {
			$url = "https://services.tesae.gr/peg_app_info/execute.php";
		}

		$sn			= 'Π' . pegasus_leading_zeros($_SESSION['cor000_sn'], 7);
		$user = $_SESSION['cor000_tesae_user'];
		$pass = $_SESSION['cor000_tesae_pass'];
		$app_code = $_SESSION['cor000_app_code'];
		$resp = pegasus_curl_request_post($url, array(
			'action'	=> 'login',
			'user'		=> $user,
			'pass'		=> $pass,
			'sn'		=> $sn,
			'un'		=> 1
		));
		$xml = simplexml_load_string($resp);
		if ($xml->code != '100') {
			return array(
				'ok'	=> 1,
				'data'	=> array(
					'status'	=> false,
					'message'	=> $_SESSION['peg_dic_app_health_app_health_useremail_error_1'],
					'_d'		=> array('table' => 'cor000', '_d' => 'cor000_d', 'module' => 'core', 'nr01' => 1)
				),
				'msg'	=> 'Fail'
			);
		}
		$sid = $xml->sid;
		$resp = pegasus_curl_request_post($url, array(
			'action'	=> 'get_app_info',
			'sid'		=> $sid,
			'sn'		=> $sn,
			'app_code'	=> $app_code
		));
		$xml = simplexml_load_string($resp);
		if ($xml->code != 200) {
			return array(
				'ok'	=> 1,
				'data'	=> array(
					'status'	=> false,
					'message'	=> $_SESSION['peg_dic_app_health_app_health_useremail_error_1'],
					'_d'		=> array('table' => 'cor000', '_d' => 'cor000_d', 'module' => 'core', 'nr01' => 1)
				),
				'msg'	=> 'Fail'
			);
		}
		$lang = strtolower($_SESSION['lang']);
		if ($lang == 'gr') {
			$lang = 'el';
		} else {
			$lang = 'en';
		}
		$xml_data = json_decode(base64_decode($xml->data), true);
		$email = '';
		foreach ($xml_data as $cat) {
			foreach ($cat['data'] as $v) {
				if ($v['name'] == 'd00_00_p11') {

					$email = $v['value'];
				}
			}
		}
		if (empty($email)) {
			return array(
				'ok'	=> 1,
				'data'	=> array(
					'status'	=> false,
					'message'	=> $_SESSION['peg_dic_app_health_app_health_useremail_error_2'],
				),
				'msg'	=> 'Fail'
			);
		}
		$email = substr($email, strpos($email, '>', 1) + 1);
		$email = substr($email, 0, strpos($email, '<', 1));
		if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
			return array(
				'ok'	=> 1,
				'data'	=> array(
					'status'	=> false,
					'message'	=> $_SESSION['peg_dic_app_health_app_health_useremail_error_3'],
				),
				'msg'	=> 'Fail'
			);
		}
		return array(
			'ok'	=> 1,
			'data'	=> $data,
			'msg'	=> 'Pass'
		);
	}
}
