<?php
class AppHealthScenariosLoader
{
	public function check($modules, $module, $scenario) {
		$find = $this->find($modules);
		$moduleScenarios = $find['data'];
		if(!isset($moduleScenarios[$module])) {
			return array(
				'ok'	=> 0,
				'data'	=> null,
				'msg'	=> "Module don't have any Scenario"
			);
		}
		if(!isset($moduleScenarios[$module]['scenarios'][$scenario])) {
			return array(
				'ok'	=> 0,
				'data'	=> null,
				'msg'	=> "Module Scenario not exist"
			);
		}
		$scenario = $moduleScenarios[$module]['scenarios'][$scenario];
		if(!class_exists($scenario['class'])) {
			if(!file_exists($scenario['path'])) {
				return array(
					'ok'	=> 0,
					'data'	=> null,
					'msg'	=> 'Scenarios file not exists'
				);
			}
			include($scenario['path']);
		}
		$scenario_obj = new $scenario['class']();
		return $scenario_obj->check();
	}
	public function find($modules = array())
	{
		$data = array();
		foreach ($modules as $module) {
			
			$path = "../../pegasus_cloud_app/" . $module['p00'] . "_app_health/";
			if (is_dir($path)) {
				$dir = opendir($path);
				while ($file = readdir($dir)) {
					if ($file == '.' || $file == '..') {
						continue;
					}
					$exp = explode('.', $file);
					if (
						count($exp) != 2
						|| $exp[1] != 'php'
					) {
						continue;
					}
					if(substr($exp[0],0,strlen($module['p00'])) != $module['p00']) {
						continue;
					}
					$exp[0] = substr($exp[0],strlen($module['p00'])+1);
					$exp = explode('_', $exp[0]);
					if(
						count($exp) < 3
						|| $exp[0] != 'app'
						|| $exp[1] != 'health'
					) {
						continue;
					}
					$class = ucfirst($module['p00']).'AppHealth'.ucfirst($exp[2]);
					$data[$module['p00']]['name'] = $module['p01'];
					$data[$module['p00']]['scenarios'][$exp[count($exp)-1]]['class'] = $class;
					$data[$module['p00']]['scenarios'][$exp[count($exp)-1]]['path'] = $path.$file;
				}
				closedir($dir);
			}
		}
		return array(
			'ok'	=> 1,
			'data'	=> $data,
			'msg'	=> 'Success'
		);
	}
}
