<?php
//XXX Start General functions
function charts_get_fields($charts_q10)
{
	$grid_array = array();
	if (empty($charts_q10['q10'])) {
		return $grid_array;
	}

	$query_q12 = 'select * from q12 where  p023=0 and  p00=? order by p05 ';
	$res_q12 = pegasus_query($query_q12, array($charts_q10['q10']));
	$q12_i = 0;

	while ($q12 = pegasus_fetch($res_q12, PEG_FETCH_ASSOC)) {
		$q12_i++;
		if (strtoupper($q12['p06']) != 'N') {
			$grid_array[] = array('name' => $q12['p03'], 'type' =>  'string');
		} else {
			$grid_array[] = array('name' => $q12['p03'], 'type' =>  'number');
		}
	}
	return $grid_array;
}

function charts_get_query($charts_q10)
{
	$query = '';
	if (empty($charts_q10['q10'])) {
		return $query;
	}

	$query = query_make_select($charts_q10['q10']);
	$query = trim($query);

	if (peg_substr($query, -1, 1) == ';') {
		$query  = peg_substr($query, 0, -1);
	}
	return $query;
}


function charts_getBtBarType($param, $is3d = false)
{
	if ($param == 'N') {
		if ($is3d == '3d') {
			return 'numeric3d';
		} else {
			return 'numeric';
		}
	} elseif ($param == 'D') {
		if ($is3d == '3d') {
			return 'category3d';
		} else {
			return 'category';
		}
	} else {
		if ($is3d == '3d') {
			return 'category3d';
		} else {
			return 'category';
		}
	}
}

function charts_getTmpImage($chart_q10_nr01, $imageStr)
{
	if (empty($chart_q10_nr01)) {
		return null;
	}

	if (empty($imageStr)) {
		return null;
	}
	$dir = '../../tmp/' . session_id() . '/';
	$f_path = $dir . '/printpdf/';
	@mkdir($f_path);

	$f_path = $f_path . '/' . $chart_q10_nr01 . '/';
	@mkdir($f_path);

	$imageFile  = $f_path . 'images.png';

	peg_write_file($imageFile, $imageStr);
	return $imageFile;
}
//XXX Start Draw functions
/**
 * Ορισμοί Γραφημάτων
 * @param array $data
 * @param string $mmnr01
 * @param string $mnr01
 * @param string $_d
 * @param string $container_id
 */
function core_charts_q10_d_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '')
{
	if ($_d == 'charts_q10_d') {
		$peg_is_new_rec = 0;
		$peg_tmp_mmnr01Ar = explode('-', $mmnr01);
		if ($peg_tmp_mmnr01Ar[0] == 'q10_d') {
			$data['q10'] = $peg_tmp_mmnr01Ar[1];
			$data['q10_readonly'] = true;
		}
		if (empty($data['nr01'])) {
			$peg_is_new_rec = 1;
			if (empty($_REQUEST['rec_copy_nr01'])) {
				$data['type'] = 'cartesianarea';
				if (!empty($data['q10']) && is_numeric($data['q10'])) {
					$q10 = null;
					pegasus_mysql_use("select nr01, p01, ep01, module_00 from q10 where nr01 = ?", $q10, array($data['q10']));

					$data['p01'] = $q10['p01'];
					$data['ep01'] = $q10['ep01'];


					if (pegasus_profile_check_module_permission('dias') && !empty($q10['module_00'])) {
						$data['module'] =  $q10['module_00'];
						$data['module_hidden'] = 2;
					}
				}
			}
		}

		if ($peg_is_new_rec === 0) {
			$data['module_hidden'] = 2;
		}

		$data['core_charts_q10_d_groupfield_hidden'] = true;
		$data['core_charts_q10_d_xaxis_hidden'] = true;
		$data['core_charts_q10_d_yaxis_hidden'] = true;
		$data['core_charts_q10_d_yminimum_hidden'] = true;
		$data['core_charts_q10_d_ymaximum_hidden'] = true;
		$data['core_charts_q10_d_cartesiandisplay_hidden'] = true;

		$data['core_charts_q10_d_angularaxis_hidden'] = true;
		$data['core_charts_q10_d_label_hidden'] = true;

		if (peg_substr($data['type'], 0, 9) == 'cartesian') {
			$data['core_charts_q10_d_groupfield_hidden'] = false;
			$data['core_charts_q10_d_xaxis_hidden'] = false;
			$data['core_charts_q10_d_yaxis_hidden'] = false;
			$data['core_charts_q10_d_cartesiandisplay_hidden'] = false;
			$data['core_charts_q10_d_yminimum_hidden'] = false;
			$data['core_charts_q10_d_ymaximum_hidden'] = false;
		} elseif ($data['type'] == 'pie') {
			$data['core_charts_q10_d_angularaxis_hidden'] = false;
			$data['core_charts_q10_d_label_hidden'] = false;
		}

		$query_q12 = pegasusGetGlobalVar(pegasus_container_id_get_parentBy_d($container_id , 'q10_d') . '_where_q12'); 

		$label_query = " select * from peg_tmp_q12 where p06 = 'C' ";		
		pegasusSetGlobalVar(
			$container_id . '_label_query',
			array(
				'sql' => $label_query . ' and '. $query_q12['sql'], 
				'sqlParams' => $query_q12['sqlParams'])
		);

		$angularaxis_query = " select * from peg_tmp_q12 where p06 = 'N' ";
		pegasusSetGlobalVar(
			$container_id . '_angularaxis_query',
			array(
				'sql' => $angularaxis_query . ' and '. $query_q12['sql'], 
				'sqlParams' => $query_q12['sqlParams'])
		);

		$xaxis_query = " select * from peg_tmp_q12 where ( p06 = 'C' ||  p06 = 'D' ) ";
		pegasusSetGlobalVar(
			$container_id . '_xaxis_query',
			array(
				'sql' => $xaxis_query . ' and '. $query_q12['sql'], 
				'sqlParams' => $query_q12['sqlParams'])
		);

		$yaxis_where = "  p06 = 'N' ";
		pegasusSetGlobalVar(
			$container_id . '_yaxis_where',
			array(
				'sql' => $yaxis_where . ' and '. $query_q12['sql'], 
				'sqlParams' => $query_q12['sqlParams'])
		);

		$groupfield_query = " select * from peg_tmp_q12 where p06 = 'C' ";
		pegasusSetGlobalVar(
			$container_id . '_groupfield_query',
			array(
				'sql' => $groupfield_query . ' and '. $query_q12['sql'], 
				'sqlParams' => $query_q12['sqlParams'])
		);
		
	}

	return $data;
}

 /**
  * 
  * @param mixed $nr01 
  * @param mixed $q10nr01 
  * @param mixed $q13_values_arr 
  * @return array 
  */
function charts__charts_display_cartesian_d_find_series_and_axes($nr01, $q10nr01, $q13_values_arr= array())
{
	if(empty($q13_values_arr)){
		$q13_values_arr = query_g13_getInitialValues($q10nr01);
	}

	pegasus_mysql_use(" select * from charts_q10 where nr01 = :nr01 ", $charts_q10, array('nr01' => $nr01));
	$leftAxis = array(
		'type' => 'numeric',
		'position' => 'left'
	);
	$btAxis = array(
		'position' => 'bottom'
	);
	$fieldsArray = null;
	$fieldsTitleArray = null;

	if (!empty($charts_q10['groupfield'])) { //πεδίο ομαδοποίησης
		$fieldsArray = array();
		$fieldsTitleArray = array();
		$q10_query = charts_get_query($charts_q10);
		$q10_query_arr = query_replace_q13_from_array($q10nr01, $q10_query, $q13_values_arr);

		$q10_res = pegasus_query(
			"select distinct(" . $charts_q10['groupfield'] . ") as fld from ( ". $q10_query_arr['sql'] ." ) as tmptbl order by " . $charts_q10['groupfield'],
			$q10_query_arr['sqlParams']
		);
		while ($rec = pegasus_fetch($q10_res, PEG_FETCH_ASSOC)) {
			$fieldsArray[] = $rec['fld'];
			$fieldsTitleArray[] = $rec['fld'];
		}
	} elseif (strpos($charts_q10['yaxis'], '#') !== false) {
		//echo $charts_q10['yaxis'];
		$tmp_charts_q10 = substr($charts_q10['yaxis'], 1, -1);
		if (strpos($tmp_charts_q10, '#') !== false) {
			$fieldsArray = explode('#', $tmp_charts_q10);
		} else {
			$fieldsArray = array($tmp_charts_q10);
		}
	} else {
		$fieldsArray = array(substr($charts_q10['yaxis'], 1, -1));
	}

	$cartesianBtBarType = 'C';
	if ($q10nr01 > 0) {
		$fieldsTitleArray = array();
		$query = "select * from q12 where p00 = :q10_nr01 ";

		foreach ($fieldsArray as &$value) {
			$value = trim($value);
			$fieldsTitleArray[$value] = $value;
		}

		$res = pegasus_query($query, array('q10_nr01' => $q10nr01));
		while ($row = pegasus_fetch($res, PEG_FETCH_ASSOC)) {
			$row_p03 = trim($row['p03']);
			if (!empty($fieldsTitleArray[$row_p03])) {

				if ($_SESSION['lang'] == 'EN' && !empty($row['ep01'])) {
					$fieldsTitleArray[$row_p03] = $row['ep01'];
				} else {
					$fieldsTitleArray[$row_p03] = $row['p01'];
				}
			}

			if ($charts_q10['xaxis'] == $row_p03) {
				$cartesianBtBarType = $row['p06'];
			}
		}
		$fieldsTitleArray = array_values($fieldsTitleArray);
	}

	if (empty($fieldsTitleArray)) {
		$fieldsTitleArray = $fieldsArray;
	}


	$renderFn = '';
	$cartesianDisplay  = '';
	$cartesianBtBar  = '';
	$cartesianStacked = false;

	$seriesLabel = array(
		'field' => $fieldsArray,
		'display' => 'under',
	);
	//die($charts_q10['type']);
	if ($charts_q10['type'] == 'cartesianarea') {
		$cartesianDisplay = 'area';
		$cartesianBtBar  = charts_getBtBarType($cartesianBtBarType,  false);
	} elseif ($charts_q10['type'] == 'cartesianline') {
		$cartesianDisplay = 'line';
		$cartesianBtBar  = charts_getBtBarType($cartesianBtBarType,  false);
	} elseif ($charts_q10['type']  == 'cartesianbar3dgroup') {
		$cartesianDisplay = 'bar3d';
		// 	    $cartesianDisplay = 'bar';
		$cartesianBtBar  = charts_getBtBarType($cartesianBtBarType,  true);
	} elseif ($charts_q10['type']  == 'cartesianbarstacked') {
		$cartesianStacked = true;
		// 	    $cartesianDisplay = 'bar3d';
		$cartesianDisplay = 'bar';
		$seriesLabel = null;
		$cartesianBtBar  = charts_getBtBarType($cartesianBtBarType,  false);
	} else {
		die('Undefined display type');
	}

	if ($cartesianBtBarType == 'D') {
		$renderFn = 'charts_displayDate';
	}


	$leftAxis['fields'] = $fieldsArray;
	$leftAxis['title'] = $fieldsTitleArray;

	if (!empty($charts_q10['yminimum']) || (is_numeric($charts_q10['yminimum']) && $charts_q10['yminimum'] === "0")) {
		$minVal = $charts_q10['yminimum'];
		if (substr($charts_q10['yminimum'], 0, 1) === '=') {
			$code = substr($charts_q10['yminimum'], 1);
			$retTmp = @eval('$minVal = ' . $code . ';');

			if ($retTmp === false && ($error = error_get_last())) {
				if (pegasus_displayErrors()) {
					print_r($charts_q10['yminimum']);
					var_dump($error);
				}

				die('Error in eval');
			}
		}
		$leftAxis['minimum'] = $minVal + 0;
	}
	if (!empty($charts_q10['ymaximum']) || (is_numeric($charts_q10['ymaximum']) && $charts_q10['ymaximum'] === "0")) {
		$maxVal = $charts_q10['ymaximum'];
		if (substr($charts_q10['ymaximum'], 0, 1) === '=') {
			$code = substr($charts_q10['ymaximum'], 1);

			$retTmp = @eval('$maxVal = ' . $code . ';');

			if ($retTmp === false && ($error = error_get_last())) {
				if (pegasus_displayErrors()) {
					print_r($charts_q10['ymaximum']);
					var_dump($error);
				}

				die('Error in eval');
			}
		}
		$leftAxis['maximum'] = $maxVal + 0;
	}

	$btAxis['type'] = $cartesianBtBar;
	$btAxis['fields'] = $charts_q10['xaxis'];
	$btAxis['renderer'] = $renderFn;
	$btAxis['label'] = array(
		'rotate' => array(
			'degrees' => -90
		)
	);


	$series = array();

	if ($cartesianDisplay == 'line') {
		for ($i = 0; $i < count($fieldsArray); $i++) {
			$tmpAr = array(
				'type' => $cartesianDisplay,
				'stacked' => $cartesianStacked,
				'highlight' => true,
				'style' => array('opacity' => .6),
				'xField' => $charts_q10['xaxis'],
				'yField' => $fieldsArray[$i],
				'label' => array(
					'field' => $fieldsArray[$i],
					'display' => 'under',
				)
			);

			if (!empty($fieldsTitleArray[$i])) {
				$tmpAr['title'] = $fieldsTitleArray[$i];
			}

			$series[] = $tmpAr;
		}
	} else {
		$series = array(
			'type' => $cartesianDisplay,
			'stacked' => $cartesianStacked,
			'highlight' => true,
			'style' => array('opacity' => .6),
			'xField' => $charts_q10['xaxis'],
			'yField' => $fieldsArray,

		);
		$series['tooltip'] = array(
			'trackMouse' => true,
			'renderer' => 'seriesTooltipRenderer'
		);

		if (!empty($seriesLabel)) {
			$series['label'] = $seriesLabel;
		}


		if (!empty($fieldsTitleArray)) {
			$series['title'] = $fieldsTitleArray;
		}
	}

	return array(
		array(
			$leftAxis,
			$btAxis
		),
		$series
	);
}


/**
 * 
 * @param mixed $nr01 
 * @param mixed $q10_nr01 
 * @param mixed $q13_values 
 * @return (array|array)[cartesianchart_fields | cartesianchart_query(sql, sqlParams)] 
 */
function charts__charts_display_cartesian_d_find_fields_and_query($nr01, $q10_nr01, $q13_values=array())
{

	pegasus_mysql_use(" select * from charts_q10 where nr01 = :nr01 ", $charts_q10, array('nr01' => $nr01));
	$cartesianchart_fields = null;
	$cartesianchart_query = null;
	$cartesianchart_fields = array();
	$cartesianchart_fields[] =  array('name' => $charts_q10['xaxis'], 'type' =>  'string', 'peg_fromjoin' => 0);

	$cartesianchart_query = charts_get_query($charts_q10);
	$cartesianchart_query = query_replace_q13_from_array($q10_nr01, $cartesianchart_query, $q13_values);
	if (!empty($charts_q10['groupfield'])) {
		/**
		 * Αν έχει groupfield τότε θα πρέπει να προσθέσω στα cartesianchart_fields
		 * τις τιμές του group. Αυτό γίνεται στην αρχικοποίηση της οθόνης, 
		 * επομένως αν στο query με τις αρχικές τιμές δεν έρθουν όλες οι πιθανές τιμές 
		 * του groupfield, δεν θα εμφανιστούν μετά.
		 */
		$yaxis = substr($charts_q10['yaxis'], 1, -1);
		$xaxis = $charts_q10['xaxis'];
		$groupfield = $charts_q10['groupfield'];		
		
		$q10_query00 = $cartesianchart_query;

		$q10_res = pegasus_query(
			"select distinct(" . $groupfield . ") as fld from ( ". $q10_query00['sql'] ." ) as tmptbl order by " . $groupfield,
			$q10_query00['sqlParams']
		);


		while ($rec = pegasus_fetch($q10_res, PEG_FETCH_ASSOC)) {
			$fld = $rec['fld'];
			$cartesianchart_fields[] = array('name' => $fld, 'type' =>  'number', 'peg_fromjoin' => 1);
		}

		$oldQuery = $cartesianchart_query['sql'];
		$cartesianchart_query['sql'] = "select ";

		foreach ($cartesianchart_fields as $value) {
			if ($value['peg_fromjoin'] == 1) {
				$cartesianchart_query['sql'] .= " sum(if( $groupfield = '" . $value['name'] . "'  , $yaxis , 0 )) as `" . $value['name'] . "`, ";
			} else {
				$cartesianchart_query['sql'] .= "maintbl." . $value['name'] . ", ";
			}
		}
		$cartesianchart_query['sql'] = substr($cartesianchart_query['sql'], 0, -2);
		$cartesianchart_query['sql'] .= " from ( $oldQuery ) as maintbl";

		$cartesianchart_query['sql'] .= " group by $xaxis";
	}
	return array($cartesianchart_fields, $cartesianchart_query);
}