<?php

class ChartsDashboardShowCart extends DashboardElement
{
    public function __construct($params_array)
    {
        parent::__construct($params_array);
        //$this->view_type = 'button';

        $this->InitializeFromType();

        $this->p52['title'] = array('par_val' => $this->title, 'code' => 0);
        $this->p52['eTitle'] = array('par_val' => $this->eTitle, 'code' => 0);

        $this->p52['preventHeader'] = array('par_val' => "false", 'code' => 0);
        $this->p52['header_refresh'] = array('par_val' => "def", 'code' => 0);
    }

    protected function InitializeFromType()
    {
        pegasus_mysql_use(
            'select charts_q10.*, 
            q10.p01 as q10_p01, 
            q10.ep01 as q10_ep01
            from charts_q10 
            left join q10 on q10.nr01 = charts_q10.q10
            where charts_q10.nr01 = ?',
            $q10_charts,
            array($this->dashboard00_11_row['charts_q10'])
        );

        if (!($q10_charts['nr01'] > 0)) {
            throw  new Exception();
        }

        if (empty($this->title)) {
            $this->title = $q10_charts['q10_p01'];
        }
        if (empty($this->eTitle)) {
            $this->eTitle = $q10_charts['q10_p01'];
        }

        $this->field_type = 'V';

        switch ($q10_charts['type']) {
            case 'pie':
                $this->view_type = 'polarchart';

                $fieldsPHP =
                    'pegasus_mysql_use("select charts_q10.* from charts_q10 where charts_q10.nr01 = ?", $q10_charts, array(\'' . $this->dashboard00_11_row['charts_q10'] . '\'));' . "\n" .
                    'return charts_get_fields($q10_charts);';

                $queryPHP =
                    'pegasus_mysql_use("select charts_q10.* from charts_q10 where charts_q10.nr01 = ?", $q10_charts, array(\'' . $this->dashboard00_11_row['charts_q10'] . '\'));' . "\n" .
                    '$query = charts_get_query($q10_charts);' . "\n" .
                    '$query = query_replace_q13_from_array(\'' .  $q10_charts['q10'] . '\', $query);' . "\n" .
                    'return $query;';

                $angularaxisPHP =
                    'pegasus_mysql_use("select charts_q10.* from charts_q10 where charts_q10.nr01 = ?", $q10_charts, array(\'' . $this->dashboard00_11_row['charts_q10'] . '\'));' . "\n" .
                    'return $q10_charts["angularaxis"];';
                $seriesLabelPHP =
                    'pegasus_mysql_use("select charts_q10.* from charts_q10 where charts_q10.nr01 = ?", $q10_charts, array(\'' . $this->dashboard00_11_row['charts_q10'] . '\'));' . "\n" .
                    'return $q10_charts["label"];';

                $this->p52['angularaxis'] =  array('par_val' => $angularaxisPHP, 'code' => 1);
                $this->p52['seriesLabel'] =  array('par_val' => $seriesLabelPHP, 'code' => 1);
                break;
            default:
                //cartesianarea, cartesianbarstacked, cartesianbar3dgroup, cartesianline
                $this->view_type = 'cartesianchart';

                $queryPHP =
                    'pegasus_mysql_use("select charts_q10.* from charts_q10 where charts_q10.nr01 = ?", $q10_charts, array(\'' . $this->dashboard00_11_row['charts_q10'] . '\'));' . "\n" .
                    'list($fields, $query) = charts__charts_display_cartesian_d_find_fields_and_query(\'' . $this->dashboard00_11_row['charts_q10'] . '\', $q10_charts["q10"]);' . "\n" .
                    'return $query;';

                $fieldsPHP =
                    'pegasus_mysql_use("select charts_q10.* from charts_q10 where charts_q10.nr01 = ?", $q10_charts, array(\'' . $this->dashboard00_11_row['charts_q10'] . '\'));' . "\n" .
                    'list($fields, $query) = charts__charts_display_cartesian_d_find_fields_and_query(\'' . $this->dashboard00_11_row['charts_q10'] . '\', $q10_charts["q10"]);' . "\n" .
                    'return $fields;';

                $axesPHP =
                    'pegasus_mysql_use("select charts_q10.* from charts_q10 where charts_q10.nr01 = ?", $q10_charts, array(\'' . $this->dashboard00_11_row['charts_q10'] . '\'));' . "\n" .
                    'list($axes, $series) = charts__charts_display_cartesian_d_find_series_and_axes(\'' . $this->dashboard00_11_row['charts_q10'] . '\', $q10_charts["q10"]);' . "\n" .
                    'return $axes;';
                $seriesPHP =
                    'pegasus_mysql_use("select charts_q10.* from charts_q10 where charts_q10.nr01 = ?", $q10_charts, array(\'' . $this->dashboard00_11_row['charts_q10'] . '\'));' . "\n" .
                    'list($axes, $series) = charts__charts_display_cartesian_d_find_series_and_axes(\'' . $this->dashboard00_11_row['charts_q10'] . '\', $q10_charts["q10"]);' . "\n" .
                    'return $series;';
                $this->p52['axes'] =  array('par_val' => $axesPHP, 'code' => 1);
                $this->p52['series'] =  array('par_val' => $seriesPHP, 'code' => 1);
                break;
        }
        $this->p52['header_link'] = array('par_val' => "dashboard00_button_open_report(" . $q10_charts['q10'] . ")", 'code' => 0);
        $this->p52['fields'] =  array('par_val' => $fieldsPHP, 'code' => 1);
        $this->p52['query'] =  array('par_val' => $queryPHP, 'code' => 1);
    }
    /**
     * @return true||false
     */
    public function CheckPermission()
    {
        $q10_nr01 = pegasus_mysql_printfld('charts_q10', 'q10', 'nr01=?', array($this->dashboard00_11_row['charts_q10']));
        //Ελέγχω την ύπαρξη της συνάρτησης για να μην χτυπήσει στο update
        $all_table_exist = function_exists('peg_query_allReportTablesExist') ? peg_query_allReportTablesExist($q10_nr01) : true;
        $can_profile_read = peg_query_canProfileRead($q10_nr01, $this->profile);
        return $all_table_exist && $can_profile_read;
    }
}
