<?php

class Core00Screen extends Core00Element
{
	public $elements = array();
	public $lastElementIndex = 0;
	public $table = '';
	public $profiles = array();
	private $p20 = array();
	private $index;

	public function __construct(
		$_d = '',
		$module = '',
		$title = '',
		$eTitle = '',
		$table = '',
		$screen_p52 = array()
	) {
		parent::__construct($title, $eTitle, "screen");

		$this->_d = $_d;
		$this->module = $module;
		$this->field_type = "";
		$this->view_type = "screen";
		$this->screenIndex = 1;
		$this->lastElementIndex = $this->index;
		$this->elements = array();
		$this->table = $table;

		foreach ($screen_p52 as $name => $v) {
			$this->addP52($name, $v);
		}
	}

	public function create($args = array())
	{
		$this->deleteOldScreen();
		$this->createp50();
		$this->crateDefaultButtons(isset($args['DefaultButtons'])?$args['DefaultButtons']:array());
		parent::create();
		foreach ($this->elements as $el) {			
			$el->create();
		}
		if (!empty($this->table)) {
			$this->recreateTable();
		}
	}



	public function addP20($p20)
	{
		$this->p20[] = array(
			'p10'		=> $p20['p10'],
			'module'	=> $this->module,

			'p01'		=> $p20['p01'],									// Table 1
			'p02'		=> isset($p20['p02']) ? $p20['p02'] : '',		// Field 1
			'p12'		=> isset($p20['p12']) ? $p20['p12'] : '',		// Field 2
			'p22'		=> isset($p20['p22']) ? $p20['p22'] : '',		// Field 3

			'p010'		=> isset($p20['p010']) ? $p20['p010'] : 0,		// onChange:Change records of table 2
			'p011'		=> isset($p20['p011']) ? $p20['p011'] : 0,		// onCopy:Copy records of table 2
			'p012'		=> isset($p20['p012']) ? $p20['p012'] : 0,		// onDelete:Delete records of table 2
			'p013'		=> isset($p20['p013']) ? $p20['p013'] : 0,		// onDelete: Deny delete on table1 if exists records in table 2
			'p014'		=> isset($p20['p014']) ? $p20['p014'] : 0,		// onSave: Save the data of table2 temporary

			'p03'		=> $p20['p03'],									// Table 2
			'p04'		=> isset($p20['p04']) ? $p20['p04'] : '',		// Field 1
			'p14'		=> isset($p20['p14']) ? $p20['p14'] : '',		// Field 2
			'p24'		=> isset($p20['p24']) ? $p20['p24'] : '',		// Field 3

			'p030'		=> isset($p20['p030']) ? $p20['p030'] : 0,		// onChange:Change records of table 1
			'p031'		=> isset($p20['p031']) ? $p20['p031'] : 0,		// onCopy:Copy records of table 1
			'p032'		=> isset($p20['p032']) ? $p20['p032'] : 0,		// onDelete:Delete records of table 1
			'p033'		=> isset($p20['p033']) ? $p20['p033'] : 0,		// onDelete: Deny delete on table2 if exists records in table 1
			'p034'		=> isset($p20['p034']) ? $p20['p034'] : 0,		// onSave: Save the data of table1 temporary
		);
	}

	public function setProfilesWithPrivilege($profiles)
	{
		$this->profiles = $profiles;
	}
	private function crateDefaultButtons($args = array())
	{
		//  Delete Existing (type : save_tab | update_tab | close_tab)
		pegasus_mysql_delete(
			'p81',
			"   p81._d = :_d
				AND p81.module = :module
				AND (
					type = 'save_tab'
					OR type = 'update_tab'
					OR type = 'close_tab'
				)
			",
			0,
			array('_d' => $this->_d, 'module' => $this->module)
		);
		// Set Save and update btn if table exist
		$handler_js = isset($args['save_tab']['handler_js']) ? $args['save_tab']['handler_js'] : '';
		if (!empty($this->table)) {
			$savebtn = new Core00Toolbar(array(
				'type'		=> 'save_tab',
				'title'		=> 'Καταχώρηση',
				'etitle'	=> 'Save',
				'module'	=> $this->module,
				'_d'		=> $this->_d,
				'iconcls'	=> 'icon-save',
				'icon_only'	=> 0,
				'handler_js' => $handler_js,
				'icon'		=> '',
				'pos'		=> 'bottom'
			));
			$savebtn->create();
			//
			$handler_js = isset($args['update_tab']['handler_js']) ? $args['update_tab']['handler_js'] : '';
			$updatebtn = new Core00Toolbar(array(
				'type'		=> 'update_tab',
				'title'		=> 'Ενημέρωση',
				'etitle'	=> 'Update',
				'module'	=> $this->module,
				'_d'		=> $this->_d,
				'iconcls'	=> 'icon-update',
				'icon_only'	=> 0,
				'handler_js' => $handler_js,
				'icon'		=> '',
				'pos'		=> 'bottom'
			));
			$updatebtn->create();

			// Set close btn
			$handler_js = isset($args['close_tab']['handler_js']) ? $args['close_tab']['handler_js'] : '';
			$closebtn = new Core00Toolbar(array(
				'type'		=> 'close_tab',
				'title'		=> 'Κλείσιμο',
				'etitle'	=> 'Close',
				'module'	=> $this->module,
				'_d'		=> $this->_d,
				'iconcls'	=> 'icon-close',
				'icon_only'	=> 0,
				'handler_js' => $handler_js,
				'icon'		=> '',
				'pos'		=> 'bottom'
			));
			$closebtn->create();
		}
	}
	private function recreateTable()
	{
		if (pegasus_mysql_table_exists($this->table)) {
			// [DELETE] p20
			pegasus_mysql_delete(
				'p20',
				'p01 = :p01p03 OR p03 = :p01p03',
				0,
				array('p01p03'	=> $this->table)
			);
			// [DELETE] p75
			pegasus_mysql_delete(
				'p75',
				'p01 = :p01',
				0,
				array('p01'	=> $this->table)
			);
			pegasus_mysql_drop_table($this->table);
		}
		pegasusUnSetGlobalVar('pegasus_mysql_table_exist_' . $this->table);
		pegasus_change_stracture($this->table, $this->_d, $this->module, 1, 0, 0, 0);
		// pegasus_mysql_delete(
		// 	'p95p50',
		// 	'p50 = :p50',
		// 	0,
		// 	array('p50' => $this->table)
		// );
		
		foreach ($this->profiles as $p95) {
			if(!(pegasus_mysql_printfld('p95p50', 'nr01', 'p95 = :p95 and p50 = :p50', array('p95' => $p95, 'p50' => $this->table)) > 0)){
				//Θα γίνεται insert εφόσον δεν υπάρχει εγγραφή γι αυτό το προφίλ στον p95p50
				$insert = array(
					'nr01'      => pegasus_mysql_newrec('p95p50'),
					'p50'       => $this->table,
					'p95'       => $p95,
					'ins'       => 1,
					'del'       => 1,
					'chan'      => 1,
					'sh'        => 1
				);
				pegasus_mysql_insert(
					'p95p50',
					array_keys($insert),
					array_values($insert)
				);

			}
			
		}
		foreach ($this->p20 as $p20) {
			$p20['nr01'] =  pegasus_mysql_newrec('p20');
			pegasus_mysql_insert(
				'p20',
				array_keys($p20),
				array_values($p20)
			);
		}
	}
	public function addElement(Core00Element $element, $selfIndex = null)
	{
		$this->lastElementIndex += 10;
		$index = $this->lastElementIndex;
		if (isset($selfIndex)) {
			$index = $selfIndex;
		}
		$element->init(
			$this->module,
			$this->_d,
			$index
		);
		$this->elements[$this->lastElementIndex] = $element;
		return $this->lastElementIndex;
	}

	public function appendInitPHP($code)
	{
		$this->initPHP .= $code;
	}
	public function appendInsertChangePHP($code)
	{
		$this->insertChangePHP .= $code;
	}

	public function addHelp($help, $help_eng)
	{
		$this->addP52('help', array('par_val' => $help, 'epar_val' => $help_eng));
	}

	private function createp50()
	{
		$nr01 = pegasus_mysql_newrec('p50');
		$arr =  array();
		$arr['nr01'] = $nr01;
		$arr['p01'] = $this->table;
		$arr['p02'] = $this->_d;
		$arr['module'] = $this->module;
		$arr['p03'] = $this->title; //Περιγραφή
		$arr['cor006'] = 1; //Κατηγορία Πίνακα = Πίνακας εφαρμογής
		$arr['p102'] = 0; //Copy to database
		$arr['p100'] = 0; //Reports
		$arr['p101'] = 0; //New module installation
		$arr['p103'] = 0; //Copy data to module Update
		$arr['p104'] = 0; //Copy to local
		$arr['p05'] = 0; //Συμμετέχει στη διαγραφή κινήσεων
		$arr['p501'] = 0; //Διαδοχή παραλαβής PIM
		$arr['p502'] = 0; //Διαδοχή αποστολής PIM

		$arr['p44'] = $this->initPHP; //initialize
		$arr['p42'] = $this->insertChangePHP; //on insert & on change a record

		if (!empty($this->table)) {
			$arr['cor006'] = 2;
			$arr['p102'] = 1;
		}

		pegasus_mysql_insert('p50', array_keys($arr), array_values($arr));
	}

	public function deleteOldScreen()
	{
		//Πρέπει να τηρώ αυτην την σειρα γιατι η cleanCache ελέγχει αν υπάρχει το p50
		pegasus_delete_directory('../../tmp/' . $this->module . '/' . $this->_d . '/');

		
		peg002_clean_dCache($this->_d);
		if (function_exists('query_delete_Q10_d90_screen')) {
			query_delete_Q10_d90_screen($this->module, $this->_d);
		}
	}
}
