<?php

/**
 * Σε αυτό το αρχείο μαζεύω τις διάφορες custom κλάσεις που αφορούν
 * σε ειδικούς πίνακες π.χ. us0, cor000 
 */

class core00_TableTransferDelete_us0 extends core00_TableTransferDelete
{
    protected function delete()
    {
        pegasus_mysql_delete($this->table, 'p01 <> ?', 0, array($_SESSION['username']));
    }
}

class core00_TableTransferDelete_cor000 extends core00_TableTransferDelete
{
    protected function delete()
    {
        //Δεν θέλω να κάνει delete
    }
}

class core00_TableTransferInsert_us0 extends core00_TableTransferInsert
{
    protected function insert($result)
    {
        $columns = array();
        foreach ($result[0] as $column_name => $value) {
            if (pegasus_mysql_table_field_exists($this->table, $column_name)) {
                array_push($columns, $column_name);
            }
        }
        $all_columns_exist = false;
        if (is_countable($result[0]) && is_countable($result[0]) && count($result[0]) == count($columns)) {
            $all_columns_exist = true;
        }
        foreach ($result as $row) {
            if (!$all_columns_exist) {
                foreach ($row as $column_name => $value) {
                    if (in_array($column_name, $columns)) {
                        $new_record[$column_name] = $value;
                    }
                }
            } else {
                $new_record = $row;
            }

            if($new_record['p01'] == $_SESSION['username']){
                //unset($new_record['pp01']); //Γιατί δεν θέλω να χάσω το password. Δεν ξέρω αν το θέλουμε αυτό
                unset($new_record['p97']); //Γιατι δεν θέλω να χάσω το δικαίωμα
            }

            pegasus_mysql_insert($this->table, array_keys($new_record), array_values($new_record), 1, 1); 

            $this->gym00_90_insert($new_record);
        }
    }

    private function gym00_90_insert($new_record){
        if(!pegasus_mysql_table_exists('gym00_90')){
            return ;
        }
        
        $row = array();
        $row['nr01'] = pegasus_mysql_newrec('gym00_90');
        $row['p01'] = $new_record['p100'];
        $row['us0p01'] = $new_record['p01'];
        pegasus_mysql_insert('gym00_90', array_keys($row), array_values($row), 1, 1); 
    }

}

class core00_TableTransferInsert_cor000 extends core00_TableTransferInsert
{

    protected function fetch_query()
    {
        //Θέλω να ενημερώσω μόνο συγκεκριμένα πεδία 
        return
            ' SELECT 
           nr01,
           d00nr01, decimal_char, default_orderby, dt_format, 
           eng_tit_line1, eng_tit_line2, eng_tit_line3, eng_tit_line4, eng_tit_line5, eng_tit_line6, eng_tit_line7, eng_tit_line8, 
           tit_line1, tit_line2, tit_line3, tit_line4, tit_line5, tit_line6 , tit_line7 , tit_line8,
           f00p203, f00p2031, f00p2032, f00p204, f00p206, f00p207, f00p208, f00p209, from_title, f_path, 
           en_caching, hide_accordion, https_only, lektiko, log_days, max_recs, misa01_live, online_help, 
           php_max_execution_time, php_memory_limit, smtplog, thousand_char, tiny_img_class, tiny_link_class, min_nr01, max_nr01     
          FROM ' . $this->table .
            ' where nr01 = 1 ';
    }
}

class core00_TableTransferDelete_p97p96 extends core00_TableTransferDelete
{
    protected function delete()
    {
        //Θέλω να προσθέσω το δικαίωμα στην ομάδα του χρήστη να εκτελεί τον αυτοματισμό αυτό
        parent::delete();    
        $p97 = pegasus_mysql_printfld("us0", "p97", "p01 = ?", array($_SESSION['username']));
        pegasus_mysql_remake_p75($this->table);
        pegasus_mysql_insert(
            "p97p96", 
            array("en", "p96", "p97", "nr01", "remguc"), 
            array(1, "core00.transfer-all-data", $p97, pegasus_mysql_newrec("p97p96"), "@core00_TableTransferDelete_p97p96")
            , 1, 1, 0 
        );
    }
}

class core00_TableTransferInsert_p97p96 extends core00_TableTransferInsert
{
    protected function insert($result){
        //Χρειάζεται να ελέγξω αν το δικαίωμα για την εκτέλεση αυτού του αυτοματισμού έγινε overwrite
        parent::insert($result);

        $p97 = pegasus_mysql_printfld("us0", "p97", "p01 = ?", array($_SESSION['username']));
        pegasus_mysql_remake_p75($this->table);

        $nr01  = pegasus_mysql_printfld("p97p96", "nr01", " p96 = :p96 and p97 = :p97", array( "p96" => "core00.transfer-all-data", "p97" =>$p97));
        if($nr01 > 0 ){
            pegasus_mysql_update("p97p96", array("en"), array("1"), "nr01 = ? ", 0, 1, 1, array($nr01));
        }
        else{
            pegasus_mysql_insert(
                "p97p96", 
                array("en", "p96", "p97", "nr01", "remguc"), 
                array(1, "core00.transfer-all-data", $p97, pegasus_mysql_newrec("p97p96"), "@core00_TableTransferDelete_p97p96")
                , 1, 1, 0 
            );
    
        }

    }

    
}


class core00_TableTransferDelete_chaa00 extends core00_TableTransferDelete
{
    protected function delete()
    {
        //Δεν θέλω να κάνει delete
    }
}

//Μέλη
class core00_TableTransferInsert_chaa00 extends core00_TableTransferInsert
{
    protected function insert($result){

        // chaa00.p04 =  barcode
        // chaa00.p02 =  d00.nr01
        // chaa00.p01 =  a01.nr01
        // chaa00.p08 =  d00.p30

        $barcode_fld = ''; 
        switch ($_SESSION['gym00_00_d00_barcode']) {
            case 0: $barcode_fld = 'pd01'; break;
            case 1: $barcode_fld = 'pd02'; break;
            case 2: $barcode_fld = 'pd03'; break;
            case 3: $barcode_fld = 'pd04'; break;
        }

        foreach($result as $chaa00){
            $row = array();
            $row[$barcode_fld] = $chaa00['p04'];
            $row['p30']        = $chaa00['p08'];

            pegasus_mysql_update('d00' , array_keys($row), array_values($row), "nr01=:nr01" ,0,1,1,array('nr01' => $chaa00['p02']));
        }

    }    
}

class core00_TableTransferDelete_chaa01 extends core00_TableTransferDelete
{
    protected function delete()
    {
        //Δεν θέλω να κάνει delete
    }
}

//Φωτογραφίες
class core00_TableTransferInsert_chaa01 extends core00_TableTransferInsert
{
    protected function fetch_query()
    {
        return 
            'SELECT 
                chaa01.*,
                chaa00.p02 AS d00_nr01
            FROM chaa01
            LEFT JOIN chaa00 ON chaa00.nr01 = chaa01.p01
            ORDER BY chaa01.nr01 DESC LIMIT ' . $this->offset . ' , ' . $this->rec_per_page; 
    }

    protected function insert($result){
        foreach($result as $chaa01){
            $row = array();
            $row['nr01'] = pegasus_mysql_newrec('erpa70');
            $row['p04'] = $chaa01['p30']; // Φωτογραφία
            $row['p02'] = 0; //Διαδοχή
            $row['p03'] = "image/jpg"; // Επέκταση αρχείου / Να ρωτήσω αν παίρνει κάτι διαφορετικό ο chaa01 γιατί μόνο JPG βλέπω.
            $row['p100'] = "d00"; // Πίνακας Συχέτισης, εδώ d00
            $row['p101'] = $chaa01['d00_nr01']; // ΜΚ Συν/νου
            //Αν υπάρχει ήδη εγγραφή στον erpa70 για αυτό το d00_nr01
            if(pegasus_mysql_printfld('erpa70', 'nr01', 'p100=:tbl and p101=:tbl_nr01', array("tbl" => $row['p100'], "tbl_nr01" => $row['p101']))) {
                continue;
            }
            pegasus_mysql_insert('erpa70', array_keys($row), array_values($row), 1);
        }
    }
}

class core00_TableTransferDelete_chaa61 extends core00_TableTransferDelete
{
    protected function delete()
    {
        //Δεν θέλω να κάνει delete
    }
}

//Αίθουσες εξυπηρέτησης
class core00_TableTransferInsert_chaa61 extends core00_TableTransferInsert
{
    protected function insert($result){

        foreach($result as $chaa61){
            $row = array();
            $row['nr01'] = $chaa61['nr01'];
            $row['p01'] = $chaa61['p02']; //Περιγραφή
            //TODO: Αγγλική περιγραφή
            $row['remguc'] = $chaa61['p01']; //Ο κωδικός της αίθουσας

            pegasus_mysql_insert('gym00_88', array_keys($row), array_values($row), 1);

        }

    }    
}


//Καταστάσεις παρουσιών
class core00_TableTransferDelete_chaa74 extends core00_TableTransferDelete
{
    protected function delete()
    {
        //Δεν θέλω να κάνει delete
    }
}

//Καταστάσεις παρουσιών
class core00_TableTransferInsert_chaa74 extends core00_TableTransferInsert
{
    protected function insert($result){

        foreach($result as $chaa74){
            $row = array();
            $row['nr01'] = $chaa74['nr01'];
            $row['p01'] = $chaa74['p02']; //Περιγραφή

            switch ($chaa74['p03']) {
                case '1':
                    $row['p02'] = $chaa74['p03']; //Εκκρεμεί 
                    break;
                case '2':
                    $row['p02'] = $chaa74['p03']; //Εκτελέστηκε
                    break;               
                default:
                $row['p02'] = 4; //Ακύρωση
                    break;
            }


            //TODO: Αγγλική περιγραφή
            $row['remguc'] = $chaa74['p01']; //Ο κωδικός της κατάστασης

            pegasus_mysql_insert('gym00_86', array_keys($row), array_values($row), 1);

        }

    }    
}

class core00_TableTransferDelete_chaa80 extends core00_TableTransferDelete
{
    protected function delete()
    {
        pegasus_mysql_delete('gym00_87', 'nr01>=0');
    }
}

class core00_TableTransferInsert_chaa80 extends core00_TableTransferInsert
{
    protected function fetch_query()
    {
        //chaa60: Κατηγορίες μονάδων κατανάλωσης
        return ' SELECT 

                    chaa80.nr01 as chaa80_nr01,            
                    chaa80.p01 as chaa80_p01, 
                    chaa80.p02 as chaa80_p02,
                    
                    chaa60.nr01 as chaa60_nr01,
                    chaa60.p01 as chaa60_p01, 
                    chaa60.p02 as chaa60_p02, 

                    chaa02.p107 as chaa02_p107,
                    chaa02.p1070 as chaa02_p1070

                    FROM chaa02 
                    LEFT JOIN chaa80 on chaa80.p01 = chaa02.p133
                    LEFT JOIN chaa60 on chaa60.p01 = chaa02.p108

                    ORDER BY chaa02.nr01 DESC LIMIT ' . $this->offset . ' , ' . $this->rec_per_page;
    }

    protected function insert($result){
        
        /**
         * chaa80: Κατηγορίες Υπηρεσιών - gym00_87: Κατηγορίες μονάδων
         * chaa80.p01 : Κωδικός
         * chaa80.p02 : Περιγραφή
         */
        
        foreach($result as $chaa80_60){

            //Ελέγχω το nr01 γιατι μπορεί ο κωδικός να ειναι 0
            $code = empty($chaa80_60['chaa80_nr01'])?"*":$chaa80_60['chaa80_p01'];
            $code .= '-' ;
            $code .= empty($chaa80_60['chaa60_nr01'])?"*":$chaa80_60['chaa60_p01'];

            $perigrafi = empty($chaa80_60['chaa80_p02'])?"":$chaa80_60['chaa80_p02'] ;
            $perigrafi .= empty($perigrafi)?'':'-';
            $perigrafi .=  empty($chaa80_60['chaa60_p02'])?"":$chaa80_60['chaa60_p02'];

            $gym00_87['nr01'] = pegasus_mysql_newrec('gym00_87');
            $gym00_87['remguc'] =   $code;
            $gym00_87['p01'] =  $perigrafi;

            $gym00_87['type']  = "1"; //Επισκέψεις
            if(round($chaa80_60['chaa02_p107']) > 0 || round($chaa80_60['chaa02_p1070'] > 0)){
                $gym00_87['type']  = "0"; //Μονάδες
            }

            if(pegasus_mysql_printfld(
                'gym00_87', 
                'nr01', 
                'remguc = :code and type = :type', 
                array('code' =>$code, 'type' => $gym00_87['type'])
                ) > 0
                ){
                    continue;
            }
            pegasus_mysql_insert('gym00_87', array_keys($gym00_87), array_values($gym00_87), $this->only_append);
        }
        
    }
}

class core00_TableTransferDelete_chaa02 extends core00_TableTransferDelete
{
    protected function delete()
    {
        pegasus_mysql_delete('gym00_82', 'nr01>=0');
        pegasus_mysql_delete('gym00_81', 'nr01>=0');
        pegasus_mysql_delete('gym00_80', 'nr01>=0');
    }
}

class core00_TableTransferInsert_chaa02 extends core00_TableTransferInsert
{
    protected function insert($result){
        
        /**
         * chaa02.p01: κωδικός - είναι και ο κωδικός είδους αποθήκης 
         *              Κάθε υπηρεσία καταχωρεί και το είδος της στην αποθήκη για το παλιο champion
         * chaa02.p101: είναι ενεργή
         * chaa02.p102: αίθουσες στις οποίες εξυπηρετείται
         * chaa02.p103/p104: διαρκεια μηνες/μερες
         * chaa02.p106: επισκέψεις (πλήθος)
         * chaa02.p114: χρόνος πλάνου (λεπτά)
         * chaa02.p128: περιγραφή πλάνου παροχών
         */
        
        foreach($result as $chaa02){
            $this->insert_from_chaa02($chaa02);
        }
        
    }


    /**
     * Καταχώρηση Συνδρομής
     * @param mixed $chaa02 
     * @return void 
     */
    private function insert_from_chaa02($chaa02){
        
        //Μεταφέρουμε μόνο υπηρεσίες για τις οποίες υπάρχει είδος αποθήκης
        if(empty($chaa02['p01']) || empty(pegasus_mysql_printfld('i00', 'nr01', 'pno=?', array($chaa02['p01'])))){
            return;
        }

        $has_episkepseis =  ($chaa02['p106'] > 0) ? true : false; 
        $has_monades =  false; 
        $paketo_prosthikis = 0;
        if($chaa02['p1070'] > 0){
            $has_monades =  true;  
            $chaa02['p1070'] = round($chaa02['p1070']); //Δεν εχουμε δεκαδικά εμείς
        }

        $perigrafi_chaa02 = $this->find_perigrafi_chaa02($chaa02);
        
        if($has_episkepseis || $has_monades ){
            $paketo_prosthikis = $this->insert_gym00_81_prosthikis_from_chaa02($chaa02); //
            $paketo_katanalosis = $this->insert_gym00_81_katanalosis_from_chaa02($chaa02);
            $this->insert_gym00_82_from_chaa02($chaa02, $paketo_katanalosis); //Καταχώρηση RV    
        }
       

        $is_syndromi = ( $chaa02['p103'] == 0 && $chaa02['p104'] == 0 ) ? false : true; //Διαάρκεια Μήνες - Μέρες
        $is_syndromi = ( $chaa02['p109'] == 0 ) ? false : $is_syndromi ; 

        if($is_syndromi){
            $gym00_80 = array(); //Συνδρομή
            $gym00_80['nr01'] = pegasus_mysql_newrec('gym00_80');
            $gym00_80['p01'] =  $perigrafi_chaa02;
            $gym00_80['p02'] =  $chaa02['p103'];
            $gym00_80['p03'] =  $chaa02['p104'];
            $gym00_80['remguc'] =  $chaa02['p01'];

            if( $paketo_prosthikis > 0 ){   
                $gym00_80['m_gym00_81'] =  '#'.$paketo_prosthikis.'#';
            }
            else{
                //Εάν δεν έχει επισκέψεις τότε το είδος τιμολογείται από τη συνδρομή και όχι από το πακέτο κατανάλωσης
                $gym00_80['i00pno'] = $chaa02['p01'];
            }
            pegasus_mysql_insert('gym00_80', array_keys($gym00_80), array_values($gym00_80), $this->only_append);
        }

        
    }

    private function find_chaa02_category($chaa02){

        if(empty($chaa02['p133']) && empty($chaa02['p108'])){
            return "";
        }
        $code = empty($chaa02['p133'])?"*":$chaa02['p133'];
        $code .= '-' ;
        $code .= empty($chaa02['p108'])?"*":$chaa02['p108'];
        return $code;
    }

    private function insert_gym00_82_from_chaa02($chaa02, $paketo_katanalosis){
        $chaa02_category = $this->find_chaa02_category($chaa02);
        if(!empty($chaa02_category)){
            pegasus_mysql_use("select * from gym00_87 where remguc=?", $gym00_87_katigorias, array($chaa02_category));
            $perigrafi_rantevou =  $gym00_87_katigorias['p01']; 
        }
        else{
            $perigrafi_rantevou = $chaa02['p128'] . (empty($chaa02['p128'])? "" : " | ") .pegasus_mysql_printfld('i00', 'name', 'pno=?', array($chaa02['p01']));
        }
        $katigoria_monadon = pegasus_mysql_printfld("gym00_81", "gym00_87", "nr01=?", array($paketo_katanalosis));
        $type = pegasus_mysql_printfld("gym00_87", "type", "nr01=?", array( $katigoria_monadon));
        $this->insert_gym00_82('#'.$paketo_katanalosis."#", $type, $chaa02['p114'], $perigrafi_rantevou); 
    }


    private function insert_gym00_81_katanalosis_from_chaa02($chaa02){
        $perigrafi_chaa02 = $this->find_perigrafi_chaa02($chaa02);
        $chaa02_category = $this->find_chaa02_category($chaa02);

        $chaa02['p107'] = round($chaa02['p107']);
        $has_monades =  ($chaa02['p107'] > 0) ? true : false; 
        $has_episkepseis =  ($chaa02['p106'] > 0) ? true : false; 

        if(!$has_episkepseis && !$has_monades){
            return 0;
        }

        if($has_monades){
            //Στις μονάδες δεν έχω την λογική να φτιάχνω πάντα ένα πακέτο κατανάλωσης μίας(1) μονάδας. 
            //Τα πακέτα κατανάλωσης για μονάδες θα φτιαχτούν μόνο αν υπάρχουν υπηρεσίες κατανάλωσης μονάδων στο παλιό champion
            //Αλλιώς, δεν θα έπαιζε ούτε στο champion ... 
            $plithos = $chaa02['p107'];
            if(!empty($chaa02_category)){
                pegasus_mysql_use("select * from gym00_87 where remguc=?", $gym00_87_katigorias, array($chaa02_category));
                $katigoria_monadwn = $gym00_87_katigorias['nr01'];
            }
            else{
                $katigoria_monadwn = $this->find_or_insert_default_gym00_87('Μονάδες', 0);
            }
            
            $perigrafi_katanalosis = $plithos. ' Μονάδες (' . $perigrafi_chaa02 .')';
        }
        else if($has_episkepseis){
            $plithos = 1;
            if(!empty($chaa02_category)){
                pegasus_mysql_use("select * from gym00_87 where remguc=?", $gym00_87_katigorias, array($chaa02_category));
                $katigoria_monadwn = $gym00_87_katigorias['nr01'];
                $perigrafi_katanalosis = $plithos. $gym00_87_katigorias['p01'];
                
            }
            else{
                $katigoria_monadwn = $this->find_or_insert_default_gym00_87('Επισκέψεις', 1);
                $perigrafi_katanalosis = $plithos." Επίσκεψη ";
                $perigrafi_katanalosis .= '(' . $perigrafi_chaa02 .')';
               
            }

        }
        

        $paketo_katanalosis =  $this->insert_gym00_81_katanalosis(
                                    "-".$perigrafi_katanalosis, 
                                    $katigoria_monadwn,
                                    $plithos, 
                                    $chaa02['p01']
                                );
          
        return $paketo_katanalosis;                        
    }

    private function insert_gym00_81_prosthikis_from_chaa02($chaa02){

        if( empty($chaa02['p106']) && empty($chaa02['p1070'])){
            return 0;
        }
        $chaa02['p106'] = round($chaa02['p106']);
        $chaa02['p1070'] = round($chaa02['p1070']);

        $perigrafi_chaa02 = $this->find_perigrafi_chaa02($chaa02);
        $has_monades =  ($chaa02['p1070'] > 0 ) ? true : false; 
        $has_episkepseis =  ($chaa02['p106'] > 0) ? true : false; 
        
        $chaa02_category = $this->find_chaa02_category($chaa02);

        if($has_monades){
            $plithos = $chaa02['p1070'];
            if(!empty($chaa02_category)){
                pegasus_mysql_use("select * from gym00_87 where remguc=?", $gym00_87_katigorias, array($chaa02_category));
                $katigoria_monadwn = $gym00_87_katigorias['nr01'];
            }
            else{
                $katigoria_monadwn = $this->find_or_insert_default_gym00_87('Μονάδες', 0);
            }

            if($plithos == 1){
                $perigrafi_prosthikis = "1 Μονάδα ";
            }
            else{
                $perigrafi_prosthikis = $plithos. " Μονάδες ";
            }
            $perigrafi_prosthikis .= ' (' . $perigrafi_chaa02 .')';
        }
        else if($has_episkepseis){
            $plithos = $chaa02['p106'];
            if(!empty($chaa02_category)){
                pegasus_mysql_use("select * from gym00_87 where remguc=?", $gym00_87_katigorias, array($chaa02_category));
                $katigoria_monadwn = $gym00_87_katigorias['nr01'];
                $perigrafi_prosthikis = $plithos. '(' .$gym00_87_katigorias['p01'].')';
                
            }
            else{
                $katigoria_monadwn = $this->find_or_insert_default_gym00_87('Επισκέψεις', 1);
                if($plithos == 1){
                    $perigrafi_prosthikis = "1 Επίσκεψη ";
                }
                else{
                    $perigrafi_prosthikis = $plithos. " Επισκέψεις ";
                }
                $perigrafi_prosthikis .= '(' . $perigrafi_chaa02 .')';
               
            }

        }

        $paketo_prosthikis = $this->insert_gym00_81_prosthikis(
            $plithos, 
            $chaa02['p01'], 
            "+".$perigrafi_prosthikis, 
            $katigoria_monadwn, 
            $chaa02['p01']
        );

        return $paketo_prosthikis;
    }

    private function find_perigrafi_chaa02($chaa02){
        
        $perigrafi_chaa02 = pegasus_mysql_printfld('i00', 'name', 'pno=?', array($chaa02['p01']));
        if(empty($perigrafi_chaa02)){
            $perigrafi_chaa02 = $chaa02['p01'];
        }
        return $perigrafi_chaa02;
    }
    /**
     * Εύρεση η Προσθήκη Κατηγορίας Μονάδων για τις επισκέψεις. 
     * Έχω τη λογική ότι όλες οι μονάδες που αφορούν σε επισκέψεις θα έχουν κοινή κατηγορία
     * @param string $chaa02_133 
     * @return int 
     */
    private function find_or_insert_default_gym00_87($perigrafi, $gym00_87_type){

        $gym00_87 = pegasus_mysql_printfld('gym00_87', 'nr01', 'p01=?', array($perigrafi));
        if(empty($gym00_87)){
            $gym00_87 = array();
            $gym00_87['nr01'] = pegasus_mysql_newrec('gym00_87');
            $gym00_87['p01']  = $perigrafi;
            $gym00_87['type'] = $gym00_87_type;
           
            pegasus_mysql_insert('gym00_87', array_keys($gym00_87), array_values($gym00_87));
            return $gym00_87['nr01'];
        }
        return $gym00_87;
    }

    /**
     * Καταχώρηση πακέτου προσθήκης για επισκέψεις
     * @param mixed $plithos 
     * @param mixed $i00pno 
     * @return void 
     */
    private function insert_gym00_81_prosthikis($plithos, $i00pno, $perigrafi, $katigoria_monadwn, $chaa02_code){
        //40 Επισκέψεις Ιατρικές Υπηρεσίες θεραπευτικής άσκη

        $gym00_81 = array();
        $gym00_81['nr01'] = pegasus_mysql_newrec('gym00_81');
        $gym00_81['p01']  = $perigrafi;
        $gym00_81['i00pno']  = $i00pno;
        $gym00_81['points']  = $plithos;
        $gym00_81['gym00_87'] = $katigoria_monadwn;
        $gym00_81['remguc'] =  $chaa02_code;
        pegasus_mysql_insert('gym00_81', array_keys($gym00_81), array_values($gym00_81));
        return $gym00_81['nr01'];
    }

    /**
     * Καταχώρηση πακέτου κατανάλωσης για την μία επίσκεψη 
     * @param mixed $i00pno 
     * @return mixed 
     */
    private function insert_gym00_81_katanalosis($perigrafi, $katigoria_monadwn, $plithos, $chaa02_code){
        
        $gym00_81 = pegasus_mysql_printfld('gym00_81', 'nr01', 'p01=?', array($perigrafi));
        if(  $gym00_81 > 0 ){
            $remguc = pegasus_mysql_printfld('gym00_81', 'remguc', 'p01=?', array($perigrafi));
            pegasus_mysql_update(
                'gym00_81', 
                array('remguc'), 
                array($remguc . $chaa02_code . "#"), 
                'nr01=?', 
                0, 1, 1, 
                array($gym00_81)
            );
            return $gym00_81;
        }
        
        $gym00_81 = array();
        $gym00_81['nr01'] = pegasus_mysql_newrec('gym00_81');
        $gym00_81['p01']  = $perigrafi;
        $gym00_81['points']  = -1*($plithos);        
        $gym00_81['gym00_87'] = $katigoria_monadwn;
        $gym00_81['remguc'] =  "#" .$chaa02_code . "#";
        pegasus_mysql_insert('gym00_81', array_keys($gym00_81), array_values($gym00_81));
        return $gym00_81['nr01'];
    }

    /**
     * Καταχώρηση τύπου ραντεβού
     * @param mixed $i00pno 
     * @param mixed $m_gym00_81 
     * @param mixed $duration 
     * @param int $max_per 
     * @return void 
     */
    private function insert_gym00_82($m_gym00_81, $gym00_87_type, $duration, $perigrafi, $max_per = 1){

        $perigrafi_rantevou = $perigrafi;
        $perigrafi_rantevou .= empty($duration) ? "" :" (".$duration."')"; 
        $gym00_82 = pegasus_mysql_printfld('gym00_82', 'nr01', 'p01=?', array($perigrafi_rantevou));
        if(  $gym00_82 > 0 ){
            return $gym00_82;
        }

        $gym00_82 = array();
        $gym00_82['nr01'] = pegasus_mysql_newrec('gym00_82');
        $gym00_82['p01']  = $perigrafi_rantevou;
        $gym00_82['m_gym00_81']  = $m_gym00_81;
        $gym00_82['duration'] = $duration;
        $gym00_82['max_per'] = $max_per;
        $gym00_82['gym00_87_type'] = $gym00_87_type;
        pegasus_mysql_insert('gym00_82', array_keys($gym00_82), array_values($gym00_82));
        return $gym00_82['nr01'];
    }
}

class core00_TableTransferDelete_chaa20 extends core00_TableTransferDelete
{
    protected function delete()
    {
        //Δεν θελω να διαγραψει τιποτα γιατι τους τυπους rv τους έχει ήδη διαγραψει το chaa02
    }
}


/**
 * Ομαδικά μαθηματα σε Τυπους rv 
 * @package 
 */
class core00_TableTransferInsert_chaa20 extends core00_TableTransferInsert
{
    protected function insert($result){

        /**
         * chaa20.p03 = gym00_82.p02//όταν ειναι ανοικτό
         * chaa20.p04 = gym00_82.p03//όταν ειναι κλειστό
         * chaa20.p01 = gym00_82.p01//περιγραφή 
         * chaa20.p02 = gym00_82.m_gym00_81//υπηρεσίες - πακετα καταναλωσης  
         */
        foreach($result as $chaa20){
            $row = array();
            $row['nr01'] = pegasus_mysql_newrec('gym00_82');
            $row['p02'] = $chaa20['p03'];
            $row['p03'] = $chaa20['p04'];
            $row['p01'] = $chaa20['p01'];
            
            $type = 0;
            $value_array = explode( "#", trim($chaa20['p02']));
            $row['m_gym00_81'] = "#";
            foreach ($value_array as $value) {
                if(empty($value)){
                    continue;
                }
                $paketo_katanalosis = pegasus_mysql_printfld("gym00_81", "nr01", "remguc like ? and points < 0", array( "#".$value."#" ));
                $row['m_gym00_81'] .=  $paketo_katanalosis . "#";
                
                $katigoria_monadon = pegasus_mysql_printfld("gym00_81", "gym00_87", "nr01=?", array($paketo_katanalosis));
                $type = pegasus_mysql_printfld("gym00_87", "type", "nr01=?", array( $katigoria_monadon));
                
            }

            //Παίρνω έναν από τους τυπους των πακέτων
            $row['gym00_87_type'] = $type;

            pegasus_mysql_insert('gym00_82', array_keys($row), array_values($row), 1);

        }

    }    
}



class core00_TableTransferDelete_chaa03 extends core00_TableTransferDelete
{
    protected function delete()
    {
        pegasus_mysql_delete('gym00_01', 'nr01>=0');
        pegasus_mysql_delete('gym00_02', 'nr01>=0');
    }
}


class core00_TableTransferInsert_chaa03 extends core00_TableTransferInsert
{
    protected function fetch_query()
    {
        //die(peg_read_file("../core00_p92_libs/sql/chaa03.sql"). ' limit ' .$this->offset . ' , ' . $this->rec_per_page);
        //echo peg_read_file("../core00_p92_libs/sql/chaa03.sql"). ' limit ' .$this->offset . ' , ' . $this->rec_per_page;
        return peg_read_file("../core00_p92_libs/sql/chaa03.sql"). ' limit ' .$this->offset . ' , ' . $this->rec_per_page;
    }

    protected function insert($result){
        $file_debug = "../../tmp/core00_TableTransferInsert_chaa03.txt";
        // peg_write_file($file_debug, "Starting core00_TableTransferInsert_chaa03\n" . "Query was: \n". $this->fetch_query()); 
        // $tt = peg_read_file("../../tmp/core00_TableTransferInsert_chaa03.txt");

        $tt =  "Query was: \n". $this->fetch_query();
        foreach($result as $ypoloipa_melwn){
            
            
            //Αρχικοποίηση του είδους ως υπηρεσίας
            if( ($i00nr01 = pegasus_mysql_printfld("i00", "nr01", "pno=?", array($ypoloipa_melwn['chaa03_p02']))) >0){
                //$tt .= "\n". "1. Το i00nr01 είναι  " .$i00nr01 ."\n";
                $i00 = array();
                $i00['ths']=$_SESSION['inventory01_00_i00ths'];
                $i00['p62']=$_SESSION['inventory01_00_i00p62'];
                $i00['p202'] = $_SESSION['inventory01_00_fi00p202'];
                pegasus_mysql_update("i00", array_keys($i00), array_values($i00), "nr01=?", 0, 1, 1, array($i00nr01));
            }

            if(empty($ypoloipa_melwn['chaa00_p02'])){
                //Αν είναι κενός ο συναλλασσόμενος
                $tt .= "\n". "2. Empty ypoloipa_melwn['chaa00_p02'] " .$ypoloipa_melwn['chaa00_p02'] ."\n";
                peg_write_file($file_debug,$tt); 
                continue;
            }
            // var_dump($ypoloipa_melwn);
            // die();
            $gym01_nr01 = 0;
            if($ypoloipa_melwn['chaa02_p109'] == 1){ //Είναι συνδρομή
                //$tt .= "\n". "3. Είναι συνδρομή : ". $ypoloipa_melwn['chaa00_p02'] ."\n";
                $gym01_nr01 = $this->insert_gym00_01($ypoloipa_melwn);
            }
            
            /**
             * Μπορώ να είμαι συνδρομή και να έχω και επισκέψεις. 
             * Είτε έχω επισκέψεις είτε έχω μονάδες. 
             */
            if($ypoloipa_melwn['ypoloipo_monadwn'] >0){
                //$tt .= "\n". "4. Έχει υπόλοιπο μονάδων ". $ypoloipa_melwn['chaa00_p02'] ."\n";
                $this->insert_gym00_02($ypoloipa_melwn);
            }
            else if(
                ($ypoloipa_melwn['ypoloipo_episkepseon'] >0 || $ypoloipa_melwn['aperioristes_episkepseis'] > 0) &&
                ($ypoloipa_melwn['enarksi_ypiresias_melous'] <= date('Y-m-d') &&  date('Y-m-d') <= $ypoloipa_melwn['liksi_ypiresias_melous'])
            ){
                //$tt .= "\n". "5. Έχει επισκέψεις ". $ypoloipa_melwn['chaa00_p02'] ."\n";
                //Θα περάσω μόνο τις υπηρεσίες που μπορούν να καταναλωθούν από ομαδικό μάθημα
                //Αυτο το κάνω γιατι έτσι παίζει η καταχώρηση παρουσίας σε ομαδικό από το site
                //$peg_where  = " && locate( concat('#', chaa02.p01 , '#'), :chaa20_p02)>0

                //βρίσκω το πακέτο κατανάλωσης που προήλθε από την υπηρεσία αυτή 
                $paketo_katanalosis = pegasus_mysql_printfld("gym00_81", "nr01", "remguc like ? and points < 0", array("#".$ypoloipa_melwn['chaa02_p01']."#" ));
                if(empty($paketo_katanalosis)){ //Δεν φτιάχνεται πακέτο κατανάλωσης για μια υπηρεσία αν δεν έχει ούτε μονάδες ούτε επισκέψεις
                    $tt .= "\n". "5.1. Δεν έχει πακέτο μονάδων paketo_katanalosis\n";
                    peg_write_file($file_debug,$tt); 
                    continue;
                }
                $pp = '%'.$paketo_katanalosis.'%';
                $gym00_82_nr01 = pegasus_mysql_printfld('gym00_82', 'nr01', 'm_gym00_81 like :pak', array('pak' => $pp));
                if(empty($gym00_82_nr01)){
                    $tt .= "\n". "5.1. Δεν έχει πακέτο μονάδων gym00_82_nr01\n";
                    peg_write_file($file_debug,$tt); 
                    continue;
                }

                //Βρίσκω την κατηγορία μονάδων από το πακέτο κατανάλωσης
                $katigoria_monadwn = pegasus_mysql_printfld('gym00_81', 'gym00_87', 'nr01=?', array($paketo_katanalosis));
                
                //βρίσκω το πακέτο προσθηκης που προήλθε από την υπηρεσία αυτή 
                $paketo_prosthikis = pegasus_mysql_printfld("gym00_81", "nr01", "remguc like ? and points > 0", array("#".$ypoloipa_melwn['chaa02_p01']."#" ));
                
                if(empty($paketo_prosthikis)){
                    //Βρίσκω ένα πακέτο της κατηγορίας αυτής 
                    $paketo_prosthikis = pegasus_mysql_printfld("gym00_81", "nr01", "gym00_87 =? and points > 0", array($katigoria_monadwn));
                }

                $gym00_02 = array();
                $d00_nr01 = $ypoloipa_melwn['chaa00_p02'];
                $gym00_02['nr01'] = pegasus_mysql_newrec("gym00_02");
                $gym00_02['gym00_81'] = $paketo_prosthikis;
                $gym00_02['gym00_87'] = $katigoria_monadwn;
                $gym00_02['gym00_01'] = empty($gym01_nr01) ? $this->find_or_create_sub_of_d00($d00_nr01) : $gym01_nr01;
                $gym00_02['points'] = empty($ypoloipa_melwn['ypoloipo_episkepseon']) ? 9999: $ypoloipa_melwn['ypoloipo_episkepseon'];

                pegasus_mysql_insert('gym00_02', array_keys($gym00_02), array_values($gym00_02), $this->only_append);
                //die($ypoloipa_melwn['chaa02_p01']);
                //$tt .= "\n". "5. ΜΚ ΚΙΝΗΣΗΣ ".  $gym00_02['nr01'] ."\n";
            }

            
        }
        peg_write_file($file_debug,$tt); 
        
    }

    private function insert_gym00_01($ypoloipa_melwn){
        $d00_nr01 = $ypoloipa_melwn['chaa00_p02'];
        //Τύπος συνδρομης $gym00_80['remguc'] =  $chaa02['p01'];
        pegasus_mysql_use("select * from gym00_80 where remguc = ? ", $gym00_80, array($ypoloipa_melwn['chaa02_p01']));
        if(empty($gym00_80['nr01'])){
            $lektiko = str_replace("##chaa02_p01##", $ypoloipa_melwn['chaa02_p01'], $_SESSION['peg_dic_gym00_no_gym00_80']);
            die($lektiko);
        }

        $gym00_01 = array();
        $gym00_01['nr01'] = pegasus_mysql_newrec("gym00_01");
        $gym00_01['gym00_80'] = $gym00_80['nr01'];
        $gym00_01['d00'] = $d00_nr01;
        $gym00_01['stdt'] = $ypoloipa_melwn['enarksi_ypiresias_melous'];
        $gym00_01['endt'] =  $ypoloipa_melwn['liksi_ypiresias_melous'];
        $gym00_01['endt_1'] =  $ypoloipa_melwn['liksi_ypiresias_melous'];
        $gym00_01['p01'] =  $gym00_80['p01'] . ' '.peg_dateToStr($gym00_01['stdt'], 'd/m/Y').' - '. peg_dateToStr($gym00_01['endt_1'], 'd/m/Y');

        
        $gym00_01['p12'] = 1;   // Συνδρομή από μεταφορά
        $gym00_01['p13'] = $ypoloipa_melwn['yphresia_melous_me_ypoloipo_episkepseon']; 

        pegasus_mysql_insert('gym00_01', array_keys($gym00_01), array_values($gym00_01));

        return $gym00_01['nr01'];
    }

    private function insert_gym00_02($ypoloipa_melwn){
    
        $chaa60_p01 = $ypoloipa_melwn['chaa60_p01'];
        $paketo_prosthikis_nr01 = 0;
        $katigoria_monadwn = 0;

        if($chaa60_p01 >= 0){
            $code = "%-".$chaa60_p01;            
            $gym00_87 = pegasus_mysql_printfld('gym00_87', 'nr01', 'remguc like :code and type = 0',  //Η μεταφορά μονάδων στο παλιο gym μπορει να χει ό,τι τύπο μοναδων θελει
                array('code' =>$code));
            $katigoria_monadwn = $gym00_87;
        }

        if(empty($katigoria_monadwn)){
            $gym00_87 = array();
            $perigrafi = 'Γενική κατηγορία Μονάδων';
            $katigoria_monadwn = pegasus_mysql_printfld('gym00_87', 'nr01', 'p01=? and type = 0', array($perigrafi));
            if(empty($katigoria_monadwn)){
                $gym00_87['nr01'] = pegasus_mysql_newrec('gym00_87');
                $gym00_87['p01'] =  $perigrafi;
                $gym00_87['type']  = "0"; //Μονάδες
                $gym00_87['remguc'] =  '----';
                $katigoria_monadwn = $gym00_87['nr01'];
                pegasus_mysql_insert('gym00_87', array_keys($gym00_87), array_values($gym00_87));
            }
        }

        pegasus_mysql_use( "select * from gym00_81 where gym00_87 = ? and points > 0 ", $paketo_prosthikis, array($katigoria_monadwn));
        $paketo_prosthikis_nr01 = $paketo_prosthikis['nr01'];

        if(empty($paketo_prosthikis_nr01)){
            
            $gym00_81 = array();
            $perigrafi = '+ 1 μονάδα για '. pegasus_mysql_printfld('gym00_87', 'p01', 'nr01 = ?', array($katigoria_monadwn));
            $gym00_81['nr01'] = pegasus_mysql_newrec('gym00_81');
            $gym00_81['p01']  = $perigrafi;
            $gym00_81['i00pno']  = '';
            $gym00_81['points']  = '1';
            $gym00_81['gym00_87'] = $katigoria_monadwn;
            $gym00_81['remguc'] =  '----';
            pegasus_mysql_insert('gym00_81', array_keys($gym00_81), array_values($gym00_81));
            $paketo_prosthikis_nr01 = $gym00_81['nr01'];

        }
        $d00_nr01 = $ypoloipa_melwn['chaa00_p02'];

        $gym00_02 = array();
        $gym00_02['nr01'] = pegasus_mysql_newrec("gym00_02");
        $gym00_02['gym00_81'] = $paketo_prosthikis_nr01;
        $gym00_02['gym00_87'] = $katigoria_monadwn;
        $gym00_02['gym00_01'] = $this->find_or_create_sub_of_d00($d00_nr01);
        $gym00_02['points'] = $ypoloipa_melwn['ypoloipo_monadwn'];

        pegasus_mysql_insert('gym00_02', array_keys($gym00_02), array_values($gym00_02));
    }
    private function find_or_create_sub_of_d00($d00_nr01){
        $query = "SELECT
                    *
                FROM
                    gym00_01
                   
                WHERE
                    gym00_01.d00 = :d00_nr01 
                    AND gym00_01.canceled = 0 
                    AND gym00_01.stdt <= curdate() 
                    AND curdate()<= gym00_01.endt ";
        pegasus_mysql_use($query, $gym00_01, array('d00_nr01' => $d00_nr01));
        
        if($gym00_01['nr01'] > 0 ){
            return $gym00_01['nr01'];
        }
        //TODO: Να gym00_01_make_default_subscription_after_save ... Να έχω ενημερώσει 
        //Αν δεν βρω ενεργή συνδρομή, φτιάχνω μία standard

        if(empty($_SESSION['gym00_00_p01'])) {
            pegasus_mysql_update('gym00_00', array('p01'), array('2'), 'nr01 = 1' );
            $_SESSION['gym00_00_p01'] = 2;
        }

        $gym00_01 = pegasus_mysql_newrec('gym00_01');
        $arr1 = array();
        $arr2 = array();
        array_push($arr1 , 'nr01');         array_push($arr2 , $gym00_01); 
        array_push($arr1 , 'p01');          array_push($arr2 , $_SESSION['peg_dic_gym00_no_subscription']); 
        array_push($arr1 , 'd00');          array_push($arr2 , $d00_nr01);
        array_push($arr1 , 'stdt');         array_push($arr2 , date('Y-m-d'));  
        array_push($arr1 , 'endt');         array_push($arr2 , '2099-12-31'); 
        pegasus_mysql_insert('gym00_01', $arr1, $arr2);

        return $gym00_01;
    }
}