<?php

class core00_p92ActionResultStatus
{
    public static $OKActionShouldBeRepeated = 1;
    public static $OKActionCompleted = 2;
    public static $ErrorP92ShouldAbort = 3;
}

//Μία εκτέλεση ενός βήματος το αυτοματισμού επιστρέφει αυστηρά απάντηση τύπου p92ActionResult
class core00_p92ActionResult
{
    private $status; //Αυστηρά τύπου core00_p92ActionResultStatus
    private $message; 
    private $log; //Είναι array
    private $next_exec_request;

    /**
     * 

     * @param mixed $status: Μία από τις επιτρεπτές τιμες της core00_p92ActionResultStatus 
     * @param string $message: Το μήνυμα που θα εμφανιστεί στο τέλος εκτέλεσης του Αυτοματισμού
     * @param array $next_exec_request: Είναι το array με όλες τις τιμές που πρέπει να περάσουν ως $_REQUEST στην επόμενη εκτέλεση του αυτοματισμού
     * @return void 
     */
    function __construct($status, $message = '', $next_exec_request = array())
    {
        $this->status = $status;
        $this->message = $message;
        $this->next_exec_request = $next_exec_request;
        $this->log = array();
    }
    /**
     * @return core00_p92ActionResultStatus 
     */
    public function get_status()
    {
        return $this->status;
    }

    public function get_message()
    {
        return $this->message;
    }

    public function get_next_exec_request()
    {
        return $this->next_exec_request;
    }

    public function add_in_next_exec_requests_params($params = array()){
        foreach ($params as $key => $value) {
            $this->next_exec_request[$key] = $value;
        }
    }

    /**
     * Add a record at the end of the logs
     * @param mixed $log 
     * @return void 
     */
    public function add_log_record($log){
        array_push($this->log, $log);
    }

    /**
     * Replace logs with input array
     * @param mixed $log 
     * @return void 
     */
    public function set_log($log){
        $this->log = $log;
    }

    public function get_log(){
        return $this->log;
    }

    public function obj_to_str()
    {
        $message = '';

        switch ($this->status) {
            case core00_p92ActionResultStatus::$ErrorP92ShouldAbort:
                $message .= "Υπήρξε πρόβλημα κατά την εκτέλεση. ". $this->message;
                break;
            case core00_p92ActionResultStatus::$OKActionCompleted:
                $message .= "Ολοκληρώθηκε η ενέργεια.". $this->message;
                break;
            case core00_p92ActionResultStatus::$OKActionShouldBeRepeated:
                $message .= "Επανάληψη Ενέργειας. ". $this->message;
                break;
            default:
                $message .= "Unknown status"; 
                break;
        }
        return $message;
    }
}

abstract class p92Action
{
    /**
     * Εκτελεί το βήμα του αυτοματισμού. Διαβάζει από το $_REQUEST και επιστρέφει ένα object p92ActionResult
     * @return core00_p92ActionResult 
     */
    abstract public function exec();

    /**
     * Η συνάρτηση αυτή γράφει στην μπάρα εκτέλεσης του αυτοματισμού
     * @param mixed $msg 
     * @return void 
     */
    protected function write_progress_bar_msg($msg)
    {
        peg_write_file('../../tmp/p92_exec.txt', $msg);
    }
    
}

class p92Exec
{

    private $step; //Έχει τιμή 1 ή 2 ανάλογα με το αν ο αυτοματισμός θα πρέπει να εμφανίσει το confirmation message ή να εκτελεστεί.
    private $p92_nr01;
    private $p92_action;
    private $log;
    /**
     * 
     * @param $p92_action Είναι object κάποιας κλάσης παιδιού που κληρονομεί από την p92Action
     * @return void 
     */
    function __construct($p92_action)
    {
        $this->step = $_REQUEST['step'];
        $this->p92_nr01 = $_REQUEST['p92_nr01'];
        $this->p92_action = $p92_action;
        $this->log = array();        
    }


    public function exec()
    {

        if (class_exists($this->p92_action)) {

            $action = $this->p92_action;
            $p92_action_object = new $action();
            $action_result = $p92_action_object->exec();
            $this->log = $action_result->get_log();

            if (!$action_result instanceof core00_p92ActionResult) {
                $this->execution_stopped_with_an_error('DebugInfo: Δεν δόθηκε σωστό response τύπου p92ActionResult από την exec');
                return;
            }

            if ($action_result->get_status() == core00_p92ActionResultStatus::$ErrorP92ShouldAbort) {
                $this->execution_stopped_with_an_error($action_result->get_message());
                return;
            } else if ($action_result->get_status() == core00_p92ActionResultStatus::$OKActionCompleted) {
                $this->execution_completed($action_result->get_message());
                return;
            } else if ($action_result->get_status() == core00_p92ActionResultStatus::$OKActionShouldBeRepeated) {
                $next_exec_request = $action_result->get_next_exec_request();
                $this->after_exec_prepare_next_step($next_exec_request);
                return;
            }

            $this->execution_stopped_with_an_error('DebugInfo: Η εκτέλεση του αυτοματισμού δεν επέστρεψε επιτρεπτό status');
        } else {
            $this->execution_stopped_with_an_error('DebugInfo: Δεν δόθηκε σωστή κλάση p92Action στην αρχικοποίηση του αυτοματισμού');
        }
    }

    public function print_log(){
        $log = '';
        foreach ($this->log as $key => $value) {
            $log .= $value . "\n";
        }
        return $log;
    }

    private function execution_completed($success_message = 'Ο Αυτοματισμός Εκτελέστηκε με Επιτυχία')
    {
        $ret = array();
        $ret['msg']       = $success_message;
        $ret['exec_next'] = 0;
        echo json_encode($ret);
    }

    private function execution_stopped_with_an_error($error_msg = 'Αδυναμία Εκτέλεσης Αυτοματισμού')
    {
        array_push($this->log, $error_msg);
        $ret = array();
        $ret['msg']       = $error_msg;
        $ret['exec_next'] = 0;
        echo json_encode($ret);
    }

    private function after_exec_prepare_next_step($next_exec_request = array())
    {

        if (isset($_REQUEST['next_exec_request'])) {
            //Αυτό το μήνυμα δεν θα πρέπει να το δει ποτέ πελάτης
            $this->execution_stopped_with_an_error("DebugInfo: Η μεταβλητή step είναι δεσμευμένη μεταβλητή στην εκτέλεση του αυτοματισμού");
            return;
        }

        $next_exec_request['p92_nr01'] = $this->p92_nr01;
        $next_exec_request['step'] = $this->step;

        foreach ($_REQUEST as $key => $value) {
            if(strpos($key, "peg_grid") !== false){
                $next_exec_request[$key] = $value;
            }
        }

        pegasusSetGlobalVar('p92_d00_go_next', $next_exec_request);
        $ret = array();
        $ret['msg']             = '';
        $ret['exec_next']       = 1;
        $ret['debug_next_exec_request']  =  $next_exec_request;
        echo json_encode($ret);
    }

}




class testActionSimpleExecution extends p92Action
{

    public function exec()
    {
        $this->write_progress_bar_msg("executed");
        return new core00_p92ActionResult(core00_p92ActionResultStatus::$OKActionCompleted, 'OLA KALA');
    }
}


class testActionIterationOfStep5Times extends p92Action
{

    private $iterator;

    function __construct()
    {
        $this->iterator = isset($_REQUEST['iterator']) ? $_REQUEST['iterator'] + 1 :  1;
    }

    public function exec()
    {
        $this->write_progress_bar_msg("executed times: " . $this->iterator);
        if ($this->iterator == 3) {
            return new core00_p92ActionResult(core00_p92ActionResultStatus::$OKActionCompleted, 'Τέλος Εκτέλεσης Αυτοματισμού');
        }
        return new core00_p92ActionResult(core00_p92ActionResultStatus::$OKActionShouldBeRepeated, '', array('iterator' => $this->iterator));
    }
}
