/*-------------------------------------------------------------------
	Ext.ux.form.TinyMCETextArea
	
  ExtJS form field - a text area with integrated TinyMCE WYSIWYG Editor
  
  Version: 1.0
  Release date: 27.03.2012
  ExtJS Version: 4.1 rc1
  TinyMCE Version: 3.5 b2
  License: LGPL v2.1 or later
	
  Author: Oleg Schildt
  E-Mail: Oleg.Schildt@gmail.com
	
	Copyright (c) 2012 Oleg Schildt
  
  Following issues are covered:

  - Initialization in an initially visible and in an initially invisible tab.
  - Correct place occupation by the initialization in any ExtJS layout.
  - Correct resizing by the resizing of the underlying text area.
  - Activation and deactivation of the WYSIWYG editor.
  - Enabling and disabling of the WYSIWYG editor control.
  - Changing of WYSIWYG settings and CSS file for the editable contents on the fly.
  - Pre-formatting of the HTML text in visible and invisible modus.
  - Focusing of the WYSIWYG editor control.
  - Marking invalid.
-------------------------------------------------------------------*/

Ext.define('Ext.ux.form.TinyMCETextArea', {

  extend: 'Ext.form.field.TextArea',
  alias: ['widget.tinymce_textarea', 'widget.tinymce_field'],
  
  //-----------------------------------------------------------------

  /*
  Flag for tracking the initialization state
  */
  wysiwygIntialized: false,
  intializationInProgress: false,
  lastWidth: 0,
  lastHeight: 0,
  
  /*
  This properties enables starting without WYSIWYG editor.
  The user can activate it later if he wants.
  */
  noWysiwyg: false,
  
  /*
  Config object for the TinyMCE configuration options
  */
  tinyMCEConfig: {},

  //-----------------------------------------------------------------
  afterRender: function(){
    var me = this;

    me.callParent(arguments);
    
    me.on('resize', function(elm, width, height, oldWidth, oldHeight, eOpts) { 
    	
   	/*pegAlert('rrrrrrrrrrrrrr');var elm = me.getEl();
	var height = this.getHeight();
	var width  = this.getWidth(); 	
	*/
    var mmm=0;
      if(me.mode=="advanced"){
      	 mmm=80;
      }
      
      if(elm.labelAlign!='top' || elm.hideLabel==true){
      	 // 5 = me to paddiing to elllemen kai to label
     	 if( elm.hideLabel==true){
      	 	me.lastWidth = width  -0;
     	 }else{
     	 	me.lastWidth = width  -5 - elm.labelWidth;
     	 }
     	 me.lastHeight = height -27 - mmm;      	
      }else{
     	 me.lastWidth = width  -0  ;
     	 me.lastHeight = height -27 - 14 - 15 - mmm;
      }
      
      
      
      if(!me.noWysiwyg && !me.wysiwygIntialized) me.initEditor();
      else me.syncEditorSize(me.lastWidth, 500);
      
      
    }, me);     
  },
  //-----------------------------------------------------------------
  getWidthCorrection: function() {
    var me = this;

    var widthCorrection = 0;
    if(Ext.isGecko) widthCorrection = -2;
    if(Ext.isOpera) widthCorrection = -2;
    if(Ext.isIE) widthCorrection = -2;
    
    return widthCorrection;
  },
  //-----------------------------------------------------------------
  syncEditorSize: function(w, h) {
    var me = this;
    
    if(!me.wysiwygIntialized || !me.rendered) return;

    var ed = tinymce.get(me.getInputId());
    
    // if the editor is hidden, we do not syncronize
    // because the size values of the hidden editor
    // are calculated wrong.
    
    if(ed.isHidden()) return;
    
    // Unfortunately, the TinyMCE has no setSize method
    // This method would help enormly and make the integration
    // very easy.
    //
    // So, we have to deal with internal issues of the editor.
    // We get the height of the tool bar and the status bar and
    // calculate the height of the content frame.
    
    var edTable = Ext.get(me.getInputId() + "_tbl");
    var edIframe = Ext.get(me.getInputId() + "_ifr");
    
    var edToolbar = edTable.down(".mceToolbar");
    var edStatusbar = edTable.down(".mceStatusbar");
    
    var frameHeight = h - 2;
    
    if(edToolbar) frameHeight -= edToolbar.getHeight();
    if(edStatusbar) frameHeight -= edStatusbar.getHeight();

    edIframe.setHeight(frameHeight);
    
    edTable.setWidth(w + me.getWidthCorrection());
    edTable.setHeight(h);
    //Ext.getCmp(me.container_id).doLayout();
  },
  //-----------------------------------------------------------------
  initEditor: function(){
    var me = this;
    
    if(me.intializationInProgress) return;
    
    me.intializationInProgress = true;
    
    if(!me.tinyMCEConfig) me.tinyMCEConfig = {};
    
    me.tinyMCEConfig.mode = "exact";
		me.tinyMCEConfig.elements = me.getInputId();

    // This type of resizing s very harmful by integration with ExtJS.
    // The editor should occupy only the place given to it by the
    // layout manager.
    me.tinyMCEConfig.theme_advanced_resizing = false;
    
    // we pass the height and width explicitly to the editor
    me.tinyMCEConfig.width = me.lastWidth +  + me.getWidthCorrection();
    me.tinyMCEConfig.height = me.lastHeight;

    me.tinyMCEConfig.setup = function(ed) {
      ed.onInit.add(function(ed) {
        me.wysiwygIntialized = true;
        me.intializationInProgress = false;
      });
    };  
			    
    tinymce.init(me.tinyMCEConfig);
  },
  //-----------------------------------------------------------------
  getEditor: function(){
    var me = this;
    
    if(!me.wysiwygIntialized)
    {
      return null;
    }
    
    return tinymce.get(me.getInputId());
  },
  //-----------------------------------------------------------------
  showEditor: function(){
    var me = this;
    
    if(!me.wysiwygIntialized)
    {
      me.initEditor();
      return;
    }
    
    var ed = tinymce.get(me.getInputId());

    ed.show();
    me.syncEditorSize(me.lastWidth, me.lastHeight);
  },
  //-----------------------------------------------------------------
  hideEditor: function(){
    var me = this;
    
    if(!me.wysiwygIntialized) return;
    
    var ed = tinymce.get(me.getInputId());
    
    var node = ed.selection.getNode();
    
    // no selection, just hide
    
    if(!node || node.nodeName == "#document" || node.nodeName == "BODY" || node.nodeName == "body")
    {
      ed.hide();
      return;
    }
    
    // otherwise try to position the cursor
    
    var marker = '<a name="_____sys__11223___"></a>';
    ed.selection.collapse(true);
    ed.execCommand('mceInsertContent', 0, marker);
    
    ed.hide();

    var ctrl = document.getElementById(me.getInputId());
    
    var pos = -1;
    var txt = "";
    
    if(ctrl) 
    {
      txt = ctrl.value;
      pos = txt.indexOf(marker);
    }
    
    if(pos != -1)
    {
      var re = new RegExp(marker, "g");
      txt = txt.replace(re, "");
      ctrl.value = txt;
      
      if(ctrl.setSelectionRange)
      {
        ctrl.focus();
        ctrl.setSelectionRange(pos, pos);
      }
    }
  },
  //-----------------------------------------------------------------
  toggleEditor: function(){
    var me = this;
    
    if(!me.wysiwygIntialized) 
    {
      me.showEditor();
      return;
    }
    
    var ed = tinymce.get(me.getInputId());
    
    if (ed.isHidden())
      me.showEditor();
    else
      me.hideEditor();
  },
  //-----------------------------------------------------------------
  // Sometimes, the editor should be reinitilized on the fly, e.g.
  // if the body css has been changed (in a CMS the user changed 
  // the design template of a page opened in the editor).
  // This method removes the editor from the textarea, adds the
  // changed properties to the base config object and initializes
  // the editor again.
  //-----------------------------------------------------------------
  reinitEditor: function(cfg){
    var me = this;
    
    if(me.intializationInProgress) return me;
    
    if(!me.tinyMCEConfig) me.tinyMCEConfig = {};
    if(!cfg) cfg = {};
    
    Ext.apply(me.tinyMCEConfig, cfg);
    
    if(!me.wysiwygIntialized) return me;
    
    var hidden = true;
    
    var ed = tinymce.get(me.getInputId());
    if(ed) 
    {
      hidden = ed.isHidden();
      ed.save();
    }
    
    tinyMCE.execCommand('mceRemoveControl', false, me.getInputId());

    me.wysiwygIntialized = false;
    
    if(!hidden) me.initEditor();
    
    return me;
  },
  //-----------------------------------------------------------------
  getValue: function() {
    var me = this;
    
    if(me.wysiwygIntialized)
    {
      // The editor does some preformatting of the HTML text
      // entered by the user. If the editor is hidden, the text is entered  
      // directly into the textarea and is not preformatted automatically. 
      // We force loading of the entered text into the editor. Later,
      // upon saving we have to call tinymce.triggerSave() to
      // force saving the final HTML text back to the textarea, because
      // the ExtJS takes the value from the textarea, not from the editor.
      
      var ed = tinymce.get(me.getInputId());
      if(ed && ed.isHidden()) ed.load();
    }
    
    return me.callParent(arguments);
  },
  //-----------------------------------------------------------------
  setValue: function(v) {
    var me = this;
    
    var res = me.callParent(arguments);
    
    if(me.wysiwygIntialized)
    {
      // The editor does some preformatting of the HTML text
      // entered by the user. 
      // The method setValue sets the value of the textarea.
      // We have to load the text into editor for the
      // preformatting and then to save it back to the textarea.
      
      var ed = tinymce.get(me.getInputId());
      if(ed) 
      {
        ed.load();
        ed.save();
      }
    }
    
    return res;    
  },
  //-----------------------------------------------------------------
  enableEditorControls: function(state) {
    var me = this;
    var ed = tinymce.get(me.getInputId());
    if(!ed) return;
    
    tinymce.each(ed.controlManager.controls, function(c) {
      c.setDisabled(!state);
    });
  },
  //-----------------------------------------------------------------
  enable: function(silent) {
    var me = this;

    if(!me.isDisabled()) return;
    
    var ed = tinymce.get(me.getInputId());
    if(ed) 
    {
      // We restore contentEditable to true
      
      var edIframe = Ext.get(me.getInputId() + "_ifr");
      edIframe.dom.contentDocument.body.contentEditable = true;
      
      // We have luck, because there is this useful internal method
      // to add all events unbound in the disable command
      ed.bindNativeEvents();
      
      me.enableEditorControls(true);
      
      // The call above enables ALL tollbar buttons
      // It is wrong. We fire this event to force adjusting 
      // of the enabled/disabled state of the buttons to the
      // actual state of the editor.
      
      ed.nodeChanged();
    }
    
    
    return me.callParent(arguments);
  },
  //-----------------------------------------------------------------
  disable: function(silent) {
    var me = this;
    
    if(me.isDisabled()) return;
    
    var ed = tinymce.get(me.getInputId());
    if(ed) 
    {
      // The body cannot be disabled,
      // So we remove events from the 
      
      tinymce.dom.Event.clear(ed.getBody());
			tinymce.dom.Event.clear(ed.getWin());
			tinymce.dom.Event.clear(ed.getDoc());
      tinymce.dom.Event.clear(ed.formElement);

      ed.onExecCommand.listeners = [];
      
      // We set the contentEditable to false
      var edIframe = Ext.get(me.getInputId() + "_ifr");
      edIframe.dom.contentDocument.body.contentEditable = false;
      
      // We disable all tool bar controls      
      me.enableEditorControls(false);
    }
    
    return me.callParent(arguments);
  },
  //-----------------------------------------------------------------
  focus: function(selectText, delay) {
    return this;
  	var me = this;
    
    if(me.isDisabled()) return me;

    
   // ��� �� ������ �� focus ................ if (delay) {
   //   me.focus.defer(delay, me, [selectText, false]);
      return me;
   // }

    if(!me.wysiwygIntialized)
    {
      return me.callParent(arguments);
    }

    var ed = tinymce.get(me.getInputId());
    
    if(ed && !ed.isHidden()) ed.focus();
    else return me.callParent(arguments);

    return me;
  },
  //-----------------------------------------------------------------
  beforeDestroy: function() {
    var me = this;
    tinyMCE.execCommand('mceRemoveControl', false, me.getInputId());
  },
  //-----------------------------------------------------------------
  renderActiveError: function() {
  
    var me = this,
        activeError = me.getActiveError(),
        hasError = !!activeError;

    var edTable = Ext.get(me.getInputId() + "_tbl");
    var edIframe = Ext.get(me.getInputId() + "_ifr");
    
    if(!edTable) return me.callParent(arguments);
    
    /*
    Adding the red border to the mceIframeContainer is the most sure
    way to do it without harming sizing and positioning.
    */    
    var edFrameContainer = edTable.down(".mceIframeContainer");
    
    if(edFrameContainer && me.rendered && !me.isDestroyed && !me.preventMark) 
    {
      var ed = tinymce.get(me.getInputId());
      
      var evHandler = function(ed, e) { me.clearInvalid(); };
      
      // Add/remove invalid class
      if(hasError)
      {
        edFrameContainer.addCls('tinymce-error-field'); 
        
        // this dirty hack is required for WebKit browsers - Safari and Chrome
        edIframe.setHeight(edIframe.getHeight()-1);
        edIframe.setHeight(edIframe.getHeight()+1);
        
        if(ed) 
        {
          // the invalid mark should be removed after any 
          // change of the contents (ExtJS standard behaviour)
          ed.onKeyDown.add(evHandler);
          ed.onChange.add(evHandler);
        }  
      }
      else
      {
        edFrameContainer.removeCls('tinymce-error-field'); 

        // this dirty hack is required for WebKit browsers - Safari and Chrome
        edIframe.setHeight(edIframe.getHeight()-1);
        edIframe.setHeight(edIframe.getHeight()+1);
        
        if(ed) 
        {
          ed.onKeyDown.remove(evHandler);
          ed.onChange.remove(evHandler);
        }  
      }
    }

    return me.callParent(arguments);
  } 
  //-----------------------------------------------------------------
});
