/**
 * @class Functions.core.kernel
 * 
 * @member WebApp.view
 * 
 *  ##Properties
 *  
 *  The global variables of the module
 *  
 *   
 *  ##Methods
 * 
 	- General functions
 	- Ajax functions
 	- Manage  {WebApp.view.*}  functions
 	- Manage  {Ext.data.Store.*}  functionss
 	- Data functions
 *  
 *  
 *  ##2do
 *  
 *  pegGetVal
 */

//XXX Start General function
 /**
 * This function return the current framework
 * @returns {string} peg002 || core
 */
function pegGetFramework(){
	try {
		if(PEGASUS && PEGASUS.FRAMEWORK){
			return PEGASUS.FRAMEWORK;
		}		
	} catch (e) {
		// TODO: handle exception
	}

	return 'core';
}


/**
 * 
 * @param {String} dic the tag of the Dictionary
 * @param callback javascript code that will be eval. The description of the dic will be at the variable desc
 * 
 * Exmaple
 * 
 * 
 * pegGetDic('peg_dic_alert', function(desc){ pegAlert(desc); } )
 *  
 */
function pegGetDic(dic,callback ){ 
	if(pegIsEmpty(dic)){
		return '';
	}

	var desc = PEGASUS.CORE.P82.getDic(dic );

	if(desc ){ 
		if(typeof callback === 'function'){
			return callback(desc);
		} 
	}else{
		PEGASUS.CORE.P82.load({ 
			   params:{dic: dic},
			   addRecords:true,
			   callback: function(records, operation, success) {
				   if(records && records[0]){
					   desc = records[0].get('desc');
					   if(typeof callback === 'function'){
							return callback(desc);
						} 
				   }else{
					   console.error('Dic "'+dic+'" not found');
				   }
					  
			   }
		}); 
	}
	return;
}
/**
 * This method will display an alert message
 * @param dic  the tag of the Dictionary
 * @returns
 */
function pegGetDicAlert(dic){
	return pegGetDic(dic, function(desc){ if(desc){pegAlert(desc);}else{pegAlert('Dic not found'); } });
}

function pegRequireRefresh(dic){
	if(!pegIsEmpty(dic)){
        peg002_unmask();
		pegConfirmBox( 
				'', 
				dic , 
				function(but){
					if(but=='yes'){ 
						window.onbeforeunload = null;
            			window.location.reload();
					} 
				}
		);
	}else{
		location.reload(true);
	}
	
}
/**
 * Displays an {Ext.window.Window} with window help
 * @param {String} _d
 * @param {String} module
 * @param {String} mMnr01
 *  @private
 */
function pegGetHelp(_d, module, mmnr01) {
	pegAjax('/' + main_path + '/core_global/help.php?_d=' + _d + '&module=' + module + '&mmnr01=' + mmnr01, {}, function (json_data) {
		if (json_data.ok == 1) {
			var width = 750;
			var height = 500;
			if (Ext.getViewportWidth() < width) {
				width = Ext.getViewportWidth() - 10;
			}
			if (Ext.getViewportHeight() < height) {
				height = Ext.getViewportHeight() - 10;
			}
			var params = {
				title: json_data.title,
				html: json_data.message,
				bodyPadding: 20,
				layout: 'fit',
				width: width,
				height: height,
				modal: 'true',
				autoScroll: true,
                collapsible:true,
                maximizable:true
				
			};


			Ext.create('Ext.window.Window', params).show();
		} else {
			pegAlert(json_data.message);
		}
	});
}

/**
 * Displays an {Ext.window.Window} with window help
 * @param {String} _d
 * @param {String} module 
 * @private
 */
function pegGetQuickSearchHelp(_d , module ){
	pegAjax('/' +main_path + '/core_global/help_quick_find.php?_d='+_d +'&module='+ module  , {} , function(json_data){
		if(json_data.ok==1){
			var params = {
						    title:  json_data.title,
						 	html :	json_data.message,
						 	bodyPadding:20,
						    layout: 'fit' ,
						    width: 750,
						    height:500,
						    modal:'true',
						    autoScroll :true
		 
						};
			
			
			Ext.create('Ext.window.Window', params).show();			
		}else{
			pegAlert(json_data.message);
		}
	});
} 
function pegMicrotime (get_as_float) {
    // Returns either a string or a float containing the current time in seconds and microseconds  
    // 
    // version: 1109.2015
    // discuss at: http://phpjs.org/functions/microtime    // +   original by: Paulo Freitas
    // *     example 1: timeStamp = microtime(true);
    // *     results 1: timeStamp > 1000000000 && timeStamp < 2000000000
    var now = new Date().getTime() / 1000;
    var s = parseInt(now, 10); 
    return (get_as_float) ? now : (Math.round((now - s) * 1000) / 1000) + ' ' + s;
}


//XXX Start Ajax function
function pegAjaxCallBack( options, success, response ){
    if(success===false){  
        var statusCode = 0;
        var title = '';
        var msg = '';
        var url0='';
   
        if(response ){
            if(response.aborted){
                return false;
            }
            if(response.status){
                if(response.status == 401){
                    var tmpconfirmdic = '';
                    if(pegGetFramework() == 'peg002'){
                        pegGetDic(
                                'peg_dic_core_logoutandrelogin',
                                function(desc02){ tmpconfirmdic += desc02; });
                    }else{
                        tmpconfirmdic += peg_dic_core_logoutandrelogin;
                    }
                    pegRequireRefresh(tmpconfirmdic);
                    return false;
                }
                statusCode = response.status;
                msg += statusCode+': ' ;
                title = ''+response.status +': ' + title;
            }
            if(response.statusText){
                msg += response.statusText;
                if(response.timedout){
                    msg += ' - Connection Timeout';
                }
                msg += '<br/>';
            }
            if(response.request){
                if(response.request.url){
                    url0 = response.request.url;
                }else if (response.request.options && response.request.options.url) {
                    url0 = response.request.options.url;
                }
            }
        }        
        pegAjaxErrorAlert(msg, title,url0); 
        return false;
    }else{ 
        return true;        
    }
}
 
/**
 * H συνάρτηση αυτη εκτελεί ενα ajax Defer request. 
 * H μόνη διαφορά με την ajax request είναι ότι μπορούμε να περάσουμε callback σε handlers που θα εκτελεστούν μετά από την ολοκλήρωση όλων των request που έχουμε κάνει με την pegAjaxDefer.
 * 
 * 
	 Ext.ux.AjaxDefer.wrap(function () {
            console.log('but02 handler has been executed');
        });
        
        
 * 
 * To save button στα _d εκτελείται με την παραπάνω λογική " Ext.ux.AjaxDefer.wrap".
 * 
 * Στις κλήσεις της pegAjaxDefer θα πρέπει να καλύπτουμε την περίπτωση που είναι ήδη σε εξέλιξη προηγούμενη κλήση της για το ίδιο url , κάνοντας abort το προηγούμενο request ακριβώς πριν την εκτέλεσή της.
 * 
 * Παράδειγμα :
 * 
 * 
	 var my_ajax = ''; // Ορίζω μία μεταβλητή globally για το request που θα εκτελέσω και την αρχικοποιώ σε κενό
	 function myAjaxExample(url, values){
		if (my_ajax != '') {	// Ελέγχω αν έχει οριστεί η μεταβλητή μου και είναι σε εξέλιξη το ajax request
			if (my_ajax.id > 0) { 
				Ext.ux.AjaxDefer.abort(my_ajax); // Αν ισχύουν οι συνθήκες κάνω abort το request που είναι σε εξέλιξη
			}
		}
		my_ajax = pegAjaxDefer(url, values, function (jsondata) { // Καλώ την pegAjaxDefer και κρατάω την επιστρεφόμενη τιμή στην global μεταβλητή μου
			// my callback code here
		});
	 } 
        
        
 * 
 * @param {String} url  service url
 * @param {Object} params  το js object με όλες τις μεταβλητες που θα περαστουν ως post στο url
 * @param {Function} callback  το callback function  , αν θελουμε να πάρουμε και τις μεταβλητές που θα μας επιστεψει το url συμπληρώνουμε jsonData π.χ. function(jsonData){}
 * @param {String} type= 'json' o τύπος των δεδομενων που θα μας επιστέψει το URL.
 * @param {Nymber} maskenable=1 θα εμφανίσει Loading Mask στο κεντρικό παράθυρο της εφαρμογής
 * @param {Boolean} async=false για να κανει συχρόνο το request  
 * @returns
 */
function pegAjaxDefer(url , params , callback , type , maskenable  , async){


	if(maskenable=='undefined'){
		maskenable=0;
	}
	
	if(maskenable==1){
		peg002_mask()
	}
	
	if(type==undefined){
		type='json';
	}	
	
	var ajaxobj =  Ext.ux.AjaxDefer.request({
		url: url      ,
		params: params,
		timeout : 300000,
		callback: function( options, success, response ){
			if(pegAjaxCallBack( options, success, response )){
				var text = response.responseText;
				var jsonData = text;
				// process server response here
				if(type=='json' && !pegIsEmpty(text)){
					try {
						jsonData = pegJsonDecode( text );
						if(type=='json' && typeof jsonData!='object'){
							var url='';
							if(response.request){
								if(response.request.url){
									url= response.request.url;
								}else if (response.request.options && response.request.options.url) {
									url= response.request.options.url;
								}
							}
							pegAjaxErrorAlert(text, 'Invalid Response Type',url );
						} 
					} catch (e) {
						console.error('Unable to decode data');
						console.info('Try to decode string',text);
						console.dir(e);
						// TODO: handle exception
					}
				} 
				 
				if(callback && typeof(callback) === "function"){ 
					callback(jsonData);
				}	
			}

			if(maskenable==1){
				peg002_unmask()
			}
		},
		success: function(response){
			return true;      
		},
		failure: function(response){
			return true;
		}
	});

	return ajaxobj;
	
}	
/*
H συνάρτησης αυτη εκετελεί ενα ajax request. 
	
params
------
url        = service url
params     = {} , το js object με όλες τις μεταβλητες που θα περαστουν ως post στο url
callback   = το callback function  , αν θελουμε να πάρουμε και τις μεταβλητές που θα μας επιστεψει το url συμπληρώνουμε jsonData π.χ. function(jsondata){}
type       = json , o τύπος των δεδομενων που θα μας επιστέψει το URL.
maskenable = 1, θα εμφανίσει Loading Mask στο κεντρικό παράθυρο της εφαρμογής
async      = false για να κανει συχρόνο το request , by default = false 

*/
/**
 * H συνάρτησης αυτη εκετελεί ενα ajax request.  
 * 
 * @param {String} url  service url
 * @param {Object} params το js object με όλες τις μεταβλητες που θα περαστουν ως post στο url
 * @param {Funcion} callback  αν θελουμε να πάρουμε και τις μεταβλητές που θα μας επιστεψει το url συμπληρώνουμε jsonData π.χ. function(jsonData){}
 * @param {String} type='json' o τύπος των δεδομενων που θα μας επιστέψει το URL.
 * @param {Number} maskenable θα εμφανίσει Loading Mask στο κεντρικό παράθυρο της εφαρμογής
 * @param {Boolean} async=false για να κανει συχρόνο το request
 * @returns
 */

function pegAjax(url , params , callback , type , maskenable , async){
	if(async== undefined ){
		async=true;
	}
	
	if(maskenable=='undefined'){
		maskenable=0;
	}
	
	if(maskenable==1){
		peg002_mask()
	}
	
	if(type==undefined){
		type='json';
	}	
	var ajaxobj =   Ext.Ajax.request({
	    url		: url   ,
	    params	: params,
	    async   : async ,
	    timeout : 300000,
	    callback: function( options, success, response ){
	    	if(pegAjaxCallBack( options, success, response )){
	    		var text = response.responseText;
	    		var jsonData = text;
	        	// process server response here
	        	if(type=='json' && !pegIsEmpty(text)){
	        		try {
						jsonData = pegJsonDecode( text );
						if(type=='json' && typeof jsonData!='object'){
                            var url='';
                            if(response.request){
                                if(response.request.url){
                                    url= response.request.url;
                                }else if (response.request.options && response.request.options.url) {
                                    url= response.request.options.url;
                                }
                            }
                            pegAjaxErrorAlert(text, 'Invalid Response Type',url );
                        } 
	    			} catch (e) {
	    				console.error('Unable to decode data');
	    				console.info('Try to decode string',text);
	    				console.dir(e);
	    				// TODO: handle exception
	    			}
	        	} 
	    		if(callback && typeof(callback) === "function"){ 
	    			callback(jsonData);
	    		}
	    		if(maskenable==1){
					peg002_unmask();
				}
	    	}
	    },
	    success: function(response){
	    	return true;
	    },
	    failure: function(response){
	    	return true;
	    }
	    
	    
	});
	
	return ajaxobj;
}	

/**
 * H συνάρτησης αυτη εκετελεί ενα ajax request.  
 * 
 * @param {String} url  service url
 * @param {Object} params το js object με όλες τις μεταβλητες που θα περαστουν ως post στο url
 * @param {Funcion} callback  αν θελουμε να πάρουμε και τις μεταβλητές που θα μας επιστεψει το url συμπληρώνουμε jsonData π.χ. function(jsonData){}
 * @param {String} type='json' o τύπος των δεδομενων που θα μας επιστέψει το URL.
 * @param {Number} maskenable θα εμφανίσει Loading Mask στο κεντρικό παράθυρο της εφαρμογής
 * @param {Boolean} async=false για να κανει συχρόνο το request
 * @returns an Ext.Promise Object
 */
function pegAjaxPromise(url , params , callback , type , maskenable  , async){ 
	if(async== undefined ){
		async=true;
	}
	
	if(maskenable=='undefined'){
		maskenable=0;
	}
	
	if(maskenable==1){
		peg002_mask()
	}
	
	if(type==undefined){
		type='json';
	}	

	return new Ext.Promise(
		function (resolve, reject) {
			var ajaxobj =   Ext.Ajax.request({
			url		: url   ,
			params	: params,
			async   : async ,
			timeout : 300000,
			callback: function( options, success, response ){
				resolve(response.responseText);
				if(pegAjaxCallBack( options, success, response )){
					var text = response.responseText;
					var jsonData = text;
					// process server response here
					if(type=='json' && !pegIsEmpty(text)){
						try {
							jsonData = pegJsonDecode( text );
							if(type=='json' && typeof jsonData!='object'){
								var url='';
								if(response.request){
									if(response.request.url){
										url= response.request.url;
									}else if (response.request.options && response.request.options.url) {
										url= response.request.options.url;
									}
								}
								pegAjaxErrorAlert(text, 'Invalid Response Type',url );
							} 
						} catch (e) {
							console.error('Unable to decode data');
							console.info('Try to decode string',text);
							console.dir(e);
							// TODO: handle exception
						}
					} 
					if(callback && typeof(callback) === "function"){ 
						callback(jsonData);
					}
					if(maskenable==1){
						peg002_unmask();
					}
				}
			},
			success: function(response){
				resolve(response.responseText);
				return true;
			},
			failure: function(response){
				reject(response.status);
				return true;
			}
		});
	});
}

//XXX Start Manage  {WebApp.view.*}  function 

/**
 * Get the containet ID of an _d
 * @param {String} container_id the container ID of the Screen
 * @param {String} _d the _d to search
 * @param {false/'up'/'down'} type
 * @param parent_d
 * @returns
 */
function pegGetContainer_id_d(container_id , _d , type , parent_d ){
	if(pegGetFramework() == 'peg002'){
		return peg002_getContainer_id_d(container_id , _d , type , parent_d );
	}
	var cmp = false;
	if(!container_id){
		return '';
	}
	
	if(!Ext.getCmp(container_id)){
		return '';
	}
	
	if(!_d){
		return '';
	}
	
	if(type==''){
		type =false;
	}
	
	if(!parent_d){
		var parent_cmp = Ext.getCmp(container_id); 
	}else{
		
		if(Ext.getCmp(container_id).peg_d==parent_d){
			parent_cmp = Ext.getCmp(container_id); 
		}
				
		if(!parent_cmp){
			parent_cmp = Ext.getCmp(container_id).down('panel[peg_d='+parent_d+']'); 
		}
		
		if(!parent_cmp){
			parent_cmp = Ext.getCmp(container_id).up('panel[peg_d='+parent_d+']'); 
		}
		
	}
	
	
	if(!parent_cmp){
		return '';		
	}

	if(parent_cmp.peg_d==_d){
		
		return parent_cmp.id;
	}
	
	if((!type) || type=='down'){
		cmp = parent_cmp.down('panel[peg_d='+_d+']'); 
	}
	
	if(!cmp){
		if((!type) || type=='up'){
			cmp = parent_cmp.up('panel[peg_d='+_d+']'); 
		}	
	}
	
	
	if(!cmp){
		return '';
	}
	return cmp.id;
	
	
} 
/**
 * This function return the owner grid of a view
 * @param {Ext.view.View} the view
 * @return {WebApp.view.grid.Grid/WebApp.view.Scheduler/null}
 */
function pegGetOwnerCmpFromView(view){
	if(view){
		if(view.ownerGrid){
			return view.ownerGrid;
		}		
	}
	return null;
}

/**
 * 
 * @see {@link Ext.getCmp}
 * 
 * @param {String} container_id the container ID of the Screen
 * @param {String} name the name of the element
 * Optional argument
 * @returns {WebApp.view.*} 
 */
function pegGetCmp( container_id , name){
	if(pegIsEmpty(name)){
		return Ext.getCmp(container_id);
	}else{
		return Ext.getCmp(container_id + '_'+name);
	}
	
}
/**
 * 
 * @param {String} name the name of the element
 * @param container_id the container ID of the current Screen
 * @param _d The _d that belongs
 * @param type 
 * @param parent_d
 * @returns  {WebApp.view.*} 
 */
function pegGetCmp_d(name , container_id , _d , type , parent_d  ){
	
	//console.log('  name:' + name  + '  container_id:' +  container_id + '_d:' +  _d + '  type:' + type + '  parent_d:' + parent_d );
	var container_id = pegGetContainer_id_d(container_id , _d , type , parent_d ); 
 	if(container_id==''){
 		//	pegAlert('1');
 		//	pegAlert('pegGetCmp_d container_id:' + container_id + ' _d:' + _d + ' type:' + type + ' parent_d:' +  parent_d , '--- PEGASUS Error ---');
 		return false;
 	}		
 	
 	if(!pegGetCmp(container_id + '_' + name )){
 		//	pegAlert('2' + container_id + '_' + name);
		//	pegAlert('pegGetVal container_id:' + container_id + '_' + name , '--- PEGASUS Error ---');
		return false;
	}	
 	//var_00 =  pegGetVal(name , id)
 	return pegGetCmp(container_id + '_' + name );
 	
}
/**
 * 	Κάνει ένα πεδίο readOnly,
 * 
 * @param {String} name the name of the element
 * @param {String} container_id = το container_id που ανοίκει το πεδίο
 * @param {String} type  = true για να κανει το πεδίο readonly και false για να επιστρεψει το edit mode.  
 * 
 */
function pegSetFieldReadonly(name, container_id, type) {
	var field = pegGetCmp(container_id, name);
	if (pegIsEmpty(field)) {
	  return false;
	}
	if (!pegIsEmpty(field.peg_selectboxClassId)) {
	  var selectbox = pegGetCmp(field.peg_selectboxClassId);
	  if (selectbox) {
		return selectbox.setReadOnly(type);
	  }
	} else if (!pegIsEmpty(field.peg_colorPickerClassId)) {
	  var selectbox = pegGetCmp(field.peg_colorPickerClassId);
	  if (selectbox) {
		return selectbox.setReadOnly(type);
	  }
	}else if (field.peg_tinyButton_id) {
		var tinyButton = pegGetCmp(field.peg_tinyButton_id);
		if (tinyButton) {
		  return tinyButton.setDisabled(type);
		}
	  } else {
	  return field.setReadOnly(type);
	}
  }
   
 
/**
 * 	Κάνει ένα πεδίο κρυφό,
 * 
 * @param {String} name the name of the element
 * @param {String} container_id = το container_id που ανοίκει το πεδίο
 * @param {String} type  = true για να κανει το πεδίο hidden  .  
 * 
 */
function pegSetFieldHidden(name, container_id, value) {
    var field = pegGetCmp(container_id, name);
    if (pegIsEmpty(field)) {
      return false;
    }

    if (!pegIsEmpty(field.peg_selectboxClassId)) {
      var selectbox = pegGetCmp(field.peg_selectboxClassId);
      if (selectbox) {
        return selectbox.setHidden(value);
      }
    } else if (!pegIsEmpty(field.peg_colorPickerClassId)) {
      var selectbox = pegGetCmp(field.peg_colorPickerClassId);
      if (selectbox) {
        return selectbox.setHidden(value);
      }
    } else if (field.peg_tinyButton_id) {
      var tinyButton = pegGetCmp(field.peg_tinyButton_id);
      if (tinyButton) {
        return tinyButton.setHidden(value);
      }
    }else {
      return field.setHidden(value);
    }
}

/**
 * Get the value of a compoment
 * @param name
 * @param container_id
 * @returns
 */
function pegGetVal(name , container_id){
    var element = pegGetCmp( container_id, name ) ; 
     if(!element){
          return '';
     }
     if(pegIsRadioObject(element) ){
          return element.getChecked()[0].inputValue;
     }else if (pegIsTimeObject(element)){
          return element.rawValue;  
     }else if (pegIsDateObject(element)){
          return element.getSubmitValue();  
     }else if (pegIsCheckboxObject(element)){
          if(element.value!=0){
               return element.inputValue;  
          }else{
               return 0;
          }
     }else if(pegIsTagObject(element)){
          return element.peg_getSubmitValue();
     }else if (pegIsNumberObject(element)) {
          return element.getValue();
     }else if(pegIsComboboxV2Object(element)){
          return element.getValue();
     }else if(pegIsTinyMCETextAreaObject(element)){
          return element.getValue();
	 }else if ( element.value){
          return element.getValue();
     }  
 
     return '';
}

 

/**
 * 
	pegGetVal_d(name , container_id , _d , type , parent_d , callback)
	------------------------------------------------------------------
	name : the name of the field
	container_id: the container id
	the _d: 
	type = up or down or empty gia na aknei anazitish prota sta pedia kai meta stoys paterades
	to parent_d  
*/
/**
 * 
 * @param {String} name  the name of the field
 * @param {String} container_id the container id
 * @param {String} _d The _d
 * @param {up/down/empty} type  up or down or empty gia na aknei anazitish prota sta pedia kai meta stoys paterades
 * @param {String} parent_d  
 * @param {Function} callback 
 * @returns
 */
function pegGetVal_d(name , container_id , _d , type , parent_d , callback){
	var var_00 = -1;
 
	var id = pegGetContainer_id_d(container_id , _d , type , parent_d ); 
 	if(id==''){
 	 	/*console.log( ' container_id --> ' + container_id +' _d--> ' + _d + ' type --> ' + type + ' parent_d -->' + parent_d );*/
 	}
 
	var_00 =  pegGetVal(name , id);
	if(callback && typeof(callback) === "function"){
		callback({value:var_00});
	}
	
	return var_00;
}



/**
 * Sets The value of a field
 * @param {String} name
 * @param {String} container_id
 * @param {String/Number} val
 * @returns
 */
function pegSetVal(name , container_id , val){
    var field = pegGetCmp(container_id , name );
     if(field){ 
          if (pegIsComboboxV2Object(field)){ 
               return field.setPeg_values(val);   
          }else{
               if(field.$className=='Pegasus.field.Number' ){
                    field.value_old = val;
               }
               return field.setValue(val); 
          }
  
     } 
}


/**
 * 
 * @param {String} name  the name of the field
 * @param {String} container_id the container id
 * @param {String} _d The _d
 * @param {up/down/empty} type  up or down or empty gia na aknei anazitish prota sta pedia kai meta stoys paterades
 * @param {String/Number} val
 * @param {String} parent_d  
 * @param {Function} callback 
 * @returns
 */
function pegSetVal_d(name , container_id , _d , type, val , parent_d, callback){
	var id = pegGetContainer_id_d(container_id , _d , type , parent_d ); 
 	return pegSetVal(name , id , val);
 	
}
//XXX Start Data functions
/**
 * Ελένχει αν ειναι empty μια τιμή.
 *  @param {String/Number/Date/Object}  H μεταβλητη που θα τεστάρει 
 *  @return {Boolean}
*/
function pegIsEmpty(obj) {
    if (typeof obj == 'undefined' || obj === null || obj === '') return true;
    if (typeof obj == 'number' && isNaN(obj)) return true;
    if (obj instanceof Date && isNaN(Number(obj))) return true;
    return false;
}
/**
 * 
 * @param {String} json The JSON string.
 * @param {Boolean} [safe=false] `true` to return null, otherwise throw an exception
 * @return {Object} The resulting object
 */
function pegJsonDecode(json, safe){
    if(Ext.JSON.decode(json, true)!=null){
        return Ext.JSON.decode(json, safe);
    }else{
 
        json00 = json
        /* [ ' expr ' : ]  ==>  [ " expr " : ] */
        .replace(/\s*('([^']+)'\s*:)/g, '"$2" :' )
        /* [  expr : ]  ==>  [  "expr" : ] */
        .replace(/\s*([a-zA-Z0-9_]+)\s*:/g,'"$1" :')
        /* [ : 'expr' ]  ==>  [  : "expr" ] */
        .replace(/\s:\s*'([^']*)'\s*/g,': "$1"')
        /* [ : expr ]  ==>  [ : "expr"  ] */
        .replace(/:\s*([a-zA-Z0-9_]+)/g,': "$1"' )
        /* remove trailing comma */
        .replace(/\,(?!\s*?[\{\[\"\'\w])/g,'' );
        try {
            return Ext.JSON.decode(json00, safe);
        }
        catch(err) {
            console.log(err,json);
        } 
    }
}

/**
 * Encodes an Object, Array or other value.
 * 
 * If the environment's native JSON encoding is not being used ({@link Ext#USE_NATIVE_JSON} is not set,
 * or the environment does not support it), then ExtJS's encoding will be used. This allows the developer
 * to add a `toJSON` method to their classes which need serializing to return a valid JSON representation
 * of the object.
 * 
 * @param {Object} obj The variable to encode.
 * @return {String} The JSON string.
 */
function pegJsonEncode(obj){
	return Ext.JSON.encode(obj); 
}



/*
	pegGetVal_d(name , container_id , _d , type , parent_d , callback)
	------------------------------------------------------------------
	name : the name of the field
	container_id: the container id
	the _d: 
	type = up or down or empty gia na aknei anazitish prota sta pedia kai meta stoys paterades
	to parent_d  
*/

/**
 * Converts a query string back into an object.
 *
 * Non-recursive:
 *
 *     pegQueryStringToObj("foo=1&bar=2"); // returns {foo: '1', bar: '2'}
 *     pegQueryStringToObj("foo=&bar=2"); // returns {foo: '', bar: '2'}
 *     pegQueryStringToObj("some%20price=%24300"); // returns {'some price': '$300'}
 *     pegQueryStringToObj("colors=red&colors=green&colors=blue"); // returns {colors: ['red', 'green', 'blue']}
 *
 * Recursive:
 *
 *     pegQueryStringToObj(
 *         "username=Jacky&"+
 *         "dateOfBirth[day]=1&dateOfBirth[month]=2&dateOfBirth[year]=1911&"+
 *         "hobbies[0]=coding&hobbies[1]=eating&hobbies[2]=sleeping&"+
 *         "hobbies[3][0]=nested&hobbies[3][1]=stuff", true);
 *
 *     // returns
 *     {
 *         username: 'Jacky',
 *         dateOfBirth: {
 *             day: '1',
 *             month: '2',
 *             year: '1911'
 *         },
 *         hobbies: ['coding', 'eating', 'sleeping', ['nested', 'stuff']]
 *     }
 *
 * @param {String} queryString The query string to decode
 * @param {Boolean} [recursive=false] Whether or not to recursively decode the string. This format is supported by
 * PHP / Ruby on Rails servers and similar.
 * @return {Object}
 */
function pegQueryStringToObj(queryString, recursive){
	return Ext.Object.fromQueryString(queryString, recursive);
}

//XXX Start Manage  {Ext.data.Store.*}  function

/**
 * 
 * @param {String} storeID the ID of the store
 * @returns {Ext.data.Store}
 * 
 * @inheritdoc {@link Ext.data.StoreManager#method-lookup}
 */
function pegGetStore(storeID){
	return Ext.getStore(storeID); 
}
 
function pegGetRecData(table, nr01) {
	pegAjax('/' + main_path + '/core_global/rec_data.php?table=' + table + '&nr01=' + nr01, {}, function (json_data) {
		if (json_data.ok == 1) {
			var width = 750;
			var height = 350;
			if (Ext.getViewportWidth() < width) {
				width = Ext.getViewportWidth() - 10;
			}
			if (Ext.getViewportHeight() < height) {
				height = Ext.getViewportHeight() - 10;
			}
			var params = {
				title: json_data.title,
				html: json_data.message,
				bodyPadding: 5,
				layout: 'fit',
				width: width,
				height: 350,
				modal: height,
				autoScroll: true

			};


			Ext.create('Ext.window.Window', params).show();
		} else {
			pegAlert(json_data.message);
		}
	});
}


/**
 * Diplay A message alart
 * 
 * @param {String} msg0 
 * @param {String} title0 
 * @param {String} url 
 * 
 */
function pegAjaxErrorAlert(msg0,title0,url){
    var title = '';
    var msg = '';
       
    if(pegGetFramework() == 'peg002'){
        pegGetDic(
            'peg_dic_core_failed_to_load_data_ttl',
            function(desc00){  title += desc00; });
        pegGetDic(
            'peg_dic_core_failed_to_load_data_msg',
            function(desc01){ msg += desc01; });
    }else{
        title += peg_dic_core_failed_to_load_data_ttl;
        msg += peg_dic_core_failed_to_load_data_msg;
    }
       
    msg +='<br/> ';;
    msg+=msg0;
    msg +='<br/> ';;
    msg += "Url: "+url+'<br/>';
   
    var d = new Date();
    var mm = d.getMonth() + 1;
    if (mm < 10) {
      mm = '0' + mm;
    }
    var date =  d.getDate();
    if (date < 10) {
        date = '0' + date;
    }
    var min= d.getMinutes();
    if (min < 10) {
        min = '0' + min;
    }
    var sec= d.getSeconds();
    if (sec < 10) {
        sec = '0' + sec;
    }
    msg += d.getFullYear()+'-'+mm+'-'+date+' '+d.getHours() +':' +min+':'+sec +'<br/>';
    //console.info('pegAjaxCallBack::response',response);
   
    title+=title0;
    pegAlert(msg, title ); 
}