<?php
	if(file_exists('../../pegasus_cloud_app/prints_libs/FPDF/fpdf.php')){
		require('../../pegasus_cloud_app/prints_libs/FPDF/fpdf.php');
	}else{
		if(!file_exists('fpdf.php')){
			return;
		}	
		require('fpdf.php');
	}
	
	
	
	
    require('pdftcpdf.php');
    require('PDF_Data.php');
    class pegPDF extends FPDF {
    	var $javascript;
        var $n_js;
    	
    	private $grammes;
    	private $stiles;
    	
    	private $total_width;
    	private $total_height;
    
    	private $g_height;
    	private $s_width;
    
    	private $left_margin;
    	private $top_margin;
    	private $right_margin;
    	private $bottom_margin;
    	/**
    	 * Το χρώμα των font που υπάρχουν στο κείμενο.
    	 * Link Ορίζετε μόνο την πρώτη φορά
    	 * @var array(
    				'maincolor' => 
    					array('r' => '', 'g' => '', 'b' => '') , 
    				'linkcolor' => 
    					array('r' => '', 'g' => '', 'b' => '')
    		)
    	 */
    	private $peg_color ;
    	
    	
    	private $url = "";
    	/**
    	 * To offset se grammes (se kathe nea selida midenizetai)
    	 * @var unknown
    	 */
    	public $offset_y;
    	/**
    	 * To offset se stiles (se kathe nea selida midenizetai)
    	 * @var unknown
    	 */
    	public $offset_x;
    	/**
    	 * To upsos toy header (se kathe nea selida midenizetai)
    	 * @var unknown
    	 */
    	public $max_head_row;
    	/**
    	 * To upsos toy body (se kathe nea selida midenizetai)
    	 * @var unknown
    	 */
    	public $bodyheight;
    	private $body_rows_i;//dex xrisimopoieite kapoii
    	
    	
    	public function __construct(
    					$grammes , $stiles , $total_width , $total_height , 
    					$orientation='P', $unit='mm', $size='A4' ,  $top_margin=0 ,
    					$left_margin=0 , $bottom_margin=0 , $right_margin=0 
    			){
    		parent::__construct($orientation,$unit,$size);
    		$this->SetAutoPageBreak(true,  0);
    // 		$this->FPDF($orientation,$unit,$size);
    		$this->offset_y			= 0;
    		$this->offset_x			= 0;
    		$this->max_head_row		= 0;
    		$this->bodyheight		= 0;
    		$this->body_rows_i		= 0;
    		
    		$this->grammes      = $grammes;
    		$this->stiles       = $stiles;
    		$this->total_width  = $total_width  ;
    		$this->total_height = $total_height ;
    		
    		$this->left_margin    = $left_margin;
    		$this->top_margin     = $top_margin;		
    		$this->right_margin   = $right_margin;
    		$this->bottom_margin  = $bottom_margin;		
    		
    		$this->s_width = ($total_width  - $this->left_margin - $this->right_margin)/$stiles;
    		$this->g_height =($total_height - $this->top_margin  - $this->bottom_margin)/$grammes;	
    		
    		//echo ($total_width  - $this->left_margin - $this->right_margin)."\n";
    		/* echo $this->g_height ."\n"; */
    		
    		$this->url = "";
    		$this->peg_color = array(
    				'maincolor' => 
    					array('r' => '', 'g' => '', 'b' => '') , 
    				'linkcolor' => 
    					array('r' => '', 'g' => '', 'b' => '')
    		);
    	}
    	public function hasMoreRows($body_rows, $body_rows_i){
    		return ($body_rows>= $body_rows_i);
    	}
    	public function addBodyRow(){
    		$this->body_rows_i++;
    	}
    	
    	public function addBodyI(){
    		return 1;
    	}
    	public function hasMoreSpace($i, $bodyheight){
    		return ($i<$bodyheight);
    	}
    	public function set_vdisft(){
    		
    	}
    	
    	
    	/**
    	 * Kanei add Ta font. kai elegxei ean exoun idi ginei add
    	 * @see TCPDF::AddFont()
    	 */
    	public function AddFontFamily($family, $style='', $fontfile='', $subset='', $id=0){
    			
    		if($id>0 and isset($this->cashingAddFont[$id] )
    				){
    					//Font Allready Added
    					/* print_r($this->cashingAddFont); */
    					return ;
    	
    		}
    	
    		if($id>0)
    			$this->cashingAddFont[$id] = array('style' => $style, 'fontfile' => $fontfile, 'subset' => $subset);
    	
    			return $this->AddFont($family, $style, $fontfile);
    	}
    	
    	/**
    	 * Kanei add Ta font. Thn kanw extern
    	 * 		1. gia n mhn exw fatal error sta arialgreek
    	 * 		2. Na kanw add font ean yparxei eidi
    	 * @see TCPDF::AddFont()
    	 */
    	public function AddFont($family, $style='', $fontfile=''){
    	/* 	if(strtolower($family) == "arialgreek" || empty($family)){
    			$family = 'dejavusans';
    			$file = '';
    		}
     */	
    		// 		$p87_00['font'] , '' , $p87_00['font'] . '.php' )
    		return parent::AddFont($family, $style , $fontfile );
    	}
    	/* public function updateMaxBodyRowI(){
    	
    	} */
    	
    	public function peg_get_position($pos , $row = 0, $col= 0, $row0= 0,$col0= 0, $i = 0){
    		if($pos==1){
    			//header
    			$row  = $this->offset_y +$row;
    			$col  = $this->offset_x+$col;
    			$row0 = $this->offset_y+$row0;
    			$col0 = $this->offset_x+$col0;
    		}
    		
    		if($pos==2){
    			//body
    			$row  = $this->offset_y+$row+$i+$this->max_head_row;
    			$col  = $this->offset_x+$col;
    			$row0 = $this->offset_y+$row0+$i+$this->max_head_row;
    			$col0 = $this->offset_x+$col0;
    		
    		}
    		
    		if($pos==3){
    			//footer
    			$row  = $this->offset_y+$row + $this->max_head_row + $this->bodyheight;
    			$col  = $this->offset_x+$col;
    			$row0 = $this->offset_y+$row0 + $this->max_head_row +  $this->bodyheight;
    			$col0 = $this->offset_x+$col0;
    		
    		}
    		if($row0<$row){
    			$row0 = 0;
    		}
    		if($col0<$col){
    			$col0 = 0;
    		}
    		return array($row,$col,$row0,$col0 );
    	}
    	
    	public function SetTextColor($r, $g = null, $b = null){
    		parent::SetTextColor($r, $g, $b );
    		$this->peg_color['maincolor']['r'] = $r;
    		$this->peg_color['maincolor']['g'] = $g;
    		$this->peg_color['maincolor']['b'] = $b;
    	}
    	public function SetTextLinkColor($r, $g = null, $b = null){
    		$this->peg_color['linkcolor']['r'] = $r;
    		$this->peg_color['linkcolor']['g'] = $g;
    		$this->peg_color['linkcolor']['b'] = $b;
    	}
    
    	function peg_print_line($grami_top , $stili_top , $grami_bottom , $stili_bottom,$width=0 ){
    		if(!empty($width)){
    			$lineWidthTmp = $this->LineWidth;
    			$this->SetLineWidth($width);
    			
    		}
    		$this->Line( ($stili_top*$this->s_width)+$this->left_margin  , ($grami_top*$this->g_height)+$this->top_margin , ($stili_bottom*$this->s_width)+$this->left_margin  ,  ($grami_bottom*$this->g_height)+$this->top_margin );
    		if(!empty($width)){
    			$this->SetLineWidth($lineWidthTmp);
    		}		
    	}
    	
     	function peg_set_margins($top_margin=0 ,$left_margin=0 , $bottom_margin=0 , $right_margin=0 ){
     		$this->left_margin    = $left_margin;
    		$this->top_margin     = $top_margin;		
    		$this->right_margin   = $right_margin;
    		$this->bottom_margin  = $bottom_margin;				
     	}
    	
    	function peg_print_text($grami , $stili  , $text){
    		if(empty($text)){
    			return ;
    		}
    		
    		if(pegasus_check_utf8($text) ){
    			$text =  iconv("UTF-8", "ISO-8859-7" , $text);
    	 	}
    	 	
    
    		if(pegasus_lock_check_app()==1){
    			$text = '.' . substr($text ,1);				
    		}		 	
    	 			
    		$this->text(($stili*$this->s_width)+$this->left_margin  , ($grami*$this->g_height)+$this->top_margin  , $text);
    		
    	}
    	/**
    	 * Καλεί την peg_print_memo_array(array(
    						'grami' => $grami,
    						'stili' => $stili,
    						'grami0' => $grami0,
    						'stili0' => $stili0
    				) ,$text )
    	 * @param unknown $grami
    	 * @param unknown $stili
    	 * @param unknown $grami0
    	 * @param unknown $stili0
    	 * @param unknown $text
    	 */
    	function peg_print_memo($grami , $stili ,$grami0 , $stili0  , $text){
    		if(empty($text)){
    			return ;
    		}
    		
    		return $this->peg_print_memo_array(
    				array(
    						'grami' => $grami,
    						'stili' => $stili,
    						'grami0' => $grami0,
    						'stili0' => $stili0
    				) ,$text 
    		);
    		
    	}
    	
    	/**
    	 * Ektipwnei ena memo se polles grammes. 
    	 * To plithos twn grammwn einai grami0 - grami
    	 * To megethos einai elemsize h stili0 -stili
    	 * @param  array() $param array(
    						'grami' => $grami,
    						'stili' => $stili,
    						'grami0' => $grami0,
    						'stili0' => $stili0,
    						'elemsize' => $elemsize,
    						'synLineHeight' =>me ti tha polaplasiastei to line height
    				)
    	 * @param unknown $text
    	 */
    	public function peg_print_memo_array($param = array(), $text = ''){
    		if(empty($text)){
    			return ;
    		}
    		$this->url ="";
    		$grami	= $param['grami'] ; 
    		$stili	= $param['stili'] ;
    		$grami0	= $param['grami0'] ;
    		$stili0	= $param['stili0'] ;
    		
    		$elemsize = (!empty( $param['elemsize']) and $param['elemsize']>0)?$param['elemsize'] : ($stili0 -$stili);
    		$syntelesthsLineHeight = (!empty( $param['synLineHeight']) and $param['synLineHeight']>0)?$param['synLineHeight'] : 1;
    		
    		//die($elemsize);
    		$numOfRows = $grami0 - $grami;
    		if($numOfRows<1){
    			$numOfRows = 1;
    		}
    
    		$x_tmp = (($stili*$this->s_width)+$this->left_margin );
    		$y_tmp = ( (($grami) *$this->g_height)+$this->top_margin );
    
    		$realText =  iconv("UTF-8", "ISO-8859-7" , $text);
    		$text = $this->_getCleanText($realText);
    		$realText =  str_replace(PHP_EOL, ' ', $realText);
    		/* var_dump($leftCol); */
    		if($elemsize<=0 || (  $elemsize>=mb_strlen($text,'ISO-8859-7') ) ){
    			$iNumOfRows = 0;
    			//th $text =  iconv("UTF-8", "ISO-8859-7" , $text);
    			$this->_printText($x_tmp,$y_tmp ,$syntelesthsLineHeight,$realText, $text);
    			return ;
    		}
    	
    		/* $text = html2text */
    		$x_tmp = (($stili*$this->s_width)+$this->left_margin );
    		$y_tmp = ( (($grami) *$this->g_height)+$this->top_margin );
    		for ($iNumOfRows = 0; $iNumOfRows < $numOfRows and $elemsize!=0 ; $iNumOfRows++) {
    			//$y_tmp= ( (($grami+$iNumOfRows) *$this->g_height)+$this->top_margin );
    			$textToPrint = FALSE;
    			$tmpstr = peg_substr($text,0,$elemsize , "ISO-8859-7");
    			$textTmpLen = peg_strlen($text, "ISO-8859-7");
    			if($tmpstr!=$text){
    				
    				//For enter
    				$textToPrint00 = mb_strstr($tmpstr,"\n",TRUE , "ISO-8859-7");
    				$textToPrint01 = mb_strrchr($tmpstr," ",TRUE, "ISO-8859-7");
    				if($textToPrint00!=false){
    					$textToPrint = $textToPrint00;
    					$text = mb_strstr($tmpstr, "\n",FALSE, "ISO-8859-7") . peg_substr($text,$elemsize,$textTmpLen, "ISO-8859-7");
    				}elseif($textToPrint01!=false){
    					$textToPrint = $textToPrint01;
    					$text = mb_strrchr($tmpstr," ", FALSE, "ISO-8859-7"). peg_substr($text,$elemsize,$textTmpLen, "ISO-8859-7");
    				}
    			}
    			//echo "$stili =  \n";
    			//echo "befor $elemsize --> $text \n\n";
    			if($textToPrint!=FALSE){
    				$text = peg_substr($text, 1, $textTmpLen, "ISO-8859-7");//Gia na ejafanistei o xaraktiras apokopis
    				$this->_printText($x_tmp, $y_tmp ,$syntelesthsLineHeight , $realText,$textToPrint);
    			}else{
    				$text =  peg_substr($text,$elemsize,$textTmpLen, "ISO-8859-7");
    				$this->_printText($x_tmp,$y_tmp ,$syntelesthsLineHeight , $realText , $tmpstr);
    			}	
    			
    			if(mb_strlen($text ,"ISO-8859-7") == 0){
    				/* $tmpstr = $text. "-Breake for ". $tmpstr;
    				$this->_printText($x_tmp,$y_tmp ,$syntelesthsLineHeight , $realText , $tmpstr); */
    				break;
    			}
    		}
    		
    	}
    	
    	public function peg_print_barcode_array($param = array(), $value = ''){ 
    	    if(empty($value)){
    	        return "";
    	    }
    	    
    	    $value = pegasus_leading_zeros($value, 12);
    	    
    	    $width = 0;
    	    $height = 0;
    	
    	    
    	    
    	    $grami	= $param['grami'] ;
    	    $stili	= $param['stili'] ;
    	    $grami0	= $param['grami0'] ;
    	    $stili0	= $param['stili0'] ;
    	    
    	    $type       = (isset($param['type']))?$param['type'] : 'EAN13';
    	     
    	     
    	    
    	    $x_tmp = (($stili*$this->s_width)+$this->left_margin );
    	    $y_tmp = ( (($grami) *$this->g_height)+$this->top_margin );
    	    
    	    $elemsize = ($stili0 -$stili);
    	    $numOfRows = $grami0 - $grami;
    	    /* if($numOfRows<1){
    	     $numOfRows = 1;
    	     } */
    	    $width	= .4;
    	    $height = $numOfRows * $this->g_height;
    	    
    	    if($type == 'EAN13'){
    	        $this->EAN13_Barcode($x_tmp, $y_tmp, $value, $height, $width) ;
    	    }
    	} 
    	
    	function peg_print_cell( $grami , $stili  , $text ,  $border=0 , $size=0 , $align='L' , $fill=false, $url=''  ){
    		if(empty($text)){
    			return ;
    		}
    		
    		
    		if(pegasus_check_utf8($text) ){
    			$text =  iconv("UTF-8", "ISO-8859-7" , $text);
    	 	}
    	 	/* $text .= chr(128); */
    		$grami = $grami-1;
    		if( $align=='R'){
    	 		if($size>0){
    	 //			$stili += $size;
    	 		}else{
    	 			$align='L';
    	 		}
    	 	}
    // 	 	echo "($grami*$this->g_height)+$this->top_margin";
    		
    		$this->SetXY(($stili*$this->s_width)+$this->left_margin,   ($grami*$this->g_height)+$this->top_margin);
    	 	$this->Cell( $this->s_width*$size , $this->g_height  ,  $text , $border  , $size , $align , $fill, $url);
    
    	}
    	
    	function peg_print_image($file , $grami , $stili , $grami_h , $stili_w   ){
    		
    		$this->peg_print_image_array(
    				array(
    						'grami' => $grami,
    						'stili' => $stili,
    						'grami0' => $grami_h,
    						'stili0' => $stili_w
    				) ,$file
    		);
    	}
    	/**
    	 * H synarthsh ayth ektypvnei mia eikona.
    	 * Ean den exoume orisi grami0, stili0 kai elemsize doyleyei opws douleue
    	 * @param array $param array(
    						'grami' => $grami,
    						'stili' => $stili,
    						'grami0' => $grami_h,
    						'stili0' => $stili_w
    						'link' => $link
    				)
    	 * @param string $file image path
    	 */
    	function peg_print_image_array($param = array(), $file =''){
    		$grami	= $param['grami'] ;
    		$stili	= $param['stili'] ;
    		$grami0	= $param['grami0'] ;
    		$stili0	= $param['stili0'] ;
    		
    		$link		= (isset($param['link']))?$param['link'] : '';
    		
    		$elemsize = ($stili0 -$stili);
    		$numOfRows = $grami0 - $grami;
    		/* if($numOfRows<1){
    			$numOfRows = 1;
    		} */
    		$width	= $elemsize * $this->s_width;
    		$height = $numOfRows * $this->g_height;
    		
    		//kai den exei orisei steilei eos
    		//kai den exei orisei grammi eos
    		if( ($stili0 -$stili)<=0 and ($grami0 - $grami)<=0){
    			//Ean den einai orismeno to platos - upsos thelw na douleuei opws douleue
    			if(file_exists($file)){
    				$this->Image($file  , ($stili*$this->s_width)+$this->left_margin  , ($grami*$this->g_height)+$this->top_margin ,0,0,'',$link) ;
    				
    			}
    				return ;
    			
    		}elseif( ($stili0 -$stili)<=0){
    			$width = 9999;
    		}else{
    			$height = 9999;
    		}
    		
    		if(file_exists($file)){
    // 			Image($file, $x=null, $y=null, $w=0, $h=0, $type='', $link='')
    			$sizes = getimagesize( $file );
    			$width_image  = $sizes[0];
    			$height_image = $sizes[1];
    			
    			if($width >= $width_image and  $height>= $height_image ){
    				// Image($file, $x = null, $y = null, $w = 0, $h = 0, $type = '', $link = '') 
    				$this->Image($file  , ($stili*$this->s_width)+$this->left_margin  , ($grami*$this->g_height)+$this->top_margin   ,0,0,'',$link ) ;
    			}else
    			if ($width >= $width_image and $width!=9999  and  !($height > $height_image) ){
    // 				echo "HERE 2 FOR $file \n";
    				$this->Image($file  , ($stili*$this->s_width)+$this->left_margin  , ($grami*$this->g_height)+$this->top_margin , 0 , $height,'',$link  ) ;
    			}elseif (!($width > $width_image) and $height!=9999 and  $height >= $height_image ){
    				$this->Image($file  , ($stili*$this->s_width)+$this->left_margin  , ($grami*$this->g_height)+$this->top_margin , $width , 0,'' ,$link  ) ;
    			}else{
    				$sintelestis = 0;
    				if(($width_image>=$height_image and $width!= 9999) or $height== 9999 ){
    					//Ean einai platia kai exei oristhe to platos
    					$sintelestis =$width/$width_image;
    					$width = (int) $width_image*$sintelestis;
    					$height = (int) $height_image*$sintelestis;
    				}else if(($width_image<=$height_image and $height!= 9999) or $width== 9999 ){
    					//Ean einai psili kai exei oristhe to upos
    					
    					$sintelestis = $height/$height_image;
    
    					$width = (int) $width_image*$sintelestis;
    					$height = (int) $height_image*$sintelestis;
    				}
    				
    				$this->Image($file  , ($stili*$this->s_width)+$this->left_margin  , ($grami*$this->g_height)+$this->top_margin , $width , $height,'' ,$link   ) ;
    			}
    			
    			
    			//($stili_w*$this->s_width) , ($grami_h*$this->g_height)  ,  );
    		}
    	}
    
        function IncludeJS($script) {
            $this->javascript=$script;
        }
    
        function _putjavascript() {
            $this->_newobj();
            $this->n_js=$this->n;
            $this->_out('<<');
            $this->_out('/Names [(EmbeddedJS) '.($this->n+1).' 0 R]');
            $this->_out('>>');
            $this->_out('endobj');
            $this->_newobj();
            $this->_out('<<');
            $this->_out('/S /JavaScript');
            $this->_out('/JS '.$this->_textstring($this->javascript));
            $this->_out('>>');
            $this->_out('endobj');
        }
    
        function _putresources() {
            parent::_putresources();
            if (!empty($this->javascript)) {
                $this->_putjavascript();
            }
        }
    
        function _putcatalog() {
            parent::_putcatalog();
            if (!empty($this->javascript)) {
                $this->_out('/Names <</JavaScript '.($this->n_js).' 0 R>>');
            }
        } 	
        
        
        private function _getCleanText($html){
        	$retStr ="";
        	$a=preg_split('/<(.*)>/U',$html,-1,PREG_SPLIT_DELIM_CAPTURE);
        	foreach($a as $i=>$e)
        	{
        		if($i%2==0){
        			$retStr .= $e;
        		}else{
        			continue;
        			//Tag
        			if($e[0]=='/'){
        				continue;
        				// 					$this->CloseTag(strtoupper(substr($e,1)));
        			}else{
        				//Extract attributes
        				$a2=explode(' ',$e);
        				$tag=strtoupper(array_shift($a2));
        				$attr=array();
        				foreach($a2 as $v)
        					if(preg_match('/^([^=]*)=["\']?([^"\']*)["\']?$/',$v,$a3))
        						$attr[strtoupper($a3[1])]=$a3[2];
        					$this->OpenTag($tag,$attr);
        			}
        		}
        	}
        	return $retStr;
        }
        
        private function _printText($x, &$y,$syntelestisLineHeight,&$textReal , $text){
        	// replace ta enter
        	$text			= str_replace(PHP_EOL, '', $text);
        	$textRealLength	= peg_strlen($textReal,'ISO-8859-7');
        	$textLength		= peg_strlen($text,'ISO-8859-7');
        	$reallength		= 0;
        	$textRealChar	= "";
        	$textChar		= "";
        	
        	$lineHeight		=  ($this->g_height*$syntelestisLineHeight);
        	/* if($this->g_height<$this->FontSize){
        		$lineHeight =  $this->FontSize *1.5;
        	} */
        
        	$y = $y-$lineHeight; // To height to pernaw mesa sto write
        	$this->SetXY($x, $y);
    /*     	$this->Write($lineHeight ,"lineHeight:");
        	$this->Write($lineHeight ,$lineHeight);
        	$this->Write($lineHeight ,"-syntelestisLineHeight:");
        	$this->Write($lineHeight ,$syntelestisLineHeight);  */
        
        
        	//$this->SetXY(($stili*$this->s_width)+$this->left_margin,   ($grami*$this->g_height)+$this->top_margin);
        	/* $url = ""; */
        	$length = 0;
        	while ($textLength>=$length){
        
        		$textChar		= peg_substr($text, $length, 1,'ISO-8859-7');
        		$textRealChar	= peg_substr($textReal, $reallength, 1,'ISO-8859-7');
        		
        		/* echo "textChar($length)				= " . $textChar;
        		echo "textRealChar($reallength) 	= " . $textRealChar . "\n";   */
        		
        		if($textRealChar=='<'){
        			$inCase = false;
        			//start
        			$textRealChar = peg_substr($textReal, ++$reallength, 1,'ISO-8859-7');
        			if($textRealChar=='/'){
        				$inCase = true;
        				$textRealChar = peg_substr($textReal, ++$reallength, 1,'ISO-8859-7');
        				if(strtolower($textRealChar)=='a'){
        					$this->url ="";
        					parent::SetTextColor(
        							$this->peg_color['maincolor']['r'],
        							$this->peg_color['maincolor']['g'],
        							$this->peg_color['maincolor']['b']
        					);
        				
        				}else if(strtolower($textRealChar)=='b'){
        					$this->SetFont('','',$this->FontSizePt-1);
        				}
        			
        			}elseif(strtolower($textRealChar)=='a'){
        				$inCase = true;
        				while($textRealLength > $reallength and $textRealChar!='>'){
        					$textRealChar = peg_substr($textReal, ++$reallength, 1,'ISO-8859-7');
        					
        					if( strtolower(peg_substr($textReal,$reallength,'5','ISO-8859-7')) == "href="){
        						$reallength += 5;
        						$textRealChar = peg_substr($textReal, $reallength, 1,'ISO-8859-7');
        						while(
        								$textRealLength > $reallength and
        								$textRealChar !='"' and
        								$textRealChar !="'"
        						) {
        							$textRealChar = peg_substr($textReal, ++$reallength, 1,'ISO-8859-7');
        							
        						}
        							
        						$startChar = $textRealChar;
        						$textRealChar = peg_substr($textReal, ++$reallength, 1,'ISO-8859-7');
        						while($textRealLength > $reallength and $textRealChar!=$startChar){
        							$this->url .= $textRealChar;
        							$textRealChar = peg_substr($textReal, ++$reallength, 1,'ISO-8859-7');
        								
        						}
        						$this->url = trim($this->url);
        						parent::SetTextColor(
        								$this->peg_color['linkcolor']['r'],
    		    						$this->peg_color['linkcolor']['g'],
    		    						$this->peg_color['linkcolor']['b']
        						);
        
        					}
        				} 
        					
        				/*$textReal =  peg_substr($textReal,$reallength,null,'ISO-8859-7');
        					$textRealLength	= peg_strlen($textReal,'ISO-8859-7');
        					$reallength = -1;
        					*/
        			}elseif (strtolower($textRealChar)=='b'){
        				$inCase = true;
        				$this->SetFont('','',$this->FontSizePt+1);
        				
        			}
        			
        			$strposclose = strpos($textReal, '>',$reallength);
        			$strposclose -= $reallength;
        			//echo "\n##$strposclose##\n";
        			if(
        					(
        						$inCase
        					) || (
        							$strposclose < 10
        							and
        							(!empty($strposclose) || $strposclose===0)
        							and
        							peg_substr($textReal, ($reallength+1) , 1,'ISO-8859-7')!=' '
        					)
        					
    	    		){
    	    			while($textRealLength > $reallength and $textRealChar!='>' ){
    	    				$textRealChar = peg_substr($textReal, ++$reallength , 1,'ISO-8859-7');
    	    			}
    	    			$reallength++;
    	    			continue;
    	    		}
        		}
        	
        		$this->Write($lineHeight ,$textChar,$this->url);
        		//TODO 2 metrites kai na kanw sxan kai to real text
        		$reallength++;
        		$length++;
        	}
        
        	/*die();*/
        	$textReal =  peg_substr($textReal,$reallength,$textRealLength ,'ISO-8859-7');
        	$y = $y+2*$lineHeight;
        }
        
        
        
        //XXX Start Ean 13
        function EAN13($x, $y, $barcode, $h=16, $w=.35)
        {
            $this->EAN13_Barcode($x,$y,$barcode,$h,$w,13);
        }
        
    //     function UPC_A($x, $y, $barcode, $h=16, $w=.35)
    //     {
    //         $this->Barcode($x,$y,$barcode,$h,$w,12);
    //     }
        
        function EAN13_GetCheckDigit($barcode)
        {
            //Compute the check digit
            $sum=0;
            for($i=1;$i<=11;$i+=2){
                $sum+=3*$barcode[$i];
            }
            for($i=0;$i<=10;$i+=2){
                $sum+=$barcode[$i];
            }
            $r=$sum%10;
            if($r>0){
                $r=10-$r;
            }
            return $r;
        }
        
        function EAN13_TestCheckDigit($barcode)
        {
            //Test validity of check digit
            $sum=0;
            for($i=1;$i<=11;$i+=2){
                $sum+=3*$barcode[$i];
            }
            for($i=0;$i<=10;$i+=2){
                $sum+=$barcode[$i];
            }
            return ($sum+$barcode[12])%10==0;
        }
        
        function EAN13_Barcode($x, $y, $barcode, $h, $w, $len){
            //Padding
            $barcode=str_pad($barcode,$len-1,'0',STR_PAD_LEFT);
            if($len==12){
                $barcode='0'.$barcode;
            }
             
            //Add or control the check digit
            if(strlen($barcode)==12){
                $barcode.=$this->EAN13_GetCheckDigit($barcode);
            }elseif(!$this->EAN13_TestCheckDigit($barcode)){
                die('Incorrect check digit');
            }
            
          
            //Convert digits to bars
            $codes=array(
                'A'=>array(
                    '0'=>'0001101','1'=>'0011001','2'=>'0010011','3'=>'0111101','4'=>'0100011',
                    '5'=>'0110001','6'=>'0101111','7'=>'0111011','8'=>'0110111','9'=>'0001011'),
                'B'=>array(
                    '0'=>'0100111','1'=>'0110011','2'=>'0011011','3'=>'0100001','4'=>'0011101',
                    '5'=>'0111001','6'=>'0000101','7'=>'0010001','8'=>'0001001','9'=>'0010111'),
                'C'=>array(
                    '0'=>'1110010','1'=>'1100110','2'=>'1101100','3'=>'1000010','4'=>'1011100',
                    '5'=>'1001110','6'=>'1010000','7'=>'1000100','8'=>'1001000','9'=>'1110100')
            );
            $parities=array(
                '0'=>array('A','A','A','A','A','A'),
                '1'=>array('A','A','B','A','B','B'),
                '2'=>array('A','A','B','B','A','B'),
                '3'=>array('A','A','B','B','B','A'),
                '4'=>array('A','B','A','A','B','B'),
                '5'=>array('A','B','B','A','A','B'),
                '6'=>array('A','B','B','B','A','A'),
                '7'=>array('A','B','A','B','A','B'),
                '8'=>array('A','B','A','B','B','A'),
                '9'=>array('A','B','B','A','B','A')
           );
           $code='101';
           $p=$parities[$barcode[0]];
           for($i=1;$i<=6;$i++){
                $code.=$codes[$p[$i-1]][$barcode[$i]];
           }
           $code.='01010';
           for($i=7;$i<=12;$i++){
               $code.=$codes['C'][$barcode[$i]];
           }
           $code.='101';
           //Draw bars
           for($i=0;$i<strlen($code);$i++){
               if($code[$i]=='1'){
                    $this->Rect($x+$i*$w,$y,$w,$h,'F');
               }
            }
            
            //Print text uder barcode
    //         $this->SetFont('Arial','',12);
    //         die("qqqwww11");
            $this->Text($x,$y+$h+11/$this->k,substr($barcode,-$len));
        }
    }	
    
?>
