<?php
require('../core_libs/tcpdf/tcpdf.php');

class pegTCPDF extends TCPDF {
	/* var $javascript;
    var $n_js; */
	
    /**
     * Toplithis ton grammvn tis ektypwsis
     * @var int
     */
	private $grammes;
	/**
	 * To plitos twn stilwn ths ektiposis
	 * @var unknown
	 */
	private $stiles;
	/**
	 * Ean tha prepei na mhdenistoun oi grammes giati exw allagi selidas
	 * @var boolean
	 */
	private $updMinusTrigger;
	/**
	 * Sthn allagi selidaw h aritmisi twn grmmwn prepei na jekinaei apo to 0
	 * @var unknown
	 */
	public $minusGrammes;
	/**
	 * Sintelestis anamesa sto upsos ths forma me to plithos ton grammvn
	 * ($this->h /$this->grammes)
	 * @var float
	 */
	private $g_height;
	/**
	 * Sintelestis anamesa sto platos ths forma me to plithos twnstilwn
	 * ($this->w )/$this->stiles;
	 * @var float
	 */
	private $s_width;
	/**
	 * To left margin se stiles
	 * @var int
	 */
	private $left_margin;
	/**
	 * To top margin se grammes
	 * @var int
	 */
	private $top_margin;
	/**
	 * To right margin se stiles
	 * @var int
	 */
	private $right_margin;
	/**
	 * To bottom margin se grammes
	 * @var int
	 */
	private $bottom_margin;
	/**
	 * Ean tha ektypvnete to header mia fora 
	 * to xreiazome gia na mhn epireazw to bodyheight
	 * @var boolean
	 */
	private $printHeaderOnce;
	/**
	 * To offset se grammes (se kathe nea selida midenizetai)
	 * @var unknown
	 */
	public $offset_y;
	/**
	 * To offset se stiles (se kathe nea selida midenizetai)
	 * @var unknown
	 */
	public $offset_x;
	/**
	 * To upsos toy header (se kathe nea selida midenizetai)
	 * @var unknown
	 */
	public $max_head_row;	
	/**
	 * To upsos toy body (se kathe nea selida midenizetai)
	 * @var unknown
	 */
	public $bodyheight;
	/**
	 * Poio einai to plithos ton dedomenwn poy exoyn ektypothei sto body
	 * @var int
	 */	
	private $body_rows_i;
	/**
	 * Poia einai h megaliteri grammi pou typwsai gia teleytaia 
	 * fora sto body
	 */
	private $peg_tmp_last_bodyrow;
	/**
	 * Thelw na jerw poia einai h megaliteri grammi apo thn trecousa ektipwsi
	 */
	private $peg_tmp_last_body_current_row;
	/**
	 * To teleytaio upsos poy epsestrepse h _getHeight
	 * @var unknown
	 */
	private $peg_tmp_lasth;
	/**
	 * Ti tiposai gia teleytaia fora
	 * @var enum {
	 * 		line	=> Grammi
	 * 		exp		=> ektipwnei keli (ekfrasi)
	 * 		exp_memo=> keimeno me anadiplwsi
	 * 		exp_html=> Ektipwnei html
	 * 		image	=> eikona
	 * }
	 */
	private $peg_tmp_lastPrintType;
	/**
	 * Pou tioposai gia teleutaia fora
	 * @var enum{1=> header,2 => body,3 => footer}
	 */
	private $peg_tmp_lastPosition;
	
	public function __construct(
					$grammes , $stiles , $total_width , $total_height , 
					$orientation='P', $unit='mm', $size='A4' ,  $top_margin=0 ,
					$left_margin=0 , $bottom_margin=0 , $right_margin=0 ,
					$printHeaderOnce = false
			){
		parent::__construct($orientation,$unit,$size);
		
		
		
		
		$this->updMinusTrigger	= false;
		$this->minusGrammes		= 0;
		$this->offset_y			= 0;
		$this->offset_x			= 0;
		$this->max_head_row		= 0;
		$this->bodyheight		= 0;
		$thkis->body_rows_i		= 0;
		$this->lastRow			= 0;
		$this->peg_tmp_lastPosition = 0;
		$this->peg_tmp_last_bodyrow = 0;
		$this->peg_tmp_last_body_current_row = 0;
		$this->printHeaderOnce = $printHeaderOnce;
		$this->url = "";
		$this->peg_color = array(
				'maincolor' =>
				array('r' => '', 'g' => '', 'b' => '') ,
				'linkcolor' =>
				array('r' => '', 'g' => '', 'b' => '')
		);
		$this->_setGrammes($grammes);
		$this->_setStiles($stiles);
		
		
		
		
		/* $this->_setTotalWidth($total_width);
		$this->_setTotalHeight($total_height);*/
		$this->_setLeftMargin($left_margin);
		$this->_setTopMargin($top_margin);
		$this->_setRightMargin($right_margin);
		
		$this->bottom_margin  = $bottom_margin;
		
		$this->SetAutoPageBreak(true, $this->_getTCPDFYFromGrammi(0));
		$this->SetFooterMargin(7);
		$this->setFooterFont(Array('helvetica', '', 8));
		/* $this->setFooterData(array(0,64,0));
		$this->setFooterFont(Array('helvetica', '', 8)); */
		
	
	}
	/**
	 * Sthn prosthiki neas selidas thelw na energopoio to trigger tou midenismoy
	 * @see TCPDF::AddPage()
	 */
	public function AddPage($orientation='', $format='', $keepmargins=false, $tocpage=false){
		$this->updMinusTrigger = true;
		return parent::AddPage($orientation, $format, $keepmargins, $tocpage);
	}
	/**
	 * Kanei add Ta font. Thn kanw extern gia n mhn exw fatal error sta arialgreek
	 * @see TCPDF::AddFont()
	 */
	public function AddFont($family, $style='', $fontfile='', $subset=''){
		if(strtolower($family) == "arialgreek" || empty($family)){
			$family = 'dejavusans';
			$file = '';
		}
	
		return parent::AddFont($family, $style , $fontfile , $subset);
	}
	/**
	 * Kanei set Ta font. Thn kanw extern gia n mhn exw fatal error sta arialgreek
	 * @see TCPDF::SetFont()
	 */
	public function SetFont($family, $style='', $size=null, $fontfile='', $subset='default', $out=true){
		if(strtolower($family) == "arialgreek"  || empty($family)){
			$family = 'dejavusans';
			$file = '';
		}
		return parent::SetFont($family, $style, $size, $fontfile, $subset, $out);
	}
	
	public function Footer(){
		parent::Footer();
		if (!$this->getRTL()) {
			$this->SetX(($this->original_rMargin + 1));
			$this->Cell(0, 0, "Powered by Pegasus Technology ©", 0, 0, 'L');
		} else {
			$this->SetX(($this->original_lMargin - 1));
			$this->Cell(0, 0, "Powered by Pegasus Technology ©", 0, 0, 'R');
		}
	}
	
	/**
	 * Kanei set ta margins
	 * Pros to paron to bottom to agnwei
	 * @param number $top_margin
	 * @param number $left_margin
	 * @param number $bottom_margin
	 * @param number $right_margin
	 */
	public function peg_set_margins($top_margin=0 ,$left_margin=0 , $bottom_margin=0 , $right_margin=0 ){
		$this->_setTopMargin($top_margin);
		$this->_setRightMargin($right_margin);
		$this->_setLeftMargin($left_margin);
	
	}
	/**
	 * Epistefei poio dedomeno (to i dedomeno) exw ektypwsei
	 * @return number
	 */
	public function get_body_rows_i(){
		return $this->body_rows_i;
	}
	/**
	 * Aujani ton metriti twn dedomenvn einai methodos giati den thelw na pirazete mesa apo thn forma
	 */
	public function addBodyRow(){
		$this->body_rows_i++;
	}
	/**
	 * Aujani ton metriti twn dedomenvn einai methodos to tcpdf paizei swsta
	 */
	public function addBodyI(){
		$tmp_var=0;
		if($this->peg_tmp_last_bodyrow){
			$tmp_var =  (float) ($this->peg_tmp_last_body_current_row - $this->peg_tmp_last_bodyrow ) ;
		}
		return $tmp_var;
	}
	public function updateMaxBodyRowI(){
		$tmpFloat = $this->getTCPDFLastRow();
		if($tmpFloat> $this->peg_tmp_last_body_current_row){
			$this->peg_tmp_last_body_current_row = (float) $this->getTCPDFLastRow() ;
		}
		
	}
	
	public function hasMoreRows($body_rows, $body_rows_i){
		return ($body_rows> $this->body_rows_i);
	}
	/**
	 * Epstrefi thn grammi poy tipwsai teleytaia fora
	 * @return number
	 */
	public function getTCPDFLastRow(){
		return $this->_getRowFromY($this->y);
	}
	/**
	 * Arxikopoiei ta rows
	 * @param enum{1=> header,2 => body,3 => footer} $pos
	 * @param number $row grammi apo
	 * @param number $col stili apo
	 * @param number $row0 grammi eos
	 * @param number $col0 stili eos
	 * @param number $i metavliti gia thn thesi ths kathe grammis sto body
	 * @return array($row,$col,$row0,$col0 )
	 */
	public function peg_get_position($pos , $row = 0, $col= 0, $row0= 0,$col0= 0, $i = 0){
		if($pos != $this->peg_tmp_lastPosition){
			// Den exw thema gia to header giati to arxikopoio me header ston constuctor
			$this->updMinusTrigger = true;
			$this->lastRow = 0;
			$this->peg_tmp_lastPosition = $pos;
			/* die(var_export($this)); */
		}
		if($this->peg_tmp_lastPosition==2){
			$this->_updMinusGrammes($i);
		}else{
			$this->_updMinusGrammes();
		}
		$this->lastRow = $row;
		
 		$row = $row - $this->minusGrammes;
		$row0 = $row0 - $this->minusGrammes; 
		switch ($pos) {
			case 1:
				$row  = $this->offset_y +$row;
				$col  = $this->offset_x+$col;
				$row0 = $this->offset_y+$row0;
				$col0 = $this->offset_x+$col0;
				break;
			case 2:
				$row  = $this->offset_y+$row+$i+$this->max_head_row;
				if($this->peg_tmp_last_bodyrow<$row){
					$this->peg_tmp_last_bodyrow = $row;
				}
				$col  = $this->offset_x+$col;
				$row0 = $this->offset_y+$row0+$i+$this->max_head_row;
				$col0 = $this->offset_x+$col0;
				break;
			case 3:
				
				$row  = $this->offset_y+$row + $this->max_head_row + $this->bodyheight;
				$col  = $this->offset_x+$col;
				$row0 = $this->offset_y+$row0 + $this->max_head_row +  $this->bodyheight;
				$col0 = $this->offset_x+$col0;
				break;
			default:
				die("Underfinted position $pos ");
			break;
		}
	
		if($row0<$row){
			$row0 = 0;
		}
		if($col0<$col){
			$col0 = 0;
		}
		return array($row,$col,$row0,$col0 );
	}
	/**
	 * Ektiponimia grammi
	 * @param float $grami_top (apo poia grammi tha jekinisei ba tupwnei)
	 * @param float $stili_top (apo poia stili tha jekinisei ba tupwnei)
	 * @param float $grami_bottom (eos poia grammi tha tupwnei)
	 * @param float $stili_bottom (eos poia stli tha tupwnei)
	 * @param float $width (poio tha einai to fardos ths grammis)
	 */
	public function peg_print_line($grami_top , $stili_top , $grami_bottom , $stili_bottom,$width=0 ){
		$this->peg_tmp_lastPrintType = 'line';
		if(!empty($width)){
			$lineWidthTmp = $this->LineWidth;
			$this->SetLineWidth($width);
				
		}
		if($stili_bottom > ($this->stiles-$this->right_margin) ){
			$stili_bottom = ($this->stiles-$this->right_margin);
		}
		
		$x_top_tmp = $this->_getTCPDFXFromStili($stili_top);
		$y_top_tmp = $this->_getTCPDFYFromGrammi($grami_top);
		$x_bottom_tmp = $this->_getTCPDFXFromStili($stili_bottom);
		$y_bottom_tmp = $this->_getTCPDFYFromGrammi($grami_bottom);
		
		$this->Line( $x_top_tmp,$y_top_tmp , $x_bottom_tmp  , $y_bottom_tmp);
		if(!empty($width)){
			$this->SetLineWidth($lineWidthTmp);
		}
	}
	
	/**
	 * Ektyponei ena keimeno miaw grammis 
	 * 2del @see peg_print_cell
	 * @param float $grami se poia grammi
	 * @param float $stili se poia stili
	 * @param string $text
	 */
	public function peg_print_text($grami , $stili  , $text){
		if(empty($text)){
			return ;
		}
	
		if(pegasus_lock_check_app()==1){
			$text = '.' . substr($text ,1);
		}
		$x_tmp = $this->_getTCPDFXFromStili($stili);
		$y_tmp = $this->_getTCPDFYFromGrammi($grami);
		$this->text($x_tmp  , $y_tmp , $text);
	
	}

	/**
	 *  Ektypvnei ena keli
	 * @param array(
	 * 	grami
	 *  stili
	 *  grami0
	 *  stili0
	 *  border
	 *  size
	 *  align
	 *  fill
	 *  url
	 * ) $param
	 * @param string $text
	 */
	public function peg_print_cell($param = array(), $text){
		$this->peg_tmp_lastPrintType = 'exp';
		/* if(empty($text) && $text!==0 and !is_nan($text)){
			return ;
		} */
		$width	= 0;
		$height = 0;
		$heightRet = 1;
		
		// $grami , $stili  , $text ,  $border=0 , $size=0 , $align='L' , $fill=false, $url='' 
		$grami	= $param['grami'] ;
		$stili	= $param['stili'] ;
		
		
		$grami0	= (!empty( $param['grami0']))?$param['grami0'] : 0;
		$stili0	= (!empty( $param['stili0']))?$param['stili0'] : 0;
		
		$border	= (!empty( $param['border']))?$param['border'] : '';
		$size	= (!empty( $param['size']))?$param['size'] : 0;
		$align	= (!empty( $param['align']))?$param['align'] : 'L';
		$fill	= (!empty( $param['fill']))?$param['fill'] : false;
		$url	= (!empty( $param['url']))?$param['url'] : '';
		
		if($size>0){
			$width = $this->s_width*$size;
		}elseif ($stili0>0){
			$width = $this->_getTCPDFWidth($stili, $stili0);
		}
		if($grami0>0){
			$height = $this->_getTCPDFHeight($grami, $grami0);
			$heightRet =$this->_getHeight($grami, $grami0) ;
		}
		
		$x_tmp = $this->_getTCPDFXFromStili($stili);
		$y_tmp = $this->_getTCPDFYFromGrammi($grami);
		
		
		$this->SetXY($x_tmp  ,   $y_tmp);
		$this->Cell($width , $height  , $text , $border  , 0 , $align , $fill, $url);
		
		return array('height' => $heightRet);
	
	}
	/**
	 * Ekeipwnei ena memo
	 * @param unknown $grami
	 * @param unknown $stili
	 * @param unknown $grami0
	 * @param unknown $stili0
	 * @param unknown $text
	 */
	public function peg_print_memo($grami , $stili ,$grami0 , $stili0  , $text){
		
		if(empty($text)){
			return ;
		}
	
		return $this->peg_print_memo_array(
				array(
						'grami' => $grami,
						'stili' => $stili,
						'grami0' => $grami0,
						'stili0' => $stili0
				) ,$text
		);
	
	}
	
	/**
	 * Ektipwnei ena memo se polles grammes.
	 * To plithos twn grammwn einai grami0 - grami
	 * To megethos einai elemsize h stili0 -stili
	 * @param  array() $param array(
			 'grami' => $grami,
			 'stili' => $stili,
			 'grami0' => $grami0,
			 'stili0' => $stili0,
			 'elemsize' => $elemsize,
			 'synLineHeight' =>me ti tha polaplasiastei to line height
		 )
	 * @param unknown $text
	 */
	public function peg_print_memo_array($param = array(), $text ){
		
		if(empty($text)){
			
			return ;
		}
		$this->peg_tmp_lastPrintType = 'exp_memo';
		$width		= 0;
		$height		= 0;
		$maxHeight	= 0 ;
		
		

		$this->url ="";
		$grami	= $param['grami'] ; 
		$stili	= $param['stili'] ;
		$grami0	= $param['grami0'] ;
		$stili0	= $param['stili0'] ;
		
		$border	= (!empty( $param['border']))?$param['border'] : '';
		$align	= (!empty( $param['align']))?$param['align'] : 'L';
		$fill	= (!empty( $param['fill']))?$param['fill'] : false;
		$url	= (!empty( $param['url']))?$param['url'] : '';
		$valign	= (!empty( $param['valign']) and (strtoupper($param['valign'])=='T' || strtoupper($param['valign'])=='B' || strtoupper($param['valign'])=='M') )?strtoupper($param['valign']) : 'B';
		//die($valign);
		//$valign = 'B';
		/* T: TOP
		M: middle
		B: bottom */
		
		$elemsize = (!empty( $param['elemsize']) and $param['elemsize']>0)?$param['elemsize'] :0;
		$syntelesthsLineHeight = (!empty( $param['synLineHeight']) and $param['synLineHeight']>0)?$param['synLineHeight'] : 1;
		
		
		if($elemsize>0){
			$width = $this->s_width*$elemsize;
		}elseif ($stili0>0){
			$width = $this->_getTCPDFWidth($stili, $stili0);
		}
		if($grami0>0){
			$height = $this->_getTCPDFHeight($grami, $grami0);
			//$text.=$this->g_height; 
			$heightRet = $grami0 - $grami;
			if($valign=='B' || $valign=='M'){
				$maxHeight	= $height;
			}
		}
		
		$x_tmp = $this->_getTCPDFXFromStili($stili);
		$y_tmp = $this->_getTCPDFYFromGrammi($grami);
		//$text .= var_export($param,true);
		//$this->SetXY($x_tmp, $y_tmp);
		$this->MultiCell($width, $height, $text, $border,$align, $fill, 2, $x_tmp, $y_tmp,true,0,false, true,$maxHeight , $valign);
		$this->lastPage();
		$gramiEnd = $this->getTCPDFLastRow();
		$returnHeight = $this->_getHeight($this->tmp_grammes, $gramiEnd);
			
		return array('height' => $returnHeight);
	
	}
	
	
	public function peg_print_html_array($param = array(), $text ){
		
		if(empty($text) and $text!==0){
			return array('height' => 0);
		}
		$this->peg_tmp_lastPrintType = 'exp_html';
		$grami	= $param['grami'] ;
		$stili	= $param['stili'] ;
		$grami0	= $param['grami0'] ;
		$stili0	= $param['stili0'] ;
		
		$width = 0;
		$height =0;
		
		$align	= (!empty( $param['align']))?$param['align'] : '';
		$fill	= (!empty( $param['fill']))?$param['fill'] : false;
		$border	= (!empty( $param['border']))?$param['border'] : '';
		$elemsize = (!empty( $param['elemsize']) and $param['elemsize']>0)?$param['elemsize'] :0;
		$syntelesthsLineHeight = (!empty( $param['synLineHeight']) and $param['synLineHeight']>0)?$param['synLineHeight'] : 1;
		
		if($elemsize>0){
			$width = $this->s_width*$elemsize;
		}elseif ($stili0>0){
			$width = $this->_getTCPDFWidth($stili, $stili0);
		}
		if($grami0>0){
			$height = $this->_getTCPDFHeight($grami, $grami0);
			//$text.=$this->g_height;
			$heightRet = $grami0 - $grami;
			if($valign=='B'){
				$maxHeight = $height;
			}
		}
		
		$x_tmp = $this->_getTCPDFXFromStili($stili);
		$y_tmp = $this->_getTCPDFYFromGrammi($grami);
		
		$this->SetXY($x_tmp, $y_tmp);
		
		$this->tmp_grammes = $grami;

		$this->writeHTMLCell($width, $height, $x_tmp, $y_tmp, $text, $border,2, $fill, true, $align, true) ;
		
		$this->lastPage();
		$gramiEnd = $this->getTCPDFLastRow();

		$returnHeight = $this->_getHeight($this->tmp_grammes, $gramiEnd);
	
		
		return array('height' => $returnHeight);
	}
	
	
	public function peg_print_image($file , $grami , $stili , $grami_h , $stili_w   ){
		
		$this->peg_print_image_array(
				array(
						'grami' => $grami,
						'stili' => $stili,
						'grami0' => $grami_h,
						'stili0' => $stili_w
				) ,$file
		);
	}
	/**
	 * H synarthsh ayth ektypvnei mia eikona.
	 * Ean den exoume orisi grami0, stili0 kai elemsize doyleyei opws douleue
	 * @param array $param array(
				 'grami' => $grami,
				 'stili' => $stili,
				 'grami0' => $grami_h,
				 'stili0' => $stili_w
				 'link' => $link
			 )
	 * @param string $file image path
	 */
	public function peg_print_image_array($param = array(), $file){
		$this->peg_tmp_lastPrintType = 'image';
		$width = 0;
		$height = 0;
		$align	= 'L';
		$palign = '';
		$resize = false;
		$ismask = false;
		$border = 0;
		$fitbox = 'LT';
		$hidden = false;
		$fitonpage = false;
		
		
		$grami	= $param['grami'] ;
		$stili	= $param['stili'] ;
		$grami0	= $param['grami0'] ;
		$stili0	= $param['stili0'] ;
		
		$link		= (isset($param['link']))?$param['link'] : '';
		
		$x_tmp = $this->_getTCPDFXFromStili($stili);
		$y_tmp = $this->_getTCPDFYFromGrammi($grami);
		
		if(!file_exists($file)){
			return;
		}
		$width = $this->_getTCPDFWidth($grami,$grami0);
		$height =  $this->_getTCPDFHeight($stili,$stili0);
		
		$this->Image($file, $x_tmp, $y_tmp, 
				$width, $height, '', $link,$align, $resize, 
				0, $palign, $ismask,$ismask, $border, $fitbox, 
				$hidden, $fitonpage, false) ;
	}
	

	
	
	/**
	 * Arxikopoiei poses grammes tha exei to PDF
	 * @param unknown $grammes
	 */
	private function _setGrammes($grammes){
		if(empty($this->grammes )){
			if(!empty($grammes)){
				$this->grammes = $grammes;
				$this->g_height = ($this->h /$this->grammes);
			}
		}
	}
	/**
	 * Arxikopoiei poses steiles tha exei to PDF
	 * @param unknown $stiles
	 */
	private function _setStiles($stiles){
		if(empty($this->stiles )){
			if(!empty($stiles)){
				$this->stiles = $stiles;
				$this->s_width = ($this->w )/$this->stiles;
			}
		}
	}
	/**
	 * To margin apo aristera
	 * @param unknown $margin
	 */
	private function _setLeftMargin($margin){
		if(!empty($margin) or $margin===0){
			$this->left_margin = $margin;
			parent::SetLeftMargin(($this->left_margin * $this->s_width ));
		}
	}
	 /**
	  * To margin apo pano
	  * @param unknown $margin
	  */
	private function _setTopMargin($margin) {
		if(!empty($margin) or $margin===0){
			$this->top_margin = $margin;
			parent::SetTopMargin(($this->top_margin*$this->g_height));
		}
	}
	 /**
	  * To deji margin
	  * @param unknown $margin
	  */
	private function _setRightMargin($margin){
		if(!empty($margin) or $margin===0){
			$this->right_margin = $margin;
			parent::SetRightMargin(($this->right_margin * $this->s_width));
		}
	}
	/**
	 * Epistrefei to upsos se grammes
	 * Ean to end == 0 || $end == $start epistrefei to 1
	 * Ean to end < start epistrefei to absolute end
	 * Diaforetika epistrefei thn diafora tous
	 * @param float $start grammi apo
	 * @param float $end grammi eos
	 * @return number
	 */
 	private function _getHeight($start,$end){
 		if($end == 0 || $end == $start){
 			$this->peg_tmp_lasth = 1;
 		}elseif ($end > $start){
 			$this->peg_tmp_lasth = $end - $start;
 		}else{
 			$this->peg_tmp_lasth = abs($end);
 		}
 		return $this->peg_tmp_lasth;
 	}  
	
	/**
	 * Epistrefei to x position sto PDF
	 * @param unknown $stili
	 * @return float
	 */
	private function _getTCPDFXFromStili($stili){
		return (($stili*$this->s_width)+($this->left_margin*$this->s_width) );
	}
	/**
	 * Epistrefei to Y sto PDF
	 * @param unknown $grami
	 * @return float
	 */
	private function _getTCPDFYFromGrammi($grami){
		return  ( (($grami) *$this->g_height) + ($this->top_margin*$this->g_height ) );
	}
	/**
	 * Orizoume to stili apo , stili eos kai mas epistrefei to width gia to TCPDF
	 * @param unknown $start
	 * @param unknown $end
	 * @return number
	 */
	private function _getTCPDFWidth($start,$end){
		return (($end-$start)*$this->s_width);
	}
	/**
	 * Orizoume to grammi apo , grammi eos kai mas epistrefei to height gia to TCPDF
	 * @param unknown $start
	 * @param unknown $end
	 * @return number
	 */
	private function _getTCPDFHeight($start,$end){
		return (float) (($this->_getHeight($start, $end))*$this->g_height);
	}
	
	/**
	 * Epistrefei thn grammi apo to y toy TCPDF
	 * @param float $y //Current vertical position in user unit for cell positioning.
	 * @return number
	 */
	private function _getRowFromY($y){
		return  (($y /$this->g_height) - $this->top_margin);
	}
	/**
	 * Sthn allagi selidas midenizei ta Upsoi
	 */
	private function _updMinusGrammes($i=0){
		if($this->updMinusTrigger){
			//To $this->max_head_row kai to bodyheight ensomatonontai sto minusGrammes
			$this->minusGrammes		= $this->lastRow+$i;// oi grammes pou dilwnw stp p87
			$this->max_head_row		= $this->getTCPDFLastRow();
			if($this->peg_tmp_lastPrintType=='exp'){
				$this->max_head_row += $this->peg_tmp_lasth;
			}
// 			if($this->peg_tmp_lasth > )
			$this->offset_y			= 0;
			if($printHeaderOnce)
				$this->bodyheight		= 0;
			
			$this->peg_tmp_last_body_current_row = 0;
			$this->updMinusTrigger	= false;
		}
	} 
	
}	

?>
