<?php
class pegConfigFile {
    /**
     * 
     * @var string
     */
    private static $tmpPath = '/tmp/pegconf/';
    /**
     * 
     * @var array
     */
    private static $paramConfig = array(
        'DB_HOST',
        'DB_USER',
        'DB_PASSWORD',
        'DB_NAME',
        'DEBUGIP'
    ); 
    
    private $cor000Config ;
    private $mySQLConfig ;
    private $customConfig ;
    
    public static function generateMysqlConfigString($dbHost, $mysqlUser, $mysqlPassword, $DBName) {
        return <<<MYSQLCOND

//Start MySQL configuration

define('DB_HOST'     , '$dbHost');
define('DB_NAME'     , '$DBName');
define('DB_USER'     , '$mysqlUser');
define('DB_PASSWORD' , '$mysqlPassword');

//End MySQL configuration

MYSQLCOND;
    }
        
    public static function generateCore000ConfigString($debug_ip = '', $httpsOnly = 0) { 
        return <<<COR000COND

//Start cor000 configuration
/** 
 * You can modify this configuration only from backend
 */
define('DEBUGIP'     , '$debug_ip');
define('HTTPSONLY'     , '$httpsOnly');


//End cor000 configuration

COR000COND;
    }
        
    public static function generateSMEConfigString($is_pdo=0) {
        $db_api = '';
        if($is_pdo){
            $db_api = 'PDO';
        }
        $appdir = peg_get_app_folder();
        $forcePeg002Redirect = false;
        if( defined('FORCE_PEG002_REDIRECT') && FORCE_PEG002_REDIRECT == true){
            $forcePeg002Redirect = true;
        }
       $forcePeg002RedirectStr = $forcePeg002Redirect?'true':'false';
        return <<<SMECOND
        
//Start SME
define('WEBAPP_MAIN_PATH'     , '$appdir');
define('DB_API' , '$db_api');
define('FORCE_PEG002_REDIRECT'     , $forcePeg002RedirectStr);
//End SME

SMECOND;
    }
        
    public static function validateSMEConfig($smeConfig = ''){
        //TODO
    }
    
    public function __construct($is_pdo=0){
        $this->customConfig = '';
        $this->mysqlConfig = '';
        $this->cor000Config = '';
        
        if(file_exists('../peg-config.php')){
            $file = peg_read_file('../peg-config.php');
            $this->customConfig  = peg_strSearchBetween($file, '//Start SME', '//End SME');
            $this->mysqlConfig   = peg_strSearchBetween($file, '//Start MySQL configuration', '//End MySQL configuration');
            $this->cor000Config  = peg_strSearchBetween($file, '//Start cor000 configuration', '//End cor000 configuration');
        }
        
        if(empty($this->mysqlConfig)){
            $this->mysqlConfig = pegConfigFile::generateMysqlConfigString(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);
        }
        if(empty($this->customConfig)){
            $this->customConfig = pegConfigFile::generateSMEConfigString($is_pdo);
        }
        
        
    }
    
    public function updateCor000($data){ 
        $debug_ip   = '';
        $httpsOnly  = 0;
        if(is_array($data)){ 
            if(!empty($data['debug_ip'])){ 
                $debug_ip = str_replace(' ', '',  $data['debug_ip']);
            }
            
            if(!empty($data['https_only'])){
                $httpsOnly = ( $data['https_only'] > 0 )?1:0;
            }
        } 
        $this->cor000Config = pegConfigFile::generateCore000ConfigString($debug_ip, $httpsOnly);
    }
   
    
    public function generateConfigurationFile() {
        $fileContent = '';
        
        if(!is_dir('../../tmp/')){
            mkdir('../../tmp/' , 0777 , true);
        }
        
        ///TODO MAKE with explode
        if(!is_dir('../..' . pegConfigFile::$tmpPath)){ 
            mkdir('../..'. substr(pegConfigFile::$tmpPath, 0,-1), 0777 , true);
        }		 
       
        
        $fileContent .= 
        "<?php \n" . $this->cor000Config .$this->mysqlConfig .$this->customConfig . "\n ?>";
        peg_write_file('../..' . pegConfigFile::$tmpPath.'peg-def.php' , $fileContent);
    }
    
    public function checkFTP() {

        if( $this->_checkCopyFile()){
            peg_write_file('../..' . pegConfigFile::$tmpPath.'peg-config.php' , peg_read_file('../..'. pegConfigFile::$tmpPath.'/peg-def.php'));
        }else{

            $dst_dir =  $_SESSION['cor000_ftp_path'] . pegConfigFile::$tmpPath.'peg-config.php' ;
            
            $src_dir = '../../'. pegConfigFile::$tmpPath.'/peg-def.php' ; 
            $src_dir = realpath($src_dir);
 
            $conn_id = pegasus_core_ftp_connect(); 
            if($conn_id === FALSE){ 
                pegasus_delete_directory('../..' . pegConfigFile::$tmpPath);
                return false;
            }  
 
            $upload = ftp_put($conn_id,  $dst_dir , $src_dir , FTP_BINARY); // put the files
            if($upload === FALSE){
                pegasus_delete_directory('../..' . pegConfigFile::$tmpPath);
                return false;
            }  
            ftp_close($conn_id);
        }

        $file1 = peg_read_file('../..' . pegConfigFile::$tmpPath.'peg-def.php');
        $file2 = peg_read_file('../..' . pegConfigFile::$tmpPath.'peg-config.php');


        // echo '../..' . pegConfigFile::$tmpPath.'peg-def.php';
        // echo '../..' . pegConfigFile::$tmpPath.'peg-config.php';

        if($file1!=$file2 || empty($file2)){ 
            pegasus_delete_directory('../..' . pegConfigFile::$tmpPath);
            return false;
        }
        return true;
    }
    

    public function _checkCopyFile(){
        $text =  rand(0,99999999999);
        peg_write_file('../peg-config-test.php' ,$text);
        if( $text == peg_read_file('../peg-config-test.php')){
            
            return true;
        } 
        return false;
    }


    public function uploadFTP() {
        

        $peg_get_fld = '';
        if(strpos(peg_get_app_folder(), '/')>0){
            $peg_get_fld_arr = explode( '/'  ,peg_get_app_folder());
            $peg_get_fld = $peg_get_fld_arr[count($peg_get_fld_arr)-1];
        }else{
            $peg_get_fld = peg_get_app_folder();
        }
        $dst_dir =   $_SESSION['cor000_ftp_path'] .'/'. $peg_get_fld . '/peg-config.php';
        
        $src_dir = '../../'. pegConfigFile::$tmpPath.'/peg-config.php' ;
        $src_dir = realpath($src_dir);
        
        if(!file_exists('../..' . pegConfigFile::$tmpPath.'peg-config.php')){
            return false;
        }


        if( $this->_checkCopyFile()){
            peg_write_file('../peg-config.php' ,peg_read_file('../..' . pegConfigFile::$tmpPath.'peg-config.php'));
            pegasus_delete_directory('../..' . pegConfigFile::$tmpPath);
            return true;
        }

        $conn_id = pegasus_core_ftp_connect();
        if($conn_id === FALSE){
            return false;
        }  
        $upload = ftp_put($conn_id,  $dst_dir , $src_dir , FTP_BINARY); // put the files
        if($upload === FALSE){
            
            return false;
        } 
        ftp_close($conn_id);
        pegasus_delete_directory('../..' . pegConfigFile::$tmpPath);
        return true;
    }
    
}