DROP FUNCTION IF EXISTS peg_abschr;
/*peg_end*/

/********************************************************************/
CREATE FUNCTION peg_abschr (_str TEXT /*character set Greek */,
                            _nochr TEXT /*character set Greek */
                            )

RETURNS TEXT /*character set Greek */
/********************************************************************
transform a character string to keyboard same characters
_str = string to be transformed
_nochr = string of characters to be deleted fromm _str
*********************************************************************/

BEGIN
    DECLARE _newchr TEXT /*character set Greek */;
    DECLARE _achr TEXT /*character set Greek */;
    DECLARE _nchr TEXT /*character set Greek */;
    DECLARE _ii bigint(10);
    DECLARE _aascii bigint(10);
    DECLARE _len bigint(10);


    SET _len=CHAR_LENGTH(_str);
    SET _newchr='';
    SET _ii=1;

    WHILE _ii<=_len DO
         SET _achr=substring(_str, _ii, 3);
         SET _nchr=_achr;        

         IF locate(_achr, _nochr)<>0
         THEN
               SET _nchr='';
         ELSE     
               SET _aascii = ord(_achr);
               SET _nchr = if( _aascii IN (162, 182, 193, 220, 225),  'A', _nchr);
               SET _nchr = if( _aascii IN (194, 226),            'B', _nchr);
               SET _nchr = if( _aascii IN (248, 216),            'C', _nchr);
               SET _nchr = if( _aascii IN (228, 196),            'D', _nchr);
               SET _nchr = if( _aascii IN (184, 197, 221, 229),  'E', _nchr);
               SET _nchr = if( _aascii IN (246, 214),            'F', _nchr);
               SET _nchr = if( _aascii IN (227, 195),            'G', _nchr);
               SET _nchr = if( _aascii IN (231, 222, 199, 185),  'H', _nchr);
               SET _nchr = if( _aascii IN (233, 223, 201, 186, 250, 218), 'I', _nchr);
               SET _nchr = if( _aascii IN (238, 206),            'J', _nchr);
               SET _nchr = if( _aascii IN (234, 202),            'K', _nchr);
               SET _nchr = if( _aascii IN (235, 203),            'L', _nchr);
               SET _nchr = if( _aascii IN (236, 204),            'M', _nchr);
               SET _nchr = if( _aascii IN (237, 205),            'N', _nchr);
               SET _nchr = if( _aascii IN (239, 252, 207, 188),  'O', _nchr);
               SET _nchr = if( _aascii IN (240, 208),            'P', _nchr);
               SET _nchr = if( _aascii IN (241, 209),            'R', _nchr);
               SET _nchr = if( _aascii IN (243, 211, 242),       'S', _nchr);
               SET _nchr = if( _aascii IN (244, 212),            'T', _nchr);
               SET _nchr = if( _aascii IN (232, 200),            'U', _nchr);
               SET _nchr = if( _aascii IN (249, 254, 217, 191),  'V', _nchr);
               SET _nchr = if( _aascii IN (247, 215),            'X', _nchr);
               SET _nchr = if( _aascii IN (245, 253, 213, 190, 251, 219), 'Y', _nchr);
               SET _nchr = if( _aascii IN (230, 198),            'Z', _nchr);
        END IF;   

        SET _newchr=concat(_newchr, _nchr);
        SET _ii= _ii+1;

    END WHILE;
    RETURN upper(_newchr);

END;
/*peg_end*/

DROP FUNCTION IF EXISTS peg_only_num;
/*peg_end*/

/********************************************************************/
CREATE FUNCTION peg_only_num (_string TEXT )
/********************************************************************
clears a string and holds only numbers (digits)
_string = string to be cleared
*********************************************************************/

RETURNS TEXT DETERMINISTIC
BEGIN
    
    DECLARE loc_string TEXT;
    DECLARE loc_len INT DEFAULT 0;
    DECLARE loc_i INT DEFAULT 0;
    DECLARE loc_chr CHAR DEFAULT '';

    SET loc_string='';
    SET loc_len=length(_string);
    SET loc_i=1;

    WHILE loc_i <=loc_len DO

       SET loc_chr=substr(_string, loc_i, 1);
       IF locate(loc_chr, '0123456789')<>0 THEN       
           SET loc_string=concat(loc_string, loc_chr);
       END IF;    
   
       SET loc_i=loc_i+1;
    END WHILE;    

    RETURN loc_string; 
END;
/*peg_end*/


DROP FUNCTION IF EXISTS peg_new_nr01;
/*peg_end*/

/********************************************************************/
CREATE FUNCTION peg_new_nr01 (_table CHAR(50), _counter BIGINT(15) )
/********************************************************************
updates table p75 with a counter and returns the new nr01 value for a table. 

_table = table name to find new nr01 for
_counter = value to be added. If missed =1 
*********************************************************************/

RETURNS bigint(15) DETERMINISTIC
BEGIN
  
    DECLARE loc_minnr01 bigint(15);
    DECLARE loc_maxp75 bigint(15);
    /* loc_nr01 used for return value*/
    SET @loc_nr01=0;

    /* loc_minnr01 = cor000.min_nr01 */
    SET loc_minnr01=ifnull((select min_nr01 from cor000 where nr01=1), 0);

    /* loc_maxp75 = max(nr01) from p50 */
    SET loc_maxp75=ifnull((select max(nr01) from p75), loc_minnr01);
    
    SET loc_maxp75 = loc_maxp75+1;
    SET _counter= if(_counter<=0, 1, _counter);
   
    SET loc_minnr01 =if(_table='p70' , 0 ,  loc_minnr01);
     
    IF ( select nr01 FROM p75 where p01=_table ) IS NULL 
    THEN 
	
        INSERT INTO p75 (nr01, p01, p010)    
	VALUES (loc_maxp75, _table, 0);
 
    END IF;               

    UPDATE p75
    SET p010 = @loc_nr01:=greatest(p010 + _counter, loc_minnr01)
    WHERE p01=_table;
    
    RETURN @loc_nr01; 

END;
/*peg_end*/



DROP FUNCTION IF EXISTS peg_module_exists;
/*peg_end*/

/********************************************************************/
CREATE FUNCTION peg_module_exists (_module CHAR(50) )
/********************************************************************
checks if is enabled a module
_module = module name to look for
Returns 1 if exists
*********************************************************************/

RETURNS tinyint(1) DETERMINISTIC
BEGIN

    SET @loc_nr01=ifnull((select en from p55 where p00=_module), 0);

    RETURN @loc_nr01; 


END;
/*peg_end*/

DROP function IF EXISTS `peg_get_month`;
/*peg_end*/
/********************************************************************/
CREATE FUNCTION peg_get_month (_month INT,_lang CHAR(3) ) 
/********************************************************************
Return the month dic
_month = The number of month [1-12]
_lang = The _lang to return the dic (GR || EN)
Returns 1 if exists
*********************************************************************/
	RETURNS text CHARSET utf8
	BEGIN
	DECLARE loc_lang TEXT CHARACTER SET utf8 ;
	DECLARE ret_str TEXT CHARACTER SET utf8 ;
		
		SET ret_str = '';
		SET loc_lang = LOWER(_lang);
        
        IF loc_lang = "gr" THEN
			CASE _month
				WHEN 1 THEN SET ret_str = "Ιανουάριος";
				WHEN 2 THEN SET ret_str = "Φεβρουάριος";
				WHEN 3 THEN SET ret_str = "Μάρτιος";
				WHEN 4 THEN SET ret_str = "Απρίλιος";
				WHEN 5 THEN SET ret_str = "Μάιος";
				WHEN 6 THEN SET ret_str = "Ιούνιος";
				WHEN 7 THEN SET ret_str = "Ιούλιος";
				WHEN 8 THEN SET ret_str = "Αύγουστος";
				WHEN 9 THEN SET ret_str = "Σεπτέμβριος";
				WHEN 10 THEN SET ret_str = "Οκτώβριος";
				WHEN 11 THEN SET ret_str = "Νοέμβριος";
				WHEN 12 THEN SET ret_str = "Δεκέμβριος";
			END CASE;
        ELSE 
			CASE _month
				WHEN 1 THEN SET ret_str = "January";
				WHEN 2 THEN SET ret_str = "February";
				WHEN 3 THEN SET ret_str = "March";
				WHEN 4 THEN SET ret_str = "April";
				WHEN 5 THEN SET ret_str = "May";
				WHEN 6 THEN SET ret_str = "June";
				WHEN 7 THEN SET ret_str = "July";
				WHEN 8 THEN SET ret_str = "August";
				WHEN 9 THEN SET ret_str = "September";
				WHEN 10 THEN SET ret_str = "October";
				WHEN 11 THEN SET ret_str = "November";
				WHEN 12 THEN SET ret_str = "December";
			END CASE;
        END IF;
    
	RETURN ret_str;
	END;
/*peg_end*/

DROP function IF EXISTS `peg_get_day`;
/*peg_end*/

CREATE FUNCTION `peg_get_day`(_day INT,_lang CHAR(3)) 
/********************************************************************
Return the day dic
_month = The number of day [0-6] 0 => Sunday
_lang = The _lang to return the dic (GR || EN)
Returns 1 if exists
*********************************************************************/
RETURNS text CHARSET utf8
BEGIN
	DECLARE loc_lang TEXT CHARACTER SET utf8 ;
	DECLARE ret_str TEXT CHARACTER SET utf8 ;
    
    SET ret_str = '';
	SET loc_lang = LOWER(_lang);
    
		IF loc_lang = "gr" THEN
			CASE _day
				WHEN 0 THEN SET ret_str = "Κυριακή";
				WHEN 1 THEN SET ret_str = "Δευτέρα";
				WHEN 2 THEN SET ret_str = "Τρίτη";
				WHEN 3 THEN SET ret_str = "Τετάρτη";
				WHEN 4 THEN SET ret_str = "Πέμπτη";
				WHEN 5 THEN SET ret_str = "Παρασκευή";
				WHEN 6 THEN SET ret_str = "Σάββατο";
			END CASE;
        ELSE 
			CASE _day
				WHEN 0 THEN SET ret_str = "Sunday";
				WHEN 1 THEN SET ret_str = "Monday";
				WHEN 2 THEN SET ret_str = "Tuesday";
				WHEN 3 THEN SET ret_str = "Wednesday";
				WHEN 4 THEN SET ret_str = "Thursday";
				WHEN 5 THEN SET ret_str = "Friday";
				WHEN 6 THEN SET ret_str = "Saturday";
			END CASE;
        END IF;
RETURN ret_str;
END;
/*peg_end*/
DROP PROCEDURE IF EXISTS pegasusSetSuperGlobalVar;
/*peg_end*/

CREATE PROCEDURE pegasusSetSuperGlobalVar (IN _var_name CHAR(150), IN _var_value LONGTEXT  )
begin
				INSERT INTO p73 
					(sess_id,var_name,var_value,remdate,remtime,remuser,remfdate,remftime,remfuser)
				VALUES 
					(@mysql_superglobal_var_sess_id, _var_name,	ifnull(_var_value,0), curdate(),curtime(),	@mysql_superglobal_var_remuser ,curdate(),	curtime(),	@mysql_superglobal_var_remuser  )
				ON DUPLICATE KEY UPDATE
          var_value=_var_value,
          remdate=curdate(), 
          remtime=curtime(), 
          remuser=@mysql_superglobal_var_remuser;
end;
/*peg_end*/

DROP PROCEDURE IF EXISTS pegasusUnSetSuperGlobalVar;
/*peg_end*/

CREATE PROCEDURE pegasusUnSetSuperGlobalVar (IN _var_name CHAR(150) )
begin
			DELETE FROM p73 WHERE var_name=_var_name and sess_id=@mysql_superglobal_var_sess_id;
end;
/*peg_end*/
DROP FUNCTION IF EXISTS pegasusGetSuperGlobalVar;
/*peg_end*/

CREATE FUNCTION pegasusGetSuperGlobalVar ( _var_name CHAR(150) )
RETURNS LONGTEXT DETERMINISTIC
BEGIN
    DECLARE _var_value LONGTEXT DEFAULT ''; 

    SET _var_value:=( select var_value FROM p73 WHERE var_name=_var_name and sess_id=@mysql_superglobal_var_sess_id );
    
    
    RETURN _var_value; 
END;
/*peg_end*/