<?php

require_once('../crm000_libs/crm000_ics.php');


function crm000_after_update(){
	//Τρέχουμε την παρακάτω αλλαγή για version <= 2.30
	//Εισαγωγή δεδομένων στους πίνακες crm000_02, crm000_03 (Κωδικοί Περιφερειών, Κωδικοί Τηλεφώνων Χωρών)
	pegasus_mysql_use('select rel, ver from p55 where p00="crm000"', $version);

	if($version['ver'] == 2 && $version['rel'] <= 30) {
		$has_records_02 = pegasus_mysql_printfld('crm000_02', 'count(*)', '1=1');
		if($has_records_02 < 1) {
			//upload.sql
			pegasus_mysql_upload_sql('../crm000_sql/crm000_02.sql');
			//remake crm000_02
			pegasus_mysql_remake_p75('crm000_02');
			pegasus_change_stracture('crm000_02' , 'crm000_02_d' , 'crm000', 1);
		}
		$has_records_03 = pegasus_mysql_printfld('crm000_03', 'count(*)', '1=1');
		if($has_records_03 < 1) {
			//upload.sql
			pegasus_mysql_upload_sql('../crm000_sql/crm000_03.sql');
			//remake crm000_03
			pegasus_mysql_remake_p75('crm000_03');
			pegasus_change_stracture('crm000_03' , 'crm000_03_d' , 'crm000', 1);
		}
	}

	if(pegasus_mysql_printfld('d32','COUNT(nr01)','p013 = 0') == 0) {
		pegasus_mysql_update(
			'd32',
			array('p013'),
			array(1),
			'nr01 > 0'
		);
	}

	if($version['ver'] == 2 && $version['rel'] <= 54) {
		if(file_exists('../crm000_01/crm000_ics_create.php')) {
			unlink('../crm000_01/crm000_ics_create.php');
		}
		
	}

	if($version['ver'] == 2 && $version['rel'] <= 73) {
		pegasus_mysql_update(
			'd40',
			array('p400'),
			array(1),
			'nr01 > 0'
		);
	}
}
/**
 * H synarthsh elegxei ean to AMKA einai swsto
 * @param string $amka 
 * @return boolean
 */
function peg_crm000_checkAmka($amka=""){
	$amka = trim($amka);//Gia na kanei kai cast se int
	// 	echo strlen($amka);
	if(empty($amka) || strlen($amka)!=11 ){
		return false;
	}
	$amkaSum = 0;
	for ($i = 0; $i < 11; $i++) {
		if($i%2 == 0 ){
			//Ean einai se zigi * 1
			$tmpint = $amka[$i] * 1;
		}else{
			//Ean einai se mono * 2
			$tmpint = $amka[$i] * 2;
		}
		if($tmpint>9){
			$tmpstr = (string) $tmpint ;//Gia na to xiristw ws string
			$tmpint = $tmpstr[0] + $tmpstr[1];
				
		}

		$amkaSum+=$tmpint;
	}
	if(($amkaSum%10) == 0){
		return true;
	}
	return false;
}

function crm000_d99103_d_initialize($data,$mmnr01,$mnr01,$_d,$container_id){
	if(empty($data['nr01'])){
	    $data['p01_readonly']=0;
	}else{
	    $data['p01_readonly']=1;
	}
	return $data;
}

function peg_crm000_d99103_d_onsave($data, $permDeny , $mmnr01 , $checkOnlyPerm){
	if($data['p100']==1){
		pegasus_mysql_use('select count(*) as tot from d99103 where p01!=:p01 and p100=1', $d99103, array('p01'=> $data['p01']));
		if($d99103['tot']>0){
			array_push( $permDeny , array( 'type'=>'deny' , 'message'=> $_SESSION['peg_dic_crm000_d99103_p100_deny']));
		}
	}
	return array($data , $permDeny);
}


function crm000_d32_d_initialize($data,$mmnr01='',$mnr01='',$_d='',$container_id=''){
	$new_rec = 0;
	if (empty($data['nr01'])) {
		$new_rec = 1;
	}

	return $data;
}

/**
 *
 * @param  integer $nr01
 * @return void
 */
function crm000_crm000_04_d_prepear_send(
	$nr01 = 0
) {
	$crm000_04 = array();
	pegasus_mysql_use("SELECT * FROM crm000_04 WHERE nr01 = :nr01",$crm000_04,array('nr01' => $nr01));
	if(!($crm000_04['nr01'] > 0)) {
		return array(
			'ok'	=> 0,
			'msg'	=> $_SESSION['peg_dic_crm000_crm000_04_not_found']
		);
	}
	$summary = array();
	if(!empty($crm000_04['p14'])) {
		$summary[] = $crm000_04['p14'];
	}
	if(!empty($crm000_04['p03'])) {
		$summary[] = $crm000_04['p03'];
	}
	$data = array(
		'SUMMARY'		=> array('value' => implode(" - ",$summary)),
		'UID'			=> array('value' => $crm000_04['p04']),
		'SEQUENCE'		=> array('value' => $crm000_04['p05']),
		'STATUS'		=> array('value' => $crm000_04['p13']),
		'LOCATION'		=> array('value' => $crm000_04['p11']),
		'DESCRIPTION'	=> array('value' => nl2br($crm000_04['p12']))
	);
	if(empty($crm000_04['p09'])) {
		$data['DTSTART'] = array('value' => "{$crm000_04['p00']} {$crm000_04['p07']}");
		$data['DTEND'] = array('value' => "{$crm000_04['p00']} {$crm000_04['p08']}");
	} elseif($crm000_04['p09'] == 'ALLDAY') {
		$data['ALLDAY'] = array('value' => $crm000_04['p00']);
	} else {
		$data['DTSTART'] = array('value' => "{$crm000_04['p00']} {$crm000_04['p07']}");
		$data['DURATION'] =array('value' => $crm000_04['p09']);
	}
	if(
		!empty($crm000_04['p15'])
		&& !empty($crm000_04['p16'])
	) {
		$data['ORGANIZER'] = array(
			'attribute' => "CN={$crm000_04['p15']}",
			'value' => "mailto:{$crm000_04['p16']}"
		);
	}
	$ics = new crm000_ics();
	$ics->data_set($data);
	$ics_str = $ics->export();
	$attach_folder = '../../tmp/'.session_id().'/mail/attachments/'.date('YmdHis').'_'.$nr01.'/';
	if(!is_dir($attach_folder)) {
		mkdir(
			$attach_folder,
			0777,
			true	
		);
	}
	peg_write_file($attach_folder.'/invite.ics' , $ics_str); 
	$mail02_nr01 = 0;
	$mail02_check = pegasus_mysql_printfld('mail02', 'nr01', 'p50=:p50', array('p50' => 'd01'));
	if($mail02_check > 0) {
		$mail02_nr01 = $mail02_check;
	}
	return array(
		'ok'	=> 1,
		'data'	=> array(
			'table'			=> $crm000_04['p01'],
			'nr01'			=> $crm000_04['p02'],
			'mail02'		=> $mail02_nr01,
			'p85'			=> 0,
			'attach_folder'	=> $attach_folder
		),
		'msg'	=> 'Success'
	);
}
/**
 *
 * @param  array   $data
 * @param  string  $mmnr01
 * @param  integer $mnr01
 * @param  string  $_d
 * @param  string  $container_id
 * @return array
 */
function crm000_04_d_initialize(
	$data = array(),
	$mmnr01 = '',
	$mnr01 = 0,
	$_d = '',
	$container_id = ''
) {
	global $PegInput;
	$request = array();
	$PegInput->addVar(new peg_input_alphanumeric('p00'));
	$PegInput->addVar(new peg_input_alphanumeric('p07'));
	$PegInput->addVar(new peg_input_alphanumeric('p08'));
	$PegInput->addVar(new peg_input_number('d01_p05'));
	$PegInput->addVar(new peg_input_number('d01_p06'));
	$request = array(
		'p00'		=> $PegInput->getRequest('p00'),
		'p07'		=> $PegInput->getRequest('p07'),
		'p08'		=> $PegInput->getRequest('p08'),
		'd01_p05'	=> $PegInput->getRequest('d01_p05'),
		'd01_p06'	=> $PegInput->getRequest('d01_p06')
	);
	$new_rec = false;
	if(!(pegasus_mysql_printfld('crm000_04','nr01','nr01 = :nr01',array('nr01' => $data['nr01'])) > 0)) {
		$data['nr01'] = pegasus_mysql_newrec('crm000_04');
		$new_rec = true;
	}

	if($new_rec) {
		$exp = explode('-',$mmnr01);
		if(count($exp) != 2) {
			$data['permDeny'] = 1;
			$data['permDenyMessage'] = str_replace(
				'##mmnr01##',
				$mmnr01,
				$_SESSION['peg_dic_crm000_crm000_04_d_mmnr01_error']
			);
			return $data;
		}
		$table = pegasus_mysql_printfld('p50','p01','p01 = :p01',array('p01' => rtrim($exp[0],'_d')));
		if(empty($table)) {
			$data['permDeny'] = 1;
			$data['permDenyMessage'] = str_replace(
				'##table##',
				rtrim($exp[0],'_d'),
				$_SESSION['peg_dic_crm000_crm000_04_d_table_error']
			);
			return $data;
		}
		$data['p01'] = $table;	// Πίνακας Αναφοράς
		$row = array();
		if(pegasus_mysql_table_exist($table)) {
			pegasus_mysql_use("SELECT * FROM $table WHERE nr01 = :nr01",$row,array('nr01' => $exp[1]));
		}
		if(empty($row)) {
			$data['permDeny'] = 1;
			$data['permDenyMessage'] = str_replace(
				array(
					'##nr01##',
					'##table##'
				),
				array(
					$exp[1],
					$table
				),
				$_SESSION['peg_dic_crm000_crm000_04_d_nr01_error']
			);
			return $data;
		}
		/**
		 * M.K. Αναφοράς
		 */
		$data['p02'] = $row['nr01'];
		/**
		 * UID
		 */
		$data['p04'] = crm000_ics::uid_create($table,$row['nr01']);
		/**
		 * Περίληψη
		 */
		$data['p14'] = $_SESSION['crm000_00_crm000_04_p03'];
		/**
		 * Αλληλουχία
		 */
		$data['p05'] = pegasus_mysql_printfld('crm000_04','COUNT(nr01)','p01 = :p01 AND p02 = :p02',array('p01' => $data['p01'], 'p02' => $data['p02']));
		/**
		 * Διοργανωτής
		 */
		$data['p15'] = pegasus_mysql_printfld('us0','p100','p01 = :p01', array('p01' => $_SESSION['username']));
		/**
		 * Email Διοργανωτή
		 */
		$data['p16'] = $_SESSION['us0_email'];
		/**
		 * Τιμές ανά πίνακα αναφοράς 
		 */
		switch($table) {
			case 'd01' : 
				/**
				 * Ημερομηνία
				 */
				if(!empty($request['p00'])) {
					$data['p00'] .= $request['p00'];	
				} else {
					$data['p00'] .= $row['p03'];
				}
				/**
				 * Ώρα Έναρξης, Ώρα Λήξης και Διάρκεια
				 */
				if(
				
					!empty($request['p07']) 
					&& !empty($request['p08'])
				) {
					$data['p07'] = $request['p07'];
					$data['p08'] = $request['p08'];
				}
				elseif(
					!isset($_REQUEST['p07'])
					&& !isset($_REQUEST['p08'])
					&& !empty($row['p04']) 
					&& !empty($row['p08'])
				) {
					$data['p07'] = $row['p04'];
					$data['p08'] = $row['p08'];
				} else {
					$data['p07_readonly'] = true;
					$data['p08_readonly'] = true;
					$data['p09'] = 'ALLDAY';
				}
				/**
				 * Περίληψη
				 */
				$d04_p02 = "";
				if(!empty($request['d01_p05'])) {
					$d04_p02 = pegasus_mysql_printfld('d04','p02','p01 = :p01', array('p01' => $request['d01_p05']));
				} else {
					$d04_p02 = pegasus_mysql_printfld('d04','p02','p01 = :p01', array('p01' => $row['p05']));
				}
				if(!empty($d04_p02)) {
					$data['p03'] .= $d04_p02;
				}
				/**
				 * Κατάσταση
				*/
				$d02_p03 = 0;
				if(!empty($request['d01_p06'])) {
					$d02_p03 = pegasus_mysql_printfld('d02','p03','p01 = :p01', array('p01' => $request['d01_p06']));
				} else {
					$d02_p03 = pegasus_mysql_printfld('d02','p03','p01 = :p01', array('p01' => $row['p06']));
				}
				if($d02_p03 == 1) {
					$data['p13'] = 'CONFIRMED';
				} elseif($d02_p03 == 2) {
					$data['p13'] = 'CANCELLED';
				} else {
					$data['permDeny'] = 1;
					$data['permDenyMessage'] = $_SESSION['peg_dic_crm000_crm000_04_d_d01_p06_error'];
					return $data;
				}
			break;
			default :
				$data['permDeny'] = 1;
				$data['permDenyMessage'] = str_replace(
					'##table##',
					$table,
					$_SESSION['crm000_crm000_04_d_mode_error']
				);
				return $data;
		}
	} else {
		$data['readonly'] = 1;
	}
	return $data;
}
function crm000_04_d01_initialize(
	$data = array(),
	$mmnr01 = '',
	$mnr01 = 0,
	$_d = '',
	$container_id = ''
) {
	global $PegInput;
	$PegInput->addVar(new peg_input_alphanumeric('p01'));
	$PegInput->addVar(new peg_input_number('p02'));
	$p01 = $PegInput->getRequest('p01');
	$p02 = $PegInput->getRequest('p02');
	pegasusSetGlobalVar(
		$container_id . '_where_grid_crm000_04_d01',
		array(
			'sql' 		=> "
				crm000_04.p01 = :p01 
				AND crm000_04.p02 = :p02
			",
			'sqlParams' => array(
				'p01' => $p01,
				'p02' => $p02
			)
		)
	);
	return $data;
}
/**
 * Βρίσκει τα πεδία της διεύθυνσης
 * @param string $mode Ο τύπος της αναζήτησης. Μπορεί να είναι μία από τις τιμές 'd23' -> Χώρα ,'d27' -> Νομός , 'd22' -> Πόλη , 'tk'->Ταχυδρομικός Κώδικας , 'd99005' -> Τιμές από τον πίνακα "Κατάλογος Διευθύνσεων"
 * @param string $tk O ταχυδρομικός κώδικας
 * @param string $d23 Η χώρα
 * @param string $d27 O νομός
 * @param string $d22 Η πόλη
 * @return array[]  
 */
function peg_crm000_find_address_data($mode,$tk='',$d23p01='',$d27p01='',$d22p01='',$d99005p01='',$peg_search_locality=''){
	$arr = array();
	$d23_result=array(); $d27_result=array(); $d22_result=array();
	if($mode=='d23'){ //Χώρα
		$arr['d23'] = $d23p01;
		$sql="SELECT if(:sess_lang='GR',d23.p02,d23.ep02) AS p02 FROM d23 WHERE p01=:var_p01";
		$sqlParams=array('sess_lang'=>$_SESSION['lang'],'var_p01'=>$d23p01);
		pegasus_mysql_use($sql,$d23_result,$sqlParams);
		$arr['d23_display']=$d23_result['p02'];
		if( $d23p01 != pegasus_mysql_printfld('d27' , 'd23' , 'p01=?', array($d27p01))){
			$arr['d27']    = '';
			$arr['d27_display']    = '';
			$arr['d22']     = '';
			$arr['d22_display']    = '';
			$arr['change']  = 1;
			$arr['change_d27']  = 1;
		}
	}

	if($mode=='d27'){ //Νομός 
		$query_d23="SELECT 	d23.p01,
							if(:sess_lang='GR',d23.p02,d23.ep02) AS p02 ,
							d27.p01 as d27,
							d27.p02 as d27_display
					FROM d23 
					JOIN d27 on d27.d23=d23.p01
					WHERE d27.p01=:var_d27
					GROUP BY d23.p01";
		pegasus_mysql_use($query_d23,$d23_result,array('sess_lang'=>$_SESSION['lang'],'var_d27'=> $d27p01));
		$d23 = $d23_result['p01'];
		$d23_display = $d23_result['p02'];
		$arr['d27'] = $d23_result['d27'];
		$arr['d27_display']=$d23_result['d27_display'];
		
		if($d23 !=  $d23p01 && !empty($d23)){
			$arr['change_d23']  = 1;		
			$arr['d23']  = $d23;			
			$arr['d23_display']  = $d23_display;
		}
		
		if( $d27p01 != pegasus_mysql_printfld('d22' , 'p03' , 'p01=?', array($d22p01))){
			$arr['d22']     = '';
			$arr['d22_display']     = '';
			$arr['change_d22']  = 1;
		}
	}
	if($mode =='d22'){ /*Πόλη */
		$query_d27="SELECT 	d27.p01,
							if(:sess_lang='GR',d27.p02,d27.ep02) AS p02,
							d22.p01 as d22,
							d22.p02 as d22_display
					FROM d27 
					JOIN d22 on d22.p03=d27.p01
					WHERE d22.p01=:var_d22 
					GROUP BY d27.p01";
		pegasus_mysql_use($query_d27,$d27_result,array('sess_lang'=>$_SESSION['lang'],'var_d22'=> $d22p01));
		$arr['d22']=$d27_result['d22'];
		$arr['d22_display']=$d27_result['d22_display'];
		$d27 = $d27_result['p01'];
		$d27_display = $d27_result['p02'];

		/*Χώρα */
		$query_d23="SELECT 	d23.p01,
						if(:sess_lang='GR',d23.p02,d23.ep02) AS p02
					FROM d23 
					JOIN d27 on d27.d23=d23.p01
					WHERE d27.p01=:var_d27
					GROUP BY d23.p01";
		pegasus_mysql_use($query_d23,$d23_result,	array('sess_lang'=>$_SESSION['lang'],'var_d27'=> $d27) );

		$d23 = $d23_result['p01'];
		$d23_display = $d23_result['p02'];
		
		$arr['d23']='';
		$arr['d27']='';
		
		if(!empty($d23) and $d23!=$d23p01){
			$arr['d23'] = $d23;
			$arr['d23_display']=$d23_display;
			$arr['change_d23']=1;
		}
		
		if(!empty($d27) and $d27!=$d27p01){
			$arr['d27'] = $d27;
			$arr['d27_display']=$d27_display;
			$arr['change_d27']=1;
		}
		
	}

	if($mode=='tk'){
		$peg_tmp_p7_1_join = '';
		$peg_tmp_p7_1_join_params=array();
		if( !empty($d23p01)  && strlen($d23p01)<=3 ){
			
			$d23 = strtoupper($d23p01);
			if($d23 == pegasus_mysql_printfld('d23','p01', 'p01=?', array($d23))){
				$peg_tmp_p7_1_join = ' join d27 on d22.p03=d27.p01 and ( d27.d23 =:d23 ||  d27.d23 ="") ';
				$peg_tmp_p7_1_join_params['d23']=$d23;
			}
			
		}
		$query_d22="SELECT 	d22.p01 ,
							if(:sess_lang='GR',d22.p02,d22.ep02) AS p02
					FROM d22 $peg_tmp_p7_1_join
					WHERE d22.p04<=:var_tk_0 and d22.p05>=:var_tk_1";
		$query_d22_params=array_merge($peg_tmp_p7_1_join_params,array('sess_lang'=>$_SESSION['lang'],'var_tk_0'=> $tk,'var_tk_1'=> $tk));
		// echo pegasus_replace_values_in_sql($query_d22,$query_d22_params);
		$result=pegasus_query($query_d22,$query_d22_params);
		if(pegasus_num_rows($result)==1){
			$d22_result=pegasus_fetch($result);
			$d22=$d22_result['p01'];
			$d22_display=$d22_result['p02'];
			if(!empty($d22)){
				$arr['d22'] = $d22;
				$arr['d22_display'] = $d22_display;
				$arr['change_d22']=1;
			}
		}		
	}
	if($mode=='d99005'){
		/* p01 */
		pegasus_mysql_use("SELECT d99005.p04 AS p5, 
								  d99005.p05 AS p7_1, 
								  d99005.p06 AS p6 FROM d99005 
								  WHERE p01=?", 
								  $d99005, array($d99005p01));

		if(!empty($d99005['p5'])){
			$arr['p5'] = $d99005['p5'];
		}
		
		if(!empty($d99005['p7_1'])){
			$arr['tk'] = $d99005['p7_1'];
		}
		
		if(!empty($d99005['p6'])){
			$arr['p6'] = $d99005['p6'];
		}else if(!empty($d99005['p7_1'])){
			$d22_query="SELECT 	d22.p01 as p01, 
								if(:sess_lang='GR',d22.p02,d22.ep02) AS p02 
						FROM d22 
						WHERE p04<=:var_tk_0 and p05>=:var_tk_1";
			$d22_query_params=array('sess_lang'	=>	$_SESSION['lang'],'var_tk_0'=>$d99005['p7_1'],'var_tk_1'=>$d99005['p7_1']);
			pegasus_mysql_use($d22_query,$d22_result,$d22_query_params);
			$d22_1=$d22_result['p01'];
			if(!empty($d22_1)){
				$arr['d22'] = $d22_1;
				$arr['d22_display'] = $d22_result['p02'];
			}
		}
	}
	if($mode=='tk' && !empty($tk) && !empty($peg_search_locality) && is_array($peg_search_locality)){
		// die(var_dump($arr['d22'],$peg_search_locality));
		$d22_query="SELECT * 
					FROM d22 
					WHERE 
						(p02 LIKE :var_d22_00 OR p02 like :var_d22_01 OR p02 LIKE :var_d22_02 OR p02 like :var_d22_03) AND
						(:var_tk_00='' OR p04>=:var_tk_01 and p05<=:var_tk_02) ";
		$d22_query_params=array(	'var_d22_00'	=>	$peg_search_locality['short_name'],
									'var_d22_01'	=>	$peg_search_locality['short_name'],
									'var_d22_02'	=>	$peg_search_locality['long_name'],
									'var_d22_03'	=>	$peg_search_locality['long_name'],
									'var_tk_00'		=>	$arr['tk'],
									'var_tk_01'		=>	$arr['tk'],
									'var_tk_02'		=>	$arr['tk']);
		$result=pegasus_query($d22_query,$d22_query_params);
		if(pegasus_num_rows($result)==1){
			$d22_result=pegasus_fetch($result);
			$d22=$d22_result['p01'];
			$d22_display=$d22_result['p02'];
			if(!empty($d22)){
				$arr['d22'] = $d22;
				$arr['d22_display'] = $d22_display;
				$arr['change_d22']=1;
			}
		}		
	}
	return $arr;
}