<?php
/**
 * @see https://icalendar.org/
 * @see https://icalendar.org/iCalendar-RFC-5545/3-6-1-event-component.html
 */
class crm000_ics {
	protected static $prod_id = '-//TESAE SA//Pegasus WebApp// CRM000 ics//GR';
	protected static $uid_prefix = "pegasus_webapp";
	protected $line_max_len = 75;
	protected $args = array();
	public function export() {
		$template = peg_read_file('../crm000_templates/invite.ics');
		$nevent = array();
		foreach($this->args['VEVENT'] as $k => $v) {
			$nevent[] = "$k:$v";
		}
		$template = str_replace(
			array(
				'{{VEVENT}}',
				'{{PRODID}}',
				'{{METHOD}}'
			),
			array(
				implode("\n",$nevent),
				self::$prod_id,
				$this->args['METHOD']
			),
			$template
		);
		return $this->lines_check($template);
	}
	private function vevent_row_set(
		$name = '',
		$row = array()
	) {
		if(empty($name)) {
			return;
		}
		if(
			empty($row['attribute'])
			&& empty($row['value'])
		) {
			return;
		}
		$value = $row['value'];
		if($name == 'ALLDAY') {
			$this->args['VEVENT']['DTSTART;VALUE=DATE'] = $this->datetime_gr_to_utc($value,true);
			return;
		}
		// If is date format field
		if(in_array($name,array('DTSTART','DTEND'))) {
			$value = $this->datetime_gr_to_utc($value);
		}
		if(empty($row['attribute'])) {
			$this->args['VEVENT'][$name] = $value;
			return;
		}
		
		$this->args['VEVENT']["$name;{$row['attribute']}"] = $value;
		return;
	}
	public function data_set($data = array()) {
			// PUBLISH/REQUEST/CANCEL
			$this->args['METHOD'] = 'REQUEST';
			$this->args['PRODID'] = self::$prod_id;
			$vevent_keys = array(
				'SUMMARY',
				'UID',
				'SEQUENCE',
				'STATUS',
				'DTSTART',
				'DTEND',
				'ALLDAY',
				'LOCATION',
				'DESCRIPTION',
				'ORGANIZER',
			);
			foreach($vevent_keys as $key) {
				if(isset($data[$key])) {
					$this->vevent_row_set($key,$data[$key]);
				}
			}
			// DTSTAMP
			$this->args['VEVENT']['DTSTAMP'] = $this->datetime_gr_to_utc(date('Y-m-d H:i:s'));
	}
	protected final function lines_check($template) {
		$ret_arr = array();
		$template = str_replace(
			array(
				"\n\r",
				"\r\n",
				"\r"
			),
			"\n",
			$template
		);
		$lines = explode("\n",$template);
		foreach($lines as $line) {
			if(mb_strlen($line,'utf-8')<$this->line_max_len) {
				$ret_arr[] = $line;
				continue;
			}
			while(mb_strlen($line,'utf-8') > $this->line_max_len) {
				$ret_arr[] = mb_substr($line,0,$this->line_max_len,'utf-8');
				$line = mb_substr($line,$this->line_max_len,mb_strlen($line,'utf-8'),'utf-8');
			}
			if(strlen($line) > 0) {
				$ret_arr[] = $line;
			}
		}
		return implode("\r\n",$ret_arr);
	}
	protected final function datetime_gr_to_utc($datetime,$only_day = false) {
		$date_obj = new DateTime($datetime, new DateTimeZone('Europe/Athens')); 
		$date_obj->setTimezone(new DateTimeZone('UTC'));
		if($only_day) {
			return $date_obj->format('Ymd');
		}
		return $date_obj->format('Ymd\THis\Z');
	}
	public static final function uid_create($mode,$nr01) {
		$uid_arr = array();
		$uid_arr[] = self::$uid_prefix;
		$uid_arr[] = pegasus_get_app_sn();
		$uid_arr[] = $mode;
		$uid_arr[] = $nr01;
		return implode('_',$uid_arr);
	}
}
