<?php 

/**
 * Kanie thn eggrafi sto d64
 * @param int(15) $p00 //ΣΥΝΑΛΛΑΣΣΌΜΕΝΟΣ
 * @param string $p001 //Τηλέφωνο
 * @param string $p02 //Είδος
 * @param boolean $p03 //Λαμβάνει Μαζικές Αποστολές Fax
 * @param string $p04 //Παρατηρήσεις
 * @param boolean $p05 //Εμφανίζεται στην 1η Οθόνη
 * @param int 3  $p06 //Διαδοχή Εμφάνισης
 * @param boolean $p07 //Λαμβάνει Μαζικές Αποστολές SMS
 * @param enum {phone-01 =>Kύριο Τηλέφωνο 1 (cellphone), phone-02 => Kύριο Τηλέφωνο 2, fax-01 => Kύριο Fax 1 } $pd100
 */
function crm001_add_d64($p00, $p001, $p02, $p03, $p04, $p05, $p06, $p07, $pd100){
	/*
	***INPUT peg_arr={p00, p001, p02, p03, p04, p05, p06, p07, pd100}
	*** look if exists same p00 + pd100  and updates else inserts record
	*** pd100 = (personal phone, fax, mobile) ph-per-001, fax-per-001, mob-per-001,
	***         (company  phone, fax, mobile) ph-com-001, fax-com-001, mob-com-001
	***         (phone-01, phone-02, fax-01)
	*/
	$arr1 = array('p00'); $arr2 = array($p00);
	array_push($arr1 , 'p001');   array_push($arr2 , $p001); 
	if($p02!=1 && $p02!=2 && $p02!=3){
		$p02 = 1;
	}
	array_push($arr1 , 'p02');    array_push($arr2 , $p02); 
	array_push($arr1 , 'p03');    array_push($arr2 , str2int($p03)); 	
	array_push($arr1 , 'p04');    array_push($arr2 , $p04); 
	array_push($arr1 , 'p05');    array_push($arr2 , str2int($p05)); 
	array_push($arr1 , 'p06');    array_push($arr2 , $p06); 
	array_push($arr1 , 'p07');    array_push($arr2 , str2int($p07)); 
	array_push($arr1 , 'pd100');  array_push($arr2 , $pd100); 
	array_push($arr1 , 'p01');    array_push($arr2 , str2int($p001)); 

	$nr01 = pegasus_mysql_printfld('d64' , 'nr01' , 'p00=:p00 and pd100=:pd100', array('p00'=>$p00, 'pd100'=>$pd100));
 	$nr01 = intval($nr01);
	
	
	//new no phone - no insert
	if(empty($nr01) and empty($p001)){
		return ;
	}

	//old no phone - delete
	if((!empty($nr01)) and empty($p001)){
		pegasus_mysql_delete('d64' , 'nr01=:nr01', 0, array('nr01' => $nr01));
	}

	if($nr01>0){
		pegasus_mysql_update('d64' , $arr1 , $arr2 , 'nr01=:nr01', 0, 1, 1, array('nr01' => $nr01));
	}else{
		$nr01 = pegasus_mysql_newrec('d64');
		array_push($arr1 , 'nr01');    array_push($arr2 , $nr01); 
		pegasus_mysql_insert('d64' , $arr1 , $arr2 );
	}

		
}
	

/**
 * @param int(15) $p00 //ΣΥΝΑΛΛΑΣΣΌΜΕΝΟΣ
 * @param string $p001 //e-mail   
 * @param boolean $p02 //Λαμβάνει Μαζικές Αποστολές
 * @param string $p04  //Παρατηρίσεις
 * @param boolean $p05 //Εμφανίζεται στην 1η οθόνη
 * @param enum {} $pd100 //Kατηγορία
 * 
 */
function crm001_add_d65($p00, $p01, $p02, $p04, $p05, $pd100){
	/*
	***INPUT peg_arr={p00, p01, p02, p04, p05, pd100}
	*** look if exists same p00 + pd100  and updates else inserts record
	*** pd100 = (personal) per-001, per-002, ...
	***         (company ) com-001, com-002, ...
	*/
		
	$arr1 = array(); $arr2 = array();
	array_push($arr1, 'p00');   array_push($arr2, $p00);
	array_push($arr1, 'p01');   array_push($arr2, $p01);
	array_push($arr1, 'p02');   array_push($arr2, str2int($p02));
	array_push($arr1, 'p04');   array_push($arr2, $p04);
	array_push($arr1, 'p05');   array_push($arr2, str2int($p05));
	array_push($arr1, 'pd100'); array_push($arr2, $pd100);

	$nr01 = pegasus_mysql_printfld('d65' ,  'nr01' , 'p00=:p00 and pd100=:pd100 ', array('p00'=>$p00, 'pd100'=>$pd100));
	//new no email - no insert
	if(empty($nr01) and empty($p01) ){
		return ;
	}
	$nr01 = intval($nr01);
	//old no email - delete
	if($nr01>0 and empty($p01) ){
		pegasus_mysql_delete('d65' , 'nr01=:nr01', 0, array('nr01' => $nr01));
		return ;
	}

	if($nr01>0){
		pegasus_mysql_update('d65' , $arr1 , $arr2 , 'nr01=:nr01', 0, 1, 1, array('nr01' => $nr01));
	}else{
		$nr01 = pegasus_mysql_newrec('d65');
		array_push($arr1, 'nr01');   array_push($arr2, $nr01);
		pegasus_mysql_insert('d65' , $arr1 , $arr2);
	}
}		
