/**
 * @class Functions.crm002.global
 * 
 * @member WebApp.view 
 *  
 *  ##Properties
 *  
 *  The global variables of the module
 *   
 *  ##Methods
 *  
		- General functions
		- After draw listeners
		- Start Grid Row edit
 *  
 *  The functions of the module
 *  
 */

//XXX Start General functions 
var crm002_d01_refresh_values_ajax = '';
function crm002_d01_refresh(container_id) {
	d01_d_container_id = pegGetContainer_id_d(container_id, 'd01_d', '', 'd01_d');
	d01_d01_container_id = pegGetContainer_id_d(container_id, 'd01_d01', '', 'd01_d');

	var d01_params = {};
	d01_params.container_id = d01_d_container_id;
	d01_params = Ext.Object.merge(d01_params, pegGetFormVal(d01_d_container_id));
	var container_id_array = {};
	container_id_array = Ext.Array.push(container_id_array, d01_d_container_id);

	if (crm002_d01_refresh_values_ajax != '') {
		if (crm002_d01_refresh_values_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(crm002_d01_refresh_values_ajax);
		}
	}

	crm002_d01_refresh_values_ajax = pegAjaxDefer('/' + main_path + '/crm002_d01_d/d01_refresh_vals.php', d01_params, function (jsondata) {

		Ext.each(container_id_array, function (container_id) {
			fld = pegGetFormFields(container_id);
			fld = Ext.Object.merge(fld, pegGetFormVal(d01_d01_container_id));
			if (fld) {
				fld.each(function (item) {

					if (jsondata[item.name] != undefined) {
						pegSetVal(item.name, item.container_id, jsondata[item.name]);
					}
				});
			}
		});

	});
}
function query_q10_d90_140000006000001_d200_grid01_view_afterDraw_listeners(container_id){
	var grid = pegGetCmp(container_id, 'grid01');
	var column_count=grid.getColumns().length;
	var q10_d90_140000006000001_d_container_id = pegGetContainer_id_d(container_id , 'q10_d90_140000006000001_d'   , '' , 'q10_d90_140000006000001_d' );
	let ColumnP03 = {};
	for (let i = 1; i < column_count; i++) {
		ColumnP03[i] = WebApp.view.grid.Grid.peg_getColumn(grid, 'p03-p04-'+i);
		if(ColumnP03[i]){
			ColumnP03[i].peg_column_celldblclick_handler=function(me, td, cellIndex, record, tr, rowIndex, e, eOpts){
				if(!pegIsEmpty(record.get('p01'))){
					params = {};
					params.peg_query_var_us0_p01 = record.get('p01').split("(")[1].split(")")[0];
					params.peg_query_var_dt = Ext.Date.format(new Date(ColumnP03[i].text.split('/').reverse().join('-')), 'Y-m-d');
					params.peg_query_var_d02_p01 = pegGetVal('peg_query_var_d02_p01',q10_d90_140000006000001_d_container_id);
					params.peg_query_var_d32_nr01 = pegGetVal('peg_query_var_d32_nr01', q10_d90_140000006000001_d_container_id);
					pegAddTab_d('', '', 'q10_d90_' + 140000006000002 + '_d', 'query', '', 0, '',params);

				}
			} 
			ColumnP03[i].peg_set_metaData = function (value, metaData, record, rowIndex, colIndex) { 
				try {
					metaData.tdCls = 'peg_clickable_cell';
				} catch (error) {
				}
				return metaData;
			}
		}
	}
}
/**
 * Update p30
 * @param {String} container_id 
 */
var crm002_d01_edit_d01p30_ajax = '';
function crm002_d01_edit_d01p30(container_id) {
	var screen = pegGetCmp(container_id);

	if (crm002_d01_edit_d01p30_ajax != '') {
		if (crm002_d01_edit_d01p30_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(crm002_d01_edit_d01p30_ajax);
		}
	}
	params = {};
	params.container_id = container_id;
	params.p30 = pegGetVal('p30', container_id);
	crm002_d01_edit_d01p30_ajax = pegAjaxDefer('/' + main_path + '/crm002_d01_d/set_p30_tmp.php', params, function (jsondata) {
		peg_windowShow_d(
			'',
			'd01_d03',
			'crm002',
			container_id,
			'',
			0,
			'',
			'c-c',
			{
				peg_screen_parent_element_name: 'vp30',
				peg_screen_parent_container_id: screen.getContainer_ID(),
				mmnr01: screen.getMmnr01(),
				mnr01: screen.getMnr01()
			},
			true,
			true,
			0,
			0,
			'tablet'
		);
	});

}

var crm002_d01_grid_d01_refresh_values_ajax = '';
function crm002_d01_grid_d01_refresh(container_id, data) {
	var d01_params = data;


	if (crm002_d01_grid_d01_refresh_values_ajax != '') {
		if (crm002_d01_grid_d01_refresh_values_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(crm002_d01_grid_d01_refresh_values_ajax);
		}
	}

	crm002_d01_grid_d01_refresh_values_ajax = pegAjaxDefer(
		'/' + main_path + '/crm002_d01_d/d01_refresh_vals.php',
		d01_params,
		function (jsondata) {
			if (jsondata) {
				var grid = pegGetCmp(container_id, 'grid_d01');
				if (pegIsEmpty(grid)) {
					grid = pegGetCmp(container_id, 'grid');
				}

				WebApp.view.grid.Grid.peg_getRowEditingSetData(grid, jsondata);
			}


		}
	);

}


function crm002_show_d01_grid(table, nr01, container_id, mnr01, mmnr01) {
	if (pegGetFramework() == 'peg002') {
		if (!(mnr01 > 0)) {
			mnr01 = pegGetCmp(container_id).getMnr01();
		}
		if (!mmnr01) {
			mmnr01 = pegGetCmp(container_id).getMmnr01();
		}
	}
	pegWindowShow_d(
		'',
		'crm002_d01_grid_d',
		'crm002',
		'',
		'0',
		'&mnr01=' + mnr01 + '&mmnr01=' + mmnr01 + '&peg_table=' + table + '&peg_nr01=' + nr01,
		container_id,
		0, 0, 'c-c-', {}, false, true, 0, 'tablet'
	);
}
function crm002_d01_d_update_fldcont00_title(container_id) {
	var fldcont00 = pegGetCmp(container_id, 'fldcont00');
	let screenData = pegGetCmp(container_id).peg_getData();
	if (fldcont00.peg_isCollapsed()) {
		let p01, p06, chars = 40;
		if (peg002_IsMobileScreen()) {
			chars = 20;
		}
		if (screenData.dias_var_p01.length >= chars) {
			p01 = screenData.dias_var_p01.substr(0, chars - 3) + '...';
		} else {
			p01 = screenData.dias_var_p01;
		}
		if (screenData.dias_var_p06.length >= chars) {
			p06 = screenData.dias_var_p06.substr(0, chars - 3) + '...';
		} else {
			p06 = screenData.dias_var_p06;
		}
		if (pegIsEmpty(p01) && pegIsEmpty(p06)) {
			fldcont00.setTitle(fldcont00.title00);

		} else {
			fldcont00.setTitle(p01 + '/' + p06);
		}
	} else {
		fldcont00.setTitle(fldcont00.title00);
	}
}
var crm002_crm004_build_open_tab_params_ajax = ''
function crm002_crm004_build_open_tab_params(
	da4_nr01 = 0,
	d01_nr01 = 0,
	d00_nr01 = 0,
	container_id = ''
) {
	const params = {
		da4_nr01 : da4_nr01,
		d01_nr01 : d01_nr01,
		d00_nr01 : d00_nr01
	}
	if (crm002_crm004_build_open_tab_params_ajax != '') {
		if (crm002_crm004_build_open_tab_params_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(crm002_crm004_build_open_tab_params_ajax)
		}
	}
	const url = '/' + main_path + '/crm00201/crm002_crm004_build_open_tab_params.php'
	crm002_crm004_build_open_tab_params_ajax = pegAjaxDefer(url, params, function (jsonData) {
		if (!jsonData) {
			return pegAlert('pegAjaxDefer response error')
		}
		if(jsonData.ok != 1) {
			return pegToast(jsonData.msg,'alert')
		}
		return pegAddTab_d(
			'' , 
			jsonData.data.table, 
			jsonData.data._d, 
			jsonData.data.module,
			'', 
			0,
			'',
			{
				d01 : d01_nr01,
				d00	: d00_nr01,
				da4 : da4_nr01,
			},
			container_id,
		);
	}, 'json', 0, true)
}
//XXX After draw listeners
/**
 * After draw for Δραστηριότητες
 * @param {String} container_id 
 */
function crm002_d01_d_afterDraw_listeners(container_id) {
	var screen = pegGetCmp(container_id);

	const p421_btn = pegGetCmp(container_id, 'p421_btn');
	if(p421_btn){
		p421_btn.on('click',function(me) {
			const da4_nr01 = pegGetVal('p421',container_id);
			const d01_nr01 = pegGetVal('nr01',container_id);
			const d00_nr01 = pegGetVal('p01',container_id);
			return crm002_crm004_build_open_tab_params(
				da4_nr01,
				d01_nr01,
				d00_nr01,
				container_id
			);	
		})	
	}

	var p01 = pegGetCmp(container_id, 'p01');

	if (p01) {
		p01.on('blur', function (me, event, eOpts) {
			if (!(me.peg_onBlurValueHasChanged())) {
				return false;
			}
			crm002_d01_refresh(me.getContainer_ID());
		});
		p01.on('change', function (me, newValue, oldValue, eOpts) {
			if (newValue == oldValue) {
				return;
			}
			crm002_d01_d_update_fldcont00_title(container_id);
			crm002_update_p304_where(container_id);
		});
	}

	//Προγραμματισμένη Ώρα Εναρξης	
	var p04 = pegGetCmp(container_id, 'p04');
	p04.on('blur', function (me) {
		crm002_d01_refresh(container_id);
	});

	//Προγραμματισμένη Ώρα Λήξης
	var p08 = pegGetCmp(container_id, 'p08');
	p08.on('blur', function (me) {
		crm002_d01_refresh(container_id);
	});

	//Πραγματική Ωρα Εναρξης
	var p041 = pegGetCmp(container_id, 'p041');
	p041.on('blur', function (me) {
		crm002_d01_refresh(container_id);
	});

	//Πραγματική Ωρα Λήξης
	var p09 = pegGetCmp(container_id, 'p09');
	p09.on('blur', function (me) {
		crm002_d01_refresh(container_id);
	});

	//Είδος
	var p05 = pegGetCmp(container_id, 'p05');
	p05.on('change', function (me, newValue, oldValue, eOpts) {
		crm002_d01_refresh(container_id);
	});

	//Κατάσταση	
	var p06 = pegGetCmp(container_id, 'p06');
	p06.on('change', function (me, newValue, oldValue, eOpts) {
		crm002_d01_refresh(container_id);
		crm002_d01_d_update_fldcont00_title(container_id);
	});

	//Προτυπη Δραστηριότητα
	var p401 = pegGetCmp(container_id, 'p401');
	p401.on('change', function (me, newValue, oldValue, eOpts) {
		if (newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue))) {
			return;
		}

		var params = pegGetFormVal(container_id, 'dias_fld_');
		params.mode = 'd32';
		pegAjaxDefer(
			'/' + main_path + '/crm002_d01_d/d32_change.php',
			params,
			function (jsonData) {

				if (jsonData.p05 != '') {
					if (pegIsComboboxV2Object(pegGetCmp(container_id, 'p05'))) {
						pegSetVal('p05', container_id, { 'value': jsonData.p05, 'display': jsonData.p05_display, });

					} else {
						pegSetVal('p05', container_id, jsonData.p05);
					}
				}
				if (jsonData.p07 != '') {
					if (pegIsComboboxV2Object(pegGetCmp(container_id, 'p07'))) {
						pegSetVal('p07', container_id, { 'value': jsonData.p07, 'display': jsonData.p07_display, });

					} else {
						pegSetVal('p07', container_id, jsonData.p07);
					}
				}
				if (jsonData.p06 != '') {
					if (pegIsComboboxV2Object(pegGetCmp(container_id, 'p06'))) {
						pegSetVal('p06', container_id, { 'value': jsonData.p06, 'display': jsonData.p06_display, });

					} else {
						pegSetVal('p06', container_id, jsonData.p06);
					}
				}
				if (jsonData.p320 != '') {
					if (pegIsComboboxV2Object(pegGetCmp(container_id, 'p320'))) {
						pegSetVal('p320', container_id, { 'value': jsonData.p320, 'display': jsonData.p320_display, });

					} else {
						pegSetVal('p320', container_id, jsonData.p320);
					}
				}
				if (jsonData.p30 != '') {
					pegSetVal_d('v_p30', container_id, 'd01_d01', 'down', pegGetVal_d('v_p30', container_id, 'd01_d01') + jsonData.p30, 'd01_d');
					crm002_d01_d01_p30_update_value(pegGetContainer_id_d(container_id, 'd01_d01'));
				}
				if (jsonData.p31 != '') {
					pegSetVal_d('v_p31', container_id, 'd01_d02', 'down', pegGetVal_d('v_p31', container_id, 'd01_d02') + jsonData.p31, 'd01_d');
					crm002_d01_d02_p31_update_value(pegGetContainer_id_d(container_id, 'd01_d02'));
				}
			},
			'json',
			true
		);
	});

	var fldcont00 = pegGetCmp(container_id, 'fldcont00');

	fldcont00.on('collapse', function () {

		crm002_d01_d_update_fldcont00_title(container_id);
	});
	fldcont00.on('expand', function () {

		crm002_d01_d_update_fldcont00_title(container_id);
	});
	crm002_d01_d_update_fldcont00_title(container_id);

	/* Συναλλασσόμενος */
	var p01 = pegGetCmp(container_id, "p01");
	p01.on('change', function (me, newValue, oldValue, eOpts) {
		if (newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue))) {
			return;
		}
		crm001_return_d88(container_id, 'd01');
		crm001_return_d69(container_id, newValue);

	});

	/* Υποκατάστημα Συναλλασσομένου */
	var p01_1 = pegGetCmp(container_id, "p01_1");
	p01_1.on('change', function (me, newValue, oldValue, eOpts) {
		if (newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue))) {
			return;
		}
		crm001_return_d88(container_id, 'd01');
	});


	/* Υπευθυνος Συναλλασσομένου */
	var p312 = pegGetCmp(container_id, "p312");
	p312.on('change', function (me, newValue, oldValue, eOpts) {
		if (newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue))) {
			return;
		}
		crm001_return_d69(container_id, 'd01');
	});


	let container_id_d01_parent_id = pegGetCmp(container_id).getPeg_screen_parent_container_id();
	let container_id_d01_d50 = pegGetContainer_id_d(container_id_d01_parent_id, 'd01_d50', '', 'd01_d50');
	if(container_id_d01_d50){
		let dt = pegGetVal('dt', container_id_d01_d50);
		pegSetVal('p03', container_id, dt);
	}

}

function crm002_d01_d01_afterDraw_listeners(container_id) {
	var fldset00 = pegGetCmp(container_id, "fldset00");
	fldset00.on('afterlayout', function () {
		if (peg002_IsMobileOrTabletScreen()) {
			pegGetCmp(container_id + "_fldset00_header").hide();//hide header on button mode
		}
	});
	var v_p30 = pegGetCmp(container_id, "v_p30");
	v_p30.on('change', function (me, newValue, oldValue, eOpts) {
		if (newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue))) {
			return;
		}
		crm002_d01_d01_p30_update_value(container_id);
	});
	if (typeof v_p30.getEditor == 'function') {
		v_p30.getEditor().on('blur', function () {
			crm002_d01_d01_p30_update_value(container_id);
		});

	}
}
function crm002_d01_d01_p30_update_value(container_id) {
	var main_container_id = pegGetCmp(container_id).peg_mainForm;
	var main_form_data = pegGetCmp(main_container_id).peg_getData();

	var user_p01 = main_form_data.peg_user_p01;
	var user_p100 = main_form_data.peg_user_p100;
	var peg_p30_init = main_form_data.peg_p30_init;

	if (pegIsEmpty(peg_p30_init)) {
		peg_p30_init = '';
	}

	var v_p30 = pegGetCmp(container_id, "v_p30");
	var peg_v_p30 = v_p30.getValue();
	var dateTimeStr = Ext.Date.format(new Date(), "d/m/Y H:i:s");
	var p30_str = peg_p30_init +
		'<div class="sign_title ">' + dateTimeStr + ' (' + user_p01 + ') ' + user_p100 + '</div>' +
		'<div class="d01_memo_body">' + peg_v_p30 + '</div>';
	if (pegIsEmpty(peg_v_p30)) {
		p30_str = peg_p30_init;
	}
	pegSetVal('p30', container_id, p30_str);
}

function crm002_d01_d02_afterDraw_listeners(container_id) {
	var fldsetnewstohos = pegGetCmp(container_id, "fldsetnewstohos");
	fldsetnewstohos.on('afterlayout', function () {
		if (peg002_IsMobileOrTabletScreen()) {
			pegGetCmp(container_id + "_fldsetnewstohos_header").hide();//hide header on button mode
		}
	});
	var v_p31 = pegGetCmp(container_id, "v_p31");
	v_p31.on('change', function (me, newValue, oldValue, eOpts) {
		if (newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue))) {
			return;
		}
		crm002_d01_d02_p31_update_value(container_id);
	});
	if (typeof v_p31.getEditor == 'function') {
		v_p31.getEditor().on('blur', function () {
			crm002_d01_d02_p31_update_value(container_id);
		});

	}
}

function crm002_d01_d15_afterDraw_listeners(container_id) {

	var screen=pegGetCmp(container_id);
	var p012=pegGetCmp(container_id,'p012');
	var p307 = pegGetCmp(container_id, "p307");

	p307.on('change', function (me, newValue, oldValue, eOpts) {
		if (newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue))) {
			return;
		}
		customers_return_a71(container_id, 'd01');
		var d01_d_container_id=pegGetContainer_id_d(container_id, 'd01_d', '', 'd01_d') ;
		crm002_update_p304_where(d01_d_container_id);
	});

	var p307_1 = pegGetCmp(container_id, "p307_1");
	p307_1.on('change', function (me, newValue, oldValue, eOpts) {
		if (newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue))) {
			return;
		}
		customers_return_a71(container_id, 'd01');
	});

	var v_vis_sn = pegGetCmp(container_id, "v_vis_sn");
	v_vis_sn.on('change', function (me, newValue, oldValue, eOpts) {
		if (newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue))) {
			return;
		}
		var d01_d_container_id=pegGetContainer_id_d(container_id, 'd01_d', '', 'd01_d') ;
		crm002_update_p304_where(d01_d_container_id);
	});

	p012.on('change',function (me, newValue, oldValue, eOpts) {
		crm002_d01_d15_reset_p010_hidden(container_id);
		pegSetVal('p010',container_id,'');
		if(pegIsEmpty(newValue)){
			pegSetFieldHidden('p010',container_id,false);
			return;
		}
		var rec=p012.getPicker().getSelectionModel().selected.items[0].data;
		if(pegIsEmpty(screen.p012_rel_combo_array)){
			screen.p012_rel_combo_array=[];
		}
		if(screen.p012_rel_combo_array[rec.p01] && pegIsComboboxV2Object(screen.p012_rel_combo_array[rec.p01])){
			pegSetVal('p010_'+rec.p01,container_id,{display:'',value:''});
			return;
		}
		crm002_d01_d15_insert_p010_field(container_id,rec.p01,rec.p02,rec.module);
	});
	pegGetCmp(container_id, "fldset_dynamic").on('add',function(){
		crm002_d01_d15_reset_p010_hidden(container_id);
	})
}
function crm002_d01_d15_reset_p010_hidden(container_id){
	var screen = pegGetCmp(container_id);
	Object.keys(screen.p012_rel_combo_array).forEach(it=>{
		if(screen.p012_rel_combo_array[it]){
			pegSetFieldHidden(screen.p012_rel_combo_array[it].name,container_id,(pegGetVal('p012',container_id)!==it ));
		}
	});
}
function crm002_d01_d15_insert_p010_field(container_id,table,_d,module){
	var screen = pegGetCmp(container_id);
	var screenData=peg002_get_screen_data(container_id);
	var fldset_dynamic_container = pegGetCmp(container_id, "fldset_dynamic");
	if(pegIsEmpty(screen.p012_rel_combo_array)){
		screen.p012_rel_combo_array=[];
	}
	if(typeof table !== 'undefined') {
		console.info(table,Ext.data.StoreManager.lookup('store_p95p50').getPermissions(table));
		var isTableEn =Ext.data.StoreManager.lookup('store_p95p50').getPermissions(table).get("sh")==1 ;
		if(!isTableEn){ 
			pegSetFieldHidden('p010',container_id,false);
			return;
		}
	}
	if(!pegIsEmpty(table)){
		var config={
			name:'p010_'+table,
			xtype:'comboboxV2',
			flex:1,
			table:table,
			_d:_d,
			module:module,
			displayField:'nr01',
			valueField:'nr01',
			fieldLabel:screenData.p010_label
		};
		screen.p012_rel_combo_array[table]=fldset_dynamic_container.peg_insert(config); 
		if(screen.p012_rel_combo_array[table]){
			pegSetFieldHidden('p010',container_id,true);
			screen.p012_rel_combo_array[table].on('change',function(){
				var val=pegGetVal('p010_'+table,container_id);
				pegSetVal('p010',container_id,val);
			});
		}
	}
}
function crm002_d01_d15_dynamic_fields_init(container_id) {
	var screenData=peg002_get_screen_data(container_id);
	crm002_d01_d15_insert_p010_field(container_id,screenData.p010_selected_table,screenData.p010_selected__d,screenData.p010_selected_module);
}

function crm002_update_p304_where(d01_d_container_id){
	var d01_d15_container_id=pegGetContainer_id_d(d01_d_container_id, 'd01_d15', '', 'd01_d');
	var params ={};
	params.v_vis_sn = pegGetVal('v_vis_sn', d01_d15_container_id); //Εμφανιση S/N
	params.p307 = pegGetVal('p307', d01_d15_container_id); //Πελατης
	params.p01 = pegGetVal('p01',  d01_d_container_id  ); //Συναλλασσομενος
	params.p304 = pegGetVal('p304',  d01_d15_container_id  ); //S/N
	params.container_id = d01_d_container_id;
	pegAjax('/' + main_path + '/crm002_d01_d/d01_d15_p304_set_where.php', params, function (jsonData) {
		if (jsonData.d01_d15_p304 == false) {
			pegSetVal('p304', d01_d15_container_id, '');
		}

	}, 'json', true);
}

function crm002_d01_d02_p31_update_value(container_id) {
	var main_container_id = pegGetCmp(container_id).peg_mainForm;
	var main_form_data = pegGetCmp(main_container_id).peg_getData();

	var user_p01 = main_form_data.peg_user_p01;
	var user_p100 = main_form_data.peg_user_p100;
	var peg_p31_init = main_form_data.peg_p31_init;

	if (pegIsEmpty(peg_p31_init)) {
		peg_p31_init = '';
	}

	var v_p31 = pegGetCmp(container_id, "v_p31");
	var peg_v_p31 = v_p31.getValue();
	var dateTimeStr = Ext.Date.format(new Date(), "d/m/Y H:i:s");
	var p31_str = peg_p31_init +
		'<div class="sign_title ">' + dateTimeStr + ' (' + user_p01 + ') ' + user_p100 + '</div>' +
		'<div class="d01_memo_body">' + peg_v_p31 + '</div>';
	if (pegIsEmpty(peg_v_p31)) {
		p31_str = peg_p31_init;
	}
	pegSetVal('p31', container_id, p31_str);
}

function crm002_d01_d50_update_fldcont_search_title(container_id) {
	var fldcont_search = pegGetCmp(container_id, 'fldcont_search');
	let screenData = pegGetCmp(container_id).peg_getData();
	var pendingCmp = pegGetCmp(container_id, 'pending');
	var pending_str = pendingCmp.fieldLabel + ':';
	if (fldcont_search.peg_isCollapsed()) {
		let us0, p06, chars = 40;
		if (peg002_IsMobileScreen()) {
			chars = 20;
		}
		if (screenData.dias_var_us0.length >= chars) {
			us0 = screenData.dias_var_us0.substr(0, chars - 3) + '...';
		} else {
			us0 = screenData.dias_var_us0;
		}
		if (pendingCmp.getDisplayValue().length - pendingCmp.getDisplayValue().length >= chars) {
			pending = pending_str + pendingCmp.getDisplayValue() + '...';
		} else {
			pending = pending_str + pendingCmp.getDisplayValue();
		}
		if (pegIsEmpty(us0) && pegIsEmpty(pending)) {
			fldcont_search.setTitle(fldcont_search.title00);

		} else {
			fldcont_search.setTitle(us0 + '/' + pending);
		}
	} else {
		fldcont_search.setTitle(fldcont_search.title00);
	}
}
var prop_grid_data_ajax ='';
var find_p30_ajax = '';
/**
 * Ημερολόγιο Δραστηριοτήτων
 * 
 * @param {String} container_id 
 */
function crm002_d01_d50_afterDraw_listeners(container_id) {
	var dt = pegGetCmp(container_id, 'dt');
	var dt_prev = pegGetCmp(container_id, 'dt_prev');
	var dt_next = pegGetCmp(container_id, 'dt_next');
	var dt_today = pegGetCmp(container_id, 'dt_today');
	var grid_d01 = pegGetCmp(container_id, 'grid_d01');
	var fldcont_search = pegGetCmp(container_id, 'fldcont_search');

	dt.on('change', function (me, newValue, oldValue, eOpts) {
		var params = pegGetFormVal(container_id, 'dias_fld_');
		params.mode = 'dt';
		pegAjax('/' + main_path + '/crm002_d01_d50/date_change.php', params, function (jsonData) {
			if (jsonData.dt_name != '') {
				pegSetVal('dt_name', container_id, jsonData.dt_name);
			}
		}, 'json', true);
		pegGridRefresh(container_id, 'grid_d01');
	});

	dt_prev.setPeg_handler(function () {
		var params = pegGetFormVal(container_id, 'dias_fld_');
		params.mode = 'dt_prev';
		pegAjax('/' + main_path + '/crm002_d01_d50/date_change.php', params, function (jsonData) {
			if (jsonData.dt != '') {
				pegSetVal('dt', container_id, jsonData.dt);
			}
		}, 'json', true);
	});

	dt_next.setPeg_handler(function () {
		var params = pegGetFormVal(container_id, 'dias_fld_');
		params.mode = 'dt_next';
		pegAjax('/' + main_path + '/crm002_d01_d50/date_change.php', params, function (jsonData) {
			if (jsonData.dt != '') {
				pegSetVal('dt', container_id, jsonData.dt);
			}
		}, 'json', true);
	});

	dt_today.setPeg_handler(function () {
		var params = pegGetFormVal(container_id, 'dias_fld_');
		params.mode = 'dt_today';
		pegAjax('/' + main_path + '/crm002_d01_d50/date_change.php', params, function (jsonData) {
			if (jsonData.dt != '') {
				pegSetVal('dt', container_id, jsonData.dt);
			}


		}, 'json', true);
	});



	var pending = pegGetCmp(container_id, 'pending');
	if (pending) {
		pending.on('change', function (me, event, eOpts) {

			// if(!(me.peg_onChangeValueHasChanged()) ){
			// 	return false;
			// }
			pegGridRefresh(container_id, 'grid_d01');
			crm002_d01_d50_update_fldcont_search_title(container_id);
		});
	}

	var us0 = pegGetCmp(container_id, 'us0');
	if (us0) {
		us0.on('change', function (me, event, eOpts) {

			// if(!(me.peg_onChangeValueHasChanged()) ){
			// 	return false;
			// }
			pegGridRefresh(container_id, 'grid_d01');
			crm002_d01_d50_update_fldcont_search_title(container_id);
		});
	}

	var d04 = pegGetCmp(container_id, 'd04');
	if (d04) {
		d04.on('change', function (me, event, eOpts) {

			// if(!(me.peg_onChangeValueHasChanged()) ){
			// 	return false;
			// }
			pegGridRefresh(container_id, 'grid_d01');
		});
	}


	var d02 = pegGetCmp(container_id, 'd02');
	if (d02) {
		d02.on('change', function (me, event, eOpts) {

			// if(!(me.peg_onChangeValueHasChanged()) ){
			// 	return false;
			// }
			pegGridRefresh(container_id, 'grid_d01');
		});
	}



	// grid_d01.setpeg_isEditable(false);
	grid_d01.on('select', function (view, record, item, index, e, opts) {
		container = pegGetCmp_d('grid_prop', container_id, 'd01_d51', '', 'd01_d50');
		var params = {};
		params.view_nr01 = record.data.nr01;
		params.view_grid_name='grid_d01';
		params.peg_total_count=grid_d01.peg_total_count;
		params.container_id=container_id;
		if (prop_grid_data_ajax != '') {
			if (prop_grid_data_ajax.id > 0) {
				Ext.ux.AjaxDefer.abort(prop_grid_data_ajax);
			}
		}
		prop_grid_data_ajax = pegAjaxDefer('/' + main_path + '/crm002_d01_d50/get_prop_grid_data.php', params, function (jsonData) {
			container = pegGetCmp_d('grid_prop', container_id, 'd01_d51', '', 'd01_d50');
			pegSetVal('grid_prop', container.container_id, jsonData.data);
		}, 'json', true);

		var params = {};
		params.nr01 = record.data.nr01;
		if (find_p30_ajax != '') {
			if (find_p30_ajax.id > 0) {
				Ext.ux.AjaxDefer.abort(find_p30_ajax);
			}
		}


		find_p30_ajax = pegAjaxDefer('/' + main_path + '/crm002_d01_d50/find_p30.php', params, function (jsonData) {
			if (jsonData.p30 != '') {
				container = pegGetCmp_d('p30', container_id, 'd01_d52', 'down', 'd01_d50');
				pegSetVal('p30', container.container_id, jsonData.p30);
			}


		}, 'json', true);

		crm002_d01_change_status(
			container_id,
			record.get('nr01'),
			'update'
		);
	});
	grid_d01.on('deselect', function (view, record, item, index, e, opts) {

		d01_51_container = pegGetCmp_d('grid_prop', container_id, 'd01_d51', '', 'd01_d50');
		pegSetVal('grid_prop', d01_51_container.container_id, '');
		d01_52_container = pegGetCmp_d('p30', container_id, 'd01_d52', 'down', 'd01_d50');
		pegSetVal('p30', d01_51_container.container_id, '');
		
		setTimeout(function(){
			const selected = pegGridGetSelectedRow(container_id,'grid_d01');
			if(
				!selected
				&& !(selected.nr01 > 0)
			) {
				return crm002_d01_change_status(
					container_id,
					0 ,
					'update'
				);
			}
		},1000);

	});
	grid_d01.on('edit', function (editor, context) {
		var values = {};
		values = context.record.getData({ serialize: true });
		pegSave_grid_row(
			grid_d01.peg_view__d,
			grid_d01.peg_view_table,
			grid_d01.peg_view_module,
			grid_d01.getMnr01(),
			grid_d01.getMmnr01(),
			values,
			function (jsonData) {
				if (!jsonData.ok) {
					context.record.reject();
					pegAlert(jsonData.message);
				} else {
					context.record.commit();
					//WebApp.view.grid.Grid.pegGridRefresh(grid_d01, jsonData.data.nr01);	
					return crm002_d01_change_status(
						container_id,
						values.nr01 ,
						'update'
					);
				}
			}
		);

	});
	grid_d01.on('canceledit', function (editor, context) {
		context.record.reject();
	});
	fldcont_search.on('collapse', function () {

		crm002_d01_d50_update_fldcont_search_title(container_id);
	});
	fldcont_search.on('expand', function () {

		crm002_d01_d50_update_fldcont_search_title(container_id);
	});
	crm002_d01_d50_update_fldcont_search_title(container_id);
	grid_d01.peg_grid_totalCount_handler=function( totalCount, me, meStore ){
		grid_d01.peg_total_count=totalCount;
	}
}
/**
 *  Οθόνη Δραστηριοτήτων 
 *  @param {*} container_id
 * 	@param {Boolean} pending {true|false}
 */
var crm002_d20_pending_refresh_ajax = '';
function crm002_d20_refresh(container_id, pending) {

	let screen = pegGetCmp(container_id);
	let mmnr01 = screen.getMmnr01();
	let mnr01 = screen.getMnr01();

	if (crm002_d20_pending_refresh_ajax != '') {
		if (crm002_d20_pending_refresh_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(crm002_d20_pending_refresh_ajax);
		}
	}

	params = {};
	params.mmnr01 = mmnr01;
	params.mnr01 = mnr01;
	params.container_id = container_id;
	params.pending = pending;

	crm002_d20_pending_refresh_ajax = pegAjaxDefer('/' + main_path + '/crm002_d01_d/d20_refresh_pending.php', params, function (jsondata) {
		pegGridRefresh(container_id, 'grid_d01');
	}, 'json', false);

}

function crm002_d01_d20_afterDraw_listeners(container_id) {

	let grid_d01 = pegGetCmp(container_id, 'grid_d01');
	let pendingField = pegGetCmp(container_id, 'pending');

	pendingField.on('change', function (me, newValue, oldValue, eOpts) {
		crm002_d20_refresh(container_id, newValue);
	});

	grid_d01.on('select', function (view, record, item, index, e, opts) {
		peg002_mask(container_id + '_grid_d01');
		container = pegGetCmp_d('grid_prop', container_id, 'd01_d51', '', 'd01_d20');
		var params = {};
		params.view_nr01 = record.data.nr01;
		pegAjax('/' + main_path + '/crm002_d01_d50/get_prop_grid_data.php', params, function (jsonData) {
			container = pegGetCmp_d('grid_prop', container_id, 'd01_d51', '', 'd01_d20');
			pegSetVal('grid_prop', container.container_id, jsonData.data);
		}, 'json', false);

		var params = {};
		params.nr01 = record.data.nr01;
		pegAjax('/' + main_path + '/crm002_d01_d50/find_p30.php', params, function (jsonData) {
			if (jsonData.p30 != '') {
				container = pegGetCmp_d('crmp30', container_id, 'd01_d102', 'down', 'd01_d20');
				pegSetVal('crmp30', container.container_id, jsonData.p30);
			}
			peg002_unmask(container_id + '_grid_d01');
		}, 'json', false);

		return true;
	});
	grid_d01.on('edit', function (editor, context) {
		var values = {};
		values = context.record.getData({ serialize: true });
		pegSave_grid_row(
			grid_d01.peg_view__d,
			grid_d01.peg_view_table,
			grid_d01.peg_view_module,
			grid_d01.getMnr01(),
			grid_d01.getMmnr01(),
			values,
			function (jsonData) {
				if (!jsonData.ok) {
					context.record.reject();
					pegAlert(jsonData.message);
				} else {
					context.record.commit();
					//WebApp.view.grid.Grid.pegGridRefresh(grid_d01, jsonData.data.nr01);	
				}
			}
		);
	});
}
/**
 * Δραστηριότητες From toolbarItem
 * @param {*} container_id 
 */
function crm002_crm002_d01_grid_d_afterDraw_listeners(container_id) {
	var grid = pegGetCmp(container_id, 'grid');

	grid.record_insert = function (me) {
		var curScreen = pegGetCmp(me.getContainer_ID());
		var parentScreen = pegGetCmp(curScreen.peg_screen_parent_container_id);

		var peg_table = parentScreen.peg_table;
		if (typeof peg_table == 'string' && peg_table.indexOf('peg_tmp_') === 0) {
			peg_table = peg_table.substring(8);
		}
		var nr01 = 0;
		var mnr01 = me.getGridMnr01();
		var cona11_nr01 = pegGetVal('cona11_nr01', container_id);

		pegAddTab_d(
			'',
			me.peg_view_table,
			me.peg_view__d,
			me.peg_view_module,
			'',
			nr01,
			me.store.url_vars00,
			{
				peg_screen_parent_element_name: 'grid',
				peg_screen_parent_container_id: me.getContainer_ID(),
				peg_table: peg_table,
				peg_nr01: mnr01,
				mmnr01: me.getMmnr01(),
				mnr01: mnr01,
				cona11_nr01: cona11_nr01
			},
			me.getContainer_ID(),
			me.name
		);
	};

	grid.on('edit', function (editor, context) {
		var values = {};
		values = context.record.data;

		pegSave_grid_row(
			grid.peg_view__d,
			grid.peg_view_table,
			grid.peg_view_module,
			grid.getMnr01(),
			grid.getMmnr01(),
			values,
			function (jsonData) {
				if (jsonData.ok) {
					context.record.commit();
					WebApp.view.grid.Grid.pegGridRefresh(grid, jsonData.data.nr01);
				} else {
					context.record.reject();
					pegAlert(jsonData.message);
				}
			}
		);
	});

	grid.on('canceledit', function (editor, context) {
		context.record.reject();
	});

}

/**
 * Καταστάσεις Δραστηριοτήτων
 * 
 * @param {String} container_id 
 */
function crm002_d02_d_afterDraw_listeners(container_id) {
	var screen = pegGetCmp(container_id);
	var p03 = pegGetCmp(container_id, 'p03');

	p03.on('change', function (me, newValue, oldValue, eOpts) {
		if (newValue === 3) {
			pegSetVal('p500', container_id, 1);
			pegSetVal('p501', container_id, 1);
		}
	});
}

//XXX Start Grid Row edit  
/**
 * After draw function for grid (grid_d01) @ _d d01_d50
 * @param {String} container_id 
 */
function crm002_d01_d_grid_d01_view_afterDraw_listeners(container_id) {
	var grid = null;

	grid = pegGetCmp(container_id, 'grid_d01');
	if (pegIsEmpty(grid)) {
		grid = pegGetCmp(container_id, 'grid');
	}


	var p04 = WebApp.view.grid.Grid.peg_getColumnEditor(grid, 'p04');//Προγραμματισμένη Ώρα Εναρξης
	var p08 = WebApp.view.grid.Grid.peg_getColumnEditor(grid, 'p08'); //Προγραμματισμένη Ώρα Λήξης
	var p041 = WebApp.view.grid.Grid.peg_getColumnEditor(grid, 'p041');//Πραγματική Ωρα Εναρξης 
	var p09 = WebApp.view.grid.Grid.peg_getColumnEditor(grid, 'p09');//Πραγματική Ωρα Λήξης 
	var p06 = WebApp.view.grid.Grid.peg_getColumnEditor(grid, 'p06');//Κατάσταση	  
	//	var p401  = WebApp.view.grid.Grid.peg_getColumnEditor(grid,'p401');//Προτυπη Δραστηριότητα


	var p05Column = WebApp.view.grid.Grid.peg_getColumn(grid, 'p05');//Ειδος Δραστηριοτητας 
	var p06Column = WebApp.view.grid.Grid.peg_getColumn(grid, 'p06');//Κατάσταση Δραστηριοτητας 
	var p320Column = WebApp.view.grid.Grid.peg_getColumn(grid, 'p320');//Κατάσταση Δραστηριοτητας 

	var p03Column = WebApp.view.grid.Grid.peg_getColumn(grid, 'p03');//Ημερομηνία
	var p04Column = WebApp.view.grid.Grid.peg_getColumn(grid, 'p04');//Προγρ. Ώρα Εναρξης 
	var p08Column = WebApp.view.grid.Grid.peg_getColumn(grid, 'p08');//Προγρ. Ώρα Λήξης

	var p01Column = WebApp.view.grid.Grid.peg_getColumn(grid, 'p01');//Συναλλασσόμενος 
	if (p05Column) {
		//Ειδος Δραστηριοτητας 
		p05Column.peg_set_metaData = function (value, metaData, record, rowIndex, colIndex) { 
			try {
				var v_color = record.get('v_color_d04');
				if (!pegIsEmpty(v_color)) {
					metaData.tdStyle = "background-color:#" + v_color + " ;";
				}
			} catch (error) {

			}
			return metaData;
		}
	}

	var read_color = 'EDC8C452' //'0ca5b526';

	if (p06Column) {
		//Κατάσταση Δραστηριοτητας 
		p06Column.peg_set_metaData = function (value, metaData, record, rowIndex, colIndex) { 
			try {
				var v_color = record.get('v_color_d02');
				if (!pegIsEmpty(v_color)) {
					metaData.tdStyle = "background-color:#" + v_color + " ;";
				}
			} catch (error) {

			}
			return metaData;
		}
	}


	if (p320Column) {
		//Προτεραιότητα Δραστηριοτητας 
		p320Column.peg_set_metaData = function (value, metaData, record, rowIndex, colIndex) { 
			try {
				var v_color = record.get('v_color_d60');
				if (!pegIsEmpty(v_color)) {
					metaData.tdStyle = "background-color:#" + v_color + " ;";
				}
			} catch (error) {

			}
			return metaData;
		}
	}
	if (p03Column) {
		//Ημερομηνία
		p03Column.peg_set_metaData = function (value, metaData, record, rowIndex, colIndex) { 
			try {
				if (record.data['p104'] == 0) {
					metaData.tdStyle = "background-color:#" + read_color + ";";
				} else {
					metaData.tdStyle = '';
				}
			} catch (error) {

			}
			return metaData;
		}
	}

	if (p04Column) {
		//Προγρ. Ώρα Έναρξης
		p04Column.peg_set_metaData = function (value, metaData, record, rowIndex, colIndex) { 
			try {
				if (record.data['p104'] == 0) {
					metaData.tdStyle = "background-color:#" + read_color + ";";
				} else {
					metaData.tdStyle = '';
				}
			} catch (error) {

			}
			return metaData;
		}
	}
	if (p08Column) {
		//Προγρ. Ώρα Λήξης
		p08Column.peg_set_metaData = function (value, metaData, record, rowIndex, colIndex) { 
			try {
				if (record.data['p104'] == 0) {
					metaData.tdStyle = "background-color:#" + read_color + ";";
				} else {
					metaData.tdStyle = '';
				}
			} catch (error) {

			}
			return metaData;
		}
	}
	if (p01Column) {
		//Συναλλασσόμενος
		p01Column.peg_set_metaData = function (value, metaData, record, rowIndex, colIndex) { 
			try {
				if (record.data['p104'] == 0) {
					metaData.tdStyle = "background-color:#" + read_color + ";";
				} else {
					metaData.tdStyle = '';
				}
			} catch (error) {

			}
			return metaData;
		}
	}

	if (p04) {
		//Προγραμματισμένη Ώρα Εναρξης	 
		p04.on('blur', function (me, event, eOpts) {
			crm002_d01_grid_d01_refresh(container_id, WebApp.view.grid.Grid.peg_getRowEditingGetData(grid));
		});
	}

	if (p08) {
		//Προγραμματισμένη Ώρα Λήξης 
		p08.on('blur', function (me) {
			crm002_d01_grid_d01_refresh(container_id, WebApp.view.grid.Grid.peg_getRowEditingGetData(grid));
		});
	}

	if (p041) {
		//Πραγματική Ωρα Εναρξης 
		p041.on('blur', function (me) {
			crm002_d01_grid_d01_refresh(container_id, WebApp.view.grid.Grid.peg_getRowEditingGetData(grid));
		});
	}

	if (p09) {
		//Πραγματική Ωρα Λήξης 
		p09.on('blur', function (me) {
			crm002_d01_grid_d01_refresh(container_id, WebApp.view.grid.Grid.peg_getRowEditingGetData(grid));
		});
	}

	if (p06) {
		//Κατάσταση	 
		p06.on('change', function (me) {
			crm002_d01_grid_d01_refresh(container_id, WebApp.view.grid.Grid.peg_getRowEditingGetData(grid));
		});
	}

}


function crm002_d01_d_grid_d01_toolbar_item_open_relation(container_id, id, dic) {
	var row = pegGridGetSelectedRow(container_id, id);
	if (row) {
		var nr01 = row.nr01;
		if (nr01 < 1) {
			pegAlert(dic);
			return;
		}
		crm002_d01_open_relation(nr01, container_id);
	}
}

function crm002_d01_open_relation(nr01, container_id) {

	var params = {};
	params.d01_nr01 = nr01;

	pegAjaxDefer('/' + main_path + '/crm00201/get_p50_data.php', params, function (json_data) {
		if (json_data.ok == 0) {
			pegAlert(json_data.msg);
		} else {
			pegAddTab_d('', json_data.data.table, json_data.data._d, json_data.data.module, '', json_data.data.nr01, '');
		}
	});
}
var crm002_d01_change_p02_ajax = '';
function crm002_d01_change_p02(container_id, mode = '') {
	let d01_d_container_id = pegGetContainer_id_d(container_id, 'd01_d', '', 'd01_d');
	let p01Val = pegGetVal('p01', d01_d_container_id);

	if (crm002_d01_change_p02_ajax != '') {
		if (crm002_d01_change_p02_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(crm002_d01_change_p02_ajax);
		}
	}
	var params = {};
	params.d00_nr01 = p01Val;
	params.mode = mode;

	crm002_d01_change_p02_ajax = pegAjaxDefer('/' + main_path + '/crm002_d01_d/change_p02.php', params, function (json_data) {
		if (json_data.ok == 0) {
			pegAlert(json_data.msg);
		} else {
			pegSetVal('p02', d01_d_container_id, { 'value': json_data.p02, 'display': json_data.display });
		}
	});
}

/**
 * @param {String} container_id 
 */
function crm002_d01_d99_afterDraw_listeners(container_id) {
	let screen = pegGetCmp(container_id);
	let dt_f = pegGetCmp(container_id, 'dt_f');
	let dt_t = pegGetCmp(container_id, 'dt_t');

	dt_f.on('change', function (me) {
		crm002_d01_d99_refresh(container_id);
	});
	dt_t.on('change', function (me) {
		crm002_d01_d99_refresh(container_id);
	});
}

function crm002_d01_open_week_schedule(container_id) {
	peg_windowShow_d(
		'',
		'd01_d99',
		'crm002',
		container_id,
		'',
		0,
		'',
		'c-c',
		{
			us0_p01 : pegGetVal('p02',container_id)
		},
		true,
		true,
		0,
		0,
		'tablet'
	);
}

var crm002_d01_d99_refresh_ajax = '';
function crm002_d01_d99_refresh(container_id){
	let screen = pegGetCmp(container_id);


	let p02Val = pegGetVal('p02', screen.getPeg_screen_parent_container_id());
	let dt_fVal = pegGetVal('dt_f', container_id);
	let dt_tVal = pegGetVal('dt_t', container_id);
	if (crm002_d01_d99_refresh_ajax != '') {
		if (crm002_d01_d99_refresh_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(crm002_d01_d99_refresh_ajax);
		}
	}

	let ajax_params = {};

	ajax_params.container_id = container_id;
	ajax_params.us0_p01 = p02Val;
	ajax_params.dt_f = dt_fVal;
	ajax_params.dt_t = dt_tVal;

	crm002_d01_d99_refresh_ajax = pegAjaxDefer('/' + main_path + '/crm002_d01_d/us0_week.php', ajax_params, function (json_data) {
		if (json_data.ok == 0) {
			pegAlert(json_data.msg);
		}else{
			pegGridRefresh(container_id, 'grid');
		}
	});
}
/**
 * Alias for for grid (grid) Δραστηριότητες From toolbarItem
 * @param {String} container_id 
 */
function crm002_d01_d_grid_view_afterDraw_listeners(container_id) {
	crm002_d01_d_grid_d01_view_afterDraw_listeners.call(this, container_id);
}
var crm002_d01_d50_get_alert_ajax = '';
/**
 * @param {String} container_id
 * @param {Number} d01_nr01 
 */
function crm002_d01_d50_get_alert(
	container_id = '',
	d01_nr01 = 0,
	next
) {
	const params = {
		container_id : container_id,
		d01_nr01 : d01_nr01
	};
	if (crm002_d01_d50_get_alert_ajax != '') {
		if (crm002_d01_d50_get_alert_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(crm002_d01_d50_get_alert_ajax);
		}
	}
	crm002_d01_d50_get_alert_ajax = pegAjaxDefer(
		'/' + main_path + '/crm00201/crm002_d01_d50_get_alert.php', 
		params, 
		function (doc) {
			return next(doc);
		}
	);
}
function crm002_d01_d50_play(
	container_id,
	d01_nr01
) {
	return crm002_d01_change_status(
		container_id,
		d01_nr01,
		'play',
		function(d01_nr01) {
			pegGridRefresh(container_id,'grid_d01',d01_nr01);
		}
	);
}
function crm002_d01_d50_pause(
	container_id,
	d01_nr01
) {
	return crm002_d01_change_status(
		container_id,
		d01_nr01,
		'pause',
		function(d01_nr01) {
			pegGridRefresh(container_id,'grid_d01',d01_nr01);
		}
	);
}
function crm002_d01_d50_stop(
	container_id,
	d01_nr01
) {
	return crm002_d01_change_status(
		container_id,
		d01_nr01,
		'stop',
		function(d01_nr01) {
			pegGridRefresh(container_id,'grid_d01',d01_nr01);
		}
	);
}
var crm002_d01_d_change_status_ajax = ''
function crm002_d01_change_status(
	container_id = '',
	d01_nr01 = 0,
	status = 'play',
	next
) {
	const params = {
		container_id : container_id,
		d01_nr01 : d01_nr01,
		status : status
	};
	if (crm002_d01_d_change_status_ajax != '') {
		if (crm002_d01_d_change_status_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(crm002_d01_d_change_status_ajax);
		}
	}
	crm002_d01_d_change_status_ajax = pegAjaxDefer(
	'/' + main_path + '/crm00201/crm002_d01_change_status.php', 
	params, 
	function (doc) {
		if(doc.ok != 1) {
			pegAlert(doc.msg?doc.msg:'Error');
			if(typeof next == 'function'){
				return next(d01_nr01);
			}
			return;
		}
		if(doc.error) {
			pegToast(doc.error.message,doc.error.type);
			if(typeof next == 'function'){
				return next(d01_nr01);
			}
			return;
		}
		if(
			typeof doc.data === 'undefined'
			|| typeof doc.data.html === 'undefined'
			|| doc.data.html == ''
		) {
			pegSetFieldHidden('d01_alert',container_id,true);
		} else {
			pegSetVal('d01_alert',container_id,doc.data.html)
			pegSetFieldHidden('d01_alert',container_id,false);
		}
		const main_d_container_id = pegGetContainer_id_d(container_id, '_main_d', '', '');
		const timer = pegGetCmp(main_d_container_id,'toolbarbutton_core_main_d_crm002_toolbaritem');
		const seperator = pegGetCmp('core_main_d_crm002_toolbaritem_separator');
		if(
			timer
			&& seperator
		) {
			switch(status) {
				case 'play':
					if(
						typeof doc.data !== 'undefined'
						&& doc.data.start_timer
					) {
						timer.pegStartTimer((new Date(`${doc.data.p01} ${doc.data.p011}`)).getTime());
						timer.setHidden(false)
						seperator.show()
					}
					break;
				case 'pause' :
				case 'stop' :
					seperator.hide()
					timer.setHidden(true)
					timer.pegStopTimer();
				case 'update' :
					if(
						doc.data
						&& doc.data.is_play == 1
						&& doc.data.start_timer
					) {
						timer.pegStartTimer((new Date(`${doc.data.p01} ${doc.data.p011}`)).getTime());
						timer.setHidden(false)
						seperator.show()
					} else {
						seperator.hide()
						timer.setHidden(true)
						timer.pegStopTimer();
					}
			}
		}
		if(typeof next == 'function'){
			return next(d01_nr01,doc.data);
		}
		return;
	})
}
function crm002_d01_d50_open(
	container_id,
	nr01
) {
	return pegAddTab_d(
		'',
		'd01',
		'd01_d',
		'crm002',
		'',
		nr01,
		'',
		{
		},
		container_id,
		'grid_d01'
	);
}
function core_main_d_crm002_toolbaritem(screen) {
	const container_id = screen.getContainer_ID()
	return pegAddTab_d(
		'',
		'',
		'd01_d50',
		'crm002',
		'',
		0,
		'',
		{
		},
		container_id,
		''
	);
}
var crm002_main_d_toolbaritem_initialize_alax = '';
function crm002_main_d_toolbaritem_initialize(container_id) {

	if (crm002_main_d_toolbaritem_initialize_alax != '') {
		if (crm002_main_d_toolbaritem_initialize_alax.id > 0) {
			Ext.ux.AjaxDefer.abort(crm002_main_d_toolbaritem_initialize_alax);
		}
	}
	crm002_main_d_toolbaritem_initialize_alax = pegAjaxDefer(
		'/' + main_path + '/crm00201/crm002_main_d_toolbaritem_initialize.php', 
		{}, 
		function (doc) {
			const timer = pegGetCmp(container_id,'toolbarbutton_core_main_d_crm002_toolbaritem');
			const seperator = pegGetCmp('core_main_d_crm002_toolbaritem_separator');
			if(
				timer
				&& seperator
			) {
				if(
					typeof doc.data !== 'undefined'
					&& doc.data.has_started
				) {
					timer.pegStartTimer((new Date(doc.data.time)).getTime());
					timer.setHidden(false)
					seperator.show()
				}
				
			}
		}
	);
}
function crm002_d01_d50_mass_show_create(container_id,grid_name) {
	const screen = pegGetCmp(container_id);
	const grid = pegGetCmp(container_id,grid_name);
	const params = {
		mnr01: 0,
		mmnr01: 'd01_d60-0',
		peg_screen_parent_element_name: grid.name,
		peg_screen_parent_container_id: grid.getContainer_ID(),
	};
	return peg_windowShow_d(
		'',
		'd01_d60',
		'crm002',
		container_id,
		'',
		0,
		'',
		'',
		params,
		true, 
		true, 
		0, 
		0, 
		'tablet'
	);
}
function crm002_d01_d60_afterDraw_listeners(container_id) {

	const red_color = '#ff0000';
	const green_color = '#53e087';

	const screen = pegGetCmp(container_id);
	const but00 = pegGetCmp(container_id,'but00');
	const but01 = pegGetCmp(container_id,'but01');
	const but02 = pegGetCmp(container_id,'but02');
	const d32 = pegGetCmp(container_id,'d32');
	const grid = pegGetCmp(container_id,'grid');
	const panel_1 = pegGetCmp(container_id,'panel_1');
	const pf_grid = pegGetCmp(container_id,'pf_grid');
	but00.setPeg_handler(function(me) {
		return crm002_d01_d60_selectall_days(container_id);
	});
	but01.setPeg_handler(function(me){
		return crm002_d01_d60_create_tmp_d01(container_id);
	});
	panel_1.on('collapse',function(){
		pf_grid.setCollapsed(false);
	});
	panel_1.on('expand',function(){
		pf_grid.setCollapsed(true);
	});
	pf_grid.on('collapse',function(){
		panel_1.setCollapsed(false);
	});
	pf_grid.on('expand',function(){
		panel_1.setCollapsed(true);
	});
	but02.setPeg_handler(function(me) {
		return crm002_d01_d60_create_d01_from_tmp(container_id);
	});
	d32.on('change', function (me, newValue, oldValue, eOpts) {
		if(
			pegIsEmpty(newValue)
			|| newValue == oldValue
		) {
			return;
		}
		return crm002_d01_d60_get_data_from_d32(
			newValue,
			function(data) {
				pegSetVal('d04',container_id,{value: data.d04, display: data.v_selectbox_d04});
				pegSetVal('d07',container_id,{value: data.d07, display: data.v_selectbox_d07});
				pegSetVal('d02',container_id,{value: data.d02, display: data.v_selectbox_d02});
				pegSetVal('d60',container_id,{value: data.d60, display: data.v_selectbox_d60});
			}
		);
	})
	const nr01 = WebApp.view.grid.Grid.peg_getColumn(grid, 'nr01');
	if (nr01) {
		nr01.peg_set_metaData = function (value, metaData, record, rowIndex, colIndex, store, view) {
			try {
				if(record.data['nr01'] > 0 ) {
					metaData.tdStyle = `background-color:${green_color};`;
				}else {
					metaData.tdStyle = `background-color:${red_color};`;
				}
			} catch (error) {
				console.error(error);
			}
			return metaData;
		}
	}
	grid.record_change = function(me,row) {
		return crm002_d01_d60_grid_messages(me,row);
	}
}
function crm002_d01_d60_grid_messages(me,row) {
	if(!(row.nr01 > 0)) {
		console.log(row)
		return pegToast(row.p308.replace(/(<([^>]+)>)/gi, ""),'alert')
	}
}
function crm002_d01_d60_create_d01_from_tmp(
	container_id
) {
	const d01_d60_container_id = pegGetContainer_id_d(container_id,'d01_d60','','d01_d60');
	return crm002_d01_d60_get_tmp_d01(function(data) {
		return crm002_d01_d60_d01_save_from_tmp(d01_d60_container_id,data);
	})
}
var crm002_d01_d60_get_tmp_d01_ajax ='';
function crm002_d01_d60_get_tmp_d01(
	next
) {
	if (crm002_d01_d60_get_tmp_d01_ajax != '') {
		if (crm002_d01_d60_get_tmp_d01_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(crm002_d01_d60_get_tmp_d01_ajax);
		}
	}
	crm002_d01_d60_get_tmp_d01_ajax = pegAjaxDefer(
		'/' + main_path + '/crm00201/crm002_d01_d60_get_tmp_d01.php', 
		{}, 
		function (doc) {
			if(doc.ok != 1) {
				return pegAlert(doc.msg?doc.msg:'Error');
			}
			return next(doc.data);
		}
	);
}
var crm002_d01_d60_d01_save_from_tmp_ajax = '';
/**
 * @todo change Mask / bind to pegAjaxDefer
 */
function crm002_d01_d60_d01_save_from_tmp(
	d01_d60_container_id,
	data
) {
	const screen = pegGetCmp(d01_d60_container_id);
	if(
		!data.rows
		|| data.rows.length == 0
	) {
		setTimeout(function(){
			screen.unmask();
		},3000)
		return pegGridRefresh(d01_d60_container_id,'grid');
	}
	screen.mask(data.mask.slice(-20).join("<br>\n"));
	const row = data.rows.pop();
	if (crm002_d01_d60_d01_save_from_tmp_ajax != '') {
		if (crm002_d01_d60_d01_save_from_tmp_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(crm002_d01_d60_d01_save_from_tmp_ajax);
		}
	}
	row.clear_tmp_table = data.rows.length > 0 ? 0 : 1;
	crm002_d01_d60_d01_save_from_tmp_ajax = pegAjaxDefer(
		'/' + main_path + '/crm00201/crm002_d01_d60_d01_save_from_tmp.php', 
		row,
		function (doc) {
			data.mask.push(doc.msg)
			screen.mask(data.mask.slice(-20).join("<br>\n"));
			return crm002_d01_d60_d01_save_from_tmp(d01_d60_container_id,data);
		}
	);
}
var crm002_d01_d60_create_tmp_d01_ajax = ''
function crm002_d01_d60_create_tmp_d01(
	container_id
) {
	const d01_d60_container_id = pegGetContainer_id_d(container_id,'d01_d60','','d01_d60');
	const panel_1 = pegGetCmp(d01_d60_container_id,'panel_1');
	const pf_grid = pegGetCmp(d01_d60_container_id,'pf_grid');
	let p30 = tinymce.get(Ext.getCmp( d01_d60_container_id + '_p30').getInputId()).save();
	p30 = `<div class="d01_memo_body"><p>${p30}</p></div>`;
	const params = {
		stdt : pegGetVal('stdt',d01_d60_container_id),
		endt : pegGetVal('endt',d01_d60_container_id),
		sttm : pegGetVal('sttm',d01_d60_container_id),
		entm : pegGetVal('entm',d01_d60_container_id),
		monday : pegGetVal('monday', d01_d60_container_id),
		tuesday : pegGetVal('tuesday', d01_d60_container_id),
		wednesday : pegGetVal('wednesday', d01_d60_container_id),
		thursday : pegGetVal('thursday', d01_d60_container_id),
		friday : pegGetVal('friday', d01_d60_container_id),
		saturday : pegGetVal('saturday', d01_d60_container_id),
		sunday : pegGetVal('sunday', d01_d60_container_id),
		d00 : pegGetVal('d00', d01_d60_container_id),
		us0 : pegGetVal('us0', d01_d60_container_id),
		d04 : pegGetVal('d04', d01_d60_container_id),
		d07 : pegGetVal('d07', d01_d60_container_id),
		d02 : pegGetVal('d02', d01_d60_container_id),
		d60 : pegGetVal('d60', d01_d60_container_id),
		d32 : pegGetVal('d32', d01_d60_container_id),
		p30 : p30,
		not_rsdt : pegGetVal('not_rsdt', d01_d60_container_id)
	};
	if (crm002_d01_d60_create_tmp_d01_ajax != '') {
		if (crm002_d01_d60_create_tmp_d01_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(crm002_d01_d60_create_tmp_d01_ajax);
		}
	}
	crm002_d01_d60_create_tmp_d01_ajax = pegAjaxDefer(
		'/' + main_path + '/crm00201/crm002_d01_d60_create_tmp_d01.php', 
		params, 
		function (doc) {
			if(doc.ok != 1) {
				return pegAlert(doc.msg?doc.msg:'Error');
			}
			panel_1.setCollapsed(true);
			pf_grid.setCollapsed(false);
			return pegGridRefresh(d01_d60_container_id,'grid')
		}
	);
}
var crm002_d01_d60_get_data_from_d32_alax = '';
function crm002_d01_d60_get_data_from_d32(
	d32_nr01 = 0,
	next
) {
	if (crm002_d01_d60_get_data_from_d32_alax != '') {
		if (crm002_d01_d60_get_data_from_d32_alax.id > 0) {
			Ext.ux.AjaxDefer.abort(crm002_d01_d60_get_data_from_d32_alax);
		}
	}
	const params = {
		d32_nr01 : d32_nr01
	};
	crm002_d01_d60_get_data_from_d32_alax = pegAjaxDefer(
		'/' + main_path + '/crm00201/crm002_d01_d60_get_data_from_d32.php', 
		params, 
		function (doc) {
			if(doc.ok != 1) {
				return;
			}
			if(typeof next == 'function'){
				return next(doc.data);
			}
			return;
		}
	);
}
function crm002_d01_d60_selectall_days(container_id) {
	const monday = pegGetVal('monday', container_id);
	const tuesday = pegGetVal('tuesday', container_id);
	const wednesday = pegGetVal('wednesday', container_id);
	const thursday = pegGetVal('thursday', container_id);
	const friday = pegGetVal('friday', container_id);
	const saturday = pegGetVal('saturday', container_id);
	const sunday = pegGetVal('sunday', container_id);
	if (
		monday == 1 
		&& tuesday == 1 
		&& wednesday == 1  
		&& thursday == 1  
		&& friday == 1  
		&& saturday == 1 
		&& sunday == 1 
	) {
		pegSetVal('monday', container_id, 0);
		pegSetVal('tuesday', container_id, 0);
		pegSetVal('wednesday', container_id, 0);
		pegSetVal('thursday', container_id, 0);
		pegSetVal('friday', container_id, 0);
		pegSetVal('saturday', container_id, 0);
		pegSetVal('sunday', container_id, 0);
		return;
	}
	pegSetVal('monday', container_id, 1);
	pegSetVal('tuesday', container_id, 1);
	pegSetVal('wednesday', container_id, 1);
	pegSetVal('thursday', container_id, 1);
	pegSetVal('friday', container_id, 1);
	pegSetVal('saturday', container_id, 1);
	pegSetVal('sunday', container_id, 1);

}
function crm002_d01_d_save_update_btn_action(screen) {
	const container_id = screen.getPeg_screen_parent_container_id();
	const nr01 = screen.getMnr01();
	if(
		typeof nr01 == 'undefined'
		|| !(nr01 > 0)
	) {
		return;
	}
	return crm002_d01_change_status(
		container_id,
		nr01,
		'update'
	)
}

function crm002_d01_d50_show_d01_d61(container_id,grid_name) {
	const grid = pegGetCmp(container_id,grid_name);
	const params = {
		peg_screen_parent_element_name: grid.name,
		peg_screen_parent_container_id: grid.getContainer_ID(),
	};
	return peg_windowShow_d(
		'',
		'd01_d61',
		'crm002',
		container_id,
		'',
		0,
		'',
		'',
		params,
		true, 
		true, 
		0, 
		0, 
		'tablet'
	);
}

var crm002_d01_d61_toolbaritem_change_ajax = '';
function crm002_d01_d61_toolbaritem_change(screen) {
	const container_id = screen.getContainer_ID();
	const d01_d50_container_id = pegGetContainer_id_d(container_id, 'd01_d50', '', 'd01_d50');
	const grid = pegGetCmp(d01_d50_container_id,'grid_d01');
	const selections = grid.getSelection();
	if(
		typeof selections == 'undefined'
		|| selections.length == 0
	) {
		return pegGetDic('peg_dic_core_no_item_selected',function(msg) {
			return pegAlert(msg);
		})
	}
	const nr01 = [];
	for(selection of selections) {
		nr01.push(selection.get('nr01'));
	}
	const params = {
		nr01s : nr01.join(';'),
		dt : pegGetVal('dt',container_id),
		us0 : pegGetVal('us0',container_id),
		d02 : pegGetVal('d02',container_id),
	}


	if (crm002_d01_d61_toolbaritem_change_ajax != '') {
		if (crm002_d01_d61_toolbaritem_change_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(crm002_d01_d61_toolbaritem_change_ajax);
		}
	}
	crm002_d01_d61_toolbaritem_change_ajax = pegAjaxDefer(
		'/' + main_path + '/crm00201/crm002_d01_d61_d01_mass_change.php', 
		params, 
		function (doc) {
			if(doc.ok != 1) {
				return pegAlert(doc.msg?doc.msg:'Error');
			}
			if(doc.data.error && doc.data.error.length > 0) {
				pegAlert(doc.data.error.join('<br>'));
			} else {
				pegWindowClose(container_id);
			}
			return pegGridRefresh(d01_d50_container_id,'grid_d01');
		}
	);
}
