<?php
class d99104
{
	protected $d01_nr01 = 0;
	protected $d01_p03 = 0;

	protected $d02_p01_play = 0;
	protected $d02_p02_play = '';
	protected $d02_p201_play = '';

	protected $d02_p01_pause = 0;
	protected $d02_p02_pause = '';
	protected $d02_p201_pause = '';

	protected $d02_p01_stop = 0;
	protected $d02_p02_stop = '';
	protected $d02_p201_stop = '';
	/**
	 *
	 * @param  integer $d01_nr01
	 * @param  string  $d01_p03
	 */
	public function __construct(
		$d01_nr01 = 0,
		$d01_p03 = ''
	) {
		if ($d01_nr01 > 0) {
			$this->set_d01(
				$d01_nr01,
				$d01_p03
			);
		}
	}
	/**
	 * Αρχικοποίηση εγγραφής (d01) και παραμέτρων (cmr002)
	 * @param  integer $d01_nr01
	 * @param  string  $d01_p03
	 * @return array
	 */
	public function set_d01(
		$d01_nr01 = 0,
		$d01_p03 = ''
	) {
		$this->d01_nr01 = $d01_nr01;
		return $this->initialize($d01_p03);
	}
	/**
	 *
	 * Action: Κάνει έλεγχο και ορίζει την κατάσταση της δραστηριότητας σε [cmr002.d01_d02_play].
	 * Αν το checkOnlyPerm είναι true κάνει μόνο τον έλεγχο.
	 * Αν δεν υπάρχει άλλη σε εξέλιξη, δημιουργεί νέα εγγραφή στον d99104.
	 *
	 * @param  array   $d01					Η δραστηριότητα αναφοράς
	 * @param  boolean $checkOnlyPerm		Αν είναι μόνο έλεγχος ή όχι
	 * @param  string  $container_id		Το container id της οθόνης του ημερολογίου
	 * @param  string  $p011				Η ώρα έναρξης
	 * @return array data[
	 * - is_play		Αν η εγγραφή βρίσκετε σε play status
	 * - start_timer	Αν θα πρέπει να ξεκινήσει να μετράει ο timer στην main _d
	 * - nr01			Το nr01 του d99104
	 * - p01			Το p01 του d99104 (ημερομηνία)
	 * - p011			Το p011 του d99104 (ώρα)
	 * - d02_p01		Την κατάσταση της δραστηριότητας
	 * - d02_p02		Το λεκτικό της κατάστασης της δραστηριότητας
	 * - d02_p201		Το χρώμα της κατάστασης της δραστηριότητας
	 * - html			Το alert που πρέπει να προστεθεί στην d01_d50 (Ενδέχεται να μην αναφέρεται σε αυτήν την d01 αλλά σε αυτήν που πρέπει να προβληθεί)
	 * ]
	 */
	public function play(
		$d01 = array(),
		$checkOnlyPerm = false,
		$container_id = '',
		$p011 = ''
	) {
		if ($this->d01_p03 != date('Y-m-d')) {
			// Δεν μπείτε να κάνετε έναρξη σε δραστηριότητα που είναι καταχωρημένη διαφορετική ημερομηνία από την σημερινή.
			return array(
				'ok'	=> 0,
				'type'	=> 'deny',
				'msg' => $_SESSION['peg_dic_crm002_d99104_play_not_today']
			);
		}
		if ($p011 > date('H:i:s')) {
			// Δεν μπορείτε να κάνετε έναρξη δραστηριότητας σε μεταγενέστερη ώρα.
			return array(
				'ok'	=> 0,
				'type'	=> 'deny',
				'msg' => $_SESSION['peg_dic_crm002_d99104_play_time_later']
			);
		}
		if ($_SESSION['crm002_d01_play_single'] == 1) {
			$other_d01_play = pegasus_mysql_printfld(
				'd01',
				'IFNULL(COUNT(nr01),0)',
				'
						d01.nr01 != :nr01
						AND d01.p06 = :p06
						AND p02 = :p02
					',
				array(
					'nr01'	=> $this->d01_nr01,
					'p06'	=> $_SESSION['crm002_d01_d02_play'],
					'p02'	=> $d01['p02']
				)
			);
			if ($other_d01_play > 0) {
				// Δεν μπορείτε να έχετε σε κατάσταση #name# πάνω από μια δραστηριότητες.
				$msg = str_replace(
					'#name#',
					"<b>" . pegasus_mysql_printfld('d02', 'p02', 'p01 = :p01', array('p01' => $_SESSION['crm002_d01_d02_play'])) . "</b>",
					$_SESSION['peg_dic_crm002_d99104_play_only_1_play']
				);
				if ($d01['p02'] != $_SESSION['username']) {
					$msg .= " " . $_SESSION['peg_dic_crm002_d99104_play_only_1_play_user'] . ": ";
					$msg .= pegasus_mysql_printfld(
						'us0',
						'p100',
						'p01 = :p01',
						array(
							'p01' => $d01['p02']
						)
					);
				}
				return array(
					'ok'	=> 0,
					'type'	=> 'deny',
					'msg' 	=> $msg
				);
			}
		}

		if (empty($p011)) {
			$p011 = date('H:i:s');
		}
		$play = $this->get_play();
		if ($play['ok'] != 1) {
			return $play;
		}
		if ($checkOnlyPerm) {
			return array(
				'ok'	=> 1,
				'msg'	=> 'Permission Check Pass'
			);
		}
		if ($play['data']['is_play'] == 0) {
			$p01 = $this->d01_p03;
			$insert = array(
				'nr01'	=> pegasus_mysql_newrec('d99104'),
				'us0'	=> $d01['p02'],
				'd01'	=> $this->d01_nr01,
				'p01'	=> $p01,
				'p011'	=> $p011,
				'p02'	=> '0100-01-01',
				'p021'	=> '',
			);
			pegasus_mysql_insert(
				'd99104',
				array_keys($insert),
				array_values($insert)
			);
		}
		$html = '';
		$status = $this->get_status($container_id);
		if ($status['ok'] == 1) {
			$html = $status['data']['html'];
		}
		$date = peg_dateToStr("{$insert['p01']} {$insert['p011']}", 'd/m/Y H:i:s');
		$msg = $_SESSION['peg_dic_crm002_d99104_play_success'] . " $this->d02_p02_play: $date";
		$start_timer = false;
		if ($d01['p02'] == $_SESSION['username']) {
			$start_timer = true;
		}
		return array(
			'ok'	=> 1,
			'data'	=> array(
				'is_play'		=> 1,
				'start_timer'	=> $start_timer,
				'nr01'			=> $insert['nr01'],
				'p01'			=> $insert['p01'],
				'p011'			=> $insert['p011'],
				'd02_p01'		=> $this->d02_p01_play,
				'd02_p02'		=> $this->d02_p02_play,
				'd02_p201'		=> $this->d02_p201_play,
				'html'			=> $html
			),
			'msg'	=> $msg
		);
	}
	/**
	 *
	 * Action: Κάνει έλεγχο και ορίζει την κατάσταση της δραστηριότητας σε [cmr002.d01_d02_pause].
	 * Αν το checkOnlyPerm είναι true κάνει μόνο τον έλεγχο.
	 *
	 * @param  array   $d01					Η δραστηριότητα αναφοράς
	 * @param  boolean $checkOnlyPerm		Αν είναι μόνο έλεγχος ή όχι
	 * @param  string  $container_id		Το container id της οθόνης του ημερολογίου
	 * @return array data[
	 * - is_play		Αν η εγγραφή βρίσκετε σε play status
	 * - start_timer	Αν θα πρέπει να ξεκινήσει να μετράει ο timer στην main _d
	 * - nr01			Το nr01 του d99104
	 * - p01			Το p01 του d99104 (ημερομηνία)
	 * - p011			Το p011 του d99104 (ώρα)
	 * - d02_p01		Την κατάσταση της δραστηριότητας
	 * - d02_p02		Το λεκτικό της κατάστασης της δραστηριότητας
	 * - d02_p201		Το χρώμα της κατάστασης της δραστηριότητας
	 * - html			Το alert που πρέπει να προστεθεί στην d01_d50 (Ενδέχεται να μην αναφέρεται σε αυτήν την d01 αλλά σε αυτήν που πρέπει να προβληθεί)
	 * ]
	 */
	public function pause(
		$d01 = array(),
		$checkOnlyPerm = false,
		$container_id = ''
	) {
		$play = $this->get_play();
		if ($play['ok'] != 1) {
			return $play;
		}
		if ($checkOnlyPerm) {
			return array(
				'ok'	=> 1,
				'msg'	=> 'Permission Check Pass'
			);
		}
		$update = array(
			'p02'	=> date('Y-m-d'),
			'p021'	=> date('H:i:s')
		);
		pegasus_mysql_update(
			'd99104',
			array_keys($update),
			array_values($update),
			'nr01 = :nr01',
			0,
			1,
			1,
			array(
				'nr01' => $play['data']['nr01']
			)
		);
		$html = '';
		$status = $this->get_status($container_id);
		if ($status['ok'] == 1) {
			$html = $status['data']['html'];
		}
		// Πραγματοποιήθηκε παύση
		$date = peg_dateToStr("{$update['p02']} {$update['p021']}", 'd/m/Y H:i:s');
		$msg = $_SESSION['peg_dic_crm002_d99104_pause_success'] . " $date";
		return array(
			'ok'	=> 1,
			'data'	=> array(
				'is_play'	=> 1,
				'nr01'		=> $play['data']['nr01'],
				'p01'		=> $play['data']['p01'],
				'p011'		=> $play['data']['p011'],
				'p02'		=> $update['p02'],
				'p021'		=> $update['p021'],
				'd02_p01'	=> $this->d02_p01_pause,
				'd02_p02'	=> $this->d02_p02_pause,
				'd02_p201'	=> $this->d02_p201_pause,
				'html'		=> $html
			),
			'msg'	=> $msg
		);
	}
	/**
	 *
	 * Action: Κάνει έλεγχο και ορίζει την κατάσταση της δραστηριότητας σε [cmr002.d01_d02_stop].
	 * Αν το checkOnlyPerm είναι true κάνει μόνο τον έλεγχο.
	 *
	 * @param  array   $d01					Η δραστηριότητα αναφοράς
	 * @param  boolean $checkOnlyPerm		Αν είναι μόνο έλεγχος ή όχι
	 * @param  string  $container_id		Το container id της οθόνης του ημερολογίου
	 * @param  string  $p02					Ημερομηνία περάτωσης
	 * @param  string  $p021				Ώρα  περάτωσης
	 * @param  string  $p011				Ώραέναρξης
	 * @return array data[
	 * - is_play		Αν η εγγραφή βρίσκετε σε play status
	 * - start_timer	Αν θα πρέπει να ξεκινήσει να μετράει ο timer στην main _d
	 * - nr01			Το nr01 του d99104
	 * - p01			Το p01 του d99104 (ημερομηνία)
	 * - p011			Το p011 του d99104 (ώρα)
	 * - d02_p01		Την κατάσταση της δραστηριότητας
	 * - d02_p02		Το λεκτικό της κατάστασης της δραστηριότητας
	 * - d02_p201		Το χρώμα της κατάστασης της δραστηριότητας
	 * - html			Το alert που πρέπει να προστεθεί στην d01_d50 (Ενδέχεται να μην αναφέρεται σε αυτήν την d01 αλλά σε αυτήν που πρέπει να προβληθεί)
	 * ]
	 */
	public function stop(
		$d01 = array(),
		$checkOnlyPerm = false,
		$container_id = '',
		$p02 = '',
		$p021 = '',
		$p011 = ''
	) {
		$p01 = $this->d01_p03;
		$play = $this->get_play();
		if ($play['ok'] != 1) {
			return $play;
		}
		$d99104 = array(
			'p01'	=> $p01,
			'p011'	=> date('H:i:s'),
			'p02'	=> date('Y-m-d'),
			'p021'	=> date('H:i:s'),
		);
		if ($play['data']['is_play'] == 1) {
			$d99104['p01'] = $play['data']['p01'];
			$d99104['p011'] = $play['data']['p011'];
		}
		if ($p02 > '0100-01-01') {
			$d99104['p02'] = $p02;
			if (empty($p021)) {
				$p021 = '00:00:00';
			}
			$d99104['p021'] = $p021;
		}
		if (!empty($p011)) {
			$d99104['p011'] = $p011;
		}
		if (
			$d99104['p01'] > $d99104['p02']
			|| ($d99104['p01'] == $d99104['p02']
				&& $d99104['p011'] > $d99104['p021']
			)
		) {
			// Δεν μπορείτε να σταματήσετε την δραστηριότητα πριν από τις
			return array(
				'ok'	=> 0,
				'type'	=> 'deny',
				'msg'	=> $_SESSION['peg_dic_crm002_d99104_stop_error_time'] . " {$d99104['p01']} {$d99104['p011']}"
			);
		}
		if ($checkOnlyPerm) {
			return array(
				'ok'	=> 1,
				'msg'	=> 'Permission Check Pass'
			);
		}
		$date = peg_dateToStr("{$d99104['p02']} {$d99104['p021']}", 'd/m/Y H:i:s');
		// Έγινε τερματισμός της δραστηριότητας
		$msg = $_SESSION['peg_dic_crm002_d99104_stop_success'] . " $date";
		if ($play['data']['is_play'] == 1) {
			pegasus_mysql_update(
				'd99104',
				array_keys($d99104),
				array_values($d99104),
				'nr01 = :nr01',
				0,
				1,
				1,
				array(
					'nr01' => $play['data']['nr01']
				)
			);
			$d99104['nr01'] = $play['data']['nr01'];
		} elseif (
			$d99104['p01'] != $d99104['p02']
			|| $d99104['p011'] != $d99104['p021']
		) {
			$d99104['nr01'] = pegasus_mysql_newrec('d99104');
			pegasus_mysql_insert(
				'd99104',
				array_keys($d99104),
				array_values($d99104)
			);
		}
		$html = '';
		$status = $this->get_status($container_id);
		if ($status['ok'] == 1) {
			$html = $status['data']['html'];
		}
		return array(
			'ok'	=> 1,
			'data'	=> array(
				'is_play'	=> 1,
				'nr01'		=> $d99104['nr01'],
				'p01'		=> $d99104['p01'],
				'p011'		=> $d99104['p011'],
				'p02'		=> $d99104['p02'],
				'p021'		=> $d99104['p021'],
				'd02_p01'	=> $this->d02_p01_stop,
				'd02_p02'	=> $this->d02_p02_stop,
				'd02_p201'	=> $this->d02_p201_stop,
				'html'		=> $html
			),
			'msg'	=> $msg
		);
	}
	/**
	 * Επιστρέφει στα στοιχεία του χρόνου δραστηριότητας αν υπάρχει χρόνος δραστηριότητα σε εξέλιξη για αυτήν την  δραστηριότητα.
	 *
	 * @return array
	 */
	protected function get_play()
	{
		if (!($this->d01_nr01 > 0)) {
			// Δεν έχετε ορίσει δραστηριότητα
			return array(
				'ok'		=> 0,
				'type'		=> 'deny',
				'msg'		=> $_SESSION['peg_dic_crm002_d99104_d_no_d01_set']
			);
		}
		$sql = "	SELECT
							d99104.nr01,
							d99104.p01,
							d99104.p011
						FROM d99104
						WHERE 1 =1
						AND d99104.d01 = :d99104_d01
						AND IFNULL(d99104.p01,'') > :d99104_p01
						AND IFNULL(d99104.p02,'') <= :d99104_p02
						ORDER BY d99104.p01 ASC, d99104.p011 ASC
						LIMIT 0,1
			";
		$values = array(
			'd99104_d01'	=> $this->d01_nr01,
			'd99104_p01'	=> '0100-010-01',
			'd99104_p02'	=> '0100-010-01'
		);
		$res = pegasus_query($sql, $values);
		if (pegasus_num_rows($res) == 0) {
			// Δεν βρέθηκε έναρξη
			return array(
				'ok'		=> 1,
				'data'		=> array(
					'is_play'	=> 0
				),
				'msg'	=> $_SESSION['peg_dic_crm002_d99104_get_play_no_start']
			);
		}
		$rs = pegasus_fetch_assoc($res);
		// Βρέθηκε έναρξη
		return array(
			'ok'	=> 1,
			'data'	=> array(
				'is_play'	=> 1,
				'nr01'	=> $rs['nr01'],
				'p01'	=> $rs['p01'],
				'p011'	=> $rs['p011'],
			),
			'msg'	=> $_SESSION['peg_dic_crm002_d99104_get_play_start'] . " ({$rs['nr01']})"
		);
	}
	/**
	 * Τα στοιχεία του χρόνο δραστηριότητας (αν υπάρχουν) και το HTML που πρέπει να προβάλει στο alert της d01_d50
	 *
	 * @param  string  $container_id
	 * @param  integer $d01_p06
	 * @return array
	 */
	public function get_status(
		$container_id = ''
	) {
		$playing = $this->get_us0_d01_playing();
		if ($playing['ok'] == 1) {
			$this->set_d01($playing['data']['nr01']);
		}
		if (!($this->d01_nr01 > 0)) {
			return $this->get_default_status(true, $container_id);
		}
		$d01 = $this->get_d01_data();
		if ($d01['p02'] != $_SESSION['username']) {
			return $this->get_default_status(true, $container_id);
		}
		switch ($d01['p06']) {
			case $_SESSION['crm002_d01_d02_play']:
				return $this->get_play_status($container_id, $d01);
				break;
			case $_SESSION['crm002_d01_d02_pause']:
				return $this->get_pause_status($container_id, $d01);
				break;
			case $_SESSION['crm002_d01_d02_stop']:
				return $this->get_stop_status($container_id, $d01);
				break;
			default:
				return $this->get_pause_status($container_id, $d01);
		}
	}
	/**
	 * Επιστρέφει την πρώτη διορατικότατα που θα βρει και είναι σε κατάσταση play για τον login user
	 *
	 * @return array data[
	 * - nr01	d01.nr01
	 * ]
	 */
	private function get_us0_d01_playing()
	{
		$d01_nr01 = pegasus_mysql_printfld(
			'd01',
			'nr01',
			'p02 = :p02 AND p06 = :p06',
			array(
				'p02'	=> $_SESSION['username'],
				'p06'	=> $_SESSION['crm002_d01_d02_play']
			)
		);
		if (!($d01_nr01 > 0)) {
			return array(
				'ok'	=> 0
			);
		}
		return array(
			'ok'	=> 1,
			'data'	=> array(
				'nr01'	=> $d01_nr01
			)
		);
	}
	/**
	 * Επιστρέφει το alert για το play status και πληροφορία για το αν είναι σε κατάσταση play και αν
	 * θα πρέπει να κάνει start ο timer της main _d
	 *
	 * @param  string $container_id		Το container id της οθόνης του ημερολογίου
	 * @param  array  $d01				Η δραστηριότητα αναφοράς
	 * @return array data[
	 * - is_play		Αν η δραστηριότητα βρίσκετε σε κατάσταση play
	 * - nr01			Το nr01 του χρόνου δραστηριότητας
	 * - p01			Την ημερομηνία του χρόνου δραστηριότητας
	 * - p011			Την ώρα του χρόνου δραστηριότητας
	 * - start_timer	Αν θα πρέπει να ξεκινήσει ο timer της main _d
	 * - html			 Το HTML για το alert της d01_d50
	 * ]
	 */
	protected function get_play_status(
		$container_id = '',
		$d01 = array()
	) {
		$play = $this->get_play();
		$template = peg_read_file('../crm002_templates/d01_d_alert.html');
		$style = pegasus_get_text_inside_tags('<!--style-start-->', '<!--style-end-->', $template);
		$alert = pegasus_get_text_inside_tags('<!--success-start-->', '<!--success-end-->', $template);
		$time = array();
		if (!empty($d01['p04'])) {
			$time[] = '<span class="start"></span>' . $d01['p04'];
		}
		if (!empty($d01['p08'])) {
			$time[] = '<span class="end"></span>' . $d01['p08'];
		}
		$time = implode(' - ', $time);
		$message = "{$d01['d00_p19']}<span>{$d01['p308']}</span>";
		$play_busy = 'data-busy="true"';
		$actions = $this->build_alert_actions(
			$container_id,
			$d01
		);
		$html = str_replace(
			array(
				'{{time}}',
				'{{description}}',
				'{{text-onclick}}',
				'{{buttons}}',

				'{{play-disabled}}',
				'{{pause-disabled}}',
				'{{stop-disabled}}',


				'{{play-busy}}',
				'{{pause-busy}}',
				'{{stop-busy}}',

				'{{play-onclick}}',
				'{{pause-onclick}}',
				'{{stop-onclick}}',

				'{{start-label}}',
				'{{end-label}}',
			),
			array(
				$time,
				$message,
				$actions['text_onclick'],
				'',

				'disabled="disabled"',
				'',
				'',

				$play_busy,
				'',
				'',

				$actions['play_onclick'],
				$actions['pause_onclick'],
				$actions['stop_onclick'],

				$_SESSION['peg_dic_crm002_d99104_start_label'],
				$_SESSION['peg_dic_crm002_d99104_end_label']
			),
			$style . $alert
		);
		$data = array(
			'html'	=> $html
		);
		$start_timer = false;
		if ($d01['p02'] == $_SESSION['username']) {
			$start_timer = true;
		}
		if ($play['ok'] == 1) {
			$data['is_play'] = $play['data']['is_play'];
			if ($play['data']['is_play'] == 1) {
				$data['nr01'] = $play['data']['is_play'];
				$data['p01'] = $play['data']['p01'];
				$data['p011'] = $play['data']['p011'];
				$data['start_timer'] = $start_timer;
			}
		}
		return array(
			'ok'	=> 1,
			'data'	=> $data,
			'msg'	=> $message
		);
	}
	/**
	 * Επιστρέφει το alert για το stop status
	 *
	 * @param  string $container_id		Το container id της οθόνης του ημερολογίου
	 * @param  array  $d01				Η δραστηριότητα αναφοράς
	 * @return array data[
	 * - html							 Το HTML για το alert της d01_d50
	 * ]
	 */
	protected function get_stop_status(
		$container_id = '',
		$d01 = array()
	) {
		$template = peg_read_file('../crm002_templates/d01_d_alert.html');
		$style = pegasus_get_text_inside_tags('<!--style-start-->', '<!--style-end-->', $template);
		$alert = pegasus_get_text_inside_tags('<!--info-start-->', '<!--info-end-->', $template);
		$time = array();
		if (!empty($d01['p04'])) {
			$time[] = '<span class="start"></span>' . $d01['p04'];
		}
		if (!empty($d01['p08'])) {
			$time[] = '<span class="end"></span>' . $d01['p08'];
		}
		$time = implode(' - ', $time);
		$message = "{$d01['d00_p19']}<span>{$d01['p308']}</span>";
		$actions = $this->build_alert_actions(
			$container_id,
			$d01
		);
		$html = str_replace(
			array(
				'{{time}}',
				'{{description}}',
				'{{text-onclick}}',
				'{{buttons}}',

				'{{play-disabled}}',
				'{{pause-disabled}}',
				'{{stop-disabled}}',

				'{{play-busy}}',
				'{{pause-busy}}',
				'{{stop-busy}}',

				'{{play-onclick}}',
				'{{pause-onclick}}',
				'{{stop-onclick}}',

				'{{start-label}}',
				'{{end-label}}'
			),
			array(
				$time,
				$message,
				$actions['text_onclick'],
				'',

				'',
				'disabled="disabled"',
				'disabled="disabled"',

				'',
				'',
				'',

				$actions['play_onclick'],
				$actions['pause_onclick'],
				$actions['stop_onclick'],

				$_SESSION['peg_dic_crm002_d99104_start_label'],
				$_SESSION['peg_dic_crm002_d99104_end_label']
			),
			$style . $alert
		);
		return array(
			'ok'	=> 1,
			'data'	=> array(
				'html'	=> $html
			),
			'msg'	=> $message
		);
	}
	/**
	 * Επιστρέφει το alert για το stop status
	 *
	 * @param  string $container_id		Το container id της οθόνης του ημερολογίου
	 * @param  array  $d01				Η δραστηριότητα αναφοράς
	 * @return array data[
	 * - html							 Το HTML για το alert της d01_d50
	 * ]
	 */
	protected function get_pause_status(
		$container_id = '',
		$d01 = array()
	) {
		$message = "Επιλέξτε Δραστηριότητα";
		$template = peg_read_file('../crm002_templates/d01_d_alert.html');
		$style = pegasus_get_text_inside_tags('<!--style-start-->', '<!--style-end-->', $template);
		$alert = pegasus_get_text_inside_tags('<!--info-start-->', '<!--info-end-->', $template);
		$time = array();
		if (!empty($d01['p04'])) {
			$time[] = '<span class="start"></span>' . $d01['p04'];
		}
		if (!empty($d01['p08'])) {
			$time[] = '<span class="end"></span>' . $d01['p08'];
		}
		$time = implode(' - ', $time);
		$message = "{$d01['d00_p19']}<span>{$d01['p308']}</span>";
		$actions = $this->build_alert_actions(
			$container_id,
			$d01
		);
		$stop_disabled = 'disabled="disabled"';
		if (pegasus_mysql_printfld('d99104', 'COUNT(nr01)', 'd01 = :d01', array('d01' => $this->d01_nr01)) > 0) {
			$stop_disabled = '';
		}

		$html = str_replace(
			array(
				'{{time}}',
				'{{description}}',
				'{{text-onclick}}',
				'{{buttons}}',

				'{{play-disabled}}',
				'{{pause-disabled}}',
				'{{stop-disabled}}',

				'{{play-busy}}',
				'{{pause-busy}}',
				'{{stop-busy}}',

				'{{play-onclick}}',
				'{{pause-onclick}}',
				'{{stop-onclick}}',

				'{{start-label}}',
				'{{end-label}}'
			),
			array(
				$time,
				$message,
				$actions['text_onclick'],
				'',

				'',
				'disabled="disabled"',
				$stop_disabled,

				'',
				'',
				'',

				$actions['play_onclick'],
				$actions['pause_onclick'],
				$actions['stop_onclick'],

				$_SESSION['peg_dic_crm002_d99104_start_label'],
				$_SESSION['peg_dic_crm002_d99104_end_label']
			),
			$style . $alert
		);
		return array(
			'ok'	=> 1,
			'data'	=> array(
				'html'	=> $html
			),
			'msg'	=> $message
		);
	}
	/**
	 * Επιστρέφει τι θα πρέπει να έχει το alert HTML της d01_d50 αν δεν έχουμε κάποια από τις γνωστές καταστάσεις (play / pause / stop).
	 *
	 * @param  boolean $only_info_message
	 * @param  string  $container_id
	 * @param  array   $d01
	 * @return array
	 */
	protected function get_default_status(
		$only_info_message = true,
		$container_id = '',
		$d01 = array()
	) {
		if ($only_info_message) {
			return array(
				'ok'	=> 1,
				'data'	=> array(
					'html'	=> ''
				),
				'msg'	=> ''
			);
		}
		$message = "{$d01['d00_p19']}<span>{$d01['p308']}</span>";
		$template = peg_read_file('../crm002_templates/d01_d_alert.html');
		$style = pegasus_get_text_inside_tags('<!--style-start-->', '<!--style-end-->', $template);
		$alert = pegasus_get_text_inside_tags('<!--info-start-->', '<!--info-end-->', $template);
		$html = str_replace(
			array(
				'{{time}}',
				'{{description}}',
				'{{buttons}}'
			),
			array(
				'',
				$message,
				'style="display:none"'
			),
			$style . $alert
		);
		return array(
			'ok'	=> 1,
			'data'	=> array(
				'html'	=> $html
			),
			'msg'	=> $message
		);
	}
	/**
	 * Δημιουργεί τα JS function για τα button των alert (play / pause / stop)
	 *
	 * @param  string $container_id
	 * @param  array  $d01
	 * @return string
	 */
	private function build_alert_actions(
		$container_id = '',
		$d01 = array()
	) {

		$play_onclick = "crm002_d01_d50_play('$container_id','{$d01['nr01']}')";
		$pause_onclick = "crm002_d01_d50_pause('$container_id','{$d01['nr01']}')";
		$stop_onclick = "crm002_d01_d50_stop('$container_id','{$d01['nr01']}')";

		$text_onclick = "crm002_d01_d50_open('$container_id','{$d01['nr01']}')";

		return array(
			'play_onclick'	=> $play_onclick,
			'pause_onclick'	=> $pause_onclick,
			'stop_onclick'	=> $stop_onclick,
			'text_onclick'	=> $text_onclick
		);
	}
	/**
	 * Αρχικοποιεί της παραμέτρους της κλάσις από της βασικές παραμέτρους δραστηριοτήτων
	 * Ορίζει την ημερομηνία της δραστηριότητας αν έχει αρχικοποιηθεί.
	 *
	 * @return array
	 */
	protected function initialize(
		$d01_p03 = ''
	) {
		$sql = "	SELECT
							d02_00.p01 		AS d02_p01_play,
							d02_00.p02 		AS d02_p02_play,
							d02_00.p201_cl	AS d02_p201_play,
							d02_01.p01 		AS d02_p01_pause,
							d02_01.p02 		AS d02_p02_pause,
							d02_01.p201_cl	AS d02_p201_pause,
							d02_02.p01 		AS d02_p01_stop,
							d02_02.p02 		AS d02_p02_stop,
							d02_02.p201_cl	AS d02_p201_stop,
							d01_00.nr01 	AS d01_nr01,
							d01_00.p03 		AS d01_p03
						FROM crm002
						LEFT JOIN d02 AS d02_00 ON d02_00.p01 = crm002.d01_d02_play
						LEFT JOIN d02 AS d02_01 ON d02_01.p01 = crm002.d01_d02_pause
						LEFT JOIN d02 AS d02_02 ON d02_02.p01 = crm002.d01_d02_stop
						LEFT JOIN d01 AS d01_00 ON d01_00.nr01 = :nr01
						WHERE crm002.nr01 = 1
			";
		$check = array();
		pegasus_mysql_use($sql, $check, array('nr01' => $this->d01_nr01));
		// Παίρνουμε και το d01.p03 γιατί αλλιώς  θα πρέπει να το προσθέσουμε σαν arg στα κουμπιά της alert της d01_d50 (το οποίο είναι επισφαλές)
		if (!empty($d01_p03)) {
			$check['d01_p03'] = $d01_p03;
		}
		if (!($check['d02_p01_play'] > 0)) {
			// Δεν έχετε ορίσει κατάσταση έναρξης στις βασικές παραμέτρους δραστηριοτήτων
			return array(
				'ok'	=> 0,
				'msg'	=> $_SESSION['peg_dic_crm002_d99104_initialize_d02_p01_play_not_set']
			);
		}
		if (!($check['d02_p01_pause'] > 0)) {
			// Δεν έχετε ορίσει κατάσταση παύσης στις βασικές παραμέτρους δραστηριοτήτων
			return array(
				'ok'	=> 0,
				'msg'	=> $_SESSION['peg_dic_crm002_d99104_initialize_d02_p01_pause_not_set']
			);
		}
		if (!($check['d02_p01_stop'] > 0)) {
			// Δεν έχετε ορίσει κατάσταση λήξης στις βασικές παραμέτρους δραστηριοτήτων
			return array(
				'ok'	=> 0,
				'msg'	=> $_SESSION['peg_dic_crm002_d99104_initialize_d02_p01_stop_not_set']
			);
		}
		$this->d02_p01_play = $check['d02_p01_play'];
		$this->d02_p02_play = $check['d02_p02_play'];
		$this->d02_p201_play = $check['d02_p201_play'];

		$this->d02_p01_pause = $check['d02_p01_pause'];
		$this->d02_p02_pause = $check['d02_p02_pause'];
		$this->d02_p201_pause = $check['d02_p201_pause'];

		$this->d02_p01_stop = $check['d02_p01_stop'];
		$this->d02_p02_stop = $check['d02_p02_stop'];
		$this->d02_p201_stop = $check['d02_p201_stop'];
		$this->d01_p03 = $check['d01_p03'];
		return array(
			'ok'	=> 1,
			'msg'	=> 'Success'
		);
	}
	/**
	 * Επιστρέφει τα στοιχεία της δραστηριότητας και το επωνυμία του συναλλασσόμενου της
	 * @return array
	 */
	public function get_d01_data()
	{
		$d01 = array();
		$sql = "	SELECT
							TRIM(d00.p19)		AS d00_p19,
							d01.*
						FROM d01
						LEFT JOIN d00 ON d00.nr01 = d01.p01
						LEFT JOIN d02 ON d02.p01 = d01.p06
						WHERE d01.nr01 = :nr01
			";
		pegasus_mysql_use($sql, $d01, array('nr01' => $this->d01_nr01));
		return $d01;
	}
}
