/*d01_p306_from_d99104_start*/
/*
	Υπολογισμός διάρκειας δραστηριότητας d01.p306 από το 
	σύνολο των εγγραφών της στον πινάκα τον χρόνων (d99104).
*/
SELECT
	SUM(
		IF(
			IFNULL(d99104.p01,'') <= '0100-01-01'
			OR IFNULL(d99104.p011,'') = ''
			OR IFNULL(d99104.p02,'') <= '0100-01-01'
			OR IFNULL(d99104.p021,'') = '',
			0,

			IF( 
				CONCAT(d99104.p01,' ',d99104.p011) > CONCAT(d99104.p02,' ',d99104.p021), 
				0,
				/* */
				CEIL(
					(
						datediff(d99104.p02, d99104.p01) * 86400
						+ time_to_sec(d99104.p021)
						- time_to_sec(d99104.p011)
					) * 100 / 3600
				) / 100
				/* */
			)
		)
	) AS d01_p306
FROM d99104
WHERE d99104.d01 = :d01
/*d01_p306_from_d99104_end*/

/*d99104_vp03_browse_jn_field_start*/
/* 
	Υπολογισμός διάρκειας (d99104.vp03) ανά γραμμή (εγγραφή) χρόνο δραστηριότητας 
*/
IF(
	IFNULL(d99104.p01,'') <= '0100-01-01'
	OR IFNULL(d99104.p011,'') = ''
	OR IFNULL(d99104.p02,'') <= '0100-01-01'
	OR IFNULL(d99104.p021,'') = '',
	0,
	IF( 
		CONCAT(d99104.p01,' ',d99104.p011) > CONCAT(d99104.p02,' ',d99104.p021), 
		0, 
		/* */
		CEIL(
			(
				datediff(d99104.p02, d99104.p01) * 86400
				+ time_to_sec(d99104.p021)
				- time_to_sec(d99104.p011)
			) * 100 / 3600
		) / 100
		/* */
	)
)
/*d99104_vp03_browse_jn_field_end*/