<?php

	/**
	 * Αυτή η συναρτηση μας βοηθάει να ελέγξουμε αν υπάρχει υπόλοιπο κάποιες ημέρες πρίν από σήμερα.
	 * Δηλάδη υπολογίζει όλες τις χρεώσεις μεχρι καποια ημερομήνία (την υμερομηνία την βρίσκει αφαιρόντάς το '$days' απο το σήμερα  ) - όλες τις πιστώσεις μέχρι σήμερα.
	 *
	 * @param unknown_type $days    = Ημερες πριν
	 * @param unknown_type $a01_p21 = Λογαριασμός
	 * @param unknown_type $p09_min = Από καταστημα
	 * @param unknown_type $p09_max = Μεχρι κατάστημα
	 *
	 * @return unknown , αν υπάρχει υπόλοιπο τότε το επιστρεφει αλλιώς επιστεφει 0.
	 *
	 */

	function customers_find_balance_age($days=0, $a01_p21=0, $p09_min=0, $p09_max=9999999999, $check_balance_limit=1){
	        
	    $limit = 0;
	    if($check_balance_limit==1){
	        $limit = $_SESSION['hera00_balanceagefromvalue'];
	    }

	    if(account_find_balance($a01_p21, $p09_min, $p09_max)<=$limit){
			return 0;
		}
		 
		// Hmerominia
		$date = peg_addDate(date('Y-m-d'), 'Y-m-d', ((-1)*$days), 0, 0);
		
		$values = array(); 
		$values['a01_p21'] = $a01_p21; 
		$pistwseis = pegasus_mysql_printfld('t01', 'sum(p04)', "p01=:a01_p21 and p09>=0 and p09<=999", $values);
		 
		 
		$values['date'] = $date;  
		$xrewseis  = pegasus_mysql_printfld('t01', 'sum(p03)', "p01=:a01_p21 and p09>=0 and p09<=999 and p02<=:date", $values);
		

		$qq = " select  ifnull(sum(t01_00.p03),0)  as sum_00 

					from (select * from t01 where t01.p03<0 and t01.p01=:a01_p21 and t01.p09>=0 and t01.p09<=999 and t01.p02>:date  ) as t01_00
					join a55 as a55_00 on t01_00.p302=a55_00.nr01 and t01_00.p303=2 and t01_00.p01=:a01_p21 
					left join a55 as a55_01 on a55_00.p601=a55_01.nr01 or a55_00.p414=a55_01.nr01  
					where  a55_01.p01<=:date or (a55_00.p601=0 and a55_00.p414=0)";

		pegasus_mysql_use($qq, $sum_00, $values);
		$xrewseis_arnitikes = $sum_00['sum_00'];
	 	 
		$ypoloipo = $xrewseis - $pistwseis + $xrewseis_arnitikes;		
		 
		if($ypoloipo>$limit){
			return $ypoloipo;
		}
		 
		return 0;	
	}
	
	/**
     * Εχει αντικατασταθει με την account_find_balance όπου χρησιμοποιείται
     * 
	 * Βρίσκει το υπόλοιπο του πελάτη
	 *
	 * $a01_p21 = O logariasmos toy ptlath.
	 * $p09_min  = Από κατάστημα.
	 * $p09_max  = Έως κατάστημα.
	 */
    function customers_find_balance($a01_p21=0, $p09_min=0, $p09_max=9999999999, $date='', $time=''){
    	
        if(peg_dateIsEmpty($date, 'Y-m-d') ){
            $date = date('Y-m-d');
        }
        if(empty($time)){
            $time = date("H:i");
        }

		$values = array();
		$values['a01_p21'] = $a01_p21;
		$values['p09_min'] = $p09_min;
		$values['p09_max'] = $p09_max;
		$values['p02_1'] = peg_dateToStr($date, 'Y-m-d');
		$values['p02_2'] = peg_dateToStr($date, 'Y-m-d');
		$values['p02t'] = $time;
        $values['p02t_1'] = $time;
        
		//αν δεν υπαρχει t01 μετα απο αυτη την ημ/νια τοτε t00tot αλλιως sum t01
        //Ελέγχω και την ισότητα καθώς αν ξανακαταχωρώ υπάρχον παραστατικό, δεν θέλω να πάρει από το t00tot
        pegasus_mysql_use("select count(*) as counter 
                            from t01 
                            where p01=:a01_p21 
                            and (p02>:p02_1 or (p02=:p02_2 and p02t>=:p02t)) " , $count, $values);
        

        if($count['counter']==0 || (peg_dateIsEmpty($date, 'Y-m-d') && empty($time))){
            pegasus_mysql_use("select   ifnull(sum(t00tot.p03),0) as balance 
                                        from t00tot 
                                        where p01= :a01_p21 
                                        and p09>=:p09_min 
                                        and p09<=:p09_max;" , $t00tot, $values);
        }else{
            pegasus_mysql_use("select t01_tmp.*,ifnull(p03-p04,0) as balance from (
                select 
                    t01.p01,
                    t01.p09,
                    if(sum(t01.p03-t01.p04)>0, sum(t01.p03-t01.p04), 0)  as p03, 
                    if(sum(t01.p04-t01.p03)>0, sum(t01.p04-t01.p03), 0)  as p04	
                from t01
                where p01=:a01_p21  and p09>=:p09_min and p09<=:p09_max and (p02<:p02_1 or (p02=:p02_2 and (p02t<:p02t or ''=:p02t_1) ))
                group by t01.p01) as t01_tmp" , $t00tot, $values);
        }
		
        return $t00tot['balance'];
    }
    
    /**
     * Βρίσκει το ατιμολόγιτο ποσο των παραγγελιών
     *
     *$a01_nr01  nr01 του πελάτη
     */
    function customers_find_orders_balance($a01_nr01=0){
    	
		$values =array($a01_nr01);
		
        pegasus_mysql_use("select sum(a57.p0109) as tot 
        					from a57 
        					join a33 on a57.p590=a33.p01 and a33.p03!=1 
        					where a57.p00<='01000101' 
        					and a57.p03=?;", $a57tot, $values);
        return $a57tot['tot'];
    }
    
        /**
     * Eλεγχεί ολους τους περιορισμούς του υπολοιπου για τον πελάτη της σύμβασης
     * $price = 0  
     * $a01_nr01 = Το nr01 της καρτέλας του πελατη
     * $enable_a01p27       = 1 by default , Αν είναι 1 κάνει έλεγχο του πιστωτικου ορίου του πελάτη   
     * $enable_balance_age  = 1 by default , Αν είναι 1 κάνει έλεγχο τις ημερες παλαιότιτα του υπολοιπου απο τον τρόπο είσπραξής   
     * $enable_order_balance =0 by default , Αν είναι 1 τότε προσθέτει και τις ατιμολόγιτες παραγγελίες στον έλεγχο του πιστωτικου ορίου του πελάτη 
     * @return (sting) Το error αν υπάρχει  
     */

    function customers_isvalidBalance($price=0, $a01_nr01, $enable_a01p27=1, $enable_balance_age=1, $enable_order_balance=0){


		$values = array($a01_nr01);
		
        if(!(pegasus_mysql_printfld('a01', 'count(*)', 'nr01=? and p0400!=1', $values)>0)){
            $msg = dic_customer_no_customer;
            if(!defined('dic_customer_no_customer')){
                $msg = $_SESSION['peg_dic_customers_no_customer'];   
            }
            return $msg;
        }       

        pegasus_mysql_use("select  
                                a01.nr01 as a01nr01, 
                                a01.p27 as maxpist, 
                                a01.p21 as logargiasmos, 
                                a14.p011 as balance_days 
                            from a01 
                            left join a14 on a01.p02 = a14.nr01 where a01.nr01=?;", $a01tmp, $values);
        
         
        // To απενεργοποιώ δεν έχει νόημά να μην ελέγχουμε το μηδενικό πιστωτικό όριο.
        // if($a01tmp['maxpist']==0){
            // return "";
        // }
        
        if($enable_a01p27==1){
            $ypoloipo = (float) round(account_find_balance($a01tmp['logargiasmos']), 2);
            if($enable_order_balance==1){
                $ypoloipo += round(customers_find_orders_balance($a01tmp['a01nr01']), 2) ;
            }
            
            $ypoloipo += $price;
            if($a01tmp['maxpist'] < $ypoloipo){
                //Το νέο υπόλοιπο σας (##newnp0109##) είναι μεγαλύτερο από το επιτρεπτό (##maxpist##)
                $tagsar = array("##newnp0109##", "##maxpist##" , '##deposit##');
                $datsar = array($ypoloipo, $a01tmp['maxpist'] , $ypoloipo-$a01tmp['maxpist'] );
                if($enable_order_balance==1){
                    $msg = dic_customer_maxpistwar_with_charge_and_with_order;
                    if(!defined('dic_customer_maxpistwar_with_charge_and_with_order')){
                        $msg = $_SESSION['peg_dic_customers_maxpistwar_with_charge_and_with_order'];   
                    }
                    $error .= str_replace($tagsar, $datsar, $msg);
                }elseif($price!=0){
                    $msg = dic_customer_maxpistwar_with_charge;
                    if(!defined('dic_customer_maxpistwar_with_charge')){
                        $msg = $_SESSION['peg_dic_customers_maxpistwar_with_charge'];   
                    }                    
                    $error .= str_replace($tagsar, $datsar, $msg);
                }else{
                    $msg = dic_customer_maxpistwar;
                    if(!defined('dic_customer_maxpistwar')){
                        $msg = $_SESSION['peg_dic_customers_maxpistwar'];   
                    } 
                    $error .= str_replace($tagsar, $datsar, $msg);
                }
            }
        }
        
        if($enable_balance_age){
            $ypoloipo = (float) round(customers_find_balance_age($a01tmp['balance_days'], $a01tmp['logargiasmos']), 2);
            if($ypoloipo>0){
                $tagsar = array("##ypoloipo##", "##balancedays##");
                $datsar = array($ypoloipo,  $a01tmp['balance_days'] );
                if(!empty($error)){
                    $error .= '<br><br>';
                }
                $msg = dic_customer_maxoldpistwar;
                if(!defined('dic_customer_maxoldpistwar')){
                    $msg = $_SESSION['peg_dic_customers_maxoldpistwar'];   
                }
                $error .= str_replace($tagsar, $datsar, $msg);
            }
        }
        
        if(!empty($error)){
            return $error;
        }
        
        return "";
    }

/** Συνάρτηση που επιστρέφει τα Στοιχεία που θα βρεί βάσει του ΑΦΜ
 * @param mixed $afm
 * @return associative
 */
function customers_search_vat_data($afm = '') {
    //
    if (!pegasus_module_exists('customers')) {
        die();
    }
    //
    $ret_data = array(
        'ok'    => 1,
        'msg'    => '',
        'data'    => ''
    );
    pegasus_mysql_use("SELECT * from cor000 where nr01=1;",$cor000);
    pegasus_mysql_use("SELECT * from customers_000 where nr01=1;",$customers_000);

    $code        = $cor000['app_code'];
    $sn          = pegasus_leading_zeros($cor000['sn'], 7);
    $username    = $customers_000['ckafmuser'];
    $password    = $customers_000['ckafmpass'];
    $ckafmafm    = $customers_000['ckafmafm'];
    $tesae_user  = $cor000['tesae_user'];
    $tesae_pass  = $cor000['tesae_pass'];
    $sid = "";
        
    try {
        $resp = pegasus_curl_request('https://services00.pegcloud.io/is_alive.php', false, array(), array(CURLOPT_TIMEOUT => 4));
    } catch (Exception $ex) {
        $resp = false;
    }

    if (!empty($resp) and  $resp == 'true') {
        $url = "https://services00.pegcloud.io/services01/execute.php";
    } else {
        $url = "https://services.tesae.gr/services01/execute.php";
    }
    
    $params = array(
        'action'    => 'login',
        'user'        => $tesae_user,
        'pass'        => $tesae_pass,
        'un'        => 1
    );
    $resp = pegasus_curl_request_post($url, $params);
    $xml = simplexml_load_string($resp);
    if ($xml->code == '100') {
        $sid  = $xml->sid;
        $params = array(
            'action'    => 'getAFM',
            'sid'        => $sid,
            'sn'        => $sn,
            'code'        => $code,
            'afm'        => $afm,
        );
        if (!empty($username) and !empty($password)) {
            $params['username'] = $username;
            $params['password'] = $password;
            $params['fromafm'] = $ckafmafm;
        }
        $resp = pegasus_curl_request_post($url, $params);
        $getAFM = simplexml_load_string($resp);
        if ($getAFM->code == 200) {
            $ret_data['msg'] = '';
            $ret_data['data'] = array();
            $ret_data['respCode'] = (int) $getAFM->code;
            $temp = (string) $getAFM->deactivation_flag;
            if (!empty($temp)) {
                $ret_data['data']['deactivationFlag'] = (int) $temp;
            }
            $temp = (string) $getAFM->name;
            if (!empty($temp)) {
                $ret_data['data']['onomasia'] = $temp;
            }
            $temp = (string) $getAFM->afm;
            if (!empty($temp)) {
                $ret_data['data']['afm'] = $temp;
            }
            $temp = (string) $getAFM->registDate;
            if (!empty($temp)) {
                $date = new DateTime($temp);
                $temp = $date->format('Y-m-d');
                $ret_data['data']['registDate'] = $temp;
            }
            unset($date);
            $temp = (string) $getAFM->stopDate;
            if (!empty($temp)) {
                $ret_data['data']['stopDate'] = $temp;
            }
            $temp = (string) $getAFM->doy;
            if (!empty($temp)) {
                $ret_data['data']['doy'] = $temp;
            }
            $temp = (string) $getAFM->doyDescr;
            if (!empty($temp)) {
                $ret_data['data']['doyDescr'] = $temp;
            }
            $temp = (string) $getAFM->commerTitle;
            if (!empty($temp)) {
                $ret_data['data']['commerTitle'] = $temp;
            }
            $temp = (string) $getAFM->parDescription;
            if (!empty($temp)) {
                $ret_data['data']['parDescription'] = $temp;
                $query_d22 = 'SELECT d22.p01, count(*) as cnt FROM d22 WHERE d22.p02 = :temp_1 OR d22.ep02 = :temp_2';
                pegasus_mysql_use($query_d22, $d22_result, array('temp_1'=>$temp, 'temp_2'=>$temp));
                if(!empty($d22_result['p01']) && $d22_result['cnt'] == 1) {
                    $ret_data['data']['city'] = $d22_result['p01'];
                }
            }
            $temp = (string) $getAFM->postalAddressNo;
            if (!empty($temp)) {
                $ret_data['data']['postalAddressNo'] = $temp;
            }
            $temp = (string) $getAFM->postalAddress;
            if (!empty($temp)) {
                $ret_data['data']['postalAddress'] = $temp . " " . $ret_data['data']['postalAddressNo'];
                $ret_data['data']['postalAddress'] = $ret_data['data']['postalAddress'];
            }
            $temp = (string) $getAFM->postalZipCode;
            if (!empty($temp)) {
                $ret_data['data']['postalZipCode'] = $temp;
            }
            $temp = (string) $getAFM->i_ni_flag_descr;
            if (!empty($temp)) {
                $ret_data['data']['i_ni_flag_descr'] = $temp;
            }
            $temp = (string) $getAFM->deactivation_flag_descr;
            if (!empty($temp)) {
                $ret_data['data']['deactivation_flag_descr'] = $temp;
            }
            $temp = (string) $getAFM->firm_flag_descr;
            if (!empty($temp)) {
                $ret_data['data']['firm_flag_descr'] = $temp;
            }
            $temp = (string) $getAFM->legal_status_descr;
            if (!empty($temp)) {
                $ret_data['data']['legal_status_descr'] = $temp;
            }
            $temp = (string) $getAFM->normal_vat_system_flag;
            if (!empty($temp)) {
                $ret_data['data']['normal_vat_system_flag'] = $temp;
            }
            $temp = (string) $getAFM->firmActCode;
            if (!empty($temp)) {
                $ret_data['data']['firmActCode'] = $temp;
            }
            $temp = (string) $getAFM->facActivity;
            if (!empty($temp)) {
                $ret_data['data']['facActivity'] = $temp;
            }
            $temp = (string) $getAFM->actLongDescr;
            if (!empty($temp)) {
                $ret_data['data']['actLongDescr'] = $temp;
            }

            if ($getAFM->firmsact->count() > 0) {
                $ret_data['data']['firmsacts'] = $getAFM->firmsact->children();
            }
            
        } else {
            $ret_data['ok'] = 0;
            $retcode = (int) $getAFM->code;
            $ret_data['respCode'] = $retcode;
            $ret_data['errDesc'] = (string) $getAFM->description;
        }
        //
        $params = array(
            'action'    => 'sessionDestroy',
            'sid'        => $sid
        );
        pegasus_curl_request_post($url, $params);
    }else if ($xml->code == '101') {
        $ret_data['ok'] = 0;
        $ret_data['respCode'] = '101';
        $ret_data['errDesc'] = (string) $xml->description;
    }
    return $ret_data;
}

/**
 * Return array keys and array of defulat values (from session)
 */
function peg_customers_a01_get_default_values(){
    //Map table's fields to default values
    $default_values_from_session=array(
        'p02'=>'customers_000_p01',
        'p48'=>'customers_000_p02',
        'p45'=>'customers_000_p03',
        'p05'=>'customers_000_p06',
        'p010'=>'customers_000_p05',
        'pl20'=>'customers_000_pl20',
        'p803c'=>'customers_000_p515',
        
        'p4_1'=>'customers_000_p07',
        'p4_2'=>'customers_000_p08',
        'p4_3'=>'customers_000_p09',
        
        'p51' => 'username'
    );
    if($_SESSION['customers_000_mngr']){
        $default_values_from_session['p51']  = '';
    }
    $default_values=array();
    // Get Session Value for each default table field
    foreach($default_values_from_session as $fieled_name=>$session_name)
        $default_values[$fieled_name]=$_SESSION[$session_name];
    return $default_values;
}

/**
 * Δημιουργεί πελάτη από συναλλασσόμενο. Ενημερώνει τη νέα εγγραφή πελάτη με τα default values των παραμέτρων και στη συνέχεια ενημερώνει τον πελάτη από τον συναλλασσόμενο.
 * @param integer $d00_nr01 - ΜΚ Συναλλασσομένου
 * @return integer $new_a01 - Αν δημιουργήθηκε πελάτης | -1 Αν υπάρχει ήδη | Τίποτα αν δεν έχει οριστεί $d00_nr01 ή δεν υπάρχει a01 table.
 */
function customers_create_a01_from_d00($d00_nr01) {

    $data = array();
	$new_a01 = "";

    if(!empty($d00_nr01) && pegasus_mysql_table_exists('a01')) {
        $a01 = pegasus_mysql_printfld('a01', 'nr01', 'pnr01 = :d00', array("d00" => $d00_nr01));

        //* Αν ο συναλλασσόμενος δεν έχει κανέναν πελάτη.
        if($a01 > 0) {
            return -1;
        }else{
            //* Ξεκινάω δημιουργία νέου πελάτη.
            $new_a01 = pegasus_mysql_newrec("a01");

            //* Set Default values Πελάτη από βασικές παραμέτρους πελατών
            $default_values = peg_customers_a01_get_default_values();
            foreach($default_values as $default_field => $default_value)
                $data[$default_field] = $default_value;
            $data['pikat'] = -1; 				// Κατάστημα Παραγγελίας Site -> -1 Προκαθορισμένο
            $data['piinv'] = -1;				// Αποθηκευτικός Χώρος Παραγγελίας Site -> -1 Προκαθορισμένο
            $data['nr01']  = $new_a01;          // ΜΚ New a01 record
            $data['pnr01'] = $d00_nr01;  		// ΜΚ Συναλλασσομένου
			//! Τα παρακάτω χτυπάνε στο update της peg_d00_to_a01_update procedure αν είναι null οπότε τα σετάρουμε εδώ με κενό
			//? Να το δούμε σε επόμενο χρόνο ίσως μπορεί να γίνει καλύτερα, μέσα από τα triggers/procedure δεν έπαιζε σωστά γι'αυτό το βάλαμε εδώ.
			$data['p30']   = '';                // Σημειώσεις Λογιστηρίου
			$data['p31']   = '';                // Σημειώσεις Τιμολογικής
			$data['p32']   = '';                // Σημειώσεις Ομαδοποίησης
			$data['p33']   = '';                // Σημειώσεις Λοιπών

            //* Κρατάω backup την τιμή του @pegasus_no_triggers
            pegasus_query("SET @pegasus_no_triggers_tmp_backup = @pegasus_no_triggers");
            //* Σετάρω το @pegasus_no_triggers = 1 πριν την insert
            pegasus_query("SET @pegasus_no_triggers = 1");
            //* Insert a01
            pegasus_mysql_insert('a01', array_keys($data), array_values($data));
            //* Επαναφέρω την προηγούμενη τιμή του @pegasus_no_triggers
            pegasus_query("SET @pegasus_no_triggers = @pegasus_no_triggers_tmp_backup");

            //* Ελέγχω αν δημιουργήθηκε ο πελάτης κανονικά και έχει ορισμένο τον συναλλασσόμενο αυτόν
            if(pegasus_mysql_printfld('a01', 'nr01', 'pnr01 = :d00', array("d00" => $d00_nr01)) > 0) {
                //* Ενημερώνω τα στοιχεία του πελάτη από τον συναλλασσόμενο >> Γίνεται με το SQL Procedure που χρησιμοποιείται στο trigger του d00
                $res = pegasus_query("CALL peg_d00_to_a01_update (:d00)", array("d00" => $d00_nr01));
            }
			return $new_a01;
        }
    }else{
		return;
	}
}

class CustomersA01T01PrintsData extends PrintsData {

    protected function setBodySql(){

        if(!empty($this->p85_arr['body_sql_code'])){
            $sql_code = eval($this->p85_arr['body_sql_code']);
        }

        $dias_main_nr01 = (is_array($this->p85_input["dias_main_nr01"])) ? $this->p85_input["dias_main_nr01"][0] : $this->p85_input["dias_main_nr01"];

        $query = customers_financials_form($dias_main_nr01, $this->p85_input['dt_to'], $this->p85_input['dt_from'], $this->p85_input['days'], $this->p85_input['t07_p01']);
        $this->body_sql = (is_array($sql_code)) ? $sql_code : array('sql'=>$query['sql'], 'sqlParams'=> $query['sqlParams']);
    }

    protected function getGlobalExpressions(){
        $global_exps = parent::getGlobalExpressions(); 
        

        //Table Expressions
        $table_exps = static::getTableExpressions($this->p85_arr['p50']);
        //Extra Table Expressions
        $p30_fn = 'getData';

        //Συνολικη Χρεωση
        $p00 = 'tot_p03';    $p01 = 'Συνολική Χρέωση';
        $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'N', 'p03'=>'5', 'p04'=>'2');

        //Συνολικη Πίστωση
        $p00 = 'tot_p04';    $p01 = 'Συνολική Πίστωση';
        $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'N', 'p03'=>'5', 'p04'=>'2');

        //Σύνολικό Υπόλοιπο
        $p00 = 'tot_remaining';    $p01 = 'Σύνολικό Υπόλοιπο';
        $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'N', 'p03'=>'5', 'p04'=>'2');

        $global_exps = array_merge($global_exps, $table_exps);
        
        return $global_exps;
    }

    protected function makeGlobalData(){

        $global_data = parent::makeGlobalData();

        $dias_main_nr01 = (is_array($this->p85_input["dias_main_nr01"])) ? $this->p85_input["dias_main_nr01"][0] : $this->p85_input["dias_main_nr01"];
        //Table Data
        $main_table_data = static::makeTableData($this->p85_arr['p50'], $dias_main_nr01);
        $counter = count($main_table_data);
        for ($j=0; $j<$counter; $j++) {  
               //Συνολική χρέωση
               $dias_main_nr01 = (is_array($this->p85_input["dias_main_nr01"])) ? $this->p85_input["dias_main_nr01"][0] : $this->p85_input["dias_main_nr01"];

                $query = customers_financials_form($dias_main_nr01,$this->p85_input['dt_to'], $this->p85_input['dt_from'], $this->p85_input['days'], $this->p85_input['t07_p01'], 1);

                pegasus_mysql_use($query['sql'], $total_charge, $query['sqlParams']);
                $main_table_data[$j]['tot_p03']       = $total_charge['tot_p03']; 
                $main_table_data[$j]['tot_p04']       = $total_charge['tot_p04'];
                $main_table_data[$j]['tot_remaining'] = $total_charge['tot_p03'] - $total_charge['tot_p04'];  
  
        }
        
        
        $global_data = array_merge($global_data, $main_table_data[0]);
        //echo "<pre>". print_r($global_data,1) . "</pre>"; 
        
        return  $global_data;

    }


    protected function getBodyExpressions(){

        $body_exps   = array();
        $p30_default = 'getBodyData';
       // $dias_main_nr01 = (is_array($this->p85_input["dias_main_nr01"])) ? $this->p85_input["dias_main_nr01"][0] : $this->p85_input["dias_main_nr01"];
        $body_fields = array(
        "p02"	 => "p02",
        "p03"	 => "p03",
        "p04"	 => "p04",
        "p05"	 => "p05",
        "p06"	 => "p06",
        "tmp_p01"=> "tmp_p01",
        "type"	 => "type"
        );
        $fields_query  = "select p50.p01 as p50_p01, p50.p03 as p50_p03, p51.* from p51 ";
        $fields_query .= "join p50 on p50.p02=p51.p02 ";
        $fields_query .= "where p50.p02 = 't01_d' ";
        $fields_query .= "order by p51.desc06, p51.nr01;";

        $result = pegasus_query($fields_query);
        while ($p51 = pegasus_fetch_assoc($result)) {

            if (in_array($p51['desc05'], array_keys($body_fields))) {
                $p00 = $body_fields[$p51['desc05']];
            } else {
                continue;
            }

            $p01 = $p51['p50_p03'] . ' -> ' . $p51['desc02'];
            $body_exps[] = array('p00' => $p00, 'p01' => $p01, 'p30' => $p30_default, 'p100' => 1, 'p02' => $p51['desc16'], 'p03' => $p51['desc17'], 'p04' => $p51['desc18']);
    }

		
		return $body_exps;
    }
}