
dashboard00_find_screen_ajax = '';
function dashboard00_open_dashboard_screen() {

	if (dashboard00_find_screen_ajax != '') {
		if (dashboard00_find_screen_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(dashboard00_find_screen_ajax);
		}
	}

	dashboard00_find_screen_ajax = pegAjaxDefer('/' + main_path + '/dashboard00_02/find_screen.php', {}, function (jsondata) {
		if (jsondata.ok === 1) {
			if (jsondata.screen) {
				peg002_addTab_d('', '', jsondata.screen, 'dashboard00', '');
			}
		}
		else {
			pegAlert(jsondata.msg);
		}
	});
}

dashboard00_find_config_screen_nr01 = '';
function dashboard00_open_config_dashboard_screen(container_id) {

	if (dashboard00_find_config_screen_nr01 != '') {
		if (dashboard00_find_config_screen_nr01.id > 0) {
			Ext.ux.AjaxDefer.abort(dashboard00_find_config_screen_nr01);
		}
	}

	dashboard00_find_config_screen_nr01 = pegAjaxDefer('/' + main_path + '/dashboard00_02/find_config_screen_nr01.php', {}, function (jsondata) {
		if (jsondata.ok === 1) {
			if (jsondata.nr01 > 0) {
				peg002_addTab_d('', 'dashboard00_10', 'dashboard00_10_d', 'dashboard00', '', jsondata.nr01);
			}
		}
		else {
			pegAlert(jsondata.msg);
		}
	});
}


function dashboard00_refresh_dashboard_screen(container_id) {
	var screen = pegGetCmp(container_id);

	/*screen = WebApp.view.Screen.peg_getMainScreen(screen);
	if(screen.isDestroying || screen.isDestroyed){
		pegAlert("DESTROYED WHILE HERE");
		return;
	}*/

	var pegasusPanels = screen.query("pegasusPanel, pegasusChartsPolar, pegasusChartsCartesian"); //xtype: pegasusPanel, pegasusChartsPolar, pegasusChartsCartesian
	var pegasusGrids = screen.query("webappGrid"); //xtype: pegasusPanel
	//Ext.data.StoreManager.items.filter(i => i._d == "dashboard00_140000000000002_d" ) δεν θα μ φερει τα grid π ειναι μεσα tab

	pegasusGrids.forEach(
		function (item) {
			//console.log(item);
			if (item.store) {
				item.store.load();
			}
		}
	);
	pegasusPanels.forEach(
		function (item) {
			if (item.tools.refresh && typeof (item.tools.refresh.callback) === "function") {
				item.tools.refresh.callback(item);
			}
		}
	);
}

/**
 * @param container_id: Είναι το container id της ενδιάμεσης οθόνης(dashboard00_13_d00) όπου δίνει το module και την περιγραφή του νέου dashboard
 * @param dashboard00_10_nr01: Η οθόνη διαμόρφωσης dashboard από όπου θα αντιγράψω τα tmp και θα τα βάλω στο dashboard00_13_nr01
 */
dashboard00_export_to_new_dashboard00_13_screen_ajax = '';
function dashboard00_dashboard00_13_d00_save_to_new_dashboard(container_id, dashboard00_10_nr01) {

	var dashboard00_10_id = pegGetContainer_id_d(container_id, 'dashboard00_10_d');

	var module = pegGetVal('module', container_id);
	var p00 = pegGetVal('p00', container_id);
	params = {};
	params.module = module;
	params.p00 = p00;
	params.dashboard00_10_nr01 = dashboard00_10_nr01;

	if (dashboard00_export_to_new_dashboard00_13_screen_ajax != '') {
		if (dashboard00_export_to_new_dashboard00_13_screen_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(dashboard00_export_to_new_dashboard00_13_screen_ajax);
		}
	}
	dashboard00_export_to_new_dashboard00_13_screen_ajax = pegAjaxDefer('/' + main_path + '/dashboard00_02/export_to_dashboard00_13.php', params, function (jsondata) {
		if (jsondata.ok) {
			if (jsondata.new_nr01 > 0) { //Το nr01 του καινούριου πρότυπου dashboard
				pegSetVal('dashboard00_13', dashboard00_10_id, jsondata.new_nr01);
			}
			pegWindowClose(container_id);
			pegAlert(jsondata.msg);
		}
		else {
			pegAlert(jsondata.msg);
		}
	});
}

/**
 * @param dashboard00_13_nr01: Είναι το παλιό template που θα ενημερώσω
 * @param dashboard00_10_nr01: Η οθόνη διαμόρφωσης dashboard από όπου θα αντιγράψω τα tmp και θα τα βάλω στο dashboard00_13_nr01
 */
dashboard00_export_to_old_dashboard00_13_screen_ajax = '';
function dashboard00_export_to_old_dashboard00_13(dashboard00_13_nr01, dashboard00_10_nr01) {

	params = {};
	params.dashboard00_13_nr01 = dashboard00_13_nr01;
	params.dashboard00_10_nr01 = dashboard00_10_nr01;

	if (dashboard00_export_to_old_dashboard00_13_screen_ajax != '') {
		if (dashboard00_export_to_old_dashboard00_13_screen_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(dashboard00_export_to_old_dashboard00_13_screen_ajax);
		}
	}
	dashboard00_export_to_old_dashboard00_13_screen_ajax = pegAjaxDefer('/' + main_path + '/dashboard00_02/export_to_dashboard00_13.php', params, function (jsondata) {
		if (jsondata.ok) {
			pegAlert(jsondata.msg);
		}
		else {
			pegAlert(jsondata.msg);
		}
	});
}

/**
 * @param dashboard00_13_nr01: Είναι το παλιό template από όπου θα κάνω import
 * @param dashboard00_10_nr01: Η οθόνη διαμόρφωσης dashboard την οποία θα ενημερώσω
 */
dashboard00_import_from_dashboard00_13_ajax = '';
function dashboard00_import_from_dashboard00_13(dashboard00_10_id, dashboard00_13_nr01, dashboard00_10_nr01) {

	params = {};
	params.dashboard00_13_nr01 = dashboard00_13_nr01;
	params.dashboard00_10_nr01 = dashboard00_10_nr01;

	if (dashboard00_import_from_dashboard00_13_ajax != '') {
		if (dashboard00_import_from_dashboard00_13_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(dashboard00_import_from_dashboard00_13_ajax);
		}
	}
	dashboard00_import_from_dashboard00_13_ajax = pegAjaxDefer('/' + main_path + '/dashboard00_02/import_from_dashboard00_13.php', params, function (jsondata) {
		if (jsondata.ok) {
			//pegAlert(jsondata.msg); Δεν θέλω να εμφανίσω μήνυμα γιατί μπορεί αυτή η συνάρτηση να τρέξει και από το refresh (εκτελείται και από την afterdraw)
			pegGridRefresh(dashboard00_10_id, 'dashboard00_11');
		}
		else {
			pegAlert(jsondata.msg);
		}
	});
}

function dashboard00_button_open_report(nr01) {

	let parent_container_id = pegGetContainer_id_d("_main_d", dashboard00_find_screen_name(), "", "_main_d");
	peg_query_window_execute(nr01, '', parent_container_id);
}

function dashboard00_dashboard00_10_refresh(container_id) {
	var dashboard00_13 = pegGetVal('dashboard00_13', container_id);
	var dashboard00_10 = pegGetVal('nr01', container_id);
	var auto_updated = pegGetVal('auto_updated', container_id);
	var grid = pegGetCmp(container_id, 'dashboard00_11');
	if (auto_updated) {
		grid.setDisabled(true);
		if (dashboard00_13 > 0) {
			dashboard00_import_from_dashboard00_13(container_id, dashboard00_13, dashboard00_10);
		}
	} else {
		grid.setDisabled(false);
	}
}


function dashboard00_dashboard00_10_d_afterDraw_listeners(container_id) {
	var grid = pegGetCmp(container_id, 'dashboard00_11');
	var button00 = pegGetCmp(container_id, 'button00');//Export to dashboard Template
	var button01 = pegGetCmp(container_id, 'button01');//Import from dashboard Template
	var dashboard00_13 = pegGetCmp(container_id, 'dashboard00_13');//Dashboard Template
	var auto_updated = pegGetCmp(container_id, 'auto_updated');//AutoUpdated

	grid.on('edit', function (editor, context) {
		var values = {};
		values = context.record.data;
		pegSave_grid_row(
			grid.peg_view__d,
			grid.peg_view_table,
			grid.peg_view_module,
			grid.getMnr01(),
			grid.getMmnr01(),
			values,
			function (jsonData) {
				if (!jsonData.ok) {
					context.record.reject();
					pegAlert(jsonData.message);
				} else {
					context.record.commit();
				}
			}
		);

	});

	grid.on('canceledit', function (editor, context) {
		context.record.reject();
	});

	button00.setPeg_handler(function (me) { //Export to dashboard Template

		var dashboard00_13_nr01 = pegGetVal('dashboard00_13', container_id);

		if (dashboard00_13_nr01 > 0) { //If template dashboard selected, Check if export to new or to old template
			pegWindowShow_d(
				'',
				'dashboard00_13_d01',
				'dashboard00', '',
				'',
				'',
				container_id,
				'',
				'',
				'',
				{},
				true
			);
		}
		else {//Export to new template
			pegWindowShow_d(
				'',
				'dashboard00_13_d00',
				'dashboard00', '',
				'',
				'',
				container_id,
				'',
				'',
				'',
				{},
				true
			);
		}
	});

	button01.setPeg_handler(function (me) { //Export to dashboard Template

		var dashboard00_13_nr01 = pegGetVal('dashboard00_13', container_id);
		var dashboard00_10_nr01 = pegGetVal('nr01', container_id);
		if (dashboard00_13_nr01 > 0) {
			dashboard00_import_from_dashboard00_13(container_id, dashboard00_13_nr01, dashboard00_10_nr01);
		}
		else {
			pegGetDic('peg_dic_dashboard00_empty_dashboard00_13', function (desc) { pegAlert(desc); });
		}
	});

	dashboard00_13.on('blur', function (me) {
		if ((me.peg_onBlurValueHasChanged())) {
			me.value_old = me.getValue();
			dashboard00_dashboard00_10_refresh(container_id);
		}
	});

	auto_updated.on('change', function (me, newValue, oldValue, eOpts) {
		if (newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue))) {
			return;
		}
		dashboard00_dashboard00_10_refresh(container_id);
	});
}
/*
	var dashboard00_13_val = pegGetVal('dashboard00_13', container_id);
	var auto_updated_val = pegGetVal('auto_updated', container_id);
	var grid = pegGetCmp(container_id, 'dashboard00_11');
	if(auto_updated_val && dashboard00_13_val>0){
		pegAlert("222");
		grid.setReadOnly(true);
	}
*/
/**
 * dashboard00_13_d01: Είναι η οθόνη που σε ρωτάει να επιλέξεις αν θες να κάνεις το export σε υπάρχον ή νέο template
 */
function dashboard00_dashboard00_13_d01_afterDraw_listeners(container_id) {
	var old_button = pegGetCmp(container_id, 'old');
	var new_button = pegGetCmp(container_id, 'new');
	var dashboard00_10_id = pegGetContainer_id_d(container_id, 'dashboard00_10_d');

	old_button.setPeg_handler(function (me) { //Save to existent
		var dashboard00_13_nr01 = pegGetVal('dashboard00_13', dashboard00_10_id);
		var dashboard00_10_nr01 = pegGetVal('nr01', dashboard00_10_id);
		if (dashboard00_13_nr01 > 0) {
			pegWindowClose(container_id);
			dashboard00_export_to_old_dashboard00_13(dashboard00_13_nr01, dashboard00_10_nr01)
		}
		else {
			pegWindowClose(container_id);
			pegAlert('Choose DashBoard Template first');
		}


	});
	new_button.setPeg_handler(function (me) {//Export to new template
		pegWindowClose(container_id);
		pegWindowShow_d(
			'',
			'dashboard00_13_d00',
			'dashboard00', '',
			'',
			'',
			dashboard00_10_id,
			'',
			'',
			'',
			{},
			true
		);
	});

}

/*Είναι η afterdraw που καλείται για όλα τα dashboards σε ολα τα profile */
function dashboard00_dashboard_screen_afterdraw_listeners(container_id) {

	if (typeof notif_check_notifications_from_dashboard00 == "function") {
		notif_check_notifications_from_dashboard00(container_id);
	}
	dashboard00_get_app_info(container_id)
	dashboard00_get_app_updates(container_id,0)
}
var dashboard00_get_app_updates_ajax = ''
function dashboard00_get_app_updates(container_id,page) {
	const appUpdatesPanel = pegGetCmp(container_id, 'app_updates_panel');
	if (appUpdatesPanel) {
		if(!page) {
			page = 0;
		}
		const url = '/' + main_path + '/dashboard00_01/dashboard00_get_app_updates.php'
		const params = {
			page : page,
			container_id: container_id
		}
		if (dashboard00_get_app_updates_ajax != '') {
			if (dashboard00_get_app_updates_ajax.id > 0) {
				Ext.ux.AjaxDefer.abort(dashboard00_get_app_updates_ajax)
			}
		}
		//appUpdatesPanel.mask()
		dashboard00_get_app_updates_ajax = pegAjaxDefer(url, params, function (jsonData) {
			if (!jsonData) {
				return pegAlert('pegAjaxDefer response error')
			}
				let html = ''
				ol = appUpdatesPanel.html
				ne =  jsonData.data.html
				if(page != 0) {
					let keepHtml = ol.slice(0,ol.indexOf('<!--add-next-page-part-1-->'))
					let newHtml= ne.slice(ne.indexOf('<!--add-next-page-part-2-->')+'<!--add-next-page-part-2-->'.length)
					html = keepHtml + newHtml
				} else {
					html = ne
				}
				
				appUpdatesPanel.setData(html)
				//appUpdatesPanel.unmask()
		}, 'json', 0, true)
	}
	return true
}

dashboard00_get_app_info_ajax = ''
function dashboard00_get_app_info(container_id) {
	if (dashboard00_get_app_info_ajax != '') {
		if (dashboard00_get_app_info_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(dashboard00_get_app_info_ajax)
		}
	}
	const url = '/' + main_path + '/dashboard00_01/dashboard00_get_app_info.php'
	dashboard00_get_app_info_ajax = pegAjaxDefer(url, {}, function (jsonData) {
		if (!jsonData) {
			return pegAlert('pegAjaxDefer response error')
		}
		const appInfoPanel = pegGetCmp(container_id, 'app_info_panel');
		if (appInfoPanel) {
			appInfoPanel.setData(jsonData.data.html)
		}
	}, 'json', 0, true)
}


function dashboard00_find_screen_name() {
	const profile = PEGASUS.USER.get("profile");
	return `dashboard00_screen_${profile}_d`;
}
function dashboard00_dashboard00_11_d_afterDraw_listeners(container_id) {
	const dashboard00_12 = pegGetCmp(container_id,'dashboard00_12');
	dashboard00_12.on('change', function(me, newValue, oldValue, eOpts ){
		if(newValue == oldValue) {
			return;
		}
		pegSetFieldHidden('fieldset_140000108000000', container_id, true);
		pegSetFieldHidden('fieldset_140000003000000', container_id, true);
		pegSetFieldHidden('fieldset_140000003000001', container_id, true);
		pegSetFieldHidden('fieldset_140000003000002', container_id, true);	
		pegSetFieldHidden('fieldset_140000003000003', container_id, true);
		switch(newValue) {
			case 140000108000000 :
				pegSetFieldHidden('fieldset_140000108000000', container_id, false);	
			break;
			case 140000003000000 :
				pegSetFieldHidden('fieldset_140000003000000', container_id, false);
			break;
			case 140000003000001 :
				pegSetFieldHidden('fieldset_140000003000001', container_id, false);
			break;
			case 140000003000002 : 
				pegSetFieldHidden('fieldset_140000003000002', container_id, false);
			break;
			case 140000003000003 : 
				pegSetFieldHidden('fieldset_140000003000003', container_id, false);
			break;
		}
	});
}