<?php

class Dashboard
{
    private $profile;
    private $_d; //'dashboard00_' . $this->profile . '_d'
    private $dashboard00_10; // Έχει το nr01 του dashboard00_10
    private  $screenIndexCounter; //It holds the screen inddex for the next element

    private $dashboard00_10_mmnr01; // Αν αυτό το πεδίο δεν είναι empty είμαι στο save της οθόνης

    public function __construct($params_array)
    {
        $this->profile = $params_array['profile'];
        $this->dashboard00_10_mmnr01 = isset($params_array['dashboard00_10_mmnr01']) ? $params_array['dashboard00_10_mmnr01'] : '';
        $this->dashboard00_10 = pegasus_mysql_printfld('dashboard00_10', 'nr01', 'p95=?', array($this->profile));
        $this->_d = dashboard00_find_screen_name($this->profile);
        $this->screenIndexCounter = 1;
    }

    /**
     * This function will delete from db the old records of p50, p51.. and will create the new DB records, for the new screen
     */
    public function create()
    {

        $this->deleteOldScreen(); //Delete old records from db

        $screen = new DashboardScreen(
            array(
                'profile' => $this->profile,
                'screenIndex' =>  $this->screenIndexCounter,
                '_d' => $this->_d
            )
        );
        $this->screenIndexCounter += 10;
        $screen->create(); //Create db records for screen element

        $this->createContainers(); //Create db records for all containers

        $this->createElements(); //Create db records for all elements

        $this->resizeAndClearElements();

        pegasus_delete_directory('../../tmp/dashboard00/' . $this->_d . '/');
        peg002_clean_dCache($this->_d);
        peg002_clean_dCache('_main_d');
    }

    /**
     * This function will create all p51 for all containers
     */
    private function createContainers()
    {
        $ret = $this->getContainersQuery(); //Βρισκει το query στον dashboard00_11 ή στον peg_tmp_dashboard00_11
        $result = pegasus_query($ret['sql'], $ret['sqlParams']);
        while ($row = pegasus_fetch($result, PEG_FETCH_ASSOC)) {
            $container  = new DashboardFieldcontainer(
                array(
                    '_d' => $this->_d,
                    'line' => $row['p02'],
                    'screenIndex' =>  $this->screenIndexCounter
                )
            );
            $container->create();
            $this->screenIndexCounter += 10;
        }
    }

    /**
     * This function will create all p51 for all elements
     */
    private function createElements()
    {
        $ret = $this->getElementsQuery(); //Βρισκει το query στον dashboard00_11 ή στον peg_tmp_dashboard00_11
        $result = pegasus_query($ret['sql'], $ret['sqlParams']);
        $i = 0;
        while ($row = pegasus_fetch($result, PEG_FETCH_ASSOC)) {

            $params = array(
                '_d' => $this->_d,
                'container' => "fieldcontainer_" . $row['p02'],
                'name' => 'p' . pegasus_leading_zeros($i, 3),
                'screenIndex' =>  $this->screenIndexCounter,
                'profile' => $this->profile,
                'dashboard00_11_row' => $row // //Περνάω ολόκληρη την εγγραφή του dashboard00_11
            );
            $element = null;
            pegasus_mysql_use("select * from dashboard00_12 where nr01 =?", $dashboard00_12, array($row['dashboard00_12']));
            
            if (pegasus_profile_check_module_permission($dashboard00_12['module'], $this->profile) && file_exists($dashboard00_12['p01'])) {
                //Το if file_exists για να μην χτυπήσει στα updates
                require_once($dashboard00_12['p01']);
                $class = $dashboard00_12['p02'];
                try {
                    $element = new $class($params);
                } catch (Exception $ex) {
                    //Θα γίνει throw αν δεν μπόρεσε να κάνει initialize γιατί π.χ. το menu item δεν υπάρχει 
                    //για τη συγκεκριμένη εφαρμογή ή η αναφορά δεν υπάρχει κοκ.
                    $element = null;
                }
            }

            if ($element !== null && $element->CheckPermission() ) {
                $element->create();
            }

            $i++;
            $this->screenIndexCounter += 10;
            unset($element);
        }
    }

    private function resizeAndClearElements()
    {
        $containersInDB_MaxHeight =
            "select 
            p51.nr01 as p51_nr01,
            p51.desc05 as p51_desc05, /*Όνομα πεδίου fieldcontainer*/
            ifnull(p52.nr01, 0) as p52_nr01, /*Αν είναι null, δεν έχει μπει κανένα element στο container*/
            ifnull(max(p52_00.par_val), 0) as height /*Αν είναι null, ή δεν έχει μπει κανένα element στο container ή δεν υπάρχει ορισμένο height σε κανένα element*/
            from p51 
            left join p52 on p51.desc05 = p52.par_val and p52.module = 'dashboard00' and p52.p02 = :_d and p52.par_nm = 'fieldset' 
            left join p52 as p52_00 on p52_00.p02 = :_d and p52_00.par_nm = 'height'  and p52_00.desc05 = p52.desc05 and p52_00.module = 'dashboard00'
            where p51.module = 'dashboard00' and p51.p02 = :_d and p51.desc07= 'fieldcontainer'
            group by p51.desc05";
        $result = pegasus_query($containersInDB_MaxHeight, array('_d' => $this->_d));
        while ($row = pegasus_fetch($result, PEG_FETCH_ASSOC)) {

            if ($row['p52_nr01'] == 0) {
                pegasus_mysql_delete(
                    'p51',
                    "p51.module = 'dashboard00' and p51.p02 = :_d and p51.nr01=:p51_nr01",
                    0,
                    array('_d' => $this->_d, 'p51_nr01' => $row['p51_nr01'])
                );
            } else {

                $heightParam = '';
                if($row['height'] > 0){
                    $heightParam = ', "height": '.$row['height'];
                }
                $tt= "SELECT 
                p51_00.nr01, count(p51_00.nr01) as cnt_ele
                from p52 
                left join p51 as p51_00 on p51_00.desc05 = p52.desc05 and p51_00.module = 'dashboard00' and p51_00.p02 = :_d
                where p52.module = 'dashboard00' and p52.p02 = :_d and p52.par_nm = 'fieldset' and p52.par_val=:container
                      and ( p51_00.desc07 ='grid' OR p51_00.desc07 ='polarchart') ";
                pegasus_mysql_use($tt, $is_grid_chart,array('_d' => $this->_d, 'container' => $row['p51_desc05']));

                $heightParam_mobile = '';
                if($is_grid_chart['nr01']>0){
                    $total_height = 500 * $is_grid_chart['cnt_ele'];
                    $heightParam_mobile = ', "height": '.$total_height;
                }
                $p52 = array();
                $p52['p02'] = $this->_d; //_d
                $p52['desc05'] = $row['p51_desc05']; //Όνομα πεδίου
                $p52['desc07'] = 'fieldcontainer'; //Τύπος πεδίου
                $p52['module'] = 'dashboard00';
                $p52['nr01'] =  pegasus_mysql_newrec('p52');
                $p52['par_nm'] = 'responsiveConfig';
                $p52['par_val'] = 
                '{
                    "width<1024" : {
                        "layout" :{
                        "type" : "box",
                        "vertical": true
                        }
                        '.$heightParam_mobile.'
                    },
                    "width>=1024" : { 
                        "layout" :{
                        "type" : "box",
                        "vertical": false
                        }   
                        '.$heightParam.'
                    }
                }';
                pegasus_mysql_insert('p52', array_keys($p52), array_values($p52));

                if($row['height'] > 0){
                    $this->resizeContainerFields($row['p51_desc05'], $row['height']);
                }
            }
        }
    }

    private function resizeContainerFields($container, $height){

        $fieldsOfContainerQuery =
        "select 
        p51_00.*
        from p52 
        left join p51 as p51_00 on p51_00.desc05 = p52.desc05 and p51_00.module = 'dashboard00' and p51_00.p02 = :_d
        where p52.module = 'dashboard00' and p52.p02 = :_d and p52.par_nm = 'fieldset' and p52.par_val=:container ";
        $resultOfContainerQuery = pegasus_query($fieldsOfContainerQuery, array('_d' => $this->_d, 'container' => $container));

        $p52 = array();
        $p52['p02'] = $this->_d; //_d
        $p52['module'] = 'dashboard00';
        $p52['par_nm'] = 'height';
        $p52['par_val'] = $height;

        while ($row = pegasus_fetch($resultOfContainerQuery, PEG_FETCH_ASSOC)) {
            $p52['nr01'] =  pegasus_mysql_newrec('p52');
            $p52['desc07'] = $row['desc07']; //Τύπος πεδίου
            $p52['desc05'] = $row['desc05']; //Όνομα πεδίου
            pegasus_mysql_insert('p52', array_keys($p52), array_values($p52), 1);
        }

    }

    private function deleteOldScreen()
    {
        pegasus_mysql_delete('p52', 'p02=? and module=?', 0, array($this->_d, 'dashboard00'));
        pegasus_mysql_delete('p51', 'p02=? and module=?', 0, array($this->_d, 'dashboard00'));
        pegasus_mysql_delete('p50', 'p02=? and module=?', 0, array($this->_d, 'dashboard00'));
    }

    private function getContainersQuery()
    {
        if ($this->dashboard00_10_mmnr01 == '') {
            return array(
                'sql' =>  ' select p02
                            from dashboard00_11 
                            where dashboard00_11.dashboard00_10=:var_dashboard00_10
                            group by p02 order by p02',
                'sqlParams' => array(
                    'var_dashboard00_10' => $this->dashboard00_10
                )
            );
        } else {
            return array(
                'sql' =>  ' select p02
                            from peg_tmp_dashboard00_11 
                            where peg_flag!=9 
                            and peg_tmp_dashboard00_11.dashboard00_10=:var_dashboard00_10
                            and peg_tmp_dashboard00_11.peg_sess_id=:var_sess_id
                            and peg_tmp_dashboard00_11.peg_mmnr01=:var_mmnr01
                            and peg_tmp_dashboard00_11.peg_mnr01=:var_mnr01 
                            group by p02 order by p02',
                'sqlParams' => array(
                    'var_dashboard00_10' => $this->dashboard00_10,
                    'var_sess_id' => session_id(),
                    'var_mmnr01' => $this->dashboard00_10_mmnr01,
                    'var_mnr01' => $this->dashboard00_10
                )
            );
        }
    }
    private function getElementsQuery()
    {
        if ($this->dashboard00_10_mmnr01 == '') {
            return array(
                'sql' =>  ' select * from dashboard00_11 
                            where dashboard00_11.dashboard00_10=:var_dashboard00_10 
                            order by p02, p01',
                'sqlParams' => array(
                    'var_dashboard00_10' => $this->dashboard00_10
                )
            );
        } else {
            return array(
                'sql' =>  ' select * from peg_tmp_dashboard00_11 
                            where peg_flag!=9 
                            and peg_tmp_dashboard00_11.dashboard00_10=:var_dashboard00_10
                            and peg_tmp_dashboard00_11.peg_sess_id=:var_sess_id
                            and peg_tmp_dashboard00_11.peg_mmnr01=:var_mmnr01
                            and peg_tmp_dashboard00_11.peg_mnr01=:var_mnr01 
                            order by p02, p01',
                'sqlParams' => array(
                    'var_dashboard00_10' => $this->dashboard00_10,
                    'var_sess_id' => session_id(),
                    'var_mmnr01' => $this->dashboard00_10_mmnr01,
                    'var_mnr01' => $this->dashboard00_10
                )
            );
        }
    }
}
