<?php

class DashboardShowPanel extends DashboardElement
{
    public function __construct($params_array)
    {
        parent::__construct($params_array); //Θα σετάρει το p52[fieldset] 
        $this->view_type = 'panel';

        $this->InitializeFromType();

        $this->p52['frame'] = array('par_val' => "true", 'code' => 0);
        $this->p52['bodyPadding'] = array('par_val' => "5px", 'code' => 0);
        if(empty($this->p52['preventHeader'])) {
            $this->p52['preventHeader'] = array('par_val' => "false", 'code' => 0);
        }

        $this->p52['title'] = array('par_val' => $this->title, 'code' => 0);
        $this->p52['eTitle'] = array('par_val' => $this->eTitle, 'code' => 0);
        //Αν ο τίτλος είναι κενός, θα πάρω το όνομα από το όνομα της επιλογής
        if (empty($this->title)) {
            $this->title = pegasus_mysql_printfld("dashboard00_12", "p00", "nr01=?", array($this->dashboard00_11_row['dashboard00_12']));
        }
        if (empty($this->eTitle)) {
            $this->eTitle = pegasus_mysql_printfld("dashboard00_12", "ep00", "nr01=?", array($this->dashboard00_11_row['dashboard00_12']));
        }
    }


    protected function InitializeFromType()
    {
        //Για κάθε panel πρέπει να σετάρουμε: 
        //1. $textPHP : Θα πρέπει να κάνει return το strval του αριθμού
        //2. $ajax_request_path : Είναι το path του ajax που κάνει το refresh του panel
        //3. $ajax_response_field_name : Είναι το όνομα του πεδίου στο json που γυρνάει το ajax
        //4. $header_link: Είναι το link που θα ανοίγει το συγκεκριμένο panel από το header
    }

    /**
     * 
     * Η συνάρτηση αυτή φτιάχνει την js για το refresh του handler ενός panel
     * Εκτελείται ένα ajax request το οποίο δεν παίρνει καμία παράμετρο. 
     * Το ajax επιστρέφει μία απάντηση σε μορφή json. 
     * Στο json υπάρχει και η τιμή (με όνομα $ajax_response_field_name) η οποία θα γίνει set στα data του panel
     * 
     * @param $ajax_request_path The path of the ajax to execute p.e. '/hot000_01/day_meal_counts.php' 
     * @param $ajax_response_field_name The name of the field in the json response of the given ajax
     */
    protected function refresh_ajax_setData_to_field($ajax_request_path, $ajax_response_field_name,$ajax_request_payload = array())
    {

        $dashboard_field_name = $this->name; //Το όνομα του πεδίου στην οθόνη του dashboard
        $payload = empty($ajax_request_payload) ? '{}' : json_encode($ajax_request_payload);
        return
            'var fld = pegGetCmp(this.container_id, \'' . $dashboard_field_name . '\'); ' . "\n" .
            'if( fld ) { fld.setData(""); } ' . "\n" .
            'pegAjax(\'/\' + main_path + \'' . $ajax_request_path . '\', '.$payload.', function (jsondata) {' . "\n" .
            '   if(fld){' . "\n" .
            '       var text =jsondata.' . $ajax_response_field_name . '.toString();' . "\n" .
            '       fld.setData(text);' . "\n" .
            '   }' . "\n" .
            '});' . "\n" ;
    }
}
