<?php
function einv_after_update()
{
	if (file_exists('../../pegasus_cloud_app/einv_app_health/einv_app_health_haseinv.php')) {
		unlink('../../pegasus_cloud_app/einv_app_health/einv_app_health_haseinv.php');
	}

	//Το module ήταν Τιμολογηση με Ηλεκτρονικη Pegasus, τώρα έγινε γενική τιμολόγηση και όλοι οι πίνακες έχουν type.
	pegasus_mysql_update("einv01", array("type"), array("einv"), "type = ''"); //Στοιχεία σύνδεσης
	pegasus_mysql_update("einv02", array("type"), array("einv"), "type = ''"); //Ρυθμίσεις παραστατικό πελάτη
	pegasus_mysql_update("einv03", array("type"), array("einv"), "type = ''"); //Ρυθμίσεις παραστατικό προμηθευτή
	pegasus_mysql_update("einv04", array("type"), array("einv"), "type = ''"); //Ρυθμίσεις αποδείξεις
	pegasus_mysql_update("einv05", array("type"), array("einv"), "type = ''"); //Ρυθμίσεις μεταφορική

	//	Check by Version
	pegasus_mysql_use('select rel, ver from p55 where p00="einv"', $version);
	if ($version['ver'] == 1 && $version['rel'] <= 140) {
		if(file_exists('../../pegasus_cloud_app/einv01/einv_if_einv20_editable.php')) {
			unlink('../../pegasus_cloud_app/einv01/einv_if_einv20_editable.php');
		}
	}
	if ($version['ver'] == 1 && $version['rel'] <= 163) {
		if(file_exists('../../pegasus_cloud_app/einv01/einv_a55_from_myd10.php')) {
			unlink('../../pegasus_cloud_app/einv01/einv_a55_from_myd10.php');
		}
		if(file_exists('../../pegasus_cloud_app/einv01/einv_a55_from_myd10_check_if_a55_exists.php')) {
			unlink('../../pegasus_cloud_app/einv01/einv_a55_from_myd10_check_if_a55_exists.php');
		}
		if(file_exists('../../pegasus_cloud_app/einv01/einv_t01_from_myd13.php')) {
			unlink('../../pegasus_cloud_app/einv01/einv_t01_from_myd13.php');
		}
	}
}
function einv_einv01_d_initialize($data, $mmnr01, $mnr01, $_d, $container_id){

	$peg_is_newrec = 0;
	if (empty($data['nr01'])) {
		$peg_is_newrec = 1;
	}

	if($peg_is_newrec){
		$data['type'] = 'einv';
	}

	$einv_fields = ['p00', 'p01', 'p11','btn00'];
	$einv02_fields = ['einv02_p00', 'einv02_p01'];
	
	if($data['type'] == 'einv'){
		foreach ($einv02_fields as $fld) {
			$data[$fld . "_hidden"] = 1;
		}
	}
	elseif($data['type'] == 'einv01'){
		foreach ($einv_fields as $fld) {
			$data[$fld . "_hidden"] = 1;
		}
		foreach ($einv02_fields as $fld) {
			$data[$fld . "_hidden"] = 1;
		}
	}
	elseif ($data['type'] == 'einv02') {
		foreach ($einv_fields as $fld) {
			$data[$fld . "_hidden"] = 1;
		}
	}

	return $data;
}
function einv_einv51_d_initialize($data, $mmnr01, $mnr01, $_d, $container_id){
	$data['readonly'] = 1;
	return $data;
}
function einv_einv00_d_afterSave() {
	pegasusWriteSession('einv00');
	pegasusReadSession('einv00');
}
function einv_env00_find_data($mydt10_nr01 = 0) {
	$einv00 = array(
		'p01'	=> $_SESSION['einv00_p01'] ?? 0,
		'p02'	=> $_SESSION['einv00_p02'] ?? 0,
	);
	if($einv00['p01'] != 1 && $einv00['p02'] != 2) {
		return array(
			'ok'	=> 1,
			'data'	=> $einv00
		);
	}
	$mydt10 = array();
	pegasus_mysql_use("SELECT tbl, tbl_nr01 FROM mydt10 WHERE nr01 = :nr01",$mydt10,array('nr01' => $mydt10_nr01));
	if($mydt10['tbl'] == 'a60' || $mydt10['tbl'] == 'tran09') {
		$einv00['p01'] = 0;
		$einv00['p02'] = 0;
		return array(
			'ok'	=> 1,
			'data'	=> $einv00
		);
	}
	$sql = '';
	$rs = array();
	switch($mydt10['tbl']) {
		case 'a55' : 
			$sql = "	SELECT
							a01_00.p01		AS email,
							d00_00.p0118	AS lang
						FROM a55 AS a55_00
						LEFT JOIN a01		AS a01_00	ON a01_00.nr01 = a55_00.p03
						LEFT JOIN d00		AS d00_00	ON d00_00.nr01 = a01_00.pnr01
						WHERE 1 = 1
						AND a55_00.nr01 = :nr01

			";
			break;
		case 'a56' :
			$sql = "	SELECT
							a00_00.p01		AS email,
							d00_00.p0118	AS lang
						FROM a56 AS a56_00
						LEFT JOIN a00		AS a00_00	ON a00_00.nr01 = a56_00.p03
						LEFT JOIN d00		AS d00_00	ON d00_00.nr01 = a00_00.pnr01
						WHERE 1 = 1
						AND a56_00.nr01 = :nr01

			";
			break; 
		case 't08':
			$sql = "	SELECT
							IFNULL(
								a00_00.p01,
								a01_00.p01
							)				AS email,
							IFNULL(
								d00_00.p0118,
								d00_01.p0118
							)				AS lang
						FROM t08 			AS t08_00						
						LEFT JOIN a00		AS a00_00	ON a00_00.p21 = t08_00.p03
						LEFT JOIN a01		AS a01_00	ON a01_00.p21 = t08_00.p03
						LEFT JOIN d00		AS d00_00	ON d00_00.nr01 = a00_00.pnr01
						LEFT JOIN d00		AS d00_01	ON d00_01.nr01 = a01_00.pnr01
						WHERE 1 = 1
						AND t08_00.nr01 = :nr01
			";
			break;
		case 'tran01':
			$sql = "	SELECT
							a01_00.p01		AS email,
							d00_00.p0118	AS lang
						FROM tran01 AS tran01_00
						LEFT JOIN a01		AS a01_00	ON a01_00.nr01 = tran01_00.p61
						LEFT JOIN d00		AS d00_00	ON d00_00.nr01 = a01_00.pnr01
						WHERE 1 = 1
						AND tran01_00.nr01 = :nr01
			";
			break;
		default :
			return array(
				'ok'	=> 0,
				'msg'	=> "einv_env00_find_data: Unknown table ".$mydt10['tbl']
			);
	}
	pegasus_mysql_use($sql,$rs,array('nr01' => $mydt10['tbl_nr01']));
	if($einv00['p01'] == 1) {
		if(!empty($rs['email'])) {
			$einv00['p010'] = $rs['email'];
		} else {
			$einv00['p01'] = 0;
		}
	}
	if($einv00['p02'] == 2) {
		$einv00['p02'] = 1;	// EN
		if(strtolower($rs['lang']) != 'en') {
			$einv00['p02'] = 0;	// EL
		}
	}
	return array(
		'ok'	=> 1,
		'data'	=> $einv00
	);
}
//TODO Έχω κάνει 4 διαφορετικά functions για πιο γρήγορα. Πιθανώς μπορούμε να κάνουμε ένα refactor να παίζει με 1 function παραμετροποιήσιμο.
function einv_einv02_d_change($data, $permDeny, $mmnr01, $checkOnlyPerm)
{

	// Ελέγχω αν υπάρχει υπερκάλυψη συνδιασμών σε [Κατάστημα - Σειρά - Τύπο Παραστατικού]
	$a18_p01 = array();
	$a10_p01 = array();
	$t07_p01 = array();
	$queryParams = array();

	$peg_is_newrec = 0;
	// εαν είναι νέα εγγραφή
	if (empty($data['nr01'])) {
		$peg_is_newrec = 1;
	}

	$data_a18_p01_tmp = $data['a18_p01'];
	if(strpos($data_a18_p01_tmp, '##') !== false) {
		$data_a18_p01_tmp = str_replace('##', '#code_field_empty_string#', $data_a18_p01_tmp);
	}

	$a18_p01 = explode('#', trim($data_a18_p01_tmp, '#'));
	$a10_p01 = explode('#', trim($data['a10_p01'], '#'));
	$t07_p01 = explode('#', trim($data['t07_p01'], '#'));

	// Τύποι Παραστατικών
	$a18_p01_query = "";
	$a18_p01_queryParams = array();
	$i = 0;
	foreach ($a18_p01 as $value) {
		if($value == 'code_field_empty_string') {
			$value = '';
		}
		if (empty($a18_p01_query)) {
			$operator = "";
		} else {
			$operator = " OR ";
		}
		$a18_p01_query .= $operator . " a18_p01 LIKE :a18_p01_param" . $i . " ";
		$a18_p01_queryParams['a18_p01_param' . $i] = "%#" . $value . "#%";
		$i++;
	}

	// Σειρές Παραστατικών
	$a10_p01_query = "";
	$a10_p01_queryParams = array();
	$i = 0;
	foreach ($a10_p01 as $value) {
		if (empty($a10_p01_query)) {
			$operator = "";
		} else {
			$operator = " OR ";
		}
		$a10_p01_query .= $operator . " a10_p01 LIKE :a10_p01_param" . $i . " ";
		$a10_p01_queryParams['a10_p01_param' . $i] = "%#" . $value . "#%";
		$i++;
	}

	// Καταστήματα
	if (pegasus_module_exists("stores")) {
		$t07_p01_query = "";
		$t07_p01_queryParams = array();
		$i = 0;
		foreach ($t07_p01 as $value) {
			if (empty($t07_p01_query)) {
				$operator = "";
			} else {
				$operator = " OR ";
			}
			$t07_p01_query .= $operator . " t07_p01 LIKE :t07_p01_param" . $i . " ";
			$t07_p01_queryParams['t07_p01_param' . $i] = "%#" . $value . "#%";
			$i++;
		}
	}


	// Αν δεν έχω new record, δεν θελω να φέρει αποτέλεσμα για το ίδιο ΜΚ. (Θα χτυπάει στο edit αν βρίσκει υπερκάλυψη από τον εαυτό του)
	$nr01_query = "";
	if ($peg_is_newrec == 0) {
		$nr01_query = " AND nr01 <> :nr01";
		$queryParams['nr01'] = $data['nr01'];
	}

	// Αν έχω stores, ελέγχω και για stores.
	if (pegasus_module_exists("stores")) {
		$query = "  SELECT
						nr01
					FROM
						einv02
					WHERE
						( " . $a18_p01_query . " )
						AND ( " . $a10_p01_query . " )
						AND ( " . $t07_p01_query . ")
						" . $nr01_query;
		$queryParams = array_merge($queryParams, $a18_p01_queryParams, $a10_p01_queryParams, $t07_p01_queryParams);
	} else {
		$query = "  SELECT
						nr01
					FROM
						einv02
					WHERE
						( " . $a18_p01_query . " )
						AND ( " . $a10_p01_query . " )
						" . $nr01_query;
		$queryParams = array_merge($queryParams, $a18_p01_queryParams, $a10_p01_queryParams);
	}


	$einv01_type = pegasus_mysql_printfld("einv01", "type", "nr01 = ? ", array($data["einv01"]));
	if($einv01_type != $data["type"]){
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_einv_wrong_einv_type']));
	}


	pegasus_mysql_use($query, $record, $queryParams);
	if (!empty($record['nr01'])) {
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_einv_overlap_err']));
	}

	if (empty($data['a18_p01']) || empty($data['a10_p01']) || (pegasus_module_exists('stores') && empty($data['t07_p01']))) {
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_einv_empty_fields_err']));
	}

	// $debug = array();
	// $debug['query'] = $query;
	// $debug['queryParams'] = $queryParams;
	// $debug['queryReplace'] = pegasus_replace_values_in_sql($query, $queryParams);
	// echo '<pre>' . print_r($debug, 1) . '</pre>';

	return array($data, $permDeny);
}
function einv_einv03_d_change($data, $permDeny, $mmnr01, $checkOnlyPerm)
{

	// Ελέγχω αν υπάρχει υπερκάλυψη συνδιασμών σε [Κατάστημα - Σειρά - Τύπο Παραστατικού]
	$a18_p01 = array();
	$a11_p01 = array();
	$t07_p01 = array();
	$queryParams = array();

	$peg_is_newrec = 0;
	// εαν είναι νέα εγγραφή
	if (empty($data['nr01'])) {
		$peg_is_newrec = 1;
	}
	
	$data_a18_p01_tmp = $data['a18_p01'];
	if(strpos($data_a18_p01_tmp, '##') !== false) {
		$data_a18_p01_tmp = str_replace('##', '#code_field_empty_string#', $data_a18_p01_tmp);
	}

	$a18_p01 = explode('#', trim($data_a18_p01_tmp, '#'));
	$a11_p01 = explode('#', trim($data['a11_p01'], '#'));
	$t07_p01 = explode('#', trim($data['t07_p01'], '#'));

	// Τύποι Παραστατικών
	$a18_p01_query = "";
	$a18_p01_queryParams = array();
	$i = 0;
	foreach ($a18_p01 as $value) {
		if($value == 'code_field_empty_string') {
			$value = '';
		}
		if (empty($a18_p01_query)) {
			$operator = "";
		} else {
			$operator = " OR ";
		}
		$a18_p01_query .= $operator . " a18_p01 LIKE :a18_p01_param" . $i . " ";
		$a18_p01_queryParams['a18_p01_param' . $i] = "%#" . $value . "#%";
		$i++;
	}

	// Σειρές Παραστατικών
	$a11_p01_query = "";
	$a11_p01_queryParams = array();
	$i = 0;
	foreach ($a11_p01 as $value) {
		if (empty($a11_p01_query)) {
			$operator = "";
		} else {
			$operator = " OR ";
		}
		$a11_p01_query .= $operator . " a11_p01 LIKE :a11_p01_param" . $i . " ";
		$a11_p01_queryParams['a11_p01_param' . $i] = "%#" . $value . "#%";
		$i++;
	}

	// Καταστήματα
	if (pegasus_module_exists("stores")) {
		$t07_p01_query = "";
		$t07_p01_queryParams = array();
		$i = 0;
		foreach ($t07_p01 as $value) {
			if (empty($t07_p01_query)) {
				$operator = "";
			} else {
				$operator = " OR ";
			}
			$t07_p01_query .= $operator . " t07_p01 LIKE :t07_p01_param" . $i . " ";
			$t07_p01_queryParams['t07_p01_param' . $i] = "%#" . $value . "#%";
			$i++;
		}
	}

	// Αν δεν έχω new record, δεν θελω να φέρει αποτέλεσμα για το ίδιο ΜΚ. (Θα χτυπάει στο edit αν βρίσκει υπερκάλυψη από τον εαυτό του)
	$nr01_query = "";
	if ($peg_is_newrec == 0) {
		$nr01_query = " AND nr01 <> :nr01";
		$queryParams['nr01'] = $data['nr01'];
	}


	if (pegasus_module_exists("stores")) {
		$query = "  SELECT
						nr01
					FROM
						einv03
					WHERE
						( " . $a18_p01_query . " ) 
						AND ( " . $a11_p01_query . " )
						AND ( " . $t07_p01_query . ")
						" . $nr01_query;
		$queryParams = array_merge($queryParams, $a18_p01_queryParams, $a11_p01_queryParams, $t07_p01_queryParams);
	} else {
		$query = "  SELECT
						nr01
					FROM
						einv03
					WHERE
						( " . $a18_p01_query . " )
						AND ( " . $a11_p01_query . " )
						" . $nr01_query;
		$queryParams = array_merge($queryParams, $a18_p01_queryParams, $a11_p01_queryParams);
	}


	pegasus_mysql_use($query, $record, $queryParams);
	if (!empty($record['nr01'])) {
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_einv_overlap_err']));
	}
	if (empty($data['a18_p01']) || empty($data['a11_p01']) || (pegasus_module_exists('stores') && empty($data['t07_p01']))) {
		array_push($permDeny, array('type' => 'deny', 'message' => "Πρέπει να συμπληρωθούν όλα τα πεδία"));
	}

	$einv01_type = pegasus_mysql_printfld("einv01", "type", "nr01 = ? ", array($data["einv01"]));
	if($einv01_type != $data["type"]){
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_einv_wrong_einv_type']));
	}
	// $debug = array();
	// $debug['query'] = $query;
	// $debug['queryParams'] = $queryParams;
	// $debug['queryReplace'] = pegasus_replace_values_in_sql($query, $queryParams);
	// echo '<pre>' . print_r($debug, 1) . '</pre>';

	return array($data, $permDeny);
}
function einv_einv04_d_change($data, $permDeny, $mmnr01, $checkOnlyPerm)
{

	// Ελέγχω αν υπάρχει υπερκάλυψη συνδιασμών σε [Κατάστημα - Σειρά - Τύπο Παραστατικού]
	$a18_p01 = array();
	$t10_p01 = array();
	$t07_p01 = array();
	$queryParams = array();

	$peg_is_newrec = 0;
	// εαν είναι νέα εγγραφή
	if (empty($data['nr01'])) {
		$peg_is_newrec = 1;
	}

	$data_a18_p01_tmp = $data['a18_p01'];
	if(strpos($data_a18_p01_tmp, '##') !== false) {
		$data_a18_p01_tmp = str_replace('##', '#code_field_empty_string#', $data_a18_p01_tmp);
	}

	$a18_p01 = explode('#', trim($data_a18_p01_tmp, '#'));
	$t10_p01 = explode('#', trim($data['t10_p01'], '#'));
	$t07_p01 = explode('#', trim($data['t07_p01'], '#'));

	// Τύποι Παραστατικών
	$a18_p01_query = "";
	$a18_p01_queryParams = array();
	$i = 0;
	foreach ($a18_p01 as $value) {
		if($value == 'code_field_empty_string') {
			$value = '';
		}
		if (empty($a18_p01_query)) {
			$operator = "";
		} else {
			$operator = " OR ";
		}
		$a18_p01_query .= $operator . " a18_p01 LIKE :a18_p01_param" . $i . " ";
		$a18_p01_queryParams['a18_p01_param' . $i] = "%#" . $value . "#%";
		$i++;
	}

	// Σειρές Παραστατικών
	$t10_p01_query = "";
	$t10_p01_queryParams = array();
	$i = 0;
	foreach ($t10_p01 as $value) {
		if (empty($t10_p01_query)) {
			$operator = "";
		} else {
			$operator = " OR ";
		}
		$t10_p01_query .= $operator . " t10_p01 LIKE :t10_p01_param" . $i . " ";
		$t10_p01_queryParams['t10_p01_param' . $i] = "%#" . $value . "#%";
		$i++;
	}

	// Καταστήματα
	if (pegasus_module_exists("stores")) {
		$t07_p01_query = "";
		$t07_p01_queryParams = array();
		$i = 0;
		foreach ($t07_p01 as $value) {
			if (empty($t07_p01_query)) {
				$operator = "";
			} else {
				$operator = " OR ";
			}
			$t07_p01_query .= $operator . " t07_p01 LIKE :t07_p01_param" . $i . " ";
			$t07_p01_queryParams['t07_p01_param' . $i] = "%#" . $value . "#%";
			$i++;
		}
	}

	// Αν δεν έχω new record, δεν θελω να φέρει αποτέλεσμα για το ίδιο ΜΚ. (Θα χτυπάει στο edit αν βρίσκει υπερκάλυψη από τον εαυτό του)
	$nr01_query = "";
	if ($peg_is_newrec == 0) {
		$nr01_query = " AND nr01 <> :nr01";
		$queryParams['nr01'] = $data['nr01'];
	}

	if (pegasus_module_exists("stores")) {
		$query = "  SELECT
						nr01
					FROM
						einv04
					WHERE
						( " . $a18_p01_query . " )
						AND ( " . $t10_p01_query . " )
						AND ( " . $t07_p01_query . ")
						" . $nr01_query;
		$queryParams = array_merge($queryParams, $a18_p01_queryParams, $t10_p01_queryParams, $t07_p01_queryParams);
	} else {
		$query = "  SELECT
						nr01
					FROM
						einv04
					WHERE
						( " . $a18_p01_query . " )
						AND ( " . $t10_p01_query . " )
						" . $nr01_query;
		$queryParams = array_merge($queryParams, $a18_p01_queryParams, $t10_p01_queryParams);
	}


	pegasus_mysql_use($query, $record, $queryParams);
	if (!empty($record['nr01'])) {
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_einv_overlap_err']));
	}
	if (empty($data['a18_p01']) || empty($data['t10_p01']) || (pegasus_module_exists('stores') && empty($data['t07_p01']))) {
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_einv_empty_fields_err']));
	}

	$einv01_type = pegasus_mysql_printfld("einv01", "type", "nr01 = ? ", array($data["einv01"]));
	if($einv01_type != $data["type"]){
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_einv_wrong_einv_type']));
	}

	// $debug = array();
	// $debug['query'] = $query;
	// $debug['queryParams'] = $queryParams;
	// $debug['queryReplace'] = pegasus_replace_values_in_sql($query, $queryParams);
	// echo '<pre>' . print_r($debug, 1) . '</pre>';

	return array($data, $permDeny);
}
function einv_einv05_d_change($data, $permDeny, $mmnr01, $checkOnlyPerm)
{

	//TODO Έλεγχος με κενή παράμετρο. Κυρίως για stores.
	// Ελέγχω αν υπάρχει υπερκάλυψη συνδιασμών σε [Κατάστημα - Σειρά - Τύπο Παραστατικού]
	$tran08_p01 = array();
	$tran20_p01 = array();
	$t07_p01 = array();
	$queryParams = array();

	$peg_is_newrec = 0;
	// εαν είναι νέα εγγραφή
	if (empty($data['nr01'])) {
		$peg_is_newrec = 1;
	}

	$data_tran08_p01_tmp = $data['tran08_p01'];
	if(strpos($data_tran08_p01_tmp, '##') !== false) {
		$data_tran08_p01_tmp = str_replace('##', '#code_field_empty_string#', $data_tran08_p01_tmp);
	}

	$tran08_p01 = explode('#', trim($data_tran08_p01_tmp, '#'));
	$tran20_p01 = explode('#', trim($data['tran20_p01'], '#'));
	$t07_p01 = explode('#', trim($data['t07_p01'], '#'));

	// Τύποι Παραστατικών
	$tran08_p01_query = "";
	$tran08_p01_queryParams = array();
	$i = 0;
	foreach ($tran08_p01 as $value) {
		if($value == 'code_field_empty_string') {
			$value = '';
		}
		if (empty($tran08_p01_query)) {
			$operator = "";
		} else {
			$operator = " OR ";
		}
		$tran08_p01_query .= $operator . " tran08_p01 LIKE :tran08_p01_param" . $i . " ";
		$tran08_p01_queryParams['tran08_p01_param' . $i] = "%#" . $value . "#%";
		$i++;
	}

	// Σειρές Παραστατικών
	$tran20_p01_query = "";
	$tran20_p01_queryParams = array();
	$i = 0;
	foreach ($tran20_p01 as $value) {
		if (empty($tran20_p01_query)) {
			$operator = "";
		} else {
			$operator = " OR ";
		}
		$tran20_p01_query .= $operator . " tran20_p01 LIKE :tran20_p01_param" . $i . " ";
		$tran20_p01_queryParams['tran20_p01_param' . $i] = "%#" . $value . "#%";
		$i++;
	}

	// Καταστήματα
	if (pegasus_module_exists("stores")) {
		$t07_p01_query = "";
		$t07_p01_queryParams = array();
		$i = 0;
		foreach ($t07_p01 as $value) {
			if (empty($t07_p01_query)) {
				$operator = "";
			} else {
				$operator = " OR ";
			}
			$t07_p01_query .= $operator . " t07_p01 LIKE :t07_p01_param" . $i . " ";
			$t07_p01_queryParams['t07_p01_param' . $i] = "%#" . $value . "#%";
			$i++;
		}
	}

	// Αν δεν έχω new record, δεν θελω να φέρει αποτέλεσμα για το ίδιο ΜΚ. (Θα χτυπάει στο edit αν βρίσκει υπερκάλυψη από τον εαυτό του)
	$nr01_query = "";
	if ($peg_is_newrec == 0) {
		$nr01_query = " AND nr01 <> :nr01";
		$queryParams['nr01'] = $data['nr01'];
	}

	if (pegasus_module_exists("stores")) {
		$query = "  SELECT
						nr01
					FROM
						einv05
					WHERE
						( " . $tran08_p01_query . " ) 
						AND ( " . $tran20_p01_query . " )
						AND ( " . $t07_p01_query . ")
						" . $nr01_query;
		$queryParams = array_merge($queryParams, $tran08_p01_queryParams, $tran20_p01_queryParams, $t07_p01_queryParams);
	} else {
		$query = "  SELECT
						nr01
					FROM
						einv05
					WHERE
						( " . $tran08_p01_query . " ) 
						AND ( " . $tran20_p01_query . " )
						" . $nr01_query;
		$queryParams = array_merge($queryParams, $tran08_p01_queryParams, $tran20_p01_queryParams);
	}


	pegasus_mysql_use($query, $record, $queryParams);
	if (!empty($record['nr01'])) {
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_einv_overlap_err']));
	}
	if (empty($data['tran08_p01']) || empty($data['tran20_p01']) || (pegasus_module_exists('stores') && empty($data['t07_p01']))) {
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_einv_empty_fields_err']));
	}

	$einv01_type = pegasus_mysql_printfld("einv01", "type", "nr01 = ? ", array($data["einv01"]));
	if($einv01_type != $data["type"]){
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_einv_wrong_einv_type']));
	}

	// $debug = array();
	// $debug['query'] = $query;
	// $debug['queryParams'] = $queryParams;
	// $debug['queryReplace'] = pegasus_replace_values_in_sql($query, $queryParams);
	// echo '<pre>' . print_r($debug, 1) . '</pre>';

	return array($data, $permDeny);
}
function einv_einv06_d_change($data, $permDeny, $mmnr01, $checkOnlyPerm)
{

	// Ελέγχω αν υπάρχει υπερκάλυψη συνδιασμών σε [Κατάστημα - Σειρά - Τύπο Παραστατικού]
	$a18_p01 = array();
	$a30_p01 = array();
	$t07_p01 = array();
	$queryParams = array();

	$peg_is_newrec = 0;
	// εαν είναι νέα εγγραφή
	if (empty($data['nr01'])) {
		$peg_is_newrec = 1;
	}

	$data_a18_p01_tmp = $data['a18_p01'];
	if(strpos($data_a18_p01_tmp, '##') !== false) {
		$data_a18_p01_tmp = str_replace('##', '#code_field_empty_string#', $data_a18_p01_tmp);
	}

	$a18_p01 = explode('#', trim($data_a18_p01_tmp, '#'));
	$a30_p01 = explode('#', trim($data['a30_p01'], '#'));
	$t07_p01 = explode('#', trim($data['t07_p01'], '#'));

	// Τύποι Παραστατικών
	$a18_p01_query = "";
	$a18_p01_queryParams = array();
	$i = 0;
	foreach ($a18_p01 as $value) {
		if($value == 'code_field_empty_string') {
			$value = '';
		}
		if (empty($a18_p01_query)) {
			$operator = "";
		} else {
			$operator = " OR ";
		}
		$a18_p01_query .= $operator . " a18_p01 LIKE :a18_p01_param" . $i . " ";
		$a18_p01_queryParams['a18_p01_param' . $i] = "%#" . $value . "#%";
		$i++;
	}

	// Σειρές Παραστατικών
	$a30_p01_query = "";
	$a30_p01_queryParams = array();
	$i = 0;
	foreach ($a30_p01 as $value) {
		if (empty($a30_p01_query)) {
			$operator = "";
		} else {
			$operator = " OR ";
		}
		$a30_p01_query .= $operator . " a30_p01 LIKE :a30_p01_param" . $i . " ";
		$a30_p01_queryParams['a30_p01_param' . $i] = "%#" . $value . "#%";
		$i++;
	}

	// Καταστήματα
	if (pegasus_module_exists("stores")) {
		$t07_p01_query = "";
		$t07_p01_queryParams = array();
		$i = 0;
		foreach ($t07_p01 as $value) {
			if (empty($t07_p01_query)) {
				$operator = "";
			} else {
				$operator = " OR ";
			}
			$t07_p01_query .= $operator . " t07_p01 LIKE :t07_p01_param" . $i . " ";
			$t07_p01_queryParams['t07_p01_param' . $i] = "%#" . $value . "#%";
			$i++;
		}
	}


	// Αν δεν έχω new record, δεν θελω να φέρει αποτέλεσμα για το ίδιο ΜΚ. (Θα χτυπάει στο edit αν βρίσκει υπερκάλυψη από τον εαυτό του)
	$nr01_query = "";
	if ($peg_is_newrec == 0) {
		$nr01_query = " AND nr01 <> :nr01";
		$queryParams['nr01'] = $data['nr01'];
	}

	// Αν έχω stores, ελέγχω και για stores.
	if (pegasus_module_exists("stores")) {
		$query = "  SELECT
						nr01
					FROM
						einv06
					WHERE
						( " . $a18_p01_query . " )
						AND ( " . $a30_p01_query . " )
						AND ( " . $t07_p01_query . ")
						" . $nr01_query;
		$queryParams = array_merge($queryParams, $a18_p01_queryParams, $a30_p01_queryParams, $t07_p01_queryParams);
	} else {
		$query = "  SELECT
						nr01
					FROM
						einv06
					WHERE
						( " . $a18_p01_query . " )
						AND ( " . $a30_p01_query . " )
						" . $nr01_query;
		$queryParams = array_merge($queryParams, $a18_p01_queryParams, $a30_p01_queryParams);
	}


	$einv01_type = pegasus_mysql_printfld("einv01", "type", "nr01 = ? ", array($data["einv01"]));
	if($einv01_type != $data["type"]){
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_einv_wrong_einv_type']));
	}


	pegasus_mysql_use($query, $record, $queryParams);
	if (!empty($record['nr01'])) {
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_einv_overlap_err']));
	}

	if (empty($data['a18_p01']) || empty($data['a30_p01']) || (pegasus_module_exists('stores') && empty($data['t07_p01']))) {
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_einv_empty_fields_err']));
	}

	// $debug = array();
	// $debug['query'] = $query;
	// $debug['queryParams'] = $queryParams;
	// $debug['queryReplace'] = pegasus_replace_values_in_sql($query, $queryParams);
	// echo '<pre>' . print_r($debug, 1) . '</pre>';

	return array($data, $permDeny);
}
function einv_get_by_pnr01($pnr01, $einv01_nr01) {
	$einv01 = array();
	pegasus_mysql_use("SELECT * FROM einv01 WHERE nr01 = :nr01", $einv01, array('nr01' => $einv01_nr01));
	$params = array('pnr01' => $pnr01);
	$einv_service_call_get_resp = einv_service_call_get('invoice-data', $einv01, $params, $pnr01);
	$log = $einv_service_call_get_resp['log'];
	$log['attributes']['pnr01'] = $pnr01;
	/**
	 * CURL Exception
	 */
	if($einv_service_call_get_resp['ok'] != 1) {
		$code = 'einv:einv_get_by_pnr01:curl';
		$msg = "Request παραστατικό με βάση το pnr01: Exception: {$einv_service_call_get_resp['msg']}";
		einv_external_logging(true, $code, $msg, $log);
		einv_einv90_logging($einv01, 'invoice-data-get', $log['request'], $einv_service_call_get_resp['msg']);
		return array(
			'ok'	=> 0,
			'code'	=> $einv_service_call_get_resp['code'],
			'msg'	=> 'Error: '.$einv_service_call_get_resp['msg']
		);
	}
	$response = json_decode($einv_service_call_get_resp['data']['response'], true);
	/**
	 * JSON decode error
	 */
	if(!is_array($response)) {
		$code = 'einv:einv_get_by_pnr01:json';
		$msg = 'Request παραστατικό με βάση το pnr01: Αποτυχία στη JSON decode του response';
		einv_external_logging(true, $code, $msg, $log);
		einv_einv90_logging($einv01, 'invoice-data-get', $log['request'], $msg. "\n". $log['response']);
		return array(
			'ok'	=> 0,
			'code'	=> 500,
			'msg'	=> 'Empty Response'
		);
	}
	/**
	 * Success
	 */
	$code = 'einv:einv_get_by_pnr01:success';
	$msg = 'Επιτυχής ανάσυρση παραστατικού';
	einv_external_logging(false, $code, $msg, $log, $response);
	einv_einv90_logging($einv01, 'invoice-data-get', $log['request'], $response);
	return $response;

}
function einv_check_token($einv01_nr01) {
	$einv01 = array();
	pegasus_mysql_use("SELECT * FROM einv01 WHERE nr01 = :nr01", $einv01, array('nr01' => $einv01_nr01));
	$einv_service_call_get_resp = einv_service_call_get('oauthcheck', $einv01, array());
	$response = json_decode($einv_service_call_get_resp['data']['response'], true);
	if(is_array($response) && !empty($response['ok'] == 0)) {
		if (einv_service_refresh_token($einv01)) {
			$einv_service_call_get_resp =  einv_service_call_get('oauthcheck', $einv01, array(), true);
			if($einv_service_call_get_resp['ok'] != 1) {
				return array(
					'ok'	=> 0,
					'code'	=> $einv_service_call_get_resp['code'],
					'msg'	=> 'Error: '.$einv_service_call_get_resp['msg']
				);
			}
			$response = json_decode($einv_service_call_get_resp['data']['response'], true);
		}
	}
	/**
	 * JSON decode error
	 */
	if(!is_array($response)) {
		return array(
			'ok'	=> 0,
			'code'	=> 500,
			'msg'	=> 'Empty Response'
		);
	}
	return $response;
}
function einv_module_where(){
	return "en=1 and p00 in ('einv' , 'einv02')";
}
/**
 * Χρησιμποιείται για να ξαναστείλουμε παραστατικό στο myDATA
 * Μέχρι τώρα οι λόγοι για τους οποίους χρειαζόμαστε την λογική της επαναποστολής είναι:
 * 1. Δεν πήραμε σωστή μορφή response
 * 2. Πήραμε timeout κατά την αποστολή του παραστατικού (errno = 28)
 */
function einv_resend($einv01 = array(), $data = array()){
	list($service_host, $service_url) = einv_get_service_url('invoice-data');
	$headers = array("Authorization:Bearer " . (empty($einv01['p11']) ? $einv01['p10'] : $einv01['p11']));
	$response = array();
	$error_code = '';
	$msg = '';
	try{
		$curl = pegasus_curl_request_post(
			$service_url, 
			$data, 
			true, 
			$headers, 
			array(
				CURLOPT_SSL_VERIFYPEER => false
			),
			true
		);
		$response = json_decode($curl['response'], true);
		if(!is_array($response)){
			$response['ok'] = 0;
			//Ελεγχω αν εχω http code "40X", "50X" και γεμίζω το $msg
			if(!empty($curl['http_code'])){
				$msg = " HTTP CODE ". $curl['http_code'] ;	
				$error_code = "http:".$curl['http_code'];
			}
			// Αν έχουμε JSON Error
			if(json_last_error() !== JSON_ERROR_NONE) {
				$msg .= "<br>\n{$_SESSION['peg_dic_einv_json_error']}";
				if(function_exists('json_last_error_msg')) {
					$msg .="<br><br>\n<pre>".json_last_error_msg()."</pre>";
				}
				$error_code = "JSON:".json_last_error();
			}
		}
	}catch (Exception $ex) {
		// Γεμίζω το $msg με το exception message και το επιστρέφω με τη λογική που επιστρέφει η συνάρτηση.
		$msg = $ex->getMessage();
		$error_code = "exc:". $ex->getCode();
	}
	$is_error = empty($error_code) ? false :true;
	$log_code = 'einv:einv_resend:'.($is_error ? 'error' : 'success');
	$log = array(
		'request' => array(
			'url'       => $service_url,
			'body'      => $data,
		),
		'response' => $response,
		'attributes'    => array(
			'service-host'  => $service_host,
			'host'          => $_SERVER['SERVER_NAME']
		)
	);
	einv_external_logging($is_error, $log_code, empty($msg)? 'Επαναποστολή παραστατικού' : $msg, $log);
	return array($response, $error_code, $msg);
}

function einv_send_prepare_data($mydt10_nr01){


	$data = array();
	// Φέρνω τα δεδομένα του mydt10 με βάση το ΜΚ του.

	// Κατηγορίες Παραστατικών mydt50
	// p101 = "Όχι εκδότης" | p102 = "Όχι Λήπτης" | p103 = "Όχι Συσχετιζόμενα" | p104 = "Όχι Τρ. Πληρωμής"
	pegasus_mysql_use(' SELECT 
							mydt50.p103 
						FROM mydt10 
						JOIN mydt50 on mydt10.invtype = mydt50.p00 
						WHERE 
							mydt10.nr01 = ?',
						$mydt50,
						array($mydt10_nr01));
	if($mydt50['p103'] != 1) {
		// Αν η Κατηγορία Παραστατικού ΔΕΝ έχει τσεκαρισμένο το "Όχι Συσχετιζόμενα".
		// Εκτελώ την einv_checkCorrelated - Είναι αντιγραφή της _checkCorrelated από το mydt
		// Ψάχνει και συμπληρώνει τα ΜΑΡΚ των συσχετιζόμενων (correlinv) από τα pegasus ids (pcor)
		einv_checkCorrelated($mydt10_nr01);
	}

	//* Οχι select * γιατί έχω πρόβλημα στο hash.
	//TODO δίνω καρφωτά transmission_failure, is_address_num, cp_address_num, fuelinvoice στο select και όχι στο array για να κρατήσω τη σειρά των δεδομένων
	//TODO να αλλάξει όταν μπουν τα πεδία στη βάση.
	$mydt10_query = "   SELECT
							tr_fail AS transmission_failure,

							IF (mydt50.p101 = 1, '', mydt10.is_vat) as is_vat,
							IF (mydt50.p101 = 1, '', mydt10.is_country) as is_country,
							IF (mydt50.p101 = 1, 0, mydt10.is_branch) as is_branch,
							IF (mydt50.p101 = 1, '', mydt10.is_name) as is_name,
							IF (mydt50.p101 = 1, '', mydt10.is_address) as is_address,
							IF (mydt50.p101 = 1, '', '0') as is_address_num,
							IF (mydt50.p101 = 1, '', mydt10.is_city) as is_city,
							IF (mydt50.p101 = 1, '', mydt10.is_zip) as is_zip,

							

							IF( (mydt50.p102 != 1 or (fuelinv = 1 and cp_p600 != '') or mydt10.isdlvno = 1), mydt10.cp_vat, '') as cp_vat,
							IF( (mydt50.p102 != 1 or (fuelinv = 1 and cp_p600 != '') or mydt10.isdlvno = 1), mydt10.cp_country, '') as cp_country,

							IF (mydt50.p102 != 1 or mydt10.isdlvno = 1, mydt10.cp_branch, 0) as cp_branch,
							IF (mydt50.p102 != 1 or mydt10.isdlvno = 1, mydt10.cp_name, '') as cp_name,
							IF (mydt50.p102 != 1 or mydt10.isdlvno = 1, mydt10.cp_address, '') as cp_address,
							IF (mydt50.p102 != 1 or mydt10.isdlvno = 1, mydt10.cp_city, '') as cp_city,
							IF (mydt50.p102 != 1 or mydt10.isdlvno = 1, mydt10.cp_zip, '') as cp_zip,
							IF (mydt50.p102 != 1 or mydt10.isdlvno = 1, '0', '') as cp_address_num,
							series,
							aa,
							issuedate,
							issuetime,
							invtype,
							vatpaysusp,
							IF(ifnull(mydt50.p107, 0) = 1,  '', 
								if(mydt10.currency in ('', '0'), 'EUR', mydt10.currency)
							) as currency,
							exchrate,
							IF (mydt50.p103 = 1, '', mydt10.correlinv) as correlinv,
							slfpricing,
							IF (mydt50.p106 = 1, '0100-01-01', mydt10.dispdate) as dispdate,
							IF (mydt50.p106 = 1, '', mydt10.disptime) as disptime,
							IF (mydt50.p106 = 1, '', mydt10.vehiclenum) as vehiclenum,
							IF (mydt50.p106 = 1, '', mydt10.mvpurpose) as mvpurpose,
							IF (mydt50.p104 = 1, '', mydt10.paytype) as paytype,


							IF (mydt50.p107 = 1 or mydt10.isdlvno = 1, mydt10.ldstreet, '') as ldstreet,
							IF (mydt50.p107 = 1 or mydt10.isdlvno = 1, mydt10.ldnumber, '') as ldnumber,
							IF (mydt50.p107 = 1 or mydt10.isdlvno = 1, mydt10.ldzip, '') as ldzip,
							IF (mydt50.p107 = 1 or mydt10.isdlvno = 1, mydt10.ldcity, '') as ldcity,

							IF (mydt50.p107 = 1 or mydt10.isdlvno = 1, mydt10.dlvstreet, '') as dlvstreet,
							IF (mydt50.p107 = 1 or mydt10.isdlvno = 1, mydt10.dlvnumber, '') as dlvnumber,
							IF (mydt50.p107 = 1 or mydt10.isdlvno = 1, mydt10.dlvzip, '') as dlvzip,
							IF (mydt50.p107 = 1 or mydt10.isdlvno = 1, mydt10.dlvcity, '') as dlvcity,

							IF (mydt50.p107 = 1 or mydt10.isdlvno = 1, mydt10.ss_branch, '') as ss_branch,
							IF (mydt50.p107 = 1 or mydt10.isdlvno = 1, mydt10.cs_branch, '') as cs_branch,
							isdlvno as isdlvno, 
							othmvpur as othmvpur, 

							

							fuelinv AS fuelinvoice,
							tnetvalue,
							tvat_am,
							twthhld_am,
							tfees_am,
							tstamp_am,
							ttax_am,
							tdeduction,
							-- //code_rev:2025-04-13 Γιατι υπαρχει αυτο??? 
							IF (mydt50.p104 = 1, 0, mydt10.tgross_val) as tgross_val, 							
							mydt10.p00,
							pnr01,
							tbl,
							tbl_nr01,
							/* add vehiclenum to notes if no vehiclenum can be sent */
							concat(
								IF(
									ifnull(mydt50.p106, 0) = 1 AND mydt10.vehiclenum <> '',
									concat('Οχημα: ', mydt10.vehiclenum, ' '),
									''
								),
								ifnull(p_notes, '')
							) as p_notes,
							cp_p600,
							cp_p601, 
							cp_p602, 
							thcoll,
							IF(mydt10.mconauth <> '', '', mydt10.mconmrk) AS mconmrk,
							
							tableaa,
							spinvcat,
							tcdord,
							mconauth
						FROM
							mydt10
						LEFT JOIN mydt50 on mydt50.p00 = mydt10.invtype
						WHERE
							mydt10.nr01 = :nr01;";
	pegasus_mysql_use($mydt10_query, $mydt10, array("nr01" => $mydt10_nr01));
	

	//Αν το παραστατικό είναι 8.6 και είναι ακύρωση τότε το βαζω τις αξίες.
	if($mydt10['tcdord']==1 && $mydt10['invtype'] == '8.6') {
		$mydt10['tnetvalue'] = '0';
		$mydt10['tvat_am'] = '0';
		$mydt10['tfees_am'] = '0';
		$mydt10['ttax_am'] = '0';
		$mydt10['tdeduction'] = '0';
		$mydt10['tgross_val'] = '0';
	}

	$data = $mydt10;
	unset($data['tbl']);
	unset($data['tbl_nr01']);

	$mydt12_query = "   SELECT mydt10,
						mydt57_p00,
						mydt58_p00,
						mydt61_p00,
						mydt62_p00,
						mydt62_p01,
						linenumber,
						rectype,
						mydt12.p104,
						IF (mydt50.p105 = 1, 0, mydt12.quantity) as quantity,
						fuelcode,
						IF (mydt50.p105 = 1, '', mydt12.munit) as munit,
						invdtype,
						netvalue,
						vatcat,
						vatexcat,
						fpavalue,
						appid,
						appdate,
						doy,
						shipid,
						discoption,
						wthhldpcat,
						wthhld_am,
						stampvalue,
						stamppcat,
						feestype,
						fees_am,
						otaxpcat,
						otax_am,
						deducvalue,
						comments,
						taxcat,
						taxtype,
						taxamount,
						taxunder,
						mydt12.p105,
						mydt12.p106,
						IF (mydt50.p107 = 1 or mydt10.isdlvno = 1, mydt12.taric, '') as taric,
						IF (mydt50.p107 = 1 or mydt10.isdlvno = 1 || mydt50.p111 = 1, mydt12.itemcode, '') as itemcode,
						IF (mydt50.p107 = 1 or mydt10.isdlvno = 1 || mydt50.p111 = 1, mydt12.itemdescr, '') as itemdescr,
						mydt12.omunit,
						mydt12.omuntl,
						mydt12.isinfo,
						mydt12.novat195
					FROM mydt12
						LEFT JOIN mydt10 on mydt10.nr01 = mydt12.mydt10
						LEFT JOIN mydt50 on mydt50.p00 = mydt10.invtype
					WHERE
						mydt10 = :mydt10";

	//TODO Επαναφορά των omunit, omuntl μετά το merge του e-invoicing με τη διόρθωση στο XML.

	$res = pegasus_query($mydt12_query, array("mydt10" => $mydt10_nr01));
	$einv02 = array();
	while ($row = pegasus_fetch_assoc($res)) {

		//Αν το παραστατικό είναι 8.6 και είναι ακύρωση
		if($mydt10['tcdord']==1 && $mydt10['invtype'] == '8.6') {
			$row['p104'] = 0;
		}

		$einv02[] = $row;

	}



	//* Η σειρά των δεδομένων είναι σημαντική για το παραστατικό (einv01), βλ. σειρά στο service.
	//* Για το einv02 δεν μας απασχολεί, είναι json, όπως σταλεί από εδώ, θα περαστεί και στο service.

	$data['einv02'] = json_encode($einv02);

	$mydt13_query = "select * from mydt13 where mydt10 = :mydt10 ";
	$res = pegasus_query($mydt13_query, array("mydt10" => $mydt10_nr01) );
	$payments = [];
	while ($row = pegasus_fetch_assoc($res)) {
		$payments[] = array(
			"type" => $row["type"], 
			"amount" => $row["amount"], 
			"tid" => $row["tid"], 
			"amount_t" => $row["amount_t"], 
			"p_sign" => $row["p_sign"]
		);
	}
	if(!empty($payments)){
		$data['payments'] = json_encode($payments);
	}

	$mydt14_query = "	SELECT
							mydt10,
							`type`,
							branch,
							vat,
							country,
							tbl,
							tbl_nr,
							`name`,
							`address`,
							city,
							zip
						FROM mydt14 
						WHERE mydt10 = :mydt10 
	";
	$res = pegasus_query($mydt14_query, array("mydt10" => $mydt10_nr01) );
	$einv09 = array();
	while ($row = pegasus_fetch_assoc($res)) {
		$einv09[] = $row;
	}
	$data['einv09'] = json_encode($einv09);
	

	// Παραμετροι ηλεκτρονικης τιμολόγησης
	$resp = einv_env00_find_data($mydt10_nr01);
	if($resp['ok'] != 1) {
		return $resp;
	}

	$data['einv00'] = json_encode($resp['data']);

	$data = einv_data_sanitizer($data);

	return $data;
	
}

function einv_data_sanitizer($data)
{
	$replace_arr = array(
        "&" => "",
        ">" => "",
        "<" => ""
    );
        
	foreach($data as $k => $v){
		$data[$k] = str_replace(array_keys($replace_arr), array_values($replace_arr), $v);
		if($k == 'p_notes' && !empty($data[$k])) {
			$purifier = new HTMLPurifier(HTMLPurifier_Config::createDefault());
			$data[$k] = $purifier->purify($data[$k]);
		}
	}
	return $data;
}
function einv_send($mydt10_nr01)
{
	$mydt10 = array();
	pegasus_mysql_use("select * from mydt10 where nr01 = :nr01", $mydt10, array("nr01" => $mydt10_nr01));
	$einv01_nr01 = $mydt10["einv_nr"];

	if(empty($einv01_nr01)) {
		$einv01_nr01 = einv00_check_settings($mydt10['tbl'], $mydt10['tbl_nr01']);
	}
	if(empty($einv01_nr01)) {
		return array(
            'ok'        => 0,
			'msg'   	=> $_SESSION['peg_dic_einv_credentials_not_found_err1']
        );
	}
	$data = einv_send_prepare_data($mydt10_nr01);
	$data['sn'] = pegasus_get_app_sn();
	$data['app_code'] = $_SESSION['cor000_app_code'];
	$error_code = '';
	$retry = 0;
	$msg = '';
	 $p_signs = array();
	 if(!empty($data['payments'])) {
		 $payments = json_decode($data['payments'],true);
		 if(is_array($payments)) {
			 foreach($payments as $payment){
				 if(empty($payment['p_sign'])) {
					 continue;
				 }
				 $p_signs[] = $payment['p_sign'];
			 }
		 }
	 }
	  $einv01 = array();
	  pegasus_mysql_use("SELECT * FROM einv01 WHERE nr01 = :nr01", $einv01, array('nr01' => $einv01_nr01));

	 $einv_service_call_post_resp = einv_service_call_post('invoice-data', $einv01, $data);
	 $log = $einv_service_call_post_resp['log'];
	 $log['attributes']['pnr01'] = $data['pnr01'];
	 $log['attributes']['p_sign'] = implode(',',$p_signs);
	 $response = array();
	 /**
	  * Αν ΔΕΝ έχουμε CURL Exception
	  */
	 if($einv_service_call_post_resp['ok'] == 1) {
		$response = json_decode($einv_service_call_post_resp['data']['response'], true);
	   if(!is_array($response)){
		   $log_code = 'einv:einv_send:exec';
		   $log_msg = json_last_error_msg();
		   einv_external_logging(true, $log_code, $log_msg, $log);
		   list($response, $error_code, $msg) = einv_resend($einv01, $data);	
		   $retry = 1;
	   }
	 } 
	 /**
	  * Αν έχουμε CURL Exception
	  */
	 if($einv_service_call_post_resp['ok'] != 1) {
		$log_code = 'einv:einv_send:exec';
		$log_msg = $einv_service_call_post_resp['msg'];
		einv_external_logging(true, $log_code, $log_msg, $log);
		if($einv_service_call_post_resp['data']['code'] == 28){
			list($response, $error_code, $msg) = einv_resend($einv01, $data);
			$retry = 1;
		}else{
			// Γεμίζω το $msg με το exception message και το επιστρέφω με τη λογική που επιστρέφει η συνάρτηση.
			$msg = $einv_service_call_post_resp['msg'];
			$error_code = "exc:". $einv_service_call_post_resp['code'];
			$msg_to_log = "Exception on pegasus_curl_request_post: " . $einv_service_call_post_resp['msg'];
		}
	}
	/**
	 * Αν μπορούμε να κάνουμε einv90/logging
	 */
	einv_einv90_logging($einv01, 'invoice-data', $log['request'],  empty($msg) ? (is_array($response) ? $response : $log['response']) : $msg);

	$invoice_already_sent = 0;
	if($response['code'] == 'customer_api_006' && $retry == 1 && !empty($response['error']['data']['auth_code'])){
		$invoice_already_sent = 1;
	}
	if($response['code'] == 'customer_api_116' && $retry == 1 && !empty($response['error']['data']['auth_code'])){
		$invoice_already_sent = 1;
	}
	
	if ($response['ok'] == 1) {
		//Αν φτάσω εδώ με ok = 1 έχω σίγουρα uid, mark, authcode
		//* 14/02/2023 - Εδώ πλέον μπορώ να φτάσω και αν έχω φτιάξει custom authcode με transmissionFailure = 2
		$arr1 = array();				$arr2 = array();

			array_push($arr1, 'uid');		array_push($arr2, $response['data']['uid']);
			array_push($arr1, 'mark');		array_push($arr2, $response['data']['mark']);
			array_push($arr1, 'auth_cd');	array_push($arr2, $response['data']['authcode']);
			array_push($arr1, 'p02');		array_push($arr2, 1);
			array_push($arr1, 'qrurl');		array_push($arr2, einv_get_qrcode_url($response['data']['authcode'], $mydt10_nr01));
			if($response['data']['transmissionFailure'] == 2) {
				array_push($arr1, 'tr_fail');	array_push($arr2, $response['data']['transmissionFailure']);
			}
			if(!empty($response['data']['p011'])) {
				array_push($arr1, 'p011');	array_push($arr2, $response['data']['p011']);
			} 
			if(!empty($response['data']['p012'])) {
				array_push($arr1, 'p012');	array_push($arr2, $response['data']['p012']);
			} 

			array_push($arr1, 'p101');		array_push($arr2, '');
			array_push($arr1, 'p102');		array_push($arr2, 0);
		
		pegasus_mysql_update('mydt10', $arr1, $arr2, 'nr01= ? ', 0, 1, 1, array($mydt10_nr01));

		//Ημερομηνία και ώρα διαβίβασης πλρωμών.
		pegasus_mysql_update('mydt13', array("einv_dt", "einv_tm"), array(date("Y-m-d"), date("H:i")), 'mydt10=?', 0, 1, 1, array($mydt10_nr01));


	}

	if($invoice_already_sent){
		//Εδώ θα μπει στην περίπτωση που $response['ok'] == 0 και το παραστατικό για κάποιον λόγο έχει ξανασταλεί
		$arr1 = array();				$arr2 = array();
		array_push($arr1, 'uid');		array_push($arr2, $response['error']['data']['uid']);
		array_push($arr1, 'mark');		array_push($arr2, $response['error']['data']['mark']);
		//TODO Μελλοντικά: Θα αλλάξει σε authcode όταν θα είμαστε live στην ηλεκτρονική.
		array_push($arr1, 'auth_cd');	array_push($arr2, $response['error']['data']['auth_code']);
		array_push($arr1, 'p02');		array_push($arr2, 1);
		array_push($arr1, 'qrurl');		array_push($arr2, einv_get_qrcode_url($response['error']['data']['auth_code'], $mydt10_nr01));
		if(!empty($response['error']['data']['p011'])) {
			array_push($arr1, 'p011');	array_push($arr2, $response['error']['data']['p011']);
		} 
		if(!empty($response['error']['data']['p012'])) {
			array_push($arr1, 'p012');	array_push($arr2, $response['error']['data']['p012']);
		} 

		array_push($arr1, 'p101');		array_push($arr2, '');
		array_push($arr1, 'p102');		array_push($arr2, 0);
	
		pegasus_mysql_update('mydt10', $arr1, $arr2, 'nr01= ? ', 0, 1, 1, array($mydt10_nr01));
		//Ημερομηνία και ώρα διαβίβασης πλρωμών.
		pegasus_mysql_update('mydt13', array("einv_dt", "einv_tm"), array(date("Y-m-d"), date("H:i")), 'mydt10=?', 0, 1, 1, array($mydt10_nr01));
		

	} 

	$success = 1;
	if(!empty($msg)) {
		// Αν $msg δεν είναι κενό, έχει γεμίσει από cURL exception error message.
		$arr1 = array();
		$arr2 = array();
		$success = 0;
		array_push($arr1, 'p30');
		array_push($arr2, $msg);
		pegasus_mysql_update('mydt10', $arr1, $arr2, 'nr01= ? ', 0, 1, 1, array($mydt10_nr01));
	}

	if ($response['ok'] == 0 && !$invoice_already_sent) {
		$arr1 = array();
		$arr2 = array();
		$success = 0;
		if (!empty($response['code'])) {

			$error_code = $response['code'];
			
			$msg = "";
			if (!empty($response['error']['message'])) {
				$msg = $response['error']['message'];
				if (!empty($response['error']['data']['errors'])) {
					foreach ($response['error']['data']['errors'] as $error) {
						$msg .= "\nCode: " . $error['code'] . " - " . "Message: " . $error['message'];
						//$error_code =  $error['code'];
						$error_code =  'mydata_business_error';
					}
				}

				if($response["code"] == "mydata_sync_004"){
					$msg_to_log = "Επιχειρησιακό error myDATA: " . $msg ;
				}
				else{
					$msg_to_log = $msg ;
				}

			} elseif (!empty($response['error'])) {
				//401 - Unauthorized
				$msg = "\nCode: " . $response['code'] . " - " . "Message: " . $response['error']['title'];
				$error_code =  $response['code'];
				$msg_to_log = $response['error']['title'];
			}
			if(isset($response['error']['data']['statusCode'])) {
				// HTTP Errors ή curl_error.
				$msg .= "\nstatusCode: " . $response['error']['data']['statusCode'] . " - " . "Message: " . $response['error']['data']['Message'];
				$error_code =  $response['error']['data']['statusCode'];
				if(empty($msg_to_log)) {
					$msg_to_log = $msg;
				}
			}
			array_push($arr1, 'p30');
			array_push($arr2, $msg);
			array_push($arr1, 'p101');
			array_push($arr2, $response['code']);

			if($response['code'] == 'customer_api_099' || $response['code'] == 'mydata_sync_004'){
				array_push($arr1, 'p102');
				array_push($arr2, 1);
			}
			pegasus_mysql_update('mydt10', $arr1, $arr2, 'nr01= ? ', 0, 1, 1, array($mydt10_nr01));
		} else {
			$error_code = "empty_response_code";
		}
	}
	// * 14/02/2023 - Σε περίπτωση success με errors
	// π.χ. Αδυναμία επικοινωνίας με το myDATA και παραγωγή custom auth_code
	if(
		$response['ok'] == 1 
		&& $response['data']['einv03']['ok'] == 0
	) {
		$success = 0;
		$msg = $response['data']['einv03']['error_message'];

		$arr1 = array();			$arr2 = array();
		array_push($arr1, 'p30');	array_push($arr2, $msg);
		pegasus_mysql_update('mydt10', $arr1, $arr2, 'nr01= ? ', 0, 1, 1, array($mydt10_nr01));

		$error_code = "einv03_not_ok";
		$msg_to_log = 'Αδυναμία επικοινωνίας παρόχου με myDATA. Προσωρινή συμβολοσειρά αυθεντικοποίησης από το e-Invoicing.';
	}
	$request_to_log = isset($data) ? $data : null;
	if(
		isset($request_to_log['einv02'])
		&& is_string($request_to_log['einv02'])
	) {
		$request_to_log['einv02'] = json_decode($request_to_log['einv02'],true);
	}
	if(empty($msg_to_log)) {
		$msg_to_log = isset($msg) ? $msg : '';
	}
	if(
		empty($msg_to_log)
		&& $success == 1
	) {
		$msg_to_log = 'Επιτυχής καταχώρηση παραστατικού';
	}
	$log_code = 'einv:einv_send:' . (empty($error_code) ? "success" : $error_code);
	einv_external_logging($success != 1, $log_code, $msg_to_log, $log, $request_to_log);

	// Για το toast κατά την καταχώρηση του παραστατικού.
	$tmp_dic = $_SESSION['peg_dic_einv_einvoicing'] . "<br>" . $_SESSION['peg_dic_einv_einvoicing_succeeded'];
	$ret_msg = str_replace('##1##',  $success . '/' . 1, $tmp_dic);

	if($success == 1) {
		$ret_msg .= "<br>".str_replace(
			array(
				'##executed##',
				'##available##',
				'##limit##'
			),
			array(
				$response['data']['einv04']['executed'],
				$response['data']['einv04']['available'],
				$response['data']['einv04']['limit']
			),
			$_SESSION['peg_dic_einv_einv04_info']
		);
		/**
		 * E: 10001161 / Δ: 10152889
		 */
		if(!empty($response['message'])) {
			$ret_msg = "<b>{$response['message']}</b><br><br>{$ret_msg}";
		}
	}

	if (!empty($msg)) {
		// Το $msg μπορεί να έχει έρθει γεμάτο από cURL exception παραπάνω.
		$ret_msg .= "<br><pre>Εrror:" .  $msg . '</pre>';
	}
	$response['msg'] = $ret_msg;

	if($invoice_already_sent){
		//Το αλλάζουμε εδώ σε περίπτωση που το παραστατικό έχει ήδη σταλεί ωστε το toast να εμφανίζεται ως info
		$response['ok'] = 1;
	}
	// Επιτυχία -> ok = 1, code, data
	// Αποτυχία -> οκ = 0, code, message (προεραιτικά και data αν είναι errors από ααδε)
	return $response;
}
/**
 *
 *   1. Θα πρέπει να καλεί την συνάρτηση που κάνει create το mydt10, mydt11, mydt12. To mydt10.einv = 1
 *   2α. Αν βρει ενημερωμένη την εγγραφή στον mydt10 με auth_cd τοτε θα πει ότι το παραστατικό έχει ήδη υπογραφη ...a55_nr01.
 *   2β. Αλλιώς θα (1) καλέσει την mydt10->execute_update() αφού πρώτα (2) έχει σετάρει το einv = 1 και p02_1 = 1
 *   3. εφόσον γίνει το execute_update κάνει την send και ενημερώνει το auth_cd και errors
 * @param string $tbl - Ο πίνακας (a55, a56, t08, tran01)
 * @param array $tbl_nr01 - ΜΚ της εγγραφής
 *
 * @return string $ret_arr
 */

function einv00_check_and_save($tbl, $tbl_nr01, $transmission_failure = 0)
{
	require_once('../mydt_libs/mydt_mydt10.php');
	require_once('../mydt_libs/mydt_classifications.php');

	$ret_arr = array();
	$ret_arr['ok']  = 0;
	$ret_arr['msg'] = '';

	$einv01 = einv00_check_settings($tbl, $tbl_nr01);
	if (empty($einv01)) {
		//* Δεν έχει ηλεκτρονική, θα επιστρέψει να εκτελέσει την υπάρχουσα λογική.
		$ret_arr['ok']  = 0;
		//TODO Να αφαιρεθεί αυτό το if όταν ενημερωθεί η invsupp_a56_d_on_save να λειτουργεί με invoices_document_after_save_global_check
		if($tbl != "a56") {
			$ret_arr['msg'] = "Δεν βρέθηκε ρύθμιση ηλεκτρονικής τιμολόγησης.";
		}
		$ret_arr['einv'] = 0;
		return $ret_arr;
	}

	pegasus_mysql_use(
		"SELECT nr01, auth_cd , p02, nr01, tr_fail, pnr01, p30 FROM mydt10 WHERE tbl=:tbl && tbl_nr01=:tbl_nr01;", 
		$mydt10, 
		array('tbl' => $tbl, 'tbl_nr01' => $tbl_nr01)
	);

	//TODO: Εδώ θα πρέπει να μπει και if για softone 
	$einv01_type = pegasus_mysql_printfld("einv01", "type", "nr01=?", array($einv01));
	$ret_arr['einv'] = 1; //Ηλεκτρονική Pegasus
	if($einv01_type == 'einv02'){
		$ret_arr['einv'] = 3; // ΙΛΥΔΑ
	}
	

 

	// An yparxei μυδτ10 και ειναι υποεκδοση φτιαξε mydt13 και στειλει 

	try {
		//* (2α)
		if (!empty($mydt10['auth_cd'])) {
			//TODO: Εδώ θα χρειαστεί να κάνουμε ένα GET στην περίπτωση που το tr_fail είναι 2
			if($mydt10['tr_fail'] == 2) {
			//Θα εμφανίσουμε 3 διαφορετικά μηνύματα με βάση τα μηνύματα του GET: 
				$resp = einv_get_by_pnr01($mydt10['pnr01'],$einv01);
				if($resp['ok'] != 1) {
					/**
					 * Το παραστατικό δεν έχει ενημερώσει το myDATA λόγω απώλειας
					 * σύνδεσης με το myDATA, δοκιμάστε να το 	ξανακαταχωρήσετε πάλι
					 * σε λίγο (δεν ενημερώνουμε κατι στον mydt10)
					 */
					return array(
						'ok'	=> 0,
						'msg'	=> $_SESSION['peg_dic_einv_invoice_transmissionfailure_2']
					);
				}
				if(
					isset($resp['data']['einv03']['error_code'])
					&& $resp['data']['einv03']['error_code'] == 'mydata_sync_004'
				) {
					// Είχε επιχειρησιακο σφάλμα
					$update = array(
						'auth_cd'	=> '',
						'p30'		=> $resp['data']['einv03']['error_message']

					);
					pegasus_mysql_update(
						'mydt10',
						array_keys($update),
						array_values($update),
						'nr01 = :nr01',
						0,1,1,
						array('nr01' => $mydt10['nr01'])
					);
					$msg = $_SESSION['peg_dic_einv_invoice_transmissionfailure_1']." " .$resp['data']['einv03']['error_message'];
					return array(
						'ok'	=> 0,
						'msg'	=> $msg
					);
				}
				elseif($resp['data']['transmissionFailure'] == 2) {
					/**
					 * Το παραστατικό δεν έχει ενημερώσει το myDATA λόγω απώλειας
					 * σύνδεσης με το myDATA, δοκιμάστε να το ξανακαταχωρήσετε πάλι
					 * σε λίγο (δεν ενημερώνουμε κατι στον mydt10)
					 */
					return array(
						'ok'	=> 0,
						'msg'	=> $_SESSION['peg_dic_einv_invoice_transmissionfailure_2']
					);
				}
				elseif($resp['data']['transmissionFailure'] == 0 || $resp['data']['transmissionFailure'] == 1) {
					/**
					 * Το παραστατικό έχει σήμανση (ενημερώνουμε mydt10 με uid, mark, auth_code)
					 */
					$update = array(
						"uid"		=> $resp['data']['uid'],
						"mark"		=> $resp['data']['mark'],
						"auth_cd"	=> $resp['data']['authcode'],
						"p011"		=> $resp['data']['p011'],
						"p012"		=> $resp['data']['p012'],
						'p04'		=> '',
						'p30'		=> ''
					);
					pegasus_mysql_update(
						'mydt10',
						array_keys($update),
						array_values($update),
						'nr01 = :nr01',
						0,1,1,
						array(
							'nr01' => $mydt10['nr01']
						)
					);
					return array(
						'ok'	=> 1,
						'msg'	=> $_SESSION['peg_dic_einv_invoice_has_authcd_2']
					);
				}		
			}
			else {
				// Happy Case:
				$ret_arr['ok']  = 1;
				$ret_arr['msg'] = $_SESSION['peg_dic_einv_invoice_has_authcd'];
			}
		}elseif(
			$ret_arr['einv'] == 3
			&& $mydt10['nr01'] > 0 
			&& $mydt10['tr_fail'] == 2
		) {
			//* (3) ΙΛΥΔΑ
			$ret_arr = einv02_send($mydt10['nr01']);
			$ret_arr['einv'] = 3;
		}
		// Αν έχει καταχωρηθεί και έχει επιστρέψει transition fail 2 και έχει επιχειρησιακό σφάλμα  τότε άπλα επιστρέφουμε το error
		// Εxoυμε κανει το auth_cd = ''
		elseif(
			empty($mydt10['auth_cd'])
			&& $mydt10['nr01'] > 0 
			&& $mydt10['tr_fail'] == 2
		) {
			/**
			 * Το παραστατικό δεν έχει ενημερώσει το myDATA λόγω απώλειας
			 * σύνδεσης με το myDATA, δοκιμάστε να το ξανακαταχωρήσετε πάλι
			 * σε λίγο (δεν ενημερώνουμε κατι στον mydt10)
			 */
			$msg = $_SESSION['peg_dic_einv_invoice_transmissionfailure_1']." " .$mydt10['p30'];
			return array(
				'ok'	=> 0,
				'msg'	=> $msg
			);
		} 
		elseif ($mydt10['p02'] == 1) {
			$ret_arr['ok']  = 1;
			$ret_arr['msg'] = $_SESSION['peg_dic_einv_invoice_is_closed']; // Αν έχει φύγει με myDATA να μην ξαναφύγει με ηλεκτρονική.

		} else {
			//προσθλεσαμε το t01 γιατί από το estiasi οταν πληρωνόμαστε πολλαπλά παραστατικά
			//δημιουργούμε t01 με τον κώδικα καρφωτά
			if($tbl!='t01'){
				if($mydt10['nr01'] > 0 ){
					//Αφού θα ξαναστείλω το παραστατικό διαγράφω το mydt10. 
					//Αυτό το κάνουμε γιατί π.χ. θέλω να ξαναυπολογιστεί το pnr01 αν αλλάξω αριθμό παραστατικού
					pegasus_mysql_delete('mydt10', 'nr01=:mydt10_nr01',   1, array('mydt10_nr01' => $mydt10['nr01']));
					pegasus_mysql_delete('mydt11', 'mydt10=:mydt10_nr01', 1, array('mydt10_nr01' => $mydt10['nr01']));
					pegasus_mysql_delete('mydt12', 'mydt10=:mydt10_nr01', 1, array('mydt10_nr01' => $mydt10['nr01']));	
				}

				$mydt_mydt10 = new mydt_mydt10($tbl, $tbl_nr01);
				//* (1)

				// Σετ την παράμετρο για ξεχωριστές συνοπτικές γραμμές ανά είδος.
				$mydt_mydt10->set_mydt00_p105(1);

				$mydt_mydt10->execute_update();
			}
			if($ret_arr['einv'] == 1){
				einv_checkConnectedAuth($mydt10['nr01']);
			}

			pegasus_mysql_use("SELECT * FROM mydt10 WHERE tbl = :tbl AND tbl_nr01 =:tbl_nr01;", $mydt10, array('tbl' => $tbl, 'tbl_nr01' => $tbl_nr01));
			if ($mydt10['nr01'] > 0) { // Έλεγχος αν δημιουργήθηκε
				//* (2β - 1)



				// Aν εχει λαθος
				if (!empty($mydt10['p04'])) {
					//! Αν έχει δημιουργηθεί mydt10 με σφάλματα
					$ret_arr['ok']   = 0;
					$ret_arr['msg']  = mydt_mydt10::find_errors_descriptions($mydt10['p04']);


				} else {
					//* (2β - 2)
					//* Update einv και p02_1 μετά την execute_update διότι μιλάμε κυρίως για νέες εγγραφές - Αυτό είπαμε ΙΣΩΣ χρειαστεί να το ξαναδούμε.
					$arr1 = array();								$arr2 = array();
					if($ret_arr['einv'] == 3){
						array_push($arr1, 'einv');						array_push($arr2, 3);
					}
					else{
						array_push($arr1, 'einv');						array_push($arr2, 1);
					}
					array_push($arr1, 'einv_nr');					array_push($arr2, $einv01); // Στοιχεία Ηλ. Τιμολόγησης που θα χρησιμοποιήσει στην αποστολή.
	
					if($transmission_failure == 1) {
						array_push($arr1, 'tr_fail');	array_push($arr2, 1);
					}
					
					pegasus_mysql_update('mydt10', $arr1, $arr2, "tbl = :tbl and tbl_nr01 = :tbl_nr01", 0, 1, 1, array('tbl' => $tbl, 'tbl_nr01' => $tbl_nr01));

					if($ret_arr['einv'] == 3){
						//* (3) ΙΛΥΔΑ
						$ret_arr = einv02_send($mydt10['nr01']);
						$ret_arr['einv'] = 3;
					}
					else{
						//* (3) Pegasus
						$ret_arr = einv_send($mydt10['nr01']);
						$ret_arr['einv'] = 1;
						// Βλέπε -> *Σημειώσεις για einv_send* στο κάτω μέρος
					}


					if($ret_arr['ok'] == 1 ){ //οκ = 1 με errors
						//ελεγχος αν υπαρχουν παραστατικα που δεν εχουν σταλει
						$pendings = einv_find_pendings();
						if(!empty($pendings)){
							$ret_arr['pendings'] = $pendings;
						}
					}
				}



			} else {
				$ret_arr['ok']  = 0;
				$ret_arr['msg'] = $_SESSION['peg_dic_einv_mydt10_record_not_created'];

				if(in_array($tbl, array('a55','a56'))){
					if(pegasus_mysql_printfld($tbl, 'pweb01', 'nr01=:nr01', array('nr01' => $tbl_nr01))==1){
						$ret_arr['msg'] = '';	
					}
				}
			}
		}

		if(pegasus_module_exists('dc00')  &&  pegasus_mysql_table_exists('dc0003') && function_exists('dc00_send_dc0003')){

			//Συνδεση με ψηφιακο πελατολογιο
			if($ret_arr['ok']==1){
				$dc_ret_array = dc00_send_dc0003($mydt10['nr01']);
				if(!empty($dc_ret_array['succeed'])){
					$ret_arr['msg'] .= '<br>'.$dc_ret_array['succeed'];
				}
				if(!empty($dc_ret_array['failed'])){
					$ret_arr['msg'] .= '<br>'.$dc_ret_array['failed'];
				}
				//Εμφανιζω μηνυμα για ολοκληρωση, να δουμε αν θα γινει για 1 μονο η για ολα 
				$ret_arr['dc0001_arr'] = $dc_ret_array['dc0001_arr'];
			}
		}

	} catch (Exception $e) {
		$ret_arr['ok']  = 0;
		$ret_arr['msg'] = $e->getMessage();
	}
	return $ret_arr;
}
/*  *Σημειώσεις για einv_send*
	Η einv_send θα επικοινωνεί με το service και στην απάντηση που θα λαμβάνει θα ενημερώνει τα δεδομένα που επιστρέφει το myDATA

	Σε περίπτωση επιτυχίας το service επιστρέφει ολόκληρο το παραστατικό και τις γραμμές του, με ενημερωμένα τα δεδομένα myDATA
	-- δεδομένα myDATA = uid, mark, auth_code

	Εναλλακτικά μπορεί να προκύψει error, είτε από service (π.χ. Το παραστατικό έχει ξανασταλεί) είτε από το myData
	Σε όλες τις περιπτώσεις έχουμε μηνύματα σφάλματος για τις περιπτώσεις του service και αν έχει προκύψει από myDATA, επιστρέφουμε επιπλέον και το σφάλμα του myDATA
	Σε κάθε περίπτωση θα πρέπει να συμπληρώνονται τα αντίστοιχα πεδία

	p31     -> Mήνυμα από myDATA (στην αποστολή) -----> Εδώ την απάντηση από το service, θα πρέπει να φτιάξουμε κάπως τα μηνύματα από το service και τα μηνύματα από το myDATA.
	auth_cd -> Authorization Code   ---->  Μας το επιστρέφει το myDATA στην επιτυχία
	uid     -> Αναγνωριστικό Παραστατικού ----> Μας το επιστρέφει το myDATA στην επιτυχία
	mark    -> Μοναδικός Αριθμός (ΜΑΡΚ) ---->  Μας το επιστρέφει το myDATA στην επιτυχία
*/

/**
 * Βρίσκει και συμπληρώνει τα ΜΑΡΚ των συσχετιζόμενων παραστατικών (correlinv) από τα pegasus ids (pcor)
 * Είναι ίδια με την _checkCorrelated του mydt
 * Εκτελείται πριν τη δημιουργία του mydt10 array που θα σταλεί στο service.
 * 
 * @param int $mydt10_nr01
 *
 * @return mixed
 */
 function einv_checkCorrelated($mydt10_nr01){
	pegasus_mysql_use("select * from mydt10 where mydt10.nr01=:mydt10_nr01;", $mydt10, array('mydt10_nr01' => $mydt10_nr01));
	$pcorArray = explode('#' ,$mydt10['pcor']);
	
	$i=0;
	$pcorSQL = '';
	$pcorSQLParams = array();
	foreach( $pcorArray as $pcor){

		//elegxei an to sysxetizomeno parastatiko exei eggrafi sto q31 allios dne to symperilambanei sto metriti
		$has_q31=true;
		if( $mydt10['tbl']=='a55' ){
			$a55p05= pegasus_mysql_printfld( 'a55' , 'p05' , 'nr01=:nr01' ,array('nr01'=> $pcor));
			$count = pegasus_mysql_printfld( 'q31' , 'count(*)' , 'q31.p01 IN (620014, 620068) and  q31.p03=:q31_p03', array('q31_p03'=> $a55p05) );
			if(!($count>0)){
				$has_q31=false;
			}
		}

		if( $mydt10['tbl']=='a56'){
			//12-01-2023
			$a56p05 = pegasus_mysql_printfld( 'a56' , 'p05' , 'nr01=:nr01' , array('nr01' => $pcor));
			$count  = pegasus_mysql_printfld( 'q31' , 'count(*)' , 'q31.p01 IN (620017, 620069) and q31.p03=:q31_p03', array('q31_p03' => $a56p05) );
			if(!($count>0)){
				$has_q31=false;
			}
		}

		if( $mydt10['tbl']=='t08'){
			$t08p05 = pegasus_mysql_printfld( 't08' , 'p05' , 'nr01=:nr01' , array('nr01' => $pcor));
			$count  = pegasus_mysql_printfld( 'q31' , 'count(*)' , 'q31.p01=620019 and q31.p03=:q31_p03', array('q31_p03' => $t08p05) );
			if(!($count>0)){
				$has_q31=false;
			}
		}

		if(!empty($pcor) and !array_search($pcor,$pcorSQLParams,true) and $has_q31 ){
			if(!empty($pcorSQL)){
				$pcorSQL .= ' , ';
			}
			$pcorSQL .= ':pcorre_' . $i; 
			$pcorSQLParams['pcorre_' . $i] =$pcor ; 

			$i++;
		}
	}

	// Έλεγχος !empty γιατί αν μπει εδώ μέσα χωρίς pcor θα χτυπήσει η sql παρακάτω.
	if(!empty($pcorSQL)) {
		$ii=0;

		if($mydt10['tbl'] == 'a56') {
			//12-01-2023
			$query = "select 
						mydt10.mark ,
						mydt50.p103 as mydt50_p103 
					from mydt10 
					join mydt50 on mydt50.p00=mydt10.invtype 
						where /*mydt10.mark!='' and*/ mydt10.tbl='a56' and mydt10.tbl_nr01 in (".$pcorSQL.");";
		}elseif($mydt10['tbl'] == 't08'){
			$query = "select 
						mydt10.mark ,
						mydt50.p103 as mydt50_p103 
					from mydt10 
					join mydt50 on mydt50.p00=mydt10.invtype 
						where /*mydt10.mark!='' and*/ mydt10.tbl='t08' and mydt10.tbl_nr01 in (".$pcorSQL.");";
		}else{
			$query = "select 
						mydt10.mark ,
						mydt50.p103 as mydt50_p103 
					from mydt10 
					join mydt50 on mydt50.p00=mydt10.invtype 
						where /*mydt10.mark!='' and*/ mydt10.tbl='a55' and mydt10.tbl_nr01 in (".$pcorSQL.");";
		}
		$res = pegasus_query($query, $pcorSQLParams);
		// $res = pegasus_query( "select 
		// 						mydt10.mark ,
		// 						mydt50.p103 as mydt50_p103 
		// 					from mydt10 
		// 					join mydt50 on mydt50.p00=mydt10.invtype 
		// 						where /*mydt10.mark!='' and*/ mydt10.tbl='a55' and mydt10.tbl_nr01 in (".$pcorSQL.");", $pcorSQLParams);

		//echo pegasus_replace_values_in_sql("select * from mydt10 where mydt10.mark!='' and mydt10.tbl='a55' and mydt10.tbl_nr01 in (".$pcorSQL.");" ,$pcorSQLParams);
		while($mydt10_00 = pegasus_fetch_assoc( $res)){

			if($mydt10_00['mydt50_p103']==0){
				$i--;
			}

			if($mydt10_00['mark']!='' && $mydt10_00['mydt50_p103']==1){
				if(!empty($correlinv)){
					$correlinv .= ',';
				}
				$correlinv .= $mydt10_00['mark'];
				$ii++;    
			}
		}

		if($i!==$ii){
			$p04 = $mydt10['p04'];
			if(empty($p04)){
				$p04 .= '#4#';
			}else{
				$p04 .= '4#';
			}
			pegasus_mysql_update('mydt10' , array('p04') , array( $p04 ) , 'nr01=:nr01' , 0 , 1 , 1 ,  array('nr01'=>$mydt10_nr01));
		}

		if($i===$ii and $i>0){

			$p04 = $mydt10['p04'];
			if($p04 == '#4#'){
				$p04 = '';
			}else{
				$p04 = str_replace('4#' ,'' ,$p04) ;
			}
			pegasus_mysql_update('mydt10' , array('correlinv','p04') , array($correlinv,$p04) , 'nr01=:nr01' , 0 , 1 , 1 ,  array('nr01'=>$mydt10_nr01));
			return $correlinv;
		}
	}

	return false;
}
/**
 * Κοινή συνάρτηση για τις ηλεκτρονικές
 * Ελέγχει αν το παραστατικό έχει εκδοθεί Χ ώρα πριν την προσπάθεια αποστολής
 * Αν την ξεπερνά, επιστρέφει οκ 0.
 * Χρησιμοποίεται στον έλεγχο αποστολής παραστατικό στον πάροχο για να επιλέξει ο χρήστης αν θέλει να το στείλει με transmission_failure
 */
function einv00_check_for_tran_failure($tbl, $tbl_nr01) {
	// p01 / p014 = Ημερομηνία
	// p02 / p017 = Ώρα

	$valid_tbls = array('a55', 'a56', 't08', 'tran01', 'a60', 'tran09');
	if(!in_array($tbl, $valid_tbls)) {
		return array(
			'ok'	=> 1,
			'msg'	=> ''
		);
	}
	/**
	 * Παραστατικά Πελάτων
	 */
	$query = "	SELECT a55.nr01
				FROM a55
				LEFT JOIN mydt10 ON mydt10.tbl = 'a55' AND mydt10.tbl_nr01 = a55.nr01
				WHERE 1 = 1 
				AND a55.nr01 = :tbl_nr01
				AND (   
					-- Έχει αποσταλεί και είναι σε κατάσταση με transmission fail 2
					mydt10.tr_fail = 2
					-- Ή Δεν είναι σε αναμονή και έχει καταχωρηθεί έως 2 λεπτά πριν
					OR (
						-- Δεν είναι σε αναμονή
						a55.pweb01 = 0
						-- Η ημερομηνία / ώρα του παραστατικού είναι μεγαλύτερη η ίση από πριν από (:date_time πλην) 2 λεπτά
						AND STR_TO_DATE(
							CONCAT(
								CAST(IFNULL(a55.p01,'0100-01-01') AS DATE),
								' ',
								CAST(IFNULL(a55.p02,'00:00:00') AS TIME)
							),
							'%Y-%m-%d %H:%i:%s'
						) >= CAST(:date_time AS DATETIME) - INTERVAL 2 MINUTE
					)
				)
	";
	/**
	 * Παραστατικά Προμηθευτών
	 */
	if($tbl == 'a56') {
		$query = "	SELECT a56.nr01
					FROM a56
					LEFT JOIN mydt10 ON mydt10.tbl = 'a56' AND mydt10.tbl_nr01 = a56.nr01
					WHERE 1 = 1
					AND a56.nr01 = :tbl_nr01
					AND (
						-- Έχει αποσταλεί και είναι σε κατάσταση με transmission fail 2
						mydt10.tr_fail = 2
						-- Ή Δεν είναι σε αναμονή και έχει καταχωρηθεί έως 2 λεπτά πριν
						OR (
							-- Δεν είναι σε αναμονή
							a56.pweb01 = 0
							-- Η ημερομηνία / ώρα του παραστατικού είναι μεγαλύτερη η ίση από πριν από (:date_time πλην) 2 λεπτά
							AND STR_TO_DATE(
								CONCAT(
									CAST(IFNULL(a56.p01,'0100-01-01') AS DATE),
									' ',
									CAST(IFNULL(a56.p02,'00:00:00') AS TIME)
								),
								'%Y-%m-%d %H:%i:%s'
							) >= CAST(:date_time AS DATETIME) - INTERVAL 2 MINUTE
						)
					)
		";
	}
	/**
	 * Φορτωτικές
	 */
	if($tbl == 'tran01') {
		$query = "	SELECT tran01.nr01
					FROM tran01
					LEFT JOIN mydt10 ON mydt10.tbl = 'tran01' AND mydt10.tbl_nr01 = tran01.nr01
					WHERE 1 = 1
					AND tran01.nr01 = :tbl_nr01
					AND (
						-- Έχει αποσταλεί και είναι σε κατάσταση με transmission fail 2
						mydt10.tr_fail = 2
						-- Ή έχει καταχωρηθεί έως 2 λεπτά πριν
						OR (
							-- Η ημερομηνία / ώρα του παραστατικού είναι μεγαλύτερη η ίση από πριν από (:date_time πλην) 2 λεπτά
							STR_TO_DATE(
								CONCAT(
									CAST(IFNULL(tran01.p014,'0100-01-01') AS DATE),
									' ',
									CAST(IFNULL(tran01.p017,'00:00:00') AS TIME)
								),
								'%Y-%m-%d %H:%i:%s'
							) >= CAST(:date_time AS DATETIME) - INTERVAL 2 MINUTE
						)
					)
		";
	}
	/**
	 * Αποδείξεις
	 */
	if($tbl == 't08') {
		$query = "	SELECT t08.nr01 AS nr01
					FROM t08
					LEFT JOIN mydt10 ON mydt10.tbl = 't08' AND mydt10.tbl_nr01 = t08.nr01
					WHERE 1 = 1
					AND t08.nr01 = :tbl_nr01
					AND (
						-- Έχει αποσταλεί και είναι σε κατάσταση με transmission fail 2
						mydt10.tr_fail = 2
						-- Ή έχει καταχωρηθεί έως 2 λεπτά πριν
						OR (
							-- Η ημερομηνία / ώρα του παραστατικού είναι μεγαλύτερη η ίση από πριν από (:date_time πλην) 2 λεπτά
							STR_TO_DATE(
								CONCAT(
									CAST(IFNULL(t08.p01,'0100-01-01') AS DATE),
									' ',
									CAST(IFNULL(t08.p02,'00:00:00') AS TIME)
								),
								'%Y-%m-%d %H:%i:%s'
							) >= CAST(:date_time AS DATETIME) - INTERVAL 2 MINUTE
						)
					)
		";
	}
	/**
	 * Παραστατικά Εσωτερικής Διακίνησης
	 */
	if($tbl == 'a60') {
		$query = "	SELECT a60.nr01 AS nr01
					FROM a60
					LEFT JOIN mydt10 ON mydt10.tbl = 'a60' AND mydt10.tbl_nr01 = a60.nr01
					WHERE 1 = 1
					AND a60.nr01 = :tbl_nr01
					AND (
						-- Έχει αποσταλεί και είναι σε κατάσταση με transmission fail 2
						mydt10.tr_fail = 2
						-- Ή έχει καταχωρηθεί έως 2 λεπτά πριν
						OR (
							-- Η ημερομηνία / ώρα του παραστατικού είναι μεγαλύτερη η ίση από πριν από (:date_time πλην) 2 λεπτά
							STR_TO_DATE(
								CONCAT(
									CAST(IFNULL(a60.p01,'0100-01-01') AS DATE),
									' ',
									CAST(IFNULL(a60.p02,'00:00:00') AS TIME)
								),
								'%Y-%m-%d %H:%i:%s'
							) >= CAST(:date_time AS DATETIME) - INTERVAL 2 MINUTE
						)								
					)		
		";
	}
	/**
	 * Δελτία Αποστολής Φορτωτικών
	 */
	if($tbl == 'tran09') {
		$query = "	SELECT tran09.nr01
					FROM tran09
					LEFT JOIN mydt10 ON mydt10.tbl = 'tran09' AND mydt10.tbl_nr01 = tran09.nr01
					WHERE 1 = 1
					AND tran09.nr01 = :tbl_nr01
					AND (
						-- Έχει αποσταλεί και είναι σε κατάσταση με transmission fail 2
						mydt10.tr_fail = 2
						-- Ή έχει καταχωρηθεί έως 1 ημέρα πριν
						OR (
							-- Η ημερομηνία του παραστατικού είναι μεγαλύτερη η ίση από πριν από (:date_time πλην) 1 ημέρα
							STR_TO_DATE(
								CONCAT(
									CAST(IFNULL(tran09.p02,'0100-01-01') AS DATE),
									' 00:00:00'
								),
								'%Y-%m-%d %H:%i:%s'
							) >= CAST(:date_time AS DATETIME) - INTERVAL 1 DAY
						)
					)
		";
	}
	$queryParams = array(
		'tbl_nr01' 	=> $tbl_nr01,
		'date_time'	=> date('Y-m-d H:i:00')
	);
	$res = pegasus_query($query, $queryParams);
	$rs  = pegasus_fetch_assoc($res);

	//Το query μου φέρνει αποτελέσματα όταν το παραστατικό έχει κοπεί σε διάστημα 2 λεπτών, άρα μπορεί να ξαναφύγει χωρίς tr_fail
	if($rs['nr01'] > 0) {
		return array(
			'ok'	=> 1,
			'msg'	=> '',
		);
	}

	$res_mydt10 = array();
	$query_mydt10 = "SELECT mydt10.series, mydt10.aa FROM mydt10 WHERE tbl = :tbl and tbl_nr01 = :tbl_nr01";

	pegasus_mysql_use($query_mydt10, $res_mydt10, array('tbl' => $tbl, 'tbl_nr01' => $tbl_nr01));
	
	$ret_arr = array(
		'ok'	=> 0,
		'msg'	=> str_replace("#invoice#", ($res_mydt10['series'].$res_mydt10['aa']), $_SESSION['peg_dic_einv_invoice_transmission_failure_prompt'])
	);

	if(in_array($tbl, array('a55','a56'))){
		//Έλεγχος Παραστατικού Σε Αναμονη
		if(pegasus_mysql_printfld($tbl, 'pweb01', 'nr01=:nr01', array('nr01' => $tbl_nr01))==1){
			$ret_arr['msg'] = '';	
		}
	}

	return $ret_arr;
	
}
function einv_send_payment_signature($t19_nr01) {

    //* t19 record
    pegasus_mysql_use("SELECT * FROM t19 WHERE nr01 = :t19_nr01", $t19, array("t19_nr01" => $t19_nr01));
    //* pos00_04 record
    // pegasus_mysql_use("SELECT * FROM pos00_04 WHERE nr01 = :pos00_04_nr01", $pos00_04, array("pos00_04_nr01" => $t19['pos00_04']));
    //* mydt10 record
    pegasus_mysql_use("SELECT * FROM mydt10 WHERE tbl = :tbl AND tbl_nr01 = :tbl_nr01", $mydt10, array("tbl" => $t19['tbl'], "tbl_nr01" => $t19["tbl_nr01"]));

	// print_r($t19);

    if($t19['akyr'] == 1) {
		$einv_nr = $mydt10['einv_nr'];
		if($mydt10['einv']==51 && pegasus_module_exists('einv03')){
			//Έλεγχος αν προκειται για Ηλεκτρονική Τιμολόγηση από Τοπικό[51]
			$einv_nr = einv03_get_settings_from_fem012($mydt10['einv_nr']);
		}
		
		if(empty($mydt10["nr01"])){ //Στην περίπτωση ταυτόχρονης πληρωμής Δεν έχω καθόλου mydt10
			$einv_nr = einv00_check_settings( $t19['tbl'], $t19["tbl_nr01"]);
		}
		
        $ret = einv_get_cancel_signature($einv_nr, $t19['p_sign'], $t19['akyr_msg']);
        //? Also update pos00_04 with cancel?
    }elseif(
            $t19['pay_am'] > 0
        &&  !empty($t19['tid'])
        &&  !empty($t19['p_sign'])
        &&  !empty($mydt10['nr01'])
        //&& αν χρειάζομαι κάτι επιπλέον
    ){
        //*create mydt13 --> Δημιουργεί το mydt13
        $arr1 = array();               $arr2 = array();
        
        array_push($arr1, 'mydt10');   array_push($arr2, $mydt10['nr01']);
        array_push($arr1, 'type');     array_push($arr2, '7'); //? Καρφώνω 7, μιλάμε για POS, αν θέλουμε να το βρίσκουμε, το αλλάζουμε
        array_push($arr1, 'tid');      array_push($arr2, $t19['tid']);
        array_push($arr1, 'amount');   array_push($arr2, $t19['pay_am']);
        array_push($arr1, 'amount_t'); array_push($arr2, $t19['tip_am']);
        array_push($arr1, 'tbl');      array_push($arr2, 't19');  
        array_push($arr1, 'tbl_nr01'); array_push($arr2, $t19_nr01); 

		$mydt13_nr01 = pegasus_mysql_printfld('mydt13', 'nr01', 'p_sign = :p_sign AND mydt10=:mydt10', array('p_sign' => $t19['p_sign'],'mydt10' => $mydt10['nr01']));
		if($mydt13_nr01>0){
			pegasus_mysql_update('mydt13', $arr1, $arr2 , 'nr01= :nr01' ,0 ,1 , 1 , array('nr01' => $mydt13_nr01 ));
		}else{
			$mydt13_nr01 = pegasus_mysql_newrec('mydt13');
			array_push($arr1, 'nr01');     array_push($arr2, $mydt13_nr01);
			array_push($arr1, 'p_sign');   array_push($arr2, $t19['p_sign']);
        	pegasus_mysql_insert('mydt13', $arr1, $arr2);
		}

        $ret = einv_update_invoice($mydt13_nr01);

		//* 22/01/2024 - Αβραάμ
		//* Θα ενημερώνω τις εγγραφές του mydt13 που μπορώ να βρώ, θα ελέγχω με type, amount, p_sign
		//* 23/01/2024 - Αβραάμ
		//* Έγιναν οι αλλαγές των πεδίων σύμφωνα με το πως γυρνάνε πλέον από το service
		//* Signature -> p_sign
		//* Γυρνάει πλέον και p_info

		if($ret['ok'] == 1) {

			foreach($ret['data']['einv05'] as $payment) {
				//* Βρίσκω αν υπάρχει mydt13 με τα ίδια type, amount, p_sign
				$mydt13_nr01 = pegasus_mysql_printfld('mydt13', 'nr01', 'type = :type AND amount = :amount AND p_sign = :p_sign AND mydt10=:mydt10', 
					array(	
						'amount' => $payment['amount'],
						'type' 	 => $payment['type'],
						'p_sign' => $payment['p_sign'],
						'mydt10' => $mydt10['nr01']
					)
				);
				if(!empty($mydt13_nr01)) {
					$arr1 = array(); 				$arr2 = array();
					array_push($arr1, 'mark');  	array_push($arr2, $ret['data']['paymentMethodMark']);
					array_push($arr1, 'p_info');  	array_push($arr2, $payment['p_info']);
					array_push($arr1, 'einv_dt');  	array_push($arr2, date("Y-m-d"));
					array_push($arr1, 'einv_tm');  	array_push($arr2, date("H:i"));

					pegasus_mysql_update('mydt13', $arr1, $arr2, 'nr01 = :nr01', 0, 1, 1, array('nr01' => $mydt13_nr01));
				}	
			}
		}

        //* Αν η καταχώρηση έγινε επιτυχώς, να γυρνάει ένα flag π.χ. ok η send_payment
        //* Θα μπορούσε να γίνεται update και μεσα στην einv_update_invoice.
        //? Εκτός από mydt13 ενημερώνουμε κάτι και στον t19 όταν στέλνουμε την πληρωμή; Δεν θυμάμαι
    }

    return $ret;
}
function einv_create_payment_signature(
	$issuedate, 
	$is_vat, 
	$is_branch, 
	$invtype, 
	$series, 
	$aa, 
	$mark, 
	$tnetvalue,  
	$tvat_am, 
	$tgross_val, 
	$amount, 
	$tidnsp, 
	$tbl, 
	$tbl_nr01,
	$pnr01,
	$einv01_nr01=0,
	$pos_protocol='') {
   /**
    * Να φτιάξουμε πιθανούς ελέγχους
    */

	/**
	 * Αν δεν έχει "Στοιχεία Σύνδεσης Ηλ. Τιμολόγησης" (einv01_nr01) προσπαθούμε να τα βρούμε με την
	 * einv00_check_settings.
	 */
	if(empty($einv01_nr01)) {
		$einv01_nr01 = einv00_check_settings($tbl, $tbl_nr01);
	}
	/**
	 * Αν δεν βρεθούν τα στοιχεία σύνδεσης ηλεκτρονικής τιμολόγησης επιστρέφουμε μήνυμα λάθους.
	 */
	if(empty($einv01_nr01)) {
		return array(
            'ok'        => 0,
			'msg'   	=> $_SESSION['peg_dic_einv_credentials_not_found_err1']
        );
	}
	/**
	 * To payload (signature) που θα σταλεί στο service για την δημιουργία της υπογραφής πληρωμής.
	 */
	$signature = array(
		"issue_date"			=> $issuedate, 
		"issuer_vat" 			=> $is_vat, 
		"issuer_branch" 		=> $is_branch, 
		"invtype" 				=> $invtype, 
		"series" 				=> $series, 
		"aa" 					=> $aa, 
		"mark" 					=> $mark, 
		"amount" 				=> number_format($amount, 2, '.', ''),
		"invoice_net_value" 	=> number_format($tnetvalue, 2, '.', ''),
		"invoice_vat_value" 	=> number_format($tvat_am, 2, '.', ''),
		"invoice_total_value"	=> number_format($tgross_val, 2, '.', ''),
		"tidnsp" 				=> $tidnsp,
		"pos_protocol" 			=> $pos_protocol
	);
	/**
	 * Στοιχεία σύνδεσης ηλεκτρονικής τιμολόγησης 
	*/
	$einv01 = array();
	pegasus_mysql_use("SELECT * FROM einv01 WHERE nr01 = :nr01", $einv01, array('nr01' => $einv01_nr01));
	/**
	 * CURL POST Request στο e-invoicing
	*/
	$einv_service_call_post_resp = einv_service_call_post('create-payment-signature', $einv01, $signature);
	$log = $einv_service_call_post_resp['log'];
	$log['attributes']['pnr01'] = $pnr01;
	$log['attributes']['pos_protocol'] = $pos_protocol;
	if($einv_service_call_post_resp['ok'] != 1) {
		$code = 'einv:einv_create_payment_signature:curl';
		$msg = $einv_service_call_post_resp['msg'];
		einv_external_logging(true, $code, $msg, $log);
		einv_einv90_logging($einv01,'create-payment-signature',$log['request'],$msg);
		return array(
			'ok'        => 0,
			'code'      => 'response_error',
			'msg'   	=>  $msg
		);
	}
	$response = json_decode($einv_service_call_post_resp['data']['response'], true);
	if(!is_array($response)) {
		$code = 'einv_create_payment_signature:json';
		$msg = json_last_error_msg();
		einv_external_logging(true, $code, $msg, $log);
		einv_einv90_logging($einv01, 'create-payment-signature', $log['request'], $msg. "\n". $log['response']);
		return array(
			'ok'        => 0,
			'code'      => 'response_error',
			'msg'   	=>  $msg
		);
	}
    if(
        $einv_service_call_post_resp['data']['http_code'] >= 400
        || $response['ok'] != 1
    ) {
        if($einv_service_call_post_resp['data']['http_code'] == 401) {
            $errors = array(array(
                'code'      => 'unauthorized',
                'message'   => $_SESSION['peg_dic_einv_invalid_token_err1']
            ));
        } else {
            $errors = $response['error']['data'];
        }
		if(empty($errors)) {
			if(isset($response['code'])) {
				$errors[] = array(
					'code'		=> $response['code'],
					'message'	=> $response['error']['title']
				);
			}else {
				$errors[] = array(
					'code'		=> 'unknown',
					'message'	=> 'Unknown Error'
				);
			}
		}
		$log_error_messages = array();
		foreach ($errors as $error) {
			$log_error_messages[] = $error['message'].(empty($error['code']) ? '' : ' ('.$error['code'].')');
		}
		$msg = implode(', ', $log_error_messages);
		$code = 'einv:einv_create_payment_signature:error';
		einv_external_logging(true, $code, $msg, $log);
		einv_einv90_logging($einv01,'create-payment-signature',$log['request'],$response);
        return array(
            'ok'	=> 0,
            'code'	=> 'service_error',
			'msg'	=> $msg
        );
    }
	$log['attributes']['p_sign'] = $response['data']['p_sign'];
	$code = 'einv:einv_create_payment_signature:success';
	$msg = 'Επιτυχής Δημιουργία υπογραφής πληρωμής';
	einv_external_logging(false, $code, $msg, $log, $response);
	einv_einv90_logging($einv01,'create-payment-signature',$log['request'],$response);
    return array(
        'ok'    => 1,
        'data'  => $response['data']
    );
}
function einv_get_cancel_signature($einv01_nr01 = 0, $p_sign = '',  $canceled_msg = '') {
	$einv01 = array();
	pegasus_mysql_use("SELECT * FROM einv01 WHERE nr01 = :nr01", $einv01, array('nr01' => $einv01_nr01));
	$body = array(
		'p_sign'        => $p_sign,
		'canceled_msg'  => $canceled_msg
	);
	$einv_service_call_post_resp = einv_service_call_post('cancel-payment-signature', $einv01, $body);
	$log = $einv_service_call_post_resp['log'];
	$log['attributes']['p_sign'] = $p_sign;
	/**
	 * CURL Exception
	 */
	if($einv_service_call_post_resp['ok'] != 1) {
		$code = 'einv:einv_get_cancel_signature:curl';
		$msg = $einv_service_call_post_resp['msg'];
		einv_external_logging(true, $code, $msg, $log);
		einv_einv90_logging($einv01,'cancel-payment-signature',$log['request'],$msg);
		return array(
            'ok'        => 0,
            'code'      => 'response_error',
			'msg'   	=>  $msg
        );
	}
	$service_response = json_decode($einv_service_call_post_resp['data']['response'], true);
	if(!is_array($service_response)) {
		$code = 'einv:einv_get_cancel_signature:json';
		$msg = json_last_error_msg();
		einv_external_logging(true, $code, $msg, $log);
		einv_einv90_logging($einv01,'cancel-payment-signature', $log['request'], $msg. "\n". $log['response']);
        return array(
            'ok'        => 0,
            'code'      => 'response_error',
			'msg'   	=>  $msg
        );
	}
    if(
        $einv_service_call_post_resp['data']['http_code'] >= 400
        || $service_response['ok'] != 1
    ) {
        if($einv_service_call_post_resp['data']['http_code'] == 401) {
            $errors = array(array(
                'code'      => 'unauthorized',
                'message'   => $_SESSION['peg_dic_einv_invalid_token_err1']
            ));
        } else {
            $errors = $service_response['error']['data'];
        }
		if(empty($errors)) {
			if(isset($service_response['code'])) {
				$errors[] = array(
					'code'		=> $service_response['code'],
					'message'	=> $service_response['error']['title']
				);
			}else {
				$errors[] = array(
					'code'		=> 'unknown',
					'message'	=> 'Unknown Error'
				);
			}
		}
		$log_messages = array();
		foreach ($errors as $error) {
			$log_messages[] = $error['message'].(empty($error['code']) ? '' : ' ('.$error['code'].')');
		}
		$msg = implode(', ', $log_messages);
		$code = 'einv:einv_get_cancel_signature:error';
		einv_external_logging(true, $code, $msg, $log,$service_response);
		einv_einv90_logging($einv01,'cancel-payment-signature',$log['request'],$service_response);
		return array(
			'ok'		=> 0,
			'code'		=> 'service_error',
			'msg'		=> $msg
		);
    }
	$code = 'einv:einv_get_cancel_signature:success';
	$msg = 'Επιτυχής Ακύρωση υπογραφής πληρωμής';
	einv_external_logging(false, $code, $msg, $log, $service_response);
	einv_einv90_logging($einv01,'cancel-payment-signature',$log['request'],$service_response);
    return array(
        'ok'    => 1,
        'data'  => $service_response['data']
    );
}
function einv_update_invoice($mydt13_nr01 = 0) {
    $sql = "    SELECT
					mydt10.pnr01 	as mydt10_pnr01,
					mydt10.einv 	as mydt10_einv,
					mydt10.einv_nr	as mydt10_einv_nr,
                    mydt13.*
                FROM mydt13
                LEFT JOIN mydt10 ON mydt10.nr01 = mydt13.mydt10
                WHERE 1 = 1
                AND mydt13.nr01 = :nr01
    ";
    pegasus_mysql_use($sql, $mydt13, array('nr01' => $mydt13_nr01));

    if(empty($mydt13)) {
        return array(
            'ok'    => 0,
            'msg'   => str_replace('##mydt13_nr01##', $mydt13_nr01, $_SESSION['peg_dic_einv_mydt13_not_exists_err1'])
        );
    }

	if($mydt13['mydt10_einv']==51 && pegasus_module_exists('einv03')){
		//Έλεγχος αν προκειται για Ηλεκτρονική Τιμολόγηση από Τοπικό[51]
		$einv01_nr01 = einv03_get_settings_from_fem012($mydt13['mydt10_einv_nr']);
	}else{
		$einv01_nr01 = $mydt13['mydt10_einv_nr'];
	}
	$einv01 = array();
	pegasus_mysql_use("SELECT * FROM einv01 WHERE nr01 = :nr01", $einv01, array('nr01' => $einv01_nr01));
	$body = array(
        "amount"    => $mydt13['amount'],
        "amount_t"  => $mydt13['amount_t'],
        "type"      => $mydt13['type'],
        "p_sign"    => $mydt13['p_sign'],
        "tid"       => $mydt13['tid']
    );
	$einv_service_call_post_resp = einv_service_call_post('invoice-update', $einv01, $body);
	$log = $einv_service_call_post_resp['log'];
	$log['attributes']['p_sign'] = $mydt13['p_sign'];
	$log['attributes']['pnr01'] = $mydt13['mydt10_pnr01'];
	/**
	 * CURL Exception
	 */
	if($einv_service_call_post_resp['ok'] != 1) {
		$code = 'einv:einv_update_invoice:curl';
		$msg = $einv_service_call_post_resp['msg'];
		einv_external_logging(true, $code, $msg, $log);
		einv_einv90_logging($einv01,'invoice-update',$log['request'],$msg);
		return array(
            'ok'        => 0,
            'code'      => 'response_error',
			'msg'   	=>  $msg
        );
	}
	$service_response = json_decode($einv_service_call_post_resp['data']['response'], true);
	if(!is_array($service_response)) {
		$code = 'einv:einv_update_invoice:json';
		$msg = json_last_error_msg();
		einv_external_logging(true, $code, $msg, $log);
		einv_einv90_logging($einv01, 'invoice-update', $log['request'], $msg. "\n". $log['response']);
        return array(
            'ok'        => 0,
            'code'      => 'response_error',
			'msg'   	=>  $msg
        );
	}
    // Service Error
    if(
        $einv_service_call_post_resp['data']['http_code'] >= 400
        || $service_response['ok'] != 1
    ) {
		// Η υπογραφή αυτή έχει καταχωρηθεί ήδη για αυτό το παραστατικό
		if(
			isset($service_response['code'])
			&& $service_response['code'] == 'update_invoice_data_009'
		) {
			$update = array(
				'einv_dt'	=> $service_response['error']['data']['p011'],
				'einv_tm'	=> $service_response['error']['data']['p012']
			);
			pegasus_mysql_update(
				'mydt13',
				array_keys($update),
				array_values($update),
				'nr01 = :nr01',
				0,1,1,
				array('nr01' => $mydt13['nr01'])
			);
			// Η πληρωμή βρέθηκε καταχωρημένη στο παραστατικό και το παραστατικό έχει διαβιβαστεί (##datetime##). Η ημερομηνία και ώρα διαβίβασης της πληρωμής ενημερώθηκαν. 
			$msg = str_replace(
				"##datetime##",
				peg_dateToStr("{$service_response['error']['data']['p011']} {$service_response['error']['data']['p012']}",'d/m/Y H:i:s'),
				$_SESSION['peg_dic_einv_update_invoice_data_009']
			);
			$code = 'einv:einv_update_invoice:error:update_invoice_data_009';
			einv_external_logging(true, $code, $msg, $log, $service_response);
			einv_einv90_logging($einv01,'invoice-update',$log['request'],$service_response);
			return array(
				'ok'        => 0,
				'code'      => 'update_invoice_data_009',
				'msg' 		=> $msg
			);
		}
		$error_code = 'unknown';
		$error_message = 'Unknown Error';
        if($einv_service_call_post_resp['data']['http_code'] == 401) {
			$error_code = 'unauthorized';
			$error_message = $_SESSION['peg_dic_einv_invalid_token_err1'];
        } else {
			$error_code = $service_response['code']??$error_code;
			$error_message = $service_response['error']['message']??$error_message;
        }
		$msg = "{$error_message} ({$error_code})";
		$code = 'einv:einv_update_invoice:error';
		einv_external_logging(true, $code, $msg, $log);
		einv_einv90_logging($einv01,'invoice-update',$log['request'],$service_response);
		if($error_code == 'payments_sync_011') {
			$msg = $_SESSION['peg_dic_einv_payments_sync_011'];
		}
		return array(
			'ok'        => 0,
			'code'      => 'service_error',
			'msg' 		=> $msg
		);
    }
	
	$code = 'einv:einv_update_invoice:success';
	$msg = 'Επιτυχής ενημέρωση παραστατικού με πληρωμή';
	einv_external_logging(false, $code, $msg, $log,$service_response);
	einv_einv90_logging($einv01,'invoice-update',$log['request'],$service_response);
    return array(
        'ok'    => 1,
        'data'  => $service_response['data']
    );
}
/**
 * Καταχωρεί εγγραφές log στον einv90 αν είναι ενεργή η καταγραφή για αυτά τα στοιχεία σύνδεσης και καταχωρεί 
 * εγγραφές log στο datadog αν είναι ενεργή η κεντρική αποστολή συμβάντων από τις βασικές παραμέτρους εφαρμογής.
 * 
 * @deprecated v1r146
 * 
 * @param  string  $url					Το URL του service που κλήθηκε
 * @param  string  $code				Ο κωδικός λάθους για το  datadog
 * @param  string  $pnr01				Το mydt10.pnr01 του παραστατικού αναφοράς (αν υπάρχει)
 * @param  string  $p_sign				Το mydt13.p_sign της υπογραφής / πληρωμής αναφοράς  (αν υπάρχει)
 * @param  integer $einv01_nr01			Στοιχεία σύνδεσης Ηλ. Τιμολόγησης με e-invoicing.pegcloud.io
 * @param  string  $title				Το message για το datadog και η περιγραφή για τον einv90
 * @param  string|array  $request		To Request σε string ή array
 * @param  string|array  $response		To Response σε string ή array
 * @param  boolean $is_error			Αν πρόκειται για log εγγραφή για error (datadog) 
 * @return void
 */
function einv_add_to_log(
	$url,
	$code,
	$pnr01,
	$p_sign, //auth_code
	$einv01_nr01 = 0,
	$title = '',
	$request = '',
	$response = '',
	$pos_protocol = '',
	$is_error = true, 
	$type = 'einv') {
	// Αν είναι ενεργοποιημένη η ενημέρωση logs επικοινωνίας για τα επιλεγμένα στοιχεία ηλεκτρονικής τιμολόγησης.
	if(
		$einv01_nr01 > 0
		&& pegasus_mysql_printfld('einv01', 'comm_logs', 'nr01 = ?', array($einv01_nr01)) == 1
	) {
		$einv90_request = $request;
		if(is_array($request)) {
			$einv90_request = print_r($request,true);
		}
		$einv90_response = $response;
		if(is_array($response)) {
			$einv90_response = print_r($response,true);
		}
		$insert = array(
			'nr01'	=> pegasus_mysql_newrec('einv90'),
			'dt'	=> date('Y-m-d'),
			'tm'	=> date('H:i'),
			'p01'	=> $title,
			'p30'	=> $einv90_request,
			'p31'	=> $einv90_response, 
			'type'  => $type
		);
		pegasus_mysql_insert(
			'einv90', 
			array_keys($insert), 
			array_values($insert)
		);
	}
	$attributes = array(
		'service-host' => $url,
		'host' => $_SERVER['SERVER_NAME'],
		'pnr01' => $pnr01,
		'p_sign' => $p_sign,
		'pos_protocol' => $pos_protocol
	);
	core00_external_logging::send(
		$is_error?1:0,
		"einv:$code",
		$_SESSION['username'],
		$request,
		$response,
		$title,
		$attributes
	);
	
}
/**
 * Προσθήκη / Ενημέρωση εγγραφής στον πίνακα einv20
 * 
 * Ε:10001831 Δ:10271622
 * Δεν προσθέτουμε εγγραφή αν το is_b2g (v_b2g01_is_b2g το b2g01.is_b2g) είναι 0.
 * Ενημερώνουμε πάντα αν υπάρχει υφιστάμενη εγγραφή.
 *
 * @return void
 */
function einv_insert_update_einv20_from_variable_fields($tbl, $tbl_nr01) {
	global $PegInput;

	$PegInput->addVar(new peg_input_number('v_b2g01_is_b2g', 'request'));
	$is_b2g = $PegInput->getRequest('v_b2g01_is_b2g');

	//Επειδή δεν ξέρω αν μπορεί να τρέξει από κάπου η συνάρτηση χωρίς να έχουν γίνει αυτά init, δεν θέλω να προχωρήσω πιο κάτω, π.χ. να μην κάνω delete
	//Στην pegInput αν ένα numeric δεν υπάρχει στο request, τότε γυρνάει null
	if ($is_b2g === null) {
		return;
	}

	$PegInput->addVar(new peg_input_alphanumeric('v_einv20_payterm'));
	$PegInput->addVar(new peg_input_alphanumeric('v_einv20_invnotescode'));
	$PegInput->addVar(new peg_input_alphanumeric('v_einv20_invnote'));
	$einv20 = array(
		'tbl'			=> $tbl,
		'tbl_nr01'		=> $tbl_nr01,
		'payterm'		=> $PegInput->getRequest('v_einv20_payterm'),
		'invnotescode'	=> $PegInput->getRequest('v_einv20_invnotescode'),
		'invnote'		=> $PegInput->getRequest('v_einv20_invnote')
	);
	$existing_nr01 = pegasus_mysql_printfld('einv20', 'nr01', 'tbl = :tbl AND tbl_nr01 = :tbl_nr01', array('tbl' => $einv20['tbl'], 'tbl_nr01' => $einv20['tbl_nr01']));

	if ($existing_nr01 > 0 && $is_b2g == 0) {
		pegasus_mysql_delete('einv20', 'tbl = :tbl AND tbl_nr01 = :tbl_nr01', 1, array('tbl' => $einv20['tbl'], 'tbl_nr01' => $einv20['tbl_nr01']));
	} else if ($existing_nr01 > 0 && $is_b2g == 1) {
		pegasus_mysql_update('einv20', array_keys($einv20), array_values($einv20), 'nr01 = :nr01', 0, 1, 1, array('nr01' => $existing_nr01));
	} else if (!($existing_nr01 > 0) && $is_b2g == 1) {
		$einv20['nr01'] = pegasus_mysql_newrec('einv20');
		pegasus_mysql_insert('einv20', array_keys($einv20), array_values($einv20));
	}

}
/**
 * Αρχικοποίηση των αντίστοιχων πεδίων του array data από τον πίνακα  einv20.
 * Προσοχή! Τα αντίστοιχα πεδία πρέπει να υπάρχουν ως variable πεδία στην αντίστοιχη οθόνη.
 *
 * @param  string $tbl
 * @param  array &$data
 * @return void
 */
function einv_update_data_einv20_fields($tbl,&$data) {
	global $PegInput;
	$PegInput->addVar(new peg_input_number('rec_copy_nr01'));
	$rec_copy_nr01 = $PegInput->getRequest('rec_copy_nr01');
	$data['v_einv20_tbl'] = $tbl;
	$data['v_einv20_tbl_nr01'] = $data['nr01'];
	$einv20 = array();
	$existing_einv20_nr01 = $rec_copy_nr01 > 0 ? $rec_copy_nr01 :$data['v_einv20_tbl_nr01'];
	pegasus_mysql_use("SELECT * FROM einv20 WHERE tbl= :tbl AND tbl_nr01= :tbl_nr01", $einv20, array('tbl' => $data['v_einv20_tbl'], 'tbl_nr01' => $existing_einv20_nr01));
	if(!empty($einv20)) {
		$data['v_einv20_payterm'] = $einv20['payterm'];
		$data['v_einv20_invnotescode'] = $einv20['invnotescode'];
		$data['v_einv20_invnote'] = $einv20['invnote'];
	}
}
function einv_download_table($table_name){
    pegasus_mysql_use("SELECT * from cor000 where nr01=1;",$cor000);

	$tesae_user  = $cor000['tesae_user'];
    $tesae_pass  = $cor000['tesae_pass'];
        
    try {
        $resp = pegasus_curl_request('https://services00.pegcloud.io/is_alive.php', false, array(), array(CURLOPT_TIMEOUT => 4));
    } catch (Exception $ex) {
        $resp = false;
    }

    if (!empty($resp) and  $resp == 'true') {
        $url = "https://services00.pegcloud.io/services01/execute.php";
    } else {
        $url = "https://services.tesae.gr/services01/execute.php";
    }
    
    $params = array(
        'action'    => 'login',
        'user'        => $tesae_user,
        'pass'        => $tesae_pass,
        'un'        => 1
    );
    $resp = pegasus_curl_request_post($url, $params);
    $xml = simplexml_load_string($resp);

	if ($xml->code == '100') {

		$params = array();
		switch ($table_name) {
			case 'einv50':
				$params['action'] = 'getApi400';
				break;
			case 'einv51':
				$params['action'] = 'getApi401';
				break;
		}
		$ret_xml = pegasus_curl_request_post($url, $params);
        $xml_obj = simplexml_load_string($ret_xml, "SimpleXMLElement", LIBXML_NOCDATA);
        /**
         * Στο mydata χρησιμοποιούμε διαφορετικά tags ανάλογα τον πίνακα π.χ (mydt65) records->record, (mydt59) mus->mu
         * Κρατάω παρόμοια λογική και εδώ
        */
        switch ($table_name){
            case 'einv50':
				$records = $xml_obj->mus->mu;
				break;
			case 'einv51':
                $records = $xml_obj->records->record;
				break;
        }
        einv_UploadDatatoDB($table_name, $records);
	}
}
function einv_UploadDatatoDB($table_name, $records ) {
    //Delete alla data
    pegasus_mysql_delete($table_name ,'nr01>0');
    //Find Tables Fields
    $res  = pegasus_query("SELECT * FROM INFORMATION_SCHEMA.columns WHERE table_schema = ? AND table_name = ?   ;",array(constant('DB_NAME'),$table_name));
    $table_fields = pegasus_fetchall($res);

    foreach( $records  as $record){
        // var_dump($record);
        $array_fields = array(); $array_values = array();
        // $res= pegasus_query("SELECT * FROM INFORMATION_SCHEMA.columns WHERE table_schema = ? AND table_name = ?   ;",array(DB_NAME,$table_name));
        foreach($table_fields as $fields){
            if(isset($record->{ $fields['COLUMN_NAME'] })){
                array_push($array_fields, $fields['COLUMN_NAME'] ); array_push($array_values, $record->{ $fields['COLUMN_NAME'] } );
            }
        }
        pegasus_mysql_insert($table_name , $array_fields , $array_values);
    }
}
/**
 * Δημιουργεί έναν κωδικό αρχικοποίησης (init_code) για την αρχικοποίηση της διαδικασίας εξουσιοδότησης.
 *
 * Αυτή η συνάρτηση καλεί την υπηρεσία "initiate-authorization" για να δημιουργήσει έναν κωδικό αρχικοποίησης
 * (init_code) και μια διεύθυνση URL για ανακατεύθυνση (redirect URL). Ο κωδικός αρχικοποίησης χρησιμοποιείται
 * στη συνέχεια για τη δημιουργία API tokens (access και refresh token).
 *
 * @param string $nr01 Το μοναδικό αναγνωριστικό του χρήστη (π.χ., ID χρήστη).
 * @param string $p02 Το όνομα του API token.
 * @param string $container_id Το einv01_d container_id για την αποθήκευση των δεδομένων σε globalVar.
 * @return array Επιστρέφει έναν πίνακα με τα εξής στοιχεία:
 *               - 'ok': 1 αν η κλήση ήταν επιτυχής, 0 αν υπήρξε σφάλμα.
 *               - 'data': Πίνακας με την διεύθυνση URL για ανακατεύθυνση.
 */
function einv_einv01_d_create_init_code($nr01, $p02, $container_id)
{
	$redirect_url = (empty($_SERVER['HTTPS']) ? 'http' : 'https') . "://{$_SERVER['HTTP_HOST']}{$_SERVER['REQUEST_URI']}";
	$redirect_url = str_replace("einv_einv01_d_create_init_code.php", "einv_einv01_d_create_init_code_resp.php", $redirect_url);
	$redirect_url = $redirect_url . "?container_id={$container_id}";

	$api_token_name = "WebApp:" . pegasus_get_app_sn() . ":{$p02}";

	$params = array(
		'api_token_name' => $api_token_name,
		'redirect_url'   => $redirect_url
	);

	list($service_host, $service_url) = einv_get_service_url('initiate-authorization', $params);

	$pegasus_curl_request_resp = pegasus_curl_request($service_url);

	$response = json_decode($pegasus_curl_request_resp, true);

	if ($response['ok'] != 1) {
		return array(
			'ok'  => 0,
			'msg' => $_SESSION['peg_dic_einv21_d_error']
		);
	}

	$einv01_p11 = pegasus_mysql_printfld('einv01', 'p11', 'nr01 = :nr01', array('nr01' => $nr01));

	pegasusSetGlobalVar(
		"{$container_id}_einv_einv01_d_create_init_code",
		array(
			'init_code'  => $response['data']['init_code'],
			'einv01_p11' => $einv01_p11,
			'einv01_nr01' => $nr01
		)
	);

	$data = array(
		'url' => $response['data']['url'],
	);

	return array(
		'ok'   => 1,
		'data' => $data
	);
}
/**
 * Δημιουργεί ένα νέο API token (access και refresh token) χρησιμοποιώντας έναν κωδικό αρχικοποίησης.
 *
 * Αυτή η συνάρτηση καλεί την υπηρεσία "get-token" για να δημιουργήσει ένα νέο API token
 * (access και refresh token) χρησιμοποιώντας έναν κωδικό αρχικοποίησης (`init_code`).
 * Αν η κλήση είναι επιτυχής, επιστρέφει τα tokens. Αν αποτύχει, επιστρέφει το αντίστοιχο μήνυμα λάθους.
 *
 * @param string $parent_container_id Το einv01_d container_id.
 * @return array Επιστρέφει έναν πίνακα με τα εξής στοιχεία:
 *               - 'ok': 1 αν η κλήση ήταν επιτυχής, 0 αν υπήρξε σφάλμα.
 *               - 'data': Πίνακας με τα tokens (access και refresh token) αν η κλήση ήταν επιτυχής.
 *               - 'msg': Μήνυμα επιτυχίας ή σφάλματος.
 */
function einv_einv021_d_create_api_token($parent_container_id)
{
	$global_var_data = pegasusGetGlobalVar("{$parent_container_id}_einv_einv01_d_create_init_code");

	list($service_host, $service_url) = einv_get_service_url('get-token', array());

	$body = array(
		'init_code' => $global_var_data['init_code']
	);

	$pegasus_curl_request_post_resp = pegasus_curl_request_post($service_url, $body);

	$response = json_decode($pegasus_curl_request_post_resp, true);

	if (!is_array($response)) {
		return array(
			'ok'  => 0,
			'msg' => $_SESSION['peg_dic_einv21_d_error']
		);
	}

	if ($response['ok'] != 1) {
		$message = $_SESSION['peg_dic_einv21_d_error'];

		if ($response['code'] == 'authorization_get_token_error_2') {
			$message = $_SESSION['peg_dic_einv21_d_error_timeout'];
		}

		return array(
			'ok'  => 0,
			'msg' => $message
		);
	}
	$data = array(
		'p11' => $response['data']['access'],
		'p12' => $response['data']['refresh']
	);
	//
	list($service_host, $service_url) = einv_get_service_url('user-info', array());
	$headers = array("Authorization:Bearer {$data['p11']}");
	$pegasus_curl_request_post_resp = pegasus_curl_request($service_url,false, $headers);
	$response = json_decode($pegasus_curl_request_post_resp, true);
	if (is_array($response)) {
		if(isset($response['data']['username'])) {
			$data['p00'] = $response['data']['username'];
		}
	}
	//

	return array(
		'ok'   => 1,
		'data' => $data,
		'msg'  => $_SESSION['peg_dic_einv21_d_success']
	);
}
/**
 * Δημιουργεί το URL για την κλήση της υπηρεσίας ηλεκτρονικής τιμολόγησης.
 *
 * Αυτή η συνάρτηση δημιουργεί το πλήρες URL για την κλήση μιας υπηρεσίας της ηλεκτρονικής τιμολόγησης,
 * λαμβάνοντας υπόψη τις παραμέτρους του χρήστη.
 *
 * @param string $service_name Το όνομα της υπηρεσίας που θα καλεστεί.
 * @param array $params Πίνακας με τις παραμέτρους που θα προστεθούν στο URL.
 * @return array Επιστρέφει έναν πίνακα με δύο στοιχεία:
 *               - Το host της υπηρεσίας.
 *               - Το πλήρες URL της υπηρεσίας, συμπεριλαμβανομένων των παραμέτρων.
 */
function einv_get_service_url($service_name = '', $params = array())
{
	$service_host = "https://e-invoicing-user-api.pegcloud.io";
	if (!empty($_SESSION['cor011_einv_user_api_url'])) {
		$service_host = $_SESSION['cor011_einv_user_api_url'];
		$service_host = rtrim($service_host, '/'); // Αφαιρεί το τελικό "/" αν υπάρχει
		$service_host = str_replace('/invoice-data', '', $service_host); // Αφαιρεί το "/invoice-data" αν υπάρχει
	}
	$service_url = $service_host . "/$service_name";
	$params['lang'] = $_SESSION['lang'];
	$redirect_url = null;
	if(isset($params['redirect_url'])) {
		$redirect_url = $params['redirect_url'];
		unset($params['redirect_url']);
	}
	$service_url .= "?" . http_build_query($params);
	if(isset($redirect_url)) {
		$service_url .= "&redirect_url=$redirect_url";
	}
	return array($service_host, $service_url);
}
/**
 * Κάνει μια GET κλήση στην υπηρεσία ηλεκτρονικής τιμολόγησης και επιστρέφει την απάντηση.
 *
 * Αυτή η συνάρτηση καλεί την υπηρεσία ηλεκτρονικής τιμολόγησης μέσω HTTP GET και επιστρέφει την απάντηση.
 * Αν η κλήση επιστρέψει κωδικό 401 (Unauthorized) και η παράμετρος $retry_on_401 είναι true,
 * τότε γίνεται προσπάθεια ανανέωσης του token και επαναλαμβάνεται η κλήση.
 *
 * @param string $service_name Το όνομα της υπηρεσίας που θα καλεστεί.
 * @param array $einv01 Πίνακας που περιέχει τα tokens για την αυθεντικοποίηση (p10 ή p11).
 * @param array $params Παράμετροι που θα προστεθούν στο URL της αίτησης.
 * @param bool $retry_on_401 Αν είναι true, γίνεται προσπάθεια ανανέωσης του token σε περίπτωση 401.
 * @return array Επιστρέφει έναν πίνακα με τα εξής στοιχεία:
 *               - 'ok': 1 αν η κλήση ήταν επιτυχής, 0 αν υπήρξε σφάλμα.
 *               - 'data': Η απάντηση από την υπηρεσία.
 *               - 'log': Πληροφορίες για την αίτηση και την απάντηση.
 */
function einv_service_call_get($service_name = '', $einv01 = array(), $params = array(), $retry_on_401 = true)
{
	list($service_host, $service_url) = einv_get_service_url($service_name, $params);
	$headers = array("Authorization:Bearer " . (empty($einv01['p11']) ? $einv01['p10'] : $einv01['p11']));
	$options = array(CURLOPT_SSL_VERIFYPEER => false);
	$log = array(
		'request' => array(
			'url'       => $service_url,
			'headers'   => $headers
		),
		'attributes' => array(
			'service-host'  => $service_host,
			'host'         => $_SERVER['SERVER_NAME']
		)
	);
	$pegasus_curl_request_resp = array();
	try {
		$pegasus_curl_request_resp = pegasus_curl_request($service_url, false, $headers, $options, true);
		if ($pegasus_curl_request_resp['http_code'] == 401 && $retry_on_401) {
			if (einv_service_refresh_token($einv01)) {
				return einv_service_call_get($service_name, $einv01, $params, false);
			}
			/**
			 * Αν έχουμε αποτυχία αυθεντικοποίησης με p10 (παλιό token).
			 */
			if(empty($einv01['p11']) && !empty($einv01['p10'])) {
				$code = 'einv:einv_service_call_post:p10_401';
				einv_external_logging(true, $code, "Αποτυχία αυθεντικοποίησης με p10 (παλιό token).", $log);
				einv_einv90_logging($einv01,'authentication',$log['request'],$_SESSION['peg_dic_einv_authentication_p10_401']);
			}
		}
	} catch(Exception $e) {
		$msg = $e->getMessage(). ' (' . $e->getCode() . ')';
		return array(
			'ok'    => 0,
			'code'  => $e->getCode(),
			'msg'   => $msg,
			'log'   => $log
		);
	}
	$log['response'] = $pegasus_curl_request_resp;
	return array(
		'ok'    => 1,
		'data'  => $pegasus_curl_request_resp,
		'log'   => $log
	);
}
/**
 * Κάνει μια POST κλήση στην υπηρεσία ηλεκτρονικής τιμολόγησης και επιστρέφει την απάντηση.
 *
 * Αυτή η συνάρτηση καλεί την υπηρεσία ηλεκτρονικής τιμολόγησης μέσω HTTP POST και επιστρέφει την απάντηση.
 * Αν η κλήση επιστρέψει κωδικό 401 (Unauthorized) και η παράμετρος $retry_on_401 είναι true,
 * τότε γίνεται προσπάθεια ανανέωσης του token και επαναλαμβάνεται η κλήση.
 *
 * @param string $service_name Το όνομα της υπηρεσίας που θα καλεστεί.
 * @param array $einv01 Πίνακας που περιέχει τα tokens για την αυθεντικοποίηση (p10 ή p11).
 * @param array $body Το σώμα της αίτησης που θα σταλεί με την POST κλήση.
 * @param bool $retry_on_401 Αν είναι true, γίνεται προσπάθεια ανανέωσης του token σε περίπτωση 401.
 * @return array Επιστρέφει έναν πίνακα με τα εξής στοιχεία:
 *               - 'ok': 1 αν η κλήση ήταν επιτυχής, 0 αν υπήρξε σφάλμα.
 *               - 'data': Η απάντηση από την υπηρεσία.
 *               - 'log': Πληροφορίες για την αίτηση και την απάντηση.
 */
function einv_service_call_post($service_name = '', $einv01 = array(), $body = array(), $retry_on_401 = true)
{
	list($service_host, $service_url) = einv_get_service_url($service_name);
	$headers = array("Authorization:Bearer " . (empty($einv01['p11']) ? $einv01['p10'] : $einv01['p11']));
	$options = array(CURLOPT_SSL_VERIFYPEER => false);
	$log = array(
		'request' => array(
			'url'       => $service_url,
			'body'      => $body,
		),
		'attributes'    => array(
			'service-host'  => $service_host,
			'host'          => $_SERVER['SERVER_NAME']
		)
	);
	$pegasus_curl_request_post_resp = array();
	try {
		$pegasus_curl_request_post_resp = pegasus_curl_request_post($service_url, $body, true, $headers, $options, true);
		if ($pegasus_curl_request_post_resp['http_code'] == 401 && $retry_on_401) {
			if (einv_service_refresh_token($einv01)) {
				return einv_service_call_post($service_name, $einv01, $body, false);
			}
			/**
			 * Αν έχουμε αποτυχία αυθεντικοποίησης με p10 (παλιό token).
			 */
			if(empty($einv01['p11']) && !empty($einv01['p10'])) {
				$code = 'einv:einv_service_call_post:p10_401';
				einv_external_logging(true, $code, "Αποτυχία αυθεντικοποίησης με p10 (παλιό token).", $log);
				einv_einv90_logging($einv01,'authentication',$log['request'],$_SESSION['peg_dic_einv_authentication_p10_401']);
			}
		}
	} catch(Exception $e) {
		$msg = $e->getMessage(). ' (' . $e->getCode() . ')';
		return array(
			'ok'    => 0,
			'code'  => $e->getCode(),
			'msg'   => $msg,
			'log'   => $log
		);
	}
	$log['response'] = $pegasus_curl_request_post_resp;
	return array(
		'ok'    => 1,
		'data'  => $pegasus_curl_request_post_resp,
		'log'   => $log
	);
}
/**
 * Ανανεώνει το access token χρησιμοποιώντας το refresh token.
 *
 * Αυτή η συνάρτηση καλεί την υπηρεσία ανανέωσης token για να λάβει ένα νέο access token
 * χρησιμοποιώντας το refresh token που παρέχεται στον πίνακα $einv01. Αν η ανανέωση είναι επιτυχής,
 * το νέο access token αποθηκεύεται στη βάση δεδομένων και στον πίνακα $einv01.
 *
 * @param array $einv01 Πίνακας που περιέχει τα tokens και τα αναγνωριστικά του χρήστη.
 *                      - 'p12': Το refresh token.
 *                      - 'nr01': Το μοναδικό αναγνωριστικό του χρήστη.
 * @return bool Επιστρέφει true αν η ανανέωση ήταν επιτυχής, διαφορετικά false.
 */
function einv_service_refresh_token(&$einv01 = array())
{
	if (empty($einv01['p12'])) {
		// @todo: Προσθήκη log για missing refresh token
		return false;
	}

	list($service_host, $service_url) = einv_get_service_url('refresh-token');

	$body = array('refresh_token' => $einv01['p12']);

	$options = array(CURLOPT_SSL_VERIFYPEER => false);

	$log = array(
		'request' => array(
			'url'       => $service_url,
			'body'      => $body,
		),
		'attributes'    => array(
			'service-host'  => $service_host,
			'host'          => $_SERVER['SERVER_NAME']
		)
	);

	$pegasus_curl_request_post_resp = pegasus_curl_request_post($service_url, $body, true, array(), $options, true);

	$log['response'] = $pegasus_curl_request_post_resp['response'];
	if ($pegasus_curl_request_post_resp['http_code'] != 200) {
		// Αποτυχία ανανέωσης API Token: Το service επέστρεψε μη αναμενόμενο HHTP code
		$msg = $_SESSION['peg_dic_einv_refresh_token_error_1'];
		einv_external_logging(true,'einv:einv_service_refresh_token:http_code',$msg,$log);
		einv_einv90_logging($einv01,'refresh-token',array(),$msg);
		return false;
	}

	$doc = json_decode($pegasus_curl_request_post_resp['response'], true);

	if (!is_array($doc)) {
		$msg = $_SESSION['peg_dic_einv_refresh_token_error_2'];
		einv_external_logging(true,'einv:einv_service_refresh_token:json',$msg,$log);
		einv_einv90_logging($einv01,'refresh-token',array(),$msg);
		return false;
	}

	if ($doc['ok'] != 1) {
		// @todo: Προσθήκη log για μη επιτυχή απάντηση
		return false;
	}

	if (empty($doc['data']['access'])) {
		// Αποτυχία ανανέωσης API Token
		$msg = $_SESSION['peg_dic_einv_refresh_token_error_3'];
		einv_external_logging(true,'einv:einv_service_refresh_token:access',$msg,$log);
		einv_einv90_logging($einv01,'refresh-token',array(),$doc);
		return false;
	}
	$update = array(
		'p11' => $doc['data']['access'],
	);
	pegasus_mysql_update('einv01', array_keys($update), array_values($update), 'nr01 = :nr01', 0, 1, 1, array('nr01' => $einv01['nr01']));
	$einv01['p11'] = $doc['data']['access'];

	$msg = $_SESSION['peg_dic_einv_refresh_token_success'];
	einv_external_logging(false,'einv:einv_service_refresh_token:_success',$msg,$log);
	einv_einv90_logging($einv01,'refresh-token',array(),$doc);
	return true;
}
/**
 * Καταγράφει αιτήματα και αποκρίσεις εξωτερικών υπηρεσιών για σκοπούς αποσφαλμάτωσης ή παρακολούθησης.
 *
 * Αυτή η συνάρτηση είναι υπεύθυνη για την καταγραφή αιτημάτων και αποκρίσεων από εξωτερικές API (DataDog).
 * Αποκωδικοποιεί τα αιτήματα και τις αποκρίσεις αν είναι σε μορφή JSON και στη συνέχεια
 * στέλνει τα δεδομένα καταγραφής σε μια εξωτερική υπηρεσία καταγραφής.
 *
 * @param  boolean $error Δηλώνει αν η καταγραφή αφορά σφάλμα (true) ή όχι (false).
 * @param  string  $code Ένας προσαρμοσμένος κωδικός σφάλματος ή κατάστασης για καταγραφή.
 * @param  string  $msg Ένα προσαρμοσμένο μήνυμα για καταγραφή.
 * @param  array   $log Ένα array που περιέχει τα δεδομένα του αιτήματος και της απόκρισης.
 *                      Αναμενόμενες κλειδιά: 'request', 'response', 'attributes'.
 * @param  array   $overwrite_log_response Ένα προαιρετικός array για να αντικαταστήσει τα δεδομένα απόκρισης στην καταγραφή.
 * @return void
 */
function einv_external_logging($error = true, $code = '', $msg = '', $log = array(), $overwrite_log_response = array()) {
	if(!isset($log['response'])) {
    	$log['response'] = array();
	}
	if (!empty($overwrite_log_response)) {
        $log['response'] = $overwrite_log_response;
    }
    $t_req = is_array($log['request']) ? $log['request'] : json_decode($log['request'], true);
	$t_res = array();
	if(isset($log['response']['response'])){
		$t_res = (is_array($log['response']['response'])) ? $log['response']['response'] : json_decode($log['response']['response'], true);
	}
    if (is_array($t_req)) {
        $log['request'] = $t_req;
    }
    if (is_array($t_res) && !empty($t_res)) {
		if(isset( $log['response']['response'])) {
			$log['response']['response'] = $t_res;
		} else {
			$log['response'] = $t_res;
		}
    }
    core00_external_logging::send(
        $error,
        $code,
        $_SESSION['username'],
        $log['request'],
        $log['response'],
        $msg,
        $log['attributes']
    );
}
/**
 * Καταγράφει αιτήματα και αποκρίσεις σε μια βάση δεδομένων για σκοπούς παρακολούθησης.
 *
 * Αυτή η συνάρτηση καταγράφει τα δεδομένα ενός αιτήματος και της απόκρισής του στον πίνακα `einv90`
 * της βάσης δεδομένων, εφόσον η καταγραφή είναι ενεργοποιημένη (comm_logs = 1).
 * Αν τα δεδομένα του αιτήματος ή της απόκρισης είναι σε μορφή JSON, αποκωδικοποιούνται πρώτα.
 *
 * @param  array  $einv01 Ένας πίνακας που περιέχει ρυθμίσεις καταγραφής. 
 *                        Απαιτείται το  'einv01.comm_logs' για να ελεγχθεί αν η καταγραφή είναι ενεργοποιημένη.
 * @param  string $title  Ένας τίτλος που περιγράφει την καταγραφή.
 * @param  mixed  $request Τα δεδομένα του αιτήματος (array ή JSON string).
 * @param  mixed  $response Τα δεδομένα της απόκρισης (array ή JSON string).
 * @return void
 */
function einv_einv90_logging($einv01 = array(), $title = '', $request, $response) {
    if ($einv01['comm_logs'] != 1) {
        return;
    }
    $request = is_array($request) ? print_r($request, 1) : $request;
    $response = is_array($response) ? print_r($response, 1) : $response;
    $t_req = json_decode($request, true);
    // $t_res = json_decode($response['response'], true); 
	$t_res = (isset($response['response']) && is_string($response['response'])) ? json_decode($response['response'], true) : '';
    if (is_array($t_req)) {
        $request = $t_req;
    }
    if (is_array($t_res)) {
        $response['response'] = $t_res;
    }
    $insert = array(
        'nr01'  => pegasus_mysql_newrec('einv90'),
        'dt'    => date('Y-m-d'),
        'tm'    => date('H:i'), 
        'p01'   => $title,
        'p30'   => $request,
        'p31'   => $response,
        'type'  => 'einv'
    );
    pegasus_mysql_insert('einv90', array_keys($insert), array_values($insert));
}

/**
 * Ελεγχει αν τα παραστατικά έχουν auth_code και ενημερώνει το mconauth
 * @param int $mydt10_nr01
 *
 * @return mixed
 */
function einv_checkConnectedAuth($mydt10_nr01){
	pegasus_mysql_use("select * from mydt10 where mydt10.nr01=:mydt10_nr01;", $mydt10, array('mydt10_nr01' => $mydt10_nr01));
	$pconArray = explode(',' ,$mydt10['pmcon']); //,

	$i=0;
	$pconSQL = '';
	$pconSQLParams = array();
	foreach( $pconArray as $pcon){
		$has_q31=true; 
		if( $mydt10['tbl']=='a55' ){
			$a55p05= pegasus_mysql_printfld( 'a55' , 'p05' , 'nr01=:nr01' ,array('nr01'=> $pcon));
			$count = pegasus_mysql_printfld( 'q31' , 'count(*)' , 'q31.p01 IN (620014, 620068) and  q31.p03=:q31_p03', array('q31_p03'=> $a55p05) );
			if(!($count>0)){
				$has_q31=false;
			}
		}

		if( $mydt10['tbl']=='a56'){
			$a56p05 = pegasus_mysql_printfld( 'a56' , 'p05' , 'nr01=:nr01' , array('nr01' => $pcon));
			$count  = pegasus_mysql_printfld( 'q31' , 'count(*)' , 'q31.p01 IN (620017, 620069) and q31.p03=:q31_p03', array('q31_p03' => $a56p05) );
			if(!($count>0)){
				$has_q31=false;
			}
		}

		if( $mydt10['tbl']=='t08'){
			$t08p05 = pegasus_mysql_printfld( 't08' , 'p05' , 'nr01=:nr01' , array('nr01' => $pcon));
			$count  = pegasus_mysql_printfld( 'q31' , 'count(*)' , 'q31.p01=620019 and q31.p03=:q31_p03', array('q31_p03' => $t08p05) );
			if(!($count>0)){
				$has_q31=false;
			}
		}

		if( $mydt10['tbl']=='tran01'){
			$tran01 = pegasus_mysql_printfld( 'tran01' , 'p105' , 'nr01=:nr01' , array('nr01' => $pcon));
			$count  = pegasus_mysql_printfld( 'q31' , 'count(*)' , 'q31.p01=620075 and q31.p03=:q31_p03', array('q31_p03' => $tran01) );
			if(!($count>0)){
				$has_q31=false;
			}
		}

		if(!empty($pcon) and !array_search($pcon,$pconSQLParams,true) and $has_q31 ){
			if(!empty($pconSQL)){
				$pconSQL .= ' , ';
			}
			$pconSQL .= ':pcon_' . $i; 
			$pconSQLParams['pcon_' . $i] =$pcon ; 

			$i++;
		}
	}

	if(!empty($pconSQL)) {
		$ii=0;

		if($mydt10['tbl'] == 'a56') {
			//12-01-2023
			$query = "select 
						mydt10.auth_cd
					from mydt10 
					where mydt10.tbl='a56' and mydt10.tbl_nr01 in (".$pconSQL.");";
		}elseif($mydt10['tbl'] == 't08'){
			$query = "select 
						mydt10.auth_cd
					from mydt10 
						where mydt10.tbl='t08' and mydt10.tbl_nr01 in (".$pconSQL.");";
		}
		elseif($mydt10['tbl'] == 'tran01'){
			$query = "select 
						mydt10.auth_cd
					from mydt10 
						where mydt10.tbl='tran01' and mydt10.tbl_nr01 in (".$pconSQL.");";
		}else{ 
			$query = "select 
						mydt10.auth_cd
					from mydt10 
					where mydt10.tbl='a55' and mydt10.tbl_nr01 in (".$pconSQL.");";
		}

		$res = pegasus_query($query, $pconSQLParams);

		while($mydt10_00 = pegasus_fetch_assoc( $res)){

			if($mydt10_00['auth_cd']!=''){
				if(!empty($connected)){
					$connected .= ',';
				}
				$connected .= $mydt10_00['auth_cd'];
				$ii++;    
			}
		}


		if($i!==$ii){
			$p04 = $mydt10['p04'];
			if(empty($p04)){
				$p04 .= '#7#';
			}else{
				$p04 .= '7#';
			}
			pegasus_mysql_update('mydt10' , array('p04') , array( $p04 ) , 'nr01=:nr01' , 0 , 1 , 1 ,  array('nr01'=>$mydt10_nr01));
		}

		if($i===$ii and $i>0){

			$p04 = $mydt10['p04'];
			if($p04 == '#7#'){
				$p04 = '';
			}else{
				$p04 = str_replace('7#' ,'' ,$p04) ;
			}
			pegasus_mysql_update('mydt10' , array('p04') , array($p04) , 'nr01=:nr01' , 0 , 1 , 1 ,  array('nr01'=>$mydt10_nr01));
			return $connected;
		}
	}

	return false;
}

/**
 * Γίνεται ελεγχος αν υπαρχουν παραστατικά στο mydt10 για αποστολή με παροχο που 
 * εχουν mydt10.p04 in ('' , '#7#') και εχουν και auth_code=""
 *
 * @return array Τα tbl και tbl_nr01 order by issuedate, issuetime.
 */

 function einv_find_pendings() {

	$query = "SELECT tbl_nr01, tbl FROM mydt10 WHERE p04 IN ('', '#7#') AND auth_cd=''  AND einv = 1  AND p101 IN ('', 'customer_api_099') ORDER BY issuedate, issuetime"; 
	$res = pegasus_query($query);
	$mydt10_pend_arr = array();
	while($mydt10 = pegasus_fetch_assoc($res)){
		$mydt10_pend_arr[] = array('tbl' => $mydt10['tbl'] , 'tbl_nr01' => $mydt10['tbl_nr01']);
	}

	return $mydt10_pend_arr;

 }
 function einv_insert_or_update_mydt_from_einv($issue_date_from = '0100-01-01', $issue_date_to = '0100-01-01', $einv01_offset = 0, $page = 1, $counters = array()) {
	if(empty($counters)) {
		$counters = array(
			'einv01_get'	=> 0,
			'mydt10_exists'	=> 0,
			'mydt10_new'	=> 0
		);
	}
	$einv01 = array();
	pegasus_mysql_use("SELECT * FROM einv01 WHERE `type` = 'einv' ORDER BY remfdate, remftime LIMIT $einv01_offset,1 ",$einv01);
	if(empty($einv01)) {
		$msg = str_replace(array('#issue_date_from#', '#issue_date_to#', '#einv01_get#', '#mydt10_exists#', '#mydt10_new#'),
			array(peg_dateToStr($issue_date_from, 'd/m/Y'), peg_dateToStr($issue_date_to, 'd/m/Y'), $counters['einv01_get'], $counters['mydt10_exists'], $counters['mydt10_new']), $_SESSION['peg_dic_einv_insert_or_update_mydt_from_einv_info']);
		return array(
			'ok'	=> 1,
			'next'	=> 0,
			'msg'	=> $msg
		);
	}
	$params = array(
		'issuedatetime_from'	=> peg_dateToStr($issue_date_from, 'Y-m-d H:i:s'),
		'issuedatetime_to'		=> peg_dateToStr("$issue_date_to 23:59:59", 'Y-m-d H:i:s'),
		'page' 					=> $page,
		'lang' 					=> (strtolower($_SESSION['lang']) == 'en')? 'en': 'el',
	);
	$einv_service_call_get_resp = einv_service_call_get('get-issued-invoices', $einv01, $params);
	$log_resp = json_decode($einv_service_call_get_resp['data']['response'], true) !== false ? json_decode($einv_service_call_get_resp['data']['response'], true) : $einv_service_call_get_resp;
	einv_einv90_logging($einv01,'get-invoice-list',$params,$log_resp);
	if($einv_service_call_get_resp['data']['http_code'] == 401) {
		return array(
			'ok' => 1,
			'next' => 1,
			'data' => array(
				'issue_date_from'	=> $issue_date_from,
				'issue_date_to'		=> $issue_date_to,
				'einv01_offset'		=> $einv01_offset + 1,
				'page'				=> 1,
				'counters' 			=> $counters
			)
		);
	}
	if($einv_service_call_get_resp['ok'] == 0) {
		return array(
			'ok'	=> 0,
			'msg'	=> $einv_service_call_get_resp['msg']
		);
	}
	$service_data = json_decode($einv_service_call_get_resp['data']['response'],true);
	if(!is_array($service_data)) {
		return array(
			'ok' => 0,
			'msg' => json_last_error_msg()
		);
	}
	if($service_data['ok'] != 1) {
		$msg = $service_data['code'].(!empty($service_data['error']['message']) ? ': '.$service_data['msg'] : '');
		return array(
			'ok' => 0,
			'msg' => $msg
		);
	}
	if(empty($service_data['data']['invoices'])) {
		return array(
			'ok' => 1,
			'next' => 1,
			'data' => array(
				'issue_date_from'	=> $issue_date_from,
				'issue_date_to'		=> $issue_date_to,
				'einv01_offset'		=> $einv01_offset + 1,
				'page'				=> 1,
				'counters' 			=> $counters
			)
		);
	}
	$counters['einv01_get'] += count($service_data['data']['invoices']);
	foreach($service_data['data']['invoices'] as $invoice) {
		$mydt10 = array();
		pegasus_mysql_use('SELECT * FROM mydt10 WHERE auth_cd = :auth_cd', $mydt10, array('auth_cd' => $invoice['auth_code']));
		if(!empty($mydt10)) {
			$counters['mydt10_exists'] ++;
			if($mydt10['p09'] == 3) {
				einv_insert_or_update_mydt10_from_einv_invoice($einv01, $invoice, $mydt10['nr01']);
				einv_update_mydt11_and_mydt12_from_einv_invoice($mydt10['nr01'], $invoice);
			}
			continue;
		}
		$counters['mydt10_new'] ++;
		$mydt10_nr01 = einv_insert_or_update_mydt10_from_einv_invoice($einv01, $invoice);
		foreach($invoice['einv02'] as $invoice_lineitem) {
			einv_insert_or_update_mydt11_and_mydt12_from_einv_invoice_lineitem($mydt10_nr01, $invoice_lineitem);
		}
	}
	return array(
		'ok' => 1,
		'next' => 1,
		'data' => array(
			'issue_date_from'	=> $issue_date_from,
			'issue_date_to'		=> $issue_date_to,
			'einv01_offset'		=> $einv01_offset,
			'page'				=> $page + 1,
			'counters' 			=> $counters
		)
	);
 }
 function einv_update_mydt11_and_mydt12_from_einv_invoice($mydt10_nr01, $invoice) {
	$todel_string = '@2del@_' . date('Ymd') .  '_' . rand(0, 99999);
	pegasus_query("UPDATE mydt11 SET remguc = :remguc WHERE mydt10 = :mydt10_nr01", array('remguc' => $todel_string, 'mydt10_nr01' => $mydt10_nr01));
	pegasus_query("UPDATE mydt12 SET remguc = :remguc WHERE mydt10 = :mydt10_nr01", array('remguc' => $todel_string, 'mydt10_nr01' => $mydt10_nr01));
	foreach($invoice['einv02'] as $invoice_lineitem) {
		$values = array(
			'mydt10_nr01'	=> $mydt10_nr01,
			'quantity'		=> $invoice_lineitem['quantity'],
			'netvalue'		=> $invoice_lineitem['netvalue'],
			'fpavalue'		=> $invoice_lineitem['fpavalue'],
			'vatcat'		=> $invoice_lineitem['vatcat'],
			'remguc'		=> $todel_string,
		);
		$mydt11_nr01 = pegasus_mysql_printfld('mydt11', 'nr01', "mydt10 = :mydt10_nr01 AND quantity = :quantity AND netvalue = :netvalue AND fpavalue = :fpavalue AND vatcat = :vatcat AND remguc = :remguc", $values);
		$mydt12_nr01 = pegasus_mysql_printfld('mydt12', 'nr01', "mydt10 = :mydt10_nr01 AND quantity = :quantity AND netvalue = :netvalue AND fpavalue = :fpavalue AND vatcat = :vatcat AND remguc = :remguc", $values);
		if($mydt11_nr01 > 0 || $mydt12_nr01 > 0) {
			einv_insert_or_update_mydt11_and_mydt12_from_einv_invoice_lineitem($mydt10_nr01, $invoice_lineitem, $mydt11_nr01, $mydt12_nr01);
			continue;
		}
		einv_insert_or_update_mydt11_and_mydt12_from_einv_invoice_lineitem($mydt10_nr01, $invoice_lineitem);
	}
	pegasus_mysql_delete('mydt11', 'mydt10 = :mydt10 AND remguc = :remguc',0, array('mydt10' => $mydt10_nr01, 'remguc' => $todel_string));
	pegasus_mysql_delete('mydt12', 'mydt10 = :mydt10 AND remguc = :remguc',0, array('mydt10' => $mydt10_nr01, 'remguc' => $todel_string));
 }
 function einv_insert_or_update_mydt11_and_mydt12_from_einv_invoice_lineitem($mydt10_nr01, $invoice_lineitem, $mydt11_nr01 = 0, $mydt12_nr01 = 0) {
	$mydt_11_12 = array(
		'mydt10'		=> $mydt10_nr01,
		//'tbl'													// Πίνακας
		//'tbl_nr01'											// ΜΚ Πίνακα
		'p104'			=> $invoice_lineitem['p104'],			// 1/2=Εσοδο/Εξοδο
		'linenumber'	=> $invoice_lineitem['linenumber'],		// ΑΑ Γραμμής
		'linerel'		=> $invoice_lineitem['linerel'],		// ΑΑ Αντίστοιχης Γραμμής
		'itemcode'		=> $invoice_lineitem['itemcode'],		// Κωδικός Είδους
		'mydt57_p00'	=> $invoice_lineitem['mydt57_p00'],		// Χαρακτηρισμός Εσόδου
		'mydt58_p00'	=> $invoice_lineitem['mydt58_p00'],		// Χαρακτηρισμός Εξόδου
		'mydt61_p00'	=> $invoice_lineitem['mydt61_p00'],		// Χαρακτηρισμός Ε3 Εσοδου
		'mydt62_p00'	=> $invoice_lineitem['mydt62_p00'],		// Χαρακτηρισμός Ε3 Εξόδου
		'rectype'		=> $invoice_lineitem['rectype'],		// Τύπος γραμμής
		'mydt62_p01'	=> $invoice_lineitem['mydt62_p01'],		// Χαρακτηρισμός Ε3 ΦΠΑ Εξόδου
		'quantity'		=> $invoice_lineitem['quantity'],		// Ποσότητα
		'munit'			=> $invoice_lineitem['munit'],			// Μοναδα Μέτρησης
		'omunit'		=> $invoice_lineitem['omunit'],			// Πλήθος Μονάδας Μέτρησης Τεμάχια Άλλα
		'omuntl'		=> $invoice_lineitem['omuntl'],			// Τίτλος Μονάδας Μέτρησης Τεμάχια Άλλα
		'invdtype'		=> $invoice_lineitem['invdtype'],		// Επισήμανση
		'fuelcode'		=> $invoice_lineitem['fuelcode'],		// Κωδικός Καυσίμου
		'netvalue'		=> $invoice_lineitem['netvalue'],		// Καθαρή Αξία
		'vatcat'		=> $invoice_lineitem['vatcat'],			// Κατηγορια ΦΠΑ
		'vatexcat'		=> $invoice_lineitem['vatexcat'],		// Κατηγoρία Εξαίρεσης ΦΠΑ
		'fpavalue'		=> $invoice_lineitem['fpavalue'],		// Αξία ΦΠΑ
		'appid'			=> $invoice_lineitem['appid'],			// Αρ.Δήλωσης
		'appdate'		=> $invoice_lineitem['appdate'],		// Ημ/νία Δήλωσης
		'doy'			=> $invoice_lineitem['doy'],			// ΔΟΥ Δήλωσης
		'shipid'		=> $invoice_lineitem['shipid'],			// Στοιχεία Πλοίου
		'discoption'	=> $invoice_lineitem['discoption'],		// Δικαίωμα Εκπτωσης
		'wthhldpcat'	=> $invoice_lineitem['wthhldpcat'],		// Κατηγορία Παρακρατησης Φόρου
		'wthhld_am'		=> $invoice_lineitem['wthhld_am'],		// Ποσό Παρακράτησης Φόρου
		'stampvalue'	=> $invoice_lineitem['stampvalue'],		// Αξία Χαρτοσήμου
		'stamppcat'		=> $invoice_lineitem['stamppcat'],		// Kατηγορία Συντελεστή Χαρτοσήμου
		'feestype'		=> $invoice_lineitem['feestype'],		// Κατηγoρία Συντελεστή Τελών
		'fees_am'		=> $invoice_lineitem['fees_am'],		// Ποσό Τελών
		'otaxpcat'		=> $invoice_lineitem['otaxpcat'],		// Kατηγορία Λοιπών Φόρων
		'otax_am'		=> $invoice_lineitem['otax_am'],		// Ποσό Λοιπών Φόρων
		'deducvalue'	=> $invoice_lineitem['deducvalue'],		// Αξία Κρατήσεων
		'comments'		=> $invoice_lineitem['comments'],		// Σχόλια
		'taxcat'		=> $invoice_lineitem['taxcat'],			// Κατηγορία Φόρου
		'taxtype'		=> $invoice_lineitem['taxtype'],		// Είδος Φόρου
		'taxamount'		=> $invoice_lineitem['taxamount'],		// Ποσό Φόρου
		'taxunder'		=> $invoice_lineitem['taxunder'],		// Υποκείμενη Αξία
		//'p101'												// Καθαρά Εισφοράς Ανακύκλωσης
		//'p101f'												// ΦΠΑ Εισφοράς Ανακύλωσης
		//'p102'												// Καθαρά Ε.Φ.Κ
		//'p102f'												// ΦΠΑ Ε.Φ.Κ.
		//'p103'												// Καθαρά Δημοτικού Φόρου
		//'p103f'												// ΦΠΑ Δημοτικού Φόρου
		'taric'			=> $invoice_lineitem['taric'],			// Κωδικός Taric
		'itemdescr'		=> $invoice_lineitem['itemdescr'],		// Περιγραφή Είδους
		'p105'			=> $invoice_lineitem['p105'],			// Ποσότητα Pegasus
		'p106'			=> $invoice_lineitem['p106'],			// Περιγραφή Pegasus
		'isinfo'		=> $invoice_lineitem['isinfo'],			// Πληροφορική Γραμμή
		'novat195'		=> $invoice_lineitem['novat195'],		// Ένδειξη μη συμμετοχής στο ΦΠΑ (έσοδα – εκροές)
	);
	if($mydt11_nr01 > 0) {
		$mydt_11_12['remguc'] = '';
		pegasus_mysql_update('mydt11', array_keys($mydt_11_12), array_values($mydt_11_12), 'nr01=:nr01', 0, 1, 1, array('nr01' => $mydt11_nr01));
	} else {
		$mydt_11_12['nr01'] = pegasus_mysql_newrec('mydt11');
		pegasus_mysql_insert('mydt11', array_keys($mydt_11_12), array_values($mydt_11_12));
	}
	if($mydt12_nr01 > 0) {
		$mydt_11_12['remguc'] = '';
		pegasus_mysql_update('mydt12', array_keys($mydt_11_12), array_values($mydt_11_12), 'nr01=:nr01', 0, 1, 1, array('nr01' => $mydt12_nr01));
	} else {
		$mydt_11_12['nr01'] = pegasus_mysql_newrec('mydt12');
		pegasus_mysql_insert('mydt12', array_keys($mydt_11_12), array_values($mydt_11_12));
	}
 }
 function einv_insert_or_update_mydt10_from_einv_invoice($einv01,$invoice, $mydt10_nr01 = 0) {
	$is_address = $invoice['is_address'].(empty($invoice['is_address_num'])? '': " {$invoice['is_address_num']}");
	$cp_address = $invoice['cp_address'].(empty($invoice['cp_address_num'])? '': " {$invoice['cp_address_num']}");
	$p03 = 0;
	if(pegasus_module_exists('stores')) {
		$stores = array();
		$sql = "	SELECT t07.p01
					FROM t07
					JOIN t05 ON t05.p01 = t07.p07
					WHERE 1 = 1
					AND t05.p204 = :t05_p204
					AND t07.p06 = :t07_p06
		";
		$values = array(
			't05_p204' => $invoice['is_vat'],
			't07_p06'  => $invoice['is_branch']
		);
		pegasus_mysql_use($sql, $stores, $values);
		if(!empty($stores)) {
			$p03 = $stores['p01'];
		} elseif($invoice['is_vat'] == $_SESSION["cor000_f00p204"]) {
			$sql = "	SELECT t07.p01
					FROM t07
					WHERE t07.p06 = :t07_p06
			";
			$values = array(
				't07_p06'  => $invoice['is_branch']
			);
			pegasus_mysql_use($sql, $stores, $values);
			if(!empty($stores)) {
				$p03 = $stores['p01'];
			}
		}
	}
	$currency = 'EUR';
	$exchrate = 1;
	$p09 = 3;
	$mydt10 = array(
		'uid' 					=> $invoice['uid'],					// Αναγνωριστικό Παραστατικού
		'mark' 					=> $invoice['mark'],				// Μοναδικός Αριθμός (Μ.Αρ.Κ)
		//'dmark'													// Μ.Αρ.Κ Διαγραφής
		'qrurl'					=> einv_get_qrcode_url($invoice['auth_code']),	// qrURL
		//'entuid'													// Μ.Αρ.Κ Χαρακτηρισμού
		'p03' 					=> $p03,							// Κατάστημα
		'einv'					=> 1,								// Πάροχος
		'auth_cd' 				=> $invoice['auth_code'],			// Συμβολοσειρά Αυθεντικοποίησης
		'einv_nr' 				=> $einv01['nr01'],					// Στοιχεία Σύνδεσης Ηλ. Τιμολόγησης
		'is_vat' 				=> $invoice['is_vat'],				// ΑΦΜ Εκδότη
		'is_country' 			=> $invoice['is_country'],			// Χώρα Εκδότη
		'is_branch' 			=> $invoice['is_branch'],			// Αρ.Εγκατάστασης Εκδότη
		'is_name' 				=> $invoice['is_name'],				// Επωνυμία Εκδότη
		'is_address' 			=> $is_address,						// Διεύθυνση Εκδότη
		'is_city' 				=> $invoice['is_city'],				// Πόλη Εκδότη
		'is_zip' 				=> $invoice['is_zip'],				// Τ.Κ. Εκδότη
		//'is_tbl'													// Πίνακας Εκδότη
		//'is_nr01'													// ΜΚ Πίνακα Εκδότη
		'cp_vat' 				=> $invoice['cp_vat'],				// ΑΦΜ Λήπτη
		'cp_country' 			=> $invoice['cp_country'],			// Χώρα Λήπτη
		'cp_branch' 			=> $invoice['cp_branch'],			// Αρ.Εγκατάστασης Λήπτη
		'cp_name' 				=> $invoice['cp_name'],				// Επωνυμία Λήπτη
		'cp_address' 			=> $cp_address,						// Διεύθυνση Λήπτη
		'cp_city' 				=> $invoice['cp_city'],				// Πόλη Λήπτη
		'cp_zip' 				=> $invoice['cp_zip'],				// Τ.Κ. Λήπτη
		//'cp_tbl'													// Πίνακας Λήπτη
		//'cp_nr01'													// ΜΚ Πίνακα Λήπτη
		'series' 				=> $invoice['series'],				// Σειρά Παρ/κού
		'aa' 					=> $invoice['aa'],					// Αρ.Παρ/κού
		'issuedate' 			=> $invoice['issuedate'],			// Ημερομηνία Έκδοσης
		'issuetime' 			=> $invoice['issuetime'],			// Ώρα Έκδοσης
		'invtype' 				=> $invoice['invtype'],				// Κατηγορία Παραστατικού
		'vatpaysusp' 			=> $invoice['vatpaysusp'],			// Αναστολή Καταβολής ΦΠΑ
		'currency' 				=> $currency,						// Νόμισμα
		'exchrate'			 	=> $exchrate,						// Ισοτιμία
		'correlinv' 			=> $invoice['correlinv'],			// Συσχετιζόμενα Παρ/κά (marks)
		'mconmrk' 				=> $invoice['mconmrk'],				// Συνδεδεμένα Παρ/κά (marks)
		// 'pmcon'													// ΜΚ Συνδεδεμένων Παραστατικών
		'mconauth' 				=> $invoice['mconauth'],			// Συμβολοσειρές Αυθεντικοποίησης Συνδεδεμένων
		//'pcor'													// Συσχετιζόμενα Παρ/κά // Pegasus IDs (nr01)	
		'slfpricing' 			=> $invoice['slfpricing'],			// Αυτοτιμολόγηση
		'fuelinv' 				=> $invoice['fuelinvoice'],			// Παραστατικό Καυσίμων
		'dispdate' 				=> $invoice['dispdate'],			// Εναρξη Αποστολής
		'disptime' 				=> $invoice['disptime'],			// Ωρα Εναρξης
		'vehiclenum' 			=> $invoice['vehiclenum'],			// Αρ.Οχήματος
		'mvpurpose' 			=> $invoice['mvpurpose'],			// Σκοπός Διακίνησης
		'spinvcat' 				=> $invoice['spinvcat'],			// Ειδική Κατηγορία Παραστατικού
		//'invvarty'												// Τύπος Απόκλισης Παραστατικού
		//'paytype' 				=> $invoice['paytype'],				// Τρόπος Πληρωμής
		'tnetvalue' 			=> $invoice['tnetvalue'],			// Σύνολο Καθαρής Αξίας
		'tvat_am' 				=> $invoice['tvat_am'],				// Σύνολο ΦΠΑ
		'twthhld_am' 			=> $invoice['twthhld_am'],			// Σύνολο Παρ.Φόρων
		'tfees_am' 				=> $invoice['tfees_am'],			// Σύνολο Τελών
		'tstamp_am' 			=> $invoice['tstamp_am'],			// Σύνολο Χαρτοσήμου
		'ttax_am' 				=> $invoice['ttax_am'],				// Σύνολο Λοιπών Φόρων
		'tdeduction' 			=> $invoice['tdeduction'],			// Σύνολο Κρατήσεων
		'tgross_val' 			=> $invoice['tgross_val'],			// Συνολική Aξία
		'p00'				 	=> $invoice['p00'],					// 1/2=Εσοδο/Εξοδο
		//'tbl'														// Πίνακας		
		//'tbl_nr01'												// ΜΚ Εγγραφής Πίνακα
		//'p30'														// Μήνυμα από myDATA (στην αποστολή)
		//'p01'														// Αποστολή/Παραλαβή
		//'p02'														// Έκλεισε
		//'p010'													// Δεν Ενημερώνεται Αυτόματα
		//'p02_2'													// Προς Επαναποστολή
		//'p04'														// Κωδικοί Λαθών
		//'p05'														// Διαγράφηκε
		'tcdord' 				=> $invoice['tcdord'],				// Ακυρωτικό Δελτίου Παραγγελίας
		'tr_fail'			=> $invoice['transmission_failure'],	// Αδυναμία Διαβίβασης
		//'v_error'													// Error	
		//'p06'														// Κωδικός Καθεστώτος ΦΠΑ	
		//'p07'														// K.K. Λογαριασμού
		//'p08d'													// Ημ/νία Τελ.Τροποποίησης Κύριου Πίνακα
		//'p08t'													// Ωρα Τελ.Τροποποίησης Κύριου Πίνακα
		'pnr01' 				=> $invoice['pnr01'],				// Pegasus UID
		// 'user_id'												// myDATA user_id (ενημερώνεται μονό στη παραλαβή)
		'p09' 					=> $p09,							// Κατάσταση (0=Αποστολή, 1=Παραλαβή, 2=Ενημέρωση, 3=Αναμονή)
		//'rel_nr01' 												// Έχει αντιστοιχιστεί με
		//'ddate'													// Hμερομηνία Διαγραφής
		//'cinvtype'												// Κωδικός Κατηγορίας Συσχετιζόμενου Παραστατικού
		'p011' 					=> $invoice['p011'],				// Ημερομηνία Διαβίβασης
		'p012' 					=> $invoice['p012'],				// Ώρα Διαβίβασης
		'ldstreet' 				=> $invoice['ldstreet'],			// Οδός
		'dlvstreet' 			=> $invoice['dlvstreet'],			// Οδός
		'ldnumber' 				=> $invoice['ldnumber'],			// Αριθμός
		'dlvnumber' 			=> $invoice['dlvnumber'],			// Αριθμός
		'ldzip' 				=> $invoice['ldzip'],				// Τ.Κ.
		'dlvzip' 				=> $invoice['dlvzip'],				// Τ.Κ.
		'ldcity' 				=> $invoice['ldcity'],				// Πόλη
		'dlvcity' 				=> $invoice['dlvcity'],				// Πόλη
		'ss_branch' 			=> $invoice['ss_branch'],			// Εγκατάσταση έναρξης διακίνησης (Εκδότη)
		'cs_branch' 			=> $invoice['cs_branch'],			// Εγκατάσταση ολοκλήρωσης διακίνησης (Λήπτη)
		'isdlvno' 				=> $invoice['isdlvno'],				// Ένδειξη Παραστατικού Διακίνησης
		'othmvpur' 				=> $invoice['othmvpur'],			// Τίτλος της Λοιπής Αιτίας Διακίνησης
		'thcoll'				=> $invoice['thcoll'],				// Ένδειξη Είσπραξης Τρίτων
		'cp_p600' 				=> $invoice['cp_p600'],				// Αρ. Παροχής Ηλ. Ρεύματος Λήπτη
		'cp_p601' 				=> $invoice['cp_p601'],				// Αριθμός επίσημου εγγράφου Λήπτη
		'cp_p602' 				=> $invoice['cp_p602'],				// Κωδ. Χώρας Έκδοσης Επίσημου Εγγράφου Λήπτη
		'tableaa' 				=> $invoice['tableaa'],				// AA Tραπεζιου
		'p_notes' 				=> $invoice['p_notes'],				// Σημειώσεις
		//'p101'													// Κωδικός Μηνύματος Παρόχου
		//'p102'													// Δεν μπορεί να εκδοθεί Υπογραφή
		//'p103'													// Εκτυπωτής (Only Local)
	);
	/**
	 * paytype: Επί Πιστώσει
	 * 
	 * @todo Κάνουμε overwrite το paytype του einv01 με επί πίστωση (να το δούμε αν είναι οκ αυτό)
	 */
	$mydt10['paytype'] = 5;

	if($mydt10_nr01 > 0) {
		$mydt10['nr01'] = $mydt10_nr01;
		pegasus_mysql_update('mydt10', array_keys($mydt10), array_values($mydt10), 'nr01 = :nr01',0,1,1, array('nr01' => $mydt10['nr01']));
	} else {
		$mydt10['nr01'] = pegasus_mysql_newrec('mydt10');
		pegasus_mysql_insert('mydt10', array_keys($mydt10), array_values($mydt10));
	}
	return $mydt10['nr01'];
 }
 function einv_insert_or_update_mydt13_from_einv_payments($pay_date_from = '0100-01-01', $pay_date_to = '0100-01-01', $einv01_offset = 0, $page = 1, $counters = array()) {
	if(empty($counters)) {
		$counters = array(
			'einv01_get'	=> 0,
			'payments_get'	=> 0,
			'mydt13_exists'	=> 0,
			'mydt13_new'	=> 0
		);
	}
	$einv01 = array();
	pegasus_mysql_use("SELECT * FROM einv01 WHERE `type` = 'einv' ORDER BY remfdate, remftime LIMIT $einv01_offset,1 ",$einv01);
	if(empty($einv01)) {
		$msg = str_replace(array('#pay_date_from#', '#pay_date_to#', '#einv01_get#','#payments_get#', '#mydt13_exists#', '#mydt13_new#'),
		array(peg_dateToStr($pay_date_from, 'd/m/Y'), peg_dateToStr($pay_date_to, 'd/m/Y'), $counters['einv01_get'], $counters['payments_get'],$counters['mydt13_exists'], 
		$counters['mydt13_new']), $_SESSION['peg_dic_einv_insert_or_update_mydt13_from_einv_paymen_info']);
		return array(
			'ok'	=> 1,
			'next'	=> 0,
			'msg'	=> $msg,
		);
	}
	$params = array(
		'paydatetime_from'		=> peg_dateToStr($pay_date_from, 'Y-m-d H:i:s'),
		'paydatetime_to'		=> peg_dateToStr("$pay_date_to 23:59:59", 'Y-m-d H:i:s'),
		'page' 					=> $page,
		'lang' 					=> (strtolower($_SESSION['lang']) == 'en')? 'en': 'el',
	);
	$einv_service_call_get_resp = einv_service_call_get('get-issued-invoices', $einv01, $params);
	$log_resp = json_decode($einv_service_call_get_resp['data']['response'], true) !== false ? json_decode($einv_service_call_get_resp['data']['response'], true) : $einv_service_call_get_resp;
	einv_einv90_logging($einv01,'get-paymets-invoice-list',$params,$log_resp);
	if($einv_service_call_get_resp['data']['http_code'] == 401) {
		return array(
			'ok' => 1,
			'next' => 1,
			'data' => array(
				'pay_date_from'		=> $pay_date_from,
				'pay_date_to'		=> $pay_date_to,
				'einv01_offset'			=> $einv01_offset + 1,
				'page'					=> 1,
				'counters'				=> $counters
			)
		);
	}
	if($einv_service_call_get_resp['ok'] == 0) {
		return array(
			'ok'	=> 0,
			'msg'	=> $einv_service_call_get_resp['msg'],
		);
	}
	$service_data = json_decode($einv_service_call_get_resp['data']['response'],true);
	if(!is_array($service_data)) {
		return array(
			'ok' => 0,
			'msg' => json_last_error_msg()
		);
	}
	if($service_data['ok'] != 1) {
		$msg = $service_data['code'].(!empty($service_data['error']['message']) ? ': '.$service_data['msg'] : '');
		return array(
			'ok' => 0,
			'msg' => $msg
		);
	}
	if(empty($service_data['data']['invoices'])) {
		return array(
			'ok' => 1,
			'next' => 1,
			'data' => array(
				'pay_date_from'		=> $pay_date_from,
				'pay_date_to'		=> $pay_date_to,
				'einv01_offset'			=> $einv01_offset + 1,
				'page'					=> 1,
				'counters'				=> $counters
			)
		);
	}
	$counters['einv01_get'] += count($service_data['data']['invoices']);
	foreach($service_data['data']['invoices'] as $invoice) {
		$mydt10 = array();
		pegasus_mysql_use('SELECT * FROM mydt10 WHERE auth_cd = :auth_cd', $mydt10, array('auth_cd' => $invoice['auth_code']));
		if(empty($mydt10)) {
			continue;
		}
		$todel_string = '@2del@_' . date('Ymd') .  '_' . rand(0, 99999);
		pegasus_mysql_update('mydt13', array('remguc'), array($todel_string), 'mydt10 = :nr01', 0, 1, 1, array('nr01' => $mydt10['nr01']));
		foreach($invoice['payments'] as $payment) {
			$counters['payments_get']++;
			$mydt13 = array(
				'mydt10'		=> $mydt10['nr01'],
				'einv_dt'		=> $invoice['issuedate'],
				'einv_tm'		=> $invoice['issuetime'],
				'type'			=> $payment['type'],
				'amount'		=> $payment['amount'],
				'amount_t'		=> $payment['amount_t'],
				'p_info'		=> $payment['p_info'],
				'p_sign'		=> $payment['p_sign'],
				'tid'			=> $payment['tid'],
				'remguc'		=> '',
				'einv_dt'		=> $payment['remfdate'],
				'einv_tm'		=> $payment['remftime'],
			);
			$mydt13_nr01 = pegasus_mysql_printfld(
				'mydt13', 
				'nr01', 
				'mydt10 = :mydt10 AND type = :type AND amount = :amount AND p_sign = :p_sign AND remguc = :remguc', 
				array('mydt10' => $mydt13['mydt10'], 'type' => $mydt13['type'], 'amount' => $mydt13['amount'], 'p_sign' => $mydt13['p_sign'], 'remguc' => $todel_string),
			);
			if($mydt13_nr01 > 0) {
				$counters['mydt13_exists']++;
				pegasus_mysql_update('mydt13', array_keys($mydt13), array_values($mydt13), 'nr01 = :nr01', 0, 1, 1, array('nr01' => $mydt13_nr01));
				continue;
			}
			$mydt13['nr01'] = pegasus_mysql_newrec('mydt13');
			pegasus_mysql_insert('mydt13', array_keys($mydt13), array_values($mydt13));
			$counters['mydt13_new']++;
		}
		$res = pegasus_query('SELECT * FROM mydt13 WHERE mydt10 = :mydt10 AND remguc = :remguc', array('mydt10' => $mydt10['nr01'], 'remguc' => $todel_string));
		while($rs = pegasus_fetch_assoc($res)) {
			pegasus_mysql_delete('mydt13', 'nr01 = :nr01',0, array('nr01' => $rs['nr01']));
			if($rs['tbl'] == 't01' && !empty($rs['tbl_nr01'])) {
				pegasus_mysql_delete('t01', 'nr01 = :nr01', 0, array('nr01' => $rs['tbl_nr01']));
			}
		}
	}
	return array(
		'ok' => 1,
		'next' => 1,
		'data' => array(
			'pay_date_from'		=> $pay_date_from,
			'pay_date_to'		=> $pay_date_to,
			'einv01_offset'			=> $einv01_offset,
			'page'					=> $page + 1,
			'counters'				=> $counters
		)
	);
 }
 function einv_initialize_a55_from_mydt10_nr01($data, $mydt10_nr01, $container_id, $is_new) {
	$mydt10 = array();
	pegasus_mysql_use('SELECT * FROM mydt10 WHERE nr01 = :nr01', $mydt10, array('nr01' => $mydt10_nr01));
	if(empty($mydt10)) {
		return $data;
	}
	if($mydt10['p09'] != 3){
		return $data;
	}

	//'p805'								// Δεν υπολογίζεται Εισφορά Ανακύκλωσης
	$data['d_p01'] =  $mydt10['dispdate'];	// Ημερομηνία Διακίνησης
	$data['d_p02'] =  $mydt10['disptime'];	// Ώρα Διακίνησης
	$data['p07'] = 0;						// Τιμές Με ΦΠΑ
	$data['p08'] = 1;						// Χειρόγραφο
	//'y_ekd'								// Υποέκδοση
	//'p901'								// Εχει γίνει Ελεγχος
	//'pweb01'								// Σε Αναμονή
	//'p0102_1'								// Έκπτωση προ ΦΠΑ από Χρήστη
	//'p0102_2'								// Έκπτωση στο σύνολο
	$data['p0100'] = $mydt10['tnetvalue'];	// Αρχική  Αξία
	//'p0600'								// Λοιποι Φόροι
	//'p0601'								// Λοιπές Κρατήσεις
	//'p0102'								// Έκπτωση (Ποσό προ ΦΠΑ)
	$data['p0105'] = $mydt10['tvat_am'];	// Φ.Π.Α.
	$data['p0109'] = $mydt10['tgross_val'];	// Σύνολο
	//'p09'									// Κωδ.Καθεστώτος ΦΠΑ
	//'p010'								// Αιτιολογία
	//'p011'								// Παρατηρήσεις
	//'p012'								// Σκοπός Διακίνησης
	//'p013'								// Από
	//'p014'									// Πρός
	$data['ldstreet'] =  $mydt10['ldstreet'];	// Οδός
	$data['dlvstreet'] =  $mydt10['dlvstreet'];	// Οδός
	$data['ldnumber'] =  $mydt10['ldnumber'];	// Αριθμός
	$data['dlvnumber'] =  $mydt10['dlvnumber'];	// Αριθμός
	$data['ldzip'] =  $mydt10['ldzip'];			// ΤΚ
	$data['dlvzip'] =  $mydt10['dlvzip'];		// ΤΚ
	$data['dlvcity'] =  $mydt10['dlvcity'];		// Πόλη
	$data['ldcity'] =  $mydt10['ldcity'];		// Πόλη
	$data['ss_branch'] =  $mydt10['ss_branch'];	// Εγκατάσταση έναρξης διακίνησης (Εκδότη)
	$data['cs_branch'] =  $mydt10['cs_branch'];	// Εγκατάσταση ολοκλήρωσης διακίνησης (Λήπτη)
	//'p702'								// Αρ.Κυκλοφορίας
	//'p017									// Κωδ.Τρόπου Μεταφοράς
	//'p016'								// Κωδικός Πωλητή
	//'p0101'								// % Εκπτωσης  στο σύνολο
	//'p0112'								// %Κράτησης
	//'vp0112								// Κράτησης
	//'p0113'								// % Φόρου
	//'vp0113'								// Φόρου
	//'p0108'								// Επιβαρύνσεις
	//'p0010'								// Δέματα
	//'p601'								// Μ.Κ. Μετασχ.
	//'p601a'								// ΜΚ Ειδικού ακυρωτικού
	//'pl601'								// Προμηθευτή
	//'p703'								// Κωδ.Αποθήκης
	$data['p0121'] = $mydt10['p03'];		// Κατάστημα
	//'p201' - 'p209'						// Καθαρά 1-9
	//'p301' - 'p309'						// ΦΠΑ 1-9
	//'p401' - 'p409'						// Λεκτικό 1-9
	$data['p410'] =  0;						// Τα σύνολα Δεν υπολογίζονται αυτόματα
	//'p420'								// Το ΦΠΑ Υπολογίζεται ανά Είδος
	//'p411'								// Προηγούμενο Υπόλοιπο Πελάτη
	//'p412'								// Πιστωτικό Οριο Πελατη
	//'p413'								// Νέο Υπόλοιπο Πελάτη
	//'p414'								// Κωδ.Παρ/κού που ακυρώθηκε
	//'p30'									// Σημειώσεις
	//'p501'								// Κωδ.Αποστολέα (CRM)
	//'p502'								// Κωδ.Παραλήπτη (CRM)
	//'pn01'								// Κωδ.Ξένου Νομίσματος
	//'pn02'								// Ισοτιμία Νομίσματος
	//'p0110'								// Ποσό Είσπραξης (Αντικαταβολή)
	//'p603'								// Ημερομηνία Είσπραξης Αντικαταβολής
	//'p604'								// Ημερομηνία Ακύρωσης Αντικαταβολής
	//'p503'								// Κωδικός Εργου
	//'p504'								// Κωδικός Εργασίας
	//'p415'								// Κωδ.Καταστήματος Από
	//'p416'								// Κωδ.Καταστήματος Εώς
	//'p417'								// Προηγούμενο Τοπικό Υπόλοιπο
	//'p418'								// Νέο Τοπικό Υπόλοιπο
	//'p016a'								// Κωδ.Χρήστη Καταχώρησης
	//'p505'								// Κωδ.Σύμβασης
	//'p704'								// Δεν Ενημερώνει Πόντους
	//'p705'								// Κωδ.Οχήματος Πελάτη
	//'p109_1'								// Αλλαγή Συνόλου
	//'p506'								// Μ.Κ.Δωροεπιταγής
	//'p507'								// Ποσό Ενός Πόντου
	//'p508'								// Αλλαγή ημερομηνίας από τον Χρήστη
	//'p706'								// Διάταξη Απαλλαγής ΦΠΑ
	//'p706c'								// Διάταξη Απαλλαγής ΦΠΑ
	//'p707'								// Αριθμός Φορολογικής Κάρτας
	//'p807'								// Αναστολή Καταβολής ΦΠΑ
	if(empty($mydt10['cp_vat'])) {
		$data['p03'] = $_SESSION['customers_000_retail_a01'];
	} else {
		$data['p03'] = pegasus_mysql_printfld('a01','nr01','p20 = :p20', array('p20' => $mydt10['cp_vat']));
		if(empty($data['p03'])) {
			$customers_getAFM_resp = customers_getAFM($mydt10['cp_vat'],'a01');
			if($customers_getAFM_resp['ok'] == 1) {
				$request_backup = $_REQUEST;
				$screen = new screen();
				$screen->container_id = pegasus_container_id_create(0 , session_id() , 'a01_d');
				$screen->module       = 'customers';
				$screen->_d           = 'a01_d';
				$screen->table        = 'a01';
				$screen->read_data_from_db(1,1);
				$screen->read_params_from_db();
				$screen->data['p20'] = $mydt10['cp_vat'];
				$screen->data['p19'] = empty($customers_getAFM_resp['onomasia']) ? $mydt10['cp_vat'] : $customers_getAFM_resp['onomasia'];
				$screen->data['p190'] = $customers_getAFM_resp['commerTitle'];
				$screen->data['pc22'] = $customers_getAFM_resp['doy'];
				$screen->data['p22'] = $customers_getAFM_resp['doyDescr'];
				$screen->data['p5'] = $customers_getAFM_resp['parDescription'];
				$screen->data['p4'] = $customers_getAFM_resp['postalAddress'];
				$screen->data['p7'] = $customers_getAFM_resp['postalZipCode'];
				$screen->data['p4_3'] = $customers_getAFM_resp['city'];
				$_REQUEST = $screen->data;
				$_REQUEST['no_confirm'] = 1;
				$screen_save_data_resp = $screen->save_data();
				$nr01 = $screen->data['nr01'];
				peg_close_d($screen->container_id);
				$_REQUEST = $request_backup;
				if(!$screen_save_data_resp[0]){
					return array(
						"ok" =>  0, 
						"msg" => $screen_save_data_resp[1]
					);
				}
				$data['p03'] = $nr01;
			}
		}
	}
	$data = invoices_find_p03_data($data, 'a55');
	
	// $data['p07'] = 0; // (Τιμές Με ΦΠΑ) το set του p07 πρέπει να γίνεται και μετά την επιλογή του πελάτη 
	$sql = "	SELECT a10.p01 AS a10_p01
				FROM q31
				JOIN a10 ON a10.p01 = q31.p03
				WHERE 1 = 1
				AND q31.p01 = 620014
				AND q31.p05 = :invtype
				ORDER BY a10.ptax DESC
				LIMIT 1
	";
	$rs = pegasus_query($sql, array('invtype' => $mydt10['invtype']));
	$res = pegasus_fetch($rs,PEG_FETCH_ASSOC);
	$data['p05'] = $res['a10_p01'];
	$data = invoices_find_p05_data($data, 'a55', false);
	// Όρισμός Τρόπου πληρωμής
	$data['p015'] = $_SESSION['einv00_a14']; // Τρόπος Πληρωμής
	$data['p08'] = 1;
	$data['p07'] = 1;

	$data['p01'] = $mydt10['issuedate'];	// Ημερομηνία
	$data['p02'] = $mydt10['issuetime'];	// Ώρα
	$data['p701'] = $mydt10['series'];		// Σειρά
	$data['p06'] = $mydt10['aa'];			// Αριθμός
	
	$todel_string = '@2del@_' . date('Ymd') .  '_' . rand(0, 99999);
	pegasus_mysql_update('peg_tmp_i01',array('remguc'), array($todel_string), pegasusGetGlobalVar($container_id . '_where_eidi'));
	$res = pegasus_query('SELECT * FROM mydt11 WHERE mydt10 = :mydt10', array('mydt10' => $mydt10_nr01));
	while($mydt11 = pegasus_fetch_assoc($res)) {
		$i00 = array();
		pegasus_mysql_use("SELECT i00.* FROM i00 JOIN einv11 ON i00.pno = einv11.i00_pno WHERE einv11.mydt51_p00 = :mydt51_p00 AND einv11.rectype = :rectype", $i00, array('mydt51_p00' => $mydt11['vatcat'], 'rectype' => $mydt11['rectype']));
		$i13 = array();
		pegasus_mysql_use("SELECT * FROM i13 WHERE p01 = :p01", $i13, array('p01' => $i00['fpa']));
		$p02 = $mydt11['p02'];
		if(empty($p02)) {
			$p02 = $mydt11['comments'];
		}
		if(empty($p02)) {
			$p02 = $i00['name'];
		}

		$quantity = $mydt11['quantity'];
	
		if(!($quantity>0) and $mydt11['p105']>0){
			$quantity = $mydt11['p105'];
		}

		if($quantity<=0){
			$quantity = 1;
		}

		$p04 = (floatval($mydt11['netvalue'])+floatval($mydt11['fpavalue'])) / $quantity;
		// Επιπλέον Αξία - υπολογισμός
		$p042 = (floatval($mydt11['netvalue'])+floatval($mydt11['fpavalue'])) - ($quantity * $p04);
		$i01 = array(
			'p013'			=> $mydt10['issuedate'],	// Ημερομηνία
			'p013t'			=> $mydt10['issuetime'],	// Ώρα
			'p01'			=> $i00['pno'],				// Eίδος αποθήκης
			//'p01b'									// Barcode Αναζήτησης
			'p02'			=> $p02,					// Περιγραφή
			'p03'			=> $quantity,
			'p04'			=> $p04,					// Τιμή Μονάδας
			//'p05'										//	Κωδικός Κίνησης
			//'p610'									// Αποθηκευτικός Χώρος
			'p023'			=> $data['p0121'],			// Κατάστημα
			//'p0601'									// Αιτιολογία
			//'p030'									// Δευτερεύουσα Ποσότητα
			//'p301'									// Τεμάχια
			//'p302'									// Μήκος				
			//'p303'									// Πλάτος,
			//'p304'									// Ύψος
			//'p306'									// Μικτό Βάρος
			//'p307'									// Αλλαγή Τελικής Ποσότητας
			//'p309'									// Κόλλα (πλήθος)	
			//'p310'									// Απόβαρο
			//'p030_1'									// Ποσότητα Συσκευασίας
			//'p308'									// Κωδ.Είδους Συσκευασίας
			'p09'			=> 0,						// Η Τιμή Μονάδας περιέχει ΦΠΑ
			//'p012'									// Συντελεστής (-1=άκυρα)
			'p010'			=> 0,						// % Έκπτωσης 1
			'p010a'			=> 0,						// % Έκπτωσης 2
			'p0100'			=> 0,						// % Επιπλέον Εκπτωσης	
			'p042'			=> $p042,						// Επιπλέον Αξία
			//'p616'									// Ε.Φ.Κ. Ανά Μονάδα Χωρίς ΦΠΑ
			//'p616p'									// % Ε.Φ.Κ.
			//'p041'									// Εισφορά Ανακύκλωσης Ανά Μονάδα (χωρίς ΦΠΑ)
			//'pp011'									// Διόρθωση Καθαρής Αξίας
			//'p021'									// Επιπλέον Επιβάρυνση (ευρώ)
			'p011'			=> $mydt11['netvalue'],		// Καθαρή Αξία (Ευρώ)
			//'p0101'									// Επιβάρυνση (σε Ευρώ)
			//'p022'									// Καθαρή Αξία με Επιβαρύνσεις (Ευρώ)
			'fp011'			=> $mydt11['fpavalue'],		// ΦΠΑ Κίνησης (ευρώ)
			'p081'			=> $i13['p01'],				// Κωδικός Κατηγορίας ΦΠΑ
			'p08'			=> $i13['p03'],				// %ΦΠΑ
			'pn01'			=> $data['pn01'],			// Κωδικός Νομίσματος
			'pn02'			=> $data['pn02'],			// Ισοτιμία
			//'p04_1'									// Τιμή Συσκευασίας
			//'timh1'									// Τιμή Κόστους
			//'timh2'									// Τιμή Λιανικής
			//'timh3'									// Τιμή Χονδρικής
			//'timh4'									// Τιμή Υπερχονδρικής
			//'p614'									// Κατώτερη Τιμή Πώλησης
			//'p500'									// Πόντοι Ενός
			//'p501'									// Δεν Συμ/χει σε Πόντους
			//'p501_1'									// Δεν Συμ/χει στους Αξιακούς Πόντους
			//'p500_1'									// Δεν Συμ/χει στους Αξιακούς Πόντους
			'p061'			=> $mydt11['linenumber'],	// Α.Α. Γραμμής Παρ/κού
			'p06'			=> $data['nr01'],			// M.K.Σχετικής Κίνησης
			'p07'			=> 2,						// Κωδ.Κατηγορίας Κίνησης
			//'p014'									// Κωδικός Λογαριασμού
			//'pd101'									// Σχετικός Πίνακας
			//'pd102'									// Σχετικό Μ.Κ.

			'remguc' 		=> $mydt11['nr01']);
		if($is_new) {
			$i01 = array_merge($i01, array(
				'nr01'			=> pegasus_mysql_newrec('i01'),
				'peg_mmnr01'	=> "a55_d-{$data['nr01']}",
				'peg_mnr01'		=> $data['nr01'],
				'peg_flag'		=>	1,
				'peg_sess_id'	=> session_id()
			));
			pegasus_mysql_insert('peg_tmp_i01', array_keys($i01), array_values($i01));
			continue;
		}
		$i01_nr01 = pegasus_mysql_printfld('peg_tmp_i01',"nr01", "p03 = :p03 AND p04 = :p04 AND p023 = :p023 AND p09 = :p09 AND p011 = :p011 AND fp011 = :fp011 AND p081 =:p081
		AND p08 = :p08 AND p061 = :p061 AND p06 = :p06 AND remguc = :remguc",array(
			'p03'		=> $i01['p03'],
			'p04'		=> $i01['p04'],
			'p023'		=> $i01['p023'],
			'p09'		=> $i01['p09'],
			'p011'		=> $i01['p011'],
			'fp011'		=> $i01['fp011'],
			'p081'		=> $i01['p081'],
			'p08'		=> $i01['p08'],
			'p061'		=> $i01['p061'],
			'p06' 		=> $i01['p06'],
			'remguc'	=> $todel_string
		));
		if($i01_nr01 > 0) {
			$i01 = array_merge($i01, array(
				'peg_mmnr01'	=> "a55_d-{$data['nr01']}",
				'peg_mnr01'		=> $data['nr01'],
				'peg_flag'		=>	2,
				'peg_sess_id'	=> session_id()
			));
			pegasus_mysql_update('peg_tmp_i01', array_keys($i01), array_values($i01), 'nr01 = :nr01', 0, 1, 1, array('nr01' => $i01_nr01));
			continue;
		}
		$i01 = array_merge($i01, array(
			'nr01'			=> pegasus_mysql_newrec('i01'),
			'peg_mmnr01'	=> "a55_d-{$data['nr01']}",
			'peg_mnr01'		=> $data['nr01'],
			'peg_flag'		=>	1,
			'peg_sess_id'	=> session_id()
		));
		pegasus_mysql_insert('peg_tmp_i01', array_keys($i01), array_values($i01));
	}
	pegasus_mysql_update('peg_tmp_i01',array('peg_flag','remguc'), array(9,''),"remguc = :remguc", 0, 1, 1, array('remguc' => $todel_string));
	pegasusSetGlobalVar("a55_d-{$data['nr01']}" . '_mydt10_nr01', $mydt10_nr01);
	return $data;
 }
 function einv_a55_d_change($checkOnlyPerm, $data, $permDeny){
	$mydt10_nr01 = pegasusGetGlobalVar("a55_d-{$data['nr01']}" . '_mydt10_nr01');
	if(empty($mydt10_nr01)) {
		return $permDeny;
	}
	$mydt10 = array();
	pegasus_mysql_use("SELECT * FROM mydt10 WHERE p09 = 3 AND nr01 = :nr01", $mydt10, array('nr01' => $mydt10_nr01));
	if(empty($mydt10)) {
		return $permDeny;
	}
	if($mydt10['tgross_val'] != $data['p0109']) {
		// Η τιμή του πεδίου "Σύνολο" δεν μπορεί να αλλάξει.
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_einv_initialize_a55_from_mydt10_nr01_error_1']));
	}
	if($checkOnlyPerm != 1) {
		pegasus_mysql_update('mydt10', array('tbl','tbl_nr01'), array('a55',$data['nr01']), 'nr01 = :nr01', 0, 1, 1, array('nr01' => $mydt10_nr01));
		$res = pegasus_query("SELECT * FROM peg_tmp_i01 WHERE ".pegasusGetGlobalVar('peg_' ."a55_d-{$data['nr01']}" . '_where_eidi'));
		while($rs = pegasus_fetch_assoc($res)) {
			if(!empty($rs['remguc'])) {
				pegasus_mysql_update('mydt11', array('tbl','tbl_nr01'), array('i01',$rs['nr01']), 'nr01 = :nr01', 0, 1, 1, array('nr01' => $rs['remguc']));
				pegasus_mysql_update('peg_tmp_i01', array('remguc'), array(''), 'nr01 = :nr01 AND '.pegasusGetGlobalVar('peg_' ."a55_d-{$data['nr01']}" . '_where_eidi')
				, 0, 1, 1, array('nr01' => $rs['nr01']));
			}
		}
	}
	return $permDeny; 
}
function einv_a55_from_mydt10($mydt10_nr01) {
	$update = false;
	$error_msg = str_replace('#mydt10_nr01#', $mydt10_nr01, $_SESSION['peg_dic_einv_a55_from_mydt10_error']);
	$mydt10 = array();
	pegasus_mysql_use("SELECT * FROM mydt10 WHERE nr01 = :nr01", $mydt10, array('nr01' => $mydt10_nr01));
	$request_backup = $_REQUEST;
	$_REQUEST['mydt10_nr01'] = $mydt10_nr01;
	$screen = new screen();
	$screen->container_id = pegasus_container_id_create(0 , session_id() , 'a55_d');
	$screen->module       = 'invcust';
	$screen->_d           = 'a55_d';
	$screen->table        = 'a55';
	if($mydt10['tbl_nr01'] > 0) {
		$update = true;
		$screen->nr01 = $mydt10['tbl_nr01'];
	}
	$screen->read_data_from_db(1,1);
	$screen->read_params_from_db();
	if($screen->data['permDeny'] == 1){
		return array(
			"ok" =>  0,
			"msg" => $error_msg.$screen->data['permDenyMessage']
		);
	}
	$_REQUEST = $screen->data;
	$_REQUEST['no_confirm'] = 1;
	$screen_save_data_resp = $screen->save_data();
	$nr01 = $screen->data['nr01'];
	peg_close_d($screen->container_id);
	$_REQUEST = $request_backup;
	if(!$screen_save_data_resp[0]){
		return array(
			"ok" =>  0, 
			"msg" => $error_msg.$screen_save_data_resp[1]
		);
	}
	// Παραστατικό myData #mydt10_nr01#: Επιτυχής <b>Δημιουργία</b> παραστατικού πελάτη #a55_nr01#
	$msg = str_replace(array('#mydt10_nr01#', '#a55_nr01#'), array($mydt10_nr01, $nr01), $_SESSION['peg_dic_einv_a55_from_mydt10_success_insert']);
	if($update) {
		// Παραστατικό myData #mydt10_nr01#: <b>Επιτυχής Ενημέρωση</b> παραστατικού πελάτη #a55_nr01#
		$msg = str_replace(array('#mydt10_nr01#', '#a55_nr01#'), array($mydt10_nr01, $nr01), $_SESSION['peg_dic_einv_a55_from_mydt10_success_update']);
	}
	return array(
		'ok' => 1,
		'msg' => $msg
	);
}
function einv_t01_from_mydt13($mydt13_nr01) {

	$check = array();
	$sql = "	SELECT 
					mydt10.tbl_nr01	AS mydt10_tbl_nr01,
					mydt10.invtype	AS mydt10_invtype,
					mydt10.p03 		AS mydt10_p03,
					a01.p21 		AS a01_p21
				FROM mydt13
				JOIN mydt10 ON mydt10.nr01 = mydt13.mydt10
				JOIN a55 ON a55.nr01 = mydt10.tbl_nr01 AND mydt10.tbl = 'a55'
				LEFT JOIN a01 ON a01.nr01 = a55.p03
				WHERE mydt13.nr01 = :nr01
	";
	pegasus_mysql_use($sql, $check, array('nr01' => $mydt13_nr01));
	if(!($check['mydt10_tbl_nr01'] > 0)) {
		// Δεν έχει καταχωρηθεί παραστατικό πελάτη για αυτή την πληρωμή
		return array(
			'ok' => 0,
			'msg' => $_SESSION['peg_dic_einv_t01_from_mydt13_error_2']
		);
	}
	$mydt13 = array();
	pegasus_mysql_use("SELECT * FROM mydt13 WHERE 1 = 1 AND mydt13.nr01 = :nr01", $mydt13, array('nr01' => $mydt13_nr01));
	$p401 = $_SESSION['username'];
	$p303 = 9;
	$is_new = false;
	if(pegasus_mysql_printfld('t01','nr01','nr01 = :nr01 AND p303 = :p303',array('nr01' => $mydt13['tbl_nr01'], 'p303' => $p303)) > 0 ){
		$t01_nr01 = $mydt13['tbl_nr01'];
	} else {
		$is_new = true;
		$t01_nr01 = pegasus_mysql_newrec('t01');
	}
	$t01_p01 = $check['a01_p21'];
	$pn01 = '';
	$pn02 = 1;	
	$t02 = array();
	$sql = "	SELECT t02.p01, t02.p03, t02.p04
				FROM einv12
				JOIN mydt50 ON p00 = :mydt50_p00
				JOIN t02 ON t02.p01 = IF(mydt50.p201 = -1, einv12.t02_p1_pi, einv12.t02_p1_xr)
				WHERE einv12.mydt64_p00 = :mydt64_p00
	";
	$values = array(
		'mydt64_p00'	=> $mydt13['type'],
		'mydt50_p00'	=> $check['mydt10_invtype']
	);
	pegasus_mysql_use($sql, $t02, $values);
	if(empty($t02)) {
		// Δεν έχει οριστεί Τύπος Πληρωμής για αυτή την πληρωμή
		return array(
			'ok' => 0,
			'msg' => $_SESSION['peg_dic_einv_t01_from_mydt13_error_3']
		);
	}
	$p03 = $mydt13['amount'] * $t02['p03'];
	$p04 = $mydt13['amount'] * $t02['p04'];
	$pn03 = $p03 * $pn02;
	$pn04 = $p04 * $pn02;
	$t01 = array(
		'p01'	=> $t01_p01,				// Λογαριασμός
		'p02'	=> $mydt13['einv_dt'],		// Ημερομηνία
		'p02t'	=> $mydt13['einv_tm'],		// Ώρα
		'p05'	=> '',						// Αιτιολογία
		'p06'	=> '',						// Παραστατικό
		'p07'	=> $t02['p01'],				// Κωδικός Κίνησης
		'p09'	=> $check['mydt10_p03'],	// Κατάστημα
		'p101'	=> 0,						// ΦΠΑ
		'p401'	=> $p401,					// Εισπράκτορας
		//'p503'	=> '',					// Έργο
		//'p504'	=> '',					// Εργασία
		'pn01'	=> $pn01,					// Ξένο Νόμισμα
		'pn02'	=> $pn02,					// Ισοτιμία
		//'pd101'	=> '',					// Σχετικός Πίνακας
		//'pd102'	=> '',					// Σχετικό Μ.Κ
		'p03'	=> $p03,					// Χρέωση
		'p04'	=> $p04,					// Πίστωση
		'p201'	=> 0,						// Καθαρά
		'pn03'	=> $pn03,					// Χρέωση σε Ξένο Νόμισμα
		'pn04'	=> $pn04,					// Πίστωση σε Ξένο Νόμισμα
		'p302'	=> $check['mydt10_tbl_nr01'],		// M.K.Σχετικής Κίνησης
		'p303'	=> $p303,					// Κωδ.Κατηγορίας Κίνησης
		//'p900'							// Υποκ/μα Λογαριασμού
		//'p080'	=> '',					// 1=Ακυρωτικό (για ΜΥΦ)
	);
	$msg = '';
	if(!$is_new){
		// Πληρωμή MyData #mydt13_nr01#: Επιτυχής <b>Ενημέρωση</b> κίνησης λογαριασμού #t01_nr01#
		$msg = str_replace(array('#mydt13_nr01#', '#t01_nr01#'), array($mydt13_nr01, $t01_nr01), $_SESSION['peg_dic_einv_t01_from_mydt13_update']);
		pegasus_mysql_update('t01', array_keys($t01), array_values($t01), 'nr01 = :nr01', 0, 1, 1, array('nr01' => $t01_nr01));
	} else {
		// Πληρωμή MyData #mydt13_nr01#: Επιτυχής <b>Δημιουργία</b> κίνησης λογαριασμού #t01_nr01#
		$msg = str_replace(array('#mydt13_nr01#', '#t01_nr01#'), array($mydt13_nr01, $t01_nr01), $_SESSION['peg_dic_einv_t01_from_mydt13_insert']);
		$t01['nr01'] = $t01_nr01;
		pegasus_mysql_insert('t01', array_keys($t01), array_values($t01));
	}
	pegasus_mysql_update('mydt13', array('tbl','tbl_nr01'), array('t01',$t01_nr01), 'nr01 = :nr01', 0, 1, 1, array('nr01' => $mydt13['nr01']));
	return array(
		'ok' => 1,
		'msg' => $msg
	);
}

function einv_einv22_d_initialize($data, $mmnr01, $mnr01, $_d, $container_id){
	$data['v_p300']=1;
	pegasusSetGlobalVar($container_id . '_where' , "mydt10.p09 = 3 AND mydt10.tbl='' AND mydt10.tbl_nr01=0");
	return $data;
}

function einv_einv23_d_initialize($data, $mmnr01, $mnr01, $_d, $container_id){
	$data['v_p300']=1;
	pegasusSetGlobalVar($container_id . '_where' , "selectbox_mydt10_mydt10.p09 = 3 AND mydt13.tbl='' AND mydt13.tbl_nr01=0");
	return $data;
}