<?php
function peg_invbalance__i2_wrap_grid_rows_update(
	$container_id='',
	$drop='',
	$add=true
) {
	//
	$group=pegasusGetGlobalVar('_i2_d04_group_data_' . $container_id);
	if(!is_array($group)) {
		$group=array();
	}
	//
	$drop=explode(';',$drop);
	foreach($drop as $v) {
		foreach($group as $kk=>$vv) {
			if($v==$vv) {
				unset($group[$kk]);
			}
		}
	}
	if($add) {
		foreach($drop as $v) {
			array_push($group,$v);
		}
	}
	pegasusSetGlobalVar('_i2_d04_group_data_' . $container_id,$group);
	return array(
		'ok'	=> 1,
		'data'	=>$group,
		'msg'	=> 'Success'
	);
}

/**
 * Υπολογισμός (i07.p05) (Υπόλοιπου Αποθήκης) για εγγραφές ειδών από πακέτο
 *
 * @param string $i07_p02		Είδος
 * @param string $date_to		Έως Ημερομηνία
 * @param string $i07_p01		Αποθήκη
 * @param string $i07_p11		S.N.
 * @param string $i07_p10		Παρτίδα
 * @param string $i07_pc01		Χρώμα
 * @param string $i07_pm01		Μέγεθος
 * @param boolean $flag_cs		Παρακολουθεί Χρώμα Μέγεθος
 * @param boolean $flag_lot		Παρακολουθεί Παρτίδες
 * @param boolean $flag_sn		Παρακολουθεί SN
 * @return array
 */
function peg_invbalance_find_i07_p05(
	$i07_p02 = '',
	$date_to = '',
	$i07_p01 = '',
	$i07_p11 = '',
	$i07_p10 = '',
	$i07_pc01 = '',
	$i07_pm01 = '',
	$flag_cs = true,
	$flag_lot = true,
	$flag_sn = true
) {
	try {
		// Color Size
		if (
			pegasus_module_exists('colorsize')
			&& $flag_cs
			&& $i07_pc01 != ''
			&& $i07_pm01 != ''
		) {
			$values = array(
				'i01_p01' => $i07_p02,
				'i48_p02' => $i07_pc01,
				'i48_p03' => $i07_pm01,
				'i01_p610' => $i07_p01,
				'i01_p013' => $date_to
			);
			$res = pegasus_query(
				" SELECT
					SUM(i48.p04*i01.p012*(i15.p03-i15.p04)) AS p05
				FROM 
					i01, i15, i48
				WHERE i01.p05=i15.p01
					AND i48.p01=i01.nr01  
					AND i01.p01=:i01_p01
					AND i48.p02=:i48_p02
					AND i48.p03=:i48_p03
					AND i01.p610=:i01_p610
					AND i01.p013<=:i01_p013
				GROUP BY 
					i01.p01
			",
				$values
			);
			if (!$res) {
				throw new Exception('(00) [peg_invbalance_find_i07_p05]: ' . pegasus_mysql_error());
			}
			$rs = pegasus_fetch_assoc($res);
			return array(
				'ok' => 1,
				'data' => $rs['p05'] ? $rs['p05'] : 0,
				'error' => null
			);
		}
		//	LOT
		if (
			pegasus_module_exists('lot')
			&& $flag_lot
			&& $i07_p10 != ''
		) {
			$values = array(
				'i01_p01' => $i07_p02,
				'i38_p02' => $i07_p10,
				'i01_p610' => $i07_p01,
				'i01_p013' => $date_to
			);
			$res = pegasus_query(
				"SELECT 
					SUM(i38.p04*i01.p012*(i15.p03-i15.p04)) AS p05
				FROM
					i01, i15, i38 
				WHERE i01.p05=i15.p01
					AND i38.p01=i01.nr01 
					AND i38.p010=1    
					AND i01.p01=:i01_p01
					AND i38.p02=:i38_p02
					AND i01.p610=:i01_p610
					AND i01.p013<=:i01_p013    
				GROUP BY 
					i01.p01
				",
				$values
			);
			if (!$res) {
				throw new Exception('(01) [peg_invbalance_find_i07_p05]: ' . pegasus_mysql_error());
			}
			$rs = pegasus_fetch_assoc($res);
			return array(
				'ok' => 1,
				'data' => $rs['p05'] ? $rs['p05'] : 0,
				'error' => null
			);
		}
		//	SN
		if (
			pegasus_module_exists('serial')
			&& $flag_sn
			&& $i07_p11 != ''
		) {
			$values = array(
				'i01_p01' => $i07_p02,
				'i32_p02' => $i07_p11,
				'i01_p610' => $i07_p01,
				'i01_p013' => $date_to
			);
			$res = pegasus_query(
				"SELECT 
					sum(i01.p012*(i15.p03-i15.p04)) AS p05
				FROM 
					i01, i15, i32    
				WHERE i01.p05=i15.p01  
					AND i32.p00=i01.nr01  
					AND i32.p010=1    
					AND i01.p01=:i01_p01  
					AND i32.p02=:i32_p02
					AND i01.p610=:i01_p610 
					AND i01.p013<=:i01_p013
				GROUP BY
					i01.p01;
				",
				$values
			);
			if (!$res) {
				throw new Exception('(02)[peg_invbalance_find_i07_p05]: ' . pegasus_mysql_error());
			}
			$rs = pegasus_fetch_assoc($res);
			return array(
				'ok' => 1,
				'data' => $rs['p05'] ? $rs['p05'] : 0,
				'error' => null
			);
		}
		// Simple (No cs or lot or sn)
		$values = array(
			'i01_p01' => $i07_p02,
			'i01_p610' => $i07_p01,
			'i01_p013' => $date_to
		);
		$res = pegasus_query(
			"SELECT 
					SUM(i01.p03*i01.p012*(i15.p03-i15.p04)) AS p05      
				FROM
					i01, i15          
				WHERE i01.p05=i15.p01  
					AND i01.p01=:i01_p01
					AND i01.p610=:i01_p610
					AND i01.p013<=:i01_p013
				GROUP BY
					i01.p01
			",
			$values
		);
		if (!$res) {
			throw new Exception('(03)[peg_invbalance_find_i07_p05]: ' . pegasus_mysql_error());
		}
		$rs = pegasus_fetch_assoc($res);
		return array(
			'ok' => 1,
			'data' => $rs['p05'] ? $rs['p05'] : 0,
			'error' => null
		);
	} catch (Exception $e) {
		return array(
			'ok' => 0,
			'data' => null,
			'error' => $e->getMessage()
		);
	}
}
/**
 * Αντιγραφή Ειδών (a38) πακέτου (insert or update) στην απογραφή (i07)
 *
 * @param integer $a37_nr01		Πακέτο
 * @param integer $p01			Αποθήκη
 * @param integer $v_p			Θα ενημερωθεί το πεδίο
 * @param string $date_to		Έως και την ημερομηνία
 * @param integer $v_p_def		Η Κενή Στήλη Ποσότητας Σημαίνει
 * @param boolean $flag_1		Οι Ποσότητες θα Προστίθενται στις Υπάρχουσες
 * @param boolean $flag_2		Υπολογισμός Υπολοίπου Αποθήκης
 * @param boolean $flag_cs		Παρακολουθεί Χρώμα μέγεθος
 * @param boolean $flag_lot		Παρακολουθεί Παρτίδες
 * @param boolean $flag_sn		Παρακολουθεί SN
 * @return array
 */
function peg_invbalance_i07_update_from_a37(
	$a37_nr01 = 0,
	$p01 = 0,
	$v_p = 0,
	$date_to = '',
	$v_p_def = 0,
	$flag_1 = true,
	$flag_2 = false,
	$flag_cs = true,
	$flag_lot = true,
	$flag_sn = true
) {
	try {
		$f01_p021 = $_SESSION['f01_p021'];
		$f01_p022 = $_SESSION['f01_p022'];

		if ($p01 == '') {
			return array(
				'ok' => 0,
				'error' => $_SESSION['peg_dic_invbalance_provide_warehouse'],
				'msg' => $_SESSION['peg_dic_invbalance_provide_warehouse']
			);
		}
		$sql = peg_read_file('../invbalance_sql/a37p083.sql');
		$values = array(
			'a38_p00' => $a37_nr01
		);
		$package_items_rs = pegasus_query($sql, $values);
		$package_items = pegasus_fetchall($package_items_rs);
		foreach ($package_items as $item) {
			$where = "
				p01=:p01 
				AND p02=:p02
				AND p010=:p010
				AND p011=:p011
				AND pc01=:pc01
				AND pm01=:pm01
			";
			$values = array(
				'p01' => $p01,
				'p02' => $item['p01'],
				'p010' => $item['p07'],
				'p011' => $item['p08'],
				'pc01' => $item['p04'],
				'pm01' => $item['p05'],
			);
			$i07_nr01 = pegasus_mysql_printfld('i07', 'nr01', $where, $values);
			$i07_p05 = 0;
			if ($flag_2) {
				$i07_p05_resp = peg_invbalance_find_i07_p05(
					$item['p01'],
					$date_to,
					$p01,
					$item['p08'],
					$item['p07'],
					$item['p04'],
					$item['p05'],
					$flag_cs,
					$flag_lot,
					$flag_sn
				);
				if ($i07_p05_resp['ok'] != 1) {
					throw new Exception($i07_p05_resp['error']);
				}
				$i07_p05 = $i07_p05_resp['data'];
			}
			//	UPDATE
			if ($i07_nr01 > 0) {
				$values = array(
					'nr01' => $i07_nr01,
					'remfuser' => $_SESSION['username'],
					'p03' => $item['p03']
				);
				$p03 = '';
				if (($v_p == 0)) {
					$p03 = "p03=" . ($flag_1 ? "p03 + :p03" : ":p03") . ",";
				}
				if (($v_p == 1)) {
					$p03 = "p03_1=" . ($flag_1 ? "p03_1 + :p03" : ":p03") . ",";
				}
				$p05 = '';
				if ($flag_2) {
					$p05 = 'p05=:p05,';
					$values['p05'] = $i07_p05;
				}
				if (!pegasus_query(
					"UPDATE
					i07 SET
						$p03
						$p05
						p06=p03+p03_1-p05,
						remdate=curdate(),
						remftime=curtime(),
						remfuser=:remfuser
					WHERE
						nr01=:nr01
					",
					$values
				)) {
					throw new Exception('(04)SQL error: ' . pegasus_mysql_error());
				}
			}
			//	INSERT
			else {
				$i07_nr01 = pegasus_mysql_newrec('i07');
				$i25_p01 =isset($_SESSION['f01_pg12'])?$_SESSION['f01_pg12']:0;
				$values = array(
					'nr01' => $i07_nr01,
					'f01_p021' => $f01_p021,
					'f01_p022' => $f01_p022,
					'p01' => $p01,
					'p02' => $item['p01'],
					'vp02' => $item['p02'],
					'pc01' => $item['p04'],
					'pm01' => $item['p05'],
					'p010' => $item['p07'],
					'p011' => $item['p08'],
					'p03' => ($v_p == 0) ? $item['p03'] : 0,
					'p03_1' => ($v_p == 1) ? $item['p03'] : 0,
					'p05' => $i07_p05,
					'remuser' => $_SESSION['username'],
					'remfuser' => $_SESSION['username']
				);
				if (!pegasus_query(
					"INSERT 
						INTO i07
						(
							nr01,
							p01,
							p02,
							vp02,
							pc01,
							pm01,
							p010,
							p011,
							p03,
							p03_1,
							p05,
							p06,
							p04,
							remdate,
							remtime,
							remuser,
							remfdate,
							remftime,
							remfuser
						)
						VALUES
						(
							:nr01,
							:p01,
							:p02,
							:vp02,
							:pc01,
							:pm01,
							:p010,
							:p011,
							:p03,
							:p03_1,
							:p05,
							p03+p03_1-p05,
							peg_i00cost
							(
								:p02,			/*i00.pno*/
								:f01_p021,		/*period from*/
								:f01_p022,		/*period to*/
								:p01,			/*i16.p00 from*/
								:p01,			/*i16.p00 to*/
								$i25_p01,  		/*cost method*/
								0				/*_balance pno balance in _dto  used in FIFO If=0, function computes it*/
							),
							curdate(),
							curtime(),
							:remuser,
							curdate(),
							curtime(),
							:remfuser
						)
					",
					$values
				)) {
					throw new Exception('(05)SQL error: ' . pegasus_mysql_error());
				};
			}
		}
		return array(
			'ok' => 1,
			'error' => null,
			'msg' => $_SESSION['peg_dic_invbalance_package2balance_success']
		);
	} catch (Exception $e) {
		return array(
			'ok' => 0,
			'error' => $e->getMessage(),
			'msg' => $_SESSION['peg_dic_invbalance_package2balance_error']
		);
	}
}
/**
 * Προσθήκη εγγραφής στην απογραφή (i07)
 *
 * @param string $p01	Αποθήκη
 * @param string $p02	Είδος
 * @param string $pc01	Χρώμα
 * @param string $pm01	Μέγεθος
 * @param integer $p03	Ποσότητα Απογραφής
 * @return array
 */
function peg_invbalance_i07_add_item(
	$p01 = '',
	$p02 = '',
	$pc01 = '',
	$pm01 = '',
	$p03 = 0
) {
	try {
		if (!isset($p01) || $p01 == '') {
			return array(
				'ok' => 0,
				'error' => null,
				'msg' => $_SESSION['peg_dic_invbalance_failure'] . ': ' . $_SESSION['peg_dic_invbalance_provide_warehouse']
			);
		}
		if (!isset($p02) || $p02 == '') {
			return array(
				'ok' => 0,
				'error' => null,
				'msg' => $_SESSION['peg_dic_invbalance_failure'] . ': ' . $_SESSION['peg_dic_invbalance_provide_item']
			);
		}
		$insert = array(
			'nr01' => pegasus_mysql_newrec('i07'),
			'p01' => $p01,
			'p02' => $p02,
			'pc01' => $pc01,
			'pm01' => $pm01,
			'p03' => $p03
		);
		if (!pegasus_mysql_insert(
			'i07',
			array_keys($insert),
			array_values($insert),
			1,
			0,
			0,
			0
		)) {
			throw new Exception('SQL Error: ' . pegasus_mysql_error());
		}
		$msg = $_SESSION['peg_dic_invbalance_item_add'];
		$msg = str_replace("#ITEM#", $p02, $msg);
		return array(
			'ok' => 1,
			'msg' => $msg,
			'error' => null
		);
	} catch (Exception $e) {
		return array(
			'ok' => 0,
			'error' => $e->getMessage(),
			'msg' => $_SESSION['peg_dic_invbalance_failure'] . ': ' . $e->getMessage()
		);
	}
}
/**
 * Αναζήτηση είδους με βάση την [invoices_make_product_search_query]
 *
 * @param string $code
 * @return void
 */
function peg_invbalance_find_item($code = '')
{
	try {
		if (!function_exists('invoices_make_product_search_query')) {
			throw new Exception('code search function "invoices_make_product_search_query" is not available');
		}
		$search_fields = array();
		$query_arr = invoices_make_product_search_query($code, 0, '', 1, $search_fields);

		$query = $query_arr['sql'];
		$query_vals = $query_arr['values'];

		$items_res = pegasus_query('SELECT * FROM (' . $query . ') AS tt GROUP BY tt.v101 LIMIT 1', $query_vals);
		$item = pegasus_fetch_assoc($items_res);
		if (empty($item)) {
			throw new Exception($_SESSION['peg_dic_invbalance_item_not_found']);
		}
		$msg = $_SESSION['peg_dic_invbalance_item_found'];
		if (!empty($item['v172'])) {
			$msg = str_replace("##COLOR##", "(" . $item['v172'] . ")", $msg);
		}
		if (!empty($item['v173'])) {
			$msg = str_replace("##SIZE##", "(" . $item['v173'] . ")", $msg);
		}
		$msg = str_replace("##COLOR##", "", $msg);
		$msg = str_replace("##SIZE##", "", $msg);
		$msg = str_replace("##CODE##", $item['v101'], $msg);
		return array(
			'ok' => 1,
			'msg' => $msg,
			'error' => null,
			'data' => $item
		);
	} catch (Exception $e) {
		return array(
			'ok' => 0,
			'msg' => $e->getMessage(),
			'error' => $e->getMessage(),
			'data' => null
		);
	}
}
/**
 * Διαγράφουμε όλες τις κινήσεις που προέρχονται από την καταχώρηση της απογραφή για την δεδομένη ημερομηνία (έως - f01.p022) της απογραφής.
 *
 * @return array
 */
function peg_invbalance_delete_old_i01()
{
	try {
		$f01_p021 = $_SESSION['f01_p021'];
		$f01_p022 = $_SESSION['f01_p022'];
		$d_f = str_replace("-", "", $f01_p021);
		$d_t =  str_replace("-", "", $f01_p022);
		$peg_str2 = "$d_f-$d_t";
		$values = array(
			'np_dt' => $f01_p022,
			'peg_str2' => $peg_str2
		);
		// serial
		if (pegasus_module_exists('serial')) {
			$where = "
				i32.p010=1
				AND
				i32.p00 IN (
					SELECT 
						nr01
					FROM
						i01
					WHERE i01.p06=0 
					AND i01.p07=0 
					AND i01.pd101='i07' 
					AND i01.pd102=0 
					AND i01.p013=:np_dt
					AND substr(i01.pd01, 1, 17)=:peg_str2
				)
			";
			if (!pegasus_mysql_delete("i32", $where, 1, $values)) {
				throw new Exception("Delete serial ->SQL Error: " . pegasus_mysql_error());
			}
		}
		// lot
		if (pegasus_module_exists('lot')) {
			$where = "
				i38.p010=1
				AND
				i38.p01 IN (
					SELECT 
						nr01
					FROM
						i01
					WHERE i01.p06=0 
					AND i01.p07=0 
					AND i01.pd101='i07' 
					AND i01.pd102=0 
					AND i01.p013=:np_dt
					AND substr(i01.pd01, 1, 17)=:peg_str2
				)
			";
			if (!pegasus_mysql_delete("i38", $where, 1, $values)) {
				throw new Exception("Delete lot ->SQL Error: " . pegasus_mysql_error());
			}
		}
		// colorsize
		if (pegasus_module_exists('colorsize')) {
			$where = "
				i48.p01 IN (
					SELECT 
						nr01
					FROM
						i01
					WHERE i01.p06=0 
					AND i01.p07=0 
					AND i01.pd101='i07' 
					AND i01.pd102=0 
					AND i01.p013=:np_dt
					AND substr(i01.pd01, 1, 17)=:peg_str2
				)
			";
			if (!pegasus_mysql_delete("i48", $where, 1, $values)) {
				throw new Exception("Delete colorsize ->SQL Error: " . pegasus_mysql_error());
			}
		}
		//	i01
		$where = "
				i01.p06=0 
				AND i01.p07=0 
				AND i01.pd101='i07' 
				AND i01.pd102=0 
				AND i01.p013=:np_dt
				AND substr(i01.pd01, 1, 17)=:peg_str2
			";
		if (!pegasus_mysql_delete("i01", $where, 1, $values)) {
			throw new Exception("Delete i01 ->SQL Error: " . pegasus_mysql_error());
		}

		return array(
			'ok' => 1,
			'msg' => $_SESSION['peg_dic_invbalance_delete_inventory_old_balance'] . ' ' . $_SESSION['peg_dic_invbalance_executed_successfully'],
			'error' => null,
		);
	} catch (Exception $e) {
		return array(
			'ok' => 0,
			'msg' => $_SESSION['peg_dic_invbalance_caution'] . ' ' . $_SESSION['peg_dic_invbalance_delete_inventory_old_balance'] . ' ' . $_SESSION['peg_dic_invbalance_was_not_executed'],
			'error' => $e->getMessage(),
		);
	}
}
/**
 * Εισάγουμε την απογραφή (διαφορές) ως κινήσεις στους αντίστοιχους πινάκες
 *
 * @param integer $i15_p01	Κωδικός Κίνησης
 * @param boolean $flag_cs	Παρακολουθεί Χρώμα/Μέγεθος
 * @param boolean $flag_lot	Παρακολουθεί Παρτίδες
 * @param boolean $flag_sn	Παρακολουθεί S.N.
 * @return array
 */
function peg_invbalance_i07_update_i01(
	$i15_p01 = 501,
	$flag_cs = true,
	$flag_lot = true,
	$flag_sn = true
) {
	try {
		$cs_tmp_name = 'i07_cs_temp';
		$lot_tmp_name = 'i07_cs_temp';
		$sn_tmp_1_name = 'i07_sn_temp_1';
		$sn_tmp_2_name = 'i07_sn_temp_2';
		$f01_p021 = $_SESSION['f01_p021'];
		$f01_p022 = $_SESSION['f01_p022'];
		$d_f = str_replace("-", "", $f01_p021);
		$d_t =  str_replace("-", "", $f01_p022);
		$peg_str2 = "$d_f-$d_t";
		$peg_str1 = "Απογραφή ($peg_str2)";

		//	Υπάρχουν είδη με S.N. στην απογραφή που η ποσότητά τους είναι διαφορετική του 0 ή του 1.
		//	Δεν μπορεί να γίνει η ενημέρωση της αποθήκης.
		if (pegasus_mysql_printfld("i07", "nr01", "p011<>'' && p03 NOT IN (0, 1)") != 0) {
			$msg = $_SESSION['peg_dic_invbalance_caution'] . ' ';
			$msg .= $_SESSION['peg_dic_invbalance_update_inventory_with_balance'] . ' ';
			$msg .= $_SESSION['peg_dic_invbalance_update_sn_error'];
			return array(
				'ok' => 0,
				'msg' => $msg,
				'error' => $msg
			);
		}
		//	Θα πρέπει να επιλέξετε Κ.Κ. που κάνει εισαγωγή ποσότητας στην αποθήκη 
		if (pegasus_mysql_printfld("i15", "p03-p04", "p01=:p01", array('p01' => $i15_p01)) != 1) {
			$msg = $_SESSION['peg_dic_invbalance_caution'] . ' ';
			$msg .= $_SESSION['peg_dic_invbalance_update_inventory_with_balance'] . ' ';
			$msg .= $_SESSION['peg_dic_invbalance_update_i15_error'];
			return array(
				'ok' => 0,
				'msg' => $msg,
				'error' => $msg
			);
		}
		$replace = array(
			'{colorsize_temporary}' => $cs_tmp_name,
			'{lot_temporary}' => $lot_tmp_name,
			'{sn_temporary_1}' => $sn_tmp_1_name,
			'{sn_temporary_2}' => $sn_tmp_2_name
		);
		$values = array(
			'np_dt' => $f01_p022,
			'np_kk' => $i15_p01,
			'peg_str1' => $peg_str1,
			'peg_str2' => $peg_str2,
			'user_pswd' => $_SESSION['username']
		);
		// Βήμα 1: Update i01 από i07 που δεν έχουν colorsize,lot,serial 
		$sqlFilePath = '../invbalance_sql/i07p0911_1.sql';
		$resp = peg_invbalance_execute_queries(
			$sqlFilePath,
			$replace,
			$values
		);
		if ($resp['ok'] != 1) {
			throw new Exception("Step 1: " . $resp['error']);
		}
		//	Βήμα 2: Update i01 από i07 που έχουν colorsize
		if (pegasus_module_exists('colorsize') && $flag_cs) {
			$sqlFilePath = '../invbalance_sql/i07p0911_2.sql';
			$resp = peg_invbalance_execute_queries(
				$sqlFilePath,
				$replace,
				$values
			);
			if ($resp['ok'] != 1) {
				throw new Exception("Step 2: " . $resp['error']);
			}
		}
		//	Βήμα 3: Update i01 από i07 που έχουν lot
		if (pegasus_module_exists('lot') && $flag_lot) {
			$sqlFilePath = '../invbalance_sql/i07p0911_3.sql';
			$resp = peg_invbalance_execute_queries(
				$sqlFilePath,
				$replace,
				$values
			);
			if ($resp['ok'] != 1) {
				throw new Exception("Step 3: " . $resp['error']);
			}
			//	-- KATI DEN KATALABENW STO TOPIKO ME TO i11	--
		}
		//	Βήμα 4: Update i01 από i07 που έχουν serial
		if (pegasus_module_exists('serial') && $flag_sn) {

			$sqlFilePath = '../invbalance_sql/i07p0911_4.sql';
			$resp = peg_invbalance_execute_queries(
				$sqlFilePath,
				$replace,
				$values
			);
			if ($resp['ok'] != 1) {
				throw new Exception("Step 4: " . $resp['error']);
			}
			$peg_nnn = 1;
			$safe_to_rem = 50;
			$sql = peg_read_file('../invbalance_sql/i07p0911_41.sql');
			$sql = str_replace(array_keys($replace), array_values($replace), $sql);
			$sql = peg_invbalance_sql_module_check($sql);
			$sql_break = peg_invbalance_sql_break_query($sql);
			while ($peg_nnn != 0 && $safe_to_rem > 0) {
				$safe_to_rem--;
				foreach ($sql_break as $sql) {
					if (!pegasus_query($sql, $values)) {
						throw new Exception("Step 41 ->SQL Error: " . pegasus_mysql_error());
					}
				}
				$peg_nnn = pegasus_mysql_printfld($sn_tmp_2_name, 'nr01', 'nr01>0');
			}
			pegasus_query("DROP TABLE IF EXISTS $sn_tmp_1_name");
			pegasus_query("DROP TABLE IF EXISTS $sn_tmp_2_name");
		}
		return array(
			'ok' => 1,
			'msg' => $_SESSION['peg_dic_invbalance_update_inventory_with_balance'] . ' ' . $_SESSION['peg_dic_invbalance_executed_successfully'],
			'error' => null,
		);
	} catch (Exception $e) {
		return array(
			'ok' => 0,
			'msg' => $_SESSION['peg_dic_invbalance_caution'] . ' ' . $_SESSION['peg_dic_invbalance_update_inventory_with_balance'] . ' ' . $_SESSION['peg_dic_invbalance_was_not_executed'],
			'error' => $e->getMessage(),
		);
	}
}
/**
 * Συμπληρώνει τις ποσότητες  από κινήσεις που έχουν γίνει στο ημερομηνιακό όριο από nt_df έως και nt_dt
 *
 * @param string $nt_df
 * @param string $nt_dt
 * @return array
 */
function peg_invbalance_i07_update_quantity(
	$nt_df = '',
	$nt_dt = ''
) {
	try {
		$sqlFilePath = '../invbalance_sql/i07p0651.sql';
		$replace = array();
		$values = array(
			'user_pswd'	=> $_SESSION['username'],
			'nt_df'		=> $nt_df,
			'nt_dt'		=> $nt_dt
		);
		$resp = peg_invbalance_execute_queries(
			$sqlFilePath,
			$replace,
			$values
		);
		if ($resp['ok'] != 1) {
			throw new Exception('[peg_invbalance_i07_update_quantity] ' . $resp['error']);
		}
		return array(
			'ok' => 1,
			'msg' => $_SESSION['peg_dic_invbalance_update_quantity'] . ' ' . $_SESSION['peg_dic_invbalance_executed_successfully'],
			'error' => null,
		);
	} catch (Exception $e) {
		return array(
			'ok' => 0,
			'msg' => $_SESSION['peg_dic_invbalance_caution'] . ' ' . $_SESSION['peg_dic_invbalance_update_quantity'] . ' ' . $_SESSION['peg_dic_invbalance_was_not_executed'],
			'error' => $e->getMessage(),
		);
	}
}
/**
 * Διαγράφει όλες τις εγγραφές του i59 με p00 = f1.p022
 *
 * @return array
 */
function peg_invbalance_i59_delete_history()
{
	try {

		//$f01_p021 = $_SESSION['f01_p021'];
		$f01_p022 = $_SESSION['f01_p022'];
		if (!pegasus_mysql_delete('i59', 'p00=:p00', 1, array('p00' => $f01_p022))) {
			throw new Exception(pegasus_mysql_error());
		}
		return array(
			'ok' => 1,
			'msg' => $_SESSION['peg_dic_invbalance_deletion_process'] . ' ' . $_SESSION['peg_dic_invbalance_executed_successfully'],
			'error' => null,
		);
	} catch (Exception $e) {
		return array(
			'ok' => 0,
			'msg' => $_SESSION['peg_dic_invbalance_caution'] . ' ' . $_SESSION['peg_dic_invbalance_deletion_process'] . ' ' . $_SESSION['peg_dic_invbalance_was_not_executed'],
			'error' => $e->getMessage(),
		);
	}
}
/**
 * Κάνει update / Insert τον πινάκα i07 apo ton i50 με i59.p00=f01.p022
 *
 * @return array
 */
function peg_invbalance_i59_update_history()
{
	try {
		//$f01_p021 = $_SESSION['f01_p021'];
		$f01_p022 = $_SESSION['f01_p022'];
		$sqlFilePath = '../invbalance_sql/i07p06211.sql';
		$values = array(
			'user_pswd'	=> $_SESSION['username'],
			'np_dt'		=> $f01_p022
		);
		$replace = array();
		$resp = peg_invbalance_execute_queries(
			$sqlFilePath,
			$replace,
			$values
		);
		if ($resp['ok'] != 1) {
			throw new Exception('[peg_invbalance_i59_update_history] ' . $resp['error']);
		}
		return array(
			'ok' => 1,
			'msg' => $_SESSION['peg_dic_invbalance_update_history'] . ' ' . $_SESSION['peg_dic_invbalance_executed_successfully'],
			'error' => null,
		);
	} catch (Exception $e) {
		return array(
			'ok' => 0,
			'msg' => $_SESSION['peg_dic_invbalance_caution'] . ' ' . $_SESSION['peg_dic_invbalance_update_history'] . ' ' . $_SESSION['peg_dic_invbalance_was_not_executed'],
			'error' => $e->getMessage(),
		);
	}
}
/**
 * Υπολογίζει και κάνει update όλα τα κόστη για τα προϊόντα που είναι καταχωρημένα στον i07
 *
 * @param integer $i25_p01			Υπολογισμός Κόστους με
 * @param string $i16_p00_from		Από Αποθήκη
 * @param string $i16_p00_to		Έως Αποθήκη
 * @param boolean $flag_1			Υπολογίζει την τιμή κόστους όπου υπάρχει
 * @param boolean $flag_2			Του κάθε αποθηκευτικού χώρου ξεχωριστά
 * @param string $i16_p00_2_from	Από Αποθήκη (Συνολικά από τις κινήσεις των αποθηκών)
 * @param string $i16_p00_2_to		Έως Αποθήκη (Συνολικά από τις κινήσεις των αποθηκών)
 * @param  boolean $return_sum_only	Δεν καταχωρεί της τιμές αλλά επιστρέφει μόνο ένα ενημερωτικό sting με τα sum values ανά αποθηκευτικό
 * @return void
 */
function peg_invbalance_i07_update_price(
	$i25_p01 = 0,
	$i16_p00_from = '',
	$i16_p00_to = '',
	$flag_1 = false,
	$flag_2 = true,
	$i16_p00_2_from = '',
	$i16_p00_2_to = '',
	$return_sum_only = false
) {
	try {
		$f01_p021 = $_SESSION['f01_p021'];
		$f01_p022 = $_SESSION['f01_p022'];

		$_invfrom = $flag_2 ? '' : $i16_p00_2_from;
		$_invto = $flag_2 ? '' : $i16_p00_2_to;

		$i07_where = array('1=1');
		$i07_values = array(
			"f01_p021"			=> $f01_p021,
			"f01_p022"			=> $f01_p022,
			"_invfrom"			=> $_invfrom,
			"_invto"			=> $_invto,
			"i25_p01"			=> $i25_p01,
			//"_balance"			=> $flag_1 ? 1 : 0
			"_balance"=>0
		);
		if ($i16_p00_from != '') {
			array_push($i07_where, 'i07.p01>=:p01_from');
			$i07_values['p01_from'] = $i16_p00_from;
		}
		if ($i16_p00_to != '') {
			array_push($i07_where, 'i07.p01<=:p01_to');
			$i07_values['p01_to'] = $i16_p00_to;
		}
		/*
			peg_i00cost
			(
				_pno   i00.pno
				_dfrom period from
				_dto   period to
				_invfrom i16.p00 from
				_invto   i16.p00 to
				_method  cost method
				_balance pno balance in _dto  used in FIFO If=0, function computes it
			)
		*/
		if ($return_sum_only) {
			$ret_rs = pegasus_query("SELECT 
				SUM(peg_i00cost(
						i07.p02, 
						:f01_p021, 
						:f01_p022, 
						:_invfrom, 
						:_invto, 
						:i25_p01, 
						:_balance
					) )AS new_p04_sum,
					i16.p01
				FROM
					i07,i16
				WHERE
					i16.p00=i07.p01
				AND
					" . implode(' AND ', $i07_where) . "
				GROUP BY
					i16.p00
			", $i07_values);
			$ret = pegasus_fetchall($ret_rs);
			$msg = '<b>' . $_SESSION['peg_dic_invbalance_inventory_balance_sum'] . ":</b><br/>";
			$sum = 0;
			$tha = '';
			if ($_SESSION['cor000_decimal_char'] == ',') {
				$tha = '.';
			}
			foreach ($ret as $v) {
				$sum += $v['new_p04_sum'];
				$msg .= $v['p01'] . ' = ' . number_format($v['new_p04_sum'], 2, $_SESSION['cor000_decimal_char'], $tha) . "&euro;<br/>";
			}
			$msg .= "<hr>";
			$msg .= '<b>' . $_SESSION['peg_dic_invbalance_total_inventory_balance_costs'] . " = ";
			$msg .= number_format($sum, 2, $_SESSION['cor000_decimal_char'], $tha) . "&euro;</b>";

			return array(
				'ok' => 1,
				'msg' => $msg,
				'error' => null,
			);
		}
		$ret = pegasus_query("UPDATE i07 SET
		p04=peg_i00cost(
				i07.p02, 
				:f01_p021, 
				:f01_p022, 
				:_invfrom, 
				:_invto, 
				:i25_p01, 
				:_balance
			)
		WHERE " . implode(' AND ', $i07_where), $i07_values);
		if (!$ret) {
			throw new Exception(pegasus_mysql_error());
		}
		return array(
			'ok' => 1,
			'msg' => $_SESSION['peg_dic_invbalance_update_price'] . ' ' . $_SESSION['peg_dic_invbalance_executed_successfully'],
			'error' => null,
		);
	} catch (Exception $e) {
		return array(
			'ok' => 0,
			'msg' => $_SESSION['peg_dic_invbalance_caution'] . ' ' . $_SESSION['peg_dic_invbalance_update_price'] . ' ' . $_SESSION['peg_dic_invbalance_was_not_executed'],
			'error' => $e->getMessage(),
		);
	}
}
/**
 * Διαγραφή πινάκα απογραφής i07 και μηδενισμός μετρητή του στον p75 
 *
 * @return array
 */
function peg_invbalance_i07_truncate()
{
	try {
		//if (!pegasus_query('TRUNCATE TABLE i07')) {
		//throw new Exception(pegasus_mysql_error());
		//}
		//	Θέλουμε τον peg_del για το PIM
		if (!pegasus_mysql_delete('i07', '1=1', 1)) {
			throw new Exception(pegasus_mysql_error());
		}
		//Reset nr01 counter to 0
		if (!pegasus_mysql_update('p75', array('p010'), array(0), "p01=:p01", 0, 1, 0, array('p01' => 'i07'))) {
			throw new Exception(pegasus_mysql_error());
		}
		return array(
			'ok' => 1,
			'msg' => $_SESSION['peg_dic_invbalance_deletion_process'] . ' ' . $_SESSION['peg_dic_invbalance_executed_successfully'],
			'error' => null,
		);
	} catch (Exception $e) {
		return array(
			'ok' => 0,
			'msg' => $_SESSION['peg_dic_invbalance_caution'] . ' ' . $_SESSION['peg_dic_invbalance_deletion_process'] . ' ' . $_SESSION['peg_dic_invbalance_was_not_executed'],
			'error' => $e->getMessage(),
		);
	}
}
/**
 * Συντάσσει και καταχωρεί τα είδη απογραφής στον i07
 *
 * @param string $i00_pno_from  Από Είδος
 * @param string $i00_pno_to    Έως Είδος
 * @param string $i16_p00_from  Από Αποθήκη
 * @param string $i16_p00_to    Έως Αποθήκη
 * @param boolean $flag_01      Οι Ποσότητες Απογραφής να Ενημερωθούν με το Υπόλοιπο της Αποθήκης
 * @param boolean $flag_02      Να Διαγραφούν οι καταχωρήσεις που υπάρχουν ήδη στην Απογραφή
 * @param boolean $flag_03      Να βρεθεί το Υπόλοιπο μόνο των καταχωρημένων στην απογραφή ειδών
 * @param boolean $flag_04      Να βρεθούν όλα τα ενεργά είδη χωρίς έλεγχο υπολοίπου
 * @param boolean $flag_i16     Υπολογισμός Κόστους Ανά Χώρο
 * @param boolean $flag_i48     Εύρεση Υπολοίπου Ανά Χρώμα/Μέγεθος
 * @param boolean $flag_i38     Εύρεση Υπολοίπου ανά Παρτίδες
 * @param boolean $flag_i32     Εύρεση Υπολοίπου ανά SN
 * @param string  $groups
 * @return array
 */
function peg_invbalance_i07_set_records(
	$i00_pno_from = '',
	$i00_pno_to = '',
	$i16_p00_from = '',
	$i16_p00_to = '',
	$flag_01 = false,
	$flag_02 = false,
	$flag_03 = false,
	$flag_04 = false,
	$flag_i16 = true,
	$flag_i48 = true,
	$flag_i38 = true,
	$flag_i32 = true,
	$container_id=''
) {
	try {
		
		$group=pegasusGetGlobalVar('_i2_d04_group_data_' . $container_id);
		if(!is_array($group) || empty($group)) {
			$group=array('0,0,0,0');
		}
		$group_in=pegasus_mysql_create_in($group,'groupconcat');

		$tmp_tbl = 'i07_tmp';
		$f01_p021 = $_SESSION['f01_p021'];
		$f01_p022 = $_SESSION['f01_p022'];
		$peg_str1 = ' t1.t_poseis<>t1.t_posex ';
		//	Να βρεθεί το Υπόλοιπο μόνο των καταχωρημένων στην απογραφή ειδών
		if ($flag_03) {
			$peg_str1 = ' i07.nr01 IS NOT NULL ';	//	Όλα τα καταχωρημένα είδη
		}
		$sql_select = peg_read_file('../invbalance_sql/i07p0710.sql');
		$replace = array(
			'{tmp_tbl}'					=> $tmp_tbl,
			'{temporary_select}'		=> $sql_select,
			'{nt_where}'				=> ' i00.nr01>=0 ',
			'{np_col}'					=> $flag_i48 ? 1 : 0,
			'{np_lot}'					=> $flag_i38 ? 1 : 0,
			'{np_sn}'					=> $flag_i32 ? 1 : 0,
			'{np_pos}'					=> $flag_01 ? 1 : 0,
			'{peg_str1}'				=> $peg_str1,
		);
		$values = array(
			'f01_p021'      => $f01_p021,
			'f01_p022'      => $f01_p022,
			'i00_pno_from'  => $i00_pno_from,
			'i00_pno_to'    => $i00_pno_to,
			'i16_p00_from'  => $i16_p00_from,
			'i16_p00_to'    => $i16_p00_to,
			'user_pswd'		=> $_SESSION['username']
		);
		// Ομαδοποίηση που συμμετέχει στην αναζήτηση
		$replace['{groupconcat}']=' AND groupconcat IN ('.$group_in['sql'].')';
		$values=array_merge($values,$group_in['sqlParams']);
		//  Να Διαγραφούν οι καταχωρήσεις που υπάρχουν ήδη στην Απογραφή
		if ($flag_02) {
			$delete = peg_invbalance_i07_truncate();
			if ($delete['ok'] != 1) {
				throw new Exception($delete['error']);
			}
		}
		//$sql_select = str_replace(array_keys($replace), array_values($replace), $sql_select);
		//print_r(pegasus_fetchall(pegasus_query($sql_select,$values)));
		//print pegasus_mysql_error();
		//print pegasus_replace_values_in_sql($sql_select,$values);
		//die('Test Select');
		$sqlFilePath = '../invbalance_sql/i07p0710_1.sql';
		$resp = peg_invbalance_execute_queries(
			$sqlFilePath,
			$replace,
			$values
		);
		if ($resp['ok'] != 1) {
			throw new Exception('[peg_invbalance_i07_set_records] ' . $resp['error']);
		}
		// Φέρνει και προσθέτει όλα τα είδη τα οποία δεν έχουν κάποια κινήσει
		if ($flag_04) {
			$sqlFilePath = '../invbalance_sql/i07p0710_3.sql';
			$replace = array(
				'{nt_where}'    => 'i00.nr01>=0',
				'{np_col}'      => $flag_i48 ? 1 : 0,
				'{np_lot}'      => $flag_i38 ? 1 : 0,
				'{np_sn}'       => $flag_i32 ? 1 : 0
			);
			$values = array(
				'f01_p021'      => $f01_p021,
				'f01_p022'      => $f01_p022,
				'i00_pno_from'  => $i00_pno_from,
				'i00_pno_to'    => $i00_pno_to,
				'i16_p00_from'  => $i16_p00_from,
				'i16_p00_to'    => $i16_p00_to,
				'user_pswd'		=> $_SESSION['username']
			);
			// Ομαδοποίηση που συμμετέχει στην αναζήτηση
			$replace['{groupconcat}']=' groupconcat IN ('.$group_in['sql'].')';
			$values=array_merge($values,$group_in['sqlParams']);

			$resp = peg_invbalance_execute_queries(
				$sqlFilePath,
				$replace,
				$values
			);
			if ($resp['ok'] != 1) {
				throw new Exception('[peg_invbalance_i07_set_records] ' . $resp['error']);
			}
		}
		$peg_invbalance_i07_update_price_resp = peg_invbalance_i07_update_price(
			0,
			$i16_p00_from,
			$i00_pno_to,
			false,
			$flag_i16,	//	 Υπολογισμός Κόστους Ανά Χώρο
			$i16_p00_from,
			$i00_pno_to,
			false
		);
		if ($peg_invbalance_i07_update_price_resp['ok'] != 1) {
			throw new Exception($peg_invbalance_i07_update_price_resp['error']);
		}
		return array(
			'ok' => 1,
			'msg' => $_SESSION['peg_dic_invbalance_finding_records_process '] . ' ' . $_SESSION['peg_dic_invbalance_executed_successfully'],
			'error' => null,
			'doc' => null
		);
	} catch (Exception $e) {
		return array(
			'ok' => 0,
			'msg' => $_SESSION['peg_dic_invbalance_caution'] . ' ' . $_SESSION['peg_dic_invbalance_finding_records_process'] . ' ' . $_SESSION['peg_dic_invbalance_was_not_executed'],
			'error' => $e->getMessage(),
			'doc' => null
		);
	}
}
/**
 * Αποθηκεύει της ημερομηνίες απογραφής στον f01 και κάνει update το session.
 *
 * @param string $f01_p021
 * @param string $f01_p022
 * @return array
 */
function peg_invbalance_f01_set_date_range(
	$f01_p021 = '',
	$f01_p022 = '',
	$f01_nr01 = 1
) {

	try {
		$data=array(
			'f01_p021'	=> $f01_p021,
			'f01_p022'	=> $f01_p022,
		);

		if(empty($data['f01_p021']) || $data['f01_p021']<= '0100-01-01') {
			throw new Exception($_SESSION['peg_dic_invbalance_f01_p021_empty_conf'],1);
		}
		if(empty($data['f01_p022']) || $data['f01_p022']<= '0100-01-01') {
			throw new Exception($_SESSION['peg_dic_invbalance_f01_p022_empty_error'],1);
		}
		if($data['f01_p021'] > date('Y-m-d')) {
			throw new Exception($_SESSION['peg_dic_invbalance_f01_p021_afterdate'],1);
		}
		if($data['f01_p022'] > date('Y-m-d')) {
			throw new Exception($_SESSION['peg_dic_invbalance_f01_p022_afterdate'],1);
		}
		if($data['f01_p022'] < $data['f01_p021']) {
			throw new Exception($_SESSION['peg_dic_invbalance_date_range_error'],1);
		}
		$f01_update = array(
			'p021' => $data['f01_p021'],
			'p022' => $data['f01_p022'],
		);
		$resp = pegasus_mysql_update('f01', array_keys($f01_update), array_values($f01_update), 'nr01=:nr01', 0, 1, 0, array('nr01' => 1));
		if (!$resp) {
			throw new Exception(pegasus_mysql_error());
		}
		pegasusWriteSession('f01');
		pegasusReadSession('f01');
		return array(
			'ok' => 1,
			'doc' => $data,
			'error' => null,
			'msg' => 'Success'
		);
	} catch (Exception $e) {
		$msg = "Error";
		if($e->getCode()==1) {
			$msg=$e->getMessage();
		}
		return array(
			'ok' => 0,
			'doc' => array(),
			'error' => $e->getMessage(),
			'msg' => $msg
		);
	}
}
/**
 * Εκτελεί, αφού πρώτα τα ελέγξει, ένα σύνολο από ερωτήματα που βρίσκονται στο αρχείο (sqlFile)
 *
 * @param string $sqlFile
 * @param array $reaplce
 * @param array $values
 * @return array
 */
function peg_invbalance_execute_queries(
	$sqlFile = '',
	$replace = array(),
	$values = array()
) {
	try {
		$resp = peg_invbalance_prepare_queries($sqlFile, $replace);
		if ($resp['ok'] != 1) {
			throw new Exception($resp['error']);
		}
		foreach ($resp['sqls'] as $sql) {
			if (!pegasus_query($sql, $values)) {
				throw new Exception(pegasus_mysql_error());
			}
		}
		return array(
			'ok' => 1,
			'error' => null
		);
	} catch (Exception $e) {
		return array(
			'ok' => 0,
			'error' => $e->getMessage()
		);
	}
}
/**
 * Επιστρέφει ένα array με ερωτήματα sql αφού τα έχει σπάσει σε κομμάτια και τα έχει ελέγξει για τα module.
 *
 * @param string $sqlFile
 * @param array $reaplce
 * @return void
 */
function peg_invbalance_prepare_queries( //prepare_queries
	$sqlFile = '',
	$replace = array()
) {
	try {
		$ret = array();
		$sql = peg_read_file($sqlFile);
		if (!empty($replace)) {
			$sql = str_replace(array_keys($replace), array_values($replace), $sql);
		}
		$sql = peg_invbalance_sql_module_check($sql);
		$ret = peg_invbalance_sql_break_query($sql);

		return array(
			'ok' => 1,
			'sqls' => $ret,
			'error' => null
		);
	} catch (Exception $e) {
		return array(
			'ok' => 0,
			'sqls' => array(),
			'error' => $e->getMessage()
		);
	}
}
/**
 * Επιστρέφει ένα array από επιμέρους mysql query 
 *
 * @param string $sql
 * @return array
 */
function peg_invbalance_sql_break_query(
	$sql
) {
	$ret = array();
	$separator = '/*PEG_QUERY_STEP_BREAK*/';
	$exp = explode($separator, $sql);
	foreach ($exp as $v) {
		$v = trim($v);
		if ($v != '') {
			array_push($ret, $v);
		}
	}
	return $ret;
}
/**
 * Προσθέτει σε σχόλια κομμάτια SQL τα οποία εξαρτώνται από το αν υπάρχουν 
 * τα module τους ή όχι και αυτά τα module δεν υπάρχουν σε αυτήν την εφαρμογή.
 * *   colorsize:    / * MOD_START_COLORSIZE * /   -   / * MOD_END_ COLORSIZE* / 
 * *   serial:
 * *   lot:
 *
 * @param string $sql
 * @return string
 */
function peg_invbalance_sql_module_check(
	$sql
) {
	$close = array();
	if (!pegasus_module_exists('colorsize')) {
		$close[] = 'COLORSIZE';
	}
	if (!pegasus_module_exists('serial')) {
		$close[] = 'SERIAL';
	}
	if (!pegasus_module_exists('lot')) {
		$close[] = 'LOT';
	}
	foreach ($close as $v) {
		$str_start = "/*MOD_START_$v*/";
		$str_end = "/*MOD_END_$v*/";
		$cnt = 50;
		while ($cnt > 0) {
			$cnt--;
			$from = strpos($sql, $str_start);
			$to = strpos($sql, $str_end);
			if ($from === false || $to === false) {
				break;
			}
			$sql = trim(substr($sql, 0, $from) . substr($sql, $to + strlen($str_end)));
		}
		//$sql = str_replace("/*MOD_START_$v*/", "/*MOD_$v", $sql);
		//$sql = str_replace("/*MOD_END_$v*/", "MOD_END_$v*/", $sql);
	}
	return $sql;
}
/**
 *
 * @param array $data
 * @param string $mmnr01
 * @param string $mnr01
 * @param string $_d
 * @param string $container_id
 * @return array $data
 */
function peg_invbalance_invbalance_d_initialize(
	$data = array(),
	$mmnr01 = '',
	$mnr01 = '',
	$_d = '',
	$container_id = ''
) {
	if (empty($data['nr01'])) {
		$data['nr01'] = 1;
	}
	$data['p021'] = $_SESSION['f01_p021'];
	$data['p022'] = $_SESSION['f01_p022'];
	return $data;
}
function peg_invbalance_i07_d_onchange(
	$data=array(), 
	$permDeny=array(), 
	$mmnr01='', 
	$checkOnlyPerm=false
) {
	//	Υπολογισμός Διαφοράς
	$data['p06'] = $data['p03'] + $data['p03_1'] - $data['p05'];
	return array (
		'data'		=> $data,
		'permDeny'	=> $permDeny
	);
}
function peg_invbalance_i07_d_initialize(
	$data = array(),
	$mmnr01 = '',
	$mnr01 = '',
	$_d = '',
	$container_id = ''
) {
	//	Υπολογισμός Συνολικού Κόστους
	$data['vp04'] = ($data['p03'] + $data['p03_1']) * $data['p04'];
	return $data;
}
/**
 *
 * @param array $data
 * @param string $mmnr01
 * @param string $mnr01
 * @param string $_d
 * @param string $container_id
 * @return array $data
 */
function peg_invbalance__i2_d4_initialize(
	$data = array(),
	$mmnr01 = '',
	$mnr01 = '',
	$_d = '',
	$container_id = ''
) {
	$data['f01_p021'] = $_SESSION['f01_p021'];
	$data['f01_p022'] = $_SESSION['f01_p022'];
	$data['flag_i16'] = 1;
	$data['flag_i48'] = 0;
	$data['flag_i38'] = 0;
	$data['flag_i32'] = 0;
	$data['flag_i48_hidden'] = 2;
	$data['flag_i38_hidden'] = 2;
	$data['flag_i32_hidden'] = 2;
	if (pegasus_module_exists('colorsize')) {
		$data['flag_i48'] = 1;
		$data['flag_i48_hidden'] = 0;
	}
	if (pegasus_module_exists('lot')) {
		$data['flag_i38'] = 1;
		$data['flag_i38_hidden'] = 0;
	}
	if (pegasus_module_exists('serial')) {
		$data['flag_i32'] = 1;
		$data['flag_i32_hidden'] = 0;
	}
	//Preset i00 from-to
	$i00_pno_from = pegasus_mysql_printfld("i00", "pno", " p202=0 ORDER BY pno ASC");
	$i00_pno_to = pegasus_mysql_printfld("i00", "pno", " p202=0 ORDER BY pno DESC");
	$data['i00_pno_from'] = $i00_pno_from;
	$data['i00_pno_to'] = $i00_pno_to;
	//Preset i16 from-to
	$i16_p00_from = pegasus_mysql_printfld("i16", "p00", " 1=1 ORDER BY p00 ASC");
	$i16_p00_to = pegasus_mysql_printfld("i16", "p00", " 1=1 ORDER BY p00 DESC");
	$data['i16_p00_from'] = $i16_p00_from;
	$data['i16_p00_to'] = $i16_p00_to;

	$sql=peg_read_file('../invbalance_sql/_i201.sql');
	pegasusSetGlobalVar(
		$container_id . '_query_grid01___i2_d04',
		$sql
	);
	return $data;
}
function peg_invbalance__i2_d5_initialize(
	$data = array(),
	$mmnr01 = '',
	$mnr01 = '',
	$_d = '',
	$container_id = ''
) {
	$data['f01_p021'] = $_SESSION['f01_p021'];
	$data['f01_p022'] = $_SESSION['f01_p022'];
	//Preset i16 from-to
	$i16_p00_from = pegasus_mysql_printfld("i16", "p00", " 1=1 ORDER BY p00 ASC");
	$i16_p00_to = pegasus_mysql_printfld("i16", "p00", " 1=1 ORDER BY p00 DESC");
	$data['i16_p00_from'] = $i16_p00_from;
	$data['i16_p00_to'] = $i16_p00_to;

	//$i25_p01 = pegasus_mysql_printfld("i25", "p01", " 1=1 ORDER BY p00 ASC");
	$i25_p01 =$_SESSION['f01_pg12'];

	$data['i25_p01'] = $i25_p01;
	$data['flag_2'] = 1;
	$data['i16_p00_2_from'] = $i16_p00_from;
	$data['i16_p00_2_to'] = $i16_p00_to;
	return $data;
}
function peg_invbalance__i2_d11_initialize(
	$data = array(),
	$mmnr01 = '',
	$mnr01 = '',
	$_d = '',
	$container_id = ''
) {
	$data['f01_p021'] = $_SESSION['f01_p021'];
	$data['f01_p022'] = $_SESSION['f01_p022'];

	return $data;
}
function peg_invbalance_innbalace_02_d_initialize(
	$data = array(),
	$mmnr01 = '',
	$mnr01 = '',
	$_d = '',
	$container_id = ''
) {
	$data['f01_p021'] = $_SESSION['f01_p021'];
	$data['f01_p022'] = $_SESSION['f01_p022'];
	// grid where
	pegasusSetGlobalVar(
		$container_id . '_where_grid_invbalace_02_d',
		array(
			'sql' => "
				i01.p06=0
				AND i01.p07=0
				AND i01.pd101='i07'
				AND i01.pd102=0
				AND i01.p013=:i01_p013
				AND substr(i01.pd01, 1, 17)=:i01_pd01
			",
			'sqlParams' => array(
				"i01_p013" => $data['f01_p022'],
				"i01_pd01" => str_replace("-", "", $data['f01_p021']) . '-' . str_replace("-", "", $data['f01_p022'])
			)
		)
	);
	return $data;
}
function peg_invbalance__i2_d6_initialize(
	$data = array(),
	$mmnr01 = '',
	$mnr01 = '',
	$_d = '',
	$container_id = ''
) {
	$data['f01_p021'] = $_SESSION['f01_p021'];
	$data['f01_p022'] = $_SESSION['f01_p022'];
	$data['flag_cs'] = 1;
	$data['flag_lot'] = 1;
	$data['flag_sn'] = 1;
	$data['i15_p01'] = 501;	//	Εισαγωγή Απογραφή	
	return $data;
}
function peg_invbalance_invbalance_03_d_initialize(
	$data = array(),
	$mmnr01 = '',
	$mnr01 = '',
	$_d = '',
	$container_id = ''
) {
	$data['info'] = "";
	$data['qua'] = 1;
	$data['p01'] = $_SESSION['cor003_p105'];

	return $data;
}
function peg_invbalance__i2_d12_initialize(
	$data = array(),
	$mmnr01 = '',
	$mnr01 = '',
	$_d = '',
	$container_id = ''
) {
	$data['a37_nr01'] = $_REQUEST['a37_nr01'];
	$data['p01'] = $_SESSION['cor003_p105'];
	$data['v_p'] = 0;
	$data['v_p_def'] = 0;
	$data['flag_1'] = 1;
	$data['flag_cs'] = 1;
	$data['flag_lot'] = 1;
	$data['flag_sn'] = 1;

	$sql = peg_read_file('../invbalance_sql/a37p083.sql');
	pegasusSetGlobalVar($container_id . '_query__i2d12_grid', array(

		'sql' => $sql,
		'sqlParams' =>  array('a38_p00' => $data['a37_nr01'])
	));
	return $data;
}
function peg_invbalance_invbalance_04_d_initialize(
	$data = array(),
	$mmnr01 = '',
	$mnr01 = '',
	$_d = '',
	$container_id = ''
) {
	try {
		$f01_p021=$_SESSION['f01_p021'];
		$f01_p022=$_SESSION['f01_p022'];
		if(empty($f01_p021)) {
			$f01_p021='0100-01-01';
		}
		if(empty($f01_p022)) {
			$f01_p022='0100-01-01';
		}
		$data['f01_p021'] = $f01_p021;
		$data['f01_p022'] = $f01_p022;

		return $data;
	}
	catch(Exception $e) {
		$data['permDeny'] = 1;
		$data['permDenyMessage'] = $e->getMessage();
		return $data;
	}
}
function invbalance_after_update()
{
	pegasus_mysql_use('select rel, ver from p55 where p00="invbalance"', $version);
	if ($version['ver'] == 1 && $version['rel'] <= 28) {
		if(file_exists('../invbalance01/invbalance_invbalance_d03_grid_where.php')) {
			unlink('../invbalance01/invbalance_invbalance_d03_grid_where.php');
		}
	}
}