function invcust_change_katestos_fpa(container_id) {
	invoices_change_katestos_fpa(container_id, 'a55');
}

function invcust_customer_change(container_id) {
	invoices_p03_change(container_id, 'a55');
}

function invcust_find_invoice_data(container_id, check_or_set_p03 = '') {
	invoices_find_invoice_data(container_id, 'a55', check_or_set_p03);
}

function invcust_calculate_total(container_id) {
	return invoices_calculate_total(container_id, 'a55');
}

function invcust_change_xeirografo(container_id) {
	var container_id_main = pegGetContainer_id_d(container_id, 'a55_d', '', 'a55_d');
	var container_id_stoixeia = pegGetContainer_id_d(container_id, 'a55_d4', '', 'a55_d');
	var new_p08 = pegGetVal('p08', container_id_stoixeia);
	invoices_p08_change(container_id_main, 'a55', new_p08);
}

//Καλειται απο την "core_pegPrintToPDF" (browse_d005)
function invcust_a55_printToPDF(p85_nr01, params){
	//console.info(arguments.callee.name);
	
	if(params.dias_main_table=="a55" && typeof (ca_server_print_a55)==="function"){
		ca_server_print_a55(params.dias_container_id, p85_nr01, params.dias_main_table, params.dias_main_nr01);
	}else{
		invcust_print_invoice(params.dias_container_id, params.dias_main_nr01, -1, 0, p85_nr01);
	}
}

//Καλειται απο οπουδηποτε στο module χρειαζεται εκτυπωση
function invcust_printToPDF(container_id, p85_nr01, table, nr01, numOfCopies){
	//console.info(arguments.callee.name);
	//console.warn(numOfCopies);

	params = {};
	params['dias_container_id'] = container_id;
	params['dias_main_table'] 	= table;

	// params['a55_nr01'] 		  	= a55_nr01;
	// params['dias_main_nr01']  	= a55_nr01;

	// for (let index = 0; index < numOfCopies; index++) {
	// 	params['ca_server_copy'] = index;
	// 	pegPrintToPDF(p85_nr01, params);
	// }

	var nr01_in  	 = '';
	var p85_input_in = '';
	for (let index = 0; index<numOfCopies; index++) {
		if(nr01_in!=''){ nr01_in += ','; }
		nr01_in += nr01;
		
		if(p85_input_in!=''){ p85_input_in += ','; }
		p85_input_in += 'inv_copy:'+index;
		//p85_input_in += '#'+'ca_server_copy:'+index;
	}

	params[table+'_nr01'] 		      = nr01_in;
	params['dias_main_nr01'] 		  = nr01_in;
	params['form_to_print_p85_input'] = p85_input_in;	
	
	pegPrintToPDF(p85_nr01, params);

	return;
}


//Καλειται όταν κανουμε καταχώρηση & εκτυπωση ή απο την οθόνη a55_d (toolbar)
var invcust_print_invoice_ajax = '';
function invcust_print_invoice(container_id, a55_nr01, numOfCopies, a55_p05, p85_nr01) {
	//console.info(arguments.callee.name);

	if (numOfCopies === undefined || numOfCopies == 0) {
		numOfCopies = 1;
	}

	var params = {};
	params.a55_nr01 	= a55_nr01;
	params.a55_p05  	= a55_p05;
	params.numOfCopies 	= numOfCopies;
	params.p85_nr01  	= p85_nr01;

	if (invcust_print_invoice_ajax != '') {
		if (invcust_print_invoice_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invcust_print_invoice_ajax);
		}
	}
	invcust_print_invoice_ajax = pegAjaxDefer('/' + main_path + '/invcust01/check_print_forms.php', params, function (json_data) {
		if (json_data.p85_nr01>0) {
			invcust_printToPDF(container_id, json_data.p85_nr01, 'a55', params.a55_nr01, json_data.numOfCopies);			
		} else {
			peg_windowShow_d('', 'browse_d005', 'core', '', '', 0, '', '', {
				display_type: 'grid',
				tp: 'grid',
				dias_module: 'invcust',
				dias_main_table: 'a55',
				dias_main_nr01: params.a55_nr01,
				dias_container_id: container_id
			},
			null,
			null,
			null,
			null,
			'tablet');
		}

	});

}
var invcust_change_plate_number_ajax = '';
function invcust_change_plate_number(container_id, cust_vehicle, $mode="") {
	var params = {};
	params.cust_vehicle = cust_vehicle;

	if (invcust_change_plate_number_ajax != '') {
		if (invcust_change_plate_number_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invcust_change_plate_number_ajax);
		}
	}
	invcust_change_plate_number_ajax = pegAjaxDefer('/' + main_path + '/invcust01/invcust_change_plate_number.php', params, function (json_data) {
		if(json_data.ok==1){
			pegSetVal($mode+'p702', container_id, json_data.plate_nmbr);
		}

	});

}

var invcust_a55_d_afterDraw_ajax = '';
function invcust_a55_d_afterDraw_listeners(container_id) {


	invoices_main_invoice_screen_after_draw(container_id);
	var p03Field = pegGetCmp(container_id, 'p03');
	var p04Field = pegGetCmp(container_id, 'p04');
	var p05Field = pegGetCmp(container_id, 'p05');
	var p701Field = pegGetCmp(container_id, 'p701');
	var p01Field  = pegGetCmp(container_id, 'p01');
	var p06Field  = pegGetCmp(container_id, 'p06');

	p03Field.on('change', function (me, e) {
		invcust_customer_change(container_id);
		invoices_update_top_fldcont_title(container_id);
	});

	p04Field.on('change', function (me, e) {
		invcust_customer_change(container_id);
	});

	p05Field.on('change', function (me, e) {
		invcust_find_invoice_data(container_id,'check_for_new_p03');
		invoices_update_top_fldcont_title(container_id);	
	});

	p701Field.on('change',function(me,e){
		invoices_refresh_invoice_num(container_id,'a55');

		var container_id_a55_d4 = pegGetContainer_id_d(container_id, 'a55_d4', '', 'a55_d');
		if(pegGetVal('p08', container_id_a55_d4) == 1){
			var nr01 = pegGetVal('nr01', container_id);
			var p701 = pegGetVal('p701', container_id);
			var p06  = pegGetVal('p06', container_id);
			var p01  = pegGetVal('p01', container_id);
			var p05  = pegGetVal('p05', container_id);

			invoices_check_p08(nr01, p01, p06, p701, 'a55', p05);
		}
	});

	p01Field.on('change',function(me,e){ 
		var container_id_a55_d4 = pegGetContainer_id_d(container_id, 'a55_d4', '', 'a55_d');
		if(pegGetVal('p08', container_id_a55_d4) == 1){
			var nr01 = pegGetVal('nr01', container_id);
			var p701 = pegGetVal('p701', container_id);
			var p06  = pegGetVal('p06', container_id);
			var p01  = pegGetVal('p01', container_id);
			var p05  = pegGetVal('p05', container_id);

			invoices_check_p08(nr01, p01, p06, p701, 'a55', p05);
		}
	});

	p06Field.on('blur',function(me,e){

		var container_id_a55_d4 = pegGetContainer_id_d(container_id, 'a55_d4', '', 'a55_d');
		if(pegGetVal('p08', container_id_a55_d4) == 1){
			var nr01 = pegGetVal('nr01', container_id);
			var p701 = pegGetVal('p701', container_id);
			var p06  = pegGetVal('p06', container_id);
			var p01  = pegGetVal('p01', container_id);
			var p05  = pegGetVal('p05', container_id);

			invoices_check_p08(nr01, p01, p06, p701, 'a55', p05);
		}
	});

	var p0100Field = pegGetCmp(container_id, 'p0100');
	if(p0100Field){
		p0100Field.on('blur', function (me) {
			if ((me.value_old != me.getValue()) || (!me.value_old)) {
				me.value_old = me.getValue();
				invcust_calculate_total(container_id);
			}
		});
	}

	let params = {};
	params.nr01 = pegGetVal('nr01', container_id);
	params.mode = "a55";
	if (invcust_a55_d_afterDraw_ajax) {
		if (invcust_a55_d_afterDraw_ajax.id) {
			Ext.ux.AjaxDefer.abort(invcust_a55_d_afterDraw_ajax);
		}
	}
	invcust_a55_d_afterDraw_ajax = pegAjaxDefer(
		'/' + main_path + '/invoices01/find_invoice_p30.php',
		params,
		function (jsonData) { //jsondata.p30
			//pegAlert(jsonData.invoice_p30);
			if (jsonData.invoice_p30 !== "") {
				pegToast(jsonData.invoice_p30, 'info');
			}
		},
		'json',
		true
	);
}

function invcust_a55_d8_afterDraw_listeners(container_id) {
	var btn01 = pegGetCmp(container_id, 'btn01'); // Επανεύρεση Στοιχείων Διακίνησης

    btn01.on('click', function(me) {
        invoices_where_p05(container_id, 'a55');
    });
}

function invcust_a55_d9_afterDraw_listeners(container_id) {
	//Ελέγχω με if γιατί η ίδια afterdraw καλείται και από τις πωλήσεις υπηρεσιών
	var p0101Field = pegGetCmp(container_id, 'p0101'); //% έκπτωσης
	var p0112Field = pegGetCmp(container_id, 'p0112'); //% κράτησης
	var p0113Field = pegGetCmp(container_id, 'p0113'); //% Φορου
	var p0102_1Field = pegGetCmp(container_id, 'p0102_1'); //Έκπτωση προ ΦΠΑ
	var p0108Field = pegGetCmp(container_id, 'p0108'); //Επιβαρύνσεις
	var p0102_2Field = pegGetCmp(container_id, 'p0102_2'); //Έκπτωση επί του συνόλου
	if(p0101Field){
		p0101Field.on('blur', function (me) {
			if(me.peg_onBlurValueHasChanged()){
				me.value_old = me.getValue();
				pegSetVal('p0102_1', me.container_id, 0);
				pegSetVal('p0102_2', me.container_id, 0);
				invcust_calculate_total(me.container_id);
			}
		});	
	}
	if(p0112Field){
		p0112Field.on('blur', function (me) {
			if(me.peg_onBlurValueHasChanged()){
				me.value_old = me.getValue();
				invcust_calculate_total(me.container_id);
			}
		});	
	}
	if(p0113Field){
		p0113Field.on('blur', function (me) {
			if(me.peg_onBlurValueHasChanged()){
				me.value_old = me.getValue();
				invcust_calculate_total(me.container_id);
			}
		});	
	}
	if(p0102_1Field){
		p0102_1Field.on('blur', function (me) {
			if(me.peg_onBlurValueHasChanged()){
				me.value_old = me.getValue();
				pegSetVal('p0101', me.container_id, 0);
				pegSetVal('p0102_2', me.container_id, 0);
				invcust_calculate_total(me.container_id);
			}
		});	
	}
	if(p0108Field){
		p0108Field.on('blur', function (me) {
			if(me.peg_onBlurValueHasChanged()){
				me.value_old = me.getValue();
				invcust_calculate_total(me.container_id);
			}
		});	
	}
	if(p0102_2Field){
		p0102_2Field.on('blur', function (me) {
			if(me.peg_onBlurValueHasChanged()){
				me.value_old = me.getValue();
				pegSetVal('p0101', me.container_id, 0);
				pegSetVal('p0102_1', me.container_id, 0);
				invcust_calculate_total(me.container_id);
			}
		});	
	}
}

function invcust_a55_d3_afterDraw_listeners(container_id) {
	//var screen = pegGetCmp(container_id);
	var grid = pegGetCmp(container_id, 'grid');
	
	if(typeof invoices_grid_rowedit_handler === 'function') {
		invoices_grid_rowedit_handler(grid)
	} else {
		grid.setpeg_isEditable(true)
	}

	grid.on('beforeedit', function (editor, context) {
		return invoices_beforeedit_actions(container_id, context, 'a55');
	});
	grid.on('validateedit', function (editor, context) {
		return invoices_validateedit_actions(container_id, context, 'a55');
	});
	grid.on('edit', function (editor, context) {
		invoices_edit_actions(container_id, context, 'a55');
	});
	grid.on('canceledit', function (editor, context) {
		return invoices_canceledit_actions(container_id, context, 'a55');
	});
	grid.on('cellkeydown', function (me, td, cellIndex, record, tr, rowIndex, e, eOpts) {
		invoices_cellkeydown_actions(e.keyCode, rowIndex, container_id, 'a55');
	});
	grid.on('peg_delete_all',function(me,recs){
		invcust_calculate_total(container_id);
		pegGridRefresh( container_id , 'grid');
	});

	//Το Αντικαταστήσαμε με την συνάρτηση invoices_keyup_actions γιατι κάποιες android συσκευες δεν επιστρεφουν σωστο keycode
	// pegGetCmp(container_id + '_grid_p01').on('keydown', function (me, e) {
	// 	invoices_keydown_actions(e.keyCode, container_id, 1);
	// });
	// pegGetCmp(container_id + '_grid_p02').on('keydown', function (me, e) {
	// 	invoices_keydown_actions(e.keyCode, container_id, 2);
	// });

	if(pegGetCmp(container_id + '_grid_p01')){
		pegGetCmp(container_id + '_grid_p01').on('keyup', function (me, e) {
			invoices_keyup_actions(me.value, container_id, 1);
		});
	}

	if(pegGetCmp(container_id + '_grid_p02')){
		pegGetCmp(container_id + '_grid_p02').on('keyup', function (me, e) {
			invoices_keyup_actions(me.value, container_id, 2);
		});
	}
	
	invoices_set_tooltips(container_id, 'a55');
}

function invcust_a55_d4_afterDraw_listeners(container_id) {

	var p09Field = pegGetCmp(container_id, 'p09'); //Καθεστώς
	var p506Field = pegGetCmp(container_id, 'p506'); //Δωροεπιταγη 
	var pn01 = pegGetCmp(container_id, 'pn01'); //Ξένο Νόμισμα
	var pn02 = pegGetCmp(container_id, 'pn02'); //Ισοτιμία
	var p08Field = pegGetCmp(container_id, 'p08'); //Χειρόγραφο
	var p07Field = pegGetCmp(container_id, 'p07'); //Τιμές με ΦΠΑ
	var p0121Field = pegGetCmp(container_id,'p0121'); //Κατάστημα
	var p0705Field = pegGetCmp(container_id,'p705'); //Όχημα Πελάτη
	var p805Field = pegGetCmp(container_id, 'p805'); //Δεν υπολογίζει Εισφορά Ανακύκλωσης
	var p703Field = pegGetCmp(container_id, 'p703'); //Αποθηκη
	var v_p601Field = pegGetCmp(container_id, 'v_p601'); //Δεν συμμετέχει στον μετασχηματισμό

	v_p601Field.on('change', function (me, newValue, oldValue, eOpts){
		if(newValue) {
			pegSetVal('p601', container_id, {'value': -1, 'display': -1});
			pegSetFieldHidden('p601', container_id, true);
		} else {
			pegSetVal('p601', container_id, 0);
			pegSetFieldHidden('p601', container_id, false);
		}
	});

	p805Field.on('change', function (me) {
		if((me.value_old != me.getValue()) || (!me.value_old)) {
			invoices_change_p805(container_id, 'a55', function(){invcust_calculate_total(container_id)});
		}
	});

	p0705Field.on('change', function (me) {
		if ((me.value_old != me.getValue()) || (!me.value_old)) {
			me.value_old = me.getValue();
			invcust_change_plate_number(container_id, me.getValue());
		}
	});

	p07Field.on('change', function(me, newValue, oldValue, eOpts) {
		if(newValue == oldValue) {
			return;
		}

		if(invoices_get_p07_onchange_pause() == true) {
			return;
		}

		invoice_p07_change(container_id, 'a55', function(){invcust_calculate_total(container_id)});
	});

	p08Field.on('change', function (me) {
		//Deprecated: 
		//if (me.getValue() == true || me.getValue() == 1) {
			invcust_change_xeirografo(container_id);
		//}

		if(pegGetVal('p08', container_id) == 1){
			var container_id_a55_d = pegGetContainer_id_d(container_id, 'a55_d', '', 'a55_d4');
			var nr01 = pegGetVal('nr01', container_id_a55_d);
			var p701 = pegGetVal('p701', container_id_a55_d);
			var p06  = pegGetVal('p06', container_id_a55_d);
			var p01  = pegGetVal('p01', container_id_a55_d);
			var p05  = pegGetVal('p05', container_id_a55_d);

			invoices_check_p08(nr01, p01, p06, p701, 'a55', p05);
		}
	});
	p09Field.on('change', function (me, e) {
		invcust_change_katestos_fpa(me.container_id);
	});

	if (p0121Field) {
		p0121Field.on('change', function (me, e) {
			invoices_refresh_invoice_num(container_id,'a55');
			invoices_where_p05(container_id, 'a55');
		});
	}

	pn01.on('change', function (me, e) {
		// console.log('change pn01');
		account_get_exchange_rate(container_id, 'a55');
		if(me.getValue() != '') {
			pegSetFieldReadonly('pn02', container_id, false);
		}else{
			pegSetFieldReadonly('pn02', container_id, true);
		}
	});

	pn02.on('change', function (me, e) {
		if ((me.value_old != me.getValue()) || (!me.value_old)) {
			me.value_old = me.getValue();
			invcust_calculate_total(container_id);
		}
	});

	if(p506Field){
		p506Field.on('change', function (me, e) {
			invcust_calculate_total(me.container_id);
		});	
	}

	p703Field.on('change', function (me) {
		invoices_find_p013_p014(container_id, 'a55');
		invoices_where_p05(container_id, 'a55');
	});
}

function invcust_a55_d5_afterDraw_listeners(container_id) {
	var screen = pegGetCmp(container_id);

	var p415Field = pegGetCmp(container_id, 'p415');
	var p416Field = pegGetCmp(container_id, 'p416');
	var p505Field = pegGetCmp(container_id, 'p505');

	if(p415Field){
		p415Field.on('change', function (me, e) {
			invoices_change_local_stores(me.container_id, 'a55');
		});			
	}

	if(p416Field){
		p416Field.on('change', function (me, e) {
			invoices_change_local_stores(me.container_id, 'a55');
		});	
	}

	if(p505Field){
		p505Field.on('change', function (me, e) {
			invcust_get_b2g_from_contract(container_id, me.getValue());
		});	
	}
}
var invcust_get_b2g_from_contract_ajax = '';
function invcust_get_b2g_from_contract(container_id, p505){
	const container_a55_d = pegGetContainer_id_d(container_id, 'a55_d', '', 'a55_d');
	const container_b2g01_d = pegGetContainer_id_d(container_a55_d, '_b2g01_d', '', '_b2g01_d');
	console.log(container_id, p505);
	if(!container_b2g01_d) {
		return;
	}
	if (invcust_get_b2g_from_contract_ajax != '') {
		if (invcust_get_b2g_from_contract_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invcust_get_b2g_from_contract_ajax);
		}
	}
	const params = {
		cona11_nr01 : p505
	};
	invcust_get_b2g_from_contract_ajax = pegAjaxDefer('/' + main_path + '/invcust01/invcust_b2g_from_contract.php', params, function(doc){
		if(doc.ok != 1){
			pegSetVal('v_b2g01_contrref', container_b2g01_d, '');				// BT-12
			pegSetVal('v_b2g01_prjref', container_b2g01_d, '');					// BT-11
			pegSetVal('v_b2g01_buyerref', container_b2g01_d, '');				// BT-10
			pegSetVal('v_b2g01_buyerid', container_b2g01_d, '');				// BT-46
			pegSetVal('v_b2g01_orderref', container_b2g01_d, '');				// BT-13
			pegSetVal('v_einv20_payterm', container_b2g01_d, '');				// BT-20
			pegSetVal('v_einv20_invnotescode', container_b2g01_d, 0);			// BT-21
			pegSetVal('v_einv20_invnote', container_b2g01_d, '');				// BT-22
			pegSetVal('v_b2g01_is_b2g', container_b2g01_d, 0);
			return;
		}
		pegSetVal('v_b2g01_is_b2g', container_b2g01_d, 1);
		pegSetVal('v_b2g01_contrref', container_b2g01_d, doc.data.v_b2g01_contrref);				// BT-12
		pegSetVal('v_b2g01_prjref', container_b2g01_d, doc.data.v_b2g01_prjref);					// BT-11
		pegSetVal('v_b2g01_buyerref', container_b2g01_d, doc.data.v_b2g01_buyerref);				// BT-10
		pegSetVal('v_b2g01_buyerid', container_b2g01_d, doc.data.v_b2g01_buyerid);					// BT-46
		pegSetVal('v_b2g01_orderref', container_b2g01_d, doc.data.v_b2g01_orderref);				// BT-13
		pegSetVal('v_einv20_payterm', container_b2g01_d, doc.data.v_einv20_payterm);				// BT-20
		pegSetVal('v_einv20_invnotescode', container_b2g01_d, doc.data.v_einv20_invnotescode);		// BT-21
		pegSetVal('v_einv20_invnote', container_b2g01_d, doc.data.v_einv20_invnote);				// BT-22
	});
}
function invcust_a55_d6_afterDraw_listeners(container_id) {
	var screen = pegGetCmp(container_id);
	var p410Field = pegGetCmp(container_id, 'p410');
	var p420Field = pegGetCmp(container_id, 'p420');

	for (var i = 1; i < 10; i++) {
		var tmpVar = pegGetCmp(container_id + '_p20' + i);
		tmpVar.on('blur', function (me) {
			if (me.peg_onBlurValueHasChanged()) {
				me.value_old = me.getValue();
				invcust_calculate_total(container_id);
			}
		});

	}

	for (var i = 1; i < 10; i++) {
		var tmpVar = pegGetCmp(container_id + '_p30' + i);
		tmpVar.on('blur', function (me) {
			if (me.peg_onBlurValueHasChanged()) {
				me.value_old = me.getValue();
				invcust_calculate_total(container_id);
			}
		});

	}

	p410Field.on('change', function (me) {
		var type = true;

		if (me.getValue() == true || me.getValue() == 1) {
			type = false;
		} else {
			invcust_calculate_total(container_id);
		}

		pegSetFieldReadonly('p201', container_id, type);
		pegSetFieldReadonly('p202', container_id, type);
		pegSetFieldReadonly('p203', container_id, type);
		pegSetFieldReadonly('p204', container_id, type);
		pegSetFieldReadonly('p205', container_id, type);
		pegSetFieldReadonly('p206', container_id, type);
		pegSetFieldReadonly('p207', container_id, type);
		pegSetFieldReadonly('p208', container_id, type);
		pegSetFieldReadonly('p209', container_id, type);

		pegSetFieldReadonly('p301', container_id, type);
		pegSetFieldReadonly('p302', container_id, type);
		pegSetFieldReadonly('p303', container_id, type);
		pegSetFieldReadonly('p304', container_id, type);
		pegSetFieldReadonly('p305', container_id, type);
		pegSetFieldReadonly('p306', container_id, type);
		pegSetFieldReadonly('p307', container_id, type);
		pegSetFieldReadonly('p308', container_id, type);
		pegSetFieldReadonly('p309', container_id, type);

	});

	p420Field.on('change', function (me) {
		invcust_calculate_total(container_id);
	});
}

function invcust_toolbar_item(container_id) {
	var screen = pegGetCmp(container_id);
	if (screen.peg__d == 'a57_d10') {
		pegGetDic('peg_dic_invcust_invoice_cust_select_order', function (desc) {
			var params = {};
			params.peg_dic_invcust_invoice_cust_select_order = desc;
			peg_ordercust_a57_d00_invoice_order(container_id, screen.getMnr01(), screen.getMmnr01(), params);
		});
	} else if (screen.peg__d == 'chaa00_d11') {
		peg_champion_chaa00_d11_do_invoice(container_id);
	}
}
var invoices_document_after_save_global_check_ajax = '';
/**
 * 
 * @param {string} container_id 
 * @param {number} a55_nr01 
 * @param {number} p08 
 * @param {number} p05 
 * @param {boolean} print 
 * @param {boolean} mail 
 * @param {boolean} sms 
 */
function invcust_a55_d_on_save(container_id, a55_nr01, p08, p05, print=false, mail=false, sms=false, callback00='') {
	if(invoices_document_after_save_global_check_ajax != '') {
		if(invoices_document_after_save_global_check_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invoices_document_after_save_global_check_ajax);
		}
	}

	const params = {
		mode : 'a55',
		nr01 : a55_nr01
	}

	invoices_document_after_save_global_check_ajax = pegAjaxDefer('/' + main_path + '/invoices01/invoices_document_after_save_global_check.php', params, 
		function (invoices_document_after_save_global_check_json_response) {
			if(invoices_document_after_save_global_check_json_response.data.oil01_epistrofi_p01 > 0) {
				callback = function() {
					invcust_a55_d_on_save(
						container_id, 
						invoices_document_after_save_global_check_json_response.data.oil01_epistrofi_p01, 
						invoices_document_after_save_global_check_json_response.data.oil01_epistrofi_p08, 
						invoices_document_after_save_global_check_json_response.data.oil01_epistrofi_p05, 
						print, mail, sms, 
						function() {
							if(callback00 && typeof(callback00) === "function") {
								invcust_a55_d_on_save_extra_actions(
									container_id, 
									invoices_document_after_save_global_check_json_response.data.ok,
									invoices_document_after_save_global_check_json_response.data.oil01_epistrofi_p01,
									print,
									mail,
									sms,
									invoices_document_after_save_global_check_json_response.data.oil01_epistrofi_p05,
									-1,
									callback00()
								)
							}
						}
					);
				}
			} else {
				callback = callback00;
			}
			
			// Τιμολόγηση με Ηλεκτρονική τιμολόγηση Pegasus
			if(invoices_document_after_save_global_check_json_response.data.einv == true) {
				einv01_check_if_einv_and_save_call('a55',a55_nr01,function(einv01_check_if_einv_and_save_call_response) {
					if(einv01_check_if_einv_and_save_call_response.msg!='') {
						pegToast(einv01_check_if_einv_and_save_call_response.msg, einv01_check_if_einv_and_save_call_response.ok == 1 ? 'info' : 'alert');
					}
					invcust_a55_d_on_save_extra_actions(container_id, einv01_check_if_einv_and_save_call_response.ok, a55_nr01, print, mail, sms, p05, -1, callback);
					if (Array.isArray(einv01_check_if_einv_and_save_call_response.pendings) && einv01_check_if_einv_and_save_call_response.pendings.length > 0 && einv01_check_if_einv_and_save_call_response.ok ==1) {
						einv01_send_pendings(einv01_check_if_einv_and_save_call_response.pendings[0].tbl, einv01_check_if_einv_and_save_call_response.pendings[0].tbl_nr01);
					}
				});
			}
			// Τιμολόγηση με Ηλεκτρονική τιμολόγηση SoftOne
			if(invoices_document_after_save_global_check_json_response.data.einv01 == true) {
				einv01_01_check_if_einv_and_save_call('a55',a55_nr01,function(einv01_01_check_if_einv_and_save_call_response) {
					if(einv01_01_check_if_einv_and_save_call_response.msg!='') {
						pegToast(`SoftOne e-invoicing: ${einv01_01_check_if_einv_and_save_call_response.msg}`, einv01_01_check_if_einv_and_save_call_response.ok == 1 ? 'info' : 'alert');
					}
					invcust_a55_d_on_save_extra_actions(container_id, einv01_01_check_if_einv_and_save_call_response.ok, a55_nr01, print,mail, sms, p05, -1, callback);
				});
			}
			// Τιμολόγηση με CnA Server και Mydt
			if(invoices_document_after_save_global_check_json_response.data.ca_server == true && p08 == 0) {
				/**
				 * Εδώ καλούμε ξεχωριστά την mydt_update_mydt10_n_send 
				 * γιατί στην ca_server_a55_d_on_save εκτελείτε και 
				 * η invcust_a55_d_on_save_extra_actions και κάνουμε return 
				 * για να μην εκτελεστεί δύο φορές η mydt_update_mydt10_n_send
				 * 
				 * * 27/03/2024 - Έβαλα την ca_server_a55_d_on_save ως callback γιατί εκτελούσε την extra_actions πριν πατήσουμε στο confirm για την αδυναμία διαβίβασης
				 */
				mydt_update_mydt10_n_send('a55',a55_nr01,container_id,true ,function(){
					ca_server_a55_d_on_save(container_id, a55_nr01, 0, print, mail, false, sms, callback);
				});
				return;
			}
			// Τιμολόγηση με Mydt
			if(invoices_document_after_save_global_check_json_response.data.mydt == true) {
				mydt_update_mydt10_n_send('a55',a55_nr01,container_id,true,function(mydt_update_mydt10_n_send_response) {
					let ok = 1;
					if(
						// Αν έχω response.ok == 0 ελέγχω και αν έχω pegasus_error ή μήνυμα από ΑΑΔΕ
						// Υπάρχει περίπτωση να μου έρθει ok == 0 χωρίς αυτά, αν π.χ. δεν έχω ρυθμίσεις mydata
						// Εκεί δεν θέλω να μου κόψει την αυτόματη εκτύπωση.
						mydt_update_mydt10_n_send_response.ok == 0 && 
						(mydt_update_mydt10_n_send_response.has_pegasus_error == 1 
						|| mydt_update_mydt10_n_send_response.has_msg_from_mydt_send_to_aade == 1)
					){
						ok = 0;
					}
					invcust_a55_d_on_save_extra_actions(container_id, ok, a55_nr01, print, mail, sms, p05, -1, callback);
				});
			}
	});
}
function invcust__account00_a55_d_grid_combobox_v2_v_a55_view_afterDraw_listeners(container_id){ 
	
	var grid = pegGetCmp(container_id, 'grid_combobox_v2_v_a55');
	var v_color_red =  'fd6d74'; 

	var v_ypolColumn  = WebApp.view.grid.Grid.peg_getColumn(grid, 'v_ypol'); 		// M.K.

	// M.K.
	if(v_ypolColumn){
		v_ypolColumn.peg_set_metaData = function(value, metaData, record, rowIndex, colIndex, store, view) {  
			try {
				var has_ypol = record.get('v_ypol'); //αν το παραστατικό έχει υπόλοιπο
				if(has_ypol !== 0){          
					metaData.tdStyle = "background-color:#"+v_color_red+";";
				}				
			} catch (error) {
				
			}
			return metaData;
		};
	}

}
/**
 * 
 * @param {string} container_id 
 * @param {number} ok 
 * @param {number} a55_nr01 
 * @param {boolean} print 
 * @param {boolean} mail 
 * @param {boolean} sms 
 * @param {number} p05 
 * @param {number} numOfCopies 
 * @returns 
 */
function invcust_a55_d_on_save_extra_actions(
	container_id,
	ok,
	a55_nr01,
	print,
	mail,
	sms,
	p05,
	numOfCopies=-1,
	callback
) {
	if(ok != 1) {
		return;
	}
	if(print == true) {
		invcust_print_invoice(container_id, a55_nr01, numOfCopies, p05);
	} else if(mail == true) {
		invcust_a55_send_mail(a55_nr01);
	} else if(sms == true) {
		invcust_a55_send_sms(a55_nr01);
	}

	if(callback && typeof(callback) === "function"){
		callback();
	}
}

var invcust_a55_d_send_mail_ajax = '';
function invcust_a55_send_mail(a55_nr01){
	if (invcust_a55_d_send_mail_ajax != '') {
		if (invcust_a55_d_send_mail_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invcust_a55_d_send_mail_ajax);
		}
	}
	params = {};	
	params.a55_nr01 = a55_nr01;
	invcust_a55_d_on_save_ajax = pegAjaxDefer('/' + main_path + '/invcust01/init_mail_send.php' , 
		params, function(jsondata){
		peg_mail_show_mail_send_d00_ajax("a55", a55_nr01, '', '', jsondata.mail02_nr01, jsondata.p85_nr01);
	});
}
var invcust_a55_d_send_sms_ajax = '';
function invcust_a55_send_sms(a55_nr01){
	if (invcust_a55_d_send_sms_ajax != '') {
		if (invcust_a55_d_send_sms_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invcust_a55_d_send_sms_ajax);
		}
	}
	params = {};	
	params.a55_nr01 = a55_nr01;
	invcust_a55_d_on_save_ajax = pegAjaxDefer('/' + main_path + '/invcust01/init_sms_send.php' , 
		params, function(jsondata){
			sms00_show_sms_send_d00_ajax("a55", a55_nr01, '', '', jsondata.sms00_02_nr01);
	});
}



function invcust_a55_d_grid_view_afterDraw_listeners(container_id){ 
	//console.log('123456');
	var grid = pegGetCmp(container_id, 'grid');

	var v_color_red =  'ed0e1d'; 

	var p06Column   = WebApp.view.grid.Grid.peg_getColumn(grid, 'p06');			// Αριθμός
	var nr01Column  = WebApp.view.grid.Grid.peg_getColumn(grid, 'nr01'); 		// M.K.
	
	// Αριθμός
	if(p06Column){
		p06Column.peg_set_metaData = function(value, metaData, record, rowIndex, colIndex, store, view) {  
			try {
				var p601a_data = record.get('p601a');			// έλεγχος αν έχει εκδοθεί ΕΑΣ	
				var is_akyrotiko = record.get('v_is_akyrotiko');    //αν ο τύπος παραστατικού ειναι αυτός που έχει οριστεί ως [ειδ.ακυρωτικό πωλήσεων/αγορών) στις [παραμέτρους παραστατικων]
				if(p601a_data>0 || is_akyrotiko == 1){
					metaData.tdStyle = "color:#"+v_color_red+";";
					metaData.style = "font-weight:bold;";
				}				
			} catch (error) {
				
			}
			return metaData;
		};
	}

	// M.K.
	if(nr01Column){
		nr01Column.peg_set_metaData = function(value, metaData, record, rowIndex, colIndex, store, view) {  
			try {
				var typos_par_data = record.get('p601a');			// έλεγχος αν ο τύπος παραστατικού ειναι αυτός που έχει οριστεί 	
				var is_akyrotiko = record.get('v_is_akyrotiko'); 	//αν ο τύπος παραστατικού ειναι αυτός που έχει οριστεί ως [ειδ.ακυρωτικό πωλήσεων/αγορών) στις [παραμέτρους παραστατικων]
				var is_y_ekd = record.get('y_ekd'); 				//αν το παραστατικό είναι Υπό έκδοση
				if(typos_par_data>0 || is_akyrotiko == 1 || is_y_ekd == 1){          
					metaData.tdStyle = "color:#"+v_color_red+";";
					metaData.style = "font-weight:bold;";
				}				
			} catch (error) {
				
			}
			return metaData;
		};
	}
	
	grid.peg_deleteRec_params=function(params,row){
		params.mmnr01='a55_d-'+row['nr01'];
		console.log(params.mmnr01)
		return params;
	};

}
function invcust_a55_d00_afterDraw_listeners(container_id) {
	const screen = pegGetCmp(container_id);
	const grid = pegGetCmp(container_id,'grid');
	grid.record_insert = function(me,row){
		const cona11 = pegGetVal('cona11',container_id);
		if(
			!pegIsEmpty(cona11)
			&& cona11 > 0
		) {
			return invcust_a55_d00_cona11_check(cona11,function(jsondata) {
				if(jsondata.ok != 1) {
					return pegAlert(jsondata.msg?jsondata.msg:'Error');
				}
				return invcust_a55_d00_show(
					grid.getContainer_ID(),
					grid.getName(),
					screen.getMmnr01(),
					screen.getMnr01()
				);
			});
		}
		return invcust_a55_d00_show(
			grid.getContainer_ID(),
			grid.getName(),
			screen.getMmnr01(),
			screen.getMnr01()
		);
	};

	grid.record_copy=function(me, record) {		
		var p_table        = '';
		var p__d           = '_invoices_copy_tables_d';
		var p_module       = 'invoices';
		var p_container_id = container_id;
		var p_nr01         = 0;

		params = {
			peg_screen_parent_element_name: 'grid',
			peg_screen_parent_container_id: container_id
		}

		peg_windowShow_d(p_table, p__d, p_module, p_container_id, '', p_nr01, '', '', params, false, true, 0, 0, 'tablet');
	}
}
function invcust_a55_d00_show(
	parent_container_id = '',
	parent_name = '',
	mmnr01 = '',
	mnr01 = 0,
	nr01 = 0
) {
	return pegAddTab_d(
		'',
		'a55',
		'a55_d',
		'invcust',
		'',
		nr01,
		'',
		{
			mmnr01: mmnr01,
			mnr01: mnr01,
			nr01: nr01
		},
		parent_container_id,
		parent_name
	);
}

var invcust_a55_d00_cona11_check_ajax = ''
function invcust_a55_d00_cona11_check(
	cona11 = 0,
	next
) {
	if (invcust_a55_d00_cona11_check_ajax != '') {
		if (invcust_a55_d00_cona11_check_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invcust_a55_d00_cona11_check_ajax);
		}
	}
	const params = {
		cona11 : cona11
	};
	invcust_a55_d00_cona11_check_ajax = pegAjaxDefer(
		'/' + main_path + '/invcust01/invcust_a55_d00_cona11_check.php' , 
		params, 
	function(jsondata){
		return next(jsondata);
	});
}