<?php

/**
 */
class invcust_pegapi_actions extends pegapi_RestObject
{
	/**
	 * @return array
	 */
	public function invoice()
	{
		switch ($this->method) {
			case 'GET':
				return $this->get();
				break;
			case 'POST':
				return $this->post();
				break;
			case 'PUT':
				return $this->put();
				break;
			case 'DELETE':
				return $this->delete();
				break;
		}
	}
	/**
	 * **SELECT:** Ανάσυρση στοιχείων παραστατικού / παραστατικών
	 * 
	 * Αχ έχει οριστεί nr01 στο request τότε επιστρέφει το παραστατικό με αυτό το 
	 * nr01 ειδάλλως επιστρέφει μια λίστα με παραστατικά σύμφωνα με τα filters που 
	 * έχουν δοθεί στο request.
	 *
	 * @return array
	 */
	private function get()
	{
		$data = array();
		$nr01 = $this->request['nr01'];
		if ($nr01 > 0) {
			$data[] = $this->a55_get_one($nr01);
			$this->recperpage	= 1;
			$this->page			= 0;
			$this->totalrec 	= empty($data) ? 0 : 1;
		} else {
			$filter 	= $this->request['filter'];
			$order 		= $this->request['order_array'];
			$recperpage	= $this->request['recperpage'];
			$page		= $this->request['page'];
			$data = $this->a55_get_many(
				$filter,
				$order,
				$recperpage,
				$page
			);
		}
		if (empty($data)) {
			return array(
				'status'	=> 209,
				'code'		=> 209,
				'data'		=> array('error' => array('title' => "No Content", 'detail' => "No Content"))
			);
		}
		return array(
			'status'	=> 200,
			'code'		=> 200,
			'data'		=> $data
		);
	}
	/**
	 * (INSERT)
	 *
	 * @return array
	 */
	private function post()
	{
		try {
			$args = array();
			$fields = $this->a55_get_participate_fields();
			if (empty($fields)) {
				throw new Exception('No field available for Insert (a55)');
			}
			foreach ($fields as $field => $type) {
				if (isset($this->request[$field])) {
					$args[$field] = $this->request[$field];
				}
			}

			if(pegasus_module_exists('b2g')) {
				$args['v_b2g01_is_b2g']        = $this->request['v_b2g01_is_b2g'];
				$args['v_b2g01_contrref'] 	   = $this->request['v_b2g01_contrref'];
				$args['v_b2g01_prjref']   	   = $this->request['v_b2g01_prjref'];
				$args['v_b2g01_buyerref'] 	   = $this->request['v_b2g01_buyerref'];
				$args['v_b2g01_buyerid']   	   = $this->request['v_b2g01_buyerid'];
				$args['v_b2g01_orderref'] 	   = $this->request['v_b2g01_orderref'];
			}

			if(pegasus_module_exists('einv')) {
				$args['v_einv20_payterm']      = $this->request['v_einv20_payterm'];
				$args['v_einv20_invnotescode'] = $this->request['v_einv20_invnotescode'];
				$args['v_einv20_invnote']      = $this->request['v_einv20_invnote'];
			}

			$i01 = array();
			$i71 = array();
			if (isset($this->request['i01'])) {
				$i01 = $this->request['i01'];
				$i01 = json_decode($i01, true);
			}
			if (isset($this->request['i71'])) {
				$i71 = $this->request['i71'];
				$i71 = json_decode($i71, true);
			}

			// Δεν μπορεί να καταχωρηθεί παραστατικό που είναι oil, δηλαδή στους [Ορισμούς Παραστατικών Πελατών] το [Καταχωρεί αυτόματα Επιστροφή] να είναι τσεκαρισμένο. 
			$cnt_q31 = pegasus_mysql_printfld("q31", "count(*)", "q31.p01 = 650000 AND q31.p03 = :p05 AND q31.p05 = 1", array("p05"=>$args['p05']));
			if($cnt_q31 > 0) {
				return array(
					'status'	=> 400,
					'code'		=> 400,
					'data'		=> array('error' => array('title' => "Error", 'detail' => $_SESSION['peg_dic_invcust_oil_invoice_not_submitted']))
				);
			}

			$resp = $this->a55_insert(
				$args,
				$i01,
				$i71
			);
			if (isset($resp['error'])) {
				throw new Exception($resp['message']);
			}
			$ret = array(
				'status'	=> 201,
				'code'		=> 201,
			);
			$ret['data'] = $resp['data'];
			if (isset($resp['mydt'])) {
				$ret['info']['mydt'] = $resp['mydt'];
			}
			$this->recperpage = 1;
			$this->page = 0;
			$this->totalrec = 1;
			return $ret;
		} catch (Exception $e) {
			return array(
				'status'	=> 403,
				'code'		=> 403,
				'data'		=> array('error' => array('title' => "Error", 'detail' => $e->getMessage()))
			);
		}
	}
	/**
	 * (UPDATE)
	 *
	 * @return array
	 */
	private function put()
	{
		try {
			$nr01 = $this->request['nr01'];
			if (!(pegasus_mysql_printfld('a55', 'nr01', 'nr01 = :nr01', array('nr01' => $nr01)) > 0)) {
				throw new Exception("Unknown invoice with nr01: $nr01");
			}
			$fields = $this->a55_get_participate_fields();
			if (empty($fields)) {
				throw new Exception('No field available for Insert (a55)');
			}
			foreach ($fields as $field => $type) {
				if (isset($this->request[$field])) {
					$args[$field] = $this->request[$field];
				}
			}

			if(pegasus_module_exists('b2g')) {
				$b2g01 = array();

				$query_b2g01 = "SELECT * FROM b2g01 WHERE tbl = :tbl AND tbl_nr01 = :tbl_nr01";

				pegasus_mysql_use($query_b2g01, $b2g01, array('tbl' => 'a55', 'tbl_nr01' => $nr01));

				$args['v_b2g01_is_b2g'] = $b2g01['is_b2g'];
				if(!empty($this->request['v_b2g01_is_b2g'])) {
					$args['v_b2g01_is_b2g'] = $this->request['v_b2g01_is_b2g'];
				}

				$args['v_b2g01_contrref'] = $b2g01['contrref'];
				if(!empty($this->request['v_b2g01_contrref'])) {
					$args['v_b2g01_contrref'] = $this->request['v_b2g01_contrref'];
				}

				$args['v_b2g01_prjref'] = $b2g01['prjref'];
				if(!empty($this->request['v_b2g01_prjref'])) {
					$args['v_b2g01_prjref'] = $this->request['v_b2g01_prjref'];
				}

				$args['v_b2g01_buyerref'] = $b2g01['buyerref'];
				if(!empty($this->request['v_b2g01_buyerref'])) {
					$args['v_b2g01_buyerref'] = $this->request['v_b2g01_buyerref'];
				}

				$args['v_b2g01_buyerid'] = $b2g01['buyerid'];
				if(!empty($this->request['v_b2g01_buyerid'])) {
					$args['v_b2g01_buyerid'] = $this->request['v_b2g01_buyerid'];
				}

				$args['v_b2g01_orderref'] = $b2g01['orderref'];
				if(!empty($this->request['v_b2g01_orderref'])) {
					$args['v_b2g01_orderref'] = $this->request['v_b2g01_orderref'];
				}
			}

			if(pegasus_module_exists('einv')) {
				$einv20 = array();

				$query_einv20 = "SELECT * FROM einv20 WHERE tbl = :tbl AND tbl_nr01 = :tbl_nr01";

				pegasus_mysql_use($query_einv20, $einv20, array('tbl' => 'a55', 'tbl_nr01' => $nr01));

				$args['v_einv20_payterm'] = $einv20['payterm'];
				if(!empty($this->request['v_einv20_payterm'])) {
					$args['v_einv20_payterm'] = $this->request['v_einv20_payterm'];
				}

				$args['v_einv20_invnotescode'] = $einv20['invnotescode'];
				if(!empty($this->request['v_einv20_invnotescode'])) {
					$args['v_einv20_invnotescode'] = $this->request['v_einv20_invnotescode'];
				}

				$args['v_einv20_invnote'] = $einv20['invnote'];
				if(!empty($this->request['v_einv20_invnote'])) {
					$args['v_einv20_invnote'] = $this->request['v_einv20_invnote'];
				}
			}

			$i01 = array();
			$i71 = array();
			if (isset($this->request['i01'])) {
				$i01 = $this->request['i01'];
				$i01 = json_decode($i01, true);
			}
			if (isset($this->request['i71'])) {
				$i71 = $this->request['i71'];
				$i71 = json_decode($i71, true);
			}
			$resp = $this->a55_update(
				$nr01,
				$args,
				$i01,
				$i71
			);
			if (isset($resp['error'])) {
				throw new Exception($resp['message']);
			}
			$ret = array(
				'status'	=> 201,
				'code'		=> 200
			);
			$ret['data'] = $resp['data'];
			if (isset($resp['mydt'])) {
				$ret['info']['mydt'] = $resp['mydt'];
			}
			$this->recperpage = 1;
			$this->page = 0;
			$this->totalrec = 1;
			return $ret;
		} catch (Exception $e) {
			return array(
				'status'	=> 400,
				'code'		=> 400,
				'data'		=> array('error' => array('title' => "Error", 'detail' => $e->getMessage()))
			);
		}
	}
	/**
	 * (DELETE)
	 *
	 * @return array
	 */
	private function delete()
	{
		$this->recperpage = 0;
		$this->page = 0;
		$this->totalrec = 0;
		try {
			$nr01 = $this->request['nr01'];
			if (!(pegasus_mysql_printfld('a55', 'nr01', 'nr01 = :nr01', array('nr01' => $nr01)) > 0)) {
				throw new Exception("Unknown invoice with nr01: $nr01");
			}
			$resp = $this->a55_delete($nr01);
			if (isset($resp['error'])) {
				throw new Exception($resp['message']);
			}
			return array(
				'code'		=> 204,
				'status'	=> 200,
				'data'		=> array('info' => array('title' => "Deleted", 'detail' => "Invoice (a55) with nr01: $nr01 deleted successfully"))
			);
		} catch (Exception $e) {
			return array(
				'status'	=> 400,
				'code'		=> 400,
				'data'		=> array('error' => array('title' => "Error", 'detail' => $e->getMessage()))
			);
		}
	}
	/**
	 *
	 * @return array
	 */
	private function a55_get_participate_fields()
	{
		$fields = array();
		$sql = "	SELECT
						p51.desc05	AS fld,
						p51.desc16	AS tp,
						desc17 		AS fldsz,
						desc18 		AS flddec
					FROM  p51
					JOIN p61 ON p51.desc07 = p61.p00 and p61.isdbfld = 1

					WHERE p51.desc16 != ''
					AND p51.desc16 != 'V'
					AND p51.p02 = :p51_p02
					AND p51.module = :p51_module
		";
		$values = array(
			'p51_p02'		=> 'a55_d',
			'p51_module'	=> 'invcust'
		);
		$res = pegasus_query($sql, $values);
		while ($rs = pegasus_fetch_assoc($res)) {
			$fields[$rs['fld']] = array(
				'fld'		=> $rs['fld'],
				'tp'		=> $rs['tp'],
				'fldsz'		=> $rs['fldsz'],
				'flddec'	=> $rs['flddec'],
			);
		}
		return $fields;
	}
	/**
	 *
	 * @param  array $a55
	 * @return array
	 */
	private function a55_recalculate_totals(
		$a55 = array()
	) {
		//	Επανυπολογισμός συνόλων
		$product_where = "
		peg_mnr01 = " . $a55['nr01'] . "
		AND peg_mmnr01 = 'a55_d-" . $a55['nr01'] . "'
		AND peg_sess_id = '" . session_id() . "'
		AND peg_flag != 9
		AND p06 = " . $a55['nr01'] . "
		AND p07 = 2
		";
		$resp = invoices_calculate_total(
			'peg_tmp_i01',
			$product_where,
			$a55['p0101'],
			$a55['p0112'],
			$a55['p0113'],
			$a55['p0103'],
			$a55['p0108'],
			$a55['p09'],
			$a55['p07'],
			$a55['p410'],
			array(),
			$a55['p506'],
			$a55['p0102_1'],
			$a55['p0102_2'],
			0,
			"a55",
			"",
			$a55['nr01'],
			$a55['pn02'],
			$a55['p420']
		);
		foreach ($resp as $k => $v) {
			$a55[$k] = $v;
		}
		return $a55;
	}
	/**
	 *
	 * @param  integer $nr01
	 * @return null|array
	 */
	private function a55_get_one(
		$nr01 = 0
	) {
		$sql = "SELECT * FROM a55 WHERE nr01 = :nr01";
		$values = array('nr01' => $nr01);
		$a55 = array();
		pegasus_mysql_use($sql, $a55, $values);
		// Add i01
		if (empty($a55)) {
			return array();
		}
		$a55['i01'] = $this->i01_get_by_a55_nr01($a55['nr01']);
		$a55['i71'] = $this->i71_get_by_a55_nr01($a55['nr01']);
		$a55 = array_merge($a55, $this->a55_get_signature($nr01));
		return $a55;
	}
	/**
	 *
	 * @param  array   $filter
	 * @param  array   $order
	 * @param  integer $recperpage
	 * @param  integer $page
	 * @return null|array
	 */
	private function a55_get_many(
		$filter = array(),
		$order = array(),
		$recperpage = 0,
		$page = 0
	) {
		if (!($recperpage > 0)) {
			$recperpage = 9999999999;
		}
		if (!($page >= 0)) {
			$recperpage = 0;
		}
		$recperpage = intval($recperpage);
		$page = intval($page);
		$this->recperpage = $recperpage;
		$this->page = $page;

		$tableFields = $this->a55_get_participate_fields();
		$filters = $this->makeFilterWhereFromArray($filter, $tableFields, '', true);

		$sql = " 1=1 ";
		$values = array();
		if (!empty($filters)) {
			$sql .= $filters['sql'];
			$values = array_merge($values, $filters['sqlParams']);
		}
		$count = pegasus_mysql_printfld('a55', 'COUNT(nr01)', $sql, $values);
		$order = $this->makeOrderBy($tableFields, $order);
		$this->totalrec = intval($count);
		$offset = $recperpage * $page;
		$limit = $recperpage;
		$sql = "SELECT * FROM a55 WHERE $sql $order LIMIT $offset,$limit";
		$res = pegasus_query($sql, $values);
		$a55s = array();
		while ($a55 = pegasus_fetch_assoc($res)) {
			// Add i01
			$a55['i01'] = $this->i01_get_by_a55_nr01($a55['nr01']);
			$a55['i71'] = $this->i71_get_by_a55_nr01($a55['nr01']);
			$a55 = array_merge($a55, $this->a55_get_signature($a55['nr01']));
			$a55s[] = $a55;
		}
		return $a55s;
	}
	/**
	 *
	 * @param  array  $args
	 * @param  array  $i01
	 * @param  array  $i71
	 * @return array
	 */
	private function a55_insert(
		$args = array(),
		$i01 = array(),
		$i71 = array()
	) {
		$request = $_REQUEST;
		try {
			$screen = new screen();
			$screen->container_id = pegasus_container_id_create(0, session_id(), 'a55_d');
			$screen->module = 'invcust';
			$screen->_d = 'a55_d';
			$screen->table = 'a55';
			if(
				isset($args['nr01'])
				&& $args['nr01'] > 0
			) {
				throw new Exception('Error: nr01 field is not allowed on insert new invoice');
			}
			$screen->read_data_from_db(1, 1);
			$screen->read_params_from_db();
			//	Περνάμε όλες τις μεταβλητές στο data
			foreach ($args as $k => $v) {
				$screen->data[$k] = $v;
			}
			//	Παίρνουμε το new_rec $nr01 από την οθόνη
			$nr01 = $screen->data['nr01'];
			//	Εισάγουμε τα (tmp) i01 (+i32, +i38, +i48)
			$this->i01_insert_tmp(
				'a55_d-' . $nr01,
				$nr01,
				$nr01,
				$i01
			);
			//	Εισάγουμε τα (tmp) i01
			$this->i71_insert_tmp(
				'a55_d-' . $nr01,
				$nr01,
				$screen->data['nr01'],
				$i71
			);
			//	Επαναπροσδιορισμός συνόλων
			$screen->data = $this->a55_recalculate_totals($screen->data);
			/**
			 * Καλούμε την invoices_document_after_save_global_check μόνο για να δούμε αν το παραστατικό θα 
			 * σταλεί με CnA το οποίο δεν μπορούμε να υποστηρίξουμε.
			 */
			$invoices_document_after_save_global_check_resp = invoices_document_after_save_global_check('a55',$screen->data['nr01']);
			if($invoices_document_after_save_global_check_resp['data']['ca_server'] == true) {
				$signatures_config = ca_server_get_signatures_configuration($screen->data['p05'], $screen->data['p701'], $screen->data['p0121']);
				if ($signatures_config['config_count'] != 0) {
					peg_close_d($screen->container_id);
					throw new Exception('Το Παραστατικό δεν μπόρεσε να καταχωρηθεί γιατί χρειάζεται φορολογικό μηχανισμό.');
				}
			}
			// Αποθήκευση παραστατικού
			$_REQUEST = $screen->data;
			$_REQUEST['no_confirm'] = 1;
			$resp = $screen->save_data();
			peg_close_d($screen->container_id);
			$_REQUEST = $request;
			if ($resp[0] != 1) {
				$msg = '';
				foreach ($resp as $v) {
					if (!empty($v)) {
						$msg .= "$v<br>";
					}
				}
				throw new Exception($msg);
			}
			/**
			 * Τώρα που έχουμε nr01 (Έχουμε κάνει save) καλούμε ξανά την invoices_document_after_save_global_check 
			 * για να δούμε τον τρόπο που θα αποσταλεί το παραστατικό (έχουμε αποκλείσει παραπάνω το CnA).
			 */
			$mydt_info = array();
			$invoices_document_after_save_global_check_resp = invoices_document_after_save_global_check('a55',$nr01);
			// Δεν αποστέλλουμε τα παραστατικά με Pegasus
			if($invoices_document_after_save_global_check_resp['data']['einv'] == true) {
				$einv = einv00_check_and_save('a55',$nr01,0);
				if($einv['ok'] != 1) {
					// throw new Exception('einv error: '.$einv['msg']);
					$mydt_info = $einv;
				}
			}
			// Δεν αποστέλλουμε τα παραστατικά με SoftOne
			if($invoices_document_after_save_global_check_resp['data']['einv01'] == true) {
				$mydt_info = array(
					'ok'	=> 0,
					'msg'	=> 'Invcust API: Einv01 not supported for invcust API post'
				);
				//throw new Exception('Invcust API: Einv01 not supported for invcust API post');
			}
			// Αν πρέπει να αποσταλεί με MyData
			if($invoices_document_after_save_global_check_resp['data']['mydt'] == true) {
				$mydt = $this->a55_set_mydt($nr01);
				if(!$mydt['status']) {
					//throw new Exception($mydt['message']);
					$mydt_info = $mydt;
				}
			}
			//	Επιστρέφουμε την εγγραφή που δημιουργήσαμε
			$data = $this->a55_get_one($nr01);
			$ret = array(
				'error'		=> null,
				'data'		=> $data,
				'mydt'		=> $mydt_info
			);
			return $ret;
		} catch (Exception $e) {
			return array(
				'error'		=> $e->getMessage(),
				'data'		=> null,
				'message'	=> $e->getMessage()
			);
		}
	}
	/**
	 *
	 * @param  integer $nr01
	 * @return array
	 */
	private function a55_delete(
		$nr01 = 0
	) {
		try {
			$_REQUEST['no_confim'] = 1;
			$resp = pegasus_mysql_full_delete(
				'a55',
				$nr01,
				0,
				'',
				0,
				array(),
				0,
				array()
			);
			$deny = array();
			foreach ($resp as $v) {
				if ($v['type'] != 'confirm') {
					$deny[] = $v;
				}
			}
			if (!empty($deny)) {
				$message = "";
				foreach ($deny as $pd) {
					if (strtoupper($pd['action']) == 'DELETE') {
						$message .= $_SESSION['peg_dic_core_perm_deny_del_table'];
						$message .= " " . pegasus_mysql_printfld('p50', 'p03',  'p01=?', array($pd['table']));
						$message .=  " (" . $pd['table'] . ")";
						$message .= "<br/>";
					}
				}
				throw new Exception($message);
			}
			return true;
		} catch (Exception $e) {
			return array(
				'error'		=> $e->getMessage(),
				'data'		=> null,
				'message'	=> $e->getMessage()
			);
		}
	}
	/**
	 *
	 * @param  integer $nr01
	 * @param  array   $args
	 * @param  array   $i01
	 * @param  array   $i71
	 * @return array
	 */
	private function a55_update(
		$nr01 = 0,
		$args = array(),
		$i01 = array(),
		$i71 = array()
	) {
		try {
			$request = $_REQUEST;
			$screen = new screen();
			$screen->container_id = pegasus_container_id_create(0, session_id(), 'a55_d');
			$screen->module = 'invcust';
			$screen->_d = 'a55_d';
			$screen->table = 'a55';
			$screen->nr01 = $nr01;
			$screen->read_data_from_db(1, 1);
			$screen->read_params_from_db();
			foreach ($args as $k => $v) {
				$screen->data[$k] = $v;
			}
			// i01, i32, i48, i38 update
			$this->i01_update_tmp(
				"a55_d-$nr01",
				$nr01,
				$nr01,
				$i01
			);
			// i71 update
			$this->i71_update_tmp(
				"a55_d-$nr01",
				$nr01,
				$nr01,
				$i71
			);

			/**
			 * Καλούμε την invoices_document_after_save_global_check μόνο για να δούμε αν το παραστατικό θα 
			 * σταλεί με CnA το οποίο δεν μπορούμε να υποστηρίξουμε.
			 */
			$invoices_document_after_save_global_check_resp = invoices_document_after_save_global_check('a55',$screen->data['nr01']);
			if($invoices_document_after_save_global_check_resp['data']['ca_server'] == true) {
				$signatures_config = ca_server_get_signatures_configuration($screen->data['p05'], $screen->data['p701'], $screen->data['p0121']);
				if ($signatures_config['config_count'] != 0) {
					peg_close_d($screen->container_id);
					throw new Exception('Το Παραστατικό δεν μπόρεσε να καταχωρηθεί γιατί χρειάζεται φορολογικό μηχανισμό.');
				}
			}
			// Αποθήκευση παραστατικού
			$_REQUEST = $screen->data;
			$_REQUEST['no_confirm'] = 1;
			$resp = $screen->save_data();
			peg_close_d($screen->container_id);
			$_REQUEST = $request;
			if ($resp[0] != 1) {
				$msg = '';
				foreach ($resp as $v) {
					if (!empty($v)) {
						$msg .= "$v<br>";
					}
				}
				throw new Exception($msg);
			}
			/**
			 * Τώρα που έχουμε nr01 (Έχουμε κάνει save) καλούμε ξανά την invoices_document_after_save_global_check 
			 * για να δούμε τον τρόπο που θα αποσταλεί το παραστατικό (έχουμε αποκλείσει παραπάνω το CnA).
			 */
			$mydt_info = array();
			$invoices_document_after_save_global_check_resp = invoices_document_after_save_global_check('a55',$nr01);
			// Δεν αποστέλλουμε τα παραστατικά με Pegasus
			if($invoices_document_after_save_global_check_resp['data']['einv'] == true) {
				$einv = einv00_check_and_save('a55',$nr01,0);
				if($einv['ok'] != 1) {
					$mydt_info = $einv;
					//throw new Exception('einv error: '.$einv['msg']);
				}
			}
			// Δεν αποστέλλουμε τα παραστατικά με SoftOne
			if($invoices_document_after_save_global_check_resp['data']['einv01'] == true) {
				$mydt_info = array(
					'ok'	=> 0,
					'msg'	=> 'Invcust API: Einv01 not supported for invcust API post'
				);
				//throw new Exception('Invcust API: Einv01 not supported for invcust API post');
			}
			// Αν πρέπει να αποσταλεί με MyData
			if($invoices_document_after_save_global_check_resp['data']['mydt'] == true) {
				$mydt = $this->a55_set_mydt($nr01);
				if(!$mydt['status']) {
					$mydt_info = $mydt;
					//throw new Exception($mydt['message']);
				}
			}
			//	Επιστρέφουμε την εγγραφή που δημιουργήσαμε
			$data = $this->a55_get_one($nr01);
			$ret = array(
				'error'		=> null,
				'data'		=> $data,
				'mydt'		=> $mydt_info
			);
			return $ret;
		} catch (Exception $e) {
			return array(
				'error'		=> $e->getMessage(),
				'data'		=> null,
				'message'	=> $e->getMessage()
			);
		}
	}
	/**
	 *
	 * @param  integer $nr01
	 * @return array
	 */
	private function a55_set_mydt(
		$nr01 = 0
	) {
		//  Mydt
		$ret = array(
			'status'	=> true,
			'message'	=> 'Καταχώρηση MyData: Επιτυχής'
		);
		$mydt_errors = array();
		$mydt_create_n_send = mydt_create_n_send('a55', $nr01, true);
		foreach ($mydt_create_n_send as $v) {
			if (
				$v['has_pegasus_error'] == 1
                || ($v['has_msg_from_mydt_send_to_aade'] == 1 && $v['ok'] == 0)
			) {
				$mydt_errors[] = $v['msg'] ;
			}
		}
		if (!empty($mydt_errors)) {
			$ret['message'] = 'Καταχώρηση MyData: Απέτυχε <br>'.implode('<br>',$mydt_errors);
			$ret['status'] = false;
		}
		return $ret;
	}
	/**
	 * @todo Na rotisw an prepei na pernei OLA ta pedia tou i01
	 * @return array
	 */
	private function i01_get_participate_fields()
	{
		$i01_fields = array(
			'p01',		//	Eίδος αποθήκης
			'p02',		//	Περιγραφή
			'p0601',	// 	Αιτιολογία
			'p03',		//	Ποσότητα
			'p301',		//	Τεμάχια
			// 'p302',		//	Μήκος
			// 'p304',		//	Υψος
			'p305',		//	Μ.Κ. Είδους Παραγγελίας
			// 'p306',		//	Μικτό Βάρος
			// 'p309',		//	Κόλλα (πλήθος)
			// 'p303',		//	Πλάτος

			// 'p310',		//	Απόβαρο
			// 'p308',		//	Είδος Συσκευασίας
			'p04',		//	Τιμή Μονάδας
			'p010',		//	% Έκπτωσης 1
			'p010a',	//	% Έκπτωσης 2
			'p08',		// %ΦΠΑ
			'p081',		// Κωδικός Κατηγορίας ΦΠΑ
			'p013',		// Ημερομηνία
			//'fp011',
			//'p011',
		);
		return $i01_fields;
	}
	/**
	 *
	 * @param  integer $a55_nr01
	 * @return array
	 */
	private function i01_get_by_a55_nr01(
		$a55_nr01 = 0
	) {
		$i01s = array();
		$sql = "SELECT * FROM i01 WHERE p06 = :p06 AND p07 IN (2)";
		$values = array('p06' => $a55_nr01);
		$res = pegasus_query($sql, $values);
		while ($i01 = pegasus_fetch_assoc($res)) {
			// serial
			if (pegasus_module_exists('serial')) {
				$i32 = $this->i32_select_by_i01_nr01($i01['nr01']);
				if (isset($i32)) {
					$i01['i32'] = $i32;
				}
			}
			// lot
			if (pegasus_module_exists('lot')) {
				$i38 = $this->i38_select_by_i01_nr01($i01['nr01']);
				if (isset($i38)) {
					$i01['i38'] = $i38;
				}
			}
			// colorsize
			if (pegasus_module_exists('colorsize')) {
				$i48 = $this->i48_select_by_i01_nr01($i01['nr01']);
				if (isset($i48)) {
					$i01['i48'] = $i48;
				}
			}
			$i01s[] = $i01;
		}
		return $i01s;
	}
	/**
	 *
	 * @param  integer $a55_nr01
	 * @return array
	 */
	private function a55_get_signature(
		$a55_nr01 = 0
	) {
		pegasus_mysql_use(
			"SELECT  mark, uid, qrurl, auth_cd, tr_fail, einv, series, p011, p012    /* ,y_ekd */
				FROM mydt10 
				WHERE tbl=:tbl 
				AND tbl_nr01=:tbl_nr01", $mydt10, array('tbl'=>'a55', 'tbl_nr01'=>$a55_nr01));
			
		$data['mark'] 		= $mydt10['mark'];
		$data['uid'] 		= $mydt10['uid'];
		$data['qrurl']		= $mydt10['qrurl'];
			
		//Λεκτικά Modules
		$p82_query = 'select p00,p01,ep01 from p82';                    
		$p82_res = pegasus_query($p82_query);
		while($p82_values = pegasus_fetch_assoc($p82_res)){
			$p82_arr['peg_dic_'.$p82_values['p00']] = array("GR"=>$p82_values['p01'], "EN"=>$p82_values['ep01']);
		}
		$mydt10_einv = $mydt10['einv'];
		$lang = $_SESSION['langapi'];
		if($lang == 'EL'){
			$lang = 'GR';
		}

		if($mydt10_einv>0) {                

			//Ενημέρωση της Σειρας Παραστατικού σε περίπτωση που το Παραστατικό αφορά πάροχο Ηλεκτρονικής Τιμολογησης(e-Invoicing ή Softone)
			$signature_array['a55_nr01_a55_nr01_p701'] = $mydt10['series'];    
			if($mydt10_einv == 1) { 
				$error_message = '';
				if($mydt10['tr_fail']==1){
					if($mydt10['y_ekd'] == 1) {
						$error_message = $p82_arr['peg_dic_einv_y_ekd_msg_1'][$lang];
					}else{
						$error_message = $p82_arr['peg_dic_einv_tr_fail_msg_1'][$lang];
					}
				}elseif($mydt10['tr_fail']==2){
					if($mydt10['y_ekd'] == 1) {
						$error_message = $p82_arr['peg_dic_einv_y_ekd_msg_1'][$lang];
					}else{
						if(empty($mydt10["auth_cd"])){ //επιχειρησιακο σφαλμα 
							$error_message = $p82_arr['peg_dic_einv_tr_fail_msg_2_mydata_sync_004'][$lang];
						}else{
							if(empty($mydt10["mark"])){ //temporary auth_Code 
								$error_message = $p82_arr['peg_dic_einv_tr_fail_msg_2_mydata_sync_005'][$lang];
							}
							else{ 
								$error_message = $p82_arr['peg_dic_einv_tr_fail_msg_2_mydata_sync_004_01'][$lang];
							}
						}
					}
				} elseif(
					$mydt10['tr_fail'] == 0
					&& $mydt10['auth_cd'] == ''
				){
					if($mydt10['y_ekd'] == 1) {
						$error_message = $p82_arr['peg_dic_einv_y_ekd_msg_1'][$lang];
					}else{
						$error_message = $p82_arr['peg_dic_einv_tr_fail_msg_0'][$lang];
					}
				} 
				
				$provider_label     = $p82_arr['peg_dic_einv_provider'][$lang];
				$provider_url       = $p82_arr['peg_dic_einv_provider_url'][$lang];
				
				$error_message_tmp  = $error_message;

			}elseif($mydt10_einv == 3) { 
				$error_message = '';
				if($mydt10['tr_fail']==1){
					$error_message = $p82_arr['peg_dic_einv_tr_fail_msg_1'][$lang];
				}elseif($mydt10['tr_fail']==2){
					if(empty($mydt10["auth_cd"])){ 
						$error_message = $p82_arr['peg_dic_einv_provider_ilyda'][$lang];
					}else{
						$error_message = $p82_arr['peg_dic_einv_tr_fail_msg_2_mydata_sync_004_01'][$lang];
					}
				} elseif(
					$mydt10['tr_fail'] == 0
					&& $mydt10['auth_cd'] == ''
				){
					if($mydt10['y_ekd'] == 1) {
						$error_message = $p82_arr['peg_dic_einv_y_ekd_msg_1'][$lang];
					}else{
						$error_message = $p82_arr['peg_dic_einv_tr_fail_msg_0'][$lang];
					}
				} 
				
				$provider_label     = $p82_arr['peg_dic_einv_provider'][$lang];
				$provider_url       = $p82_arr['peg_dic_einv_provider_url'][$lang];
				$error_message_tmp  = $error_message;
			}elseif($mydt10_einv == 2)  {  
				$provider_label     = $p82_arr['peg_dic_einv_provider_softone'][$lang];
				$provider_url       = $p82_arr['peg_dic_einv_provider_softone_url'][$lang];
				$error_message_tmp  = '';
			}

			
			$auth_cd      = $mydt10["auth_cd"];               


		}else{
			$auth_cd        = '';
			
		}    
		$data['auth_cd']   	 		 = $auth_cd;
		$data['provider_label'] 	 = $provider_label;
		$data['provider_url']   	 = $provider_url;
		$data['error_message_tmp']   = $error_message_tmp;
		return $data;
	}
	/**
	 *
	 * @param  string  $mmnr01
	 * @param  integer $mnr01
	 * @param  integer  $nr01
	 * @param  array   $i01s
	 * @return void
	 */
	private function i01_insert_tmp(
		$mmnr01 = '',
		$mnr01 = 0,
		$nr01 = 0,
		$i01s = array()
	) {

		$i01_fields = $this->i01_get_participate_fields();
		foreach ($i01s as $i01) {
			$insert = array();
			foreach ($i01_fields as $field) {
				if (isset($i01[$field])) {
					$insert[$field] = $i01[$field];
				}
			}
			if (empty($insert)) {
				continue;
			}
			$insert['nr01'] = pegasus_mysql_newrec('i01');
			$insert['p06'] = $nr01;
			$insert['p07'] = 2;
			$insert['peg_mnr01'] = $mnr01;
			$insert['peg_mmnr01'] = $mmnr01;
			$insert['peg_sess_id'] = session_id();
			$insert['peg_flag'] = 1;
			// lot
			if (
				pegasus_module_exists('lot')
				&& isset($i01['i38'])
			) {
				$i38_sum = $this->i38_insert_tmp(
					$mmnr01,
					$insert['nr01'],
					$insert['nr01'],
					$i01['i38']
				);
				//	Αν έχουμε lot τότε η ελάχιστη ποσότητα ορίζετε ως το σύνολο (SUM) των lot
				if (
					!($insert['p03'] > 0)
					|| $insert['p03'] < $i38_sum
				) {
					$insert['p03'] = $i38_sum;
				}
				$insert['p301'] = $insert['p03'];
			}
			// color size
			if (
				pegasus_module_exists('colorsize')
				&& isset($i01['i48'])
			) {
				$i48_sum = $this->i48_insert_tmp(
					$mmnr01,
					$insert['nr01'],
					$insert['nr01'],
					$insert['p01'],
					$i01['i48']
				);
				//	Αν έχουμε colorsize τότε η ελάχιστη ποσότητα ορίζετε ως το σύνολο (SUM) των colorsize
				if (
					!($insert['p03'] > 0)
					|| $insert['p03'] < $i48_sum
				) {
					$insert['p03'] = $i48_sum;
				}
				$insert['p301'] = $insert['p03'];
			}
			// serial tmp
			if (
				pegasus_module_exists('serial')
				&& isset($i01['i32'])
			) {
				$this->i32_insert_tmp(
					$mmnr01,
					$insert['nr01'],
					$insert['nr01'],
					$insert['p01'],
					$i01['i32']
				);
				//	Αν έχουμε serial τότε η ελάχιστη ποσότητα ορίζετε ως το σύνολο (COUNT) των serial
				if (
					!($insert['p03'] > 0)
					|| $insert['p03'] < count($i01['i32'])
				) {
					$insert['p03'] = count($i01['i32']);
				}
				$insert['p301'] = $insert['p03'];
			}
			//	Η εγγραφές του i01 γίνονται μετρά από τα serial, lot, colorsize για τυχόν αναπροσαρμογές (πχ ποσότητα)
			pegasus_mysql_insert(
				'peg_tmp_i01',
				array_keys($insert),
				array_values($insert)
			);
		}
	}
	/**
	 *
	 * @param  string  $mmnr01
	 * @param  integer $mnr01
	 * @param  integer $nr01
	 * @param  array   $i01s
	 * @return void
	 */
	private function i01_update_tmp(
		$mmnr01 = '',
		$mnr01 = 0,
		$a55_nr01 = 0,
		$i01s = array()
	) {
		$sql = "	SELECT *
					FROM peg_tmp_i01
					WHERE p06 = :p06
					AND p07 = 2
					AND peg_mnr01 = :peg_mnr01
					AND peg_mmnr01 = :peg_mmnr01
					AND peg_sess_id = :peg_sess_id
					AND peg_flag != 9

		";
		$values = array(
			'p06'			=> $a55_nr01,
			'peg_mnr01'		=> $mnr01,
			'peg_mmnr01'	=> $mmnr01,
			'peg_sess_id'	=> session_id(),
		);
		$res = pegasus_query($sql, $values);
		$tmp_i01 = array();
		while ($rs = pegasus_fetch_assoc($res)) {
			$tmp_i01[$rs['nr01']] = $rs;
		}
		//	Έλεγχος insert / update / delete
		$i01_insert = array();
		$i01_update = array();
		$i01_nr01_delete = array();
		foreach ($i01s as $i01) {
			if (!isset($i01['nr01'])) {
				$i01_insert[] = $i01;
				continue;
			}
			if (!array_key_exists($i01['nr01'], $tmp_i01)) {
				$i01_insert[] = $i01;
				continue;
			}
			$i01_update[] = array(
				'new'	=> $i01,
				'old'	=> $tmp_i01[$i01['nr01']]
			);
			unset($tmp_i01[$i01['nr01']]);
		}
		foreach ($tmp_i01 as $i01) {
			$i01_nr01_delete[] = $i01['nr01'];
		}
		
		// insert
		if (!($i01_insert)) {
			$this->i01_insert_tmp(
				$mmnr01,
				$mnr01,
				$a55_nr01,
				$i01_insert
			);
		}
		// delete
		if (!empty($i01_nr01_delete)) {
			$this->i01_delete_tmp_by_nr01s(
				$mmnr01,
				$mnr01,
				$i01_nr01_delete
			);
		}
		// update
		if (!empty($i01_update)) {
			$where = "
				p06 = :p06
				AND p07 = 2
				AND peg_mnr01 = :peg_mnr01
				AND peg_mmnr01 = :peg_mmnr01
				AND peg_sess_id = :peg_sess_id
				AND peg_flag != 9
				AND nr01 = :nr01
			";
			$values = array(
				'p06'			=> $a55_nr01,
				'peg_mnr01'		=> $mnr01,
				'peg_mmnr01'	=> $mmnr01,
				'peg_sess_id'	=> session_id()
			);
			$i01_fields = $this->i01_get_participate_fields();
			foreach ($i01_update as $i01_upd) {
				$update = array();
				$values['nr01'] = $i01_upd['old']['nr01'];
				foreach ($i01_fields as $field) {
					if ($i01_upd['new'][$field] != $i01_upd['old'][$field]) {
						$update[$field] = $i01_upd['new'][$field];
					}
				}
				if (!empty($update)) {
					$update['peg_flag'] = 2;
					pegasus_mysql_update(
						'peg_tmp_i01',
						array_keys($update),
						array_values($update),
						$where,
						0,
						1,
						1,
						$values
					);
				}
				// i32 update
				if (pegasus_module_exists('serial')) {
					$i32_old = $this->i32_select_by_i01_nr01($i01_upd['old']['nr01']);
					$old = array();
					foreach($i32_old as $i32) {
						$old[$i32['nr01']] = $i32;
					}
					$this->i32_update_tmp(
						$mmnr01,
						$i01_upd['old']['nr01'],
						$i01_upd['old']['nr01'],
						$i01_upd['new']['p01'],
						array(
							'old' => $old,
							'new' => isset($i01_upd['new']['i32']) ? $i01_upd['new']['i32'] : array(),
						)
					);
				}
				// i48 update
				if (pegasus_module_exists('colorsize')) {
					$i48_old = $this->i48_select_by_i01_nr01($i01_upd['old']['nr01']);
					$old = array();
					foreach($i48_old as $i48) {
						$old[$i48['nr01']] = $i48;
					}
					$this->i48_update_tmp(
						$mmnr01,
						$i01_upd['old']['nr01'],
						$i01_upd['old']['nr01'],
						$i01_upd['new']['p01'],
						array(
							'old' => $old,
							'new' => isset($i01_upd['new']['i48']) ? $i01_upd['new']['i48'] : array(),
						)
					);
				}
				// i38 update
				if (pegasus_module_exists('lot')) {
					$i38_old = $this->i38_select_by_i01_nr01($i01_upd['old']['nr01']);
					$old = array();
					foreach($i38_old as $i38) {
						$old[$i38['nr01']] = $i38;
					}
					$this->i38_update_tmp(
						$mmnr01,
						$i01_upd['old']['nr01'],
						$i01_upd['old']['nr01'],
						array(
							'old' => $old,
							'new' => isset($i01_upd['new']['i38']) ? $i01_upd['new']['i38'] : array(),
						)
					);
				}
			}
		}
	}
	/**
	 *
	 * @param  string  $mmnr01
	 * @param  integer $mnr01
	 * @param  integer  $nr01
	 * @return void
	 */
	private function i01_delete_tmp_by_nr01s(
		$mmnr01 = '',
		$mnr01 = 0,
		$i01_nr01s = array()
	) {
		$in = pegasus_mysql_create_in($i01_nr01s, 'i01_nr01');
		$where = "	nr01 IN (" . $in['sql'] . ")
					AND peg_mnr01 = :peg_mnr01
					AND peg_mmnr01 = :peg_mmnr01
					AND peg_sess_id = :peg_sess_id
		";
		$values = $in['sqlParams'];
		$values['peg_mnr01'] = $mnr01;
		$values['peg_mmnr01'] = $mmnr01;
		$values['peg_sess_id'] = session_id();
		$update = array(
			'peg_flag' => 9
		);
		pegasus_mysql_update(
			'peg_tmp_i01',
			array_keys($update),
			array_values($update),
			$where,
			0,1,1,
			$values
		);
	}
	/**
	 *
	 * @param  integer $a55_nr01
	 * @return array
	 */
	private function i71_get_by_a55_nr01(
		$a55_nr01 = 0
	) {
		$sql = "	SELECT *
					FROM i71
					WHERE tbl = 'a55'
					AND tbl_nr = :tbl_nr
					ORDER BY tax
		";
		$values = array('tbl_nr' => $a55_nr01);
		$res = pegasus_query($sql, $values);
		return pegasus_fetchall($res);
	}
	/**
	 *
	 * @return array
	 */
	private function i71_get_participate_fields() {
		return array(
			'i70',
			'i70p02',
			'i70p07',
			'p04',
			'p05',
			'p100',
			'tax',
		);
	}
	/**
	 *
	 * @param  string  $mmnr01
	 * @param  integer $mnr01
	 * @param  integer $a55_nr01
	 * @param  integer $a55_p07
	 * @param  integer $a55_pn02
	 * @param  array   $i71s
	 * @return void
	 */
	private function i71_insert_tmp(
		$mmnr01 = '',
		$mnr01 = 0,
		$a55_nr01 = 0,
		$i71s = array()
	) {
		$fields = $this->i71_get_participate_fields();
		$insert = array();
		if (empty($i71s)) {
			return;
		}
		foreach ($i71s as $i71) {
			$tmp = array();
			foreach ($fields as $field) {
				if (isset($i71[$field])) {
					$tmp[$field] = $i71[$field];
				}
			}
			if (!empty($tmp)) {
				if (!isset($tmp['tax'])) {
					$tmp['tax'] = 0;
				}
				$insert[] = $tmp;
			}
		}
		if (empty($insert)) {
			return;
		}
		//	Κάνουμε sort τους φόρους για να τους προσθέσουμε με την σωστή σειρά (υπολογισμοί με βάση το υφιστάμενο σύνολο)
		usort($insert, array('$this', 'i71_tax_sor'));
		//	Προσθήκη των φόρων
		foreach ($insert as $i71) {
			$i71['nr01']		= pegasus_mysql_newrec('i71');
			$i71['tbl'] 		= 'a55';
			$i71['tbl_nr']		= $a55_nr01;
			//
			$i71['peg_mmnr01'] 	= $mmnr01;
			$i71['peg_mnr01'] 	= $mnr01;
			$i71['peg_sess_id'] = session_id();
			$i71['peg_flag'] 	= 1;
			pegasus_mysql_insert(
				'peg_tmp_i71',
				array_keys($i71),
				array_values($i71)
			);
		}
	}
	/**
	 *
	 * @param  string  $mmnr01
	 * @param  integer $mnr01
	 * @param  array   $a55_nr01
	 * @param  array   $i71s
	 * @return void
	 */
	private function i71_update_tmp(
		$mmnr01 = '',
		$mnr01 = 0,
		$a55_nr01 = array(),
		$i71s = array()
	) {
		$sql = "	SELECT *
					FROM peg_tmp_i71
					WHERE tbl = 'a55'
					AND tbl_nr = :tbl_nr
					AND peg_mnr01 = :peg_mnr01
					AND peg_mmnr01 = :peg_mmnr01
					AND peg_sess_id = :peg_sess_id
					AND peg_flag != 9
		";
		$values = array(
			'tbl_nr'		=> $a55_nr01,
			'peg_mnr01'		=> $mnr01,
			'peg_mmnr01'	=> $mmnr01,
			'peg_sess_id'	=> session_id(),
		);
		$res = pegasus_query($sql, $values);
		$tmp_i71= array();
		while ($rs = pegasus_fetch_assoc($res)) {
			$tmp_i71[$rs['nr01']] = $rs;
		}
		//	Έλεγχος insert / update / delete
		$i71_insert = array();
		$i71_update = array();
		$i71_nr01_delete = array();
		foreach ($i71s as $i71) {
			if (!isset($i71['nr01'])) {
				$i71_insert[] = $i71;
				continue;
			}
			if (!array_key_exists($i71['nr01'], $tmp_i71)) {
				$i71_insert[] = $i71;
				continue;
			}
			$i71_update[] = array(
				'new'	=> $i71,
				'old'	=> $tmp_i71[$i71['nr01']]
			);
			unset($tmp_i71[$i71['nr01']]);
		}
		foreach ($tmp_i71 as $i01) {
			$i71_nr01_delete[] = $i01['nr01'];
		}
		// insert
		if (!empty($i71_insert)) {
			$this->i71_insert_tmp(
				$mmnr01,
				$mnr01,
				$a55_nr01,
				$i71_insert
			);
		}
		// delete
		if (!empty($i71_nr01_delete)) {
			$this->i71_delete_tmp_by_nr01s(
				$mmnr01,
				$mnr01,
				$i71_nr01_delete
			);
		}
		// update
		if (!empty($i71_update)) {
			$where = "
				tbl = 'a55'
				AND tbl_nr = :tbl_nr
				AND peg_mnr01 = :peg_mnr01
				AND peg_mmnr01 = :peg_mmnr01
				AND peg_sess_id = :peg_sess_id
				AND peg_flag != 9
				AND nr01 = :nr01
			";
			$values = array(
				'tbl_nr'		=> $a55_nr01,
				'peg_mnr01'		=> $mnr01,
				'peg_mmnr01'	=> $mmnr01,
				'peg_sess_id'	=> session_id()
			);
			$i71_fields = $this->i71_get_participate_fields();
			foreach ($i71_update as $i71_upd) {
				$update = array();
				$values['nr01'] = $i71_upd['old']['nr01'];
				foreach ($i71_fields as $field) {
					if ($i71_upd['new'][$field] != $i71_upd['old'][$field]) {
						$update[$field] = $i71_upd['new'][$field];
					}
				}
				if (!empty($update)) {
					$update['peg_flag'] = 2;
					pegasus_mysql_update(
						'peg_tmp_i71',
						array_keys($update),
						array_values($update),
						$where,
						0,
						1,
						1,
						$values
					);
				}
			}
		}
	}
	/**
	 *
	 * @param  string  $mmnr01
	 * @param  integer $mnr01
	 * @param  integer  $nr01
	 * @return void
	 */
	private function i71_delete_tmp_by_nr01s(
		$mmnr01 = '',
		$mnr01 = 0,
		$i71_nr01s = array()
	) {
		$in = pegasus_mysql_create_in($i71_nr01s, 'i71_nr01');
		$where = "	nr01 IN (" . $in['sql'] . ")
					AND peg_mnr01 = :peg_mnr01
					AND peg_mmnr01 = :peg_mmnr01
					AND peg_sess_id = :peg_sess_id
		";
		$values = $in['sqlParams'];
		$values['peg_mnr01'] = $mnr01;
		$values['peg_mmnr01'] = $mmnr01;
		$values['peg_sess_id'] = session_id();
		$update = array(
			'peg_flag' => 9
		);
		pegasus_mysql_update(
			'peg_tmp_i71',
			array_keys($update),
			array_values($update),
			$where,
			0,1,1,
			$values
		);
	}
	/**
	 *
	 * @return array
	 */
	private function i32_get_participate_fields()
	{
		return array(
			'p02',		//	Serial Number
		);
	}
	/**
	 *
	 * @param  integer $i01_nr01
	 * @return null|array
	 */
	private function i32_select_by_i01_nr01(
		$i01_nr01 = 0
	) {
		$sql = "	SELECT * FROM i32 WHERE p00 = :p00 AND p010 = 1";
		$values = array('p00' => $i01_nr01);
		$res = pegasus_query($sql, $values);
		if (pegasus_num_rows($res) == 0) {
			return null;
		}
		return pegasus_fetchall($res);
	}
	/**
	 *
	 * @param  string  $mmnr01
	 * @param  integer  $mnr01
	 * @param  integer $i01
	 * @param  integer $i00_pno
	 * @param  array   $i32s
	 * @return void
	 */
	private function i32_insert_tmp(
		$mmnr01 = '',
		$mnr01 = 0,
		$i01 = 0,
		$i00_pno = 0,
		$i32s = array()
	) {
		$i32_fields = $this->i32_get_participate_fields();
		foreach ($i32s as $i32) {
			$insert = array();
			foreach ($i32_fields as $field) {
				if (isset($i32[$field])) {
					$insert[$field] = $i32[$field];
				}
			}
			if (empty($insert)) {
				continue;
			}
			$insert['nr01'] = pegasus_mysql_newrec('i32');
			$insert['p01'] = $i00_pno;							//	Κωδικός Είδους
			$insert['p00'] = $i01;								//	Μ.Κ. Σχετικής Κίνησης
			$insert['p010'] = 1;								//	Κατηγορία Κίνησης
			$insert['peg_mnr01'] = $mnr01;
			$insert['peg_mmnr01'] = $mmnr01;
			$insert['peg_sess_id'] = session_id();
			$insert['peg_flag'] = 1;
			pegasus_mysql_insert(
				'peg_tmp_i32',
				array_keys($insert),
				array_values($insert)
			);
		}
	}
	/**
	 *
	 * @param  string  $mmnr01
	 * @param  integer $mnr01
	 * @param  integer $i01
	 * @param  integer $i00_pno
	 * @param  array   $i32
	 * @return void
	 */
	private function i32_update_tmp(
		$mmnr01 = '',
		$mnr01 = 0,
		$i01 = 0,
		$i00_pno = 0,
		$i32s = array()
	) {
		//	Αν δεν υπάρχουν εγγραφές για έλεγχο
		if (
			(!isset($i32s['old'])
				|| empty($i32s['old'])
			) && (!isset($i32s['new'])
				|| empty($i32s['new'])
			)
		) {
			return;
		}
		//	Έλεγχος insert / update / delete
		$i32_insert = array();
		$i32_update = array();
		$i32_delete_nr01s = array();
		foreach($i32s['new'] as $i32) {
			if(!isset($i32['nr01'])) {
				$i32_insert[] = $i32;
				continue;
			}
			if(!array_key_exists($i32['nr01'],array_keys($i32s['old']))) {
				$i32_insert[] = $i32;
				continue;
			}
			$i32_update[] = array(
				'old' => $i32s['old'][$i32['nr01']],
				'new' => $i32
			);
			unset($i32s['old'][$i32['nr01']]);
		}
		foreach($i32s['old'] as $i32) {
			$i32_delete_nr01s[] = $i32['nr01'];
		}
		// insert
		if(!empty($i32_insert)) {
			$this->i32_insert_tmp(
				$mmnr01,
				$mnr01,
				$i01,
				$i00_pno,
				$i32_insert
			);
		}
		// delete
		if(!empty($i32_delete_nr01s)) {
			$this->i32_delete_tmp_by_nr01s(
				$mmnr01,
				$mnr01,
				$i32_delete_nr01s
			);
		}
		//	update
		if(!empty($i32_update)) {
			$fields = $this->i32_get_participate_fields();
			foreach($i32_update as $i32) {
				$update = array();
				foreach ($fields as $field) {
					if ($i32['old'][$field] != $i32['new'][$field]) {
						$update[$field] = $i32['new'][$field];
					}
				}
				//	Αν εχει αλλάξει το i00.pno του i01
				if ($i32['old']['p01'] != $i00_pno) {
					$update['p01'] = $i00_pno;
				}
				if (!empty($update)) {
					$where = "
						p00 = :p00
						AND p010 = 1
						AND peg_mnr01 = :peg_mnr01
						AND peg_mmnr01 = :peg_mmnr01
						AND peg_sess_id = :peg_sess_id
						AND peg_flag != 9
						AND nr01 = :nr01
					";
					$values = array(
						'p00'			=> $i01,
						'peg_mnr01'		=> $mnr01,
						'peg_mmnr01'	=> $mmnr01,
						'peg_sess_id'	=> session_id(),
						'nr01'			=> $i32['old']['nr01']
					);
					$update['peg_flag'] = 2;
					pegasus_mysql_update(
						'peg_tmp_i32',
						array_keys($update),
						array_values($update),
						$where,
						0,
						1,
						1,
						$values
					);
				}
			}
		}
	}
	/**
	 * 
	 * @param  string  $mmnr01
	 * @param  integer $mnr01
	 * @param  integer $i01
	 * @param  string  $i00_pno
	 * @param  array   $i32_delete_nr01s
	 * @return void
	 */
	private function i32_delete_tmp_by_nr01s(
		$mmnr01 = '',
		$mnr01 = 0,
		$i32_delete_nr01s = array()
	) {
		$in = pegasus_mysql_create_in($i32_delete_nr01s,'i32_nr01');
		$where = "
			nr01 IN (".$in['sql'].")
			AND peg_mnr01 = :peg_mnr01
			AND peg_mmnr01 = :peg_mmnr01
			AND peg_sess_id = :peg_sess_id
			AND peg_flag != 9
		";
		$values = $in['sqlParams'];
		$values['peg_mnr01'] = $mnr01;
		$values['peg_mmnr01'] = $mmnr01;
		$values['peg_sess_id'] = session_id();
		$update = array(
			'peg_flag'	=> 9
		);
		pegasus_mysql_update(
			'peg_tmp_i32',
			array_keys($update),
			array_values($update),
			$where,
			0,1,1,
			$values
		);
	}
	/**
	 *
	 * @return array
	 */
	private function i48_get_participate_fields()
	{
		return array(
			'p02',		//	Κωδ.Χρώματος
			'p03',		//	Κωδ.Μεγέθους
			'p04'		//	Ποσότητα
		);
	}
	/**
	 *
	 * @param  integer $i01_nr01
	 * @return null|array
	 */
	private function i48_select_by_i01_nr01(
		$i01_nr01 = 0
	) {
		$sql = "	SELECT * FROM i48 WHERE p01 = :p01";
		$values = array('p01' => $i01_nr01);
		$res = pegasus_query($sql, $values);
		if (pegasus_num_rows($res) == 0) {
			return null;
		}
		return pegasus_fetchall($res);
	}
	/**
	 *
	 * @param  string  $mmnr01
	 * @param  integer $mnr01
	 * @param  integer $i01
	 * @param  string  $i00_pno
	 * @param  array   $i48s
	 * @return integer
	 */
	private function i48_insert_tmp(
		$mmnr01 = '',
		$mnr01 = 0,
		$i01 = 0,
		$i00_pno = '',
		$i48s = array()
	) {
		$i48_fields = $this->i48_get_participate_fields();
		$sum = 0;
		foreach ($i48s as $i48) {
			$insert = array();
			foreach ($i48_fields as $field) {
				if (isset($i48[$field])) {
					$insert[$field] = $i48[$field];
				}
			}
			$sum += (isset($insert['p04'])) ? $insert['p04'] : 0;
			if (empty($insert)) {
				continue;
			}
			$insert['nr01'] = pegasus_mysql_newrec('i48');
			$insert['i01p01'] = $i00_pno;						//	Κωδ.Είδους
			$insert['p01'] = $i01;								//	Μ.Κ. Σχετικής Κίνησης
			$insert['peg_mnr01'] = $mnr01;
			$insert['peg_mmnr01'] = $mmnr01;
			$insert['peg_sess_id'] = session_id();
			$insert['peg_flag'] = 1;
			pegasus_mysql_insert(
				'peg_tmp_i48',
				array_keys($insert),
				array_values($insert)
			);
		}
		return $sum;
	}
	/**
	 *
	 * @param  string  $mmnr01
	 * @param  integer $mnr01
	 * @param  integer $i01
	 * @param  integer $i00_pno
	 * @param  array   $i48
	 * @return void
	 */
	private function i48_update_tmp(
		$mmnr01 = '',
		$mnr01 = 0,
		$i01 = 0,
		$i00_pno = 0,
		$i48s = array()
	) {
		//	Αν δεν υπάρχουν εγγραφές για έλεγχο
		if (
			(!isset($i48s['old'])
				|| empty($i48s['old'])
			) && (!isset($i48s['new'])
				|| empty($i48s['new'])
			)
		) {
			return;
		}
		//	Έλεγχος insert / update / delete
		$i48_insert = array();
		$i48_update = array();
		$i48_delete_nr01s = array();
		foreach($i48s['new'] as $i48) {
			if(!isset($i48['nr01'])) {
				$i48_insert[] = $i48;
				continue;
			}
			if(!array_key_exists($i48['nr01'],array_keys($i48s['old']))) {
				$i48_insert[] = $i48;
				continue;
			}
			$i48_update[] = array(
				'old' => $i48s['old'][$i48['nr01']],
				'new' => $i48
			);
			unset($i48s['old'][$i48['nr01']]);
		}
		foreach($i48s['old'] as $i48) {
			$i48_delete_nr01s[] = $i48['nr01'];
		}
		// insert
		if(!empty($i48_insert)) {
			$this->i48_insert_tmp(
				$mmnr01,
				$mnr01,
				$i01,
				$i00_pno,
				$i48_insert
			);
		}
		// delete
		if(!empty($i48_delete_nr01s)) {
			$this->i48_delete_tmp_by_nr01s(
				$mmnr01,
				$mnr01,
				$i48_delete_nr01s
			);
		}
		//	update
		if(!empty($i48_update)) {
			foreach($i48_update as $i48) {
				$fields = $this->i48_get_participate_fields();
				$update = array();
				foreach ($fields as $field) {
					if ($i48['old'][$field] != $i48['new'][$field]) {
						$update[$field] = $i48['new'][$field];
					}
				}
				//	Αν εχει αλλάξει το i00.pno του i01
				if ($i48['old']['i01p01'] != $i00_pno) {
					$update['i01p01'] = $i00_pno;
				}
				if (!empty($update)) {
					$where = "
						p01 = :p01
						AND peg_mnr01 = :peg_mnr01
						AND peg_mmnr01 = :peg_mmnr01
						AND peg_sess_id = :peg_sess_id
						AND peg_flag != 9
						AND nr01 = :nr01
					";
					$values = array(
						'p01'			=> $i01,
						'peg_mnr01'		=> $mnr01,
						'peg_mmnr01'	=> $mmnr01,
						'peg_sess_id'	=> session_id(),
						'nr01'			=> $i48['old']['nr01']
					);
					$update['peg_flag'] = 2;
					pegasus_mysql_update(
						'peg_tmp_i48',
						array_keys($update),
						array_values($update),
						$where,
						0,
						1,
						1,
						$values
					);
				}
			}
		}
	}
	/**
	 *
	 * @param  string  $mmnr01
	 * @param  integer $mnr01
	 * @param  integer  $nr01
	 * @return void
	 */
	private function i48_delete_tmp_by_nr01s(
		$mmnr01 = '',
		$mnr01 = 0,
		$i48_nr01s = array()
	) {
		$in = pegasus_mysql_create_in($i48_nr01s, 'i48_nr01');
		$where = "	nr01 IN (" . $in['sql'] . ")
					AND peg_mnr01 = :peg_mnr01
					AND peg_mmnr01 = :peg_mmnr01
					AND peg_sess_id = :peg_sess_id
		";
		$values = $in['sqlParams'];
		$values['peg_mnr01'] = $mnr01;
		$values['peg_mmnr01'] = $mmnr01;
		$values['peg_sess_id'] = session_id();
		$update = array(
			'peg_flag' => 9
		);
		pegasus_mysql_update(
			'peg_tmp_i48',
			array_keys($update),
			array_values($update),
			$where,
			0,1,1,
			$values
		);
	}
	/**
	 *
	 * @return array
	 */
	private function i38_get_participate_fields()
	{
		return array(
			'p02',		//	Παρτίδα
			'p04',		//	Ποσότητα
			'p05',		//	Τεμάχια
		);
	}
	/**
	 *
	 * @param  integer $i01_nr01
	 * @return null|array
	 */
	private function i38_select_by_i01_nr01(
		$i01_nr01 = 0
	) {
		$sql = "	SELECT * FROM i38 WHERE p01 = :p01 AND p010 = 1";
		$values = array('p01' => $i01_nr01);
		$res = pegasus_query($sql, $values);
		if (pegasus_num_rows($res) == 0) {
			return null;
		}
		return pegasus_fetchall($res);
	}
	/**
	 *
	 * @param  string  $mmnr01
	 * @param  integer $mnr01
	 * @param  integer $i01
	 * @param  string  $i00_pno
	 * @param  array   $i38s
	 * @return integer
	 */
	private function i38_insert_tmp(
		$mmnr01 = '',
		$mnr01 = 0,
		$i01 = 0,
		$i38s = array()
	) {
		$i38_fields = $this->i38_get_participate_fields();
		$sum = 0;
		foreach ($i38s as $i38) {
			$insert = array();
			foreach ($i38_fields as $field) {
				if (isset($i38[$field])) {
					$insert[$field] = $i38[$field];
				}
			}
			$sum += (isset($insert['p04'])) ? $insert['p04'] : 0;
			if (empty($insert)) {
				continue;
			}
			$insert['nr01'] = pegasus_mysql_newrec('i38');
			$insert['p01'] = $i01;			//	M.K. Κίνησης
			$insert['p010'] = 1;			//	Είδος Κίνησης
			$insert['peg_mnr01'] = $mnr01;
			$insert['peg_mmnr01'] = $mmnr01;
			$insert['peg_sess_id'] = session_id();
			$insert['peg_flag'] = 1;
			pegasus_mysql_insert(
				'peg_tmp_i38',
				array_keys($insert),
				array_values($insert)
			);
		}
		return $sum;
	}
	/**
	 *
	 * @param  string  $mmnr01
	 * @param  integer $mnr01
	 * @param  integer $i01
	 * @param  integer $i00_pno
	 * @param  array   $i38
	 * @return void
	 */
	private function i38_update_tmp(
		$mmnr01 = '',
		$mnr01 = 0,
		$i01 = 0,
		$i38s = array()
	) {
		//	Αν δεν υπάρχουν εγγραφές για έλεγχο
		if (
			(!isset($i38s['old'])
				|| empty($i38s['old'])
			) && (!isset($i38s['new'])
				|| empty($i38s['new'])
			)
		) {
			return;
		}
		//	Έλεγχος insert / update / delete
		$i38_insert = array();
		$i38_update = array();
		$i38_delete_nr01s = array();
		foreach($i38s['new'] as $i38) {
			if(!isset($i38['nr01'])) {
				$i38_insert[] = $i38;
				continue;
			}
			if(!array_key_exists($i38['nr01'],array_keys($i38s['old']))) {
				$i38_insert[] = $i38;
				continue;
			}
			$i38_update[] = array(
				'old' => $i38s['old'][$i38['nr01']],
				'new' => $i38
			);
			unset($i38s['old'][$i38['nr01']]);
		}
		foreach($i38s['old'] as $i38) {
			$i38_delete_nr01s[] = $i38['nr01'];
		}
		// insert
		if(!empty($i38_insert)) {
			$this->i38_insert_tmp(
				$mmnr01,
				$mnr01,
				$i01,
				$i38_insert
			);
		}
		// delete
		if(!empty($i38_delete_nr01s)) {
			$this->i38_delete_tmp_by_nr01s(
				$mmnr01,
				$mnr01,
				$i38_delete_nr01s
			);
		}
		//	udapte
		if(!empty($i38_update)) {
			foreach($i38_update as $i38) {

			}
		}
		$fields = $this->i38_get_participate_fields();
		$update = array();
		foreach ($fields as $field) {
			if ($i38['old'][$field] != $i38['new'][$field]) {
				$update[$field] = $i38['new'][$field];
			}
		}
		if (!empty($update)) {
			$where = "
				p01 = :p01
				AND p010 = 1
				AND peg_mnr01 = :peg_mnr01
				AND peg_mmnr01 = :peg_mmnr01
				AND peg_sess_id = :peg_sess_id
				AND peg_flag != 9
				AND nr01 = :nr01
			";
			$values = array(
				'p01'			=> $i01,
				'peg_mnr01'		=> $mnr01,
				'peg_mmnr01'	=> $mmnr01,
				'peg_sess_id'	=> session_id(),
				'nr01'			=> $i38['old']['nr01']
			);
			$update['peg_flag'] = 2;
			pegasus_mysql_update(
				'peg_tmp_i38',
				array_keys($update),
				array_values($update),
				$where,
				0,
				1,
				1,
				$values
			);
		}
	}
	/**
	 * 
	 * @param  string  $mmnr01
	 * @param  integer $mnr01
	 * @param  integer $i01
	 * @param  string  $i00_pno
	 * @param  array   $i38_delete_nr01s
	 * @return void
	 */
	private function i38_delete_tmp_by_nr01s(
		$mmnr01 = '',
		$mnr01 = 0,
		$i38_delete_nr01s = array()
	) {
		$in = pegasus_mysql_create_in($i38_delete_nr01s,'i38_nr01');
		$where = "
			nr01 IN (".$in['sql'].")
			AND peg_mnr01 = :peg_mnr01
			AND peg_mmnr01 = :peg_mmnr01
			AND peg_sess_id = :peg_sess_id
			AND peg_flag != 9
		";
		$values = $in['sqlParams'];
		$values['peg_mnr01'] = $mnr01;
		$values['peg_mmnr01'] = $mmnr01;
		$values['peg_sess_id'] = session_id();
		$update = array(
			'peg_flag'	=> 9
		);
		pegasus_mysql_update(
			'peg_tmp_i38',
			array_keys($update),
			array_values($update),
			$where,
			0,1,1,
			$values
		);
	}
}
