<?php

    if (class_exists('PrintsData') === false) {
        if (file_exists('../../pegasus_cloud_app/prints_classes/prints_data.php')) {
            require_once('../../pegasus_cloud_app/prints_classes/prints_data.php');
        } else {
            return;
        }
    }

    class InventoryI00PrintsData extends PrintsData{

        protected function makeBodyData(){
            $body_data = parent::makeBodyData();
            
            if(pegasus_module_exists('colorsize') && $this->p85_input["cs_analysis"]==1){
                //Αν έχω Χρώμα/Μέγεθος και υπάρχει 1-1 συνδεση με τον πινακα i47
                if ($this->p85_input['i47_nr01']>0 || (is_array($this->p85_input['i47_nr01']) && count($this->p85_input['i47_nr01'])>0)) {

                    //Find ColorSize Fields
                    $fields_query  = "select p50.p01 as p50_p01, p50.p03 as p50_p03, p51.* from p51 ";
                    $fields_query .= "join p50 on p50.p02=p51.p02 ";
                    $fields_query .= "join p60 on p60.p00=p51.desc16 ";
                    $fields_query .= "where p50.p01 in ('i47','i40','i43') and p50.p102=1 and p60.isdbfld=1 ";
                    $fields_query .= "order by field(p50.p01,'i47','i40','i43'), p51.desc06,p51.nr01;";
                    //echo pegasus_replace_values_in_sql($fields_query);

                    $result = pegasus_query($fields_query);
                    while ($p51 = pegasus_fetch_assoc($result)) {
                        if ($p51['p50_p01'] == 'i40') {
                            $body_fields[$p51['p50_p01'] . '.' . $p51['desc05']] = 'i47_p02_i40_p01_' . $p51['desc05'];
                        } elseif ($p51['p50_p01'] == 'i43') {
                            $body_fields[$p51['p50_p01'] . '.' . $p51['desc05']] = 'i47_p03_i43_p01_' . $p51['desc05'];
                        } else {
                            $body_fields[$p51['p50_p01'] . '.' . $p51['desc05']] = 'i47_nr01_i47_nr01_' . $p51['desc05'];
                        }
                    }
                    //echo "<pre>". print_r($body_fields,1) . "</pre>";


                    //Add ColorSize Relation
                    $select_fields = '';
                    foreach ($body_fields as $key => $value) {
                        $select_fields .= (!empty($select_fields)) ? ', ' : '';
                        $select_fields .= $key . ' as ' . $value;
                    }


                    $i47_nr01_arr = (is_array($this->p85_input['i47_nr01'])) ? $this->p85_input['i47_nr01'] : array($this->p85_input['i47_nr01']);
                    $in_stmt_arr  = pegasus_mysql_create_in($i47_nr01_arr, 'i47nr01');


                    $query  = "select " . $select_fields . " ";
                    $query .= "from i47 ";
                    $query .= "left join i40 on i40.p01=i47.p02 ";
                    $query .= "left join i43 on i43.p01=i47.p03 ";
                    $query .= "where i47.nr01 in (" . $in_stmt_arr['sql'] . ") ";
                    $query .= "order by i47.p02, i47.p03;";
                    //echo pegasus_replace_values_in_sql($query, $in_stmt_arr['sqlParams']);
                    $result  = pegasus_query($query, $in_stmt_arr['sqlParams']);
                    $i47_arr = pegasus_fetchall($result);

                    $counter = count($body_data);
                    for ($j = 0; $j < $counter; $j++) {
                        if (count($i47_arr[$j]) > 0) {
                            $body_data[$j] = array_merge($body_data[$j], $i47_arr[$j]);
                        }
                    }
                }

                //echo "<pre>". print_r($body_data,1) . "</pre>";
            }

            return  $body_data;
        }


        protected function getBodyExpressions(){
            $body_exps = parent::getBodyExpressions();

            if(pegasus_module_exists('colorsize')){
                $p30_default = 'getBodyData';

                $fields_query  = "select p50.p01 as p50_p01, p50.p03 as p50_p03, p51.* from p51 ";
                $fields_query .= "join p50 on p50.p02=p51.p02 ";
                $fields_query .= "join p60 on p60.p00=p51.desc16 ";
                $fields_query .= "where p50.p01 in ('i47','i40','i43') and p50.p102=1 and p60.isdbfld=1 ";
                $fields_query .= "order by field(p50.p01,'i47','i40','i43'), p51.desc06,p51.nr01;";
                //echo pegasus_replace_values_in_sql($fields_query);

                $result = pegasus_query($fields_query);
                while ($p51 = pegasus_fetch_assoc($result)) {

                    if ($p51['p50_p01'] == 'i40') {
                        $p00 = 'i47_p02_i40_p01_' . $p51['desc05'];
                    } elseif ($p51['p50_p01'] == 'i43') {
                        $p00 = 'i47_p03_i43_p01_' . $p51['desc05'];
                    } else {
                        $p00 = 'i47_nr01_i47_nr01_' . $p51['desc05'];
                    }

                    $p01 = $p51['p50_p03'] . ' -> ' . $p51['desc02'];
                    $p05 = static::getExpressionType($p51['desc07']);

                    $body_exps[] = array('p00' => $p00, 'p01' => $p01, 'p30' => $p30_default, 'p100' => 1, 'p02' => $p51['desc16'], 'p03' => $p51['desc17'], 'p04' => $p51['desc18'], 'p05' => $p05);
                }
            }

            return $body_exps;
        }

    }