<?php
	/**
	 * Η συνάρτηση αυτή παράγει το pno με βάση την αυτόματη παραγωγή
	 * @param string $p9901
	 * @param string $p9902
	 * @param string $p910
	 * @param string $p911
	 * @param string $new_pno
	 * @return array Επιστρέφει ένα array όπου $ret_arr['ok']=0 ή 1, $ret_arr['msg'] μήνυμα λάθους, $ret_arr['pno'] ο κωδικός pno;
	 */

	function inventory_make_pno($p9901, $p9902, $p910, $p911, $new_pno = '')
	{
		$ret_arr = array();
		if ($_SESSION['f01_w_p02'] == 0 or $_SESSION['f01_w_p03'] == 0) {  //αυτοματη αριθμιση απο ψηφιο και για ψηφια
			$ret_arr['ok'] = 0;
			$ret_arr['msg'] = $_SESSION['peg_dic_inventory_no_auto_pno'];
			return $ret_arr;
		}
		$peg_str = "SELECT
						if(i21.nr01 IS NULL, '', i21.w_pc01) as pc01, 
						if(i22.nr01 IS NULL, '', i22.w_pc01) as pc02,
						if(i29.nr01 IS NULL, '', i29.w_pc01) as pc03,
						if(i30.nr01 IS NULL, '', i30.w_pc01) as pc04 
					FROM i21         
					LEFT JOIN i22 ON i22.nr01=?        
					LEFT JOIN i29 ON i29.nr01=?        
					LEFT JOIN i30 ON i30.nr01=?       
					WHERE i21.nr01=?";
		pegasus_mysql_use($peg_str, $tbl, array($p9902, $p910, $p911, $p9901));
		$peg_str = $tbl['pc01'] . $tbl['pc02'] . $tbl['pc03'] . $tbl['pc04'];
		//echo $peg_str;
		if (!empty($peg_str)) {
			$new_pno = $peg_str;
		}
		//    var_dump($new_pno); 
		/*end eyresi kwdikoy apo omada */

		//$new_pno_len = strlen($new_pno);
		$new_pno_len = iconv_strlen($new_pno, 'UTF-8');

		if (iconv_strlen($_SESSION['f01_w_p01'], 'UTF-8') > $new_pno_len) {  //f01_w_p01 Μορφή κωδικού
			$new_pno_len =  iconv_strlen($_SESSION['f01_w_p01'], 'UTF-8'); //strlen($_SESSION['f01_w_p01']);
		}
		$i = 0;
		$peg_str = '';
		while ($new_pno_len > $i) {
			$str_char = mb_substr($_SESSION['f01_w_p01'], $i, 1, 'UTF-8');
			if (strtoupper($str_char) == 'X' or strtoupper($str_char) == 'Χ') {
				$peg_str .= mb_substr($new_pno, $i, 1);
			} elseif ($str_char == '9') {
				$peg_str .= intval(mb_substr($new_pno, $i, 1));
			} elseif (!empty($str_char)) {
				$peg_str .=  $str_char;
			} elseif (!empty(mb_substr($new_pno, $i, 1))) {
				$peg_str .= mb_substr($new_pno, $i, 1);
			} else {
				$peg_str .= '0';
			}

			$i++;
		}

		if (!empty($peg_str)) {
			$new_pno = $peg_str;
		}


		$peg_str = mb_substr($new_pno, 0, ($_SESSION['f01_w_p02'] - 1), 'UTF-8');
		pegasus_mysql_use("SELECT * 
							FROM i00  
							WHERE 
								left(pno, ? )= ? 
								&& char_length(pno)=?
								&& SUBSTR(pno, 1, ?) REGEXP ? 
								/**Μας ενδιαφέρουν μονο τα pno που εχουν νουμερα στο σημείο της αυτόματης αριθμησης*/
							ORDER BY pno DESC 
							LIMIT 1;", 
							$check, 
							array(
								$_SESSION['f01_w_p02'] - 1, 
								$peg_str, 
								($_SESSION['f01_w_p02'] + $_SESSION['f01_w_p03'] - 1), 
								($_SESSION['f01_w_p02'] + $_SESSION['f01_w_p03'] - 1),
								'[0-9]{'.($_SESSION['f01_w_p03'] - 1).'}'
							)
						);
		if ($check['nr01'] > 0) {
			$peg_nnn = str2int(mb_substr($check['pno'], $_SESSION['f01_w_p02'] - 1, $_SESSION['f01_w_p03'], 'UTF-8'));
		} else {
			$peg_nnn = 0;
		}

		$new_pno = $peg_str . pegasus_leading_zeros($peg_nnn + 1, $_SESSION['f01_w_p03']);


		$ret_arr['ok'] = 1;
		$ret_arr['pno'] = $new_pno;
		//$ret_arr['query'] = "SELECT * FROM i00  WHERE left(pno, ".($_SESSION['f01_w_p02']-1).")='".$peg_str."' && length(pno)=" . ($_SESSION['f01_w_p02']+$_SESSION['f01_w_p03']-1) . " ORDER BY pno DESC LIMIT 1;"   ;
		return $ret_arr;
	}

	function inventory_i10_d_initialize($data,$mmnr01,$mnr01,$_d,$container_id){

		if($data['is_std']==1){
			$data['p01_readonly']=true;
			$data['p02_readonly']=true;
		}

		//Παραμετροποίηση myDATA/B2G
		$data['v_q30_620050'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620050", array($data['p01'])); 
		$data['v_q30_620022'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620022", array($data['p01'])); 
		$data['v_q30_620058'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620058", array($data['p01'])); 
		$data['v_q30_620026'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620026", array($data['p01'])); 
		$data['v_q30_620023'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620023", array($data['p01'])); 
		$data['v_q30_620027'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620027", array($data['p01'])); 
		$data['v_q30_620020'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620020", array($data['p01'])); 
		$data['v_q30_620021'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620021", array($data['p01'])); 
		$data['v_q30_620028'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620028", array($data['p01'])); 
		$data['v_q30_620029'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620029", array($data['p01'])); 
		$data['v_q30_620071'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620071", array($data['p01']));
		$data['v_q30_620074'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620074", array($data['p01']));

		if(!pegasus_module_exists('mydt') && pegasus_module_exists('b2g')){
			$data['inventory_i10_d_fset01_title'] = 'Παραμετροποίηση B2G';
		}elseif(pegasus_module_exists('mydt') && !pegasus_module_exists('b2g')){
			$data['inventory_i10_d_fset01_title'] = 'Παραμετροποίηση myDATA';
		}

		return $data;
	}

	function inventory_i10_d_onsave($data , $permDeny , $mmnr01 , $checkOnlyPerm){

		global $PegInput;

		if($data['is_std']==0 and $data['p01']>999999999){
			$permDeny = array(
				array( 
				   'type'=> 'deny',
				   'message'=> $_SESSION['peg_dic_inventory_i00_p01_alert']
				)
			);
		}

		
		//Παραμετροποίηση myDATA/B2G
		if ($checkOnlyPerm == 1){
			$PegInput->addVar(new peg_input_alphanumeric('v_q30_620050', 'request'));
			$PegInput->addVar(new peg_input_alphanumeric('v_q30_620022', 'request'));
			$PegInput->addVar(new peg_input_alphanumeric('v_q30_620058', 'request'));
			$PegInput->addVar(new peg_input_alphanumeric('v_q30_620026', 'request'));
			$PegInput->addVar(new peg_input_alphanumeric('v_q30_620023', 'request'));
			$PegInput->addVar(new peg_input_alphanumeric('v_q30_620027', 'request'));
			$PegInput->addVar(new peg_input_alphanumeric('v_q30_620020', 'request'));
			$PegInput->addVar(new peg_input_alphanumeric('v_q30_620021', 'request'));
			$PegInput->addVar(new peg_input_alphanumeric('v_q30_620028', 'request'));
			$PegInput->addVar(new peg_input_alphanumeric('v_q30_620029', 'request'));
			$PegInput->addVar(new peg_input_alphanumeric('v_q30_620071', 'request'));
			$PegInput->addVar(new peg_input_alphanumeric('v_q30_620074', 'request'));
			$v_q30_620050 = $PegInput->getRequest('v_q30_620050');
			$v_q30_620022 = $PegInput->getRequest('v_q30_620022');
			$v_q30_620058 = $PegInput->getRequest('v_q30_620058');
			$v_q30_620026 = $PegInput->getRequest('v_q30_620026');
			$v_q30_620023 = $PegInput->getRequest('v_q30_620023');
			$v_q30_620027 = $PegInput->getRequest('v_q30_620027');
			$v_q30_620020 = $PegInput->getRequest('v_q30_620020');
			$v_q30_620021 = $PegInput->getRequest('v_q30_620021');
			$v_q30_620028 = $PegInput->getRequest('v_q30_620028');
			$v_q30_620029 = $PegInput->getRequest('v_q30_620029');
			$v_q30_620071 = $PegInput->getRequest('v_q30_620071');
			$v_q30_620074 = $PegInput->getRequest('v_q30_620074');
	
			core00_manage_relation($v_q30_620050, '620050', $data['p01']);
			core00_manage_relation($v_q30_620022, '620022', $data['p01']);
			core00_manage_relation($v_q30_620058, '620058', $data['p01']);
			core00_manage_relation($v_q30_620026, '620026', $data['p01']);
			core00_manage_relation($v_q30_620023, '620023', $data['p01']);
			core00_manage_relation($v_q30_620027, '620027', $data['p01']);
			core00_manage_relation($v_q30_620020, '620020', $data['p01']);
			core00_manage_relation($v_q30_620021, '620021', $data['p01']);
			core00_manage_relation($v_q30_620028, '620028', $data['p01']);
			core00_manage_relation($v_q30_620029, '620029', $data['p01']);
			core00_manage_relation($v_q30_620071, '620071', $data['p01']);
			core00_manage_relation($v_q30_620074, '620074', $data['p01']);
		}

		return array( $data , $permDeny );
	}
	function inventory_i24_d_initialize($data,$mmnr01='',$mnr01='',$_d='',$container_id=''){
		
		$data['v_q30_620060'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620060", array($data['p01'])); 
		$data['v_q30_10000000000'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 10000000000", array($data['p01'])); 
		
		return $data;
	}
	function inventory_i24_d_onchange($data , $permDeny , $mmnr01 , $checkOnlyPerm){

		global $PegInput;
		if ($checkOnlyPerm == 1){
			$PegInput->addVar(new peg_input_alphanumeric('v_q30_620060', 'request'));
			$PegInput->addVar(new peg_input_alphanumeric('v_q30_620060', 'request'));
			$PegInput->addVar(new peg_input_alphanumeric('v_q30_10000000000', 'request'));
			
			$v_q30_620060 = $PegInput->getRequest('v_q30_620060');
			$v_q30_10000000000 = $PegInput->getRequest('v_q30_10000000000');
	
			core00_manage_relation($v_q30_620060, '620060', $data['p01']);
			core00_manage_relation($v_q30_10000000000, '10000000000', $data['p01']);
		}
		
	
		return array($data, $permDeny);
	}

	/**
	 * 
	 */
	function inventory_find_teliki_timh_agoras($p610, $p611e, $p611){

		$p610t = round( ($p610 * ( 100-$p611e)/100) + $p611, $_SESSION['f01_p07']);
		return $p610t; 
	}

	/**
	 * 
	 * @param enum{i22,i29,i30} $mode
	 * @param boolean  checkonlyperm ean einai true kanei elegxo na vre allages 
	 * @param array $data (Ola ta data tou screen)
	 * @param boolean $permDeny (to idi uparxon)
	 * @return array($data, $permDeny)
	 */
	function inventory_category_tree_change($mode,$checkonlyperm, $data,$permDeny){
		$chechData = array();		//To array me ayta poy exw na elegjw
		$newValuesAr = array();		// Oi nees times poy tha kanw update
		$mode = strtolower($mode);
		$tablekey = $data['nr01'];
		$pegdicmakeurl  = '';
		if(pegasus_module_exists('kernel')){
			$pegdicmakeurl  =  '. ' . $_SESSION['peg_dic_inventory_make_url'];
		}
		
		
		switch ($mode) {
			case 'i22':
				if(pegasus_module_exists('invsite')){
					$tblname= findScreenTitle( 'invsite' , 'i05_d'  , 'i05');
					$chechData['i05'] 		= 
						array('msg' =>  ' i05 (' .$tblname . ')'.$pegdicmakeurl,		'field' => 'pe03'  , 'con' => ' and pe02!="'.$data['p01'].'" ', 'fieldstoupd' => array('pe02')); //Eidiki simetoxi
				}
				if(pegasus_module_exists('products')){
					$tblname= findScreenTitle( 'products' , 'herp02_d'  , 'herp02');
					$chechData['herp02']	= 
						array('msg' => ' herp02 (' .$tblname . ')',	'field' => 'i22' , 'con' => ' and i21!="'.$data['p01'].'" ' , 'fieldstoupd' => array('i21')); //Tab eidwn
				}
				if(pegasus_module_exists('pconf')){
					$tblname= findScreenTitle( 'pconf' , 'hpcc01_d'  , 'hpcc01');
					$chechData['hpcc01']	= 
						array('msg' => ' hpcc01 (' .$tblname . ')',	'field' => 'p011', 'con' => ' and p010!="'.$data['p01'].'" ' , 'fieldstoupd' => array('p010'));//PC Configuration
				}
				if(pegasus_module_exists('inventory')){
					$tblname= findScreenTitle( 'inventory' , 'i00_d'  , 'i00');
					$chechData['i00']		= 
						array('msg' => ' i00 (' .$tblname . ')' . $pegdicmakeurl,		'field' => 'p9902', 'con' => ' and p9901!="'.$data['p01'].'" ' , 'fieldstoupd' =>  array('p9901'));//Apothiki
				}
				if(pegasus_module_exists('invcompare')){
					$tblname= findScreenTitle( 'invcompare' , 'i54_d'  , 'i54');
					$chechData['i54']		= 
						array('msg' => ' i54 (' .$tblname . ')',		'field' => 'p011', 'con' =>  ' and p010!="'.$data['p01'].'" ', 'fieldstoupd' => array('p010'));//Sigkritika xaraktiristika
				}
				if(pegasus_module_exists('invprices')){
					$tblname= findScreenTitle( 'invprices' , 'a73_d'  , 'a73');
					$chechData['a73']		= 
						array('msg' => ' a73 (' .$tblname . ')',		'field' => 'p07' , 'con' =>  ' and p01!="'.$data['p01'].'" ', 'fieldstoupd' => array('p01'));//Εκτώσεις πελάτη ανά ομάδα
					$tblname= findScreenTitle( 'invprices' , 'a75_d'  , 'a75');
					$chechData['a75']		=
						array('msg' =>  ' a75 (' .$tblname . ')',		'field' => 'p07', 'con' =>  ' and p01!="'.$data['p01'].'" ', 'fieldstoupd' => array('p01'));//Εκτώσεις προμηθευτή ανά ομάδα
				}
				
				if(!($checkonlyperm)){
					$i21 =$data['p01'];
					$newValuesAr=array($i21);
				}
			break;
			case 'i29':
				if(pegasus_module_exists('invsite')){
					$tblname= findScreenTitle( 'invsite' , 'i05_d'  , 'i05');
					$chechData['i05'] 		= 
						array('msg' =>  ' i05 (' .$tblname . ')'.$pegdicmakeurl,		'field' => 'p910' , 'con' => ' and pe03!="'.$data['p01'].'" ', 'fieldstoupd' => array('pe02', 'pe03')); //Eidiki simetoxi
				}
				if(pegasus_module_exists('products')){
					$tblname= findScreenTitle( 'products' , 'herp02_d'  , 'herp02');
					$chechData['herp02']	= 
						array('msg' => ' herp02 (' .$tblname . ')',	'field' => 'i29' , 'con' => ' and i22!="'.$data['p01'].'" ' , 'fieldstoupd' => array('i21', 'i22')); //Tab eidwn
				}
				if(pegasus_module_exists('pconf')){
					$tblname= findScreenTitle( 'pconf' , 'hpcc01_d'  , 'hpcc01');
					$chechData['hpcc01']	= 
						array('msg' =>  ' hpcc01 (' .$tblname . ')',	'field' => 'p012', 'con' => ' and p011!="'.$data['p01'].'" ' , 'fieldstoupd' => array('p010', 'p011'));//PC Configuration
				}
				if(pegasus_module_exists('inventory')){
					$tblname= findScreenTitle( 'inventory' , 'i00_d'  , 'i00');
					$chechData['i00']		= 
						array('msg' => ' i00 (' .$tblname . ')' . $pegdicmakeurl,		'field' => 'p910', 'con' => ' and p9902!="'.$data['p01'].'" ' , 'fieldstoupd' =>  array('p9901', 'p9902'));//Apothiki
				}
				
				if(pegasus_module_exists('invcompare')){
					$tblname= findScreenTitle( 'invcompare' , 'i54_d'  , 'i54');
					$chechData['i54']		= 
						array('msg' => ' i54 (' .$tblname . ')',		'field' => 'p012', 'con' =>  ' and p011!="'.$data['p01'].'" ', 'fieldstoupd' => array('p010', 'p011'));//Sigkritika xaraktiristika
				}
				if(!($checkonlyperm)){
					$i22 = $data['p01'];
					$i21 = pegasus_mysql_printfld('i22', 'p01', 'nr01="'.$i22.'"');
					$newValuesAr=array($i21,$i22);
				}
			break;
			case 'i30':
				
				if(pegasus_module_exists('invsite')){
					$tblname= findScreenTitle( 'invsite' , 'i05_d'  , 'i05');
					$chechData['i05'] 		= 
						array('msg' => ' i05 (' .$tblname . ')'.$pegdicmakeurl,		'field' => 'p911', 'con' => ' and p910!="'.$data['p01'].'" ' , 'fieldstoupd' => array('pe02', 'pe03','p910')); //Eidiki simetoxi
				}
				if(pegasus_module_exists('products')){
					$tblname= findScreenTitle( 'products' , 'herp02_d'  , 'herp02');
					$chechData['herp02']	= 
						array('msg' => ' herp02 (' .$tblname . ')',	'field' => 'i30', 'con' => ' and i29!="'.$data['p01'].'" ' , 'fieldstoupd' => array('i21', 'i22','i29')); //Tab eidwn
				}
				if(pegasus_module_exists('pconf')){
					$tblname= findScreenTitle( 'pconf' , 'hpcc01_d'  , 'hpcc01');
					$chechData['hpcc01']	= 
						array('msg' =>  ' hpcc01 (' .$tblname . ')',	'field' => 'p013', 'con' => ' and p012!="'.$data['p01'].'" ' , 'fieldstoupd' => array('p010', 'p011','p012'));//PC Configuration
				}
				if(pegasus_module_exists('inventory')){
					$tblname= findScreenTitle( 'inventory' , 'i00_d'  , 'i00');
					$chechData['i00']		= 
						array('msg' => ' i00 (' .$tblname . ')' .$pegdicmakeurl,		'field' => 'p911', 'con' =>  ' and p910!="'.$data['p01'].'" ' , 'fieldstoupd' => array('p9901', 'p9902','p910'));//Apothiki
				}
				if(pegasus_module_exists('invcompare')){
					$tblname= findScreenTitle( 'invcompare' , 'i54_d'  , 'i54');
					$chechData['i54']		= 
						array('msg' => ' i54 (' .$tblname . ')',		'field' => 'p013', 'con' => ' and p012!="'.$data['p01'].'" ' , 'fieldstoupd' => array('p010', 'p011','p012'));//Sigkritika xaraktiristika
				}
				if(!($checkonlyperm)){
					$i29 = $data['p01'];
					$i22 = pegasus_mysql_printfld('i29', 'p01', 'nr01="'.$i29.'"');
					$i21 = pegasus_mysql_printfld('i22', 'p01', 'nr01="'.$i22.'"');
					$newValuesAr=array($i21,$i22,$i29);
				}
				
			break;
			default:
				return array($data ,  $permDeny);
			break;
		}
 	
		foreach ($chechData as $table => $value){
			$where =  ' '. $value['field'].' ="'. $tablekey . '" ' . $value['con'];
			$count = pegasus_mysql_printfld($table, "count(*)", $where);
			if($count>0){
				if($checkonlyperm){
					$conf_text = str_replace('##count##',  $count,$_SESSION['peg_dic_inventory_cat_tree_change'])  ;
					$conf_text .= $value['msg'];
					array_push( $permDeny , array( 'type'=>'CONFIRM' , 'message'=> $conf_text ));
				}else{
					pegasus_mysql_backup_table($table);
					pegasus_mysql_update($table, $value['fieldstoupd'], $newValuesAr, $where); 
				}
			}
		}
		
		return array($data ,  $permDeny);
	}

	

	/**
	 * Make the product photo html code
	 *
	 * @param  int 10 $nr01 the product nr01
	 * @param  char $pno the product code
	 * @param  int 10 $i02nr the nr01 of photo table i02
	 * @param  char $HTMLpars pars to add to html element <img
	 * @param  boolean $onlypath if is true return onle the path with out the html element <img src =...
	 * @return the html photo preview code or the file path.
	 */
	function inventory_MakeProductPhoto($nr01=0, $pno='', $i02nr=0, $HTMLpars="", $onlypath=false, $return_image_width=0, $return_image_height=0, $return_image_type='', $from_tmp_tbl=false,  $peg_tmp_where=''){

		if(empty($return_image_type)){
			$return_image_type = (!empty($_SESSION['herp00_img_type'])) ? $_SESSION['herp00_img_type'] : 'jpg';
		}

		if(str2int($nr01)==0 and strlen($pno)>0){
			$nr01 = pegasus_mysql_printfld('i00', 'nr01', 'pno=?', array($pno));
		}
	
		if(str2int($nr01)>0 and strlen($pno)==0){
			$pno = pegasus_mysql_printfld('i00', 'pno', 'nr01=?', array($nr01));
		}

		$dir_name='/photos/';
		if(!is_dir('../..' . $dir_name)){
			mkdir('../..' . $dir_name);
		}
		$dir_name='/photos/custom_images/';
		if(!is_dir('../..' . $dir_name)){
			mkdir('../..' . $dir_name);
		}
		$dir = opendir('../..' . $dir_name);
		$create_width   = $return_image_width ;
		$create_height  = $return_image_height ;
		$i02whereParams = array();
		if($i02nr>0){
			$i02where = " and nr01=:i02_whr_nr01 " ;
			$i02whereParams = array('i02_whr_nr01'=> $i02nr);
		}
			
		pegasus_mysql_use("	SELECT  i02.p08, i02.nr01, i02.p04, i02.p05, i02.p02 
							FROM i02 where p00=:p00 " . $i02where . " 
							ORDER BY p01 limit 1;" , 
							$i02,
							array_merge($i02whereParams, array('p00'=>$pno)));
		
		if($from_tmp_tbl==true and !empty($peg_tmp_where)){
			$peg_tmp_whereParams = array();
			if(is_array($peg_tmp_where)){
				$peg_tmp_whereSQL    = $peg_tmp_where['sql'];
				$peg_tmp_whereParams = $peg_tmp_where['sqlParams'];
			}else{
				$peg_tmp_whereSQL = $peg_tmp_where;
			}
			pegasus_mysql_use("	SELECT  peg_tmp_i02.p03, peg_tmp_i02.p08, peg_tmp_i02.nr01, peg_tmp_i02.p04, peg_tmp_i02.p05, peg_tmp_i02.p02 
								FROM peg_tmp_i02  
								WHERE 	p00=:mk_prod_photo_p00 and 
										nr01=:mk_prod_photo_nr01 and  
										" . $peg_tmp_whereSQL . " 
								ORDER BY p01 limit 1 ;", 
								$i02_tmp, 
								array_merge(array('mk_prod_photo_p00'=>$pno,'mk_prod_photo_nr01'=>$i02nr),$peg_tmp_whereParams));
			
			if( ($i02_tmp['p04']!= $i02['p04']) or ($i02_tmp['p05']!= $i02['p05']) ){				
				
				$fp   = fopen('../../photos/' .  'i02_tmp_' . $i02_tmp['nr01'] . str_replace('-', '', $i02_tmp['p04']) . str_replace( ':', '', $i02_tmp['p05']). '.' .  $i02_tmp['p08'], 'w+');
				$file = fwrite($fp,  $i02_tmp['p03']);  
				fclose($fp);	
								
				$res  = peg_createtmp_photo('i02_tmp_' . $i02_tmp['nr01'] .str_replace('-', '', $i02_tmp['p04']) . str_replace( ':', '', $i02_tmp['p05']). '.' .  $i02_tmp['p08'], '../../photos/' ,  '../..' . $dir_name, 'i02_tmp_' . $i02_tmp['nr01'] .str_replace('-', '', $i02_tmp['p04']) .str_replace( ':', '', $i02_tmp['p05']). '.' .  $return_image_type, $create_width, $create_height, $return_image_type);
				
				if(!$res){
					if($onlypath){
						return '/' .$_SESSION['main_path']. '/inventory_images/no-image.jpg';
					}else{
						return '<img src="/' .$_SESSION['main_path']. '/inventory_images/no-image.jpg"  ' . $HTMLpars . ' width="' .$create_width . '"  height="' . $create_height . '" border="0">';
					}				
				}else{
					if($onlypath){
						return  $dir_name . 'i02_tmp_' . $i02_tmp['nr01'] .str_replace('-' , '' ,$i02_tmp['p04']) .str_replace( ':' , '' , $i02_tmp['p05']). '.' .  $return_image_type ;
					}else{
						return '<img src="' .$dir_name . 'i02_tmp_' . $i02_tmp['nr01'] .str_replace('-' , '' ,$i02_tmp['p04']) .str_replace( ':' , '' , $i02_tmp['p05']). '.' .  $return_image_type . '" ' . $HTMLpars . '  border="0">';
					}						
				}					
			}					
		}

		

		$where = '';
		$whereParams = array();
		if ($i02['nr01']>0 ) {
			$where = " 	and i02nr=:whr_i02nr  
						and cast(CONCAT(dt , ' ' , tm)  as DATETIME) >= cast(CONCAT(:whr_i02p04 ,  ' ' , :whr_i02p05 ) AS datetime) ";
			$whereParams = array(	'whr_i02nr' => 	$i02['nr01'],
								'whr_i02p04'=>	$i02['p04'],
								'whr_i02p05'=>	$i02['p05'] );
			pegasus_mysql_delete(	'inventory_002' , 
									' 	i00nr=:del_i00nr 
										and i02nr=:del_i02nr
										and cast(CONCAT(dt , " " , tm)  as DATETIME) < cast(CONCAT(:del_i02_p04 ,  " " , :del_i02_p05 ) AS datetime)  ',
									0,
									array( 'del_i00nr'	=>	$nr01,
											'del_i02nr'	=>	$i02['nr01'],
											'del_i02_p04'=>	$i02['p04'],
											'del_i02_p05'=>	$i02['p05']) 
									);
		} 

		pegasus_mysql_use("	SELECT * 
							FROM inventory_002 
							WHERE i00nr=:i00nr ". $where . " and wdth=:wdth and hght=:hght " , 
							$inventory_002,
							array_merge(	array( 'i00nr' => $nr01 , 'wdth' => $create_width , 'hght' => $create_height), 
											$whereParams));
		if($inventory_002['nr01']>0 and file_exists('../..' . $inventory_002['fname'] )){
			if($onlypath){
				return $inventory_002['fname'] ;
			}else{
				return '<img src="' .$inventory_002['fname'] . '"  ' . $HTMLpars . ' border="0">';
			}
		}elseif (	$i02['nr01']>0 and   
					pegasus_mysql_printfld('i02' , 'p03' ,  "p00=:v_pno " . $i02where ,array_merge( array('v_pno'=>$pno) , $i02whereParams ) )!='') {
			
				
				$p03 = pegasus_mysql_printfld('i02' , 'p03' ,  "p00=:v_pno " . $i02where ,array_merge( array('v_pno'=>$pno) , $i02whereParams ) );
				pegasus_mysql_delete(	'inventory_002' , 
										' 	i00nr=:del_i00nr and 
											i02nr=:del_i02nr  and 
											wdth=:del_wdth and 
											hght=:del_hght',
										0,
										array(	'del_i00nr'	=>	$nr01 ,
												'del_i02nr'	=>	$i02['nr01'] ,
												'del_wdth'	=>	$create_width,
												'del_hght'	=>	$create_height) );
				$inventory_002_nr01 = pegasus_mysql_newrec('inventory_002');
				
				$dir_name = $dir_name . pegasus_leading_zeros(trim(substr($inventory_002_nr01 , -3)) , 3) . '/';
				if(!is_dir('../..' . $dir_name)){
					mkdir('../..'  . $dir_name);
				}
				
				$fp = fopen( '../../photos/' .  $inventory_002_nr01  . '.' .  strtolower($i02['p08']) , 'w+');
				$file = fwrite($fp,  $p03 );  
				fclose($fp);

				$res = peg_createtmp_photo($inventory_002_nr01 . '.' .  strtolower($i02['p08']), '../../photos/',  '../..' . $dir_name,  $inventory_002_nr01  . '.' .  $return_image_type, $create_width, $create_height, $return_image_type);
				
				if(!$res){
					if($onlypath){
						return '/' .$_SESSION['main_path']. '/inventory_images/no-image.jpg';
					}else{
						return '<img src="/' .$_SESSION['main_path']. '/inventory_images/no-image.jpg"  ' . $HTMLpars . ' width="' .$create_width . '"  height="' . $create_height . '" border="0">';
					}
				}
				$arr1=array('nr01'); $arr2=array($inventory_002_nr01);
				array_push($arr1 , 'i00nr'); array_push($arr2 , $nr01 );
				array_push($arr1 , 'i02nr'); array_push($arr2 , $i02['nr01'] );
				array_push($arr1 , 'dt')   ; array_push($arr2 , date('Ymd'));
				array_push($arr1 , 'tm')   ; array_push($arr2 , date('H:i:s') );
				array_push($arr1 , 'wdth') ; array_push($arr2 , $create_width );
				array_push($arr1 , 'hght') ; array_push($arr2 , $create_height);
				array_push($arr1 , 'fname'); array_push($arr2 , $dir_name . $inventory_002_nr01  .  '.' .  $return_image_type  );
				pegasus_mysql_insert('inventory_002' , $arr1 , $arr2);

				

				unlink('../../photos/' . $inventory_002_nr01  . '.' .  strtolower($i02['p08']));

				if($onlypath){
					return  $dir_name . $inventory_002_nr01  . '.' . $return_image_type   ;
				}else{
					return '<img src="' .$dir_name . $inventory_002_nr01  . '.' . $return_image_type . '" ' . $HTMLpars . '  border="0">';
				}
		}elseif (url_exists($i02['p02']) ) {
				if($onlypath){
					return $i02['p02'];
				}else{
					return '<img src="' .$i02['p02'] . '" width="' .$create_width . '"  height="' . $create_height . '" border="0">';
				}

		}else{
				if($onlypath){
					return '/' .$_SESSION['main_path']. '/inventory_images/no-image.jpg';
				}else{
					return '<img src="/' .$_SESSION['main_path']. '/inventory_images/no-image.jpg"  ' . $HTMLpars . ' border="0"> ';
				}
		}
	}

	function peg_inventory_i02_d00_initialize($data,$mmnr01='',$mnr01='',$_d='',$container_id=''){
		if(pegasus_mysql_printfld('i00','nr01','pno=?',array($_REQUEST['i00pno']))>0){
			$data['p00']=$_REQUEST['i00pno'];
			pegasusSetGlobalVar( $container_id . '_where' ,  
								array( 	'sql'		=>'i02.p00=:i02p00 ',
										'sqlParams' =>	array(	'i02p00' => $_REQUEST['i00pno']) 
								));
		}
		return $data;
	}

	/**
	 * Return array keys and array of defulat values (from session)
	 */
	function peg_inventory_i00_get_default_values($is_service_only=0){
		//Map table's fields to default values
		$default_values_from_session=array(
			'fpa'=>'inventory_000_p501',	//FPA
			'pgef'=>'inventory_000_p013'	//kwdikos sindesis logistikhs
		);
		$default_values=array();
		// Get Session Value for each default table field
		foreach($default_values_from_session as $fieled_name=>$session_name){
				$default_values[$fieled_name]=$_SESSION[$session_name];
		}
		if($is_service_only==1 || !pegasus_module_exists('inventory00')){
			$default_values['ths']=$_SESSION['inventory01_00_i00ths'];
			$default_values['p62']=$_SESSION['inventory01_00_i00p62'];
			$default_values['p202'] = $_SESSION['inventory01_00_fi00p202'];
		}
		else{
			$default_values['ths']=$_SESSION['inventory_000_p502'];		//Basikh monada m.	
		}
		return $default_values;
	}

	function peg_inventory_i00_d_initialize($data,$mmnr01='',$mnr01='',$_d='',$container_id=''){
		
		//Υπηρεσίες
		if(
			(isset($_REQUEST['service_only']) && $_REQUEST['service_only']==1) || 
			!pegasus_module_exists('inventory00')
		){
			$data = peg_inventory01_i00_d_initialize($data,$mmnr01,$mnr01,$_d,$container_id);
			$service_only =  1;
		}
		else{
			$service_only =  0;
			pegasusSetGlobalVar($container_id . '_where_p62', ' p300=1 ') ;
		}

		//Skroutz Marketplace
		if(pegasus_module_exists('products04') && $_REQUEST['parent_screen']=='products04_02_d'){
			$data = products04_i00_d_initialize($data, $mmnr01, $mnr01, $_d, $container_id);
		}

		if(empty($data['nr01']) and empty($_REQUEST['rec_copy_nr01'])){
			// Set Default values
			$default_values=peg_inventory_i00_get_default_values($service_only);
			foreach($default_values as $default_field=>$default_value){
				$data[$default_field]=$default_value;
			}
		}
		
	    /* Eιδικοι τιμοκατάλογοι */
	    $peg_is_newrec = 0;

		$data = inventory_find_prices($data, "i00_init");

		//Παραμετροποίηση myDATA/B2G
		$data['v_q30_620067'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620067", array($data['pno']));
		$data['v_q30_620070'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620070", array($data['pno']));

	    if(!empty($data['pno'])){
	    	pegasus_mysql_use("	select sum(p03) as p03 
	    						FROM i00tot 
	    						WHERE 	i00tot.pno1=:pno1
	    								and i00tot.p610>=:p610_0
	    								and i00tot.p610<=:p610_1 " ,
	    					  $peg_tmprec, 
	    					  array('pno1'	=>	$data['pno'],
							  		'p610_0'=>	$_SESSION['cor003_p303'],
							  		'p610_1'=>	$_SESSION['cor003_p304']));

			$data['v_locbaltot']= $peg_tmprec['p03'];
			if(pegasus_module_exists('ordercust')){
				pegasus_mysql_use("select sum(p04) as tot from i00tot where pno1=?" ,$peg_tmprec ,array($data['pno']));
				$data['v_cusord']= $peg_tmprec['tot'];
			}
			if(pegasus_module_exists('ordersupp')){
				pegasus_mysql_use("select sum(p05) as tot from i00tot where pno1=?" ,$peg_tmprec ,array($data['pno']));
				$data['v_suppsord']= $peg_tmprec['tot'];
			}
			if(pegasus_module_exists('interorder')){
				pegasus_mysql_use("select sum(p06) as tot from i00tot where pno1=?" ,$peg_tmprec ,array($data['pno']));
				$data['v_interord']= $peg_tmprec['tot'];
			}

			pegasus_mysql_use(" SELECT MAX(p013) 
								from i01
								left join i00 on i01.p01 = i00.pno
								left join i15 on i01.p05 = i15.p01
								where 	i00.nr01 = :i00_nr01
										and i15.p03 = 1 
										and i15.p101 = 0", 
								$max_i01_p013, 
								array('i00_nr01' => $data['nr01']));
			// var_dump($max_i01_p013);
			// var_dump($data['v_last_purchase']);
			$data['v_last_purchase'] = $max_i01_p013['MAX(p013)'];  
	    }
		
	    if($_d=='i00_d'){
	        if(empty($data['nr01'])){
	            $data['nr01'] = pegasus_mysql_newrec("i00");
	            $peg_is_newrec =1 ;
			}

			/**
			 * Εξαιρέσεις για τα module lot και Serial
			 * p904 -->
			 * ps01 -->
			 */
			if(!pegasus_module_exists('lot')){
				$data['p904_hidden']=1;
			}
			if(!pegasus_module_exists('serial')){
				$data['ps01_hidden']=1;
				$data['psm01_hidden']=1;
			}	

			if(pegasus_module_exists('lotf')){
				pegasus_mysql_use("select * from lotf01 where lotf01.i00=?;" , $lotf01, array($data['nr01']));
				
				$data['lotf01_i00'] = $lotf01['i00'];
				$data['lotf01_en']  = $lotf01['en'];
				$data['lotf01_p01'] = $lotf01['p01'];
				$data['lotf01_p02'] = $lotf01['p02'];

			}

			if(pegasus_module_exists('geopon')){
				$res_gepa01 = array();
				pegasus_mysql_use("SELECT gepa82.p03 AS gepa82_p03,
										  gepa01.p01,
										  gepa01.p02_p101,
										  gepa01.p03_p101,
										  gepa01.p04,
										  gepa01.p05_p101
								   FROM gepa01 
								   LEFT JOIN gepa82 ON gepa82.p101 = gepa01.p02_p101
								   WHERE gepa01.p01=?;", $res_gepa01, array($data['pno']));
				
				$data['gepa01_p01']      	 = $res_gepa01['p01'];
				$data['gepa01_p02_p101'] 	 = $res_gepa01['p02_p101'];
				$data['gepa01_p03_p101'] 	 = $res_gepa01['p03_p101'];
				$data['gepa01_p04']      	 = $res_gepa01['p04'];
				$data['gepa01_p05_p101'] 	 = $res_gepa01['p05_p101'];
				$data['gepa01_v_gepa82_p03'] = $res_gepa01['gepa82_p03'];
			}

			//Διαδοχή
			if($peg_is_newrec == 1 && !($_REQUEST['rec_copy_nr01'] > 0)){
				$data['ptax'] = 9999;
			}
			
			//Υπηρεσία ή προϊόν. Ανεξάρτητη από το container ID γιατί θα χρησιμοποιηθεί σε διάφορες οθόνες π.χ. i01_d100, στο save του i00 κοκ
			pegasusSetGlobalVar( 'peg_'.$data['nr01'] . '_service_only' , $service_only );

			/* For PDO-compatible grids*/
			$whereTmpTbl_prep = ' peg_flag!=9 and
								  peg_sess_id=:peg_sess_id  and 
								  peg_mmnr01=:peg_mmnr01 and 
								  peg_mnr01=:peg_mnr01 ';

			$whereTmpTbl_prep_arr=array(  	'peg_sess_id'	=>	session_id(),
											'peg_mmnr01'	=>	'i00_d-'.$data['nr01'] ,
											'peg_mnr01'		=>	$data['nr01']);
	        //Dimiourgoume ola ta tmp
	        pegasus_make_all_tmp_recs('i00' , $data , $data['nr01'] , $_REQUEST['rec_copy_nr01'] , 'i00_d-'.$data['nr01'] );
	        
	        if( $peg_is_newrec==0 ){
	            //Gia tis dyndeseis poy den einai me mk
	            //Photo eidwn
	            $pno=pegasus_mysql_printfld('i00','pno','pno=?',array($data['pno']));
				pegasusSetGlobalVar($container_id. '_where_i02' , 
									array(	'sql'		=>	' peg_tmp_i02.p00=:pno and '.$whereTmpTbl_prep ,
											'sqlParams'	=>	array_merge($whereTmpTbl_prep_arr,array('pno'=>$pno ))
									));
	            //eidikoi kwdikoi
	            //XXX DEN EXEI TMP
				pegasusSetGlobalVar($container_id . '_where_i08' ,  
									array(	'sql'		=>	' i08.pe01=:pno ',
											'sqlParams'	=>	array('pno'=>$pno )
									));
	        }else{
				//Συμπληρώνω τις τιμες των markup
				if(empty($_REQUEST['rec_copy_nr01'])){
					$data['tim2'] = pegasus_mysql_printfld('i23','p03', 'p01=2');
					$data['tim3'] = pegasus_mysql_printfld('i23','p03', 'p01=1');
					$data['tim4'] = pegasus_mysql_printfld('i23','p03', 'p01=3');			
				}
	        	  $data['toolbarbutton_140000021000005_hidden'] = true;
	        }
			pegasus_mysql_use(
				"select peg_i00cost(i00.pno,?,?,?,?,?,?) as cost from i00 where pno=?",
				$ret_arr,
				array('0100-01-01', date('Y-m-d'), 0, 999999, $data['p414'], 0, $data['pno'])
			);
			$data['v_timh'] = $ret_arr['cost'];
	        
			//Dikaivmata 
			pegasusSetGlobalVar( $container_id . '_where_heru10' , 
								array(	'sql'		=>	' peg_tmp_heru10.tbl_nr01=:i00 and peg_tmp_heru10.tbl="i00" and '.$whereTmpTbl_prep ,
										'sqlParams'	=>	array_merge($whereTmpTbl_prep_arr,array('i00'=>$data['nr01']))
			 					));

	        //Xroma Megethos
			pegasusSetGlobalVar( $container_id . '_where_i47' , 
								array(	'sql'		=>	' peg_tmp_i47.i00=:i00 and '.$whereTmpTbl_prep ,
										'sqlParams'	=>	array_merge($whereTmpTbl_prep_arr,array('i00'=>$data['nr01']))
			 					) );
	        
	        //Antisixier eidwn
			pegasusSetGlobalVar( $container_id. '_where_i36'  , 
								array(	'sql'		=>	' (peg_tmp_i36.i00_1=:i00_1 or peg_tmp_i36.i00_2=:i00_2 )  and '.$whereTmpTbl_prep ,
										'sqlParams'	=>	array_merge($whereTmpTbl_prep_arr,array('i00_1'=>$data['nr01'],'i00_2'=>$data['nr01']))
			 					));
	        //Texnika keimena
			pegasusSetGlobalVar($container_id. '_where_i06' , 
								array(	'sql'		=>	' peg_tmp_i06.i00=:i00 and '.$whereTmpTbl_prep ,
										'sqlParams'	=>	array_merge($whereTmpTbl_prep_arr,array('i00'=>$data['nr01']))
			 					));
	        //Sigkritika xaraktiristika
			pegasusSetGlobalVar($container_id . '_where_i39' , 
								array(	'sql'		=>	' peg_tmp_i39.i00=:i00 and '.$whereTmpTbl_prep ,
										'sqlParams'	=>	array_merge($whereTmpTbl_prep_arr,array('i00'=>$data['nr01']))
			 					));
	        //Συνταγή Είδους
			pegasusSetGlobalVar($container_id. '_where_i19' , 
								array(	'sql'		=>	' peg_tmp_i19.i00=:i00 and '.$whereTmpTbl_prep ,
										'sqlParams'	=>	array_merge($whereTmpTbl_prep_arr,array('i00'=>$data['nr01']))
			 					));
	        
	        //Eidiki simetoxi
	        pegasusSetGlobalVar( $container_id . '_where_i05_prep' , 
								array(	'sql'		=>	' peg_tmp_i05.i00=:i00 and '.$whereTmpTbl_prep ,
										'sqlParams'	=>	array_merge($whereTmpTbl_prep_arr,array('i00'=>$data['nr01']))
			 					));
	        if( $_REQUEST['rec_copy_nr01']>0 and pegasus_mysql_table_exists('i05')){
				pegasus_mysql_update(	'peg_tmp_i05' , 
										array('peg_flag') , array('9') , 
										' peg_tmp_i05.i00=:i00 and '.$whereTmpTbl_prep .  ' and master=1',
										0,1,1,
										array_merge($whereTmpTbl_prep_arr,array('i00'=>$data['nr01'])));
	        }
	       
	        //Kathgories photo galery
			pegasusSetGlobalVar($container_id. '_where_herpg9' , 
								array(	'sql'		=>	' peg_tmp_herpg9.i00=:i00 and '.$whereTmpTbl_prep ,
										'sqlParams'	=>	array_merge($whereTmpTbl_prep_arr,array('i00'=>$data['nr01']))
			 					));
	        //Videos
			pegasusSetGlobalVar($container_id. '_where_herp80'  , 
								array(	'sql'		=>	' peg_tmp_herp80.i00=:i00 and '.$whereTmpTbl_prep ,
										'sqlParams'	=>	array_merge($whereTmpTbl_prep_arr,array('i00'=>$data['nr01']))
			 					));
	        //Download
			pegasusSetGlobalVar( $container_id . '_where_hdow05_d00'  ,
								 array(	'sql'		=>	' peg_tmp_hdow05.i00=:i00 and '.$whereTmpTbl_prep ,
										'sqlParams'	=>	array_merge($whereTmpTbl_prep_arr,array('i00'=>$data['nr01']))
			 					) );
	        //Eidikes times - Ποσοτικές Τιμές
			pegasusSetGlobalVar($container_id . '_where_i37'  ,  
								array(	'sql'		=>	' peg_tmp_i37.i00=:i00 and '.$whereTmpTbl_prep ,
										'sqlParams'	=>	array_merge($whereTmpTbl_prep_arr,array('i00'=>$data['nr01']))
			 					));
	        //Eidikes times - Τιμές Ανά Ειδικό Τιμοκατάλογο
	        //Den to xrisimopoiei
			pegasusSetGlobalVar($container_id . '_where_i17'  ,  
								array(	'sql'		=>	' peg_tmp_i17.i00=:i00 and '.$whereTmpTbl_prep ,
										'sqlParams'	=>	array_merge($whereTmpTbl_prep_arr,array('i00'=>$data['nr01']))
								 ) );
			//Επιπλέον Ομαδοποίηση
			pegasusSetGlobalVar($container_id . '_where_products02_01' , 
								array(	'sql'		=>	' peg_tmp_products02_01.i00=:i00 and '.$whereTmpTbl_prep ,
										'sqlParams'	=>	array_merge($whereTmpTbl_prep_arr,array('i00'=>$data['nr01']))
								));

			//Ειδικές τιμές Προμηθευτή συγκεκριμένου είδους αποθήκης
			pegasusSetGlobalVar($container_id. '_where_a74', 
								array(	'sql' 		=> ' a74.p01=:pno ',
										'sqlParams' => array("pno"=>$data['pno'])
								));

			//Ειδικές τιμές Πελάτη συγκεκριμένου είδους αποθήκης
			pegasusSetGlobalVar($container_id. '_where_a72', 
								array(	'sql' 		=> ' a72.p01=:pno ',
										'sqlParams' => array("pno"=>$data['pno'])
								));
								
			pegasusSetGlobalVar($container_id . '_i00_d_pno' , $data['pno']);	

			//Elaxista/Megista
			$select  = 'select group_concat(concat("peg_tmp_i28.", desc05)) as name from p51 where p02="i28_d" and desc16!="" and desc05 not in ("p05") and desc16!="V";';        
			pegasus_mysql_use($select, $fields);
			
			$fields_var = '';
			foreach(array('p03', 'p04', 'p05', 'p06') as $fld){
				$fields_var .= 'ifnull((select sum(i00tot_in.'.$fld.') as '.$fld.' from i00tot as i00tot_in where i00tot_in.pno1=i00.pno and i00tot_in.p610=i16.p00 group by i00tot_in.pno1), 0) ';
				$fields_var .= 'as v_i00tot_'.$fld;	
				$fields_var .= ', ';
			}
		
			$query_i28  = 'select i16.p00 as p05, i16.p01 as v_selectbox_p05, ';
			$query_i28 .= $fields_var;
			$query_i28 .= $fields['name'] . ' ';
			$query_i28 .= 'from i16 ';
			$query_i28 .= 'left join i00 on i00.pno=:pno ';
			$query_i28 .= 'left join peg_tmp_i28 on peg_tmp_i28.p05=i16.p00 and peg_tmp_i28.p06 = "" and peg_tmp_i28.p07 = "" and peg_tmp_i28.p01=i00.pno and '. $whereTmpTbl_prep .';';

			pegasusSetGlobalVar($container_id . '_where_i28_query',  
								array('sql'		  => $query_i28,
									  'sqlParams' => array_merge($whereTmpTbl_prep_arr, array('pno'=>$data['pno']))
									)
								);

			$fields_var = '';

			$fields_var .= '
				ifnull(
					(
						select sum(i47tot_in.p05) as p05 
						from i47tot as i47tot_in 
						where i47tot_in.p01=i00.pno and 
							  i47tot_in.p02=i16.p00 and
							  i47tot_in.p03=i40.p01 and
							  i47tot_in.p04=i43.p01
						group by i47tot_in.p01
					), 0) as v_i00tot_p03, ';
				
			$fields_var .= '
				ifnull(
					(
						select sum(i47tot_in.p06) as p06 
						from i47tot as i47tot_in 
						where i47tot_in.p01=i00.pno and 
							  i47tot_in.p02=i16.p00 and
							  i47tot_in.p03=i40.p01 and
							  i47tot_in.p04=i43.p01
						group by i47tot_in.p01
					), 0) as v_i00tot_p04, ';

			$fields_var .= '
				ifnull(
					(
						select sum(i47tot_in.p07) as p07 
						from i47tot as i47tot_in 
						where i47tot_in.p01=i00.pno and 
							  i47tot_in.p02=i16.p00 and
							  i47tot_in.p03=i40.p01 and
							  i47tot_in.p04=i43.p01
						group by i47tot_in.p01
					), 0) as v_i00tot_p05, ';

			$fields_var .= '
				ifnull(
					(
						select sum(i47tot_in.p08) as p08 
						from i47tot as i47tot_in 
						where i47tot_in.p01=i00.pno and 
								i47tot_in.p02=i16.p00 and
								i47tot_in.p03=i40.p01 and
								i47tot_in.p04=i43.p01
						group by i47tot_in.p01
					), 0) as v_i00tot_p06, ';

			$query_i28_d01  = 'select i16.p00 as p05, i16.p01 as v_selectbox_p05, ';
			$query_i28_d01 .= $fields_var;
			$query_i28_d01 .= 'peg_tmp_i28.nr01, peg_tmp_i28.p01, peg_tmp_i28.p02, peg_tmp_i28.p03, peg_tmp_i28.p04, ';
			$query_i28_d01 .= 'i47.p02 as p06, i47.p03 as p07, ';
			$query_i28_d01 .= 'if("'.$_SESSION['lang'].'" = "GR", i40.p02, i40.ep02) as p06_1, ';
			$query_i28_d01 .= 'if("'.$_SESSION['lang'].'" = "GR", i43.p02, i43.ep02) as p07_1 '; 
			$query_i28_d01 .= 'from i16 ';
			$query_i28_d01 .= 'left join i00 on i00.pno=:pno ';
			$query_i28_d01 .= 'left join i47 on i47.p01 = i00.pno ';
			$query_i28_d01 .= 'left join peg_tmp_i28 on peg_tmp_i28.p05=i16.p00 and peg_tmp_i28.p06 = i47.p02 and peg_tmp_i28.p07 = i47.p03 and peg_tmp_i28.p01=i00.pno and '. $whereTmpTbl_prep .' ';
			$query_i28_d01 .= 'left join i40 on i40.p01 = i47.p02 ';
			$query_i28_d01 .= 'left join i43 on i43.p01 = i47.p03 ';

			pegasusSetGlobalVar($container_id . '_where_i28_d01_query',  
								array('sql'		  => $query_i28_d01,
									  'sqlParams' => array_merge($whereTmpTbl_prep_arr, array('pno'=>$data['pno']))
									)
								);	

			$data['#where_i28_query'] = pegasus_replace_values_in_sql($query_i28,array_merge($whereTmpTbl_prep_arr, array('pno'=>$data['pno'])));

			// $data['#where_i28_d01_query'] = pegasus_replace_values_in_sql($query_i28_d01,array_merge($whereTmpTbl_prep_arr, array('pno'=>$data['pno'])));
	        
	    }
		
	    return $data;
	}

	function peg_inventory_i00_d5_initialize($data,$mmnr01='',$mnr01='',$_d='',$container_id=''){
	    	
	    $f01_p014=$_SESSION['f01_p014'];
		$v_weight=0;
		if($f01_p014!=0){
			$v_weight=$data['p907_1']*$data['p907_2']*$data['p907_3']*1000000 /$f01_p014;
		}
		$data['vp906_1'] =$v_weight;
		$volume =$data['p907_1']*$data['p907_2']*$data['p907_3'];
		if($volume==0){ //υπάρχει έστω κι ενα μηδέν => βάζει τον όγκο με το χέρι
		    $data['p907_readonly']=0;
		}else{
			$data['p907']=$volume;
	   	 	$data['p907_readonly']=1;
		}
		if($data['p616p']>0){
			$data['p616_readonly']=1;
			$data['p616']=0;
		} 

		if(!pegasus_module_exists('ordecust') && !pegasus_module_exists('ordersupp') && !pegasus_module_exists('interorder')){
			$data['reserv_quan_fldset_hidden'] = 1;
		}

		if(!pegasus_module_exists('retail00')) {
			// Στοιχεία Retail Hidden
			$data['inventory_i00_d6_fset03_hidden'] = 1;
		}
	    return $data;
	}

	function peg_inventory_i02_d_initialize($data,$mmnr01='',$mnr01='',$_d='',$container_id=''){
		if($_d=='i02_d'){
			if(empty($data['nr01'])){
	            $data['nr01'] = pegasus_mysql_newrec("i02");
	           
	        }
	        $data['p00'] = pegasus_mysql_printfld('i00' , 'pno' , 'nr01=?',array($mnr01));
	    }
		if(substr($mmnr01,0,5) == 'i00_d'){	
			//Photo eidous
			pegasusSetGlobalVar( 	$container_id . '_where_clsa01'  , 
									array(	
										'sql'		=> ' peg_tmp_clsa01.p01=:clsa01_p01 
														 and peg_flag!=9 
														 and peg_sess_id=:clsa01_peg_sess_id 
														 and peg_mmnr01=:clsa01_peg_mmnr01 
														 and peg_mnr01=:clsa01_peg_mnr01', 
										'sqlParams'	=> array(	'clsa01_p01'		=>	$data['nr01'],
																'clsa01_peg_sess_id'=>	session_id(),
																'clsa01_peg_mmnr01'	=>	'i00_d-'.$mnr01,
																'clsa01_peg_mnr01'	=>	$data['nr01'])
									));
		}
		 pegasus_make_all_tmp_recs('i02' , $data , $data['nr01'] , $_REQUEST['rec_copy_nr01'] , 'i00_d-'.$data['nr01'] );
	       
	    return $data;
	}

	function peg_inventory_i02_d_onsave($data,$mmnr01='',$mnr01='',$_d='',$container_id=''){
		//if($_d=='i02_d'){
			if(empty($data['p02'])  and empty($data['p03']) ){
				//array_push( $permDeny , array( 'type'=>'deny' , 'message'=>   $_SESSION['peg_dic_inventory_photo_not_empty'] ) );
			}
		//}
		 return array($data, $permDeny);
	}

	function peg_inventory_i00_d_change($data , $permDeny , $mmnr01 , $checkOnlyPerm, $grid_editing){
		global $PegInput;

		// plno not exists
		if( !empty($data['plno']) and pegasus_mysql_printfld('i00', 'nr01', "pno=?" ,array($data['plno']) )==0)
		{ array_push( $permDeny , array( 'type'=>'deny' , 'message'=>$_SESSION['peg_dic_inventory_i00_002'])); 
		}
		// i00.pno (pno)
		if( pegasus_mysql_printfld('i00', 'nr01', "nr01=?",array($data['nr01']) )>0 &&   pegasus_mysql_printfld('i00', 'pno', "nr01=?",array($data['nr01'])) <> $data['pno'] )
		{ array_push( $permDeny , array( 'type'=>'deny' , 'message'=>$_SESSION['peg_dic_inventory_i00_008'])); 
		}
		
		// i00.fpa (VAT code)
		if( pegasus_mysql_printfld('i13', 'nr01', "p01=?",array($data['fpa'] ) )==0)
		{ array_push( $permDeny , array( 'type'=>'deny' , 'message'=>$_SESSION['peg_dic_inventory_i00_003'])); 
		}
		
		// i00.ths (unit)
		if( pegasus_mysql_printfld('i24', 'nr01', "p01=?" ,array($data['ths']))==0)
		{ array_push( $permDeny , array( 'type'=>'deny' , 'message'=>$_SESSION['peg_dic_inventory_i00_004'])); 
		}
		
		//i00.p01 (barcode)
		if( !empty($data['p01']) and !empty(pegasus_mysql_printfld('i00', 'nr01', "nr01<>? and p01=?",array($data['nr01'],$data['p01']))))
		{ 	
			array_push( $permDeny , array( 'type'=>'deny' , 'message'=>$_SESSION['peg_dic_inventory_i00_005'])); 
		}
		
		//i00.p01 (barcode) to color size
		if(!empty($data['p01']) and pegasus_module_exists('colorsize')  and !empty(pegasus_mysql_printfld('i47', 'nr01', "p04=?",array($data['p01']))))
		{ array_push( $permDeny , array( 'type'=>'deny' , 'message'=>$_SESSION['peg_dic_inventory_i00_007'])); 
		}
		
		// i00.p9001 (pairing code)
		if(!empty($data['p9001']) and  $_SESSION['inventory_000_p06'] == '1'  and !empty(pegasus_mysql_printfld('i00', 'nr01', "nr01<>? and p9001=?", array($data['nr01'], $data['p9001'])))) {
			array_push( $permDeny , array( 'type'=>'deny' , 'message'=>$_SESSION['peg_dic_inventory_i00_006'])); 
		}
		
		$ret_arr = peg_inventory_i00_d_check_obligatory_fields($data , $permDeny ,$mmnr01, $checkOnlyPerm);
		$data = $ret_arr['data'];
		$permDeny  = $ret_arr['permDeny'];
		
		if(pegasus_mysql_table_exists('peg_tmp_i47') and pegasus_module_exists('colorsize')){
			//array_push( $permDeny , array( 'type'=>'deny' , 'message'=> "peg_mmnr01='" .$mmnr01 ."' and peg_sess_id='" .session_id()."' and peg_flag!=9 "));
			// kanw elegxw toy tmp mono giati an to exei anoixi mono tote tha ftiaxei to tmp kai mono totet tha yparxei to i47_d01 gia na doylecei to save
			//die( "peg_mmnr01='" .$mmnr01 ."' and peg_sess_id='" .session_id()."' and peg_flag!=9 ");
			if(pegasus_mysql_printfld('peg_tmp_i47' , 'count(*)' ,  "peg_mmnr01=? and peg_sess_id=? and peg_flag!=9 ",array($mmnr01,session_id()))>0){
				if(empty($data['p9904'])){
					$data['p9904']=1;		
				}
				
				if(empty($data['p9905'])){
					$data['p9905']=1;		
				}
			}
		}	

		if(pegasus_module_exists('lotf')){
			global $PegInput;
			
			$PegInput->addVar(new peg_input_number('nr01'));
			$PegInput->addVar(new peg_input_number('lotf01_en'));
			$PegInput->addVar(new peg_input_alphanumeric('lotf01_p01'));
			$PegInput->addVar(new peg_input_alphanumeric('lotf01_p02'));
			$req_nr01 = $PegInput->getRequest('nr01');
			$req_en   = $PegInput->getRequest('lotf01_en');
			$req_p01  = $PegInput->getRequest('lotf01_p01');
			$req_p02  = $PegInput->getRequest('lotf01_p02');

			if(isset($req_en) && isset($req_p01) && isset($req_p02)){
				$lotf01_arr1 = array();			   $lotf01_arr2 = array();
				array_push($lotf01_arr1 , 'i00');  array_push($lotf01_arr2 , $req_nr01);
				array_push($lotf01_arr1 , 'en');   array_push($lotf01_arr2 , $req_en);
				array_push($lotf01_arr1 , 'p01');  array_push($lotf01_arr2 , $req_p01);
				array_push($lotf01_arr1 , 'p02');  array_push($lotf01_arr2 , $req_p02);
			
				if(pegasus_mysql_printfld('lotf01' , 'count(*)' , 'i00=:i00', array('i00' => $data['nr01'])  ) > 0){
					pegasus_mysql_update('lotf01' , $lotf01_arr1 , $lotf01_arr2 , 'i00=:i00', 0, 1, 1, array('i00' => $data['nr01']) );
				}else{
					array_push($lotf01_arr1 , 'nr01'); array_push($lotf01_arr2 , pegasus_mysql_newrec('lotf01'));
					pegasus_mysql_insert('lotf01' , $lotf01_arr1 , $lotf01_arr2);
				}
			}
			
		}		
		
		if(pegasus_module_exists('geopon')){
			global $PegInput;

			$PegInput->addVar(new peg_input_alphanumeric('gepa01_p02_p101'));
			$PegInput->addVar(new peg_input_alphanumeric('gepa01_p03_p101'));
			$PegInput->addVar(new peg_input_number('gepa01_p04'));
			$PegInput->addVar(new peg_input_alphanumeric('gepa01_p05_p101'));

			$gepa01_p02_p101 = $PegInput->getRequest('gepa01_p02_p101');
			$gepa01_p03_p101 = $PegInput->getRequest('gepa01_p03_p101');
			$gepa01_p04      = $PegInput->getRequest('gepa01_p04');
			$gepa01_p05_p101 = $PegInput->getRequest('gepa01_p05_p101');

			$_geopon_03_arr1 = array();			       $_geopon_03_arr2 = array();
			array_push($_geopon_03_arr1, 'p01');  	   array_push($_geopon_03_arr2, $data['pno']);
			array_push($_geopon_03_arr1, 'p02_p101');  array_push($_geopon_03_arr2, $gepa01_p02_p101);
			array_push($_geopon_03_arr1, 'p03_p101');  array_push($_geopon_03_arr2, $gepa01_p03_p101);
			array_push($_geopon_03_arr1, 'p04');       array_push($_geopon_03_arr2, $gepa01_p04);
			array_push($_geopon_03_arr1, 'p05_p101');  array_push($_geopon_03_arr2, $gepa01_p05_p101);
		
			if((!empty($gepa01_p02_p101) && (!empty($gepa01_p03_p101) || $gepa01_p03_p101 === '0') && !empty($gepa01_p04))) {
				if(pegasus_mysql_printfld('gepa01' , 'count(*)' , 'p01=:p01', array('p01' => $data['pno'])) > 0){
					pegasus_mysql_update('gepa01', $_geopon_03_arr1, $_geopon_03_arr2 , 'p01=:p01', 0, 1, 1, array('p01' => $data['pno']));
				} else {
					array_push($_geopon_03_arr1, 'nr01'); array_push($_geopon_03_arr2, pegasus_mysql_newrec('gepa01'));
					pegasus_mysql_insert('gepa01', $_geopon_03_arr1, $_geopon_03_arr2);
				}
			} else if(
				(
					empty($gepa01_p02_p101) && (	
											((!empty($gepa01_p03_p101) || $gepa01_p03_p101 === '0') && !empty($gepa01_p04)) || 
											(empty($gepa01_p03_p101)  && !empty($gepa01_p04)) || 
											((!empty($gepa01_p03_p101) || $gepa01_p03_p101 === '0') && empty($gepa01_p04))	
										  ) 
				) ||
				(
					empty($gepa01_p03_p101) && (	
											(!empty($gepa01_p02_p101) && !empty($gepa01_p04)) || 
											(empty($gepa01_p02_p101)  && !empty($gepa01_p04)) || 
											(!empty($gepa01_p02_p101) && empty($gepa01_p04))	
										  ) 
				) ||
				(
					empty($gepa01_p04) && (	
											(!empty($gepa01_p02_p101) && (!empty($gepa01_p03_p101) || $gepa01_p03_p101 === '0')) || 
											(empty($gepa01_p02_p101)  && (!empty($gepa01_p03_p101) || $gepa01_p03_p101 === '0')) || 
											(!empty($gepa01_p02_p101) && empty($gepa01_p03_p101))	
										  ) 
				)
			) {
				array_push( $permDeny , array( 'type'=>'deny' , 'message'=>$_SESSION['peg_dic_geopon_filled_formula_elements'])); 
			} 
		}
		
		//Παραμετροποίηση myDATA/B2G
		if ($checkOnlyPerm == 1 && $grid_editing != 1){
			$PegInput->addVar(new peg_input_alphanumeric('v_q30_620067', 'request'));
			$PegInput->addVar(new peg_input_alphanumeric('v_q30_620070', 'request'));
			$v_q30_620067 = $PegInput->getRequest('v_q30_620067');
			$v_q30_620070 = $PegInput->getRequest('v_q30_620070');
	
			core00_manage_relation($v_q30_620067, '620067', $data['pno']);
			core00_manage_relation($v_q30_620070, '620070', $data['pno']);
		}

		if($checkOnlyPerm == 0){
		    if(isset($data['px01']) && function_exists('peg_kernel_youtube_http_to_https')){
		        $data['px01'] = peg_kernel_youtube_http_to_https($data['px01']);
		    }
		    if(isset($data['px02']) && function_exists('peg_kernel_youtube_http_to_https')){
		        $data['px02'] = peg_kernel_youtube_http_to_https($data['px02']);			
		    }

		}
		
		return array('data' => $data , 'permDeny' => $permDeny );
	}

	function peg_inventory_i00_d_check_obligatory_fields($data , $permDeny , $mmnr01 , $checkOnlyPerm){

		if( $_SESSION['inventory_000_p901'] == 1 && empty($data['p01'])){//Barcode
			array_push( $permDeny , array( 'type'=>'deny' , 'message'=>$_SESSION['peg_dic_inventory_i00_009'])); 
		}

		if( $_SESSION['inventory_000_p902'] == 1 && empty($data['p9001'])){//Antistoixia
			array_push( $permDeny , array( 'type'=>'deny' , 'message'=>$_SESSION['peg_dic_inventory_i00_010'])); 
		}

		if( $_SESSION['inventory_000_p903'] == 1 && empty($data['p602'])){//Promitheutis
			array_push( $permDeny , array( 'type'=>'deny' , 'message'=>$_SESSION['peg_dic_inventory_i00_011'])); 
		}

		if( $_SESSION['inventory_000_p904'] == 1 && empty($data['p9901'])){//Omada
			array_push( $permDeny , array( 'type'=>'deny' , 'message'=>$_SESSION['peg_dic_inventory_i00_012'])); 
		}

		if( $_SESSION['inventory_000_p905'] == 1 && empty($data['p9902'])){//Ypoomada
			array_push( $permDeny , array( 'type'=>'deny' , 'message'=>$_SESSION['peg_dic_inventory_i00_013'])); 
		}

		if( $_SESSION['inventory_000_p911'] == 1 && empty($data['p910'])){//Oikogeneia
			array_push( $permDeny , array( 'type'=>'deny' , 'message'=>$_SESSION['peg_dic_inventory_i00_014'])); 
		}

		if( $_SESSION['inventory_000_p912'] == 1 && empty($data['p911'])){//Ypooikogeneia
			array_push( $permDeny , array( 'type'=>'deny' , 'message'=>$_SESSION['peg_dic_inventory_i00_015'])); 
		}

		if( $_SESSION['inventory_000_p913'] == 1 && empty($data['p912'])){//Proeleysi
			array_push( $permDeny , array( 'type'=>'deny' , 'message'=>$_SESSION['peg_dic_inventory_i00_016'])); 
		}

		if( $_SESSION['inventory_000_p906'] == 1 && empty($data['p99'])){//Klasi
			array_push( $permDeny , array( 'type'=>'deny' , 'message'=>$_SESSION['peg_dic_inventory_i00_017'])); 
		}

		if( $_SESSION['inventory_000_p907'] == 1 && empty($data['p9903'])){//Katigoria
			array_push( $permDeny , array( 'type'=>'deny' , 'message'=>$_SESSION['peg_dic_inventory_i00_018'])); 
		}

		if( $_SESSION['inventory_000_p909'] == 1 && empty($data['p9907'])){//Kataskeuastis
			array_push( $permDeny , array( 'type'=>'deny' , 'message'=>$_SESSION['peg_dic_inventory_i00_019'])); 
		}

		if( $_SESSION['inventory_000_p910'] == 1 && empty($data['p9908'])){//Syskeuasia
			array_push( $permDeny , array( 'type'=>'deny' , 'message'=>$_SESSION['peg_dic_inventory_i00_020'])); 
		}

		if( $_SESSION['inventory_000_p908'] == 1 && !(pegasus_mysql_printfld('i10', 'nr01', 'p01=?', array($data['p62']))>0) ) {//Typos
			array_push( $permDeny , array( 'type'=>'deny' , 'message'=>$_SESSION['peg_dic_inventory_i00_021'])); 
		}

		return array('data' => $data , 'permDeny' => $permDeny );
	}

	
	function peg_inventory_f01_d_change($data , $permDeny , $mmnr01 , $checkOnlyPerm){

		if(empty($data['w_p01'])){
			$data['w_p01'] = 'XXXXXXXXXX';
		}
		if( $checkOnlyPerm!=1 && 
		  	(	$data['p07']!=$_SESSION['f01_p07']	|| 
			  	$data['p08']!=$_SESSION['f01_p08'] 	||
				$data['p012']!=$_SESSION['f01_p012'])){

			peg002_clean_dCache('i01_d10');
			peg002_clean_dCache('i01_d101');
			peg002_clean_dCache('i01_d310');
			if(pegasus_module_exists(('estiasi'))){
				peg002_clean_dCache('estiasi_01_d02');

			}
		}
		return array('data' => $data , 'permDeny' => $permDeny );
	}

	function inventory_after_update(){

		if(!pegasus_mysql_table_exists('peg_tmp_inventory_004')){
			pegasus_create_tmp_table('inventory_004');
		}

		// sets i00_d20 fs01 title
		if(function_exists('peg_inventory_set_lot_or_serial_name')){
    		peg_inventory_set_lot_or_serial_name();
		}

		peg_inventory_user_defined_fields();
		if(function_exists('peg_inventory_set_pricelists_names_in_i00_d7')){
			peg_inventory_set_pricelists_names_in_i00_d7();
		}		

		inventory_after_update_i10();

		pegasus_mysql_use('select rel, ver from p55 where p00="inventory"', $version);
		if($version['ver'] == 2 && $version['rel'] <= 212) {
			if(pegasus_mysql_printfld('i10' , 'count(*)' , 'nr01<10000000001')>0){
				pegasus_mysql_update('i10' , array('p300') , array('1') , 'nr01<10000000001');
				pegasus_mysql_update('i10' , array('p300') , array('0') , 'nr01>=10000000001');
			}else{
				if(!pegasus_module_exists('estiasi')){
					pegasus_mysql_update('i10' , array('p300') , array('0') , 'p01 in ("1000000200","1000000201")');
				}
				if(!pegasus_module_exists('hot000')){
					pegasus_mysql_update('i10' , array('p300') , array('0') , 'p01 in ("1000000500")');					
				}else{
					// Eνημερωση Τυπο ειδος για τα είδη Διασμονης
					pegasus_query("update hota01 join i00 on i00.pno=hota01.p04 and i00.p62='' set i00.p62='1000000005', i00.remdate=curdate(), i00.remtime=curtime();") ;

					// Eνημερωση Τυπο ειδος για τα είδος Φόρος Διασμονης
					pegasus_query("update hota01 join i00 on i00.pno=hota01.p09 and i00.p62='' set i00.p62='1000000500', i00.remdate=curdate(), i00.remtime=curtime();") ;

					// Eνημερωση Τυπο ειδος για τα είδη των Υπηρεσιών 
					pegasus_query("update hota03 join i00 on (i00.pno=hota03.p04 or i00.pno=hota03.p04_2) and i00.p62='' set i00.p62='1000000005', i00.remdate=curdate(), i00.remtime=curtime();") ;

					// Eνημερωση Τυπο ειδος για προσαυξήσεις // ακυρωσεις
					pegasus_query("update hota98 join i00 on (i00.pno=hota98.p10 or i00.pno=hota98.p11 or i00.pno=hota98.p11 or i00.pno=hota98.p99) and i00.p62='' set i00.p62='1000000005', i00.remdate=curdate(), i00.remtime=curtime();") ;
				}

				if(!pegasus_module_exists('elaio')){
					pegasus_mysql_update('i10' , array('p300') , array('0') , 'p01 in ("1000000700")');					
				}
			}


		}

		if($version['ver'] == 2 && $version['rel'] <= 248) {
			pegasus_mysql_update('i10' , array('p101') , array('0') , 'p01 in ("1000000200","1000000201") and p101=2');
		}
        //Αρχικοπόιηση i12 μόνο αν δεν εχει εγγραφές.
		if (!(pegasus_mysql_printfld("i12", "nr01", "nr01>0") > 0)) {
			inventory_after_update_i12();
		}

		if($version['ver'] == 2 && $version['rel'] <=269 ) {
			$query="SELECT  p52.* ,p52_orderby.nr01 as p52_orderby_nr01
					FROM p52
					LEFT JOIN p52 as p52_orderby on p52_orderby.p02=p52.p02 and  p52_orderby.desc05=p52.desc05  and  p52_orderby.module=p52.module and p52_orderby.par_nm='orderby' 
					JOIN p55 on p55.p00 = p52.module && p55.en = 1/*Να υπάρχει το module γιατι παίζει κάποιος να έχει άκυρα p52 από αντιγραφη*/
					where p52.desc07 in ('comboboxV2','multi_selectbox','selectbox' )  and p52.par_nm='table' && p52.p02 not like 'q10_d90_%' 
					&& p52.par_val='i16'
					having p52_orderby_nr01 is  null ";
			$res=pegasus_query($query);
			while ($row=pegasus_fetch($res)) {
				$arr1=array();				$arr2=array();
				array_push($arr1,'p02'); 	array_push($arr2,$row['p02']);
				array_push($arr1,'desc05'); array_push($arr2,$row['desc05']);
				array_push($arr1,'module'); array_push($arr2,$row['module']);
				array_push($arr1,'nr01'); 	array_push($arr2,pegasus_mysql_module_newrec('p52', $row['module'])); 
				array_push($arr1,'par_nm'); array_push($arr2,'orderby');
				array_push($arr1,'par_val');array_push($arr2,'i16.ptax');
				array_push($arr1,'desc07'); array_push($arr2,$row['desc07']);
				array_push($arr1,'remguc'); array_push($arr2,"**auto-insert**");
				pegasus_mysql_insert('p52',$arr1,$arr2);
			}
	
			$query="SELECT p52.* ,p52_where.nr01 as p52_where_nr01
					FROM p52
					LEFT JOIN p52 as p52_where on p52_where.p02=p52.p02 and  p52_where.desc05=p52.desc05  and  p52_where.module=p52.module and p52_where.par_nm='where' 
					JOIN p55 on p55.p00 = p52.module && p55.en = 1/*Να υπάρχει το module γιατι παίζει κάποιος να έχει άκυρα p52 από αντιγραφη*/
					where p52.desc07 in ('comboboxV2','multi_selectbox','selectbox' )  and p52.par_nm='table' && p52.p02 not like 'q10_d90_%' 
					&& p52.par_val='i16'
					having   p52_where_nr01 is  null ";
			$res=pegasus_query($query);
			while ($row=pegasus_fetch($res)) {
				$arr1=array();				$arr2=array();
				array_push($arr1,'p02'); 	array_push($arr2,$row['p02']);
				array_push($arr1,'desc05'); array_push($arr2,$row['desc05']);
				array_push($arr1,'module'); array_push($arr2,$row['module']);
				array_push($arr1,'nr01'); 	array_push($arr2,pegasus_mysql_module_newrec('p52', $row['module'])); 
				array_push($arr1,'par_nm'); array_push($arr2,'where');
				array_push($arr1,'par_val');array_push($arr2,"
				if(function_exists('peg_inventory_get_storage_where_array')){
					return peg_inventory_get_storage_where_array(\$data['".$row['desc05']."'],1); 
				}");
				array_push($arr1,'desc07'); array_push($arr2,$row['desc07']);
				array_push($arr1,'code'); array_push($arr2,1);
				array_push($arr1,'remguc'); array_push($arr2,"**auto-insert**");
				pegasus_mysql_insert('p52',$arr1,$arr2);
	
			}
	
		}
		if($version['ver'] == 2 && $version['rel'] <= 274) {
			peg002_clean_dCache('i01_d101');		
		}

		if($version['ver'] == 2 && $version['rel'] <= 340) {
			pegasus_mysql_update('i00', array('ptax'), array(9999), 'i00.ptax = 0', 1);
		}
		
		if($version['ver'] == 2 && $version['rel'] <= 384) {
			$arr1 = array();				$arr2 = array();
			array_push($arr1, 't07p01'); 	array_push($arr2, -1);
			
			pegasus_mysql_update('i16', $arr1, $arr2, 't07p01 = "" OR t07p01 IS NULL', 1);
		}

		if($version['ver'] == 2 && $version['rel'] <= 423) {
			pegasus_mysql_use("SELECT count(*) as cnt FROM i24 WHERE p01 = 'ΚΙΛ'", $check, array());
			/**Αν δεν έχουμε ΜΜ τα Κιλά τα δημιουργώ */
			if ($check['cnt'] == 0) {
				$arr1 = array();						$arr2 = array();
				array_push($arr1, 'nr01'); 				array_push($arr2, pegasus_mysql_newrec('i24'));
				array_push($arr1, 'p01'); 				array_push($arr2, 'ΚΙΛ');
				array_push($arr1, 'p02'); 				array_push($arr2, 'ΚΙΛΑ');
				array_push($arr1, 'ep02'); 				array_push($arr2, 'KILOGRAMS');
				array_push($arr1, 'dek'); 				array_push($arr2, 4);

				core00_manage_relation('2', '620060', 'ΚΙΛ');

				pegasus_mysql_insert('i24', $arr1, $arr2);
			}
		}

		if($version['ver'] == 2 && $version['rel'] <= 427) {
			// Προσθήκη δικαιώματος στις ομάδες χρηστών πέραν του administrator
			$query_p97 = "SELECT * FROM p97 WHERE nr01 != 140000000000000";

			$res = pegasus_query($query_p97);

			while($row = pegasus_fetch_assoc($res)) {
				$p97p96_nr01 = pegasus_mysql_printfld("p97p96", "nr01", "p97=:p97_nr01 and p96='inventory_change_pno'", array('p97_nr01' => $row['nr01']));

				if(!($p97p96_nr01 > 0)) {
					$p97p96_array = array();

					$p97p96_array['nr01'] = pegasus_mysql_newrec("p97p96");
					$p97p96_array['p96']  = "inventory_change_pno";
					$p97p96_array['p97']  = $row['nr01'];
					$p97p96_array['en']   = 1;

					pegasus_mysql_insert('p97p96', array_keys($p97p96_array), array_values($p97p96_array));
				}
			}
		}
	}
	


	function inventory_after_update_i10(){
		/**
		 *select 
				concat(
				'$i10_arr=array(); \n',
				'$i10_arr[\'nr01\']="',i10.nr01,'"; \n',
				'$i10_arr[\'p01\']="',i10.p01,'"; \n',
				'$i10_arr[\'p02\']="',i10.p02,'"; \n',
				'$i10_arr[\'is_std\']="',is_std,'"; \n',
				'if(pegasus_mysql_printfld(\'i10\' , \'nr01\' , \'nr01=:nr01\' , array(\'nr01\' => $i10_arr[\'nr01\']))>0){\n',
				'	pegasus_mysql_update(\'i10\' ,array_keys($i10_arr),array_values($i10_arr), \'nr01=:nr01\',0,1,1, array(\'nr01\' => $i10_arr[\'nr01\']));\n',
				'}else{\n',
				'	$i10_arr[\'p300\']= (pegasus_mysql_printfld(\'i10\' , \'count(*)\' , \'is_std=0\')>0)? 0 : 1  ;  \n',
				'	$i10_arr[\'p01\']="',i10.p01,'"; \n',
				'	$i10_arr[\'p04\']="',i10.p04,'"; \n',
				'	$i10_arr[\'p05\']="',i10.p05,'"; \n',
				'	$i10_arr[\'p101\']="',i10.p101,'"; \n',
				'	$i10_arr[\'p102\']="',i10.p102,'"; \n',
				'	$i10_arr[\'p103\']="',i10.p103,'"; \n',
				'	$i10_arr[\'p105\']="',i10.p105,'"; \n',
				'	$i10_arr[\'p106\']="',i10.p106,'"; \n',

				'	pegasus_mysql_insert(\'i10\' ,array_keys($i10_arr),array_values($i10_arr));\n',
				'}\n'
				),

				i10.* from i10 where is_std=1;
		 */
		$i10_arr=array(); 
		$i10_arr['nr01']="10000000001"; 
		$i10_arr['p01']="1000000001"; 
		$i10_arr['p02']="Εμπορεύματα"; 
		$i10_arr['is_std']="1"; 
		if(pegasus_mysql_printfld('i10' , 'nr01' , 'nr01=:nr01' , array('nr01' => $i10_arr['nr01']))>0){
			pegasus_mysql_update('i10' ,array_keys($i10_arr),array_values($i10_arr), 'nr01=:nr01',0,1,1, array('nr01' => $i10_arr['nr01']));
		}else{
			$i10_arr['p300']= (pegasus_mysql_printfld('i10' , 'count(*)' , 'is_std=0')>0)? 0 : 1  ;  
			$i10_arr['p01']="1000000001"; 
			$i10_arr['p04']="20.  .  ."; 
			$i10_arr['p05']="70-20-00"; 
			$i10_arr['p101']="0.00"; 
			$i10_arr['p102']="0.00"; 
			$i10_arr['p103']="0.00"; 
			$i10_arr['p105']="0"; 
			$i10_arr['p106']="0"; 
			pegasus_mysql_insert('i10' ,array_keys($i10_arr),array_values($i10_arr));
		}
		
		$i10_arr=array(); 
		$i10_arr['nr01']="10000000002"; 
		$i10_arr['p01']="1000000002"; 
		$i10_arr['p02']="Προϊόντα"; 
		$i10_arr['is_std']="1"; 
		if(pegasus_mysql_printfld('i10' , 'nr01' , 'nr01=:nr01' , array('nr01' => $i10_arr['nr01']))>0){
			pegasus_mysql_update('i10' ,array_keys($i10_arr),array_values($i10_arr), 'nr01=:nr01',0,1,1, array('nr01' => $i10_arr['nr01']));
		}else{
			$i10_arr['p300']= (pegasus_mysql_printfld('i10' , 'count(*)' , 'is_std=0')>0)? 0 : 1  ;  
			$i10_arr['p01']="1000000002"; 
			$i10_arr['p04']="24.  .  ."; 
			$i10_arr['p05']="71-24-00"; 
			$i10_arr['p101']="0.00"; 
			$i10_arr['p102']="0.00"; 
			$i10_arr['p103']="0.00"; 
			$i10_arr['p105']="0"; 
			$i10_arr['p106']="0"; 
			pegasus_mysql_insert('i10' ,array_keys($i10_arr),array_values($i10_arr));
		}
		
		$i10_arr=array(); 
		$i10_arr['nr01']="10000000003"; 
		$i10_arr['p01']="1000000003"; 
		$i10_arr['p02']="Α'Υλες"; 
		$i10_arr['is_std']="1"; 
		if(pegasus_mysql_printfld('i10' , 'nr01' , 'nr01=:nr01' , array('nr01' => $i10_arr['nr01']))>0){
			pegasus_mysql_update('i10' ,array_keys($i10_arr),array_values($i10_arr), 'nr01=:nr01',0,1,1, array('nr01' => $i10_arr['nr01']));
		}else{
			$i10_arr['p300']= (pegasus_mysql_printfld('i10' , 'count(*)' , 'is_std=0')>0)? 0 : 1  ;  
			$i10_arr['p01']="1000000003"; 
			$i10_arr['p04']=""; 
			$i10_arr['p05']="70-20-00"; 
			$i10_arr['p101']="0.00"; 
			$i10_arr['p102']="0.00"; 
			$i10_arr['p103']="0.00"; 
			$i10_arr['p105']="0"; 
			$i10_arr['p106']="0"; 
			pegasus_mysql_insert('i10' ,array_keys($i10_arr),array_values($i10_arr));
		}
		
		$i10_arr=array(); 
		$i10_arr['nr01']="10000000004"; 
		$i10_arr['p01']="1000000004"; 
		$i10_arr['p02']="Αναλώσιμα"; 
		$i10_arr['is_std']="1"; 
		if(pegasus_mysql_printfld('i10' , 'nr01' , 'nr01=:nr01' , array('nr01' => $i10_arr['nr01']))>0){
			pegasus_mysql_update('i10' ,array_keys($i10_arr),array_values($i10_arr), 'nr01=:nr01',0,1,1, array('nr01' => $i10_arr['nr01']));
		}else{
			$i10_arr['p300']= (pegasus_mysql_printfld('i10' , 'count(*)' , 'is_std=0')>0)? 0 : 1  ;  
			$i10_arr['p01']="1000000004"; 
			$i10_arr['p04']="25.  .  ."; 
			$i10_arr['p05']="70-25-00"; 
			$i10_arr['p101']="0.00"; 
			$i10_arr['p102']="0.00"; 
			$i10_arr['p103']="0.00"; 
			$i10_arr['p105']="0"; 
			$i10_arr['p106']="0"; 
			pegasus_mysql_insert('i10' ,array_keys($i10_arr),array_values($i10_arr));
		}
		
		$i10_arr=array(); 
		$i10_arr['nr01']="10000000005"; 
		$i10_arr['p01']="1000000005"; 
		$i10_arr['p02']="Παροχές Υπηρεσιών"; 
		$i10_arr['is_std']="1"; 
		if(pegasus_mysql_printfld('i10' , 'nr01' , 'nr01=:nr01' , array('nr01' => $i10_arr['nr01']))>0){
			pegasus_mysql_update('i10' ,array_keys($i10_arr),array_values($i10_arr), 'nr01=:nr01',0,1,1, array('nr01' => $i10_arr['nr01']));
		}else{
			$i10_arr['p300']= (pegasus_mysql_printfld('i10' , 'count(*)' , 'is_std=0')>0)? 0 : 1  ;  
			$i10_arr['p01']="1000000005"; 
			$i10_arr['p04']=""; 
			$i10_arr['p05']="73-60-00"; 
			$i10_arr['p101']="0.00"; 
			$i10_arr['p102']="0.00"; 
			$i10_arr['p103']="0.00"; 
			$i10_arr['p105']="0"; 
			$i10_arr['p106']="0"; 
			pegasus_mysql_insert('i10' ,array_keys($i10_arr),array_values($i10_arr));
		}
		
		$i10_arr=array(); 
		$i10_arr['nr01']="10000000006"; 
		$i10_arr['p01']="1000000050"; 
		$i10_arr['p02']="Περιβαλλοντικό Τέλος"; 
		$i10_arr['is_std']="1"; 
		if(pegasus_mysql_printfld('i10' , 'nr01' , 'nr01=:nr01' , array('nr01' => $i10_arr['nr01']))>0){
			pegasus_mysql_update('i10' ,array_keys($i10_arr),array_values($i10_arr), 'nr01=:nr01',0,1,1, array('nr01' => $i10_arr['nr01']));
		}else{
			$i10_arr['p300']= (pegasus_mysql_printfld('i10' , 'count(*)' , 'is_std=0')>0)? 0 : 1  ;  
			$i10_arr['p01']="1000000050"; 
			$i10_arr['p04']=""; 
			$i10_arr['p05']="70-20-00"; 
			$i10_arr['p101']="0.00"; 
			$i10_arr['p102']="0.00"; 
			$i10_arr['p103']="0.00"; 
			$i10_arr['p105']="1"; 
			$i10_arr['p106']="0"; 
			pegasus_mysql_insert('i10' ,array_keys($i10_arr),array_values($i10_arr));
		}
		
		$i10_arr=array(); 
		$i10_arr['nr01']="10000000007"; 
		$i10_arr['p01']="1000000051"; 
		$i10_arr['p02']="Εγγυοδοσίες"; 
		$i10_arr['is_std']="1"; 
		if(pegasus_mysql_printfld('i10' , 'nr01' , 'nr01=:nr01' , array('nr01' => $i10_arr['nr01']))>0){
			pegasus_mysql_update('i10' ,array_keys($i10_arr),array_values($i10_arr), 'nr01=:nr01',0,1,1, array('nr01' => $i10_arr['nr01']));
		}else{
			$i10_arr['p300']= (pegasus_mysql_printfld('i10' , 'count(*)' , 'is_std=0')>0)? 0 : 1  ;  
			$i10_arr['p01']="1000000051"; 
			$i10_arr['p04']=""; 
			$i10_arr['p05']="70-20-00"; 
			$i10_arr['p101']="0.00"; 
			$i10_arr['p102']="0.00"; 
			$i10_arr['p103']="0.00"; 
			$i10_arr['p105']="1"; 
			$i10_arr['p106']="0"; 
			pegasus_mysql_insert('i10' ,array_keys($i10_arr),array_values($i10_arr));
		}
		
		$i10_arr=array(); 
		$i10_arr['nr01']="10000000008"; 
		$i10_arr['p01']="1000000099"; 
		$i10_arr['p02']="Οχι ΜΚΦΣ και MyDATA"; 
		$i10_arr['is_std']="1"; 
		if(pegasus_mysql_printfld('i10' , 'nr01' , 'nr01=:nr01' , array('nr01' => $i10_arr['nr01']))>0){
			pegasus_mysql_update('i10' ,array_keys($i10_arr),array_values($i10_arr), 'nr01=:nr01',0,1,1, array('nr01' => $i10_arr['nr01']));
		}else{
			$i10_arr['p300']= (pegasus_mysql_printfld('i10' , 'count(*)' , 'is_std=0')>0)? 0 : 1  ;  
			$i10_arr['p01']="1000000099"; 
			$i10_arr['p04']=""; 
			$i10_arr['p05']="70-20-00"; 
			$i10_arr['p101']="0.00"; 
			$i10_arr['p102']="0.00"; 
			$i10_arr['p103']="0.00"; 
			$i10_arr['p105']="1"; 
			$i10_arr['p106']="1"; 
			pegasus_mysql_insert('i10' ,array_keys($i10_arr),array_values($i10_arr));
		}
		
		$i10_arr=array(); 
		$i10_arr['nr01']="10000000009"; 
		$i10_arr['p01']="1000000100"; 
		$i10_arr['p02']="Καύσιμα"; 
		$i10_arr['is_std']="1"; 
		if(pegasus_mysql_printfld('i10' , 'nr01' , 'nr01=:nr01' , array('nr01' => $i10_arr['nr01']))>0){
			pegasus_mysql_update('i10' ,array_keys($i10_arr),array_values($i10_arr), 'nr01=:nr01',0,1,1, array('nr01' => $i10_arr['nr01']));
		}else{
			$i10_arr['p300']= (pegasus_mysql_printfld('i10' , 'count(*)' , 'is_std=0')>0)? 0 : 1  ;  
			$i10_arr['p01']="1000000100"; 
			$i10_arr['p04']=""; 
			$i10_arr['p05']="70-20-00"; 
			$i10_arr['p101']="0.00"; 
			$i10_arr['p102']="0.00"; 
			$i10_arr['p103']="0.00"; 
			$i10_arr['p105']="0"; 
			$i10_arr['p106']="0"; 
			pegasus_mysql_insert('i10' ,array_keys($i10_arr),array_values($i10_arr));
		}
		
		$i10_arr=array(); 
		$i10_arr['nr01']="10000000010"; 
		$i10_arr['p01']="1000000101"; 
		$i10_arr['p02']="Πετρέλαιο Θέρμανσης"; 
		$i10_arr['is_std']="1"; 
		if(pegasus_mysql_printfld('i10' , 'nr01' , 'nr01=:nr01' , array('nr01' => $i10_arr['nr01']))>0){
			pegasus_mysql_update('i10' ,array_keys($i10_arr),array_values($i10_arr), 'nr01=:nr01',0,1,1, array('nr01' => $i10_arr['nr01']));
		}else{
			$i10_arr['p300']= (pegasus_mysql_printfld('i10' , 'count(*)' , 'is_std=0')>0)? 0 : 1  ;  
			$i10_arr['p01']="1000000101"; 
			$i10_arr['p04']=""; 
			$i10_arr['p05']="70-20-00"; 
			$i10_arr['p101']="0.00"; 
			$i10_arr['p102']="0.00"; 
			$i10_arr['p103']="0.00"; 
			$i10_arr['p105']="0"; 
			$i10_arr['p106']="0"; 
			pegasus_mysql_insert('i10' ,array_keys($i10_arr),array_values($i10_arr));
		}
		
		$i10_arr=array(); 
		$i10_arr['nr01']="10000000011"; 
		$i10_arr['p01']="1000000102"; 
		$i10_arr['p02']="Πετρέλαιο Κίνησης"; 
		$i10_arr['is_std']="1"; 
		if(pegasus_mysql_printfld('i10' , 'nr01' , 'nr01=:nr01' , array('nr01' => $i10_arr['nr01']))>0){
			pegasus_mysql_update('i10' ,array_keys($i10_arr),array_values($i10_arr), 'nr01=:nr01',0,1,1, array('nr01' => $i10_arr['nr01']));
		}else{
			$i10_arr['p300']= (pegasus_mysql_printfld('i10' , 'count(*)' , 'is_std=0')>0)? 0 : 1  ;  
			$i10_arr['p01']="1000000102"; 
			$i10_arr['p04']=""; 
			$i10_arr['p05']="70-20-00"; 
			$i10_arr['p101']="0.00"; 
			$i10_arr['p102']="0.00"; 
			$i10_arr['p103']="0.00"; 
			$i10_arr['p105']="0"; 
			$i10_arr['p106']="0"; 
			pegasus_mysql_insert('i10' ,array_keys($i10_arr),array_values($i10_arr));
		}
		
		$i10_arr=array(); 
		$i10_arr['nr01']="10000000012"; 
		$i10_arr['p01']="1000000200"; 
		$i10_arr['p02']="Τρόφιμα (Estiasi)"; 
		$i10_arr['is_std']="1"; 
		if(pegasus_mysql_printfld('i10' , 'nr01' , 'nr01=:nr01' , array('nr01' => $i10_arr['nr01']))>0){
			pegasus_mysql_update('i10' ,array_keys($i10_arr),array_values($i10_arr), 'nr01=:nr01',0,1,1, array('nr01' => $i10_arr['nr01']));
		}else{
			$i10_arr['p300']= (pegasus_mysql_printfld('i10' , 'count(*)' , 'is_std=0')>0)? 0 : 1  ;  
			$i10_arr['p01']="1000000200"; 
			$i10_arr['p04']="20.  .  ."; 
			$i10_arr['p05']="70-20-00"; 
			$i10_arr['p101']="0.00"; 
			$i10_arr['p102']="0.00"; 
			$i10_arr['p103']="0.00"; 
			$i10_arr['p105']="0"; 
			$i10_arr['p106']="0"; 
			pegasus_mysql_insert('i10' ,array_keys($i10_arr),array_values($i10_arr));
		}
		
		$i10_arr=array(); 
		$i10_arr['nr01']="10000000013"; 
		$i10_arr['p01']="1000000201"; 
		$i10_arr['p02']="Ποτά (Estiasi)"; 
		$i10_arr['is_std']="1"; 
		if(pegasus_mysql_printfld('i10' , 'nr01' , 'nr01=:nr01' , array('nr01' => $i10_arr['nr01']))>0){
			pegasus_mysql_update('i10' ,array_keys($i10_arr),array_values($i10_arr), 'nr01=:nr01',0,1,1, array('nr01' => $i10_arr['nr01']));
		}else{
			$i10_arr['p300']= (pegasus_mysql_printfld('i10' , 'count(*)' , 'is_std=0')>0)? 0 : 1  ;  
			$i10_arr['p01']="1000000201"; 
			$i10_arr['p04']="20.  .  ."; 
			$i10_arr['p05']="70-20-00"; 
			$i10_arr['p101']="0.00"; 
			$i10_arr['p102']="0.00"; 
			$i10_arr['p103']="0.00"; 
			$i10_arr['p105']="0"; 
			$i10_arr['p106']="0"; 
			pegasus_mysql_insert('i10' ,array_keys($i10_arr),array_values($i10_arr));
		}
		
		$i10_arr=array(); 
		$i10_arr['nr01']="10000000014"; 
		$i10_arr['p01']="1000000500"; 
		$i10_arr['p02']="Φορος Διαμόνης (Hotel)"; 
		$i10_arr['is_std']="1"; 
		if(pegasus_mysql_printfld('i10' , 'nr01' , 'nr01=:nr01' , array('nr01' => $i10_arr['nr01']))>0){
			pegasus_mysql_update('i10' ,array_keys($i10_arr),array_values($i10_arr), 'nr01=:nr01',0,1,1, array('nr01' => $i10_arr['nr01']));
		}else{
			$i10_arr['p300']= (pegasus_mysql_printfld('i10' , 'count(*)' , 'is_std=0')>0)? 0 : 1  ;  
			$i10_arr['p01']="1000000500"; 
			$i10_arr['p04']=""; 
			$i10_arr['p05']="70-20-00"; 
			$i10_arr['p101']="0.00"; 
			$i10_arr['p102']="0.00"; 
			$i10_arr['p103']="0.00"; 
			$i10_arr['p105']="0"; 
			$i10_arr['p106']="0"; 
			pegasus_mysql_insert('i10' ,array_keys($i10_arr),array_values($i10_arr));
		}
		
		$i10_arr=array(); 
		$i10_arr['nr01']="10000000015"; 
		$i10_arr['p01']="1000000700"; 
		$i10_arr['p02']="Δοχεία (Elaio)"; 
		$i10_arr['is_std']="1"; 
		if(pegasus_mysql_printfld('i10' , 'nr01' , 'nr01=:nr01' , array('nr01' => $i10_arr['nr01']))>0){
			pegasus_mysql_update('i10' ,array_keys($i10_arr),array_values($i10_arr), 'nr01=:nr01',0,1,1, array('nr01' => $i10_arr['nr01']));
		}else{
			$i10_arr['p300']= (pegasus_mysql_printfld('i10' , 'count(*)' , 'is_std=0')>0)? 0 : 1  ;  
			$i10_arr['p01']="1000000700"; 
			$i10_arr['p04']=""; 
			$i10_arr['p05']="70-20-00"; 
			$i10_arr['p101']="0.00"; 
			$i10_arr['p102']="0.00"; 
			$i10_arr['p103']="0.00"; 
			$i10_arr['p105']="0"; 
			$i10_arr['p106']="0"; 
			pegasus_mysql_insert('i10' ,array_keys($i10_arr),array_values($i10_arr));
		}
		
		$i10_arr=array(); 
		$i10_arr['nr01']="10000000016"; 
		$i10_arr['p01']="1000000150"; 
		$i10_arr['p02']="Δαπάνες (με ΦΠΑ)"; 
		$i10_arr['is_std']="1"; 
		if(pegasus_mysql_printfld('i10' , 'nr01' , 'nr01=:nr01' , array('nr01' => $i10_arr['nr01']))>0){
			pegasus_mysql_update('i10' ,array_keys($i10_arr),array_values($i10_arr), 'nr01=:nr01',0,1,1, array('nr01' => $i10_arr['nr01']));
		}else{
			$i10_arr['p300']= (pegasus_mysql_printfld('i10' , 'count(*)' , 'is_std=0')>0)? 0 : 1  ;  
			$i10_arr['p01']="1000000150"; 
			$i10_arr['p04']=""; 
			$i10_arr['p05']=""; 
			$i10_arr['p101']="0.00"; 
			$i10_arr['p102']="0.00"; 
			$i10_arr['p103']="0.00"; 
			$i10_arr['p105']="0"; 
			$i10_arr['p106']="0"; 
			pegasus_mysql_insert('i10' ,array_keys($i10_arr),array_values($i10_arr));
		}
		
		$i10_arr=array(); 
		$i10_arr['nr01']="10000000017"; 
		$i10_arr['p01']="1000000151"; 
		$i10_arr['p02']="Δαπάνες (Χωρίς ΦΠΑ)"; 
		$i10_arr['is_std']="1"; 
		if(pegasus_mysql_printfld('i10' , 'nr01' , 'nr01=:nr01' , array('nr01' => $i10_arr['nr01']))>0){
			pegasus_mysql_update('i10' ,array_keys($i10_arr),array_values($i10_arr), 'nr01=:nr01',0,1,1, array('nr01' => $i10_arr['nr01']));
		}else{
			$i10_arr['p300']= (pegasus_mysql_printfld('i10' , 'count(*)' , 'is_std=0')>0)? 0 : 1  ;  
			$i10_arr['p01']="1000000151"; 
			$i10_arr['p04']=""; 
			$i10_arr['p05']=""; 
			$i10_arr['p101']="0.00"; 
			$i10_arr['p102']="0.00"; 
			$i10_arr['p103']="0.00"; 
			$i10_arr['p105']="0"; 
			$i10_arr['p106']="0"; 
			pegasus_mysql_insert('i10' ,array_keys($i10_arr),array_values($i10_arr));
		}
		
		$i10_arr=array(); 
		$i10_arr['nr01']="10000000018"; 
		$i10_arr['p01']="1000000152"; 
		$i10_arr['p02']="Πάγια"; 
		$i10_arr['is_std']="1"; 
		if(pegasus_mysql_printfld('i10' , 'nr01' , 'nr01=:nr01' , array('nr01' => $i10_arr['nr01']))>0){
			pegasus_mysql_update('i10' ,array_keys($i10_arr),array_values($i10_arr), 'nr01=:nr01',0,1,1, array('nr01' => $i10_arr['nr01']));
		}else{
			$i10_arr['p300']= (pegasus_mysql_printfld('i10' , 'count(*)' , 'is_std=0')>0)? 0 : 1  ;  
			$i10_arr['p01']="1000000152"; 
			$i10_arr['p04']=""; 
			$i10_arr['p05']=""; 
			$i10_arr['p101']="0.00"; 
			$i10_arr['p102']="0.00"; 
			$i10_arr['p103']="0.00"; 
			$i10_arr['p105']="0"; 
			$i10_arr['p106']="0"; 
			pegasus_mysql_insert('i10' ,array_keys($i10_arr),array_values($i10_arr));
		}
		
		$i10_arr=array(); 
		$i10_arr['nr01']="10000000019"; 
		$i10_arr['p01']="1000000153"; 
		$i10_arr['p02']="Ενοίκια"; 
		$i10_arr['is_std']="1"; 
		if(pegasus_mysql_printfld('i10' , 'nr01' , 'nr01=:nr01' , array('nr01' => $i10_arr['nr01']))>0){
			pegasus_mysql_update('i10' ,array_keys($i10_arr),array_values($i10_arr), 'nr01=:nr01',0,1,1, array('nr01' => $i10_arr['nr01']));
		}else{
			$i10_arr['p300']= (pegasus_mysql_printfld('i10' , 'count(*)' , 'is_std=0')>0)? 0 : 1  ;  
			$i10_arr['p01']="1000000153"; 
			$i10_arr['p04']=""; 
			$i10_arr['p05']=""; 
			$i10_arr['p101']="0.00"; 
			$i10_arr['p102']="0.00"; 
			$i10_arr['p103']="0.00"; 
			$i10_arr['p105']="0"; 
			$i10_arr['p106']="0"; 
			pegasus_mysql_insert('i10' ,array_keys($i10_arr),array_values($i10_arr));
		}
		
		$i10_arr=array(); 
		$i10_arr['nr01']="10000000020"; 
		$i10_arr['p01']="1000000006"; 
		$i10_arr['p02']="Εμπορεύματα με Μηδενικό ΦΠΑ"; 
		$i10_arr['is_std']="1"; 
		if(pegasus_mysql_printfld('i10' , 'nr01' , 'nr01=:nr01' , array('nr01' => $i10_arr['nr01']))>0){
			pegasus_mysql_update('i10' ,array_keys($i10_arr),array_values($i10_arr), 'nr01=:nr01',0,1,1, array('nr01' => $i10_arr['nr01']));
		}else{
			$i10_arr['p300']= (pegasus_mysql_printfld('i10' , 'count(*)' , 'is_std=0')>0)? 0 : 1  ;  
			$i10_arr['p01']="1000000006"; 
			$i10_arr['p04']="20.  .  ."; 
			$i10_arr['p05']="70-20-00"; 
			$i10_arr['p101']="0.00"; 
			$i10_arr['p102']="0.00"; 
			$i10_arr['p103']="0.00"; 
			$i10_arr['p105']="0"; 
			$i10_arr['p106']="0"; 
			pegasus_mysql_insert('i10' ,array_keys($i10_arr),array_values($i10_arr));
		}
		
		$i10_arr=array(); 
		$i10_arr['nr01']="10000000021"; 
		$i10_arr['p01']="1000000052"; 
		$i10_arr['p02']="Λοιπα Συνήθη Έσοδα"; 
		$i10_arr['is_std']="1"; 
		if(pegasus_mysql_printfld('i10' , 'nr01' , 'nr01=:nr01' , array('nr01' => $i10_arr['nr01']))>0){
			pegasus_mysql_update('i10' ,array_keys($i10_arr),array_values($i10_arr), 'nr01=:nr01',0,1,1, array('nr01' => $i10_arr['nr01']));
		}else{
			$i10_arr['p300']= (pegasus_mysql_printfld('i10' , 'count(*)' , 'is_std=0')>0)? 0 : 1  ;  
			$i10_arr['p01']="1000000052"; 
			$i10_arr['p04']=""; 
			$i10_arr['p05']="70-20-00"; 
			$i10_arr['p101']="0.00"; 
			$i10_arr['p102']="0.00"; 
			$i10_arr['p103']="0.00"; 
			$i10_arr['p105']="0"; 
			$i10_arr['p106']="0"; 
			pegasus_mysql_insert('i10' ,array_keys($i10_arr),array_values($i10_arr));
		}
		
		$i10_arr=array(); 
		$i10_arr['nr01']="10000000022"; 
		$i10_arr['p01']="1000000053"; 
		$i10_arr['p02']="Λοιπά Πληροφοριακά Στοιχεία Εσόδων"; 
		$i10_arr['is_std']="1"; 
		if(pegasus_mysql_printfld('i10' , 'nr01' , 'nr01=:nr01' , array('nr01' => $i10_arr['nr01']))>0){
			pegasus_mysql_update('i10' ,array_keys($i10_arr),array_values($i10_arr), 'nr01=:nr01',0,1,1, array('nr01' => $i10_arr['nr01']));
		}else{
			$i10_arr['p300']= (pegasus_mysql_printfld('i10' , 'count(*)' , 'is_std=0')>0)? 0 : 1  ;  
			$i10_arr['p01']="1000000053"; 
			$i10_arr['p04']=""; 
			$i10_arr['p05']="70-20-00"; 
			$i10_arr['p101']="0.00"; 
			$i10_arr['p102']="0.00"; 
			$i10_arr['p103']="0.00"; 
			$i10_arr['p105']="0"; 
			$i10_arr['p106']="0"; 
			pegasus_mysql_insert('i10' ,array_keys($i10_arr),array_values($i10_arr));
		}
		
		
		
	}
	function peg_inventory_user_defined_fields(){
	    for ($i = 0; $i < 4; $i++) {
	        
	        for ($ii = 1; $ii < 6; $ii++) {
	            pegasus_mysql_use('select * from p82 where p00="inventory_pd'.$ii .$i. '_tit";', $p82);
	            
	            $tit  = $p82['p01'];
	            $etit = $p82['ep01'];
	            
	            
	             
	            if( !empty($_SESSION['inventory_000_pd' .$ii .$i]) ){
	                $tit  = $_SESSION['inventory_000_pd' .$ii .$i];
	                $etit = $_SESSION['inventory_000_pd' .$ii .$i];
	            }
	            
	            
	            $arr1 = array(); $arr2 = array();
	            array_push($arr1 , 'desc02');  array_push($arr2 , $tit);
	            array_push($arr1 , 'edesc02'); array_push($arr2 , $etit);
	            pegasus_mysql_update('p51', $arr1, $arr2, 'p02 in ("i00_d" , "i00_d1" ) and desc05="pd'.$ii .$i.'"');
	        }
	        
	    }
	    for ($i = 0; $i < 4; $i++) {
	        for ($ii = 0; $ii < 2; $ii++) {
	            $tmpTable;
	            
	            switch ($i) {
	                case 1:
	                    $tmpTable = 'i22' ;
	                break;
	                case 2:
	                    $tmpTable = 'i29' ;
	                    break;
	                case 3:
	                    $tmpTable = 'i30' ;
	                    break;
	                default:
	                    $tmpTable = 'i21' ;
	                break;
	            }
	            pegasus_mysql_use('select * from p82 where p00="inventory_'.$tmpTable.'pd2'.$ii. '_tit";', $p82);
	            
	            $tit  = $p82['p01'];
	            $etit = $p82['ep01'];
	            
	            if( !empty($_SESSION['inventory_000_'.$tmpTable.'pd2' .$ii ]) ){
	                $tit  = $_SESSION['inventory_000_'.$tmpTable.'pd2' .$ii ];
	                $etit = $_SESSION['inventory_000_'.$tmpTable.'pd2' .$ii ];
	            }
	            $arr1 = array(); $arr2 = array();
	            array_push($arr1 , 'desc02');  array_push($arr2 , $tit);
	            array_push($arr1 , 'edesc02'); array_push($arr2 , $etit);
	            pegasus_mysql_update('p51', $arr1, $arr2, 'p02 in ("'.$tmpTable.'_d" ) and desc05="pd2'.$ii .'"');
	        }
	       
	    }
	    
	    pegasus_delete_directory('../../tmp/inventory/i00_d/');
	    pegasus_delete_directory('../../tmp/inventory/i00_d1/');
	    
	    
	    pegasus_delete_directory('../../tmp/inventory/i21_d/');
	    pegasus_delete_directory('../../tmp/inventory/i22_d/');
	    pegasus_delete_directory('../../tmp/inventory/i29_d/');
	    pegasus_delete_directory('../../tmp/inventory/i30_d/');
		
		if( pegasus_module_exists('peg002') ){
			peg002_clean_dCache('i00_d');
			peg002_clean_dCache('i00_d1');
			peg002_clean_dCache('i21_d');
			peg002_clean_dCache('i22_d');
			peg002_clean_dCache('i29_d');
			peg002_clean_dCache('i30_d');
		}
	}
	function inventory_after_update_i12()
	{
		//BackUp table a30
		pegasus_mysql_backup_table('i12');
		//delete
		pegasus_mysql_delete('i12', 'nr01>0');
		//upload.sgl
		pegasus_mysql_upload_sql('../inventory_exec/i12.sql');
		//remake a30
		pegasus_mysql_remake_p75('i12');
		pegasus_change_stracture('i12', 'i12_d', 'inventory', 1);
		
	}
	/**
	 * Update i00d_20 fs01 title (on module lot or serial change)
	 */
	function peg_inventory_set_lot_or_serial_name()
	{
		if(pegasus_module_exists('lot')||pegasus_module_exists('serial')){

			$dic_title=array();
			if(!pegasus_module_exists('lot')){
				//Get Serial Title
				pegasus_mysql_use('select * from p82 where p00 = "inventory_i00_d20_fs01_title01" ', $dic_title);
			}
			elseif(!pegasus_module_exists('serial')){
				// Get Lot title
				pegasus_mysql_use('select * from p82 where p00 = "inventory_i00_d20_fs01_title02" ', $dic_title);
			}
			else{
				// Setial And Lot
				pegasus_mysql_use('select * from p82 where p00 = "inventory_i00_d20_fs01_title00" ', $dic_title);
			}
			$arr1 = array();
			$arr2 = array();
			array_push($arr1, 'desc02'); array_push($arr2, $dic_title['p01']);
			array_push($arr1, 'edesc02'); array_push($arr2, $dic_title['ep01']);
			pegasus_mysql_update('p51',$arr1,$arr2,'module="inventory" and p02="i00_d20" and desc05=?', 0, 1, 1, array('fs01'));
			unset($arr1);
			unset($arr2);
			pegasus_delete_directory('../../tmp/inventory/i00_d20/');
			peg002_clean_dCache('i00_d20');
		}
	}
	function peg_inventory_set_pricelists_names_in_i00_d7(){

		$pricelists_dic_arr = array();
		$pricelists_dic_arr['timh1'] = array("dic" => "inventory_timh1", "i23" => 4); //Τιμή Κόστους 4
		$pricelists_dic_arr['timh2'] = array("dic" => "inventory_timh2", "i23" => 2); //Τιμή Λιανικής 2
		$pricelists_dic_arr['timh3'] = array("dic" => "inventory_timh3", "i23" => 1); //Τιμή Χονδρικής 1
		$pricelists_dic_arr['timh4'] = array("dic" => "inventory_timh4", "i23" => 3); //Τιμή Υπερχονδρικής 3
	
		pegasus_mysql_use('select * from p82 where p00 = "inventory_with_fpa" ', $dic_with_fpa);
		pegasus_mysql_use('select * from p82 where p00 = "inventory_no_fpa" ', $dic_no_fpa);
	
		foreach ($pricelists_dic_arr as $key => $value) {
			pegasus_mysql_use('select * from p82 where p00 = ? ', $p82, array($value['dic']));
			$with_fpa = pegasus_mysql_printfld("i23", "p03_1", "p01=?", array($value['i23']));
	
			if($with_fpa == 1)
			{
				$p01 = " (".$dic_with_fpa['p01'].")";
				$ep01 = " (".$dic_with_fpa['ep01'].")";
			}	
			else{
				$p01 = " (".$dic_no_fpa['p01'].")";
				$ep01 = " (".$dic_no_fpa['ep01'].")";			
			}	
	
			$arr1 = array();
			$arr2 = array();
			array_push($arr1, 'desc02');
			array_push($arr2, $p82['p01'] . $p01 );
			array_push($arr1, 'edesc02');
			array_push($arr2,  $p82['ep01'] . $ep01 );
		
			pegasus_mysql_update('p51', $arr1, $arr2, 'p02 = "i00_d7" and desc05=?', 0, 1, 1, array($key));
		
			unset($arr1);
			unset($arr2);
		}

			 pegasus_delete_directory('../../tmp/inventory/i00_d/');
			 pegasus_delete_directory('../../tmp/inventory/i00_d7/');
			 pegasus_delete_directory('../../tmp/inventory/i23_d/');

			
			if( pegasus_module_exists('peg002') && function_exists('peg002_clean_dCache')){
			peg002_clean_dCache('i00_d');
			peg002_clean_dCache('i00_d7');
			peg002_clean_dCache('i23_d');
			}
	
	}
	function peg_inventory__i00_change_pno_d_initialize($data,$mmnr01='',$mnr01='',$_d='',$container_id=''){
		if($_d=='_i00_change_pno_d'){
			pegasus_mysql_use('select * from i00 where nr01=?',$i00,array($_REQUEST['i00_nr01']));
			$data['name']=$i00['name'];
			$data['old_pno']=$i00['pno'];
	
		 	$data['name_readonly'] = 1;
	
	 		$data['old_pno_readonly'] = 1;
	 		$data['log_readonly'] = 1;

			if(!pegasus_check_permission('inventory_change_pno')) { 
				$data['permDeny'] = 1;
				$data['permDenyMessage'] = $_SESSION['peg_dic_inventory_change_pno_perm'];

				return $data;
			}
		}
		return $data;
	}

	function peg_inventory_i00_mass_change_price_initialize($data,$mmnr01,$mnr01,$_d = '',$container_id = ''){
		global $PegInput;
		//Αρχικοποιώ τα checkbox του ΦΠΑ βάσει των βασικών τιμοκαταλόγων.
		$data['timh1_fpa_check'] = pegasus_mysql_printfld('i23', 'p03_1', 'p01 = 4');
		$data['timh2_fpa_check'] = pegasus_mysql_printfld('i23', 'p03_1', 'p01 = 2');
		$data['timh3_fpa_check'] = pegasus_mysql_printfld('i23', 'p03_1', 'p01 = 1');
		$data['timh4_fpa_check'] = pegasus_mysql_printfld('i23', 'p03_1', 'p01 = 3');
		$PegInput->addVar(new peg_input_alphanumeric('grid_selection'));
		$PegInput->addVar(new peg_input_alphanumeric('peg_view_table'));
		$PegInput->addVar(new peg_input_alphanumeric('peg_view_d'));
		$PegInput->addVar(new peg_input_alphanumeric('peg_view_module'));
		$grid_selection  = $PegInput->getRequest('grid_selection');
		$peg_view_table  = $PegInput->getRequest('peg_view_table');
		$peg_view_d 	 = $PegInput->getRequest('peg_view_d');
		$peg_view_module = $PegInput->getRequest('peg_view_module');

		if(!empty($grid_selection)) {
			$grid_selection_explode = explode(',',$grid_selection);
			$data['filters'] = str_replace('#cnt#', count($grid_selection_explode),
			$_SESSION['peg_dic_mass_change_price_nr01_filter']
			);
		}	

		// Δεν θέλουμε να συμμετέχουν τα υπόλοιπα φίλτρα αν έχει γίνει πολλαπλή επιλογή γραμμών
		if(empty($grid_selection)) {
			$peg_cont_id     = pegasus_container_id_get_parentBy_d($container_id, 'browse_d00');
			$peg_where_arr   = pegasusGetGlobalVar('gridData_' . $peg_cont_id . '_grid_where_array');
			$wwhr = '';
			$wwhrParams  = array();
			if (function_exists('peg002_make_grid_where')) {
				$whereTbl = peg002_make_grid_where($peg_where_arr, $peg_view_table);
				$wwhr = $whereTbl['where'];
				$wwhrParams = $whereTbl['whereParams'];
			} else {
				$wwhr = make_grid_where($peg_where_arr, $peg_view_table);
			}
			if (!empty($wwhr)) {
				$peg_d           = strip_tags($peg_view_d);
				$peg_module      = strip_tags($peg_view_module);
				$msg = make_grid_where_message(
					$peg_where_arr,
					$peg_d,
					$peg_module
				);
				$cnt = pegasus_mysql_printfld($peg_view_table, 'count(*)', $wwhr, $wwhrParams);
				$data['filters'] = str_replace(
					array('#cnt#'),
					array($cnt),
					$_SESSION['peg_dic_mass_change_filter']
				)." $msg";
			}
		}
		if (empty($data['filters'])) {
			$data['filters'] = '<b style="color:red">' . $_SESSION['peg_dic_mass_change_price_nr01_no_filter'] . '</b>';
		}

		return $data;
}


	function inventory_i00_mass_change_price_set_values($data){
		//Εδω ενημερώνω τις βασικές τιμές των ειδών
		if(!empty($data['grid_selection'])){
			//Φτιαχνω τα nr01 για το query
			$i00_params 	= array();
			$i00_nr01       = explode(',', $data['grid_selection']);
			$i00_nr01_in    = pegasus_mysql_create_in($i00_nr01, 'i00_nr01');
			$i00_nr01_where = " and i00.nr01 IN (" .$i00_nr01_in['sql'] . ")";
			$i00_params     = array_merge($i00_params ,$i00_nr01_in['sqlParams']);
		}else{
			//Αν η αναζητηση εχει ερθει απο φιλτρα
			$peg_cont_id     = pegasus_container_id_get_parentBy_d($data['container_id'], 'browse_d00');
			$peg_where_arr   = pegasusGetGlobalVar('gridData_' . $peg_cont_id . '_grid_where_array');
			$wwhr = '';
			$wwhrParams  = array();
			if (function_exists('peg002_make_grid_where')) {
				$whereTbl = peg002_make_grid_where($peg_where_arr, 'i00');
				$wwhr = $whereTbl['where'];
				$wwhrParams = $whereTbl['whereParams'];
			} else {
				$wwhr = make_grid_where($peg_where_arr, 'i00');
			}
			//var_dump($wwhr);
			$i00_params 	= $wwhrParams;
			$i00_nr01_where = '';
			if(!empty($wwhr)){
				$i00_nr01_where = ' and '.$wwhr;
			}
			//var_dump($i00_params.'====='.$i00_nr01_where);
		}
		$markup_update = '';
		$markup_update_params = array();
		$increases_where = '';
		$update_selected_i17 		= "";
		$update_selected_i17_params = array();
		// Ανάλογα το τι έχει επιλέξει στο Ο υπολογισμός θα γίνει επάνω υπολογίζει και την τιμή που θα προσθέσει
		switch ($data['calculate']) {
			case 1:
				$i00_timh1 = 'i00.timh1 + i00.timh1 ' ;    
				$i00_timh2 = 'i00.timh2 + i00.timh2 ' ;
				$i00_timh3 = 'i00.timh3 + i00.timh3 ' ;
				$i00_timh4 = 'i00.timh4 + i00.timh4 ' ;
				$i17_pe03  = 'i17.pe03 + i17.pe03 ';
			break;
			case 2:
				$i00_timh1 = 'i00.timh1 + i00.timh1 ' ;
				$i00_timh2 = 'i00.timh1 + i00.timh1 ' ;
				$i00_timh3 = 'i00.timh1 + i00.timh1 ' ;
				$i00_timh4 = 'i00.timh1 + i00.timh1 ' ;
				$i17_pe03  = 'i00.timh1 + i00.timh1 ' ;
				break;
			case 3:
				$i00_timh1 = 'i00.p610 + i00.p610 ' ;
				$i00_timh2 = 'i00.p610 + i00.p610 ' ;
				$i00_timh3 = 'i00.p610 + i00.p610 ' ;
				$i00_timh4 = 'i00.p610 + i00.p610 ' ;
				$i17_pe03  = 'i00.p610 + i00.p610 ' ;
				break;
			case 4:
				$i00_timh1 = 'i00.p610*(100-p611e)/100 + i00.p610*(100-p611e)/100 ' ;
				$i00_timh2 = 'i00.p610*(100-p611e)/100 + i00.p610*(100-p611e)/100 ' ;
				$i00_timh3 = 'i00.p610*(100-p611e)/100 + i00.p610*(100-p611e)/100 ' ;
				$i00_timh4 = 'i00.p610*(100-p611e)/100 + i00.p610*(100-p611e)/100 ' ;
				$i17_pe03  = 'i00.p610*(100-p611e)/100 + i00.p610*(100-p611e)/100 ' ;
			break;
			case 5:
				$i00_timh1 = '(i00.p610*(100-p611e)/100 + p611) + (i00.p610*(100-p611e)/100 + p611) ' ;
				$i00_timh2 = '(i00.p610*(100-p611e)/100 + p611) + (i00.p610*(100-p611e)/100 + p611) ' ;    
				$i00_timh3 = '(i00.p610*(100-p611e)/100 + p611) + (i00.p610*(100-p611e)/100 + p611) ' ; 
				$i00_timh4 = '(i00.p610*(100-p611e)/100 + p611) + (i00.p610*(100-p611e)/100 + p611) ' ;
				$i17_pe03  = '(i00.p610*(100-p611e)/100 + p611) + (i00.p610*(100-p611e)/100 + p611) ' ;
			break;
			case 6:
				$i00_timh1 = 'i00.timh4 + i00.timh4 ' ;
				$i00_timh2 = 'i00.timh4 + i00.timh4 ' ;
				$i00_timh3 = 'i00.timh4 + i00.timh4 ' ;
				$i00_timh4 = 'i00.timh4 + i00.timh4 ' ;
				$i17_pe03  = 'i00.timh4 + i00.timh4 ' ;
			break;
			case 7:
				$i00_timh1 = 'i00.timh3 + i00.timh3 ' ;
				$i00_timh2 = 'i00.timh3 + i00.timh3 ' ;
				$i00_timh3 = 'i00.timh3 + i00.timh3 ' ;
				$i00_timh4 = 'i00.timh3 + i00.timh3 ' ;
				$i17_pe03  = 'i00.timh3 + i00.timh3 ' ;
			break;
			case 8:
				$i00_timh1 = 'i00.timh2 + i00.timh2 ' ;
				$i00_timh2 = 'i00.timh2 + i00.timh2 ' ;
				$i00_timh3 = 'i00.timh2 + i00.timh2 ' ;
				$i00_timh4 = 'i00.timh2 + i00.timh2 ' ;
				$i17_pe03  = 'i00.timh2 + i00.timh2 ' ;
			break;
			case 9:
				$i00_timh1 = "peg_i00cost(i00.pno,'0100-01-01',curdate(),0,999999,i00.p414,0) + peg_i00cost(i00.pno,'0100-01-01',curdate(),0,999999,i00.p414,0) " ;    
				$i00_timh2 = "peg_i00cost(i00.pno,'0100-01-01',curdate(),0,999999,i00.p414,0) + peg_i00cost(i00.pno,'0100-01-01',curdate(),0,999999,i00.p414,0) " ;
				$i00_timh3 = "peg_i00cost(i00.pno,'0100-01-01',curdate(),0,999999,i00.p414,0) + peg_i00cost(i00.pno,'0100-01-01',curdate(),0,999999,i00.p414,0) " ;
				$i00_timh4 = "peg_i00cost(i00.pno,'0100-01-01',curdate(),0,999999,i00.p414,0) + peg_i00cost(i00.pno,'0100-01-01',curdate(),0,999999,i00.p414,0) " ;
				$i17_pe03  = "peg_i00cost(i00.pno,'0100-01-01',curdate(),0,999999,i00.p414,0) + peg_i00cost(i00.pno,'0100-01-01',curdate(),0,999999,i00.p414,0) " ;
			break;
			
		}

		//Query params
		$query_params['balance_from'] 		= $data['balance_from'];
		$query_params['balance_to']   		= $data['balance_to'];
		$query_params['local_balance_from'] = $data['local_balance_from'];
		$query_params['local_balance_to']   = $data['local_balance_to'];
		$query_params['var_cor003_p303']    = $_SESSION['cor003_p303'];
		$query_params['var_cor003_p304']    = $_SESSION['cor003_p304'];
		$query_params['decimals']    		= $data['decimals'];

		if($data['timh1_check'] == '1'){
			//Υπολογιζω την τιμή που θα κάνω set
			$i00_timh1 = "".$i00_timh1." *(:var_i00_timh1 /100) ";
			$i00_timh_params = array("var_i00_timh1"=>$data['timh1']);
			//Αν έχει check στο Να γίνουν μόνο οι αυξήσεις: ελεγχω αν είναι μεγαλυτερο το i00.timh1 απο την νεα τιμή
			if($data['increases'] == '1'){
				$increases_where = " and i00.timh1 < $i00_timh1 ";
			}
			$query_params  = array_merge($query_params, $i00_params, $i00_timh_params);
			pegasus_query("UPDATE i00
							LEFT JOIN (
								SELECT
								i00tot.pno1,
								SUM(i00tot.p03) AS p03
								FROM i00tot
								GROUP BY i00tot.pno1
							)   AS i00tot ON i00tot.pno1 = i00.pno
							LEFT JOIN (
								SELECT
								i00tot.pno1,
								SUM(i00tot.p03) AS p03
								FROM i00tot
								WHERE i00tot.p610 >= :var_cor003_p303 and i00tot.p610 <= :var_cor003_p304 
								GROUP BY i00tot.pno1
							)   AS i00tot_2 ON i00tot_2.pno1 = i00.pno
							LEFT JOIN i13 ON i00.fpa = i13.p01
							SET i00.timh1 = ".($data['timh1_fpa_check'] == '1' ? "round(".$i00_timh1." + (".$i00_timh1.")* i13.p03/100, :decimals) " : "round(".$i00_timh1.", :decimals)" )."  
							WHERE IFNULL(i00tot.p03, 0) >= :balance_from 
							and IFNULL(i00tot.p03, 0) <= :balance_to 
							and IFNULL(i00tot_2.p03, 0) >= :local_balance_from
							and IFNULL(i00tot_2.p03, 0) <= :local_balance_to
							$i00_nr01_where".$increases_where,
							$query_params);
		}
		if($data['timh2_check'] == '1'){
			//Στην περίπτωση που έχει check στο ενημέρωση και του % του Markup
			if($data['update_markup'] == '1'){
				$markup_update = " ,i00.tim2 = :var_timh2";
				$markup_update_params = array('var_timh2'=>$data['timh2']);
			}
			$i00_timh2 = "$i00_timh2 *( if(:var_i00_timh2 = '0', i00.tim2, :var_i00_timh2) /100) ";
			$i00_timh_params = array("var_i00_timh2"=>$data['timh2']);
			//Αν έχει check στο Να γίνουν μόνο οι αυξήσεις: ελεγχω αν είναι μεγαλυτερο το i00.timh1 απο την νεα τιμή
			if($data['increases'] == '1'){
				$increases_where = " and i00.timh2 < $i00_timh2 ";
			}
			$query_params  = array_merge($query_params, $i00_params, $markup_update_params, $i00_timh_params);
			pegasus_query("UPDATE i00
							LEFT JOIN (
								SELECT
								i00tot.pno1,
								SUM(i00tot.p03) AS p03
								FROM i00tot
								GROUP BY i00tot.pno1
							)   AS i00tot ON i00tot.pno1 = i00.pno
							LEFT JOIN (
								SELECT
								i00tot.pno1,
								SUM(i00tot.p03) AS p03
								FROM i00tot
								WHERE i00tot.p610 >= :var_cor003_p303 and i00tot.p610 <= :var_cor003_p304 
								GROUP BY i00tot.pno1
							)   AS i00tot_2 ON i00tot_2.pno1 = i00.pno
							LEFT JOIN i13 ON i00.fpa = i13.p01
							SET i00.timh2 = ".($data['timh2_fpa_check'] == '1' ? "round(".$i00_timh2." + (".$i00_timh2.")* i13.p03/100, :decimals) ".$markup_update  : "round(".$i00_timh2.", :decimals)".$markup_update )."
							WHERE IFNULL(i00tot.p03, 0) >= :balance_from 
							and IFNULL(i00tot.p03, 0) <= :balance_to 
							and IFNULL(i00tot_2.p03, 0) >= :local_balance_from
							and IFNULL(i00tot_2.p03, 0) <= :local_balance_to
							$i00_nr01_where".$increases_where,
							$query_params);		
							
		}
		if($data['timh3_check'] == '1'){
			//Στην περίπτωση που έχει check στο ενημέρωση και του % του Markup
			if($data['update_markup'] == '1'){
				$markup_update = " ,i00.tim3 = :var_timh3";
				$markup_update_params = array('var_timh3'=>$data['timh3']);
			}
			$i00_timh3 = "".$i00_timh3." *( if(:var_i00_timh3 = '0', i00.tim3, :var_i00_timh3) /100) ";
			$i00_timh_params = array("var_i00_timh3"=>$data['timh3']);
			//Αν έχει check στο Να γίνουν μόνο οι αυξήσεις: ελεγχω αν είναι μεγαλυτερο το i00.timh1 απο την νεα τιμή
			if($data['increases'] == '1'){
				$increases_where = " and i00.timh3 < $i00_timh3 ";
			}
			$query_params  = array_merge($query_params, $i00_params, $markup_update_params, $i00_timh_params);
			pegasus_query("UPDATE i00
							LEFT JOIN (
								SELECT
								i00tot.pno1,
								SUM(i00tot.p03) AS p03
								FROM i00tot
								GROUP BY i00tot.pno1
							)   AS i00tot ON i00tot.pno1 = i00.pno
							LEFT JOIN (
								SELECT
								i00tot.pno1,
								SUM(i00tot.p03) AS p03
								FROM i00tot
								WHERE i00tot.p610 >= :var_cor003_p303 and i00tot.p610 <= :var_cor003_p304 
								GROUP BY i00tot.pno1
							)   AS i00tot_2 ON i00tot_2.pno1 = i00.pno
							LEFT JOIN i13 ON i00.fpa = i13.p01
							SET i00.timh3 = ".($data['timh3_fpa_check'] == '1' ? "round(".$i00_timh3." + (".$i00_timh3.")* i13.p03/100, :decimals) ".$markup_update  : "round(".$i00_timh3.", :decimals)".$markup_update )."
							WHERE IFNULL(i00tot.p03, 0) >= :balance_from 
							and IFNULL(i00tot.p03, 0) <= :balance_to 
							and IFNULL(i00tot_2.p03, 0) >= :local_balance_from
							and IFNULL(i00tot_2.p03, 0) <= :local_balance_to
							$i00_nr01_where".$increases_where,
							$query_params);	
		}
		if($data['timh4_check'] == '1'){
			if($data['update_markup'] == '1'){
				$markup_update = " ,i00.tim4 = :var_timh4";
				$markup_update_params = array('var_timh4'=>$data['timh4']);
			}
			$i00_timh4 = "".$i00_timh4." *( if(:var_i00_timh4 = '0', i00.tim4, :var_i00_timh4) /100) ";
			$i00_timh_params = array("var_i00_timh4"=>$data['timh4']);
			//Αν έχει check στο Να γίνουν μόνο οι αυξήσεις: ελεγχω αν είναι μεγαλυτερο το i00.timh1 απο την νεα τιμή
			if($data['increases'] == '1'){
				$increases_where = " and i00.timh4 < $i00_timh4 ";
			}
			$query_params  = array_merge($query_params, $i00_params, $markup_update_params, $i00_timh_params);
			pegasus_query("UPDATE i00
						LEFT JOIN (
							SELECT
							i00tot.pno1,
							SUM(i00tot.p03) AS p03
							FROM i00tot
							GROUP BY i00tot.pno1
						)   AS i00tot ON i00tot.pno1 = i00.pno
						LEFT JOIN (
							SELECT
							i00tot.pno1,
							SUM(i00tot.p03) AS p03
							FROM i00tot
							WHERE i00tot.p610 >= :var_cor003_p303 and i00tot.p610 <= :var_cor003_p304 
							GROUP BY i00tot.pno1
						)   AS i00tot_2 ON i00tot_2.pno1 = i00.pno
						LEFT JOIN i13 ON i00.fpa = i13.p01
						SET i00.timh4 = ".($data['timh4_fpa_check'] == '1' ? "round(".$i00_timh4." + (".$i00_timh4.")* i13.p03/100, :decimals) ".$markup_update  : "round(".$i00_timh4.", :decimals)".$markup_update )."
						WHERE IFNULL(i00tot.p03, 0) >= :balance_from 
						and IFNULL(i00tot.p03, 0) <= :balance_to 
						and IFNULL(i00tot_2.p03, 0) >= :local_balance_from
						and IFNULL(i00tot_2.p03, 0) <= :local_balance_to
						$i00_nr01_where".$increases_where,
						$query_params);	
		}
		
		//Update τις ειδικες τιμές
		if(!empty($data['markup'])){
			if($data['update_markup_2']){
					$markup_update = " ,i17.pe04 = :i17_pe04";
					$markup_update_params = array('i17_pe04'=>$data['markup']);
			}

			//Υπολογιζω την τιμή που θα κάνω set
			$i17_pe03_select = " IFNULL(round(".$i17_pe03." *(".$data['markup']." /100), ".$data['decimals'].")  , 0) "; 
			$i17_pe03 = "".$i17_pe03." *(:markup /100) ";
			$i17_pe03_params = array("markup"=>$data['markup']);
			//Αν εχει επιλεξει να γίνουν μόνο οι αυξήσεις
			if($data['increases'] == '1'){
				$increases_where = " and i17.pe03 < $i17_pe03 ";
			}
			//Αν επιλέξει την Ενημέρωση όλων των Ειδικών Τιμοκαταλόγων
			if($data['update_i14'] == '0'){
				$update_selected_i17 		= " and i17.pe02 = :i14_p01 ";
				$update_selected_i17_params = array('i14_p01'=>$data['i14_p01']); 
			}
			$query_params  = array_merge($query_params, $i00_params, $markup_update_params, $i17_pe03_params, $update_selected_i17_params);

			pegasus_query("UPDATE i17
						LEFT JOIN i00 on i17.i00 = i00.nr01
						LEFT JOIN (
							SELECT
							i00tot.pno1,
							SUM(i00tot.p03) AS p03
							FROM i00tot
							GROUP BY i00tot.pno1
						)   AS i00tot ON i00tot.pno1 = i00.pno
						LEFT JOIN (
							SELECT
							i00tot.pno1,
							SUM(i00tot.p03) AS p03
							FROM i00tot
							WHERE i00tot.p610 >= :var_cor003_p303 and i00tot.p610 <= :var_cor003_p304 
							GROUP BY i00tot.pno1
						)   AS i00tot_2 ON i00tot_2.pno1 = i00.pno
						SET  i17.pe03 = round(".$i17_pe03.", :decimals) ".$markup_update."  
						WHERE IFNULL(i00tot.p03, 0) >= :balance_from 
						and IFNULL(i00tot.p03, 0) <= :balance_to 
						and IFNULL(i00tot_2.p03, 0) >= :local_balance_from
						and IFNULL(i00tot_2.p03, 0) <= :local_balance_to".
						$i00_nr01_where.
						$increases_where.
						$update_selected_i17,
						$query_params);


			//Αν έχει επιλέξει Αν δεν υπάρχουν να δημιουργηθούν :
			if($data['create'] == '1'){	
				//Με αυτο το query βρήσκω για ποια nr01 πρέπει να κάνω νέα εγγραφή στον i17 
				$res_params     = array_merge($update_selected_i17_params ,$i00_params);
				$res = pegasus_query("SELECT i00.nr01
									FROM i00
									LEFT JOIN i17 ON i17.i00 = i00.nr01 ".$update_selected_i17 ."
									WHERE i17.i00 IS NULL "
									.$i00_nr01_where.";",
									 $res_params);
				//Εγγραφή στον i17 για κάθε nr01
				while ($nr01_insert = pegasus_fetch_assoc($res)){
					$new_nr01 = pegasus_mysql_newrec('i17');

					$query_params['nr01_insert'] = $nr01_insert['nr01'];
					pegasus_query("INSERT INTO i17 (nr01, pe01, i00, pe02, pe03, pe04, remdate, remtime, remuser, remfdate, remftime, remfuser)
									SELECT ".$new_nr01."							AS i17_nr01,
										i00.pno  		 	 						AS i17_pe01,
										i00.nr01 		 	 						AS i17_i00,
										".$data['i14_p01']."						AS i17_pe02,
										".$i17_pe03_select."						AS i17_pe03, 
										".$data['markup']."							AS i17_pe04,
										CURDATE()									AS i17_remdate,
										CURTIME()									AS i17_remtime,
										'".$_SESSION['username']."' 		 		AS i17_remuser,
										CURDATE()									AS i17_remfdate,
										CURTIME()									AS i17_remftime,
										'".$_SESSION['username']."'					AS i17_remfuser
									FROM i00
									LEFT JOIN i17 ON i17.i00 = i00.nr01
									LEFT JOIN (
									SELECT i00tot.pno1, SUM(i00tot.p03) AS p03
									FROM i00tot
									GROUP BY i00tot.pno1
									) AS i00tot ON i00tot.pno1 = i00.pno
									LEFT JOIN (
									SELECT i00tot.pno1, SUM(i00tot.p03) AS p03
									FROM i00tot
									WHERE i00tot.p610 >= :var_cor003_p303 and i00tot.p610 <= :var_cor003_p304
									GROUP BY i00tot.pno1
									) AS i00tot_2 ON i00tot_2.pno1 = i00.pno
									WHERE IFNULL(i00tot.p03, 0) >= :balance_from 
									AND IFNULL(i00tot.p03, 0) <= :balance_to 
									AND IFNULL(i00tot_2.p03, 0) >= :local_balance_from
									AND IFNULL(i00tot_2.p03, 0) <= :local_balance_to and i00.nr01 = :nr01_insert
									AND i17.i00 IS NULL",
								//.$increases_where,
								$query_params);
				}
			}
		}

	}

	function peg_inventory_custom_actions_peg002($retArray=array(),$grid_name=''){
		$peg_handler="inventory_toolbar_item(screen.getContainer_ID(),'".$grid_name."');";
		$retArray[] = array(
	                'xtype' => 'pegasusToolBarGridAction',
	                'peg_custom_id' => 'inventory_change_pno',
	                'icon'=> 'inventory_images/change_pno.png',
	                'text'=>  $_SESSION['peg_dic_inventory_change_pno'],
	                'peghandler' => $peg_handler
	            ); 

		$peg_handler="inventory_toolbar_item_mass_change_price(screen);";
		$retArray[] = array(
	                'xtype' => 'pegasusToolBarGridAction',
	                'peg_custom_id' => 'inventory_mass_change_price',
	                'icon'=> 'inventory_images/change_price.png',
	                'text'=>  $_SESSION['peg_dic_inventory_mass_change_price'],
	                'peghandler' => $peg_handler
	            ); 
		return $retArray;
	}
	
	function peg_inventory_get_warehouses_query($i16p01='') {

		if(empty($i16p01)){
			$i16p01 = $_SESSION['peg_dic_inventory_default_warehouse'];
		}

		$query = "";    
		$query  = "SELECT * from (";
		$query .= "SELECT	i16.nr01,
							i16.p00, 
							i16.p01,
							i16.p05, 
							i16.ep05, 
							i16.p02, 
							i16.p03, 
							i16.p300, 
							i16.ptax,
							i16.p7,
							i16.t07p01
					FROM   i16 ";  
		$query .= "UNION ";
		$query .= "SELECT 	-1 as nr01,
							-1 as p00, 
							'" . $i16p01 . "' as p01, 
							'' as p05, 
							'' as ep05, 
							'' as p02, 
							'' as p03, 
							'' as p300,
							'' as ptax,
							'' as p7,
							-1 as t07p01
					";     
		$query .= ") as i16_tmp ";

		return $query;
	}

	function inventory_i00_d_griddata_comboboxV2_searchFld_filter($v_add_fld,$v_add_val,$v_add_val1,$v_add_type,$v_add_mode,$v_in_fld){
		$where='';$where_params=array();
		if($v_add_fld=='invspcodes'){
			$i08_query="SELECT pe01 FROM i08 WHERE i08.pe02 like ?";
			$i08_res=pegasus_query($i08_query,array("%".$v_add_val."%"));
			$i=0;
			while($i08=pegasus_fetch($i08_res)){
				if(!empty($where)){
					$where.=',';
				}
				$where.=':i08_'.$i.'_param';
				$where_params['i08_'.$i.'_param']=$i08['pe01'];
				$i++;
			}
			if(!empty($where)){
				$where='i00.pno in ('.$where.')';
			} else{
				$where='1=0';
			}
		}
		if($v_add_fld=='serial'){
			$i31_query="SELECT p01 FROM i31 WHERE i31.p02 like ?";
			$i31_res=pegasus_query($i31_query,array("%".$v_add_val."%"));
			$i=0;
			while($i31=pegasus_fetch($i31_res)){
				if(!empty($where)){
					$where.=',';
				}
				$where.=':i31_'.$i.'_param';
				$where_params['i31_'.$i.'_param']=$i31['p01'];
				$i++;
			}
			if(!empty($where)){
				$where='i00.pno in ('.$where.')';
			} else{
				$where='1=0';
			}
		}
		if($v_add_fld=='all_codes'){
			$inv_query=invoices_make_product_search_query($v_add_val,0,'',1);
			$inv_res=pegasus_query($inv_query['sql'],$inv_query['values']);
			$i=0;
		//	die(pegasus_replace_values_in_sql($inv_query['sql'],$inv_query['values']));
			while($row=pegasus_fetch($inv_res)){
				if(!empty($where)){
					$where.=',';
				}
				$where.=':inv_'.$i.'_param';
				$where_params['inv_'.$i.'_param']=$row['v101'];
				$i++;
			}
			if(!empty($where)){
				$where='i00.pno in ('.$where.')';
			} else{
				$where='1=0';
			}
		}
		
		return array('where'=>$where,'whereParams'=>$where_params);
	}

	function peg_inventory_get_storage_where_array( $include_i16_p00=-1, $only_non_negative_tax = 0){
		
		$i16_query = ' i16.nr01>0 ';
		
		if($only_non_negative_tax==1){
			$i16_query.=" and i16.ptax>=0 ";
		} 
		if($include_i16_p00 >= 0){
			$i16_query = " ((".$i16_query. ") or i16.p00 = :extra_i16 )";
			$values['extra_i16'] = $include_i16_p00;
		}

		$where = "/*inventory*/ (" . $i16_query . ") /*inventory*/ ";

		$sql = array('sql' => $where, 'sqlParams' => $values);
		return $sql;
	}

	function peg_inventory_get_i16_where_array()
	{

		$apoth1 = $_SESSION['cor003_p303']; //apo	
		$apoth2 = $_SESSION['cor003_p304'];	//ews

		$i16_query = 'SELECT p00 FROM i16 where nr01>0 ';
		

		if (pegasus_mysql_printfld('i16', 'nr01', 'p00=:p00', array('p00' => $apoth1)) > 0) {	
				$i16_query .= ' and p00>=:apoth1 ';
				$values['apoth1'] = $apoth1;
						
		}

		if (pegasus_mysql_printfld('i16', 'nr01', 'p00=:p00', array('p00' => $apoth2)) > 0) {	
				$i16_query .= ' and p00<=:apoth2 ';
				$values['apoth2'] = $apoth2;
					
		}
		
		$where = "/*i16*/ in (" . $i16_query . ") /*i16*/";

		$sql = array('sql'=>$where, 'sqlParams'=>$values);	

		return $sql;
	}

	function peg_inventory_get_all_i16_multi()
	{	
		$ans = "";
		// #0#1#2# .... για τους αποθηκευτικούς χώρους του i16 με βάση το τερματικό
		$sql = peg_inventory_get_i16_where_array(); 
		$query_2 = "select p00 from i16 where p00 ". $sql["sql"]; 

		$res_2 = pegasus_query($query_2, $sql["sqlParams"]);
		
		while($i16 = pegasus_fetch($res_2)){
			$ans.="#";
			$ans.=$i16['p00'];
		}
		$ans.="#";
	
		
		return $ans;
	}

	function inventory_inventory_004_d01_initialize($data, $mmnr01='', $mnr01='', $_d='', $container_id=''){
		$mmnr01_arr = explode('-', $mmnr01);


		$joins  = "";
		if(in_array($mmnr01_arr[0], array('a55_d','a56_d','a60_d'))){
			$tbl   = 'peg_tmp_i01';
			$joins = "join i00 on i00.pno=".$tbl.".p01 ";
		}elseif(in_array($mmnr01_arr[0], array('a57_d','a67_d','a61_d'))){
			if($mmnr01_arr[0]=='a67_d'){
				$tbl = 'peg_tmp_a68';
			}elseif($mmnr01_arr[0]=='a61_d'){
				$tbl = 'peg_tmp_a62';
			}else{
				$tbl = 'peg_tmp_a58';
			}
			
			$joins = "join i00 on i00.pno=".$tbl.".v101 ";
		}

		$sql = '';
		if(!empty($tbl)){
			$sql  = "select i00.ths as i00_ths ";
			$sql .= "from ".$tbl." ";
			$sql .= $joins;
			$sql .= "where ".$tbl.".peg_flag!=9 and ".$tbl.".peg_mmnr01=:mmnr01 and ".$tbl.".peg_sess_id=:sid ";
			$sql .= "group by i00.ths";
		}
		
		$i24_p01_arr = array();		
		if(!empty($sql)) {			
			$result = pegasus_query($sql, array('mmnr01'=>$mmnr01, 'sid'=>session_id()));
			
			while ($i24=pegasus_fetch_assoc($result)) {
				$i24_p01_arr[] = $i24['i00_ths'];
			}
		}
		
		$i24_p01_in = pegasus_mysql_create_in($i24_p01_arr, 'i24p01');
		if(!empty($i24_p01_in['sql'])){
			$i24_p01_in['sql']  = ' i24.p01 in ('.$i24_p01_in['sql'].') ';
		}
		pegasusSetGlobalVar($container_id . '_where_vi24p01', $i24_p01_in);	
		
		$data['vi24p01'] = (in_array('ΤΕΜ', $i24_p01_arr)) ? '#ΤΕΜ#' : '';


		

		$message = $_SESSION['peg_dic_inventory_inventory_004_d00_msg'];
		$query 	 = inventory_inventory_004_d00_query($data, $mmnr01);
		pegasusSetGlobalVar($container_id . '_query_grid_inventory_004_d', $query);

		if(pegasus_module_exists('colorsize')){
			$data['inventory_inventory_004_d00_v_colorsize_hidden'] = 0;
			// $message .= $_SESSION['peg_dic_colorsize_colorsize_001_d00_msg'];
			$module  = $_SESSION['peg_dic_colorsize_color_size'].', ';
			$query   = colorsize_colorsize_001_d00_query($data, $mmnr01);
			pegasusSetGlobalVar($container_id . '_query_grid_colorsize_001_d', $query);	
		}

		if(pegasus_module_exists('serial')){
			$data['inventory_inventory_004_d00_v_serial_hidden'] = 0;
			// $message .= $_SESSION['peg_dic_serial_serial_001_d00_msg'];
			$module .= $_SESSION['peg_dic_inventory_serial_desc'].', ';
			$query   = serial_serial_001_d00_query($data, $mmnr01);
			pegasusSetGlobalVar($container_id . '_query_grid_serial_001_d', $query);	
		}

		if(pegasus_module_exists('lot')){
			$data['inventory_inventory_004_d00_v_lot_hidden'] = 0;
			// $message .= $_SESSION['peg_dic_lot_lot_001_d00_msg'];
			$module .= $_SESSION['peg_dic_invoices_search_lots'].', ';
			$query   = lot_lot_001_d00_query($data, $mmnr01);
			pegasusSetGlobalVar($container_id . '_query_grid_lot_001_d', $query);	
		}

		if(pegasus_module_exists('colorsize') || pegasus_module_exists('serial') || pegasus_module_exists('lot')) {
			$message .= str_replace(array('#module#'), array($module), $_SESSION['peg_dic_inventory_print_labels']);
		}

		$data['message'] = (!empty($message)) ? '<div class="warning_message">' . $message . '</div>' : '';
		//$data['message'] = pegasus_replace_values_in_sql($query['sql'],$query['sqlParams']);

		return $data;
    }


	function inventory_inventory_004_d00_query($data, $mmnr01=''){
		
		if(!pegasus_mysql_table_exists('peg_tmp_inventory_004')){
			pegasus_create_tmp_table('inventory_004');
		}
		
		$mmnr01_arr = explode('-', $mmnr01);
		

		/* Delete τα δεδομένα του grid */
		if (pegasus_mysql_table_exists('peg_tmp_inventory_004')) {
			pegasus_mysql_delete('peg_tmp_inventory_004', 'peg_mmnr01=:mmnr01 AND peg_sess_id=:sid', 
				0,
				array(
					'mmnr01' => $mmnr01_arr[0].'-0',
					'sid' 	 => session_id()
				)
			);
		}

		/* Επιλεγει το αντιστοιχο Grid απο την οθονη που προερχεται */
		$i24_p01_arr = explode('#', $data['vi24p01']);	
		if(in_array($mmnr01_arr[0], array('a55_d','a56_d','a60_d'))){
			$tbl 	= 'peg_tmp_i01';
			
			if($mmnr01_arr[0]=='a56_d'){
				$type = "1";
			}elseif($mmnr01_arr[0]=='a60_d'){
				$type = "3";
			}else{
				$type = "2";	
			}

			$fields = "i00.*, ".$tbl.".nr01 as ".$tbl."_nr01, ".$tbl.".p03 as quan ";
			$joins  = "join i00 on i00.pno=".$tbl.".p01 ";
			$where  = " and ".$tbl.".p07=".$type." and ".$tbl.".ppnr01 = 0 ";
			$group  = " ".$tbl.".nr01, ";

			if(pegasus_module_exists('colorsize')){
				$fields .= ", peg_tmp_i48.nr01 as peg_tmp_i48_nr01 ";
				$joins  .= "left join peg_tmp_i48 on peg_tmp_i48.i01p01=".$tbl.".p01 and peg_tmp_i48.p01=".$tbl.".nr01 ";

				if($data['v_colorsize'] == 0) {
					$where  .= " and peg_tmp_i48.nr01 is null ";
				} else {
					$group .= "peg_tmp_i48.p01, ";
				}
			}

			if(pegasus_module_exists('serial')){
				$fields .= ", peg_tmp_i32.nr01 as peg_tmp_i32_nr01 ";
				$joins  .= "left join peg_tmp_i32 on peg_tmp_i32.p01=".$tbl.".p01 and peg_tmp_i32.p00=".$tbl.".nr01 ";

				if($data['v_serial'] == 0) {
					$where  .= " and peg_tmp_i32.nr01 is null ";
				} else {
					$group .= "peg_tmp_i32.p00, ";
				}
            }

            if(pegasus_module_exists('lot')){
				$fields .= ", peg_tmp_i38.nr01 as peg_tmp_i38_nr01 ";
				$joins  .= "left join peg_tmp_i38 on peg_tmp_i38.p010=1 and peg_tmp_i38.p01=".$tbl.".nr01 ";

				if($data['v_lot'] == 0) {
					$where  .= " and peg_tmp_i38.nr01 is null ";
				} else {
					$group .= "peg_tmp_i38.p01, ";
				}
			}

		}elseif(in_array($mmnr01_arr[0], array('a57_d','a67_d','a61_d'))){

			if($mmnr01_arr[0]=='a57_d' && pegasus_module_exists('ordercust')){
				$tbl 	  = 'peg_tmp_a58';
				$tbl_cs	  = 'peg_tmp_a59';
				$i38_p010 = 2;

			}elseif($mmnr01_arr[0]=='a67_d' && pegasus_module_exists('ordersupp')){
				$tbl 	  = 'peg_tmp_a68';
				$tbl_cs	  = 'peg_tmp_a69';
				$i38_p010 = 3;

			}elseif($mmnr01_arr[0]=='a61_d' && pegasus_module_exists('interorder')){
				$tbl 	  = 'peg_tmp_a62';
				$tbl_cs	  = 'peg_tmp_a63';
				$i38_p010 = 4;
			}

			$fields = "i00.*, ".$tbl.".nr01 as ".$tbl."_nr01, ".$tbl.".v103 as quan ";
			$joins  = "join i00 on i00.pno=".$tbl.".v101 ";
			$where  = '';
			$group  = " ".$tbl.".nr01, ";
			
			if(pegasus_module_exists('colorsize')){
				$fields .= ", ".$tbl_cs.".nr01 as ".$tbl_cs."_nr01 ";
				$joins  .= "left join ".$tbl_cs." on ".$tbl_cs.".p06=".$tbl.".v101 and ".$tbl_cs.".p01=".$tbl.".nr01 ";
				
				if($data['v_colorsize'] == 0) {
					$where  .= " and ".$tbl_cs.".nr01 is null ";
				} else {
					$group .= $tbl_cs.".p01, ";
				}
			}

			if(pegasus_module_exists('serial')){
				$fields .= ", peg_tmp_i32.nr01 as peg_tmp_i32_nr01 ";
				$joins  .= "left join peg_tmp_i32 on peg_tmp_i32.p01=".$tbl.".v101 and peg_tmp_i32.p00=".$tbl.".nr01 ";
				
				if($data['v_serial'] == 0) {
					$where  .= " and peg_tmp_i32.nr01 is null ";
				} else {
					$group .= "peg_tmp_i32.p00, ";
				}
            }

            if(pegasus_module_exists('lot')){
				$fields .= ", peg_tmp_i38.nr01 as peg_tmp_i38_nr01 ";
				$joins  .= "left join peg_tmp_i38 on peg_tmp_i38.p010=".$i38_p010." and peg_tmp_i38.p01=".$tbl.".nr01 ";
				
				if($data['v_lot'] == 0) {
					$where  .= " and peg_tmp_i38.nr01 is null ";
				} else {
					$group .= "peg_tmp_i38.p01, ";
				}
			}
		}

		$group = trim($group, ", ");

		if(!empty($group)) {
			$group = " group by ".$group." ";
		}

		$sql = '';
		if(!empty($tbl)){
			$sql  = "select ".$fields." ";
			$sql .= "from ".$tbl." ";
			$sql .= $joins;
			$sql .= "where ".$tbl.".peg_flag!=9 and ".$tbl.".peg_mmnr01=:mmnr01 and ".$tbl.".peg_sess_id=:sid ";
			$sql .= $where;  
			$sql .= $group;
			$sql .= "order by ".$tbl.".nr01";
		}
		

		/* Βρίσκει τα δεδομενα του i00 με βαση το Grid */
		$i00_tmp_data = array();		
		if(!empty($sql)) {			
			$sqlParams 		= array('mmnr01'=>$mmnr01, 'sid'=>session_id());
			$result 		= pegasus_query($sql, $sqlParams);
			$i00_tmp_data	= pegasus_fetchall($result);

			//echo pegasus_replace_values_in_sql($sql, $sqlParams);
		}
		
		/* Insert δεδομενα στον peg_tmp_colorsize_001 */
		foreach ($i00_tmp_data as $i => $tmp_data) {
			$tmp_data['i00nr01'] = $tmp_data['nr01'];
			
			for ($i=0; $i <round($tmp_data['quan']); $i++) { 
				inventory_insert_into_peg_tmp($tmp_data, 'peg_tmp_inventory_004', pegasus_mysql_newrec("peg_tmp_inventory_004"), '9', $mmnr01_arr[0]."-0");
				if(!in_array($tmp_data['ths'], array_filter($i24_p01_arr))){
					break;
				}
			}
		}


		// /* Δημιουργεί το query για το Grid */
		$sql  = "select peg_tmp_inventory_004.* ";
		$sql .= "from peg_tmp_inventory_004 ";
		$sql .= "where peg_tmp_inventory_004.peg_flag=9 and peg_tmp_inventory_004.peg_mmnr01=:mmnr01 and peg_tmp_inventory_004.peg_sess_id=:sid "; 
		$sql .= "order by peg_tmp_inventory_004.nr01;"; 
		$sqlParams = array('mmnr01'=>$mmnr01_arr[0].'-0','sid'=>session_id());
		
		return array('sql'=>$sql,'sqlParams'=>$sqlParams);
    }

	/**
	 * Εισάγει τα δεδομένα στον peg_tmp Πινακα
	 *
	 * @param array     $data		τα δεδομένα
	 * @param string    $tbl		το όνομα του πίνακα
	 * @param int       $nr01       0 ή καινούργια εγγραφή
	 * @param string    $peg_mmnr01 custom peg_mmnr01
	 * @param string    $peg_mnr01  custom peg_mnr01
	 */
	function inventory_insert_into_peg_tmp($data, $tbl='', $nr01, $peg_flag='1', $peg_mmnr01='', $peg_mnr01=''){

		if(!pegasus_mysql_table_exists($tbl)){
			return false;
		}
		
		$tbl_columns  = pegasus_mysql_show_columns($tbl);
		$exclude_flds = array('nr01','remdate','remtime','remuser','remfdate','remftime','remfuser','remguc');

		$arr1 = array();	$arr2 = array();
		foreach ($tbl_columns as $fld) {
			if(!in_array($fld, $exclude_flds) && isset($data[$fld])){
				array_push($arr1, $fld);	array_push($arr2, $data[$fld]);
			}
		}

		array_push($arr1, 'nr01');			array_push($arr2, $nr01);
		array_push($arr1, 'peg_flag');		array_push($arr2, $peg_flag);
		array_push($arr1, 'peg_sess_id');	array_push($arr2, session_id());
		array_push($arr1, 'peg_mmnr01');	array_push($arr2, $peg_mmnr01);
		array_push($arr1, 'peg_mnr01');		array_push($arr2, $peg_mnr01);
		
		// echo "<pre>". print_r($arr1,1) . "</pre>";
		// echo "<pre>". print_r($arr2,1) . "</pre>";
		
		pegasus_mysql_insert($tbl, $arr1, $arr2);
		return true;
	}

	function peg_inventory_i21_d_initialize($data,$mmnr01='',$mnr01='',$_d='',$container_id=''){
		$_this_table = 'i21';
		if($_d == $_this_table . '_d'){
			if(empty($data['nr01'])){
				$data['nr01'] = pegasus_mysql_newrec($_this_table);
				$peg_is_newrec = 1 ;
			}

			$whereTmpTbl =  ' peg_tmp_heru10.tbl_nr01= :tbl_nr01 and 
							  peg_tmp_heru10.tbl= :tbl and
							  peg_flag!=9 and
							  peg_sess_id= :sid  and
							  peg_mmnr01= :peg_mmnr01 and 
							  peg_mnr01= :peg_mnr01';

			//Dimiourgoume ola ta tmp
			pegasus_make_all_tmp_recs($_this_table , $data , $data['nr01'] , $_REQUEST['rec_copy_nr01'] , $_this_table.'_d-'.$data['nr01'] );	        

			//Dikaiomata 
			pegasusSetGlobalVar( 
				$container_id . '_where_heru10' ,  
				array( 	'sql'		=> $whereTmpTbl,
				'sqlParams' =>	array(	
					'tbl_nr01' 		=> $data['nr01'],
					'tbl' 			=> $_this_table,
					'sid' 			=> session_id(),
					'peg_mmnr01' 	=> $_this_table.'_d-'.$data['nr01'],
					'peg_mnr01' 	=> $data['nr01']
				) 
			));
		}
		
		if(!pegasus_module_exists('retail00')) {
			// Στοιχεία Retail Hidden
			$data['fset03_hidden'] = 1;
		}
		return $data;
	}
	function peg_inventory_i22_d_initialize($data,$mmnr01='',$mnr01='',$_d='',$container_id=''){
		$_this_table = 'i22';
		if($_d == $_this_table . '_d'){
			if(empty($data['nr01'])){
				$data['nr01'] = pegasus_mysql_newrec($_this_table);
				$peg_is_newrec = 1 ;
			}

			$whereTmpTbl =  ' peg_tmp_heru10.tbl_nr01= :tbl_nr01 and 
							  peg_tmp_heru10.tbl= :tbl and
							  peg_flag!=9 and
							  peg_sess_id= :sid  and
							  peg_mmnr01= :peg_mmnr01 and 
							  peg_mnr01= :peg_mnr01';

			//Dimiourgoume ola ta tmp
			pegasus_make_all_tmp_recs($_this_table , $data , $data['nr01'] , $_REQUEST['rec_copy_nr01'] , $_this_table.'_d-'.$data['nr01'] );	        

			//Dikaiomata 
			pegasusSetGlobalVar( 
				$container_id . '_where_heru10' ,  
				array( 	'sql'		=> $whereTmpTbl,
				'sqlParams' =>	array(	
					'tbl_nr01' 		=> $data['nr01'],
					'tbl' 			=> $_this_table,
					'sid' 			=> session_id(),
					'peg_mmnr01' 	=> $_this_table.'_d-'.$data['nr01'],
					'peg_mnr01' 	=> $data['nr01']
				) 
			));
		}
		
		if(!pegasus_module_exists('retail00')) {
			// Στοιχεία Retail Hidden
			$data['fset03_hidden'] = 1;
		}
		return $data;
	}
	function peg_inventory_i29_d_initialize($data,$mmnr01='',$mnr01='',$_d='',$container_id=''){
		$_this_table = 'i29';
		if($_d == $_this_table . '_d'){
			if(empty($data['nr01'])){
				$data['nr01'] = pegasus_mysql_newrec($_this_table);
				$peg_is_newrec = 1 ;
			}

			$whereTmpTbl =  ' peg_tmp_heru10.tbl_nr01= :tbl_nr01 and 
							  peg_tmp_heru10.tbl= :tbl and
							  peg_flag!=9 and
							  peg_sess_id= :sid  and
							  peg_mmnr01= :peg_mmnr01 and 
							  peg_mnr01= :peg_mnr01';

			//Dimiourgoume ola ta tmp
			pegasus_make_all_tmp_recs($_this_table , $data , $data['nr01'] , $_REQUEST['rec_copy_nr01'] , $_this_table.'_d-'.$data['nr01'] );	        

			//Dikaiomata 
			pegasusSetGlobalVar( 
				$container_id . '_where_heru10' ,  
				array( 	'sql'		=> $whereTmpTbl,
				'sqlParams' =>	array(	
					'tbl_nr01' 		=> $data['nr01'],
					'tbl' 			=> $_this_table,
					'sid' 			=> session_id(),
					'peg_mmnr01' 	=> $_this_table.'_d-'.$data['nr01'],
					'peg_mnr01' 	=> $data['nr01']
				) 
			));
		}
		
		if(!pegasus_module_exists('retail00')) {
			// Στοιχεία Retail Hidden
			$data['fset03_hidden'] = 1;
		}
		return $data;
	}
	function peg_inventory_i30_d_initialize($data,$mmnr01='',$mnr01='',$_d='',$container_id=''){
		$_this_table = 'i30';
		if($_d == $_this_table . '_d'){
			if(empty($data['nr01'])){
				$data['nr01'] = pegasus_mysql_newrec($_this_table);
				$peg_is_newrec = 1 ;
			}

			$whereTmpTbl =  ' peg_tmp_heru10.tbl_nr01= :tbl_nr01 and 
							  peg_tmp_heru10.tbl= :tbl and
							  peg_flag!=9 and
							  peg_sess_id= :sid  and
							  peg_mmnr01= :peg_mmnr01 and 
							  peg_mnr01= :peg_mnr01';

			//Dimiourgoume ola ta tmp
			pegasus_make_all_tmp_recs($_this_table , $data , $data['nr01'] , $_REQUEST['rec_copy_nr01'] , $_this_table.'_d-'.$data['nr01'] );	        

			//Dikaiomata 
			pegasusSetGlobalVar( 
				$container_id . '_where_heru10' ,  
				array( 	'sql'		=> $whereTmpTbl,
				'sqlParams' =>	array(	
					'tbl_nr01' 		=> $data['nr01'],
					'tbl' 			=> $_this_table,
					'sid' 			=> session_id(),
					'peg_mmnr01' 	=> $_this_table.'_d-'.$data['nr01'],
					'peg_mnr01' 	=> $data['nr01']
				) 
			));
		}
		
		if(!pegasus_module_exists('retail00')) {
			// Στοιχεία Retail Hidden
			$data['fset03_hidden'] = 1;
		}
		return $data;
	}


	function inventory_i00_d7_price_container_id_initialize($data,$mmnr01='',$mnr01='',$_d='',$container_id=''){
		global $PegInput;
		$PegInput->addVar(new peg_input_number('mefpa'));
		$PegInput->addVar(new peg_input_number('timh'));
		$PegInput->addVar(new peg_input_number('fpa'));
		$PegInput->addVar(new peg_input_number('timh_field'));

		$with_fpa 			= $PegInput->getRequest('mefpa');
		$timh 				= $PegInput->getRequest('timh');
		$data['timh_field'] = $PegInput->getRequest('timh_field');
	
		if($with_fpa == 0){
			$data['change_price_fpa'] 	 = $timh;
			$data['change_price_hidden'] = 1;
		}else{
			$data['change_price'] 			 = $timh;
			$data['change_price_fpa_hidden'] = 1;		
		}	
		
		return $data;
	}


	function inventory_hide_fields(){
		if(!pegasus_module_exists('retail00')){
			//Ενημέρωση του grid και property grid για το i00
			pegasus_query("UPDATE p51 
							SET desc13= 0 , 
								desc131= 0 
							WHERE  p51.p02 = 'i00_d' 
							AND desc05 IN ('ptax', 'pcf01_cl', 'pcb01_cl', 'pct01')");
			//Ενημέρωση του grid και property grid για το i21
			pegasus_query("UPDATE p51 
							SET desc13= 0 , 
								desc131= 0 
							WHERE  p51.p02 = 'i21_d' 
							AND desc05 IN ('tax', 'pcf01_cl', 'pcb01_cl', 'pct01')");
			//Ενημέρωση του grid και property grid για το i22
			pegasus_query("UPDATE p51 
							SET desc13= 0 , 
								desc131= 0 
							WHERE  p51.p02 = 'i22_d' 
							AND desc05 IN ('tax', 'pcf01_cl', 'pcb01_cl', 'pct01')");

		}else{
			//Ενημέρωση του grid και property grid για το i00
			pegasus_query("UPDATE p51
							SET desc13 = 
								CASE 
									WHEN desc05 = 'ptax' THEN 700
									WHEN desc05 = 'pcf01_cl' THEN 710
									WHEN desc05 = 'pcb01_cl' THEN 720
									WHEN desc05 = 'pct01' THEN 730
								END,
								desc131 = 
								CASE 
									WHEN desc05 = 'ptax' THEN 170
									WHEN desc05 = 'pcf01_cl' THEN 171
									WHEN desc05 = 'pcb01_cl' THEN 172
									WHEN desc05 = 'pct01' THEN 173
								END
							WHERE p02 = 'i00_d'
							AND desc05 IN ('ptax', 'pcf01_cl', 'pcb01_cl', 'pct01')");	
			//Ενημέρωση του grid και property grid για το i21		
			pegasus_query("UPDATE p51
							SET desc13 = 
								CASE 
									WHEN desc05 = 'tax' THEN 6
									WHEN desc05 = 'pcf01_cl' THEN 400
									WHEN desc05 = 'pcb01_cl' THEN 500
									WHEN desc05 = 'pct01' THEN 600
								END,
								desc131 = 
								CASE 
									WHEN desc05 = 'tax' THEN 64
									WHEN desc05 = 'pcf01_cl' THEN 66
									WHEN desc05 = 'pcb01_cl' THEN 68
									WHEN desc05 = 'pct01' THEN 70
								END
							WHERE p02 = 'i21_d'
							AND desc05 IN ('tax', 'pcf01_cl', 'pcb01_cl', 'pct01')");
			//Ενημέρωση του grid και property grid για το i22		
			pegasus_query("UPDATE p51
							SET desc13 = 
								CASE 
									WHEN desc05 = 'tax' THEN 5
									WHEN desc05 = 'pcf01_cl' THEN 25
									WHEN desc05 = 'pcb01_cl' THEN 30
									WHEN desc05 = 'pct01' THEN 35
								END,
								desc131 = 
								CASE 
									WHEN desc05 = 'tax' THEN 64
									WHEN desc05 = 'pcf01_cl' THEN 180
									WHEN desc05 = 'pcb01_cl' THEN 190
									WHEN desc05 = 'pct01' THEN 200
								END
							WHERE p02 = 'i22_d'
							AND desc05 IN ('tax', 'pcf01_cl', 'pcb01_cl', 'pct01')");
		}

		pegasusWriteSession('i00');
		pegasusWriteSession('i21');
		pegasusWriteSession('i22');

		pegasusReadSession('i00');
		pegasusReadSession('i21');
		pegasusReadSession('i22');

		pegasus_delete_directory('../../tmp/inventory/i00_d/');
		pegasus_delete_directory('../../tmp/inventory/i21_d/');
		pegasus_delete_directory('../../tmp/inventory/i22_d/');

		if (pegasus_module_exists('peg002') && function_exists('peg002_clean_dCache')) {
			peg002_clean_dCache('i00_d');
			peg002_clean_dCache('i21_d');
			peg002_clean_dCache('i22_d');
		}

	}

	function inventory_i16_d_onchange($data , $permDeny , $mmnr01 , $checkOnlyPerm){

		if(pegasus_module_exists('stores')) {
			if(!isset($data['t07p01']) || $data['t07p01'] == '') {
				array_push( $permDeny , array( 'type' => 'deny' , 'message' => $_SESSION['peg_dic_inventory_i16_empty_store']));
			}
		}else{
			$data['t07p01'] = -1;
		}

		//* Έλεγχος πεδίων διεύθυνσης
		$field_titles = [
			'p02' => ['Περιοχή', 'Area'],
			'p03' => ['Διεύθυνση', 'Address'],
			'p7'  => ['Τ.Κ', 'P.C']
		];
		
		$filled_fields = array();
		$empty_fields  = array();
		
		$filled_fields[] = !empty($data['p02']) ? $field_titles['p02'][$_SESSION['lang'] == 'GR' ? 0 : 1] : '';
		$empty_fields[]  =  empty($data['p02']) ? $field_titles['p02'][$_SESSION['lang'] == 'GR' ? 0 : 1] : '';
		
		$filled_fields[] = !empty($data['p03']) ? $field_titles['p03'][$_SESSION['lang'] == 'GR' ? 0 : 1] : '';
		$empty_fields[]  =  empty($data['p03']) ? $field_titles['p03'][$_SESSION['lang'] == 'GR' ? 0 : 1] : '';
		
		$filled_fields[] = !empty($data['p7'])  ? $field_titles['p7'][$_SESSION['lang']  == 'GR' ? 0 : 1] : '';
		$empty_fields[]  =  empty($data['p7'])  ? $field_titles['p7'][$_SESSION['lang']  == 'GR' ? 0 : 1] : '';
		
		$filled_fields = array_filter($filled_fields);
		$empty_fields  = array_filter($empty_fields);
		
		if (count($filled_fields) > 0 && count($empty_fields) > 0) {
			$filled = implode(', ', $filled_fields);
			$empty = implode(', ', $empty_fields);
			$msg = str_replace(array("##filled##", "##empty##"), array($filled, $empty), $_SESSION['peg_dic_inventory_i16_address_fields_err1']);
			array_push( $permDeny , array( 'type' => 'deny' , 'message' => $msg ));
		}


		return array($data, $permDeny);
	}

	function inventory_i16_d_initialize($data,$mmnr01,$mnr01,$_d,$container_id){

		$new_rec = 0;
		// Αρχικοποίησης Νέας Εγγραφής
		if (!($data['nr01'] > 0)) {
			$new_rec = 1;
		}

		if($new_rec == 1) {
			$data['t07p01'] = -1;
		}

		return $data;
	}

	/**
	 * timh: Τιμή βασικού τιμοκαταλόγου (χοντρική, υπερχοντρική, λιανική)
	 * p610t: Τελική τιμή αγοράς
	 */
	function inventory_calc_final_markup($timh, $p610t) {
		$final_markup = 0;

		//% Τελικά
		if(!empty($p610t) && $p610t > 0 && $timh != 0) {
			$final_markup = ($timh - $p610t) * 100 / $p610t;
		}

		return $final_markup;
	}

	/**
	 * timh: Τιμή βασικού τιμοκαταλόγου (χοντρική, υπερχοντρική, λιανική)
	 * p610t: Τελική τιμή αγοράς
	 */
	function inventory_calc_profit($timh, $p610t) {
		$p_vtim = 0;

		//% Κέρδος
		if(!empty($timh) && $timh > 0) {
			$p_vtim = ($timh - $p610t) * 100 / $timh;
		}

		return $p_vtim;
	}

	//i00_init                                                -> Υπολογίζει τα % Τελικα και % Markup
	//onchange των τιμών απο το fldset [Τιμή Αγοράς]          -> Υπολογίζει τα % Τελικα και % Markup
	//onchange του κερδους                                    -> Yπολογιζει το % Markup
	//onchange της τιμης υπερχονδρικής / χονδρικής / λιανικής -> Υπολογίζει τα % Τελικα και % Markup
	//onclick του [Υπολογισμός Τιμών Από Markup]              -> Υπολογίζει τα % Τελικα, tα % Markup και την τιμή υπερχονδρικής / χονδρικής / λιανικής

	// 1 - Υπολογισμός Τιμών Από Markup called_from "button_reculc_prices"
	// 2 - Αλλαγή Κέρδους called_from "onchange fields p_vtim2 , p_vtim3 , p_vtim4 
	// 3 - Αλλαγή Τιμής από βασικό τιμοκατάλογο (Υπερχοντρικής, Χοντρικής, Λιανικής) - "onchange fields timh2 , timh3 , timh4
	// 4 - Aλλαγή όλων των τιμών % Τελικά και % Κέρδους -  called_from i00_init ,  p610t , p611 , p611e ...

	/**
	* array $data Χρειαζόμαστε τα (p610, p611, p611e, timh2, timh3, timh4, tim2, tim3, tim4, p_vtim2, p_vtim3, p_vtim4)
	*/
	function inventory_find_prices($data, $called_from) { // inventory_reculc_prices_i00_d7
		$p610  = $data['p610'];  // Τιμή αγοράς
		$p611  = $data['p611'];  // Επιβάρυνση
		$p611e = $data['p611e']; // % Έκπτωση

		$timh2 = $data['timh2']; // Τιμή Λιανικής
		$timh3 = $data['timh3']; // Τιμή Χονδρικής
		$timh4 = $data['timh4']; // Τιμή Υπερχονδρικής

		$tim2 = $data['tim2'];   // % Λιανικής Markup
		$tim3 = $data['tim3'];   // % Χονδρικής Markup
		$tim4 = $data['tim4'];   // % Υπερχονδρικής Markup
	
		$fpa = pegasus_mysql_printfld('i13', 'p03', 'p01=?', array($data['fpa']));
	 
		$p610t = inventory_find_teliki_timh_agoras($p610, $p611e, $p611);
		$data['p610t'] = $p610t;

		if($_SESSION['f02_p640'] == 0) { 		// Τελική τιμή αγοράς
			$timh_agoras_gia_markup = $p610t;
		} else if($_SESSION['f02_p640'] == 1) { // Τιμή Αγοράς - Έκπτωση
			$timh_agoras_gia_markup = round(($p610 * ( 100-$p611e)/100), $_SESSION['f01_p07']);
		} else if($_SESSION['f02_p640'] == 2) { // Τιμή Αγοράς
			$timh_agoras_gia_markup = round($p610, $_SESSION['f01_p07']);
		} else {								// Τελική τιμή αγοράς
			$timh_agoras_gia_markup = $p610t;
		}

		$query_i23 = "select * from i23;";
		$res_i23   = pegasus_query($query_i23);
	
		while($i23 =  pegasus_fetch($res_i23)){
			if($i23['p01'] == 1){
				$data['mefpa3']  = $i23['p03_1'];
			}
			if($i23['p01'] == 2){
				$data['mefpa2']  = $i23['p03_1'];
			}
			if($i23['p01'] == 3){
				$data['mefpa4']  = $i23['p03_1'];
			}
			if($i23['p01'] == 4){
				$data['mefpa1']  = $i23['p03_1'];
			}
		}

		//Υπολογισμός Τιμών Από Markup
		if(in_array($called_from, array("bt1"))) {
			if($timh_agoras_gia_markup > 0) {
				if($tim2 != 0) {
					$timh2 = $timh_agoras_gia_markup * (100 + $tim2) / 100;
				}
	
				if($tim3 != 0) {
					$timh3 = $timh_agoras_gia_markup * (100 + $tim3) / 100;
				}
	
				if($tim4 != 0) {
					$timh4 = $timh_agoras_gia_markup * (100 + $tim4) / 100;
				}

				$timh2_nofpa = round($timh2, $_SESSION['f01_p07']);
				$timh3_nofpa = round($timh3, $_SESSION['f01_p07']);
				$timh4_nofpa = round($timh4, $_SESSION['f01_p07']);
	
				if($data['mefpa2'] == 1) {
					if($tim2 != 0){
						$timh2 = $timh2 * (100 + $fpa) / 100;
					} else {
						$timh2_nofpa = $timh2 / ((100 + $fpa) / 100);
					}
				}
				
				if($data['mefpa3'] == 1) {
					if($tim3 != 0){
						$timh3 = $timh3 * (100 + $fpa) / 100;
					} else {
						$timh3_nofpa = $timh3 / ((100 + $fpa) / 100);
					}
				}		
	
				if($data['mefpa4'] == 1) {		
					if($tim4 != 0){
						$timh4 = $timh4 * (100 + $fpa) / 100;
					} else {
						$timh4_nofpa = $timh4 / ((100 + $fpa) / 100);
					}	
				}
	
				$data['timh2'] = round($timh2, $_SESSION['f01_p07']);
				$data['timh3'] = round($timh3, $_SESSION['f01_p07']);
				$data['timh4'] = round($timh4, $_SESSION['f01_p07']);
	
				//% Κέρδος
				$data['p_vtim2'] = 0;
				$data['p_vtim3'] = 0;
				$data['p_vtim4'] = 0;
	
				//% Τελικά
				$data['p_ptim2'] = 0;
				$data['p_ptim3'] = 0;
				$data['p_ptim4'] = 0;
	
				if(!empty($data['timh2'])) {
					$data['p_vtim2'] = inventory_calc_profit($timh2_nofpa, $timh_agoras_gia_markup);       //% Κέρδος
					$data['p_ptim2'] = inventory_calc_final_markup($timh2_nofpa, $timh_agoras_gia_markup); //% Τελικά
				}
	
				if(!empty($data['timh3'])) {
					$data['p_vtim3'] = inventory_calc_profit($timh3_nofpa, $timh_agoras_gia_markup);	      //% Κέρδος
					$data['p_ptim3'] = inventory_calc_final_markup($timh3_nofpa, $timh_agoras_gia_markup); //% Τελικά
				}
	
				if(!empty($data['timh4'])) {
					$data['p_vtim4'] = inventory_calc_profit($timh4_nofpa, $timh_agoras_gia_markup);	      //% Κέρδος
					$data['p_ptim4'] = inventory_calc_final_markup($timh4_nofpa, $timh_agoras_gia_markup); //% Τελικά
				}
			}
		}	
		
		//Αλλαγή Κέρδους
		if(in_array($called_from, array("p_vtim2", "p_vtim3", "p_vtim4"))) {
			if($called_from == "p_vtim2") {
				$tim = ($timh_agoras_gia_markup * 100) / (100 - $data['p_vtim2']);          // Νέα Τιμή Λιανικής

				if($data['p_vtim2'] == 100 || $tim < 0) {
					$tim = 0;
				}

				$data['tim2'] = inventory_calc_final_markup($tim, $timh_agoras_gia_markup); // Τιμή % Markup Λιανικής
			} else if($called_from == "p_vtim3") {
				$tim = ($timh_agoras_gia_markup * 100) / (100 - $data['p_vtim3']);          // Νέα Τιμή Χοντρικής

				if($data['p_vtim3'] == 100 || $tim < 0) {
					$tim = 0;
				}

				$data['tim3'] = inventory_calc_final_markup($tim, $timh_agoras_gia_markup); // Τιμή % Markup Χοντρικής
			} else {
				$tim = ($timh_agoras_gia_markup * 100) / (100 - $data['p_vtim4']);          // Νέα Τιμή Υπερχοντρικής

				if($data['p_vtim4'] == 100 || $tim < 0) {
					$tim = 0;
				}
				
				$data['tim4'] = inventory_calc_final_markup($tim, $timh_agoras_gia_markup); // Τιμή % Markup Υπερχοντρικής
			}
		}

		//Αλλαγή Τιμής από βασικό τιμοκατάλογο (Υπερχοντρικής, Χοντρικής, Λιανικής)
		if(in_array($called_from, array("timh2", "timh3", "timh4"))) {
			if($called_from == "timh2") {
				if($data['mefpa2'] == 1) {
					$timh2 = $timh2 / ((100 + $fpa) / 100);						// Τιμή Λιανικής Με ΦΠΑ
				}

				$timh2 = round($timh2, $_SESSION['f01_p07']);

				$data['p_ptim2'] = inventory_calc_final_markup($timh2, $timh_agoras_gia_markup); // Τελικά Λιανικής
				$data['p_vtim2'] = inventory_calc_profit($timh2, $timh_agoras_gia_markup);	    // Κέρδος Λιανικής
			} else if($called_from == "timh3") {
				if($data['mefpa3'] == 1) {
					$timh3 = $timh3 / ((100 + $fpa) / 100);						// Τιμή Χοντρικής Με ΦΠΑ
				}

				$timh3 = round($timh3, $_SESSION['f01_p07']);

				$data['p_ptim3'] = inventory_calc_final_markup($timh3, $timh_agoras_gia_markup); // Τελικά Χοντρικής
				$data['p_vtim3'] = inventory_calc_profit($timh3, $timh_agoras_gia_markup);	    // Κέρδος Χοντρικής
			} else {
				if($data['mefpa4'] == 1) {
					$timh4 = $timh4 / ((100 + $fpa) / 100);						// Τιμή Υπερχοντρικής Με ΦΠΑ
				}

				$timh4 = round($timh4, $_SESSION['f01_p07']);

				$data['p_ptim4'] = inventory_calc_final_markup($timh4, $timh_agoras_gia_markup); // Τελικά Υπερχοντρικής
				$data['p_vtim4'] = inventory_calc_profit($timh4, $timh_agoras_gia_markup);	    // Κέρδος Υπερχοντρικής
			}	
		}

		//Αλλαγή όλων των τιμών % Τελικά και % Κέρδους
		if(in_array($called_from, array("p610", "p611e", "p611", "i00_init"))) {
			if($data['mefpa2'] == 1) {
				$timh2 = $timh2 / ((100 + $fpa) / 100);								// Τιμή Λιανικής Με ΦΠΑ
			}

			if($data['mefpa3'] == 1) {
				$timh3 = $timh3 / ((100 + $fpa) / 100);								// Τιμή Χοντρικής Με ΦΠΑ
			}

			if($data['mefpa4'] == 1) {
				$timh4 = $timh4 / ((100 + $fpa) / 100);								// Τιμή Υπερχοντρικής Με ΦΠΑ
			}

			$timh2 = round($timh2, $_SESSION['f01_p07']);
			$timh3 = round($timh3, $_SESSION['f01_p07']);
			$timh4 = round($timh4, $_SESSION['f01_p07']);

			$data['p_ptim2'] = inventory_calc_final_markup($timh2, $timh_agoras_gia_markup); // Τελικά Λιανικής
			$data['p_vtim2'] = inventory_calc_profit($timh2, $timh_agoras_gia_markup);       // Κέρδος Λιανικής
	
			$data['p_ptim3'] = inventory_calc_final_markup($timh3, $timh_agoras_gia_markup); // Τελικά Χοντρικής
			$data['p_vtim3'] = inventory_calc_profit($timh3, $timh_agoras_gia_markup);       // Κέρδος Χοντρικής
	
			$data['p_ptim4'] = inventory_calc_final_markup($timh4, $timh_agoras_gia_markup); // Τελικά Υπερχοντρικής
			$data['p_vtim4'] = inventory_calc_profit($timh4, $timh_agoras_gia_markup);       // Κέρδος Υπερχοντρικής
		}
	
		return $data;
	}

	function inventory_i00_color_query(){
		$sql = "SELECT	t_p51.*
					FROM (
							SELECT 
								'i00_d' AS p02,
                               'inventory' AS module,
                               'v_i47_p02' AS desc05,
                               '884' AS desc06,
                               '0' AS desc08,
                               'C' AS desc16,
                               '14' AS desc17,
                               '5' AS desc18,
                               'comboboxV2' AS desc07,
                               '' AS desc14,
                               -1  AS nr01,
                               'Κωδικός χρώματος' AS desc02,
                               '0' AS desc13,
                               '216' AS desc131,
                               '0' AS desc99,
                               '0' AS desc98,
                               'Color' AS edesc02,
                               '0' AS desc132
					UNION 
					SELECT 
								'i00_d' AS p02,
                               'inventory' AS module,
                               'v_i47_p02_desc' AS desc05,
                               '885' AS desc06,
                               '0' AS desc08,
                               'C' AS desc16,
                               '14' AS desc17,
                               '5' AS desc18,
                               'comboboxV2' AS desc07,
                               '' AS desc14,
                               -2  AS nr01,
                               'Περιγραφή χρώματος' AS desc02,
                               '0' AS desc13,
                               '217' AS desc131,
                               '0' AS desc99,
                               '0' AS desc98,
                               'Color' AS edesc02,
                               '0' AS desc132
					UNION 
					SELECT 
							   'i00_d' AS p02,
                               'inventory' AS module,
                               'v_i47_p03' AS desc05,
                               '886' AS desc06,
                               '0' AS desc08,
                               'C' AS desc16,
                               '14' AS desc17,
                               '5' AS desc18,
                               'comboboxV2' AS desc07,
                               '' AS desc14,
                               -3  AS nr01,
                               'Κωδικός μεγέθους' AS desc02,
                               '0' AS desc13,
                               '218' AS desc131,
                               '0' AS desc99,
                               '0' AS desc98,
                               'Size' AS edesc02,
                               '0' AS desc132
					UNION 
					SELECT 
							   'i00_d' AS p02,
                               'inventory' AS module,
                               'v_i47_p03_desc' AS desc05,
                               '887' AS desc06,
                               '0' AS desc08,
                               'C' AS desc16,
                               '14' AS desc17,
                               '5' AS desc18,
                               'comboboxV2' AS desc07,
                               '' AS desc14,
                               -4  AS nr01,
                               'Περιγραφή μεγέθους' AS desc02,
                               '0' AS desc13,
                               '219' AS desc131,
                               '0' AS desc99,
                               '0' AS desc98,
                               'Size' AS edesc02,
                               '0' AS desc132
					UNION 
					SELECT 
							   'i00_d' AS p02,
                               'inventory' AS module,
                               'v_i47_p04' AS desc05,
                               '888' AS desc06,
                               '0' AS desc08,
                               'C' AS desc16,
                               '14' AS desc17,
                               '5' AS desc18,
                               'comboboxV2' AS desc07,
                               '' AS desc14,
                               -5  AS nr01,
                               'Barcode' AS desc02,
                               '0' AS desc13,
                               '220' AS desc131,
                               '0' AS desc99,
                               '0' AS desc98,
                               'Barcode' AS edesc02,
                               '0' AS desc132
							   UNION 
					SELECT 
							   'i00_d' AS p02,
                               'inventory' AS module,
                               'v_i47_p05' AS desc05,
                               '889' AS desc06,
                               '0' AS desc08,
                               'C' AS desc16,
                               '14' AS desc17,
                               '5' AS desc18,
                               'comboboxV2' AS desc07,
                               '' AS desc14,
                               -6  AS nr01,
                               '2ο Barcode' AS desc02,
                               '0' AS desc13,
                               '221' AS desc131,
                               '0' AS desc99,
                               '0' AS desc98,
                               '2nd Barcode' AS edesc02,
                               '0' AS desc132
					UNION
					(
						SELECT
							 p02,
							 module,
							 desc05,
							 desc06,
							 desc08,
							 desc16,
							 desc17,
							 desc18,
							 desc07,
							 desc14,
							 nr01,
							 desc02,
							 desc13,
							 desc131,
							 desc99,
							 desc98,
							 edesc02,
							 desc132
						FROM p51
					)
			) AS t_p51
				 
		";

	return array(
		'sql' => $sql,
		'sqlParams' => array()
	);
	}