<?php
    class inventory_pegapi_actions extends pegapi_RestObject {

        protected $_d;
        protected $module;
        
        public function __construct($method, $request=null, $file=null){
            parent::__construct($method, $request, $file);

            $this->module = 'inventory';
        }
        

        /**
         * Αναζήτηση Ειδών στα πεδία
         * Περιγραφη
         * Κωδικός
         * Barcode
         * Ειδικοί κωδικοί
         * Aντιστοιχία
         */
        public function search(){

            $this->_d = 'i00_d';
            
            if($this->isLoggedIn()===false){
                throw new PegApi00Exception('Unauthorized', 401, null, 401, 'Unauthorized', 'Unauthorized');
            }
            
            if($this->method=='GET'){

                $data   = array();
                $fields = self::_get_fields_from_table($this->module, $this->_d);              

                //echo "<pre>". print_r($fields,1) . "</pre>";

                if(!empty(trim($this->request['query']))){

                    $where  = "i00.pno   like :query_like or ";     //Κωδικός    
                    $where .= "i00.name  like :query_like or ";     //Περιγραφη   
                    $where .= "i00.ename like :query_like or ";      
                    $where .= "i00.p01   like :query_like or ";     //Barcode    
                    $where .= "i00.p9001 like :query_like or ";     //Aντιστοιχία     

                    if(pegasus_module_exists("invspcodes")) {
                        $where .= "i08.pe02  like :query_like or ";     //Ειδικοί κωδικοί   
                    }
                    
                    $where .= "1=0 "; 
                
                    $query  = " select i00.* ";
                    $query .= " from i00 ";
                    if(pegasus_module_exists("invspcodes")) {
                        $query .= " left join i08 on i08.pe01=i00.pno ";
                    }
                    $query .= " where " . $where;
                    $query .= " group by i00.pno ";
                    $query .= " order by i00.pno, i00.nr01;";

                    
                    //echo pegasus_replace_values_in_sql($query, array('query_like'=>"%".trim($this->request['query'])."%"));
                    $res_query = pegasus_query($query, array('query_like'=>"%".trim($this->request['query'])."%"));

                    while($i00=pegasus_fetch_assoc($res_query)){
                        $data[] = static::validateData_static($i00, $fields);				
                    }
                }
                 
                $this->totalrec = count($data) ;
                if($this->totalrec<1){
                    throw new PegApiException('No Content', 290, null, 290);
                }
                
                
                return array(
                        'status'	=> 200,
                        'code'		=> 200,
                        'data'		=> $data
                );
                    
            }else{
                throw new PegApi00Exception('Method Not allowed', 400, null, 400, 'Method Not allowed', 'Only GET method available');
            }
        }


        /**
         * Υπολογισμός Τιμής Είδους
         */
        public function find_price(){

            $this->_d = 'i00_d';
            
            if($this->isLoggedIn()===false){
                throw new PegApi00Exception('Unauthorized', 401, null, 401, 'Unauthorized', 'Unauthorized');
            }
            
            if($this->method=='GET'){

                $data = array();
                
                $quan = 1;
                $a01nr01 = $this->request['a01nr01'];

                $preview_wthfpa = $_SESSION['f02_p06'];
                pegasus_mysql_use("select * from a01 where nr01=? ", $a01, array($a01nr01) );
                $a01_p48 = $a01['p48'];	
                if(empty($a01_p48)){
                    $a01_p48 = $_SESSION['customers_000_p02'];
                }
                if(empty($a01_p48)){
                    $a01_p48 = 2;
                }
                //Timokatalogos
                if($a01_p48>0){
                    pegasus_mysql_use( ' select * from i23 where p01=? ' , $i23 , array($a01_p48) );
                    $preview_wthfpa = $i23['p05'];
                }
                //Eidikos Timokatalogos
                if($a01['p06']>0){
                    pegasus_mysql_use( ' select * from i14 where p01=? ' , $i14 ,array($a01['p06']));
                    $preview_wthfpa = $i14['p05'];
                }		

             

                $price_arr = inventory_find_price($this->request['i00pno'], $this->request['a01nr01'], $quan, '', 0, 'a01', $preview_wthfpa);
                
                $data = $price_arr;
                
                return array(
                        'status'	=> 200,
                        'code'		=> 200,
                        'data'		=> $data
                );
                    
            }else{
                throw new PegApi00Exception('Method Not allowed', 400, null, 400, 'Method Not allowed', 'Only GET method available');
            }

        }
        

        //toDo: Θα μπορουσαμε να το εισαγουμε σαν μεθοδο στην μαμά κλαση "pegapi_RestObject"
        protected static function _get_fields_from_table($module='', $_d=''){

            $fields = array();
            
            $query_p51  = " select ";
            $query_p51 .= " p51.desc05 as fld, p51.desc16 as tp, desc17 as fldsz, desc18 as flddec ";
            $query_p51 .= " from p51 ";
            $query_p51 .= " join p61 on p51.desc07=p61.p00 and p61.isdbfld=1 ";
            $query_p51 .= " where ";
            $query_p51 .= " p51.desc16!='' and p51.desc16!='V' and  p51.desc16!='' and p51.p02=:_d and p51.module=:module ";
            $query_p51 .= " order by case when desc13>0 then 0 else 1 end asc, desc13, desc06; ";
                
            $res_p51    = pegasus_query($query_p51, array('_d'=>$_d, 'module'=>$module));

            while($p51 = pegasus_fetch($res_p51)){
                $fields[$p51['fld']] = array('fld'=>$p51['fld'], 'tp'=>$p51['tp'], 'fldsz'=>$p51['fldsz'],  'flddec'=>$p51['flddec']);			
            }

            return $fields;
        }
    }