<?php
   //There is no need to be Deleted!
   class invoices_copy {
		// Βλέπουμε αν πρόκειται για τιμολόγηση παραγγελίας ή για αντιγραφή 
		private $invoice_get_total_quantity;
		private $invoice_get_main_i18_product_nr01;

		function __construct() {
			$this->invoice_get_total_quantity = 0;
			$this->invoice_get_main_i18_product_nr01 = 0;
		}

		public function set_is_invoicing($invoice_get_total_quantity) {
			$this->invoice_get_total_quantity = $invoice_get_total_quantity;
		}
		
		private function get_invoice_get_total_quantity() {
			return $this->invoice_get_total_quantity;
		}

		public function set_invoice_get_main_i18_product_nr01($add_to_array) {			
			$i18_array = $this->get_invoice_get_main_i18_product_nr01();
			
			foreach($add_to_array as $key=>$value) {
				$i18_array[$key] = $value;
			}

			$this->invoice_get_main_i18_product_nr01 = $i18_array;
		}
		
		private function get_invoice_get_main_i18_product_nr01() {
			return empty($this->invoice_get_main_i18_product_nr01) ? array() : $this->invoice_get_main_i18_product_nr01;
		}

		private function _invoice_data($data, $from_tbl, $from_nr01, $to_tbl) {
			$res_from_tbl = array();

			$query_from_tbl = "SELECT * FROM $from_tbl WHERE nr01=:from_nr01";
			$query_params_from_tbl = array(
				"from_nr01" => $from_nr01
			);

			pegasus_mysql_use($query_from_tbl, $res_from_tbl, $query_params_from_tbl);

			if(
				(in_array($from_tbl, array("a55", "a57", "a56", "a67")) && in_array($to_tbl, array("a60", "a61"))) ||
				(in_array($from_tbl, array("a60", "a61")) && in_array($to_tbl, array("a55", "a57", "a56", "a67")))
			) {
				$data['p0121'] = $res_from_tbl['p0121'];
				$data['p30']   = $res_from_tbl['p30'];

				return $data;
			}

			if(
				($from_tbl == 'a60' && $to_tbl == 'a61') ||
				($from_tbl == 'a61' && $to_tbl == 'a60') 
			) {
				$data['p03']   = $res_from_tbl['p03'];
				$data['p04']   = $res_from_tbl['p04'];
				$data['p05']   = $res_from_tbl['p05'];
				$data['p010']  = $res_from_tbl['p010'];
				$data['p011']  = $res_from_tbl['p011'];
				$data['p012']  = $res_from_tbl['p012'];
				$data['p702']  = $res_from_tbl['p702'];
				$data['p0121'] = $res_from_tbl['p0121'];
				$data['p30']   = $res_from_tbl['p30'];

				if(($from_tbl == 'a61' && $to_tbl == 'a60') ) {
					pegasus_mysql_use("SELECT p202 FROM a30 WHERE p01=?", $a30, array($data['p05']));

					$data['p08'] = $a30['p202'];
				}

				return $data;
			}
			
			if(
				($from_tbl == 'a55' && $to_tbl == 'a57') ||
				($from_tbl == 'a57' && $to_tbl == 'a55') ||
			    ($from_tbl == 'a56' && $to_tbl == 'a67') ||
			    ($from_tbl == 'a67' && $to_tbl == 'a56')
			) {
				$p03  = $res_from_tbl['p03'];
				$p04  = $res_from_tbl['p04'];
				$p05  = $res_from_tbl['p05'];
				$p015 = $res_from_tbl['p015'];
				$p010 = $res_from_tbl['p010'];
			} else {
				$p03  = 0;
				$p04  = 0;
				$p05  = 0;
				$p015 = 0;
				$p010 = '';
			}

			if($to_tbl == "a57") {
				$data['p590'] = $_SESSION['f02_p601'];
			} else if($to_tbl == "a67") {
				$data['p590'] = $_SESSION['f02_ap601'];
			}

			if(
				(
					($from_tbl == 'a57' && $to_tbl == 'a55') ||
					($from_tbl == 'a55' && $to_tbl == 'a57')
				) && 
				pegasus_module_exists('b2g')
			){
				pegasus_mysql_use("SELECT * FROM b2g01 WHERE tbl = :from_tbl AND tbl_nr01 = :tbl_nr01", $b2g01, array("from_tbl"=>$from_tbl, "tbl_nr01" => $res_from_tbl['nr01']));
                if($b2g01['is_b2g'] == 1){
					$data['v_b2g01_is_b2g']     = $b2g01['is_b2g'];
					$data['v_b2g01_prjref']     = $b2g01['prjref'];
					$data['v_b2g01_buyerref']   = $b2g01['buyerref'];
					$data['v_b2g01_buyerid']    = $b2g01['buyerid'];
					$data['v_b2g01_contrref']   = $b2g01['contrref'];
					$data['v_b2g01_orderref']   = $b2g01['orderref'];
				}
			}
			/**
			 * E:10001831
			 * Αρχικοποίηση πεδίων einv20
			 */
			if(
				(
					($from_tbl == 'a57' && $to_tbl == 'a55') ||
					($from_tbl == 'a55' && $to_tbl == 'a57')
				) && 
				pegasus_module_exists('einv')
			){
				$einv20 = array();
				pegasus_mysql_use("SELECT * FROM einv20 WHERE tbl = :from_tbl AND tbl_nr01 = :tbl_nr01", $einv20, array("from_tbl"=>$from_tbl, "tbl_nr01" => $res_from_tbl['nr01']));
                $data['v_einv20_payterm']   = empty($einv20['payterm']) ? '' : $einv20['payterm'];
				$data['v_einv20_invnotescode'] = empty($einv20['invnotescode']) ? '' : $einv20['invnotescode'];
				$data['v_einv20_invnote']  = empty($einv20['invnote']) ? '' : $einv20['invnote'];
			}

			$data['p03'] 	 = $p03;	    				// Πελάτης/Προμηθευτής
            $data['p04'] 	 = $p04;	    				// Υποκατάστημα
            $data['p05'] 	 = $p05;	    				// Παραστατικό
            $data['p07'] 	 = $res_from_tbl['p07'];	    // Τιμές Με ΦΠΑ
            $data['p09'] 	 = $res_from_tbl['p09'];	    // Κωδ.Καθεστώτος ΦΠΑ
			$data['p010']	 = $p010;	    				// Αιτιολογία
            $data['p011'] 	 = $res_from_tbl['p011'];	    // Παρατηρήσεις
            $data['p012'] 	 = $res_from_tbl['p012'];	    // Σκοπός Διακίνησης
            $data['p013'] 	 = $res_from_tbl['p013'];	    // Από
            $data['p014'] 	 = $res_from_tbl['p014'];	    // Πρός
            $data['p015'] 	 = $p015;	    				// Είσπραξη
            $data['p016'] 	 = $res_from_tbl['p016'];	    // Κωδικός Πωλητή
            $data['p017'] 	 = $res_from_tbl['p017'];	    // Κωδ.Τρόπου Μεταφοράς

            $data['p0101'] 	 = $res_from_tbl['p0101'];	    // % Εκπτωσης  στο σύνολο
            $data['p0102'] 	 = $res_from_tbl['p0102'];	    // Έκπτωση (Ποσό προ ΦΠΑ)
            $data['p0105'] 	 = $res_from_tbl['p0105'];	    // Φ.Π.Α.
            $data['p0108'] 	 = $res_from_tbl['p0108'];	    // Επιβαρύνσεις
            $data['p0112'] 	 = $res_from_tbl['p0112'];	    // %Κράτησης
            $data['p0113'] 	 = $res_from_tbl['p0113'];	    // % Φόρου
            $data['p0110'] 	 = $res_from_tbl['p0110'];	    // Ποσό Είσπραξης (Αντικαταβολή)

   			$data['p702'] 	 = $res_from_tbl['p702'];	    // Αρ.Κυκλοφορίας
            $data['p703']  	 = $res_from_tbl['p703'];	    // Κωδ.Αποθήκης
            $data['p704']  	 = $res_from_tbl['p704'];	    // Δεν Ενημερώνει Πόντους
            $data['p705']  	 = $res_from_tbl['p705'];	    // Όχημα Πελάτη
            $data['p706c']   = $res_from_tbl['p706c'];		// Διάταξη Απαλλαγής ΦΠΑ
            $data['p707'] 	 = $res_from_tbl['p707'];	    // Αριθμός Φορολογικής Κάρτας

			$data['p807'] 	 = $res_from_tbl['p807'];	    // Αναστολή Καταβολής ΦΠΑ

            $data['p0102_1'] = $res_from_tbl['p0102_1'];	// Έκπτωση προ ΦΠΑ από Χρήστη
            $data['p0102_2'] = $res_from_tbl['p0102_2'];	// Έκπτωση στο σύνολο
			$data['p0109_1'] = $res_from_tbl['p0109_1'];	// Αλλαγή Συνόλου
    		$data['p0010'] 	 = $res_from_tbl['p0010'];	    // 
			$data['p0121'] 	 = $res_from_tbl['p0121'];      // Κατάστημα

			$data['pn01']  	 = $res_from_tbl['pn01'];	    // Κωδ.Ξένου Νομίσματος
            $data['pn02']  	 = $res_from_tbl['pn02']; 	    // Ισοτιμία Νομίσματος
            $data['p30']   	 = $res_from_tbl['p30'];		// Σημειώσεις

			$data['p401'] 	 = $res_from_tbl['p401'];	    // Λεκτικό 1
            $data['p402'] 	 = $res_from_tbl['p402'];	    // Λεκτικό 2
            $data['p403'] 	 = $res_from_tbl['p403'];	    // Λεκτικό 3
            $data['p404'] 	 = $res_from_tbl['p404'];	    // Λεκτικό 4
            $data['p405'] 	 = $res_from_tbl['p405'];	    // Λεκτικό 5
            $data['p406'] 	 = $res_from_tbl['p406'];	    // Λεκτικό 6
            $data['p407'] 	 = $res_from_tbl['p407'];	    // Λεκτικό 7
            $data['p408'] 	 = $res_from_tbl['p408'];	    // Λεκτικό 8
            $data['p409'] 	 = $res_from_tbl['p409'];	    // Λεκτικό 9
            //$data['p410'] 	 = $res_from_tbl['p410'];	// Τα σύνολα Δεν υπολογίζονται αυτόματα
			$data['p415'] 	 = $res_from_tbl['p415'];	    // Κωδ.Καταστήματος Από
			$data['p416'] 	 = $res_from_tbl['p416'];	    // Κωδ.Καταστήματος Εώς

            $data['p201'] 	 = $res_from_tbl['p201'];	    // Καθαρά 1
            $data['p202'] 	 = $res_from_tbl['p202'];	    // Καθαρά 2
            $data['p203'] 	 = $res_from_tbl['p203'];	    // Καθαρά 3
            $data['p204']  	 = $res_from_tbl['p204'];	    // Καθαρά 4
            $data['p205'] 	 = $res_from_tbl['p205'];	    // Καθαρά 5
            $data['p206'] 	 = $res_from_tbl['p206'];	    // Καθαρά 6
            $data['p207'] 	 = $res_from_tbl['p207'];	    // Καθαρά 7
            $data['p208'] 	 = $res_from_tbl['p208'];	    // Καθαρά 8
            $data['p209'] 	 = $res_from_tbl['p209'];	    // Καθαρά 9

            $data['p301'] 	 = $res_from_tbl['p301'];	    // ΦΠΑ 1
            $data['p302'] 	 = $res_from_tbl['p302'];	    // ΦΠΑ 2
            $data['p303'] 	 = $res_from_tbl['p303'];	    // ΦΠΑ 3
            $data['p304'] 	 = $res_from_tbl['p304'];	    // ΦΠΑ 4
            $data['p305'] 	 = $res_from_tbl['p305'];	    // ΦΠΑ 5
            $data['p306'] 	 = $res_from_tbl['p306'];	    // ΦΠΑ 6
            $data['p307'] 	 = $res_from_tbl['p307'];	    // ΦΠΑ 7
            $data['p308'] 	 = $res_from_tbl['p308'];	    // ΦΠΑ 8
            $data['p309'] 	 = $res_from_tbl['p309'];	    // ΦΠΑ 9

            $data['p501']  	 = $res_from_tbl['p501'];	    // Κωδ.Αποστολέα (CRM)
            $data['p502']  	 = $res_from_tbl['p502'];	    // Κωδ.Παραλήπτη (CRM)
            $data['p503']    = $res_from_tbl['p503'];	    // Κωδικός Εργου
            $data['p504']  	 = $res_from_tbl['p504'];	    // Κωδικός Εργασίας
            $data['p505']  	 = $res_from_tbl['p505'];	    // Κωδ.Σύμβασης
			$data['p506'] 	 = $res_from_tbl['p506'];	    // Μ.Κ.Δωροεπιταγής
            $data['p507'] 	 = $res_from_tbl['p507'];	    // Ποσό Ενός Πόντου

            return $data;
		}

		private function _invoice_products($from_tbl, $from_nr01= array(), $to_tbl, $to_nr01, $append_mnr01) {
			$mmnr01 = $to_tbl.'_d-'.$to_nr01;

			// Σε ποια περίπτωση αντιγραφής βρισκόμαστε
			if(in_array($from_tbl, array("a55", "a56", "a60")) && in_array($to_tbl, array("a57", "a67", "a61"))) {
				$is_invoice_to_order = 1;
			} else if(in_array($from_tbl, array("a55", "a56", "a60")) && in_array($to_tbl, array("a55", "a56", "a60"))) {
				$is_invoice_to_invoice = 1;
			} else if(in_array($from_tbl, array("a57", "a67", "a61")) && in_array($to_tbl, array("a55", "a56", "a60"))) {
				$is_order_to_invoice = 1;
			} else if(in_array($from_tbl, array("a57", "a67", "a61")) && in_array($to_tbl, array("a57", "a67", "a61"))) {
				$is_order_to_order = 1;
			}

			// Από ποιον πίνακα θα γίνει η αντιγραφή των ειδών και ποιο είναι το [M.K. Σχετικής Κίνησης]
			if(in_array($from_tbl, array("a55", "a56", "a60"))) {
				$from_product_tbl	= 'i01';
				$prefix = 'p06';
			} else if($from_tbl == "a57") {
				$from_product_tbl	= 'a58';
				$prefix = 'p00';
			} else if($from_tbl == "a67") {
				$from_product_tbl	= 'a68';
				$prefix = 'p00';
			} else if($from_tbl == "a61") {
				$from_product_tbl	= 'a62';
				$prefix = 'p00';
			}

			// Σε ποιον πίνακα θα γίνει η αντιγραφή των ειδών
			if(in_array($to_tbl, array("a55", "a56", "a60"))) {
				$to_product_tbl	= 'i01';
			} else if($to_tbl == "a57") {
				$to_product_tbl	= 'a58';
			} else if($to_tbl == "a67") {
				$to_product_tbl	= 'a68';
			} else if($to_tbl == "a61") {
				$to_product_tbl	= 'a62';
			}

			if(in_array($from_tbl, array("a57", "a67", "a61"))) {
				if($this->get_invoice_get_total_quantity() == 0) {
					$condition	= ' AND v103 > v109 ORDER BY p00, vd100 ';
				} else {
					$condition	= ' ORDER BY p00, vd100 ';
				}
			} else if($from_tbl == "a55") {
				$condition	= ' AND p07 = 2 ';
			} else if($from_tbl == "a56") {
				$condition	= ' AND p07 = 1 ';
			} else if($from_tbl == "a60") {
				$condition	= ' AND p07 = 3 AND (ppnr01 = 0 OR ppnr01 = nr01)';
			}

			if(is_array($append_mnr01) && count($append_mnr01) > 0) {
				$from_nr01 = array_merge($from_nr01, $append_mnr01);
			}

			$in = pegasus_mysql_create_in($from_nr01, $prefix);
			$query_product_tbl = "SELECT * FROM $from_product_tbl WHERE $prefix IN (".$in['sql'].") $condition";
			$res_tbl = pegasus_query($query_product_tbl, $in['sqlParams']);

			while($res = pegasus_fetch($res_tbl)) {
				$tbl_nr01 =  pegasus_mysql_newrec($to_product_tbl);

				if($is_order_to_invoice == 1) {
					$this->_invoice_products_order_2_inv($res, $from_tbl, $to_tbl, $from_product_tbl, $to_product_tbl, $tbl_nr01, $mmnr01);
				} else if($is_invoice_to_order == 1) {
					$this->_invoice_products_inv_2_order($res, $from_tbl, $from_product_tbl, $to_product_tbl, $tbl_nr01, $mmnr01);
				} else if($is_invoice_to_invoice == 1) {
					$this->_invoice_products_inv_2_inv($res, $from_tbl, $to_tbl, $to_product_tbl, $tbl_nr01, $mmnr01);
				} else if($is_order_to_order == 1) {
					$this->_invoice_products_order_2_order($res, $from_tbl, $from_product_tbl, $to_product_tbl, $tbl_nr01, $mmnr01);
				}

				$from_product_nr01 =  $res['nr01'];
				$to_product_nr01 = $tbl_nr01;

				$this->_invoice_products_a90($from_product_tbl, $from_product_nr01, $to_product_tbl, $to_product_nr01, $mmnr01);
	
				$this->_invoice_products_serial($from_product_tbl, $from_product_nr01, $to_product_tbl, $to_product_nr01, $mmnr01);
	
				$this->_invoice_products_lots($from_product_tbl, $from_product_nr01, $to_product_tbl, $to_product_nr01, $mmnr01);

				$this->_invoice_products_colorsize($from_product_tbl, $from_product_nr01, $to_tbl, $to_product_nr01, $mmnr01);
			}

			$this->_invoice_products_i71($from_tbl, $from_nr01, $to_tbl, $to_nr01, $mmnr01);
      	}

		private function _invoice_products_order_2_order($res, $from_tbl, $from_product_tbl, $to_product_tbl, $to_product_nr01, $mmnr01) {
			$to_nr01 	 = substr($mmnr01, 6);
			$peg_tmp_tbl = "peg_tmp_".$to_product_tbl;

			$arr1 = array();				        $arr2 = array();

			array_push($arr1, 'peg_mnr01');			array_push($arr2, $to_nr01);
			array_push($arr1, 'peg_mmnr01');		array_push($arr2, $mmnr01);
			array_push($arr1, 'peg_sess_id');		array_push($arr2, session_id());
			array_push($arr1, 'peg_flag');			array_push($arr2, '1');
			array_push($arr1, 'nr01');				array_push($arr2, $to_product_nr01);

			//Δεν υπήρχε το ΜΚ Παραγγελίας
			array_push($arr1, 'p00');				array_push($arr2, $to_nr01);

			array_push($arr1, 'v103');				array_push($arr2, $res['v103']);  // Ποσοτητα 
			array_push($arr1, 'v301');				array_push($arr2, $res['v301']);  // Τεμαχια

			array_push($arr1, 'v101');				array_push($arr2, $res['v101']);  // Κωδικός είδους
			array_push($arr1, 'v102');				array_push($arr2, $res['v102']);  // Περιγραφή είδος
			array_push($arr1, 'v108');				array_push($arr2, $res['v108']);  // Κατηγορία ΦΠΑ
			array_push($arr1, 'v107');				array_push($arr2, $res['v107']);  // Σύνολο
			array_push($arr1, 'v105');				array_push($arr2, $res['v105']);  // Ποσοστό ΦΠΑ
			array_push($arr1, 'v104');				array_push($arr2, $res['v104']);  // Τιμή Μονάδας
			array_push($arr1, 'v120');				array_push($arr2, $res['v120']);  // Δευτ.τιμη μοναδα
			array_push($arr1, 'v1041');				array_push($arr2, $res['v1041']); // Εισφορά Ανακύκλωσης Ανά Μονάδα (χωρίς ΦΠΑ)
			array_push($arr1, 'v1042');				array_push($arr2, $res['v1042']); // Επιπλέον Αξία
			array_push($arr1, 'v106');				array_push($arr2, $res['v106']);  // Εκπτωση 1
			array_push($arr1, 'v106a');				array_push($arr2, $res['v106a']); // Εκπτωση 2
			array_push($arr1, 'v616');				array_push($arr2, $res['v616']);  // Ε.Φ.Κ. Ανά Μονάδα Χωρίς ΦΠΑ
			array_push($arr1, 'v1030_1');			array_push($arr2, $res['v1030_1']);// Ποσότητα Συσκευασίας
			array_push($arr1, 'v104_1');			array_push($arr2, $res['v104_1']);// Τιμή Συσκευασίας
			array_push($arr1, 'v160');				array_push($arr2, $res['v160']);  // Αιτιολογία
			array_push($arr1, 'timh1');				array_push($arr2, $res['timh1']); // Τιμ κοστους ? ισως πρεπει να τα διαζουμε απο το ειδος οτνα αντιγραφο απο παραστατικό σε παραγγελία
			array_push($arr1, 'timh2');				array_push($arr2, $res['timh2']); // Τιμη υπερχοντρικη ? -''-
			array_push($arr1, 'timh3');				array_push($arr2, $res['timh3']); // Τιμη χοντρικη? -''-
			array_push($arr1, 'timh4');				array_push($arr2, $res['timh4']); // Τιμη λαινικης? -''-
			
			array_push($arr1, 'v302');				array_push($arr2, $res['v302']);  // Επιλ. Μ.Μ
			array_push($arr1, 'v303');				array_push($arr2, $res['v303']);  // Επιλ. Μ.Μ
			array_push($arr1, 'v304');				array_push($arr2, $res['v304']);  // Επιλ. Μ.Μ
			array_push($arr1, 'v306');				array_push($arr2, $res['v306']);  // Επιλ. Μ.Μ
			array_push($arr1, 'v307');				array_push($arr2, $res['v307']);  // Επιλ. Μ.Μ
			array_push($arr1, 'v308');				array_push($arr2, $res['v308']);  // Επιλ. Μ.Μ
			array_push($arr1, 'v309');				array_push($arr2, $res['v309']);  // Επιλ. Μ.Μ
			array_push($arr1, 'v310');				array_push($arr2, $res['v310']);  // Επιλ. Μ.Μ
			array_push($arr1, 'i19p03');			array_push($arr2, $res['i19p03']);// Ποσότητα συνταγής

			if($to_product_tbl != 'a62') {
				array_push($arr1, 'vd101');			array_push($arr2, $res['vd101']); // Επιλέον σύνδεση πίνακα
				array_push($arr1, 'vd102');			array_push($arr2, $res['vd102']); // Επιλέον σύνδεση μ.κ.
			}

			$where_eidi = pegasusGetGlobalVar('peg_'.$from_tbl.'_d-' . $res['p00'] . '_where_eidi');
			$cnt = pegasus_mysql_printfld('peg_tmp_'.$from_product_tbl, 'count(*)', $where_eidi.' AND i18'.$from_product_tbl.' = :nr01', array("nr01"=>$res['nr01']));

			if($cnt > 0) {
				$this->set_invoice_get_main_i18_product_nr01(array($res['nr01'] => $to_product_nr01));
			}

			if(!empty($res['i18'.$from_product_tbl])) {
				$main_i18_product_nr01 = $this->get_invoice_get_main_i18_product_nr01();

				array_push($arr1, 'i18'.$to_product_tbl); array_push($arr2, $main_i18_product_nr01[$res['i18'.$from_product_tbl]]);
			}
			
			//** Από παραστατικό σε παραγγελία προμηθευτή και εσωτερική παραγγελία δεν υπάρχει
			if($to_product_tbl == 'a58') {
				array_push($arr1, 'vd01');			array_push($arr2, $res['vd01']);  // Παράμετρος 1 **
			}

			//** Από παραστατικό σε παραγγελία προμηθευτή δεν υπάρχει
			if($to_product_tbl == 'a58' || $to_product_tbl == 'a62') {
				array_push($arr1, 'v614');			array_push($arr2, $res['v614']);  // Κατώτερη Τιμή Πώλησης **
			}

			//** Αποθηκευτικός Χώρος
			if(in_array($from_product_tbl, array("a58", "a68")) && $to_product_tbl == 'a62') {
				array_push($arr1, 'p03');			array_push($arr2, $res['p703']);
			} else if($from_product_tbl == 'a62' && in_array($to_product_tbl, array("a58", "a68"))) {
				array_push($arr1, 'p703');			array_push($arr2, $res['p03']);
			} else {
				array_push($arr1, 'p703');			array_push($arr2, $res['p703']);
			}

			pegasus_mysql_insert($peg_tmp_tbl, $arr1, $arr2);
		}

		private function _invoice_products_inv_2_inv($res, $from_tbl, $to_tbl, $to_product_tbl, $to_product_nr01, $mmnr01) {
			$to_nr01 = substr($mmnr01, 6);
			$peg_tmp_tbl = "peg_tmp_".$to_product_tbl;

			if($to_tbl == 'a55') {
				$p07 = '2';
			} else if($to_tbl == 'a56') {
				$p07 = '1';
			} else if($to_tbl == 'a60') {
				$p07 = '3';
			}

			$arr1 = array();				        $arr2 = array();

			array_push($arr1, 'p06');				array_push($arr2, $to_nr01);
			array_push($arr1, 'p07'); 				array_push($arr2, $p07);
			array_push($arr1, 'peg_mnr01');			array_push($arr2, $to_nr01);
			array_push($arr1, 'peg_mmnr01');		array_push($arr2, $mmnr01);
			array_push($arr1, 'peg_sess_id');		array_push($arr2, session_id());
			array_push($arr1, 'peg_flag');			array_push($arr2, '1');
			array_push($arr1, 'nr01');				array_push($arr2, $to_product_nr01);

			array_push($arr1, 'p03');				array_push($arr2, $res['p03']);   // Ποσότητα
			array_push($arr1, 'p301');				array_push($arr2, $res['p301']);  // Επιλ. Μ.Μ

			array_push($arr1, 'p013');				array_push($arr2, date('Ymd'));   // Ημερομηνία κίνησης *
			array_push($arr1, 'p013t');				array_push($arr2, date('H:i'));   // Ώρα
			array_push($arr1, 'p305');				array_push($arr2, 0);  			  // Μ.Κ. ειδους παραγγελιας *

			array_push($arr1, 'p01');				array_push($arr2, $res['p01']);   // Κωδικος ειδους
			array_push($arr1, 'p02');				array_push($arr2, $res['p02']);   // Περιγραφη ειδος
			array_push($arr1, 'p081');				array_push($arr2, $res['p081']);  // Κατηγορια ΦΠΑ
			array_push($arr1, 'p08');				array_push($arr2, $res['p08']);   // Ποσοστο φπα
			array_push($arr1, 'p04');				array_push($arr2, $res['p04']);   // Τιμη Μοναδας
			array_push($arr1, 'p030');				array_push($arr2, $res['p030']);  // Δευτ.τιμη μοναδα
			array_push($arr1, 'p041');				array_push($arr2, $res['p041']);  // Εισφορά Ανακύκλωσης Ανά Μονάδα (χωρίς ΦΠΑ)
			array_push($arr1, 'p042');				array_push($arr2, $res['p042']);  // Επιπλέον Αξία
			array_push($arr1, 'p010');				array_push($arr2, $res['p010']);  // Εκπτωση 1
			array_push($arr1, 'p010a');				array_push($arr2, $res['p010a']); // Εκπτωση 2
			array_push($arr1, 'p616');				array_push($arr2, $res['p616']);  // Ε.Φ.Κ. Ανά Μονάδα Χωρίς ΦΠΑ
			array_push($arr1, 'p030_1');			array_push($arr2, $res['p030_1']);// Ποσότητα Συσκευασίας
			array_push($arr1, 'p04_1');				array_push($arr2, $res['p04_1']); // Τιμη Συσκευασίας
			array_push($arr1, 'p0601');				array_push($arr2, $res['p0601']); // Αιτιολογία
			array_push($arr1, 'p610');				array_push($arr2, $res['p610']);  // Αποθηκευτικός Χώρος
			array_push($arr1, 'timh1');				array_push($arr2, $res['timh1']); // Τιμ κοστους ? ισως πρεπει να τα διαζουμε απο το ειδος οτνα αντιγραφο απο παραστατικό σε παραγγελία
			array_push($arr1, 'timh2');				array_push($arr2, $res['timh2']); // Τιμη υπερχοντρικη ? -''-
			array_push($arr1, 'timh3');				array_push($arr2, $res['timh3']); // Τιμη χοντρικη? -''-
			array_push($arr1, 'timh4');				array_push($arr2, $res['timh4']); // Τιμη λαινικης? -''-
			array_push($arr1, 'p614');				array_push($arr2, $res['p614']);  // Κατώτερη Τιμή Πώλησης **
			array_push($arr1, 'p302');				array_push($arr2, $res['p302']);  // Επιλ. Μ.Μ
			array_push($arr1, 'p303');				array_push($arr2, $res['p303']);  // Επιλ. Μ.Μ
			array_push($arr1, 'p304');				array_push($arr2, $res['p304']);  // Επιλ. Μ.Μ
			array_push($arr1, 'p306');				array_push($arr2, $res['p306']);  // Επιλ. Μ.Μ
			array_push($arr1, 'p307');				array_push($arr2, $res['p307']);  // Επιλ. Μ.Μ
			array_push($arr1, 'p308');				array_push($arr2, $res['p308']);  // Επιλ. Μ.Μ
			array_push($arr1, 'p309');				array_push($arr2, $res['p309']);  // Επιλ. Μ.Μ
			array_push($arr1, 'p310');				array_push($arr2, $res['p310']);  // Επιλ. Μ.Μ
			// array_push($arr1, 'pd101');				array_push($arr2, $res['pd101']); // Επιλεον συνδεση πινακσς
			// array_push($arr1, 'pd102');				array_push($arr2, $res['pd102']); // Επιλεον συνδεση μ.κ.
			array_push($arr1, 'pd01');				array_push($arr2, $res['pd01']);  // Παράμετρος 1 **
			array_push($arr1, 'p09');				array_push($arr2, $res['p09']);   // Η Τιμή Μονάδας περιέχει ΦΠΑ
			array_push($arr1, 'i19p03');			array_push($arr2, $res['i19p03']);// Ποσότητα συνταγής

			$where_eidi = pegasusGetGlobalVar('peg_'.$from_tbl.'_d-' . $res['p06'] . '_where_eidi');

			if($from_tbl == "a60") {
				$cnt = pegasus_mysql_printfld('peg_tmp_i01', 'count(*)', $where_eidi['sql'].' AND i18i01 = :nr01', array_merge($where_eidi['sqlParams'], array("nr01"=>$res['nr01'])));
			} else {
				$cnt = pegasus_mysql_printfld('peg_tmp_i01', 'count(*)', $where_eidi.' AND i18i01 = :nr01', array("nr01"=>$res['nr01']));
			}

			if($cnt > 0) {
				$this->set_invoice_get_main_i18_product_nr01(array($res['nr01'] => $to_product_nr01));
			}

			if(!empty($res['i18i01'])) {
				$main_i18_product_nr01 = $this->get_invoice_get_main_i18_product_nr01();

				array_push($arr1, 'i18i01');		array_push($arr2, $main_i18_product_nr01[$res['i18i01']]);
			}

			pegasus_mysql_insert($peg_tmp_tbl, $arr1, $arr2);
		}

		private function _invoice_products_order_2_inv($res, $from_tbl, $to_tbl, $from_product_tbl, $to_product_tbl, $to_product_nr01, $mmnr01) {
			$to_nr01 = substr($mmnr01, 6);
			$peg_tmp_tbl = "peg_tmp_".$to_product_tbl;

			if($from_product_tbl == 'a58') {
				$p09 = pegasus_mysql_printfld('a57', 'p07', 'nr01 = :p00', array("p00"=>$res['p00']));
			} else if($from_product_tbl == 'a68') {
				$p09 = pegasus_mysql_printfld('a67', 'p07', 'nr01 = :p00', array("p00"=>$res['p00']));
			} else if($from_product_tbl == 'a62') {
				$p09 = 0;
			}

			if($to_tbl == 'a55') {
				$p07 = '2';
			} else if($to_tbl == 'a56') {
				$p07 = '1';
			} else if($to_tbl == 'a60') {
				$p07 = '3';
			}

			if($this->get_invoice_get_total_quantity() == 0) {
				$p03  = $res['v103'] - $res['v109'];
				$p301 = $res['v301'] - $res['v111'];
				$p305 = $res['nr01'];
			} else {
				$p03  = $res['v103'];
				$p301 = $res['v301'];
				$p305 = 0;
			}

			$arr1 = array();				        $arr2 = array();

			array_push($arr1, 'p06');				array_push($arr2, $to_nr01);
			array_push($arr1, 'p07'); 				array_push($arr2, $p07);
			array_push($arr1, 'peg_mnr01');			array_push($arr2, $to_nr01);
			array_push($arr1, 'peg_mmnr01');		array_push($arr2, $mmnr01);
			array_push($arr1, 'peg_sess_id');		array_push($arr2, session_id());
			array_push($arr1, 'peg_flag');			array_push($arr2, '1');
			array_push($arr1, 'nr01');				array_push($arr2, $to_product_nr01);

			array_push($arr1, 'p03');				array_push($arr2, $p03);		  // Ποσότητα
			array_push($arr1, 'p301');				array_push($arr2, $p301);		  // Επιλ. Μ.Μ

			array_push($arr1, 'p013');				array_push($arr2, date('Ymd'));   // Ημερομηνία κίνησης *
			array_push($arr1, 'p013t');				array_push($arr2, date('H:i'));   // Ώρα
			array_push($arr1, 'p305');				array_push($arr2, $p305);         // Μ.Κ. ειδους παραγγελιας *

			array_push($arr1, 'p01');				array_push($arr2, $res['v101']);  // Κωδικος ειδους
			array_push($arr1, 'p02');				array_push($arr2, $res['v102']);  // Περιγραφη ειδος
			array_push($arr1, 'p081');				array_push($arr2, $res['v108']);  // Κατηγορια ΦΠΑ
			array_push($arr1, 'p08');				array_push($arr2, $res['v105']);  // Ποσοστο φπα
			array_push($arr1, 'p04');				array_push($arr2, $res['v104']);  // Τιμή Μονάδας
			array_push($arr1, 'p030');				array_push($arr2, $res['v120']);  // Δευτ.τιμη μοναδα
			array_push($arr1, 'p041');				array_push($arr2, $res['v1041']); // Εισφορά Ανακύκλωσης Ανά Μονάδα (χωρίς ΦΠΑ)
			array_push($arr1, 'p042');				array_push($arr2, $res['v1042']); // Επιπλέον Αξία
			array_push($arr1, 'p010');				array_push($arr2, $res['v106']);  // Εκπτωση 1
			array_push($arr1, 'p010a');				array_push($arr2, $res['v106a']); // Εκπτωση 2
			array_push($arr1, 'p616');				array_push($arr2, $res['v616']);  // Ε.Φ.Κ. Ανά Μονάδα Χωρίς ΦΠΑ
			array_push($arr1, 'p030_1');			array_push($arr2, $res['v1030_1']);// Ποσότητα Συσκευασίας
			array_push($arr1, 'p04_1');				array_push($arr2, $res['v104_1']);// Τιμή Συσκευασίας
			array_push($arr1, 'p0601');				array_push($arr2, $res['v160']);  // Αιτιολογία
			array_push($arr1, 'timh1');				array_push($arr2, $res['timh1']); // Τιμ κοστους ? ισως πρεπει να τα διαζουμε απο το ειδος οτνα αντιγραφο απο παραστατικό σε παραγγελία
			array_push($arr1, 'timh2');				array_push($arr2, $res['timh2']); // Τιμη υπερχοντρικη ? -''-
			array_push($arr1, 'timh3');				array_push($arr2, $res['timh3']); // Τιμη χοντρικη? -''-
			array_push($arr1, 'timh4');				array_push($arr2, $res['timh4']); // Τιμη λαινικης? -''-
			array_push($arr1, 'p614');				array_push($arr2, $res['v614']);  // Κατώτερη Τιμή Πώλησης **
			array_push($arr1, 'p302');				array_push($arr2, $res['v302']);  // Επιλ. Μ.Μ
			array_push($arr1, 'p303');				array_push($arr2, $res['v303']);  // Επιλ. Μ.Μ
			array_push($arr1, 'p304');				array_push($arr2, $res['v304']);  // Επιλ. Μ.Μ
			array_push($arr1, 'p306');				array_push($arr2, $res['v306']);  // Επιλ. Μ.Μ
			array_push($arr1, 'p307');				array_push($arr2, $res['v307']);  // Επιλ. Μ.Μ
			array_push($arr1, 'p308');				array_push($arr2, $res['v308']);  // Επιλ. Μ.Μ
			array_push($arr1, 'p309');				array_push($arr2, $res['v309']);  // Επιλ. Μ.Μ
			array_push($arr1, 'p310');				array_push($arr2, $res['v310']);  // Επιλ. Μ.Μ
			array_push($arr1, 'pd101');				array_push($arr2, $res['vd101']); // Επιλεον συνδεση πινακσς
			array_push($arr1, 'pd102');				array_push($arr2, $res['vd102']); // Επιλεον συνδεση μ.κ.
			array_push($arr1, 'pd01');				array_push($arr2, $res['vd01']);  // Παράμετρος 1 **
			array_push($arr1, 'p09');				array_push($arr2, $p09);          // Η Τιμή Μονάδας περιέχει ΦΠΑ
			array_push($arr1, 'i19p03');			array_push($arr2, $res['i19p03']);// Ποσότητα συνταγής

			$where_eidi = pegasusGetGlobalVar('peg_'.$from_tbl.'_d-' . $res['p00'] . '_where_eidi');
			$cnt = pegasus_mysql_printfld('peg_tmp_'.$from_product_tbl, 'count(*)', $where_eidi.' AND i18'.$from_product_tbl.' = :nr01', array("nr01"=>$res['nr01']));

			if($cnt > 0) {
				$this->set_invoice_get_main_i18_product_nr01(array($res['nr01'] => $to_product_nr01));
			}

			if(!empty($res['i18'.$from_product_tbl])) {
				$main_i18_product_nr01 = $this->get_invoice_get_main_i18_product_nr01();

				array_push($arr1, 'i18i01'); 		array_push($arr2, $main_i18_product_nr01[$res['i18'.$from_product_tbl]]);
			}
			
			// Αποθηκευτικός Χώρος
			if($from_product_tbl == "a62") {
				array_push($arr1, 'p610');			array_push($arr2, $res['p03']);
			} else {
				array_push($arr1, 'p610');			array_push($arr2, $res['p703']);
			}
			

			pegasus_mysql_insert($peg_tmp_tbl, $arr1, $arr2);
		}

		private function _invoice_products_inv_2_order($res, $from_tbl, $from_product_tbl, $to_product_tbl, $to_product_nr01, $mmnr01) {
			$to_nr01 = substr($mmnr01, 6);
			$peg_tmp_tbl = "peg_tmp_".$to_product_tbl;
			$v107        = invoices_make_product_total($res['p03'], $res['p04'], $res['p08'], $res['p010'], $res['p010a'], $res['p041'], $res['p616'], $res['p09'], $res['p042']);

			$arr1 = array();				        $arr2 = array();

			array_push($arr1, 'peg_mnr01');			array_push($arr2, $to_nr01);
			array_push($arr1, 'peg_mmnr01');		array_push($arr2, $mmnr01);
			array_push($arr1, 'peg_sess_id');		array_push($arr2, session_id());
			array_push($arr1, 'peg_flag');			array_push($arr2, '1');
			array_push($arr1, 'nr01');				array_push($arr2, $to_product_nr01);

			//Δεν υπήρχε το ΜΚ Παραγγελίας
			array_push($arr1, 'p00');				array_push($arr2, $to_nr01);

			array_push($arr1, 'v103');				array_push($arr2, $res['p03']);   // Ποσοτητα 
			array_push($arr1, 'v301');				array_push($arr2, $res['p301']);  // Επιλ. Μ.Μ

			array_push($arr1, 'v101');				array_push($arr2, $res['p01']);   // Κωδικός είδους
			array_push($arr1, 'v102');				array_push($arr2, $res['p02']);   // Περιγραφή είδος
			array_push($arr1, 'v108');				array_push($arr2, $res['p081']);  // Κατηγορία ΦΠΑ
			array_push($arr1, 'v107');				array_push($arr2, $v107 );  	  // Σύνολο
			array_push($arr1, 'v105');				array_push($arr2, $res['p08']);   // Ποσοστό ΦΠΑ
			array_push($arr1, 'v104');				array_push($arr2, $res['p04']);   // Τιμή Μονάδας
			array_push($arr1, 'v120');				array_push($arr2, $res['p030']);  // Δευτ.τιμη μοναδα
			array_push($arr1, 'v1041');				array_push($arr2, $res['p041']);  // Εισφορά Ανακύκλωσης Ανά Μονάδα (χωρίς ΦΠΑ)
			array_push($arr1, 'v1042');				array_push($arr2, $res['p042']);  // Επιπλέον Αξία
			array_push($arr1, 'v106');				array_push($arr2, $res['p010']);  // Εκπτωση 1
			array_push($arr1, 'v106a');				array_push($arr2, $res['p010a']); // Εκπτωση 2
			array_push($arr1, 'v616');				array_push($arr2, $res['p616']);  // Ε.Φ.Κ. Ανά Μονάδα Χωρίς ΦΠΑ
			array_push($arr1, 'v1030_1');			array_push($arr2, $res['p030_1']);// Ποσότητα Συσκευασίας
			array_push($arr1, 'v104_1');			array_push($arr2, $res['p04_1']); // Τιμή Συσκευασίας
			array_push($arr1, 'v160');				array_push($arr2, $res['p0601']); // Αιτιολογία
			array_push($arr1, 'timh1');				array_push($arr2, $res['timh1']); // Τιμ κοστους ? ισως πρεπει να τα διαζουμε απο το ειδος οτνα αντιγραφο απο παραστατικό σε παραγγελία
			array_push($arr1, 'timh2');				array_push($arr2, $res['timh2']); // Τιμη υπερχοντρικη ? -''-
			array_push($arr1, 'timh3');				array_push($arr2, $res['timh3']); // Τιμη χοντρικη? -''-
			array_push($arr1, 'timh4');				array_push($arr2, $res['timh4']); // Τιμη λαινικης? -''-
			
			array_push($arr1, 'v302');				array_push($arr2, $res['p302']);  // Επιλ. Μ.Μ
			array_push($arr1, 'v303');				array_push($arr2, $res['p303']);  // Επιλ. Μ.Μ
			array_push($arr1, 'v304');				array_push($arr2, $res['p304']);  // Επιλ. Μ.Μ
			array_push($arr1, 'v306');				array_push($arr2, $res['p306']);  // Επιλ. Μ.Μ
			array_push($arr1, 'v307');				array_push($arr2, $res['p307']);  // Επιλ. Μ.Μ
			array_push($arr1, 'v308');				array_push($arr2, $res['p308']);  // Επιλ. Μ.Μ
			array_push($arr1, 'v309');				array_push($arr2, $res['p309']);  // Επιλ. Μ.Μ
			array_push($arr1, 'v310');				array_push($arr2, $res['p310']);  // Επιλ. Μ.Μ
			array_push($arr1, 'i19p03');			array_push($arr2, $res['i19p03']);// Ποσότητα συνταγής

			//? Δεν θέλουμε να αρχικοποιούνται τα πεδία των συνδέσεων από invoice σε invoice/order,
			//? επειδή π.χ.μπορεί ένα είδος να έχει σύνδεση με αντλία και αν αυτή μεταφερθεί, η καταχώρηση του παραστατικού 
			//? δεν θα μπορέσει να γίνει σαν ελεύθερη καταχώρηση ή καταχώρηση με παραστατικό διάφορο από oil παραστατικού.
			// if($to_product_tbl != 'a62') {
			// 	array_push($arr1, 'vd101');		   array_push($arr2, $res['pd101']); // Επιλέον σύνδεση πίνακα
			// 	array_push($arr1, 'vd102');		   array_push($arr2, $res['pd102']); // Επιλέον σύνδεση μ.κ.
			// }
			
			$where_eidi = pegasusGetGlobalVar('peg_'.$from_tbl.'_d-' . $res['p06'] . '_where_eidi');

			if($from_tbl == "a60") {
				$cnt = pegasus_mysql_printfld('peg_tmp_i01', 'count(*)', $where_eidi['sql'].' AND i18i01 = :nr01', array_merge($where_eidi['sqlParams'], array("nr01"=>$res['nr01'])));
			} else {
				$cnt = pegasus_mysql_printfld('peg_tmp_i01', 'count(*)', $where_eidi.' AND i18i01 = :nr01', array("nr01"=>$res['nr01']));
			}

			if($cnt > 0) {
				$this->set_invoice_get_main_i18_product_nr01(array($res['nr01'] => $to_product_nr01));
			}

			if(!empty($res['i18i01'])) {
				$main_i18_product_nr01 = $this->get_invoice_get_main_i18_product_nr01();

				array_push($arr1, 'i18'.$to_product_tbl); array_push($arr2, $main_i18_product_nr01[$res['i18i01']]);
			}
			
			//** Από παραστατικό σε παραγγελία προμηθευτή και εσωτερική παραγγελία δεν υπάρχει
			if($to_product_tbl == 'a58') {
				array_push($arr1, 'vd01');			array_push($arr2, $res['pd01']);  // Παράμετρος 1 **
			}

			//** Από παραστατικό σε παραγγελία προμηθευτή δεν υπάρχει
			if($to_product_tbl == 'a58' || $to_product_tbl == 'a62') {
				array_push($arr1, 'v614');			array_push($arr2, $res['p614']);  // Κατώτερη Τιμή Πώλησης **
			}

			//** Αποθηκευτικός Χώρος
			if($to_product_tbl == 'a62') {
				array_push($arr1, 'p03');			array_push($arr2, $res['p610']);
			} else {
				array_push($arr1, 'p703');			array_push($arr2, $res['p610']);
			}

			pegasus_mysql_insert($peg_tmp_tbl, $arr1, $arr2);
		}




		private function _invoice_products_a90($from_product_tbl, $from_product_nr01, $to_product_tbl, $to_product_nr01, $mmnr01) {
			if(pegasus_mysql_table_exists('a90')) {
				$query_a90 = "SELECT p30 FROM a90 WHERE tbl=:tbl AND tbl_nr01=:res_nr01";
				$query_params_a90 = array(
					'tbl'      => $from_product_tbl,
					'res_nr01' => $from_product_nr01
				);

				pegasus_mysql_use($query_a90, $a90, $query_params_a90);

				if(!empty($a90['p30'])) {
					$arr['p30']         = $a90['p30'];
					$arr['tbl']         = $to_product_tbl;
					$arr['tbl_nr01']    = $to_product_nr01;
					$arr['nr01']        = pegasus_mysql_newrec('a90');
					$arr['peg_mnr01']   = $to_product_nr01;
					$arr['peg_mmnr01']  = $mmnr01;
					$arr['peg_sess_id'] = session_id();
					$arr['peg_flag']    = '1';

					pegasus_mysql_insert('peg_tmp_a90', array_keys($arr), array_values($arr));
				}
			}
        }	

		private function _invoice_products_serial($from_product_tbl, $from_product_nr01, $to_product_tbl, $to_product_nr01, $mmnr01) {
			if(pegasus_module_exists('serial')) {
				if($from_product_tbl == 'a58') {
					$from_p010 = '2';
				} else if($from_product_tbl == 'a68') {
					$from_p010 = '3';
				} else if($from_product_tbl == 'i01') {
					$from_p010 = '1';
				} else if($from_product_tbl == 'a62') {
					$from_p010 = '4';
				}

				$query_i32 = "SELECT * FROM i32 WHERE p010=:p010 AND p00=:from_product_nr01 ";
				$query_params_i32 = array(
					'p010' => $from_p010,
					'from_product_nr01' => $from_product_nr01
				);

				$res_i32 = pegasus_query($query_i32, $query_params_i32);
				
				while($i32 = pegasus_fetch($res_i32)) {

					if($to_product_tbl == 'a58') {
						$to_p010 = '2';
					} else if($to_product_tbl == 'a68') {
						$to_p010 = '3';
					} else if($to_product_tbl == 'i01') {
						$to_p010 = '1';
					} else if($to_product_tbl == 'a62') {
						$to_p010 = '4';
					}

					invoices_add_serial($mmnr01, $to_product_nr01, $i32['p01'], $to_p010, $i32['p02']); 
				}
			}
      	}

	  	private function _invoice_products_lots($from_product_tbl, $from_product_nr01, $to_product_tbl, $to_product_nr01, $mmnr01) {
			if(pegasus_module_exists('lot')) {
				if($from_product_tbl == 'a58') {
					$from_p010 = '2';
				} else if($from_product_tbl == 'a68') {
					$from_p010 = '3';
				} else if($from_product_tbl == 'i01') {
					$from_p010 = '1';
				} else if($from_product_tbl == 'a62') {
					$from_p010 = '4';
				}

				if($this->get_invoice_get_total_quantity() == 0 && in_array($from_product_tbl, array('a58', 'a68', 'a62'))) {
					$query_i38 = "SELECT * FROM i38 WHERE p010=:p010 AND p01=:from_product_nr01 AND (p04-p06) > 0";
				} else {
					$query_i38 = "SELECT * FROM i38 WHERE p010=:p010 AND p01=:from_product_nr01 AND (pnr01 = 0 OR pnr01 = nr01)";
				}

				$query_params_i38 = array(
					'p010' => $from_p010,
					'from_product_nr01' => $from_product_nr01
				);

				$res_i38 = pegasus_query($query_i38, $query_params_i38);

				if($to_product_tbl == 'a58') {
					$to_p010 = '2';
				} else if($to_product_tbl == 'a68') {
					$to_p010 = '3';
				} else if($to_product_tbl == 'i01') {
					$to_p010 = '1';
				} else if($to_product_tbl == 'a62') {
					$to_p010 = '4';
				}

				while ($i38 = pegasus_fetch($res_i38)) {
					if($this->get_invoice_get_total_quantity() == 0 && in_array($from_product_tbl, array('a58', 'a68', 'a62'))) {
						$p04 = $i38['p04'] - $i38['p06'];
						$p05 = $i38['p05'] - $i38['p07'];
						$p06 = $i38['p06'];
						$p07 = $i38['p07'];
					} else {
						$p04 = $i38['p04'];
						$p05 = $i38['p05'];
						$p06 = 0;
						$p07 = 0;
					}

					invoices_add_lot($mmnr01, $to_product_nr01, $to_p010, $i38['p02'], $p04, $p05, $p06, $p07);
				}
			}
		}

		private function _invoice_products_colorsize($from_product_tbl, $from_product_nr01, $to_tbl, $to_product_nr01, $mmnr01) {
			if(pegasus_module_exists('colorsize')) {
				if($from_product_tbl == 'a58') {
					$tbl = 'a59';
				} else if($from_product_tbl == 'a68') {
					$tbl = 'a69';
				} else if($from_product_tbl == 'i01') {
					$tbl = 'i48';
				} else if($from_product_tbl == 'a62') {
					$tbl = 'a63';
				}

				$query_tbl = "SELECT * FROM $tbl WHERE p01=:nr01";
				$query_params_tbl = array(
					'nr01' => $from_product_nr01
				);

				$res_tbl = pegasus_query($query_tbl, $query_params_tbl);

				while($res = pegasus_fetch($res_tbl)) {
					if($this->get_invoice_get_total_quantity() == 0) {
						$p04 = $res['p04'] - $res['p05'];
					} else {
						$p04 = $res['p04'];			
					}

					if(in_array($from_product_tbl, array("a58", "a68", "a62"))) {
						$p01 = $res['p06'];
						$i01p05 = 0;
						$i01p012 = 0;
						$i01p610 = $res['p07'];
					} else {
						$p01 	 = $res['i01p01'];
						$i01p05  = $res['i01p05'];
						$i01p012 = $res['i01p012'];
						$i01p610 = $res['i01p610'];
					}

					invoices_add_colorsize($mmnr01, $to_tbl, $to_product_nr01, $p01, $res['p02'], $res['p03'], $p04, $i01p05, $i01p012, $i01p610);
				}
			}
		}

		private function _invoice_products_i71($from_tbl, $from_nr01, $to_tbl, $to_nr01, $mmnr01) {
			$query_i71 = "SELECT * FROM i71 WHERE tbl=:from_tbl AND tbl_nr=:tbl_nr";
			$query_params_i71 = array(
				'from_tbl' => $from_tbl,
				'tbl_nr'   => $from_nr01[0]
			);

			$res_i71 = pegasus_query($query_i71, $query_params_i71);

			while ($i71 = pegasus_fetch($res_i71)) {
				$arr1 = array();        		   $arr2 = array();

				array_push($arr1, 'peg_mnr01');    array_push($arr2, $to_nr01);
				array_push($arr1, 'peg_mmnr01');   array_push($arr2, $mmnr01);
				array_push($arr1, 'peg_sess_id');  array_push($arr2, session_id());
				array_push($arr1, 'peg_flag');     array_push($arr2, '1');
				array_push($arr1, 'nr01');         array_push($arr2, pegasus_mysql_newrec('i71'));
				array_push($arr1, 'tbl');          array_push($arr2, $to_tbl);
				array_push($arr1, 'tbl_nr');       array_push($arr2, $to_nr01);
				array_push($arr1, 'i70p02');       array_push($arr2, $i71['i70p02']);
				array_push($arr1, 'i70');          array_push($arr2, $i71['i70']);
				array_push($arr1, 'p04');          array_push($arr2, $i71['p04']);
				array_push($arr1, 'p05');          array_push($arr2, $i71['p05']);
				array_push($arr1, 'p100');         array_push($arr2, $i71['p100']);
				array_push($arr1, 'tax');          array_push($arr2, $i71['tax']);
				array_push($arr1, 'i70p07');       array_push($arr2, $i71['i70p07']);
				array_push($arr1, 'p012');         array_push($arr2, $i71['p012']);

				pegasus_mysql_insert('peg_tmp_i71', $arr1, $arr2);
			}
		}

		private function _invoice_recalc_totals($data, $main_tbl) {
			$mmnr01 = $main_tbl.'_d-'.$data['nr01'];

			$data['nr01'] = intval($data['nr01']);
			$product_where = "peg_mnr01='" .  $data['nr01'] . "' and peg_mmnr01='" . $mmnr01 . "' and peg_sess_id='" . session_id() . "' and peg_flag!=9 ";

			if($main_tbl == 'a55') {
				$product_table = 'peg_tmp_i01';
				$p07 = '2';
				$product_where .= " and p06='" .  $data['nr01'] . "' and p07='". $p07 ."'" ;
			} else if($main_tbl == 'a56') {
				$product_table = 'peg_tmp_i01';
				$p07 = '1';
				$product_where .= " and p06='" .  $data['nr01'] . "' and p07='". $p07 ."'" ;
			}else if($main_tbl == 'a57'){
				$product_table = 'peg_tmp_a58';		

			}else if($main_tbl == 'a67'){
				$product_table = 'peg_tmp_a68';		
			}

			$p0101   = $data['p0101'];
			$p0102_1 = $data['p0102_1'];
			$p0102_2 = $data['p0102_2'];

			$p0112   = $data['p0112'];
			$p0113   = $data['p0113'];
			$p0103   = $data['p0103'];
			$p0108   = $data['p0108'];
			$p410    = $data['p410'];
			$p420    = $data['p420'];
			$a01_p09 = $data['p09'];
			$preview_with_vat = $data['p07'];

			$_totals['p201'] = $data['p201'];
			$_totals['p202'] = $data['p202'];
			$_totals['p203'] = $data['p203'];
			$_totals['p204'] = $data['p204'];
			$_totals['p205'] = $data['p205'];
			$_totals['p206'] = $data['p206'];
			$_totals['p207'] = $data['p207'];
			$_totals['p208'] = $data['p208'];
			$_totals['p209'] = $data['p209'];

			$_totals['p301'] = $data['p301'];
			$_totals['p302'] = $data['p302'];
			$_totals['p303'] = $data['p303'];
			$_totals['p304'] = $data['p304'];
			$_totals['p305'] = $data['p305'];
			$_totals['p306'] = $data['p306'];
			$_totals['p307'] = $data['p307'];
			$_totals['p308'] = $data['p308'];
			$_totals['p309'] = $data['p309'];

			$return_array = invoices_calculate_total(
				$product_table, 
				$product_where, 
				$p0101, 
				$p0112, 
				$p0113, 
				$p0103, 
				$p0108, 
				$a01_p09, 
				$preview_with_vat, 
				$p410,
				$_totals, 
				null, 
				$p0102_1, 
				$p0102_2,
				0,
				$main_tbl, 
				"", 
				$data['nr01'],
				$data['pn02'],
				$p420
			); // todo να αλλαξουμε το where να παζιει εμ values array

			foreach ($return_array as $key => $value) {
				$data[$key] = $value;
			}

			return $data;
		}

		public function from_tbl_2_to_tbl($mode_nr01 = 0, $data = array(), $append_mnr01 = array(), $from_tbl = "", $to_tbl = "") {
			if(!($mode_nr01 > 0)) {
				return $data;
			}

			// Προσθήκη Παραμέτρων οθόνης
			$data = $this->_invoice_data($data, $from_tbl, $mode_nr01, $to_tbl);

			if(in_array($from_tbl, array("a55", "a56", "a57", "a67"))) {
				// Διαβαζω τα στοιχεια του πελατη αν προκειται για παραγγελια / παραστατικο πελατη
				if(in_array($to_tbl, array("a55", "a57"))) {
					pegasus_mysql_use("SELECT * FROM a01 WHERE nr01=? ", $a01, array($data['p03']));

					// Πιστωτικό Όριο Πελάτη
					$data['p412']  = $a01['p27'];

					if($a01['pl31'] == 1) {	  
						// Οι Σημειώσεις Τιμολογικής Εμφανίζονται σε Παραστατικά / Παραγγελίες
						$data['message'] = $a01["p31"];
					}

					// Υπόλοιπα Πελάτες																											// a55						 / a57
					$data['p411'] = account_find_balance($a01['p21'], 0, 9999999999, $data['p01'], $data['p02'], $data['nr01']);                // Συνολικό Προηγ. Υπόλοιπο  / Πρ.Υπόλοιπο
					$data['p417'] = account_find_balance($a01['p21'], $data['p415'],  $data['p416'],$data['p01'], $data['p02'], $data['nr01']); // Προηγούμενο Υπόλοιπο      / Τοπικό Υπόλοιπο

					if(pegasus_module_exists('giftcards')) {
						// Πόντοι (Variable)
						$data['vp506_2'] = giftcards_find_total_points($a01['nr01']);
					}
				// Διαβαζω τα στοιχεια του προμηθευτη αν προκειται για παραγγελια / παραστατικο πελατη					
				} else if(in_array($to_tbl, array("a56", "a67"))) {
					pegasus_mysql_use("SELECT * FROM a00 WHERE nr01=? ", $a00, array($data['p03']));

					// Πιστωτικό Όριο Προμηθευτή
					$data['p412'] = $a00['p27']; 

					if($a00['pl31'] == 1) {	  
						// Οι Σημειώσεις Τιμολογικής Εμφανίζονται σε Παραστατικά / Παραγγελίες
						$data['message'] = $a00["p31"];
					}

					// Υπόλοιπα Προμηθευτές																												  // a56 					  / a67 
					$data['p411'] = account_find_balance($a00['p21'], 0, 9999999999, $data['p01'], $data['p02'], $data['nr01'], 0, 'a56');                // Συνολικό Προηγ. Υπόλοιπο / Πρ.Υπόλοιπο
					$data['p417'] = account_find_balance($a00['p21'], $data['p415'],  $data['p416'],$data['p01'], $data['p02'], $data['nr01'], 0, 'a56'); // Προηγούμενο Υπόλοιπο     / Τοπικό Υπόλοιπο
				}

				// Αν προκειται για αντιγραφη Παραγγελιας/παραστατικου πελατη σε Παραγγελιας/παραστατικου πελατη μονο τοτε αντιγραφω το κοινα
				if(
					($from_tbl == 'a55' && $to_tbl == 'a57') ||
					($from_tbl == 'a57' && $to_tbl == 'a55')					
				) {
					pegasus_mysql_use("SELECT * FROM a10 WHERE p01=?", $a10, array($data['p05']));

					// Χειρόγραφο
					$data['p08'] = $a10['p203']; 
					
					// Αν το χειρόγραφο ειναι ενεργό τότε θα αντιγράφει τον αριθμό της παραγγελίας
					if($a10['p203'] == 1){
						// Αριθμός
						$data['p06'] = $data['p06'];
					}
		
					// Ε: 10000058 Υπολογίζει την σειρά του παραστατικού
					if(!empty($a10) && $a10['p109'] != '****') {
						$data['p701'] = $a10['p109'];
					} else { 
						// Σειρά (p701) fallback από cor003.p105
						$data['p701'] = $_SESSION['cor003_p101'];
					}
				} 
				
				// Αν προκειται για αντιγραφη Παραγγελιας/παραστατικου προμηθευτη σε Παραγγελιας/παραστατικου προμηθευτη μονο τοτε αντιγραφω το κοινα
				if(
					($from_tbl == 'a56' && $to_tbl == 'a67') ||
					($from_tbl == 'a67' && $to_tbl == 'a56')
				) {
					pegasus_mysql_use("SELECT * FROM a11 WHERE p01=?", $a11, array($data['p05']));

					// Χειρόγραφο
					$data['p08'] = $a11['p203'];

					//Αν το χειρόγραφο ειναι ενεργό τότε θα αντιγράφει τον αριθμό της παραγγελίας
					if($a11['p203'] == 1) {
						$data['p06'] = $data['p06'];
					}
				
					if(!empty($a11['p109'])) {
						$data['p701'] = $a11['p109'];
					}

					// Ε:10000058
					if(!empty($a11) && $a11['p109'] != '****') {
						$data['p701'] = $a11['p109'];
					} else { // Σειρά (p701) fallback από cor003.p105
						$data['p701'] = $_SESSION['cor003_p101'];
					}
				}
			}

			// Δημιουργία Ειδών
			$p00_array[] = $mode_nr01;
			$this->_invoice_products($from_tbl, $p00_array, $to_tbl, $data['nr01'], $append_mnr01);

			// Υπολογισμός Συνόλων
			if(in_array($from_tbl, array("a55", "a56", "a57", "a67")) && in_array($to_tbl, array("a55", "a56", "a57", "a67"))) {
				$data = $this->_invoice_recalc_totals($data, $to_tbl);
			}

			return $data;
		}
	}