<?php
	require_once('../invoices00/header.php');
	
	global $PegInput;

	$PegInput->addVar(new peg_input_number('a01nr01'));
	$PegInput->addVar(new peg_input_number('nr01'));
	$PegInput->addVar(new peg_input_number('p09'));
	$PegInput->addVar(new peg_input_alphanumeric('p01'));
	$PegInput->addVar(new peg_input_number('recalculate_unit_price'));
	$PegInput->addVar(new peg_input_alphanumeric('container_id'));
	$PegInput->addVar(new peg_input_alphanumeric('container_id_eidi'));
	
	$a01nr01 	  	   		= $PegInput->getRequest('a01nr01');				   // ΜΚ Πελάτη
	$nr01 	  	   			= $PegInput->getRequest('nr01');				   // ΜΚ Παραστατικού/Παραγελίας
	$p09 	  	   			= $PegInput->getRequest('p09');		               // Η Τιμή Μονάδας περιέχει ΦΠΑ
	$p01 	  	   			= $PegInput->getRequest('p01');					   // Ημερομηνία
	$recalculate_unit_price = $PegInput->getRequest('recalculate_unit_price'); // 1 = Αν θέλουμε να γίνει αποφορολόγηση των ειδών στην τιμή μονάδας
	$container_id 	   		= $PegInput->getRequest('container_id');
	$container_id_eidi 		= $PegInput->getRequest('container_id_eidi');
		
	if(peg_dateIsEmpty($p01)){
		$p01 = date('Y-m-d');
	}
	
	if($mode == 'a55' || $mode == 'retail00_01'){
		$product_table = 'peg_tmp_i01';
		$is_invoice=1;
	}

	if($mode == 'a56'){
		$product_table = 'peg_tmp_i01';
		$is_invoice=1;
	}
	
	if($mode == 'a57'){
		$product_table = 'peg_tmp_a58';
		$is_invoice = 0;
	}

	if($mode == 'a67'){
		$product_table = 'peg_tmp_a68';
		$is_invoice = 0;
	}

	$product_where = pegasusGetGlobalVar( $container_id . '_where_eidi') ;
	$product_table_array = array();
	
	if($is_invoice == 0) {
		$query='SELECT 	'.$product_table.'.nr01,
						'.$product_table.'.v103,
						'.$product_table.'.v104, 
						'.$product_table.'.v105,
						'.$product_table.'.v1042,
						'.$product_table.'.v101 AS v101 
				FROM '.$product_table.' 
				WHERE ' . $product_where . ' ';
	} else {
		$query='SELECT 	'.$product_table.'.nr01,
						'.$product_table.'.p03,
						'.$product_table.'.p04,
						'.$product_table.'.p08, 
						'.$product_table.'.p042,
						'.$product_table.'.p01  AS v101 
				FROM '.$product_table.' 
				WHERE ' . $product_where . ' ';
	}

	$res = pegasus_query($query);	

	while($products = pegasus_fetch($res)) {
		$ret = invoice_find_product_fpa($products['v101'], $p09, $p01);

		if($is_invoice == 1) {
			$product_table_array['p08']  = $ret['v105']; // % ΦΠΑ
			$product_table_array['p081'] = $ret['v108']; // Κατηγορία ΦΠΑ

			if($recalculate_unit_price == 1) {
				// ((Ποσότητα *Τιμή μονάδας + Επιπλέον αξία ) / Ποσότητα) *100/(100 + ποσοστό ΦΠΑ)
				$p04 = (($products['p03'] * $products['p04'] + $products['p042']) / $products['p03']) * 100 / (100 + $products['p08']);

				$product_table_array['p04']  = $p04; // Τιμή Μονάδας
				$product_table_array['p09']  = 0;    // Η Τιμή Μονάδας περιέχει ΦΠΑ
				$product_table_array['p042'] = 0;    // Επιπλέον Αξία
			}
		} else {
			$product_table_array['v105'] = $ret['v105']; // % ΦΠΑ
			$product_table_array['v108'] = $ret['v108']; // Κατηγορία ΦΠΑ

			if($recalculate_unit_price == 1) {
				$v104 = (($products['v103'] * $products['v104'] + $products['v1042']) / $products['v103']) * 100 / (100 + $products['v105']);
				$v107 = '(( v103 * '.$v104.' * ((100 - v106) / 100) * ((100 - v106a) / 100)) + (v1041 * v103) + (v616 * v103))';

				$product_table_array['v104']  = $v104; // Τιμή Μονάδας
				$product_table_array['v107']  = $v107; // Σύνολο
				$product_table_array['v1042'] = 0;     // Επιπλέον Αξία
			}
		}

		$product_table_array['peg_flag'] = 2;

		pegasus_mysql_update($product_table, array_keys($product_table_array), array_values($product_table_array), 'nr01=:nr01 and '.$product_where, 0, 0, 1, array("nr01" => $products['nr01']));
	}
	
	$ret_array = array();
	$ret_array['ok'] = 1;
	
	echo json_encode($ret_array);
?>