<?php

class InvoicesAppHealthIsfieldsnull extends AppHealthScenario
{
    public function check() {
        $ret_array = array();
        $ret_array['data'] = array(
            'status'    => true,
            'message'   => $_SESSION['peg_dic_invoices_app_health_efficient_search']
        );
        $ret_array['ok'] = 1;
        $ret_array['msg'] = 'pass';
        $has_error = false;

        $barcode_f02 = $_SESSION['f02_pg06'];
        $partNumber_f02 = $_SESSION['f02_pg07'];
        $spID_f02 = $_SESSION['f02_pg011'];
        $sn_f02 = $_SESSION['f02_pg08'];
        $lot_with_f02 = $_SESSION['f02_pg012'];

        $list = "";

        $query_i00 = "SELECT count(*) AS cnt, i00.pno FROM i00 WHERE i00.p203 = 0 AND i00.p01 != '' AND i00.pno != '' LIMIT 1";
        pegasus_mysql_use($query_i00, $i00_result);

        if($i00_result['cnt'] > 0) {
            if($barcode_f02 == '0') {                
                $barcode = $_SESSION['peg_dic_invoices_search_barcode'];
                $has_error = true;
                if(!empty($list)) {
                    $list = $list . ", ";
                }
                $list = $list . $barcode;
            }

            if($partNumber_f02 == '0') {
                $partNumber = $_SESSION['peg_dic_invoices_search_antistoixia'];
                $has_error = true;
                if(!empty($list)) {
                    $list = $list . ", ";
                }
                $list = $list . $partNumber;
            }

            if($spID_f02 == '0') { 
                if(pegasus_module_exists('invspcodes')) {
                    $query_i08 = 'SELECT count(*) AS cnt FROM i08 WHERE pe01 = :pno LIMIT 1';
                    pegasus_mysql_use($query_i08, $i08_reuslt, array('pno'=>$i00_result['pno']));

                    if($i08_reuslt['cnt'] > 0) {
                        $spID = $_SESSION['peg_dic_invoices_search_spcodes'];
                        $has_error = true;
                        if(!empty($list)) {
                            $list = $list . ", ";
                        }
                        $list = $list . $spID;
                    }
                }
            }
            //Serial Number
            if($sn_f02 == '0') {
                if(pegasus_module_exists('serial')) {
                    $query_i00 = "SELECT count(*) AS cnt, i00.pno FROM i00 WHERE i00.ps01 = 1 AND i00.p203 = 0 AND i00.p01 != '' AND i00.pno != '' LIMIT 1";
                    pegasus_mysql_use($query_i00, $i00_result);

                    if($i00_result['cnt'] > 0) { // Παρακολουθεί SN
                        $query_i31 = 'SELECT count(*) AS cnt FROM i31 WHERE p01 = :pno LIMIT 1';
                        pegasus_mysql_use($query_i31, $i31_result, array('pno'=>$i00_result['pno']));
                        
                        if($i31_result['cnt'] > 0) {
                            $sn = $_SESSION['peg_dic_invoices_search_serial'];
                            $has_error = true;
                            if(!empty($list)) {
                                $list = $list . ", ";
                            }
                            $list = $list . $sn;
                        }
                    }
                }
            }

            if($lot_with_f02 == '0') {
                if(pegasus_module_exists('lot')) {
                    $query_i00 = "SELECT count(*) AS cnt, i00.pno FROM i00 WHERE i00.p904 = 1 AND i00.p203 = 0 AND i00.p01 != '' AND i00.pno != '' LIMIT 1";
                    pegasus_mysql_use($query_i00, $i00_result);
                    
                    if($i00_result['cnt'] > 0) { // Παρακολουθεί Partida
                        $query_i11 = 'SELECT count(*) AS cnt FROM i11 WHERE p01 = :pno LIMIT 1';
                        pegasus_mysql_use($query_i11, $i11_result, array('pno'=>$i00_result['pno']));
                        
                        if($i11_result['cnt'] > 0) {
                            $lot_with = $_SESSION['peg_dic_invoices_app_health_lot_with_barcode'];
                            $has_error = true;
                            if(!empty($list)) {
                                $list = $list . ", ";
                            }
                            $list = $list . $lot_with;
                        }
                    }
                }
            }
        }

        if($has_error) {
            $ret_array['msg'] = 'fail';
            $ret_array['data'] = array(
                'status'    => false,
                'message'   => str_replace('##the_list##', $list, $_SESSION['peg_dic_invoices_app_health_non_efficient_search']),
                '_d'        => array(
                    'table' => 'f02',
                    '_d'    => 'f02_d',
                    'module'=> 'invoices'
                )
            );
            return $ret_array;
        }
        return $ret_array;
    }
}