<?php

if (class_exists('PrintsData') === false) {
	if (file_exists('../../pegasus_cloud_app/prints_classes/prints_data.php')) {
		require_once('../../pegasus_cloud_app/prints_classes/prints_data.php');
	} else {
		return;
	}
}

class InvtransInv_tot_dPrintsData extends PrintsData {

    protected function setBodySql(){
    
        if(!empty($this->p85_arr['body_sql_code'])){
            $sql_code = eval($this->p85_arr['body_sql_code']);
        }

        if(empty($sql_code)){
            $sql_code = pegasusGetGlobalVar('peg_'.$this->p85_input['dias_container_id'].'_grid_query');
        }
        $this->body_sql = (is_array($sql_code)) ? $sql_code : array('sql'=>$sql_code, 'sqlParams'=>array());
    }

    protected function makeGlobalData(){
        
        $global_data = parent::makeGlobalData();

        $p85_search = pegasusGetGlobalVar( $this->p85_input['dias_container_id']. '_i00tot_d_params');

        // Store Titles
		$core_titles_data = invoices_get_store_titles(0);

        for($i=1; $i<=8; $i++){ 
            $global_data['cor000_tit_line'.$i] = $core_titles_data[$i-1];
        }
        for($i=1; $i<=8; $i++){ 
            $global_data['cor000_eng_tit_line'.$i] = $core_titles_data[$i+7];
            if(empty($global_data['cor000_eng_tit_line'.$i])){
                $global_data['cor000_eng_tit_line'.$i] = $core_titles_data[$i-1];
            }
        }

        // Footer Titles
        $core_footer_data = invoices_get_store_footer(0);
        for($i=1; $i<=5; $i++){ 
            $global_data['f02_ftr00'.$i] = $core_footer_data[$i-1];
        }
        for($i=1; $i<=5; $i++){ 
            $global_data['f02_eftr00'.$i] = $core_footer_data[$i+4];
        }
        
        // Κριτήρια Αναζήτησης
        $global_data['search_param_dt']        = !empty($this->p85_input['dt'])?peg_dateToStr($this->p85_input['dt'], 'd/m/Y'):peg_dateToStr($p85_search['dt'], 'd/m/Y');
        $global_data['search_param_p02']       = !empty($this->p85_input['p02'])?$this->p85_input['p02']:$p85_search['p02'];
        $global_data['search_param_p03']       = !empty($this->p85_input['p03'])?$this->p85_input['p03']:$p85_search['p03'];
        $global_data['search_param_colorsize'] = !empty($this->p85_input['colorsize'])?$this->p85_input['colorsize']:$p85_search['colorsize'];
        
        // Απ Χώροι 
        $m_i16_arr        = array();
        $m_i16            = '';
        $m_i16_concat     = !empty($this->p85_input['m_i16'])?$this->p85_input['m_i16']:$p85_search['m_i16'];
        $m_i16_arr        = explode ('#', $m_i16_concat);
        $m_i16_arr        = array_slice($m_i16_arr, 1, -1);
        if(!empty($m_i16_arr)){
            foreach($m_i16_arr as $m_i16_p00){
                if(!empty($m_i16)){
                    $m_i16 .=', ' ;
                }
                 $m_i16 .= pegasus_mysql_printfld('i16', 'p01', 'i16.p00 = ?', array($m_i16_p00));
            }
        }
        $global_data['search_param_m_i16']     = $m_i16;  

        
        // $i16_query = "select p01 from i16 where p00 in (:i16)";
        // $recs = pegasus_query($i16_query, array('i16'=>$this->p85_input['colorsize']));
        // echo pegasus_replace_values_in_sql($i16_query, array('i16'=>$this->p85_input['colorsize']));
        
        //$global_data['search_param_m_i16'] = $this->p85_input['m_i16'];

        return  $global_data;
    }

    protected function getGlobalExpressions(){
        $global_exps = parent::getGlobalExpressions(); 

        //Footer Titles
        $f02_fields = array('ftr001','ftr002','ftr003','ftr004','ftr005','eftr001','eftr002','eftr003','eftr004','eftr005');
        foreach ($f02_fields as $fld) {
            if(peg_substr($fld, 0, 3)=='ftr'){   
                $p01 = (int)peg_substr($fld, -1, 1).'η Γραμμή Footer';
            }elseif(peg_substr($fld, 0, 4)=='eftr'){
                $p01 = (int)peg_substr($fld, -1, 1).'η Γραμμή Footer (EN)';
            }
            $p00  = 'f02_' . $fld;
            $p30  = 'return array("text"=>$pdf->printsData->getData("'.$p00.'"), "autoSizing"=>true);';
            $global_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p02'=>'C', 'p03'=>60); 
        }

        

        // Κριτήρια Αναζήτησης
        $p00 = 'search_param_dt';
        $p30  = 'return array("text"=>$pdf->printsData->getData("'.$p00.'"), "autoSizing"=>true);';
        $global_exps[] = array('p00'=>$p00, 'p01'=>"Υπόλοιπα εώς και", 'p30'=>$p30, 'p02'=>'C', 'p03'=>60); 

        $p00 = 'search_param_p02';
        $p30  = 'return array("text"=>$pdf->printsData->getData("'.$p00.'"), "autoSizing"=>true);';
        $global_exps[] = array('p00'=>$p00, 'p01'=>"Υπόλοιπο από", 'p30'=>$p30, 'p02'=>'C', 'p03'=>60); 

        $p00 = 'search_param_p03';
        $p30  = 'return array("text"=>$pdf->printsData->getData("'.$p00.'"), "autoSizing"=>true);';
        $global_exps[] = array('p00'=>$p00, 'p01'=>"Υπόλοιπο έως", 'p30'=>$p30, 'p02'=>'C', 'p03'=>60); 

        $p00 = 'search_param_m_i16';
        $p30  = 'return array("text"=>$pdf->printsData->getData("'.$p00.'"), "autoSizing"=>true);';
        $global_exps[] = array('p00'=>$p00, 'p01'=>"Αποθηκευτικοί Χώροι", 'p30'=>$p30, 'p02'=>'C', 'p03'=>60); 

        $p00 = 'search_param_colorsize';
        $p30  = 'return array("text"=>$pdf->printsData->getData("'.$p00.'"), "autoSizing"=>true);';
        $global_exps[] = array('p00'=>$p00, 'p01'=>"Εύρεση Ανά Χρώμα / Μέγεθος", 'p30'=>$p30, 'p02'=>'C', 'p03'=>60); 
        
        return $global_exps;
    }

    protected function getBodyExpressions(){

        $body_exps   = array();
        $p30_default = 'getBodyData';

        // εδώ βάζεις τα πεδία της οθόνης που θες να εμφανίσεις ως επιλογή
        $body_fields = array(
			"pno"	=> "pno",
			"name"	=> "name",
			"p01"	=> "p01",
			"p02"	=> "p02",
			"p03"	=> "p03",
			"rp"	=> "rp",
			"op"	=> "op",
            "nr01"	=> "nr01",
            "p9001"	=> "p9001",
            "pp08"	=> "pp08",
            "pp09"	=> "pp09",
            "vpp08"	=> "vpp08",
            "vpp09"	=> "vpp09",
            "i00p01"=> "i00p01",
            "p9000"	=> "p9000",
		);

        $fields_query  = "select p50.p01 as p50_p01, p50.p03 as p50_p03, p51.* from p51 ";
        $fields_query .= "join p50 on p50.p02=p51.p02 ";
        $fields_query .= "where p50.p02 = 'inv_tot_d01' ";
        $fields_query .= "order by p51.desc06, p51.nr01;";
    
        $result = pegasus_query($fields_query);
		while ($p51 = pegasus_fetch_assoc($result)) {

			if (in_array($p51['desc05'], array_keys($body_fields))) {
				$p00 = $body_fields[$p51['desc05']];
			} else {
				continue;
			}

			$p01 = $p51['p50_p03'] . ' -> ' . $p51['desc02'];
			$body_exps[] = array('p00' => $p00, 'p01' => $p01, 'p30' => $p30_default, 'p100' => 1, 'p02' => $p51['desc16'], 'p03' => $p51['desc17'], 'p04' => $p51['desc18']);
		}

		$p00 = 'i24_dek';
		$p01 = 'Μονάδες Μέτρησης Αποθήκης -> Δεκαδικά Ποσότητας';
		$body_exps[] = array('p00' => $p00, 'p01' => $p01, 'p30' => $p30_default, 'p100' => 1, 'p02' => 'N', 'p03' => '2');
		return $body_exps;
    }
}