<?php

/**
 * Μαζική δημιουργία κινήσεων αποθήκης από την τιμή παραμετρικού πεδίου
 *
 * @param integer $p01	Κ.Κ. Χρέωσης
 * @param string $p02	Ημερομηνία Κίνησης
 * @param integer $p03	Αποθήκη
 * @param integer $p04	Αριθμός (1-4)
 * @return array
 */
function peg_invtrans_mass_insert_i01_from_pd3_field(
    $p01 = 0,
    $p02 = '0100-01-01',
    $p03 = 0,
    $p04 = 0
) {
    try {
        $data = array(
            'log'    => array()
        );
        $pd3 = NULL;
        $my_str = 'Από μεταφορά';
        //	Πρέπει να επιλέξετε Αριθμό από 1 έως και 4
        if (
            empty($p04)
            || $p04 < 1
            || $p04 > 4
        ) {
            throw new Exception($_SESSION['peg_dic_invtrans_mass_i01_error_p04_not_set'], 1);
        }
        //	Πρέπει να ορίσετε Υπαρκτό Κωδικό Κίνησης
        if (!(pegasus_mysql_printfld('i15', 'nr01', 'p01=:p01', array('p01' => $p01)) > 0)) {
            throw new Exception($_SESSION['peg_dic_invtrans_mass_i01_error_p01_not_set'], 1);
        }
        //	Πρέπει να ορίσετε υπαρκτή αποθήκη
        if (!(pegasus_mysql_printfld('i16', 'nr01', 'p00=:p00', array('p00' => $p03)) > 0)) {
            throw new Exception($_SESSION['peg_dic_invtrans_mass_i01_error_p03_not_set'], 1);
        }
        //	Πρέπει να ορίσετε Ημερομηνία
        if (
            empty($p02)
            || peg_dateIsEmpty($p02, 'Y-m-d')
            || $p02 <= '0100-01-01'
        ) {
            throw new Exception($_SESSION['peg_dic_invtrans_mass_i01_error_p02_not_set'], 1);
        }
        //	Ορισμός λεκτικού πεδίου
        switch ($p04) {
            case 1:
                $pd3 = "pd30";
                break;
            case 2:
                $pd3 = "pd31";
                break;
            case 3:
                $pd3 = "pd32";
                break;
            case 4:
                $pd3 = "pd33";
                break;
            default:
                throw new Exception($_SESSION['peg_dic_invtrans_mass_i01_error_p04_not_set'], 1);
        }
        //	Τιμές ενημέρωσης για τον i01
        $values = array(
            'my_date'    => $p02,
            'my_kk'        => $p01,
            'my_store'    => $p03,
            'user_pswd'    => $_SESSION['username'],
            'my_str'    => $my_str
        );
        //	Ενημέρωση κινήσεων Αποθήκης 
        $i00_cnt = pegasus_mysql_printfld('i00', 'COUNT(nr01)', $pd3 . ' <> 0');
        $sql = peg_read_file('../invtrans_sql/i00_mass_update_i01_by_pd3_field.sql');
        $sql = str_replace(
            '{{my_fld}}',
            $pd3,
            $sql
        );
        if (!pegasus_query($sql, $values)) {
            throw new Exception(pegasus_mysql_error(), 0);
        }
        $msg = $_SESSION['peg_dic_invtrans_mass_i01_i00_report'];
        $msg = str_replace(
            array("#i00_cnt#", '#my_str#'),
            array($i00_cnt, $my_str),
            $msg
        );
        $data['log'][] = $msg;
        return array(
            'ok'    => 1,
            'error'    => NULL,
            'data'    => $data,
            'msg'    => $_SESSION['peg_dic_invtrans_mass_i01_success_go2log']
        );
    } catch (Exception $e) {
        $msg = $_SESSION['peg_dic_invtrans_mass_i01_error'];
        if ($e->getCode() == 1) {
            $msg = $e->getMessage();
        }
        return array(
            'ok'     => 0,
            'error' => $e->getMessage(),
            'data'  => null,
            'msg'    => $msg
        );
    }
}

function peg_invtrans_i01_d_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '')
{
    $data['readonly'] = 0;
    $data['message'] = '';
    global $PegInput;
	
	$PegInput->addVar(new peg_input_number('rec_copy_nr01'));
	$rec_copy_nr01  = $PegInput->getRequest('rec_copy_nr01');
	$new_rec = false;
	if(!($data['nr01'] > 0)) {
		$new_rec = true;
        $data['nr01'] = pegasus_mysql_newrec('i01');
	}

	if ((!($rec_copy_nr01 > 0)) and $new_rec == 1) {
		//Κατάστημα από ΤΕΡΜΑΤΙΚΟ
		$data['p023'] = $_SESSION['cor003_p104'];
	}

    // it's linked with logi-document
    if ($data['p06'] <> 0 or $data['p07'] <> 0) {
        $data['readonly'] = 1;
        $data['message'] = $data['message'] . $_SESSION['peg_dic_inventory_i01_001'] . '<br>';
    }

    $data['v_pno'] = $data['p01'];
    
    if (peg_dateIsEmpty($data['p013'], 'Y-m-d') and pegasus_mysql_printfld('i01', 'count(*)', 'nr01=:nr01', array('nr01' => $data['nr01'])) == 0) {
        $data['p013'] = date('Y-m-d');
        $data['p013t'] = date('H:i');
    }
    // it's in closed period
    if (
        !(peg_dateToTimeStamp($_SESSION['inventory_000_p101'], 'Y-m-d') <= peg_dateToTimeStamp($data['p013'], 'Y-m-d')
            and
            peg_dateToTimeStamp($data['p013'], 'Y-m-d') <= peg_dateToTimeStamp($_SESSION['inventory_000_p102'], 'Y-m-d'))
    ) {
        $data['readonly'] = 1;
        $peg_tmpstr = $_SESSION['peg_dic_inventory_i01_002'];
        $peg_tmpstr = str_replace('#1#', peg_datetostr($_SESSION['inventory_000_p101'], 'd/m/Y'), $peg_tmpstr);
        $peg_tmpstr = str_replace('#2#', peg_datetostr($_SESSION['inventory_000_p102'], 'd/m/Y'), $peg_tmpstr);
        $data['message'] = $data['message'] . $peg_tmpstr . '<br>';
    }

    //if master the can change but set message
    if (pegasus_check_permission('inventory_master')) {
        $data['readonly'] = 0;
        $data['message'] = $data['message'] . $_SESSION['peg_dic_inventory_i01_003'] . '<br>';
    }


    //set message red
    if ($data['message'] != '') {
        $data['message'] = '<span style="color:red">' . $data['message'] . '</span>';
    }

    if ($_REQUEST['i00_pno']) {
        $data['p01'] = $_REQUEST['i00_pno'];
    }

    return $data;
}

function peg_invtrans_i01_d_on_change($data, $permDeny, $mmnr01, $checkOnlyPerm, $grid_editing) {
    if(substr($mmnr01, 0, 5) == 'a55_d') {
        $mode = "a55";
    }
    if(substr($mmnr01, 0, 5) == 'a56_d') {
        $mode = "a56";
    }
    if(substr($mmnr01, 0, 5) == 'a60_d') {
        $mode = "a60";
    }

    if(pegasus_mysql_table_exists('a90')) {
        invoices_set_a90($mode, $data['p06'], $data['nr01']);
    }

    // Αν ειναι νεα καταχωρηση και ειναι και ελευθερη κινηση
    if(pegasus_mysql_printfld('i01' , 'count(*)' , 'nr01=:nr01' , array('nr01'=> $data['nr01'])) == 0 && $data['p07']==0){
        pegasus_mysql_use("select * from i00 where pno=:pno;" , $i00 , array("pno" => $data['p01']) );
        $data['timh1'] = inventory_find_cost_price($i00['pno'], $data['p610'], $data['p610'], '', $data['p013'], 0 );
        $data['timh2'] = floatval($i00['timh2']);
        $data['timh3'] = floatval($i00['timh3']);
        $data['timh4'] = floatval($i00['timh4']);
    }

    if($grid_editing == 1 && $_REQUEST['peg_tmp_var_context_field'] != ''){
        $ret_array = invoice_check_n_calculate_data_on_gridedit(
            $mode, 
            $data, 
            $permDeny, 
            $_REQUEST['peg_tmp_var_context_field'], 
            $_REQUEST['peg_tmp_var_p07'], 
            $_REQUEST['peg_tmp_var_p05'],
            $_REQUEST['peg_tmp_var_p03'], 
            $_REQUEST['peg_tmp_var_date'], 
            $_REQUEST['peg_tmp_var_kath_fpa'], 
            $_REQUEST['peg_tmp_var_context_originalValue'], 
            $_REQUEST['peg_tmp_var_context_changed_value'],
            $_REQUEST['peg_tmp_var_ser'],
            $_REQUEST['peg_tmp_var_v172'],
            $_REQUEST['peg_tmp_var_v173'],
            $_REQUEST['peg_tmp_var_v161']
        );

        $data  = $ret_array['data'];
        $permDeny  = $ret_array['permDeny'];
    }
    
    $permDeny = peg_invtrans_i01_d_check_values($data, $permDeny, $mmnr01, $checkOnlyPerm);

    //Αν εχει μηδενικες τιμες στο ειδος η τιμη του ειδους γινεται 0
    if($mode == "a60"){
        $invoice_nr01 = substr($mmnr01, 6);
        $zero_prices = invoices_check_if_zero_prices($mode, $invoice_nr01);
        if($zero_prices != 0){
            $data['p04'] = 0;
        }
    }

    if($checkOnlyPerm == 1 && in_array($mode, array("a55", "a56", "a60")) && pegasus_module_exists("invsets")) {
        $where_eidi = pegasusGetGlobalVar('peg_'.$mode.'_d-' . $data['p06'] . '_where_eidi');

        if($mode == "a60") {
            $i01_new_rec = pegasus_mysql_printfld('peg_tmp_i01', 'nr01', $where_eidi['sql'].' AND nr01 = :nr01', array_merge($where_eidi['sqlParams'], array("nr01"=>$data['nr01'])));
            $cnt_i18i01 = pegasus_mysql_printfld('peg_tmp_i01', 'count(*)', $where_eidi['sql'].' AND i18i01 = :nr01', array_merge($where_eidi['sqlParams'], array("nr01"=>$data['nr01'])));
        } else {
            $i01_new_rec = pegasus_mysql_printfld('peg_tmp_i01', 'nr01', $where_eidi.' AND nr01 = :nr01', array("nr01"=>$data['nr01']));
            $cnt_i18i01 = pegasus_mysql_printfld('peg_tmp_i01', 'count(*)', $where_eidi.' AND i18i01 = :nr01', array("nr01"=>$data['nr01']));
        }

        if(
            $i01_new_rec == 0 && 
            empty($data['ppnr01']) &&
            empty($_REQUEST['peg_tmp_var_v172']) &&
            empty($_REQUEST['peg_tmp_var_v173'])
        ) {
            $query_i18 = "SELECT nr01, p02, p03, p04, p05 FROM i18 WHERE p00 = :p01 AND pc01 = :pc01 AND pm01 = :pm01";

            $query_params_i18 = array(
                "p01"  => $data['p01'],
                "pc01" => "",
                "pm01" => ""
            );

            pegasus_mysql_use($query_i18, $res_i18, $query_params_i18);

            if(
                ($mode == "a55" && $res_i18['p03'] == 1) ||
                ($mode == "a56" && $res_i18['p04'] == 1) ||
                ($mode == "a60" && $res_i18['p05'] == 1)
            ) {
                invoices_execute_i18_add_item(
                    $mode, 
                    substr($mmnr01, 6), 
                    $res_i18['nr01'], 
                    $data['nr01'], 
                    $data['p01'], 
                    $data['p03'], 
                    $data['p05'], 
                    $_REQUEST['peg_tmp_var_kath_fpa'], 
                    "", 1, 0
                );

                $data['i19p03'] = $res_i18['p02'];
            }
        } else if($cnt_i18i01 > 0) {
            invoices_execute_i18_update_item($mode, $data['nr01'], $data['p06'], $data['p03'], $data['i19p03']);
        } 
    }

    return array('data' => $data, 'permDeny' => $permDeny);
}
function peg_invtrans_i01_d_on_delete($data, $permDeny, $mmnr01, $checkOnlyPerm)
{
    $peg_tmpmaster = 0;

    //check date
    if (
        !(  peg_dateDiff($_SESSION['inventory_000_p101'], $data['p013'], 'Y-m-d')<=0    &&
            peg_dateDiff($data['p013'], $_SESSION['inventory_000_p102'], 'Y-m-d')<0)
    ) {
        $peg_tmpstr = $_SESSION['peg_dic_inventory_i01_002'];
        $peg_tmpstr = str_replace('#1#', peg_datetostr($_SESSION['inventory_000_p101'], 'd/m/Y'), $peg_tmpstr);
        $peg_tmpstr = str_replace('#2#', peg_datetostr($_SESSION['inventory_000_p102'], 'd/m/Y'), $peg_tmpstr);

        if (pegasus_check_permission('inventory_master')) {
            array_push($permDeny, array('type' => 'confirm', 'message' => $peg_tmpstr  . ' - ' . $data['p013']));
            $peg_tmpmaster = 1;
        } else {
            array_push($permDeny, array('type' => 'deny', 'message' => $peg_tmpstr));
        }
    }
    
    //Αν ειναι συνδεδεμένο με Παραστατικό Προμηθευτή/Πελάτη
    if($data['p07'] == 1 || $data['p07'] == 2){
        if ($data['p07'] == 1) {
            $pweb01 = pegasus_mysql_printfld('a56', 'pweb01', 'nr01=:a56_nr01', array('a56_nr01' => $data['p06']));
            $y_ekd  = 0; // Δεν το εχουμε σε a56
        }else if ($data['p07'] == 2) {
            $pweb01 = pegasus_mysql_printfld('a55', 'pweb01', 'nr01=:a55_nr01', array('a55_nr01' => $data['p06']));
            $y_ekd  = pegasus_mysql_printfld('a55', 'y_ekd', 'nr01=:a55_nr01', array('a55_nr01' => $data['p06']));
        }
        if(!pegasus_check_permission('inventory_master') && $pweb01 == 0 && $y_ekd == 0){
            //Μέσα από οθόνη παραστατικό προμηθευτή / πελάτη
            if (substr($mmnr01, 0, 6) == 'a55_d-' || substr($mmnr01, 0, 6) == 'a56_d-') { 
                $mnr01 = explode('-',$mmnr01)[1];
                if($mnr01 > 0 ){
                    $tbl = substr($mmnr01, 0, 3);
                    $p08 = pegasus_mysql_printfld($tbl , 'p08', 'nr01=:tbl_nr01', array('tbl_nr01' => $mnr01));
                    if ($p08 == 1) {
                        array_push($permDeny, array('type' => 'confirm', 'message' => $_SESSION['peg_dic_inventory_i01_001']));
                    } else if ($p08 === "0") { //διότι το == 0 έπιανε το κενό 
                        array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_inventory_i01_004']));
                    }
                }
            }else{//Απο κινήσεις ειδών  ελέγχεται αν έχει σύνδεση με παραστατικό πελάτη προμηθευτή
                if ($data['p07'] == 1) {
                    $p08 = pegasus_mysql_printfld('a56', 'p08', 'nr01=:a56_nr01', array('a56_nr01' => $data['p06']));
                }else if ($data['p07'] == 2) {
                    $p08 = pegasus_mysql_printfld('a55', 'p08', 'nr01=:a55_nr01', array('a55_nr01' => $data['p06']));
                }
                if ($p08 == 1) {
                    array_push($permDeny, array('type' => 'confirm', 'message' => $_SESSION['peg_dic_inventory_i01_001']));
                } else {
                    array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_inventory_i01_001']));
                }
                 
            }
        }elseif(pegasus_check_permission('inventory_master')){
            array_push($permDeny, array('type' => 'confirm', 'message' => $_SESSION['peg_dic_inventory_i01_001']));
            $peg_tmpmaster = 1;
        }else{
            array_push($permDeny, array('type' => 'confirm', 'message' => $_SESSION['peg_dic_inventory_i01_001']));
            if($pweb01 == 1) {
                array_push($permDeny, array('type' => 'confirm', 'message' => $_SESSION['peg_dic_inventory_i01_005']));
            }
            if($y_ekd == 1) {
                array_push($permDeny, array('type' => 'confirm', 'message' => $_SESSION['peg_dic_inventory_i01_006']));
            }
            $peg_tmpmaster = 0;
        }
    }else{
        array_push($permDeny, array('type' => 'confirm', 'message' => $_SESSION['peg_dic_inventory_i01_001']));
    } 

    //Αν είναι το κύριο είδος της συνταγής, αποσυνδέουμε τα υπο είδη που είναι συνδεδεμένα μαζί του
    if(in_array(substr($mmnr01, 0, 3), array("a55", "a56", "a60"))) {
        $where_eidi = pegasusGetGlobalVar('peg_'.substr($mmnr01, 0, 3).'_d-' . $data['p06'] . '_where_eidi');

        if(substr($mmnr01, 0, 3) == "a60") {
            $product_nr01 = pegasus_mysql_printfld('peg_tmp_i01', 'nr01', $where_eidi['sql'].' AND i18i01 = :nr01', array_merge($where_eidi['sqlParams'], array("nr01"=>$data['nr01'])));
        } else {
            $product_nr01 = pegasus_mysql_printfld('peg_tmp_i01', 'nr01', $where_eidi.' AND i18i01 = :nr01', array("nr01"=>$data['nr01']));
        }

        if($product_nr01 > 0) {
            // array_push($permDeny, array('type' => 'confirm', 'message' => $_SESSION['peg_dic_invoices_main_recipe']));

            if($checkOnlyPerm == 0) {
                if(substr($mmnr01, 0, 3) == "a60") {
                    pegasus_mysql_update("peg_tmp_i01", array("peg_flag", "i18i01"), array(2, 0), $where_eidi['sql']." AND i18i01 = :nr01", 0, 1, 1, array_merge($where_eidi['sqlParams'], array("nr01"=>$data['nr01'])));
                } else {
                    pegasus_mysql_update("peg_tmp_i01", array("peg_flag", "i18i01"), array(2, 0), "$where_eidi AND i18i01 = :nr01", 0, 1, 1, array("nr01"=>$data['nr01']));
                }
                
            }
        }
    }

    // if master and has message then add the priviledge message
    if ($peg_tmpmaster != 0) {
        array_push($permDeny, array('type' => 'confirm', 'message' => $_SESSION['peg_dic_inventory_i01_003']));
    }
    return array($data, $permDeny);
}
/**
 * Ελέγχει αν το παραστατικό έχει επιτρεπτούς τύπους ειδών και αν το είδος του i01 έχει τύπο είδους που ανήκει σε αυτούς
 *
 * @param array $data
 * @param array $permDeny
 * @param string $mmnr01
 * @param boolean $checkOnlyPerm
 * @return array
 */
function invtrans_i01_check_i10(
    $data = array(),
    $permDeny = array(),
    $mmnr01 = '',
    $checkOnlyPerm = false
) {

    $_d = explode('-', $mmnr01)[0];
    $nr01 = explode('-', $mmnr01)[1];
    $p05_table = false;
    $ax_table = false;
    switch ($_d) {
        case 'a55_d':
            $p05_table = 'a55';
            $ax_table = 'a10';
            break;
        case 'a57_d':
            $p05_table = 'a57';
            $ax_table = 'a10';
            break;
        case 'a56_d':
            $p05_table = 'a56';
            $ax_table = 'a11';
            break;
        case 'a67_d':
            $p05_table = 'a67';
            $ax_table = 'a11';
            break;
        default:
            $p05_table = false;
    }
    //  Η parent οθόνη Δεν ανήκει στις υποστηριζόμενες οθόνες
    if (!$p05_table) {
        return $permDeny;
    }
    $p05 = pegasusGetGlobalVar('peg_' . $p05_table . '_d-' . $nr01 . '_p05');
    $p32 = pegasus_mysql_printfld($ax_table, 'p32', 'p01=:p01', array('p01' => $p05));
    $p32 = explode('#', $p32);
    //  Το παραστατικό δεν έχει επιτρεπτούς τύπους ειδών (επιτρέπονται όλοι)
    if (count($p32) < 3) {
        return $permDeny;
    }
    array_pop($p32);
    array_shift($p32);
    // Τύπος Είδους αυτού του i01
    $i00_p62 = pegasus_mysql_printfld('i00', 'p62', 'pno=:pno', array('pno' => $data['p01']));
    //  Το Είδος έχει τύπο είδους και δεν είναι μέσα στους επιτρεπτούς 
    if (!in_array($i00_p62, $p32)) {
        $msg = $_SESSION['peg_dic_invtrans_i01_check_i10_fail'];
        $msg = str_replace(
            array("#i10_p02#", "#i00_pno#", "#ax_p02#"),
            array(
                pegasus_mysql_printfld('i10', 'p02', "p01=:p01", array('p01' => $i00_p62)),
                $data['p01'],
                pegasus_mysql_printfld($ax_table, 'p02', 'p01=:p01', array('p01' => $p05))
            ),
            $msg
        );
        array_push($permDeny, array('type' => 'deny', 'message' => $msg));
    }
    return $permDeny;
}

function peg_invtrans_i01_d_check_values($data, $permDeny, $mmnr01, $checkOnlyPerm)
{
   
    $peg_tmpmaster = 0;
    //check date
    if (
        !(  peg_dateDiff($_SESSION['inventory_000_p101'], $data['p013'], 'Y-m-d')<=0    &&
            peg_dateDiff($data['p013'], $_SESSION['inventory_000_p102'], 'Y-m-d')<0)
    ) {
        $peg_tmpstr = $_SESSION['peg_dic_inventory_i01_002'];
        $peg_tmpstr = str_replace('#1#', peg_datetostr($_SESSION['inventory_000_p101'], 'd/m/Y'), $peg_tmpstr);
        $peg_tmpstr = str_replace('#2#', peg_datetostr($_SESSION['inventory_000_p102'], 'd/m/Y'), $peg_tmpstr);
        if (pegasus_check_permission('inventory_master') /*$_SESSION['inventory_is_master']*/) {
            array_push($permDeny, array('type' => 'confirm', 'message' => $peg_tmpstr));
            $peg_tmpmaster = 1;
        } else {
            array_push($permDeny, array('type' => 'deny', 'message' => $peg_tmpstr));
        }
    }
    // if master and has message then add the priviledge message
    if ($peg_tmpmaster != 0) {
        array_push($permDeny, array('type' => 'confirm', 'message' => $_SESSION['peg_dic_inventory_i01_003']));
    }

    $i00 = array();
    $mode = substr($mmnr01, 0, 3);

    pegasus_mysql_use("select * from i00 where pno=? ", $i00, array($data['p01']));

    if ($mode == 'a55' or $mode == 'a56') {
        if(!($i00['nr01'] > 0)) {
            array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_invoices_i00_not_exists']));
        }
    }

    $permDeny = invtrans_i01_check_i10($data, $permDeny, $mmnr01, $checkOnlyPerm);
    
    $permDeny = invoices_check_min_price($mode, $data, $permDeny, $mmnr01);
    if ($data['p04'] > 0) {
        $invoice_nr01 = substr($mmnr01, 6);
        $zero_prices = invoices_check_if_zero_prices($mode, $invoice_nr01);
        if ($zero_prices) {
            $data['p04'] = 0;
            //array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_invoices_zero_prices_en']));
        }
    }

    /*Δεν επιτρέπεται ελεύθερη καταχώρηση χρώματος μεγέθους ή serial-ούτε μπορείς να αλλάξεις παλιές κινήσεις*/
    if ((substr($mmnr01, 0, 5) == 'i01_d') &&
        (pegasus_module_exists('colorsize') || pegasus_module_exists('serial'))
    ) {
        if (
            pegasus_module_exists('colorsize') &&
            (pegasus_mysql_printfld('i47', 'count(*)',  'i00=?', array($i00['nr01'])) > 0)
        ) {
            array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_invtrans_i01_cs']));
        }
        if (pegasus_module_exists('serial') && ($i00['ps01'] != 0)) {
            array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_invtrans_i01_serial']));
        }
        if (pegasus_module_exists('lot') && ($i00['p904'] != 0)) {
            array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_lot_i01_lot']));
        }
    }

    if (substr($mmnr01, 0, 5) == 'i01_d') {
        if(empty($data['p05'])) {
            array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_invtrans_i01_p05']));
        }
        if($data['p303'] == 0) {
            if(pegasus_mysql_printfld('i16', 'count(*)', 'p00 = ?', array($data['p610'])) == 0) {
                array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_invtrans_i01_p610']));
            }
        }
    }

    //Αν ειναι συνταγη, καινουριο record και peg_tmp προχωραμε. Αυτο γίνεται για να μην παρουμε error στο retail
    //Δεν μας ενδιαφέρει αν είναι ή οχι συνταγή, διότι την πρώτη φορά θέλουμε να περνάει το είδος με serial ή lot ανεξάρτητα αν έχει το είδος συνταγή. 
    if($checkOnlyPerm == 1 && $mode == 'a55') {
        $where_eidi = pegasusGetGlobalVar('peg_'.$mode.'_d-' . $data['p06'] . '_where_eidi');
        $peg_tmp_i01_nr01_exists = pegasus_mysql_printfld('peg_tmp_i01', 'nr01', $where_eidi.' AND nr01 = :nr01', array("nr01"=>$data['nr01']));

        if($peg_tmp_i01_nr01_exists == 0) {
            return  $permDeny;
        }
    }

    // Έλεγχος για τα σύνολα ποσοτήτων των παρτίδων που έχουν επιλεγεί σε αυτό το είδος.
    if($mode == 'a55' || $mode == 'a56' || $mode == 'a60') {
        if(pegasus_module_exists('lot') && $i00['p904'] == 1 && $data['ppnr01'] == 0) {
            // ERROR 1
            $tmp_i38_p04_sum = pegasus_mysql_printfld(
                'peg_tmp_i38',
                'SUM(p04)',
                '
                        peg_tmp_i38.p010=:p010 AND
                        peg_tmp_i38.p01=:p01 AND
                        peg_mnr01=:peg_mnr01 AND 
                        peg_mmnr01=:peg_mmnr01 AND 
                        peg_sess_id=:peg_sess_id AND 
                        peg_flag!=9 AND
                        pnr01=:pnr01
                    ',
                array(
                    'p01'         =>  $data['nr01'],
                    'p010'        =>  1,
                    'pnr01'       =>  0,
                    'peg_mmnr01'  =>  $mmnr01,
                    'peg_mnr01'   =>  $data['nr01'],
                    'peg_sess_id' =>  session_id()
                )
            );
			// Ε: 10000308
            // Αν έχουμε παρτίδες και ισχύει ο έλεγχος ποσότητας στις παρτίδες
            if(
				$_SESSION['f02_p637'] == 1
				&& $data['p03'] != 0 
				&& $tmp_i38_p04_sum != $data['p03']
			) {
                $message = $_SESSION['peg_dic_lot_a58_gt_quan'];
                $message = str_replace('##i00.name##', $i00['name'], $message);
                array_push($permDeny, array('type' => 'deny', 'message' => $message));
            }
        }

        if(pegasus_module_exists('serial') && $i00['ps01'] == 1 && $data['ppnr01'] == 0) {
            $printfld_where = ' 	p01= :p01 and  
                                    peg_mmnr01=:peg_mmnr01 and  
                                    peg_mnr01=:peg_mnr01 and 
                                    peg_flag!=:peg_flag and 
                                    peg_sess_id=:peg_sess_id ';
            $printfld_where_vals = array(
                'p01'         => $data['p01'],
                'peg_mmnr01'  => $mmnr01,
                'peg_mnr01'   => $data['nr01'],
                'peg_flag'    => '9',
                'peg_sess_id' => session_id()
            );
            $gnt_sn = pegasus_mysql_printfld('peg_tmp_i32', 'count(*)', $printfld_where, $printfld_where_vals);
            if ($gnt_sn > $data['p03']) {
                array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_serial_a58_gt_quan']));
            }

            if ($_SESSION['f02_pg905'] == 1 && $gnt_sn != $data['p03']) {
                array_push($permDeny, array('type' => 'deny', 'message' => str_replace('##i00_name##',   $i00['name'], $_SESSION['peg_dic_serial_a58_lt_quan'])));
            }
            if ($_SESSION['f02_pg905'] == 2 && $gnt_sn != $data['p03']) {
                array_push($permDeny, array('type' => 'deny', 'message' => str_replace('##i00_name##',   $i00['name'], $_SESSION['peg_dic_serial_a58_lt_quan_invoices'])));
            }
        }
    }
    
    return  $permDeny;
}

function peg_invtrans_i01_d90_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '')
{
    
    global $PegInput;
    $PegInput->addVar(new peg_input_alphanumeric('peg_t_log'));

    $item = $PegInput->getRequest('peg_t_log');

    if (!empty($item)) {
        $data['item'] = $item;
        $data['invtrans_i01_d90_item_readonly'] = 1;
    } else {
        $data['invtrans_i01_d90_item_readonly'] = 0;
    }
    //var_dump($data['item']);
    invtrans_i51_d00_grid01_set_where($data, $container_id);

    return $data;
}

function peg_invtrans_i01_d100_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '') {
    if ($_d == 'i01_d100') {
        if (!empty($_REQUEST['peg_t_log'])) {
            $data['t_lo'] = $_REQUEST['peg_t_log'];
            $data['invtrans_i01_d100_t_lo_readonly'] = 1;
        } else {
            $data['invtrans_i01_d100_t_lo_readonly'] = 0;
        }

        $i00_nr01 = pegasus_mysql_printfld('i00', 'nr01', 'pno=?', array($data['t_lo']));
        if ($i00_nr01 > 0) {
            $service_only = pegasusGetGlobalVar('peg_' . $i00_nr01 . '_service_only');
        }

        if ($service_only == 1) {
            $data['t_ka_hidden'] = 1;

            //$data['{module}_{_d}_{tab fld name}_{custom_id}_hidden']
            $data['invtrans_i01_d100_tab_i01_d1001_id_hidden'] = true; //tab Κινήσεις
            $data['invtrans_i01_d100_tab_i01_d1003_id_hidden'] = true; //tab Προμηθευτές
            $data['invtrans_i01_d100_tab_i01_d1004_id_hidden'] = true; //tab Ελάχιστα - Μέγιστα ανά Αποθηκευτικο
        }

        if (empty($data['t_df'])) {
            $data['t_df'] = date('Y-m-d', mktime(0, 0, 0, 1, 1, date('Y')));
        }
    }
    $data['invtrans_i01_d1001_grid01_invtrans_relation_hidden'] = false;
    $data['invtrans_i01_d1006_grid01_invtrans_relation_hidden'] = false;

    $data['t_dt'] = date('Y-m-d');
    invtrans_i01_d100_set_grid_query('i01_d1001', $data, $container_id); // Κινήσεις
    invtrans_i01_d100_set_grid_query('i01_d1006', $data, $container_id); // Αγορές
    invtrans_i01_d100_set_grid_query('i01_d1002', $data, $container_id); // Πελάτες
    invtrans_i01_d100_set_grid_query('i01_d1003', $data, $container_id); // Προμηθευτές

    invtrans_i51_d00_grid01_set_where($data, $container_id);

    return $data;
}

function invtrans_i01_d100_set_grid_query($_d, $data, $container_id) {
    $i01_d100_sqlParams = array(
        'tmp_lo' =>  $data['t_lo'],
        'tmp_dt' =>  $data['t_dt'],
        'tmp_df' =>  $data['t_df'],
        'tmp_ka1' =>  $data['t_ka1'],
        'tmp_ka2' =>  $data['t_ka2']
    );

    $t_ka = explode('#', $data['t_ka']);
    array_pop($t_ka);
    array_shift($t_ka);

    $i16_p00_in = pegasus_mysql_create_in($t_ka, 'i16_p00');

    $i16_p00 = "";
    if(!empty($i16_p00_in['sql'])) {
        $i16_p00 = "AND i01.p610 in (".$i16_p00_in['sql'].")";
    }

    $i01_d100_sqlParams = array_merge($i16_p00_in['sqlParams'], $i01_d100_sqlParams);

    if ($_d == 'i01_d1001') {
        //exists t00?
        $tmp_ext00 = 0;
        if (pegasus_mysql_table_exists('t00')) {
            $tmp_ext00 = 1;
        }
        $repl_array = array(
            "##peg_dic_invtrans_i01_001##" => $_SESSION['peg_dic_invtrans_i01_001']
        );
        if ($tmp_ext00 == 1) {
            $repl_array['##fld_p02##'] = "if(i01.p0601='' ,  ifnull(t00.p02, ifnull(i12.p02, '')) , i01.p0601) as p02, ";
            $repl_array['##t00_join##'] = "LEFT JOIN t00 ON t00.p01=i01.p014";
        } else {
            $repl_array['##fld_p02##'] = "if(i01.p0601='' , ifnull(i12.p02, '') , i01.p0601) as p02, ";
            $repl_array['##t00_join##'] = "";
        }

        $fld_p014  = '';
        $extra_select = '';
        if (pegasus_module_exists('invoices')) {
            if (pegasus_module_exists('invcust')) {
                $fld_p014 .= ' when i01.p07="2" then (select concat(a10.p00, " ", a55.p701, " ", a55.p06)
                                      from a55,a10 where a10.p01=a55.p05 and a55.nr01=i01.p06) ';
            }
            if (pegasus_module_exists('invsupp')) {
                $fld_p014 .= ' when i01.p07="1" then (select concat(a11.p00, " ", a56.p701, " ", a56.p06)
                                       from a56,a11 where a11.p01=a56.p05 and a56.nr01=i01.p06) ';
            }
            if (pegasus_module_exists('invtrans00')) {
                $fld_p014 .= ' when i01.p07="3" then (select concat(a30.p00, " ", a60.p701, " ", a60.p06)
                                      from a60,a30 where a30.p01=a60.p05 and a60.nr01=i01.p06) ';
            }
            $extra_select =  'IF(
                        /**pegasus_start_module_invcust**/ 
                        i01.p07="2",a55.p702,
                         /**pegasus_end_module_invcust**/
                         -- pegasus_module_not_exists_invcust 1=0,"",
                         IF(/**pegasus_start_module_invsupp**/
                             i01.p07="1",a56.p702,
                             /**pegasus_end_module_invsupp**/
                             -- pegasus_module_not_exists_invsupp 1=0,"",
                             IF(/**pegasus_start_module_invtrans00**/
                                 i01.p07="3",a60.p702,
                                 /**pegasus_end_module_invtrans00**/
                                 -- pegasus_module_not_exists_invtrans00 1=0,"",
                                 ""))) as v_p702';
            $extra_join = "
                        /**pegasus_start_module_invcust**/ 
                         LEFT JOIN a55 ON (a55.nr01= i01.p06 AND i01.p07='2')
                         /**pegasus_end_module_invcust**/
                         /**pegasus_start_module_invsupp**/
                         LEFT JOIN a56 ON (a56.nr01= i01.p06 AND i01.p07='1')
                         /**pegasus_end_module_invsupp**/
                         /**pegasus_start_module_invtrans00**/
                         LEFT JOIN a60 ON (a60.nr01= i01.p06 AND i01.p07='3')
                        /**pegasus_end_module_invtrans00**/
                        ";
            if (!pegasus_module_exists('invcust')) {
                $extra_select = str_replace('-- pegasus_module_not_exists_invcust', '', $extra_select);
                $extra_select = peg_invtrans_replace_text_inside_tags("/**pegasus_start_module_invcust**/", "/**pegasus_end_module_invcust**/", $extra_select);
                $extra_join = peg_invtrans_replace_text_inside_tags("/**pegasus_start_module_invcust**/", "/**pegasus_end_module_invcust**/", $extra_join);
            }
            if (!pegasus_module_exists('invsupp')) {
                $extra_select = str_replace('-- pegasus_module_not_exists_invsupp', '', $extra_select);
                $extra_select = peg_invtrans_replace_text_inside_tags("/**pegasus_start_module_invsupp**/", "/**pegasus_end_module_invsupp**/", $extra_select);
                $extra_join = peg_invtrans_replace_text_inside_tags("/**pegasus_start_module_invsupp**/", "/**pegasus_end_module_invsupp**/", $extra_join);
            }
            if (!pegasus_module_exists('invtrans00')) {
                $extra_select = str_replace('-- pegasus_module_not_exists_invtrans00', '', $extra_select);
                $extra_select = peg_invtrans_replace_text_inside_tags("/**pegasus_start_module_invtrans00**/", "/**pegasus_end_module_invtrans00**/", $extra_select);
                $extra_join = peg_invtrans_replace_text_inside_tags("/**pegasus_start_module_invtrans00**/", "/**pegasus_end_module_invtrans00**/", $extra_join);
            }
        }

        if (pegasus_module_exists('courier00')) {
            $fld_p014 .= ' when i01.p07 in ("20","21") then (select r18.p01 from r18 where r18.nr01=i01.p06) ';
        }
        if (empty($fld_p014)) {
            $repl_array['##fld_p014##'] = '""';
        } else {
            $repl_array['##fld_p014##'] = '(case ' . $fld_p014 . ' else "" end)';
        }

        //query 
        $i01_d1001_sql = "SELECT tabl01.*, (@sum := @sum + ifnull(tabl01.p04,0)-ifnull(tabl01.p07,0)) as p09 
                        FROM ( 
                            /***********************
                                    prev totals 
                            ***********************/
                            (select 0 as nr01, 
                                    cast('00000000' as date) as p01, 
                                    '' as p01t,
                                    if(t00.p02='' or t00.p02 is null, '##peg_dic_invtrans_i01_001##', t00.p02) as t00_p02,
                                    '##peg_dic_invtrans_i01_001##' as p02, 
                                    '' as p03, 
                                    i01.p04 as i01_p04,
                                    sum(round(i01.p012 * i01.p03  * i15.p03, f01.p08)) as p04, 
                                    sum(round(i01.p012 * i01.p011 * i15.p05, 2)) as p05, 
                                    sum(round(i01.p012 * i01.p022 * i15.p05, 2)) as p06, 
                                    sum(round(i01.p012 * i01.p03  * i15.p04, f01.p08)) as p07, 
                                    sum(round(i01.p012 * i01.p011 * i15.p06, 2)) as p08, 

                                    sum(round(i01.p012 * i01.p03  * i15.p03 * if(i15.p101=0, 1, 0), f01.p08)) as p04_no_internal, 
                                    sum(round(i01.p012 * i01.p011 * i15.p05 * if(i15.p101=0, 1, 0), 2))       as p05_no_internal, 
                                    sum(round(i01.p012 * i01.p03  * i15.p04 * if(i15.p101=0, 1, 0), f01.p08)) as p07_no_internal, 
                                    sum(round(i01.p012 * i01.p011 * i15.p06 * if(i15.p101=0, 1, 0), 2))       as p08_no_internal,

                                    sum(round(i01.p012 * i01.p03  * i15.p03 * if(i15.p101=0, 0, 1), f01.p08)) as p04_internal, 
                                    sum(round(i01.p012 * i01.p011 * i15.p05 * if(i15.p101=0, 0, 1), 2))       as p05_internal, 
                                    sum(round(i01.p012 * i01.p03  * i15.p04 * if(i15.p101=0, 0, 1), f01.p08)) as p07_internal, 
                                    sum(round(i01.p012 * i01.p011 * i15.p06 * if(i15.p101=0, 0, 1), 2))       as p08_internal,

                                    round(i01.p010 + i01.p010a * ((100 - i01.p010) / 100), 3) as discounts,

                                    0  as p010, 
                                    0  as p011, 
                                    0  as p012, 
                                    0  as p013,
            						'' as p014,
                                    '' as v_p702,
                                    sum(round(i01.p011  / IF(i01.p03=0, 1, i01.p03) , 2)) AS p015,
                                    sum(round(i01.fp011  / IF(i01.p03=0, 1, i01.p03) , 2)) AS p016,
                                    sum(round((i01.p012 * i01.p022 * i15.p05) / IF(i01.p03=0, 1, i01.p03) , 2)) AS p017
                        
                            FROM i01
                            LEFT JOIN i12 ON i12.p01=i01.p07
                            LEFT JOIN i15 ON i15.p01=i01.p05
                            LEFT JOIN t00 ON t00.p01=i01.p014
                            LEFT JOIN f01 ON f01.nr01=1
                            WHERE i01.p01=:tmp_lo
                              AND i01.p013<:tmp_df
                              $i16_p00
                            GROUP BY i01.p01
                            )	  
                            union ALL 
                            /**************************
                                all transactions
                            **************************/    
                            (select i01.nr01 as nr01, 
                                    i01.p013 as p01,
                                    i01.p013t as p01t,
                                    t00.p02 as t00_p02,
                                    ##fld_p02## 
                                    '' as p03, 
                                    i01.p04 as i01_p04,
                                    round(i01.p012 * i01.p03  * i15.p03, f01.p08) as p04, 
                                    round(i01.p012 * i01.p011 * i15.p05, 2) as p05, 
                                    round(i01.p012 * i01.p022 * i15.p05, 2) as p06, 
                                    round(i01.p012 * i01.p03  * i15.p04, f01.p08) as p07, 
                                    round(i01.p012 * i01.p011 * i15.p06, 2) as p08,

                                    round(i01.p012 * i01.p03  * i15.p03 * if(i15.p101=0, 1, 0), f01.p08) as p04_no_internal, 
                                    round(i01.p012 * i01.p011 * i15.p05 * if(i15.p101=0, 1, 0), 2)       as p05_no_internal, 
                                    round(i01.p012 * i01.p03  * i15.p04 * if(i15.p101=0, 1, 0), f01.p08) as p07_no_internal, 
                                    round(i01.p012 * i01.p011 * i15.p06 * if(i15.p101=0, 1, 0), 2)       as p08_no_internal,

                                    round(i01.p012 * i01.p03  * i15.p03 * if(i15.p101=0, 0, 1), f01.p08) as p04_internal, 
                                    round(i01.p012 * i01.p011 * i15.p05 * if(i15.p101=0, 0, 1), 2)       as p05_internal, 
                                    round(i01.p012 * i01.p03  * i15.p04 * if(i15.p101=0, 0, 1), f01.p08) as p07_internal, 
                                    round(i01.p012 * i01.p011 * i15.p06 * if(i15.p101=0, 0, 1), 2)       as p08_internal,

                                    round(i01.p010 + i01.p010a * ((100 - i01.p010) / 100), 3) as discounts,

                                    i01.p05 as p010, 
                                    i01.p610 as p011,
                                    round(i01.p012 * i01.p03  * i15.p05 * if(i15.p102=1, 0, 1), f01.p08) as p012, 
                                    round(i01.p012 * i01.p03  * i15.p06 * if(i15.p102=1, 0, 1), f01.p08) as p013,
                                    ##fld_p014## as p014,
                                    " . $extra_select . ",                   
                                    round(i01.p011  / IF(i01.p03=0, 1, i01.p03) , 2) as p015,
                                    round(i01.fp011  / IF(i01.p03=0, 1, i01.p03) , 2) as p016,
                                    round((i01.p012 * i01.p022 * i15.p05) / IF(i01.p03=0, 1, i01.p03) , 2) as p017   
                                                    

                            FROM i01
                            LEFT JOIN i12 ON i12.p01=i01.p07
                            LEFT JOIN i15 ON i15.p01=i01.p05
                            ##t00_join##
                            LEFT JOIN f01 ON f01.nr01=1
                            " . $extra_join . "
                            WHERE i01.p01=:tmp_lo
                              AND i01.p013>=:tmp_df
                              AND i01.p013<=:tmp_dt
                              $i16_p00
            	            ORDER BY i01.p013, i01.remfdate, i01.remftime
            	            )
                        ) as tabl01
                        ORDER BY tabl01.p01 , tabl01.nr01";

        $i01_d1001_sql = str_replace(array_keys($repl_array), array_values($repl_array), $i01_d1001_sql);

        // peg_write_file('../../tmp/t1_'.$container_id.'.sql', pegasus_replace_values_in_sql($i01_d1001_sql,$i01_d100_sqlParams));

        pegasusSetGlobalVar(
            'peg_' . $container_id . '_grid_query_d1001',
            array(
                'sql' => $i01_d1001_sql,
                'sqlParams' => $i01_d100_sqlParams
            )
        );
    } else if ($_d == 'i01_d1006') {
        if(pegasus_module_exists('account')) {
            $i01_d1006_sql = "SELECT nr01, 
                                     pn01,
                                     pn02,
                                     p013,
                                     p03,
                                     p04,
                                     vp04,
                                     p041,
                                     p616, 
                                     p610,
                                     p022,
                                     p014,
                                     vp014
                            FROM (
                                SELECT  i01.nr01   as nr01,  
                                        i01.pn01   as pn01, 
                                        i01.pn02   as pn02, 
                                        i01.p013   as p013,
                                        i01.p03    as p03, 
                                        i01.p04    as p04, 
                                        if(i01.p03<>0, i01.p022/i01.p03, 0) as vp04,
                                        i01.p041   as p041, 
                                        i01.p616   as p616, 
                                        i01.p610   as p610, 
                                        i01.p022   as p022,
                                        i01.p014   as p014, 
                                        i01.p05    as p05,
                                        i01.p06    as p06,
                                        i01.p07    as p07,
                                        t00.p02    as vp014
                                FROM i15, i01
                                LEFT JOIN t00 ON t00.p01=i01.p014
                                WHERE i01.p05   = i15.p01 
                                  AND i15.p05   > 0  
                                  AND i15.p101  = 0  
                                  AND i01.p012 >= 0
                                  AND i01.p01   = :tmp_lo
                                  AND i01.p013 >= :tmp_df
                                  AND i01.p013 <= :tmp_dt
                                  $i16_p00
                                  AND i01.p07   = '1'       
                                ORDER BY i01.p013 DESC, i01.nr01 desc 
                            ) as tt;";

            pegasusSetGlobalVar(
                'peg_' . $container_id . '_grid_query_d1006',
                array(
                    'sql' => $i01_d1006_sql,
                    'sqlParams' => $i01_d100_sqlParams
                )
            );
        }
    } else if ($_d == 'i01_d1002') {
        if (pegasus_module_exists('invcust')) {
            $i01_d1002_sql = "SELECT nr01, p00,p01,p02,sum(p04) as p04,min(p05) as p05,max(p05) as p06,sum(p07) as p07,sum(p08) as p08, CAST( ROUND(sum(p04) *1.00 / sum(p08), 2) AS FLOAT) as p09
                from (
                	select i01.nr01 as nr01,
                            d00.nr01 as p00,
                            a01.nr01 as p01,
                            a01.p19 as p02,
                            round(i01.p012 * i01.p011 * i15.p06, 2) as p04,
                  			i01.p013 as p05,
                            round(i01.p012 * i01.p03  * i15.p03, f01.p08) as p07,
                            round(i01.p012 * i01.p03  * i15.p04, f01.p08) as p08
                	from i01 
                	join a55 on a55.nr01=i01.p06
                	join a01 on a01.nr01=a55.p03
                	join f01 ON f01.nr01=1
                	left join d00 on d00.nr01=a01.pnr01
                 	left join i15 ON i15.p01=i01.p05
                	WHERE i01.p01=:tmp_lo
                      AND i01.p013>=:tmp_df
                      AND i01.p013<=:tmp_dt
                      AND i01.p07='2'
                      $i16_p00
                ) as tt
                group by p00 ";

            pegasusSetGlobalVar(
                'peg_' . $container_id . '_grid_query_d1002',
                array(
                    'sql' => $i01_d1002_sql,
                    'sqlParams' => $i01_d100_sqlParams
                )
            );
        }
    } else if ($_d == 'i01_d1003') {

        if (pegasus_module_exists('invsupp')) {
            $i01_d1003_sql = "SELECT nr01, p00,p01,p02,sum(p04) as p04,min(p05) as p05,max(p05) as p06,sum(p07) as p07,sum(p08) as p08, CAST( ROUND(sum(p04) *1.00 / sum(p07), 2) AS FLOAT) as p09
                from (
                    select i01.nr01 as nr01,
                            d00.nr01 as p00,
                            a00.nr01 as p01,
                            a00.p19 as p02,
                            round(i01.p012 * i01.p011 * i15.p05, 2) as p04,
                            i01.p013 as p05,
                            round(i01.p012 * i01.p03  * i15.p03, f01.p08) as p07,
                            round(i01.p012 * i01.p03  * i15.p04, f01.p08) as p08
                    from i01 
                    join a56 on a56.nr01=i01.p06
                    join a00 on a00.nr01=a56.p03
                    join f01 ON f01.nr01=1
                    left join d00 on d00.nr01=a00.pnr01
                    left join i15 ON i15.p01=i01.p05
                    WHERE i01.p01=:tmp_lo
                      AND i01.p013>=:tmp_df
                      AND i01.p013<=:tmp_dt
                      AND i01.p07='1'
                      $i16_p00
                ) as tt
                group by p00";

            pegasusSetGlobalVar(
                'peg_' . $container_id . '_grid_query_d1003',
                array(
                    'sql' => $i01_d1003_sql,
                    'sqlParams' => $i01_d100_sqlParams
                )
            );
        }
    }
}
function peg_invtrans_i01_d1005_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = ''){

    $tbl_nr01       = $_REQUEST['tbl_nr01'];
    $mode           = $_REQUEST['mode'];
    $data['p_df']   = date('Y-m-01');
    $data['p_dt']   = date('Y-m-d');

    if(!empty($_REQUEST['p_col'])){
        $data['p_col'] = $_REQUEST['p_col'];
    }
    $data['invtrans_i01_d10051_grid_invtrans_view_relation_hidden'] = false;

    if (pegasus_module_exists('stores')) {
        if (function_exists('peg_stores_get_all_stores_multi')) {
            $data['p_kat'] = peg_stores_get_all_stores_multi(1);
        }
    }

    if (function_exists('peg_inventory_get_all_i16_multi')) {
        $data['p_apoth'] = peg_inventory_get_all_i16_multi();
    }

    switch ($mode) {
        case 'a01':
            pegasusSetGlobalVar(
                'peg_' . $container_id . '_a01_select_where',
                array(
                    'sql' => 'a71_00.p601=:var_a01',
                    'sqlParams' => array('var_a01' => $tbl_nr01)
                )
            );
            $data['p_log'] = pegasus_mysql_printfld('a01', 'p21', 'nr01=:tbl_nr01', array('tbl_nr01' => $tbl_nr01));
            $data['p_ypo_a76_hidden'] = 1;

            break;
        case 'a00':
            pegasusSetGlobalVar(
                'peg_' . $container_id . '_a00_select_where',
                array(
                    'sql' => 'a76_00.p601=:var_a00',
                    'sqlParams' => array('var_a00' => $tbl_nr01)
                )
            );
            $data['p_log'] = pegasus_mysql_printfld('a00', 'p21', 'nr01=:tbl_nr01', array('tbl_nr01' => $tbl_nr01));
            $data['p_ypo_a71_hidden'] = 1;

            break;
        default:
            break;
    }

    invtrans_i01_d10051_set_grid_query($mode, $data, $container_id);
    invtrans_i01_d10052_set_grid_query($mode, $data, $container_id);

    return $data;
}

function invtrans_i01_d10051_set_grid_query($mode, $datas, $container_id){

    $peg_str          = "";
    $i01_d1005_params = array();

    switch ($mode) {
        case 'a01':
            if (pegasus_module_exists('invcust')) {
                $peg_str = '&& (ifnull(a55.p04, 0)=:np_ypo || :np_ypo="")';
                $i01_d1005_params['np_ypo'] = $datas['p_ypo_a71'];
            }
            break;
        case 'a00':
            if (pegasus_module_exists('invsupp')) {
                $peg_str = '&& (ifnull(a56.p04, 0)=:np_ypo || :np_ypo="")';
                $i01_d1005_params['np_ypo'] = $datas['p_ypo_a76'];
            }
            break;
        default:
            break;
    }

    if (pegasus_module_exists('stores') && !empty($datas['p_kat'])) {
		$peg_str  .= " AND locate(concat('#', i01.p023, '#'), :tmp_kat)>0 ";
		$i01_d1005_params['tmp_kat'] = $datas['p_kat'];
	}

    if (!empty($datas['p_apoth'])) {
		$peg_str  .= " AND locate(concat('#', i01.p610, '#'), :tmp_apoth)>0 ";
		$i01_d1005_params['tmp_apoth'] = $datas['p_apoth'];
	}

    $i01_d10051_query = peg_read_file('../invtrans_sql/i01_d1005.sql');
    $i01_d10051_query = str_replace('/*peg_str*/', $peg_str, $i01_d10051_query);
    $i01_d10051_query = pegasus_replace_modules_exists_tags($i01_d10051_query);
    $i01_d1005_params['log'] = $datas['p_log'];
    $i01_d1005_params['from_date'] = $datas['p_df'];
    $i01_d1005_params['to_date'] = $datas['p_dt'];
    $i01_d1005_params['i00_pno'] = $datas['p_col'];

    pegasusSetGlobalVar(
        $container_id . '_grid_query_d10051',
        array(
            'sql' => $i01_d10051_query,
            'sqlParams' => $i01_d1005_params
        )
    );

    //echo pegasus_replace_values_in_sql($i01_d10051_query, $i01_d1005_params);  

}
function invtrans_i01_d10052_set_grid_query($mode, $datas, $container_id){
    
    $peg_str          = "";
    $i01_d1005_params = array();

    switch ($mode) {
        case 'a01':
            if (pegasus_module_exists('invcust')) {
                $peg_str = '&& (ifnull(a55.p04, 0)=:np_ypo || :np_ypo="")';
                $i01_d1005_params['np_ypo'] = $datas['p_ypo_a71'];
            }
            break;
        case 'a00':
            if (pegasus_module_exists('invsupp')) {
                $peg_str = '&& (ifnull(a56.p04, 0)=:np_ypo || :np_ypo="")';
                $i01_d1005_params['np_ypo'] = $datas['p_ypo_a76'];
            }
            break;
        default:
            break;
    }


    if (pegasus_module_exists('stores') && !empty($datas['p_kat'])) {
		$peg_str  .= " AND locate(concat('#', i01.p023, '#'), :tmp_kat)>0 ";
		$i01_d1005_params['tmp_kat'] = $datas['p_kat'];
	}

    if (!empty($datas['p_apoth'])) {
		$peg_str  .= " AND locate(concat('#', i01.p610, '#'), :tmp_apoth)>0 ";
		$i01_d1005_params['tmp_apoth'] = $datas['p_apoth'];
	}

    $i01_d10052_query = "SELECT i01.p01    as p01,  
                                i00.name    as p02,  
                              sum(i01.p03 * i15.p03 * i01.p012) as poseis,  
                              sum(i01.p03 * i15.p04 * i01.p012) as posex,  
                              sum(i01.p03 * i15.p05 * i01.p012) as tposeis,  
                              sum(i01.p03 * i15.p06 * i01.p012) as tposex,  
                              sum(i01.p011 * i15.p05 * i01.p012) as axeis,  
                              sum(i01.p011 * i15.p06 * i01.p012) as axex  
                       FROM i00, i15, i01
                       /**pegasus_start_module_invcust
                            LEFT JOIN a55 ON a55.nr01=i01.p06 && i01.p07=2
                       pegasus_end_module_invcust**/
                        /**pegasus_start_module_invsupp
                            LEFT JOIN a56 ON a56.nr01=i01.p06 && i01.p07=1
                       pegasus_end_module_invsupp**/
                       WHERE i01.p014=:log
                          && i01.p013>=:from_date
                          && i01.p013<=:to_date
                          && i01.p01=i00.pno
                          && i01.p05=i15.p01
                          && (i01.p01=:i00_pno || :i00_pno='') 
                          ##peg_str##
                       GROUP BY i01.p01;";

    $i01_d10052_query = str_replace('##peg_str##', $peg_str, $i01_d10052_query);
    $i01_d10052_query = pegasus_replace_modules_exists_tags($i01_d10052_query);

    $i01_d1005_params['log'] = $datas['p_log'];
    $i01_d1005_params['from_date'] = $datas['p_df'];
    $i01_d1005_params['to_date'] = $datas['p_dt'];
    $i01_d1005_params['i00_pno'] = $datas['p_col'];

    pegasusSetGlobalVar(
        $container_id . '_grid_query_d10052',
        array(
            'sql' => $i01_d10052_query,
            'sqlParams' => $i01_d1005_params
        )
    );

    //echo pegasus_replace_values_in_sql($i01_d10052_query, $i01_d1005_params);  
}

function invtrans_i51_d00_grid01_set_where($data, $container_id){
    if(pegasus_module_exists('invprices00')){
        //var_dump($data['item']);
        $_i51_d_where = array(    'sql'   => 'i51.p01=:var_i51_p01 and 
                                            ((i51.p06 <> i51.p08) or
                                             (i51.p05 <> i51.p07))',
                                'sqlParams' => array(   'var_i51_p01'   =>  $data['item']
                            ));
        //var_dump($_i51_d_where);
        pegasusSetGlobalVar('peg_' . $container_id . '_i51_d_where', $_i51_d_where );
    }
}

/*TODO: Να φτιάξουμε την invtrans_recalc_i00tot να υπολογίζει τις δεσμευμένες
            ποσότητες από τα νέα πεδία a58.p703, a58.p591 , a68.p703 κλπ*/
function invtrans_recalc_i00tot()
{

    $log = 'Recalculate i00tot' . chr(13) . chr(10);
    $message   = '';
    $peg_error = 0;

    //delete data   
    $query = "delete from i00tot;";
    $res   = pegasus_query($query);
    if (!$res) {
        $log .= '--Delete i00tot error ' . pegasus_mysql_error();
        $peg_error += 1;
    }

    //$log .= $query;
    //set p75.nr01 to 0
    $query = "update p75 set p010=0 where p01='i00tot';";
    $res   = pegasus_query($query);
    if (!$res) {
        $log .= '--Set p75.p010=0 error ' . pegasus_mysql_error();
        $peg_error += 1;
    }
    //$log .= $query;

    $query = "set @_i = '0';";
    $res   = pegasus_query($query);
    if (!$res) {
        $log .= " \n --set @_i = 0 error " . pegasus_mysql_error();
        $peg_error += 1;
    }

    //$log .= $query;

    //update i00tot
    $query = "INSERT INTO i00tot (nr01, pno1, p610, p03, remdate, remtime, remfdate, remftime)

                  SELECT @_i:=@_i+1 AS nr01, 
                          pno1,
                          p610,
                          p03,
                          curdate() as remdate, curtime() as remtime , curdate() as remfdate, curtime() as remftime
                          FROM
                         (
                             SELECT i01.p01 as pno1,
                                    i01.p610 as p610,
                                    sum( (i15.p03-i15.p04) * i01.p03 * i01.p012) as p03
                            FROM i01, i15
                            WHERE i01.p05=i15.p01
                            GROUP BY i01.p01, i01.p610 ) as tt;";
    $res = pegasus_query($query);
    if (!$res) {
        $log .= '--Update i00tot error ' . pegasus_mysql_error();
        $peg_error += 1;
    }

    //If Customers Orders , recalculate Orders Tot   
    if (pegasus_mysql_table_exists('a58') and pegasus_module_exists('ordercust') and pegasus_mysql_table_field_exists('a58','p591')) {
        //update p04 A
        // $query = "UPDATE i00tot 
        //           SET p04=0,
        //               remdate=curdate(), 
        //               remtime=curtime();";
        // $res = pegasus_query($query);
        // if(!$res){
        //     $log.='--Update i00tot from Customers Orders error '. pegasus_mysql_error();
        //     $peg_error += 1;
        // }


        //update p04 B
        // $query = "UPDATE i00tot 
        //           SET nr01=peg_new_nr01('i00tot', 1), 
        //               remdate=curdate(), 
        //               remtime=curtime()
        //           WHERE nr01=0;";   
        // $res = pegasus_query($query);
        // if(!$res){
        //     $log.='--Update i00tot from Customers Orders set new NR01 error '. pegasus_mysql_error();
        //     $peg_error += 1;
        // }

        //update p04 C - update current records
        $query = "UPDATE i00tot, 
                       (select a58.v101 as pno1,
                           if(a58.vapcl1=1, a58.vapc1, a57.p703) as p610,
                           sum(a58.v103-a58.v109) as p04
                        FROM a57, a58 
                        WHERE a58.p00=a57.nr01
                           && a58.v103>a58.v109
                           && a58.p00=a57.nr01
                           && a58.p591=0
                        GROUP BY a58.v101, if(a58.vapcl1=1, a58.vapc1, a57.p703)) as tbl01
                    SET i00tot.p04=tbl01.p04, 
                        i00tot.remdate=curdate(), 
                        i00tot.remtime=curtime()
                    WHERE i00tot.pno1=tbl01.pno1
                       && i00tot.p610=tbl01.p610;";
        $res = pegasus_query($query);
        if (!$res) {
            $log .= '--Update i00tot from Customers Orders - Current Records error ' . pegasus_mysql_error();
            $peg_error += 1;
        }

        //$log .= $query;

        // $query = "select @_i:=max(nr01) from i00tot;";
        // $res   = pegasus_query($query);
        // if(!$res){
        //     $log.='--select @_i:=max(nr01) from i00tot; error '. pegasus_mysql_error();
        //     $peg_error += 1;
        // }

        // //$log .= $query;

        //update p04 D - insert new records
        $query = "insert into i00tot (nr01, pno1, p610, p04, remdate, remtime, remfdate, remftime)

                        SELECT @_i:=@_i+1 AS nr01, 
                        pno1,
                        p610,
                        p04,
                        curdate() as remdate, curtime() as remtime , curdate() as remfdate, curtime() as remftime
                        FROM
                        (
                            select
                                    a58.v101 as pno1,
                                    if(a58.vapcl1=1, a58.vapc1, a57.p703) as p610,
                                    sum(a58.v103-a58.v109) as p04
                            FROM a58 
                            LEFT JOIN a57 ON a58.p00=a57.nr01
                            LEFT JOIN i00tot ON i00tot.pno1=a58.v101
                                            && i00tot.p610=if(a58.vapcl1=1, a58.vapc1, a57.p703)
                            WHERE a57.nr01 is not null
                                && a58.v103>a58.v109
                                && a58.p00=a57.nr01
                                && a58.p591=0
                                && i00tot.nr01 is null
                                GROUP BY a58.v101, if(a58.vapcl1=1, a58.vapc1, a57.p703)
                         ) as tt;";
        $res = pegasus_query($query);
        if (!$res) {
            $log .= '--Update i00tot from Customers Orders  - Insert New Records error ' . pegasus_mysql_error();

            $peg_error += 1;
        }
        //$log .= $query;
    }


    //If Suppliers Orders , recalculate Orders Tot 
    if (pegasus_mysql_table_exists('a68') and pegasus_module_exists('ordersupp')  and pegasus_mysql_table_field_exists('a68','p591')) {
        //update p05 A 
        // $query = "UPDATE i00tot 
        //           SET p05=0,
        //               remdate=curdate(), 
        //               remtime=curtime();";
        // $res = pegasus_query($query);
        // if(!$res){
        //     $log.='--Update i00tot from Suppliers Orders error '. pegasus_mysql_error();
        //     $peg_error += 1;
        // }

        // //update p05 B     
        // $query = "UPDATE i00tot 
        //           SET nr01=peg_new_nr01('i00tot', 1), 
        //               remdate=curdate(), 
        //               remtime=curtime()
        //           WHERE nr01=0;";   
        // $res = pegasus_query($query);
        // if(!$res){
        //     $log.='--Update i00tot from Suppliers - set new NR01 '. pegasus_mysql_error();
        //     $peg_error += 1;
        // }

        //update p05 C - update current records
        $query = "UPDATE i00tot, 
                         (select a68.v101 as pno1,
                             if(a68.vapcl1=1, a68.vapc1, a67.p703) as p610,
                             sum(a68.v103-a68.v109) as p05
                          FROM a67, a68 
                          WHERE a68.p00=a67.nr01
                             && a68.v103>a68.v109
                             && a68.p00=a67.nr01
                             && a68.p591=0
                          GROUP BY a68.v101, if(a68.vapcl1=1, a68.vapc1, a67.p703)) as tbl01
                      SET i00tot.p05=tbl01.p05, 
                          i00tot.remdate=curdate(), 
                          i00tot.remtime=curtime()
                      WHERE i00tot.pno1=tbl01.pno1
                         && i00tot.p610=tbl01.p610;";
        $res = pegasus_query($query);
        if (!$res) {
            $log .= '--Update i00tot from Suppliers - Current Records error ' . pegasus_mysql_error();
            $peg_error += 1;
        }

        //$log .= $query;

        //update p05 D - insert new records     
        $query = "insert into i00tot (nr01, pno1, p610, p05, remdate, remtime, remfdate, remftime)

                        SELECT @_i:=@_i+1 AS nr01, 
                        pno1,
                        p610,
                        p05,
                        curdate() as remdate, curtime() as remtime , curdate() as remfdate, curtime() as remftime
                        FROM
                        (
                            select 
                                    a68.v101 as pno1,
                                    if(a68.vapcl1=1, a68.vapc1, a67.p703) as p610,
                                    sum(a68.v103-a68.v109) as p05
                            FROM a68 
                            LEFT JOIN a67 ON a68.p00=a67.nr01
                            LEFT JOIN i00tot ON i00tot.pno1=a68.v101
                                            && i00tot.p610=if(a68.vapcl1=1, a68.vapc1, a67.p703)
                            WHERE a67.nr01 is not null
                                && a68.v103>a68.v109
                                && a68.p00=a67.nr01
                                && a68.p591=0
                                && i00tot.nr01 is null
                            GROUP BY a68.v101, if(a68.vapcl1=1, a68.vapc1, a67.p703)
                        ) as tt;";
        $res = pegasus_query($query);
        if (!$res) {
            $log .= '--Update i00tot from Suppliers Insert new records error ' . pegasus_mysql_error();
            $peg_error += 1;
        }

        //$log .= $query;

    }

    //If internal Orders , recalculate Orders Tot 
    if (pegasus_mysql_table_exists('a62') and pegasus_module_exists('interorder') ) {

        //update p06 A
        // $query = "UPDATE i00tot 
        //           SET p06=0,
        //               remdate=curdate(), 
        //               remtime=curtime();";
        // $res = pegasus_query($query);
        // if(!$res){
        //     $log.='--Update i00tot from a62 error '. pegasus_mysql_error();
        //     $peg_error += 1;
        // }

        // //update p06 B
        // $query = "UPDATE i00tot 
        //           SET nr01=peg_new_nr01('i00tot', 1), 
        //               remdate=curdate(), 
        //               remtime=curtime()
        //           WHERE nr01=0;";
        // $res = pegasus_query($query);
        // if(!$res){
        //     $log.='--Update i00tot from a62 - set new nr01 error '. pegasus_mysql_error();
        //     $peg_error += 1;
        // }

        //update p06 C - update current records (p06)
        $query = "UPDATE i00tot, 
                         (select a62.v101 as pno1,
                             if(a62.vapcl1=1, a62.vapc1, a61.p03) as p610,
                             sum(a62.v103-a62.v109) as p06
                          FROM a61, a62 
                          WHERE a62.p00=a61.nr01
                             && a62.v103>a62.v109
                             && a62.p00=a61.nr01
                             && a62.p591=0
                          GROUP BY a62.v101, if(a62.vapcl1=1, a62.vapc1, a61.p03)) as tbl01
                      SET i00tot.p06=tbl01.p06, 
                          i00tot.remdate=curdate(), 
                          i00tot.remtime=curtime()
                      WHERE i00tot.pno1=tbl01.pno1
                         && i00tot.p610=tbl01.p610;";
        $res = pegasus_query($query);
        if (!$res) {
            $log .= '--Update i00tot from a62 - Current Records error ' . pegasus_mysql_error();
            $peg_error += 1;
        }

        //$log .= $query;

        //update p06 D - insert new records  
        $query = "insert into i00tot (nr01, pno1, p610, p06, remdate, remtime, remfdate, remftime)

                        SELECT @_i:=@_i+1 AS nr01, 
                        pno1,
                        p610,
                        p06,
                        curdate() as remdate, curtime() as remtime , curdate() as remfdate, curtime() as remftime
                        FROM
                        (
                            select 
                                    a62.v101 as pno1,
                                    if(a62.vapcl1=1, a62.vapc1, a61.p03) as p610,
                                    sum(a62.v103-a62.v109) as p06
                            FROM a62 
                            LEFT JOIN a61 ON a62.p00=a61.nr01
                            LEFT JOIN i00tot ON i00tot.pno1=a62.v101
                                            && i00tot.p610=if(a62.vapcl1=1, a62.vapc1, a61.p03)
                            WHERE a61.nr01 is not null
                                && a62.v103>a62.v109
                                && a62.p00=a61.nr01
                                && a62.p591=0
                                && i00tot.nr01 is null
                            GROUP BY a62.v101, if(a62.vapcl1=1, a62.vapc1, a61.p03)
                        )as tt;";
        $res = pegasus_query($query);
        if (!$res) {
            $log .= '--Update i00tot from a62 - insert new records error ' . pegasus_mysql_error();
            $peg_error += 1;
        }

        //Update p07 [A] - update current records
        $query = "UPDATE i00tot, 
                        (select a62.v101 as pno1,
                            if(a62.vapcl2=1, a62.vapc2, a61.p04) as p610,
                            sum(a62.v103-a62.v109) as p07
                        FROM a61, a62 
                        WHERE a62.p00=a61.nr01
                            && a62.v103>a62.v109
                            && a62.p00=a61.nr01
                            && a62.p591=0
                        GROUP BY a62.v101, if(a62.vapcl2=1, a62.vapc2, a61.p04)) as tbl02
                    SET i00tot.p07=tbl02.p07, 
                        i00tot.remdate=curdate(), 
                        i00tot.remtime=curtime()
                    WHERE i00tot.pno1=tbl02.pno1 && i00tot.p610=tbl02.p610;";
        $res = pegasus_query($query);
        if (!$res) {
            $log .= '--Update i00tot from a62 - Current Records error (p07)' . pegasus_mysql_error();
            $peg_error += 1;
        }

        //Update p07 [B] - insert new records
        $query = "insert into i00tot (nr01, pno1, p610, p07, remdate, remtime, remfdate, remftime)

                        SELECT @_i:=@_i+1 AS nr01, 
                        pno1,
                        p610,
                        p07,
                        curdate() as remdate, curtime() as remtime , curdate() as remfdate, curtime() as remftime
                        FROM
                        (
                            select 
                                    a62.v101 as pno1,
                                    if(a62.vapcl2=1, a62.vapc2, a61.p04) as p610,
                                    sum(a62.v103-a62.v109) as p07
                            FROM a62 
                            LEFT JOIN a61 ON a62.p00=a61.nr01
                            LEFT JOIN i00tot ON i00tot.pno1=a62.v101
                                            && i00tot.p610=if(a62.vapcl2=1, a62.vapc2, a61.p04)
                            WHERE a61.nr01 is not null
                                && a62.v103>a62.v109
                                && a62.p00=a61.nr01
                                && a62.p591=0
                                && i00tot.nr01 is null
                            GROUP BY a62.v101, if(a62.vapcl2=1, a62.vapc2, a61.p04)
                        ) as tt;";
        $res = pegasus_query($query);
        if (!$res) {
            $log .= '--Update i00tot from a62 - insert new records error (p07)' . pegasus_mysql_error();
            $peg_error += 1;
        }


        //$log .= $query;
    }


    //p75 tot
    $query = "	UPDATE p75 
            SET p010=@_i , 
                remdate=curdate(), 
                remtime=curtime()
            WHERE p01='i00tot';";

    $res = pegasus_query($query);
    if (!$res) {
        $log .= '--Update p75 error ' . pegasus_mysql_error();
        $peg_error += 1;
    }
    //$log .= $query;

    return array('log' => $log, 'peg_error' => $peg_error);
}

function peg_invtrans_i01_d100_grids_custom_actions_peg002()
{
    $peg_handler = "invtrans_i01_d100_custom_actions(screen.getContainer_ID());";
    return array(array(
        'xtype' => 'pegasusToolBarGridAction',
        'peg_custom_id' => 'invtrans_relation',
        'icon' => 'invtrans_images/i01_relation_16x16.png',
        'text' =>  $_SESSION['peg_dic_invtrans_show_relation'],
        'peghandler' => $peg_handler,
        'viewModel' => array(
            'type' => 'GridButtonModel',
            'isToolBar' => 1,
            'data' => array('toolBarButton' => 'invtrans_relation')
        )
    ));
}

function peg_invtrans_replace_text_inside_tags($tag_start, $tag_end, $input_string, $text = '')
{
    $start_index = strpos($input_string, $tag_start);
    $end_index   = strpos($input_string, $tag_end);
    while ($start_index !== false) {
        $input_string   = str_replace(substr($input_string, $start_index, $end_index + strlen($tag_end) - $start_index), $text, $input_string);
        $start_index    = strpos($input_string, $tag_start);
        $end_index      = strpos($input_string, $tag_end);
    }
    return $input_string;
}

function peg_invtrans_inv_tot_d_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '')
{
    // αποθηκευτικοί χώροι
    $data['m_i16'] = peg_inventory_get_all_i16_multi();

    // Εύρεση ανά Χρώμα/Μέγεθος
    if(!pegasus_module_exists('colorsize')){
        $data['colorsize_hidden'] = 1;
    }else{
        $data['colorsize'] = 1;
    }

    $data['dt'] = date('Y-m-d');
    $data['p01'] = 1;
    $data['p02'] = -99999999999.999;
    $data['p03'] = 99999999999.999;
    $data['p04'] = 1;

    invtrans_inv_tot_d_set_grid_query($container_id , $data);

    return $data;
}

function invtrans_inv_tot_d_set_grid_query($container_id, $data){

    if($data['colorsize']==0){
        $query = peg_read_file('../invtrans_sql/i00p301.sql');
    }else if($data['colorsize']==1 && pegasus_module_exists('colorsize')){
        $query = peg_read_file('../invtrans_sql/i00p301_cs.sql');

    }


    if(pegasus_module_exists('invsite')){
        $replace_array = array(
            '/*##invsite_color_size_select##*/'      => ' t1.p9907 as v_p9907,
                                               t1.selectbox_v_p9907  as v_selectbox_v_p9907, ',
            '/*##invsite_color_size_union##*/'      => ' ,i49.p01  as p9907,
                                                i49.p02  as selectbox_v_p9907 ',
            '/*##invsite_color_size_join##*/' => ' LEFT JOIN i49 ON i49.p01=i00.p9907'
    );
        $query =  str_replace(
                array_keys($replace_array),
                array_values($replace_array),
                $query);
    }else{
        $replace_array = array(
            '/*##invsite_color_size_select##*/'      => " '' as v_p9907,
                                                          ''  as v_selectbox_v_p9907, ",
            '/*##invsite_color_size_union##*/'       => '',
            '/*##invsite_color_size_join##*/'        => ''
    );
        $query =  str_replace(
                array_keys($replace_array),
                array_values($replace_array),
                $query);
    }
    

    if(function_exists('pegasus_replace_modules_exists_tags')){
        $query = pegasus_replace_modules_exists_tags($query);
    }
    
    $inv_tot_d_params = array();

    $inv_tot_d_params['date'] = $data['dt'];
    $inv_tot_d_params['nt_yp1'] = $data['p02'];
    $inv_tot_d_params['nt_yp2'] = $data['p03'];

    // χώροι
    $i16_in = explode('#', $data['m_i16']);
    foreach ($i16_in as $key => $value) {
        if($value==''){
            unset($i16_in[$key]);
        }
    }
    
	$in_stmt = pegasus_mysql_create_in($i16_in, 'i16');

    $inv_tot_d_params = array_merge($inv_tot_d_params, $in_stmt['sqlParams']);

    $where = " IN (" . $in_stmt['sql'] . ")";
    $query = str_replace(array('{{i16}}'), array($where), $query);

    // Να μην εμφανίσει όσα έχουν Υπόλοιπο 0
    if($data['p01']==1){
        $zero = ' && t2.p01<>0 ';
        $query = str_replace(array('{{zero}}'), array($zero), $query);
    }else{
        $query = str_replace(array('{{zero}}'), array(''), $query);  
    }

    //echo pegasus_replace_values_in_sql($query, $inv_tot_d_params);

    pegasusSetGlobalVar(
        'peg_'.$container_id.'_grid_query', 
        array(
            'sql' =>$query,
            'sqlParams'=>$inv_tot_d_params
        )
    );
}

/**
 * Εισάγει στο παραστατικό - Παραγγελία τα δεδομένα και τα ειδή τα οποία επέλεξε ο χρήστης στο grid των υπολοίπων.
 * Δημιουργεί εκτός από τα ίδιο και τους βοηθητικούς πίνακες (peg_tmp_) για τα χρώματα μέγεθος serial number και παρτίδα
 *
 * @param string $dest_table	Πίνακες Αναφοράς (ο πινάκας που συνδέεται το παραστατικό ή η Παραγγελία)
 * @param array  $data          Το array  δεδομένων του παραστατικού ή της παραγγελίας (από to αντίστοιχο initialize function)
 * @param string $inv_tot_d_container_id    Το container id της οθόνης inv_tot_d
 * @param int    $p04                       Καταχώρηση μόνο των ειδών με θετικό υπόλοιπο (ckeckbox της inv_tot_d)
 * @return array $data	        Το ίδιο array με τα δεδομένα που έχει προσθέσει ή αλλάξει
 * 
 * @example #dest_table= 	a55 / a56 / a60 / a57 / a67 / a61
 */
function invtrans_inv_tot_d_import_data($dest_table = '', $data = array(),  $inv_tot_d_container_id = '', $p04 = null){
    $i00_arr = json_decode(pegasusGetGlobalVar('invtrans' . '_' . $inv_tot_d_container_id . '_i00_arr'), true);
    
    // Γενικός έλεγχος υποστηριζόμενων πινάκων 
	if(!in_array($dest_table, array('a55', 'a56', 'a60', 'a57', 'a67', 'a61'))) {
		return $data;
	}

	$peg_mmnr01 = $dest_table . '_d-' . $data['nr01'];

	if(in_array($dest_table, array('a55', 'a57'))) {        // Πελάτη
		$p07_flag = 2;
        $p03_table = 'a01';
        $p03_invoice = $data['p03'];
        $p703 = $data['p703'];
	} else if(in_array($dest_table, array('a56', 'a67'))) { // Προμηθευτή
		$p07_flag = 1;
        $p03_table = 'a00';
        $p03_invoice = $data['p03'];
        $p703 = $data['p703'];
	} else if(in_array($dest_table, array('a60', 'a61'))) { // Εσωτερική
		$p07_flag = 3;
        $p03_table = '-';
        $p03_invoice = 0;
        $p703 = $data['p03'];
	}

    //Prepare peg_tmp_i01
	foreach($i00_arr as $i00_record){
        // Έλεγχος για Καταχώρηση μόνο των ειδών με θετικό υπόλοιπο
        if($p04==1 && $i00_record['p01']<=0){
            continue;
        }

        $i00_p9908 = pegasus_mysql_printfld("i00", "p9908", "pno = :pno", array("pno" => $i00_record['pno']));
		$p0601 = '';

		$price_array = inventory_find_price(
			$i00_record['pno'], // Κωδικός Είδους
			$p03_invoice,       // Κωδικός Πελάτη / Προμηθευτή
			$i00_record['p01'], // Υπόλοιπο
			date('Y-m-d'),      // Ημερομηνία
			$data['p09'],       // Καθεστώς ΦΠΑ 
			$p03_table,         // a01 / a00 / -
			$data['p07'],       // Τιμές με ΦΠΑ
			$p703               // Αποθήκη 1
		);

        
        $timi_monadas = $price_array['price'];      // Τιμή Μονάδας
        $discount_1   = $price_array['discount_1']; // Έκτπωση 1
        $discount_2   = $price_array['discount_2']; // Έκτπωση 2
        $kfpa         = $price_array['kfpa'];       // Κατηγορία ΦΠΑ
        $fpa          = $price_array['fpa'];        // % ΦΠΑ

		$line_item_nr01 = 0;

		//	Αποθήκη (Παραστατικό)
		if (in_array($dest_table, array('a55', 'a56', 'a60'))) {
            $line_items_table = 'i01';

			// Set parent nr01 for i01
			$line_item_nr01 = pegasus_mysql_newrec('i01');

			$peg_tmp_line_item_insert = array(
				'nr01'  => $line_item_nr01,     // M.K.
                'p01'   => $i00_record['pno'],  // Eίδος αποθήκης
				'p02'   => $i00_record['name'], // Περιγραφή
				'p06'   => $data['nr01'],		// M.K. Σχετικής Κίνησης
				'p07'   => $p07_flag,			// Κωδ.Κατηγορίας Κίνησης
                'p013'  => date('Ymd'),		    // Ημ/νία
				'p03'   => $i00_record['p01'],  // Ποσότητα
				'p04'   => $timi_monadas,		// Τιμή Μονάδας
                'p010'  => $discount_1,	        // % Έκπτωσης 1
                'p010a' => $discount_2,	        // % Έκπτωσης 2
                'p081'  => $kfpa,	            // Κωδικός Κατηγορίας ΦΠΑ
                'p08'   => $fpa,		        // % ΦΠΑ
				'p0601' => $p0601,			    // Αιτιολογία
				'p308'  => $i00_p9908,	        // Κωδ.Είδους Συσκευασίας
                'p610'  => -1,                  // Αποθηκευτικός Χώρος: Προκαθορισμένο

				'peg_flag'    => 1,
				'peg_mmnr01'  => $peg_mmnr01,
				'peg_mnr01'   => $data['nr01'],
				'peg_sess_id' => session_id()

			);
			pegasus_mysql_insert('peg_tmp_'. $line_items_table, array_keys($peg_tmp_line_item_insert), array_values($peg_tmp_line_item_insert));
		}
		//	Παραγγελία
		if (in_array($dest_table, array('a57', 'a67', 'a61'))) {
			$line_items_table = '';
			switch ($dest_table) {
				case 'a57':
					$line_items_table = 'a58';
					break;
				case 'a67':
					$line_items_table = 'a68';
					break;
				case 'a61':
					$line_items_table = 'a62';
					break;
			}

			$line_item_nr01 = pegasus_mysql_newrec($line_items_table);

			$peg_tmp_line_item_insert = array(
				'nr01'  => $line_item_nr01,    // M.K.
				'p00'   => $data['nr01'],	   // Μ.Κ.Παραγγελίας
				'v101'  => $i00_record['pno'], // Eίδος αποθήκης
				'v102'  => $i00_record['name'],// Περιγραφή
				'v103'  => $i00_record['p01'], // Ποσότητα
				'v104'  => $timi_monadas,	   // Τιμή Μονάδας
				'v160'  => $p0601,			   // Αιτιολογία
				'v308'  => $i00_p9908,	       // Κωδ.Είδους Συσκευασίας
                'v106'  => $discount_1,	       // % Έκπτωσης 1
                'v106a' => $discount_2,	       // % Έκπτωσης 2
                'v108'  => $kfpa,	           // Κωδικός Κατηγορίας ΦΠΑ
                'v105'  => $fpa,		       // % ΦΠΑ
                'v107'  => invoices_make_product_total($i00_record['p01'], $timi_monadas, $fpa, floatval($discount_1), floatval($discount_2), 0, 0, $data['p07']),		                

				'peg_flag'    => 1,
				'peg_mmnr01'  => $peg_mmnr01,
				'peg_mnr01'   => $data['nr01'],
				'peg_sess_id' => session_id()
			);

            // Αποθηκευτικός Χώρος: Προκαθορισμένο
            if(in_array($dest_table, array('a57', 'a67'))) {
                $peg_tmp_line_item_insert['p703'] = -1;
            } else {
                $peg_tmp_line_item_insert['p03'] = -1;
                $peg_tmp_line_item_insert['p04'] = -1;
            }
                
			pegasus_mysql_insert('peg_tmp_' . $line_items_table, array_keys($peg_tmp_line_item_insert), array_values($peg_tmp_line_item_insert));
		}
		// Colorsize (i48)
		if($i00_record['pp08'] != '' && $i00_record['pp09'] != '' && pegasus_module_exists('colorsize')) {
            invoices_add_colorsize($peg_mmnr01, $dest_table, $line_item_nr01, $i00_record['pno'], $i00_record['pp08'], $i00_record['pp09'], $i00_record['p01']);
		}
	}

    if(empty($line_items_table)){
        $data = array();
		$data['permDeny'] = 1;
		$data['permDenyMessage'] = $_SESSION['peg_dic_invtrans_items_not_found'];
		return $data;
    }

    // Υπολογισμός Συνόλων

    $product_where = array(
		'sql' => " peg_mnr01=:mnr01 
					and peg_mmnr01=:mmnr01
					and peg_sess_id=:session 
					and peg_flag!=9 ",

		'sqlParams' => array(
			'mnr01' => $data['nr01'],
			'mmnr01' => $peg_mmnr01,
			'session' => session_id(), 
		)
	);

    $a01_p09 = $data['p09']; //Καθεστώς ΦΠΑ
	$preview_with_vat = $data['p07']; //Με ΦΠΑ
	$p0101   = $data['p0101']; //Ποσοστό έκπτωσης
	$date    = $data['p01']; //Ημερομηνία

	$p0103   = 0; //Δεν χρησιμοποιείται κάπου στην συνάρτηση invoices_calculate_total το πεδίο
	$p0112   = 0; //Ποσοστό κράτησης
	$p0113   = 0; //Ποσοστό Φόρου
	$p0108   = 0; //Επιβαρύνσεις
	$p410    = 0; //Τα σύνολα δεν υπολογίζονται αυτόματα
	$p506	 = 0; //Δωροεπιταγη
	$p0102_1 = 0; //Εκπτ προ ΦΠΑ
	$p0102_2 = 0; //Εκπτ στο σύνολο
	$p01080	 = 0;

	$_totals = array();
	$_totals['p201'] = $data['p201'];
	$_totals['p202'] = $data['p202'];
	$_totals['p203'] = $data['p203'];
	$_totals['p204'] = $data['p204'];
	$_totals['p205'] = $data['p205'];
	$_totals['p206'] = $data['p206'];
	$_totals['p207'] = $data['p207'];
	$_totals['p208'] = $data['p208'];
	$_totals['p209'] = $data['p209'];

	$_totals['p301'] = $data['p301'];
	$_totals['p302'] = $data['p302'];
	$_totals['p303'] = $data['p303'];
	$_totals['p304'] = $data['p304'];
	$_totals['p305'] = $data['p305'];
	$_totals['p306'] = $data['p306'];
	$_totals['p307'] = $data['p307'];
	$_totals['p308'] = $data['p308'];
	$_totals['p309'] = $data['p309'];

	$return_array = invoices_calculate_total(
		'peg_tmp_' . $line_items_table,
		$product_where,
		$p0101,
		$p0112,
		$p0113,
		$p0103,
		$p0108,
		$a01_p09,
		$preview_with_vat,
		$p410,
		$_totals,
		$p506,
		$p0102_1,
		$p0102_2,
		$p01080,
		$dest_table,
		$date
	);
	foreach ($return_array as $key => $value) {
		$data[$key] = $value;
	}

    return $data;
}

function peg_invtrans_inv_anap_d_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '')
{
    // αποθηκευτικοί χώροι
    $data['m_i16'] = peg_inventory_get_all_i16_multi();
    //$data['i16'] = -1;

    // Κινήσεις από-έως
    $data['dt'] = date('Y-m-d');
    $data['dt2'] = date('Y-m-d');

    // Υπολογίζει και τις Εσωτερικές Διακινήσεις (checkbox)
    $data['esed'] = 1;
    // Εμφανίζει όλα όσα έχουν κίνηση (checkbox)
    $data['kin'] = 1;
    // Παραγγελίες Πελατών (checkbox)
    if(!pegasus_module_exists('ordercust')){
        $data['ppe_hidden'] = 1;
    }else{
        $data['ppe'] = 1;
    }

    // Παραγγελίες Προμηθευτών (checkbox)
    if(!pegasus_module_exists('ordersupp')){
        $data['ppr_hidden'] = 1;
    }else{
        $data['ppr'] = 1;
    }
    
    // Εσωτερικές Παραγγελίες (checkbox)
    if(!pegasus_module_exists('interorder')){
        $data['pes_hidden'] = 1;
    }else{
        $data['pes'] = 1;
    }

    // Υπόλοιπα Ειδών (checkbox)
    $data['ypol'] = 1;
    // Ελάχιστο Ειδών (checkbox)
    $data['elax'] = 1;

    // Ελάχιστο/Μέγιστο από Στοιχεία Ανά Χώρο (checkbox)
    $data['anx'] = 0;

    // Εύρεση ανά Χρώμα/Μέγεθος (checkbox)
    if(!pegasus_module_exists('colorsize')){
        $data['colorsize_hidden'] = 1;
    }else{
        $data['colorsize'] = 0;
    }

    // Υπόλοιπο Από/Έως
    $data['min_ypol'] = -99999999999;
    $data['max_ypol'] = 99999999999;

    $data['p06'] = 0;

    $cost_res = invtrans_inv_anap_d_set_grid_query($container_id , $data);
    $data['p04'] = $cost_res['p04'];
    $data['p05'] = $cost_res['p05'];

    return $data;
}

function invtrans_inv_anap_d_set_grid_query($container_id, $data){

    
    if($data['colorsize']==0){
        $query = peg_read_file('../invtrans_sql/i00p01011.sql');
        if(function_exists('pegasus_replace_modules_exists_tags')){
            $query = pegasus_replace_modules_exists_tags($query);
        }
        
    }else if($data['colorsize']==1 && pegasus_module_exists('colorsize')){
        $query = peg_read_file('../invtrans_sql/i00p01011.sql');
        $query_cl = peg_read_file('../invtrans_sql/i00p01011_cs.sql');
        if(function_exists('pegasus_replace_modules_exists_tags')){
            $query = pegasus_replace_modules_exists_tags($query);
            $query_cl = pegasus_replace_modules_exists_tags($query_cl);
        }
    }

    // για το grid των ειδών
    $inv_anap_d_params = array();

    $inv_anap_d_params['dt'] = $data['dt'];
    $inv_anap_d_params['dt2'] = $data['dt2'];
    $inv_anap_d_params['dek'] = $_SESSION['f01_p07']; // τιμή μονάδας
    $inv_anap_d_params['dek_pos'] = $_SESSION['f01_p08']; // ποσότητας

    //Εμφανίζει Επιπλέον το Υπόλοιπο του Χώρου
    $inv_anap_d_params['p06'] = $data['p06'];

    //Απο υπολοιπο - Εως υπολοιπο
    $inv_anap_d_params['min_ypol'] = $data['min_ypol'];
    $inv_anap_d_params['max_ypol'] = $data['max_ypol'];

    // Προμηθευτής
    if(empty($data['a00'])){
        $where = "i00.p602>=0";
    }else{
        $where = "i00.p602=:a00";
        $inv_anap_d_params['a00'] = $data['a00'];
    }

    if($data['colorsize']==1){
        // Για τα είδη που έχουν ΧΜ 
        $query_cl = str_replace(array('{peg_str1}'), array($where), $query_cl);
        $where .= " && ( i00.p9904=0 || i00.p9905=0 )";
    }

    $query = str_replace(array('{peg_str1}'), array($where), $query);
    
    // Εμφανίζει επιπλέον το υπόλοιπο του Χώρου -> αν οριστεί αυτό ενεργοποιείται και το υπόλοιπο από-έως
    //if($data['i16']<0){
        $i16 = "p012>=-999999999999.999";
        

        $query = str_replace(array("/*beg_sp_rest*/"), array(""), $query);
        $query = str_replace(array("/*end_sp_rest*/"), array(""), $query);
        $query_cl = str_replace(array("/*beg_sp_rest*/"), array(""), $query_cl);
        $query_cl = str_replace(array("/*end_sp_rest*/"), array(""), $query_cl);

        //Αποθηκευτικος χώρος
        //if($data['p06']>0){
        $query = str_replace(array('{nt_xoyp}'), array('&& i01_tot1.xoros=:p06'), $query);
        $query_cl = str_replace(array('{nt_xoyp}'), array('&& i47tot.p02=:p06'), $query_cl);

        //Απο εως Υπολοιπο
        $query = str_replace(array('{min_ypol}'), array('&& i01_tot1.ypolp >=:min_ypol'), $query);
        $query_cl = str_replace(array('{min_ypol}'), array('&& i47tot.p05 >=:min_ypol'), $query_cl);
        $query = str_replace(array('{max_ypol}'), array('&& i01_tot1.ypolp <=:max_ypol'), $query);
        $query_cl = str_replace(array('{max_ypol}'), array('&& i47tot.p05 <=:max_ypol'), $query_cl);

        //$query_cl = str_replace(array('{min_max_ypol}'), array('&& i47tot.p02=:p06'), $query_cl);

        // }else{
        //     $query = str_replace(array('{nt_xoyp}'), array(''), $query);
        //     $query_cl = str_replace(array('{nt_xoyp}'), array(''), $query_cl);
        // }
        
        
    /*}else{
        $i16 = "p012>=:nt_yp1 && p012<=:nt_yp2";
        $inv_anap_d_params['nt_yp1'] = $data['p02'];
        $inv_anap_d_params['nt_yp2'] = $data['p03'];
 
        
        $inv_anap_d_params['nt_xoyp'] = $data['i16'];
    }*/
    $query = str_replace(array('{peg_str2}'), array($i16), $query);
    $query_cl = str_replace(array('{peg_str2}'), array($i16), $query_cl);

    $query = invtrans_inv_anap_d_reform_query($data, $query);
    $query_cl = invtrans_inv_anap_d_reform_query($data, $query_cl);

    // χώροι
    $i16_in = explode('#', $data['m_i16']);
    foreach ($i16_in as $key => $value) {
        if($value==''){
            unset($i16_in[$key]);
        }
    }
    
    if(empty($i16_in)){
        $where = " IN (select p00 from i16)";
    }
    else{
        $in_stmt = pegasus_mysql_create_in($i16_in, 'i16');
        $inv_anap_d_params = array_merge($inv_anap_d_params, $in_stmt['sqlParams']);
        $where = " IN (" . $in_stmt['sql'] . ")";
    }

    $query = str_replace(array('{{i16}}'), array($where), $query);
    $query_cl = str_replace(array('{{i16}}'), array($where), $query_cl);

    ############################################################################

    if($data['colorsize']==1){
        $query = "SELECT * from ($query UNION ALL $query_cl) as tot4";
    }

    // εαν επιλέχθηκε "Ενημέρωση Αναγκών από Εξαγωγές Περιόδου"
    if($data['max']=="0" || $data['max']=="1"){
        $extra_query = peg_read_file('../invtrans_sql/i00p01011_needs.sql');
        $query = str_replace(array('{query}'), array($query), $extra_query);

        // υπολογισμός
        $peg_nnn = "round(tot5.p015*".$data['pos']."/100, :dek)"; // p015: Εξαγωγές 
        $peg_nnn = "round(".$peg_nnn." + tot5.p08 + tot5.p011 - tot5.p06 - tot5.p07, :dek)";
        
        $p09 = "tot5.p09";
        $p010 = "tot5.p010";
        $p020 = "tot5.p020";
        $p021 = "tot5.p021";

        // εαν εχει επιλεχθεί "Ενημέρωση Ελάχιστης Ανάγκης"
        if($data['min']=="1"){
            $p09 = "if(".$peg_nnn."<0, 0, ".$peg_nnn.")";
            $p020 = "round(".$p09." *tot5.p016, :dek)";
        }
        // εαν εχει επιλεχθεί "Ενημέρωση Μέγιστης Ανάγκης"
        if($data['max']=="1"){
            $p010 = "if(".$peg_nnn."<0, 0, ".$peg_nnn.")";
            $p021 = "round(".$p010." *tot5.p016, :dek)";
        }

        $query = str_replace(array('{p09}'), array($p09), $query);
        $query = str_replace(array('{p010}'), array($p010), $query);
        $query = str_replace(array('{p020}'), array($p020), $query);
        $query = str_replace(array('{p021}'), array($p021), $query);
    }

    //echo pegasus_replace_values_in_sql($query, $inv_anap_d_params);

    pegasusSetGlobalVar(
        'peg_'.$container_id.'_grid_query', 
        array(
            'sql' =>$query,
            'sqlParams'=>$inv_anap_d_params
        )
    );

    $query_2 = peg_read_file('../invtrans_sql/i00p010701.sql');
    $query_2 = str_replace(array('{query}'), array($query), $query_2);

    pegasusSetGlobalVar(
        'peg_'.$container_id.'_grid_query_2', 
        array(
            'sql' =>$query_2,
            'sqlParams'=>$inv_anap_d_params
        )
    );

    // Υπολογίζει τα δύο κόστη για την οθόνη..
    $query_3 = peg_read_file('../invtrans_sql/i00p01011_cost.sql');
    $query_3 = str_replace(array('{query}'), array($query), $query_3);

    pegasus_mysql_use($query_3, $cost_res, $inv_anap_d_params);
    $ret_array = array();
    $ret_array['p04'] = $cost_res['p020'];
    $ret_array['p05'] = $cost_res['p021'];

    return $ret_array;
}

function invtrans_inv_anap_d_reform_query($data, $query){
    //var_dump($data);
    // Ελάχιστο Ειδών (checkbox)
    if($data['elax'] == 1){
        $query = str_replace(array('nt_elax'), array(TRUE), $query);
    }
    else{
        $query = str_replace(array('nt_elax'), array(FALSE), $query);
    }

    // Παραγγελίες Πελατών (checkbox)
    if($data['ppe'] == 0){
        $query = str_replace(array("/**pegasus_start_module_ordercust**/"), array("/**pegasus_start_module_ordercust"), $query);
        $query = str_replace(array("/**pegasus_end_module_ordercust**/"), array("pegasus_end_module_ordercust**/"), $query);
    }
    // Παραγγελίες Προμηθευτών (checkbox)
    if($data['ppr'] ==0){
        $query = str_replace(array("/**pegasus_start_module_ordersupp**/"), array("/**pegasus_start_module_ordersupp"), $query);
        $query = str_replace(array("/**pegasus_end_module_ordersupp**/"), array("pegasus_end_module_ordersupp**/"), $query);
    }
    // Εσωτερικές Παραγγελίες (checkbox)
    if($data['pes'] == 0){
        $query = str_replace(array("/**pegasus_start_module_interorder**/"), array("/**pegasus_start_module_interorder"), $query);
        $query = str_replace(array("/**pegasus_end_module_interorder**/"), array("pegasus_end_module_interorder**/"), $query);
    }
    // Υπόλοιπα Ειδών (checkbox)
    if($data['ypol'] == 0){
        $query = str_replace(array("/*beg_rest*/"), array("/*beg_rest"), $query);
        $query = str_replace(array("/*end_rest*/"), array("end_rest*/"), $query);
    }

    // Υπολογίζει και τις Εσωτερικές Διακινήσεις (checkbox)
    if($data['esed'] == 1){
        $query = str_replace(array('nt_esed'), array(1), $query);
    }
    else{
        $query = str_replace(array('nt_esed'), array(0), $query);
    }

    // Εμφανίζει όλα όσα έχουν κίνηση (checkbox)
    if($data['kin'] == 1){
        $query = str_replace(array('nt_kin'), array(1), $query);
    }
    else{
        $query = str_replace(array('nt_kin'), array(0), $query);
    }

    // Ελάχιστο/Μέγιστο από Στοιχεία Ανά Χώρο (checkbox)
    if($data['anx'] == 1){
        $query = str_replace(array('nt_anx'), array(1), $query);
    }
    else{
        $query = str_replace(array('nt_anx'), array(0), $query);
    }

    // peg_str3
    if($data['anx'] or !$data['elax']){
        $where = "i00.nr01=-99999999";
    }else{
        $where = "i00.nr01>=0";
    }
    $query = str_replace(array('{peg_str3}'), array($where), $query);

    // peg_str4
    if(!$data['anx'] or !$data['elax']){
        $where = "i00.nr01=-99999999";
    }else{
        $where = "i00.nr01>=0";
    }
    $query = str_replace(array('{peg_str4}'), array($where), $query);

    return $query;
}

/**
 * Εισάγει στην Παραγγελία τα δεδομένα και τα ειδή τα οποία επέλεξε ο χρήστης στο grid των αναπαραγγελιών.
 * Δημιουργεί εκτός από τα ίδιο και τους βοηθητικούς πίνακες (peg_tmp_) για τα χρώματα μέγεθος serial number και παρτίδα
 *
 * @param string $dest_table	Πίνακες Αναφοράς (ο πινάκας που συνδέεται η Παραγγελία)
 * @param array  $data          Το array  δεδομένων της παραγγελίας (από to αντίστοιχο initialize function)
 * @param string $inv_tot_d_container_id    Το container id της οθόνης inv_tot_d
 * @return array $data	        Το ίδιο array με τα δεδομένα που έχει προσθέσει ή αλλάξει
 * 
 * @example #dest_table = a67 / a61
 */
function invtrans_inv_anap_d_import_data($dest_table = '', $data = array(),  $inv_tot_d_container_id = ''){
    
    $i00_arr = json_decode(pegasusGetGlobalVar('invtrans' . '_' . $inv_tot_d_container_id . '_i00_arr'), true);
    
    //Γενικός έλεγχος υποστηριζόμενων πινάκων 
	$availabe_tables = array('a67', 'a61');
	if (!in_array($dest_table, $availabe_tables)) {
		return $data;
	}
	$peg_mmnr01 = $dest_table . '_d-' . $data['nr01'];
	$p03_table = '';
	switch ($dest_table) {
		case 'a67':
			$p03_table = 'a00';
            $p03_invoice = $data['p03'];
			break;
		case 'a61':
			$p03_table = '-';
            $p03_invoice = 0;
			break;
	}

    $a00 = 0;
    $records = 0;       // όλα τα records
    $a00_records = 0;   // records με a00 

    //Prepare peg_tmp_i01
	foreach($i00_arr as $i00_record){
        $records++;
        // θα μπει την πρώτη φορά που θα βρει a00
        if($i00_record['a00']>0 && $a00==0){
            $a00 = $i00_record['a00'];
        }

        if($i00_record['a00']==$a00 && $a00>0){
            $a00_records++;
        }

		$i00 = array();
		pegasus_mysql_use("SELECT * FROM i00 WHERE pno=:pno", $i00, array('pno' => $i00_record['pno']));
		$p0601 = '';
        
		// Line Item price
		$price_array = inventory_find_price(
			$i00_record['pno'],
			$p03_invoice,
			$i00_record['p01'], // υπόλοιπο
			date('Y-m-d'),
			$data['p09'],
			$p03_table,
			$data['p07'],
			$data['p703']
		);
        // Τιμή Μονάδας
        $timi_monadas = $price_array['price'];
        // Έκτπωση 1-2
        $discount_1 = $price_array['discount_1'];
        $discount_2 = $price_array['discount_2'];
        // κατηγορία ΦΠΑ
        $kfpa= $price_array['kfpa'];
        // % ΦΠΑ
        $fpa  = $price_array['fpa'];

		$line_item_nr01 = 0;
		//	Παραγγελία
		if (in_array($dest_table, array('a67', 'a61'))) {
			$line_items_table = '';
			switch ($dest_table) {
				case 'a67':
					$line_items_table = 'a68';
					break;
				case 'a61':
					$line_items_table = 'a62';
					break;
			}
			$line_item_nr01 = pegasus_mysql_newrec($line_items_table);
			$peg_tmp_line_item_insert = array(
				'nr01' => $line_item_nr01,              //  M.K.
				'p00' => $data['nr01'],					//	Μ.Κ.Παραγγελίας
				'v101' => $i00_record['pno'],			//	Eίδος αποθήκης
				'v102' => $i00['name'],					//	Περιγραφή
				'v103' => $i00_record['p01'],			//	Ποσότητα
				'v104' => $timi_monadas,		        //	Τιμή Μονάδας
				'v160' => $p0601,						//	Αιτιολογία
				'v308' => $i00['p9908'],				//	Κωδ.Είδους Συσκευασίας

                'v106' => floatval($discount_1),	//	% Έκπτωσης 1
                'v106a' => floatval($discount_2),	//	% Έκπτωσης 2
                'v108' => $kfpa,	                //	Κωδικός Κατηγορίας ΦΠΑ
                'v105' => $fpa,		                //	% ΦΠΑ

                'v107' => invoices_make_product_total(  $i00_record['p01'], 
                                                        $timi_monadas,  
                                                        $fpa, 
                                                        floatval($discount_1), 
                                                        floatval($discount_2), 
                                                        0, 
                                                        0, 
                                                        $data['p07']),		                

				'peg_flag' => 1,
				'peg_mmnr01' => $peg_mmnr01,
				'peg_mnr01' => $data['nr01'],
				'peg_sess_id' => session_id()
			);

            // Αποθηκευτικός Χώρος: Προκαθορισμένο
            if($dest_table == 'a67') {
                $peg_tmp_line_item_insert['p703'] = -1;
            } else {
                $peg_tmp_line_item_insert['p03'] = -1;
                $peg_tmp_line_item_insert['p04'] = -1;
            }

			pegasus_mysql_insert('peg_tmp_' . $line_items_table, array_keys($peg_tmp_line_item_insert), array_values($peg_tmp_line_item_insert));
		}
        if(pegasus_module_exists('colorsize')) {
            $i47_nr01 = pegasus_mysql_printfld("i47", "nr01", "p02 = :pp08 AND p03 = :pp09 AND p01 = :pno", array("pp08" => $i00_record['pp08'], "pp09" => $i00_record['pp09'], "pno" => $i00_record['pno']));

            if($i47_nr01 > 0) {
                invoices_add_colorsize($peg_mmnr01, $dest_table, $line_item_nr01, $i00_record['pno'], $i00_record['pp08'], $i00_record['pp09'], $i00_record['p01']);
            }
        }
	}

    // αν όλα τα επιλεγμένα έχουν τον ίδιο προμηθευτή
    if($records==$a00_records && $dest_table=='a67' ){
        $data['p03'] = $a00;
    }

    // Υπολογισμός Συνόλων

    $product_where = array(
		'sql' => " peg_mnr01=:mnr01 
					and peg_mmnr01=:mmnr01
					and peg_sess_id=:session 
					and peg_flag!=9 ",

		'sqlParams' => array(
			'mnr01' => $data['nr01'],
			'mmnr01' => $peg_mmnr01,
			'session' => session_id(), 
		)
	);

    $a01_p09 = $data['p09']; //Καθεστώς ΦΠΑ
	$preview_with_vat = $data['p07']; //Με ΦΠΑ
	$p0101   = $data['p0101']; //Ποσοστό έκπτωσης
	$date    = $data['p01']; //Ημερομηνία

	$p0103   = 0; //Δεν χρησιμοποιείται κάπου στην συνάρτηση invoices_calculate_total το πεδίο
	$p0112   = 0; //Ποσοστό κράτησης
	$p0113   = 0; //Ποσοστό Φόρου
	$p0108   = 0; //Επιβαρύνσεις
	$p410    = 0; //Τα σύνολα δεν υπολογίζονται αυτόματα
	$p506	 = 0; //Δωροεπιταγη
	$p0102_1 = 0; //Εκπτ προ ΦΠΑ
	$p0102_2 = 0; //Εκπτ στο σύνολο
	$p01080	 = 0;

	$_totals = array();
	$_totals['p201'] = $data['p201'];
	$_totals['p202'] = $data['p202'];
	$_totals['p203'] = $data['p203'];
	$_totals['p204'] = $data['p204'];
	$_totals['p205'] = $data['p205'];
	$_totals['p206'] = $data['p206'];
	$_totals['p207'] = $data['p207'];
	$_totals['p208'] = $data['p208'];
	$_totals['p209'] = $data['p209'];

	$_totals['p301'] = $data['p301'];
	$_totals['p302'] = $data['p302'];
	$_totals['p303'] = $data['p303'];
	$_totals['p304'] = $data['p304'];
	$_totals['p305'] = $data['p305'];
	$_totals['p306'] = $data['p306'];
	$_totals['p307'] = $data['p307'];
	$_totals['p308'] = $data['p308'];
	$_totals['p309'] = $data['p309'];

	$return_array = invoices_calculate_total(
		'peg_tmp_' . $line_items_table,
		$product_where,
		$p0101,
		$p0112,
		$p0113,
		$p0103,
		$p0108,
		$a01_p09,
		$preview_with_vat,
		$p410,
		$_totals,
		$p506,
		$p0102_1,
		$p0102_2,
		$p01080,
		$dest_table,
		$date
	);
	foreach ($return_array as $key => $value) {
		$data[$key] = $value;
	}

    return $data;
}

function invtrans_after_update() {
    $version = array();
    pegasus_mysql_use("SELECT rel, ver FROM p55 WHERE p00='invtrans'", $version);
    if($version['ver'] == 2 && $version['rel'] <= 131) { 
        if(file_exists('../invtrans_exec/invtrans_massive_insert_i01_from_pd3_field.php')) {
            unlink('../invtrans_exec/invtrans_massive_insert_i01_from_pd3_field.php');
        }
        if (file_exists('../invtrans00/functions_.php')) {
            unlink('../invtrans00/functions_.php');
        }
    }
    if(file_exists('../../pegasus_cloud_app/invtrans_sql/i00p301_cs.sql_')) {
        unlink('../../pegasus_cloud_app/invtrans_sql/i00p301_cs.sql_');
    }
}

function invtrans_invoice_relation_grid_custom_actions($retArray = array()) {
    $peg_handler = 'invtrans_invoice_relation(screen.getContainer_ID());';

	$retArray[]  = array(
		'xtype' => 'pegasusToolBarGridAction',
		'peg_custom_id' => 'invtrans_view_relation',
		'viewModel' => array(
			'type' => 'GridButtonModel',
			'isToolBar' => 1,
			'data' => array(
				'toolBarButton' => 'invtrans_view_relation',

			)
		),
		'icon' => 'invtrans_images/i01_relation_16x16.png',
		'text' =>  $_SESSION['peg_dic_invtrans_show_relation'],
		'peghandler' => $peg_handler
	);
    return $retArray;
}

function invtrans_custom_actions_peg002($retArray=array(), $id='', $parent_d=''){

    $peg_handler = 
    "var row=pegGridGetSelectedRow(screen.getContainer_ID() , 'grid' , screen.getMnr01(), screen.getMmnr01());
		if(row){
			invtrans_toolbar_item_show_i01_d1005(screen, '".$id."', '".$parent_d."');
		}else{
			pegAlert('" . $_SESSION['peg_dic_inventory_must_select_record'] . "');
		}";

    $retArray[] = array(
        'xtype'         => 'pegasusToolBarGridAction',
        'peg_custom_id' => 'invtrans_toolbar_item_show_i01_d1005',
        'viewModel'     => array(
                'type'      => 'GridButtonModel',
                'isToolBar' => 1,
                'data'      => array(
                    'toolBarButton' => 'invtrans_toolbar_item_show_i01_d1005',
                )
            ),
        'icon'          => 'invtrans_images/i01_16x16.png',
        'text'          =>  $_SESSION['peg_dic_invtrans_toolbar_item_show_i01_d1005'],
        'peghandler'    => $peg_handler
    );
    
	return $retArray;
}

function invtrans_enable_custom_actions(&$data, $main_d='', $module='', $grid_d='', $grid_name='') {
	$data[$module . '_' . $grid_d . '_' . $grid_name . '_invtrans_toolbar_item_show_i01_d1005_hidden'] = false;
}

function invtrans_invtrans_browse_i01_d100_initialize($data,$mmnr01='',$mnr01='',$_d='',$container_id=''){

	$data['grid_change_hidden'] = true;
	$data['grid_rowchange_hidden'] = true; 
	if($_d=='invtrans_browse_i01_d100'){
		pegasusSetGlobalVar(
			$container_id. '_where_grid_invtrans_browse_i01_d100' ,
			array(
				'sql' => ' p85.nr01 IN ("140000025000003") ', 
				'sqlParams' => array()
			)
		);
	}

	return $data;
}

function invtrans_i01_d1022_set_grid_query($data, $container_id)
{

    $i01_d1022_params = array();

    $i01_d1022_query = "SELECT i01.p01    as p01,  
                                i00.name    as p02, 
                                i00.nr01, 
                              sum(i01.p03 * i15.p04 * i01.p012) as posex
                       FROM i00, i15, i01
                       /**pegasus_start_module_invcust
                            LEFT JOIN a55 ON a55.nr01=i01.p06 && i01.p07=2
                       pegasus_end_module_invcust**/
                       WHERE 
                          i01.p014=:log
                          && i01.p013>=:from_date
                          && i01.p013<=:to_date
                          && i01.p01=i00.pno
                          && i01.p05=i15.p01
                       GROUP BY i01.p01
                       ORDER BY posex desc";
                       // desc posex

    $i01_d1022_query = pegasus_replace_modules_exists_tags($i01_d1022_query);

    $i01_d1022_params['from_date']  = $data['dt_from'];
    $i01_d1022_params['to_date']    = $data['dt_to'];
    $i01_d1022_params['log']        = pegasus_mysql_printfld('a01', 'p21', 'nr01=:a01nr01', array('a01nr01' => $data['a01nr01']));

    pegasusSetGlobalVar(
        $container_id . '_grid_query_d1022',
        array(
            'sql' => $i01_d1022_query,
            'sqlParams' => $i01_d1022_params
        )
    );
    //echo pegasus_replace_values_in_sql($i01_d1022_query, $i01_d1022_params);
    
}

function invtrans_i01_d1022_initialize($data,$mmnr01 ,$mnr01 ,$_d ,$container_id){
    
    return $data;

}

function invtrans_erpa02_d06_set_grid_query($erpa02_nr01, $a55_p03, $container_id) {
    $v_sn = "";
    if(pegasus_module_exists('serial')) {
        $serial_select = "SELECT group_concat(if(i32.nr01 IS NULL, '', concat(i32.p02, '', if(i31.p015!='', concat('', i31.p015), '')) ) SEPARATOR ',') as serials
                          FROM i00    
                          LEFT JOIN i32 on i32.p00=i01.nr01 and i32.p00=i01.nr01
                          LEFT JOIN i31 on i32.p02=i31.p02  
                          WHERE i01.p01 = i00.pno";

        $v_sn = "ifnull(($serial_select), '') as v_sn, ";
    }

    $v_lot = "";
    if(pegasus_module_exists('lot')) {
        $lot_select = "SELECT group_concat(if(i38.nr01 IS NULL, '', if(i38.p04>0, concat(i38.p02,' ',' (',i38.p04,')'),'' ) ) SEPARATOR ',\n') as lots 
                       FROM i00    
                       LEFT JOIN i38 on i38.p01=i01.nr01 
                       WHERE i01.p01 = i00.pno";

        $v_lot = "ifnull(($lot_select), '') as v_lot, ";
    }

    $v_cs = "";
    if(pegasus_module_exists('colorsize')) {
        $colorsize_select = "SELECT group_concat(distinct if(i48.nr01 IS NULL || i40.p01 IS NULL || i43.p01 IS NULL, '', concat(i40.p02, IF(i40.p02='', '', '-'), i43.p02, ' x ', Format(i48.p04, i24.dek))) SEPARATOR ', ') as color_size 
                             FROM i00   
                             LEFT JOIN i24 on i00.ths = i24.p01  
                             LEFT JOIN i48 on i48.p01=i01.nr01
                             LEFT JOIN i40 on i40.p01=i48.p02  
                             LEFT JOIN i43 on i43.p01=i48.p03  
                             WHERE i01.p01 = i00.pno";

        $v_cs = "ifnull(($colorsize_select), '') as v_cs, ";
    }

    $query = "SELECT    i01.nr01   as nr01,  
                        i01.p01    as p01,  
                        i01.p02    as p02,  
                        i01.p012   as p012,  
                        i01.p013   as p013,  
                        i01.p0601  as p0601,
                        concat(ifnull(a10.p00, ''), ' ', ifnull(a55.p701, ''), ' ', ifnull(a55.p06, ''), '') as pp0601,
                        i01.p03    as p03,   
                        i01.p04    as p04,   
                        i01.p010   as p010,  
                        i01.p010a  as p010a, 
                        i01.p0100  as p0100, 
                        i01.p0101  as p0101, 
                        i01.p021   as p021,  
                        i01.p022   as p022,  
                        i01.p014   as p014,  
                        i01.p05    as p05,   
                        i01.p301   as p301,  
                        i01.p302   as p302,  
                        i01.p303   as p303,  
                        i01.p304   as p304,   
                        i01.p041   as p041,   
                        i01.p042   as p042,   
                        i01.p616   as p616,   
                        i01.pn01   as pn01,  
                        i01.pn02   as pn02,
                        $v_sn
                        $v_lot
                        $v_cs
                        ifnull(i01.p03  * (i15.p03-i15.p04) * i01.p012, 0) as ap03,   
                        ifnull(i01.p022 * (i15.p05-i15.p06) * i01.p012, 0) as ap022
                FROM i01 
                LEFT JOIN i15 ON i01.p05 = i15.p01
                LEFT JOIN a55 ON a55.nr01 = i01.p06
                             AND i01.p07  = 2
                LEFT JOIN a10 ON a10.p01 = a55.p05
                WHERE a55.p705 = :erpa02_nr01
                  AND a55.p03 = :a55_p03
                
                ORDER BY i01.p013 DESC;";
    
    $query_params = array();
    $query_params['erpa02_nr01'] = $erpa02_nr01;
    $query_params['a55_p03'] = $a55_p03;

    pegasusSetGlobalVar(
        $container_id . '_query_erpa02_d06',
        array(
            'sql' => $query,
            'sqlParams' => $query_params
        )
    );
}