<?php
    class invtrans_pegapi_actions extends pegapi_RestObject{
        
        protected $_d;
        protected $module;
        
        public function __construct($method, $request=null, $file=null){
            parent::__construct($method, $request, $file);

            $this->module = 'invtrans';
        }
        

        /**
         * Σύνολα ανά Είδος
         */
        public function i00tot_by_item(){

            $this->_d = 'i00tot_d';
            
            if($this->isLoggedIn()===false){
                throw new PegApi00Exception('Unauthorized', 401, null, 401, 'Unauthorized', 'Unauthorized');
            }
            
            if($this->method=='GET'){

                $data   = array();
                $fields = self::_get_fields_from_table($this->module, $this->_d);

                //echo "<pre>". print_r($fields,1) . "</pre>";

                $query  = " select ";
                $query .= " i00tot.pno1, sum(i00tot.p03) as p03 ";
                $query .= " , sum(i00tot.p04) as p04, sum(i00tot.p05) as p05, sum(i00tot.p06) as p06, sum(i00tot.p07) as p07 ";
                $query .= " , group_concat(i00tot.p610) as p610 ";
                $query .= " from i00tot ";
                $query .= " join i16 on i16.p00=i00tot.p610 and i16.p300=1 ";
                $query .= " where i00tot.pno1=:i00pno ";
                $query .= " group by i00tot.pno1;";

                $values = array('i00pno'=>trim($this->request['i00pno']));
                //echo pegasus_replace_values_in_sql($query, $values);
                $res_query = pegasus_query($query, $values);

                while($i00tot=pegasus_fetch_assoc($res_query)){
                    $data[] = static::validateData_static($i00tot, $fields);				
                }
                 
                $this->totalrec = count($data) ;
                if($this->totalrec<1){
                    throw new PegApiException('No Content', 290, null, 290);
                }
                
                
                return array(
                        'status'	=> 200,
                        'code'		=> 200,
                        'data'		=> $data
                );
                    
            }else{
                throw new PegApi00Exception('Method Not allowed', 400, null, 400, 'Method Not allowed', 'Only GET method available');
            }
        } 
        
        protected static function _get_fields_from_table($module='', $_d=''){

            $fields = array();
            
            $query_p51  = " select ";
            $query_p51 .= " p51.desc05 as fld, p51.desc16 as tp, desc17 as fldsz, desc18 as flddec ";
            $query_p51 .= " from p51 ";
            $query_p51 .= " join p61 on p51.desc07=p61.p00 and p61.isdbfld=1 ";
            $query_p51 .= " where ";
            $query_p51 .= " p51.desc16!='' and p51.desc16!='V' and  p51.desc16!='' and p51.p02=:_d and p51.module=:module ";
            $query_p51 .= " order by case when desc13>0 then 0 else 1 end asc, desc13, desc06; ";
                
            $res_p51    = pegasus_query($query_p51, array('_d'=>$_d, 'module'=>$module));

            while($p51 = pegasus_fetch($res_p51)){
                $fields[$p51['fld']] = array('fld'=>$p51['fld'], 'tp'=>$p51['tp'], 'fldsz'=>$p51['fldsz'],  'flddec'=>$p51['flddec']);			
            }

            return $fields;
        }
    }