<?php
// update v1r50

function mail_after_update(){

	pegasus_mysql_use('select rel, ver from p55 where p00="mail"', $version);
	if($version['ver'] == 1 && $version['rel'] <= 61) {
		if (file_exists('../../pegasus_cloud_app/mail01/mail_send_mail_d00_find_mails.php')) {
			unlink('../../pegasus_cloud_app/mail01/mail_send_mail_d00_find_mails.php');
		}
    }
	if($version['ver'] == 1 && $version['rel'] <= 61) {
		if(file_exists('../../pegasus_cloud_app/mail_sql/find_fields.sql')){
			unlink('../../pegasus_cloud_app/mail_sql/find_fields.sql');
		}
	}
	if($version['ver'] == 1 && $version['rel'] <= 61) {
		if(file_exists('../../pegasus_cloud_app/mail_sql/find_1ton_fields.sql')){
			unlink('../../pegasus_cloud_app/mail_sql/find_1ton_fields.sql');
		}
	}

	if ($version['ver'] == 1 && $version['rel'] <= 86) {
		if (file_exists('../../pegasus_cloud_app/mail00/afterupdate.php')) {
			unlink('../../pegasus_cloud_app/mail00/afterupdate.php');
		}

		pegasus_mysql_update(
			'mail02',
			array('p60'),
			array(1),
			'p60 = 0',
			0 ,1 ,1,
			array()
		);
	}
}

function peg_mail_mail02_d_initialize($data,$mmnr01='',$mnr01='',$_d='',$container_id=''){
    // Ο κωδικός του κύριου πίνακα

	$new_rec = 0;
    if(empty($data['nr01'])){
        $new_rec = 1;
    }
    
    pegasusSetGlobalVar('mail02_' .  $container_id   . '_sql'  , mail00_find_fields($data['p50']));
    pegasusSetGlobalVar('mail02_' .  $container_id   . '_table_sql'  , mail00_find_1toN_table_fields($data['p50']));
	
	if(pegasus_module_exists('urls')){
		urls_set_global_table_urls($container_id, $data['p50']);
	}	
	
    if($_d=='mail02_d'){
        if(!empty($data['module']) && !pegasus_module_exists('dias')){
            // $data['readonly']=1;
			$data['mail_mail02_d_p00_readonly'] = true;
			$data['mail_mail02_d_p50_readonly'] = true;
			$data['mail_mail02_d_mail10_readonly'] = true;
			$data['mail_mail02_d_p85_readonly'] = true;
			$data['mail_mail02_d_p01_readonly'] = true;
			$data['mail_mail02_d_d65pd100_readonly'] = true;
			$data['mail_mail02_d_p30_readonly'] = true;
			$data['mail_mail02_d00_p30_readonly'] = true;
			
        }
    }

	if($new_rec == 1){
		$data['p60'] = 1;
	}
    
    return $data;
}

function peg_mail_mail02_d_onsave($data, $permDeny = array(), $mmnr01 ='', $checkOnlyPerm = false){
	if(empty($data['p50'])){
		$permDeny[] = array(
			"type" => "deny",
            "message" => $_SESSION['peg_dic_mail_must_select_db_table']
		);
	}

	return array($data, $permDeny);

}

function peg_mail_mail_send_d00_d_initialize($data,$mmnr01='',$mnr01='',$_d='',$container_id=''){
	global $PegInput;
	$PegInput->addVar(new peg_input_alphanumeric('peg_table'));
	$PegInput->addVar(new peg_input_number('peg_nr01'));
	$PegInput->addVar(new peg_input_number('peg_p85'));
	$PegInput->addVar(new peg_input_number('peg_mail02'));
	$PegInput->addVar(new peg_input_alphanumeric('peg_mail'));
	$PegInput->addVar(new peg_input_alphanumeric('attach_folder'));

	$peg_table = $PegInput->getRequest('peg_table');
	$peg_nr01  = $PegInput->getRequest('peg_nr01');
	$peg_p85  = $PegInput->getRequest('peg_p85');
	$peg_mail02  = $PegInput->getRequest('peg_mail02');
	$peg_mail = $PegInput->getRequest('peg_mail');
	$attach_folder = $PegInput->getRequest('attach_folder');

	$data['tbl']      = $peg_table;
	$data['tbl_nr01'] = $peg_nr01;
	$data['mail02']      = $peg_mail02;
	$data['p85'] = $peg_p85;


	if($data['tbl'] == "a55" && function_exists('ca_server_a55_unable_to_find_signature')){
		if(ca_server_a55_unable_to_find_signature("a55", $data['tbl_nr01'])){
			$data = array();
			$data['permDeny'] = 1;
			$data['permDenyMessage'] = $_SESSION['peg_dic_ca_server_a55_not_fisc_sig_settings'];
			return $data;
		}
	}
	if($data['tbl'] == "d00" ){
		$data['d00nr01']=$data['tbl_nr01'];
	}

	if($data['tbl'] == "a01" ){ //Πελάτες
		//a01.pnr01 =d00.nr01
		$data['d00nr01']=pegasus_mysql_printfld('a01','pnr01','nr01=:var_a01_nr01',array('var_a01_nr01'=>$data['tbl_nr01']));	
	}
	if($data['tbl'] == "a00"){ //Προμηθευτές
		//a00.pnr01 = d00.nr01
		$data['d00nr01']=pegasus_mysql_printfld('a00', 'pnr01', 'nr01=:var_a00_nr01', array('var_a00_nr01'=>$data['tbl_nr01']));
	}
	//Αν το πρότυπο είναι αρχικοποιημένο, θα πρέπει ναβρω το κείμενο του email κοκ
	if($peg_mail02 > 0 ){ 

		$mail02Array =  mail00_get_data_from_mail02($peg_mail02, $peg_table, $peg_nr01);
		if(!($peg_p85>0)){//Αν έρθει αρχικοποιημένη η φόρμα, θέλω να χρησιμοποιήσω αυτήν
			$data['p85'] = $mail02Array['p85'];
		}
		
		$data['p01'] = $mail02Array['p01'];
		$data['p30'] = $mail02Array['p30'];	
		
		$data['mail'] = mail00_find_mail_with_crm000_02($peg_table ,$peg_nr01, $peg_mail02, '', true);
	}
	if(!empty( $peg_mail )){
		$data['mail']='#'.trim( $peg_mail ,'#').'#';
	}

	pegasusSetGlobalVar(
		$container_id.'_mail_send_mail_query',  mail00_find_all_mails_for_multi_selectbox($peg_table , $peg_nr01)
	);

	/** - **/
	pegasusSetGlobalVar('mail_send_p85_tbl',$peg_table);
	pegasusSetGlobalVar('mail_send_d00_tbl'      , $peg_table);
	pegasusSetGlobalVar('mail_send_d00_tbl_nr01' , $peg_nr01);
	$data['mail_mail_send_d00_attach_input_hidden']=true;
	if(!is_dir($attach_folder)){
		$attach_folder=mail_create_attachments_tmp_folder();
	}
	if(!$attach_folder || !is_dir($attach_folder)){
		$data['mail_mail_send_d001_attach_fldcontainer_hidden']=true;
	}
	
	if(!empty($attachments) && file_exists($attach_folder.'/')){
		$data['attachments']=$attachments;
	}
    pegasusSetGlobalVar($container_id.'_mail_attachments_directory', $attach_folder );
	$attachments_config_arr=mail_mail_send_d001_d_attachments_config($container_id); 
	$data['mail_mail_send_d001_attachments_ls_data']=$attachments_config_arr['ls_data'];	
	$data['attachments']=$attachments_config_arr['value'];	
	return $data;
}
function mail_mail_send_d001_d_attachments_config($container_id){
    $attach_folder= pegasusGetGlobalVar($container_id.'_mail_attachments_directory');
	$ret_arr=array(); 
	if(!empty($attach_folder)){ 
		$fileArray = peg_scandir( $attach_folder); 
		if($fileArray === false){ return $ret_arr;}
		$ls_data_array=array();
		$attachments='#';
		foreach ($fileArray as $file){ 
			$path =  rtrim($attach_folder,'/').'/'.$file;  
			if(	!is_dir($path) 
				&& mail_attachment_validMIMEType(peg_mime_content_type($path))
				){ 
				if(!pegasus_check_utf8($path)){
                    $path = iconv('ISO-8859-7' , 'UTF-8' , $path);
                    $file = iconv('ISO-8859-7' , 'UTF-8' , $file);
                }
				$filesize = round( filesize($path) / 1024 , 1); 
				array_push($ls_data_array,array('desc'=>"$file ($filesize KB)" , 'val' => $file));
				$attachments.="$file#";
			} 
		}
	} 
	return array(	'ls_data'	=>	$ls_data_array,
					'value'		=>	$attachments );
}
function mail_mail_send_d00_execute_before_save(){
	return mail_upload_attachment();
}
function mail_create_attachments_tmp_folder(){
	$path =  "../../tmp/".session_id().'/';
	if(!is_dir($path)){
		return false;
	}  
	$path.='mail/attachments/'.date('YmdHis').'_'.rand().'/';
	if(!is_dir($path)){
		mkdir( $path ,0777,true);	
	} 
	return $path;
}
function mail_attachment_validMIMEType($mimeType){
    $mimeTypeAr = explode('/', $mimeType); 
    switch ($mimeTypeAr[0]) {
        case 'text':
            if($mimeTypeAr[1] == 'plain' || $mimeTypeAr[1] == 'calendar'){
                return true;
            }
            return false;
        break;
        case 'image':
            return in_array($mimeTypeAr[1], array('gif', 'png', 'jpeg', 'webp'));
        break;
        case 'audio':
            return in_array($mimeTypeAr[1], array('midi', 'mpeg', 'webm', 'ogg', 'wav'));
        break;
        case 'video':
            return in_array($mimeTypeAr[1], array(  'webm', 'ogg'));
        break;
        case 'application':
            return in_array($mimeTypeAr[1], array(  'vnd.openxmlformats-officedocument.wordprocessingml.document','vnd.mspowerpoint', 'pdf','zip'));
        break;
        default:
            return false;
        break;
    }
    return false;

} 
function mail_upload_attachment($input_fld_name='attach_input'){
    global $PegInput;
	$PegInput->addVar(new peg_input_alphanumeric('scr_container_id'));  
	$scr_container_id = $PegInput->getRequest('scr_container_id');
    $ret_arr = array(
        'denysave' => 0,
        'denymsg' => ''
    );  
 
	$path =  pegasusGetGlobalVar($scr_container_id.'_mail_attachments_directory').'/';
    if (!isset($_FILES[$input_fld_name])) {
        $ret_arr['denysave'] = 1;
        $ret_arr['denymsg'] = $_SESSION['peg_dic_mail_attachment_no_file'];
		return $ret_arr;
    } 
	// var_dump($_FILES[$input_fld_name]['tmp_name'],mime_content_type($_FILES[$input_fld_name]['tmp_name']));
	if(!mail_attachment_validMIMEType(mime_content_type($_FILES[$input_fld_name]['tmp_name']))){
		$ret_arr['denysave'] = 1;
        $ret_arr['denymsg'] = str_replace("##mime##",mime_content_type($_FILES[$input_fld_name]['tmp_name']),$_SESSION['peg_dic_mail_attachment_invalid_mime_type']);
		return $ret_arr;
	}
    if ($_FILES[$input_fld_name]["error"] == 0) {
        if (!is_dir($path)) {
            $flag = @mkdir($path, 0777, true);
            if (!$flag) {
                $denySave = 1;
                $denyMsg = '<p style="color:red;text-align:center;font-weight:bold;">Folder Access Denied (' . $path . ')</p>';
                return array('denymsg' => $denyMsg, 'denysave' => $denySave);
            }
        }
        if (file_exists("$path".$_FILES[$input_fld_name]["name"])) {
            unlink("$path".$_FILES[$input_fld_name]["name"]);
        } 
        if(!(move_uploaded_file($_FILES[$input_fld_name]["tmp_name"] ,  $path . $_FILES[$input_fld_name]["name"]) )){
            $denySave = 1; 
            $denyMsg = '<p style="color:red;text-align:center;font-weight:bold;">Error move_uploaded_file (' . $path .  $_FILES[$input_fld_name]["name"].')</p>';
            return array('denymsg' => $denyMsg, 'denysave' => $denySave);
    	}
        pegasusSetGlobalVar($scr_container_id.'_last_attachment',array('fname'=>$_FILES[$input_fld_name]["name"] ,'fpath'=>$path . $_FILES[$input_fld_name]["name"]));
    } else if ($_FILES[$input_fld_name]["error"] == 4) {
        //  0 file was uploaded
        // $photo_ok = peg_createtmp_photo('no-image.png', "../peg_photos_images/", $path, "$erpa70_nr01.png",  $width,$height, 'png');
    } else if ($_FILES[$input_fld_name]["error"] == 1) {
        $denySave = 1;
        $denyMsg = '<p style="color:red;text-align:center;font-weight:bold;">' . $_SESSION['peg_dic_core_upload_err_ini_size'] . ' (' . ini_get('upload_max_filesize') . ')</p>';
        return array('denymsg' => $denyMsg, 'denysave' => $denySave);
    } else if ($_FILES[$input_fld_name]["error"] > 0) {
        $denySave = 1;
        $denyMsg = "<p>Error: " . $_FILES[$input_fld_name]["error"] . "<p/>";
        return array('denymsg' => $denyMsg, 'denysave' => $denySave);
    }
    return $ret_arr;
}
function mail00_find_all_mails_for_multi_selectbox($core_tbl , $core_tbl_nr01){
	$query = mail00_find_mails_query($core_tbl , $core_tbl_nr01, '', 1);
    if(empty($query) || (is_array($query) && empty($query['sql'] ))){
        return " select '' as mail, '' as recipient from d65 where 1 == 0 "; //Δεν υπάρχει query που να μας φέρνει mail
    }

	$query['sql'] =  "SELECT all_mails.d65nr01 as mail,
							concat(all_mails.mail, if(d00.p19 is not null and d00.p19 <> '', ' | ', '') , ifnull(d00.p19,'')    ) as recipient 
					  FROM (".$query['sql'].") as all_mails
					  LEFT JOIN d00 on all_mails.d00nr01 = d00.nr01
	";
	
	//echo pegasus_replace_values_in_sql($query['sql'], $query['sqlParams']);

	return $query;
}
