<?php

/**
 * 
 * @param Integer[15] $mail02nr01 o monadikos kwdikos thn eggrafis ston pinaka mail02
 * @param String $core_tbl
 * @param Integer[15] $core_tbl_nr01
 * @return array ('p85' => '', 'p01' => '', 'p30' => '');
 */
function mail00_get_data_from_mail02($mail02nr01, $core_tbl, $core_tbl_nr01)
{
    $p85 = '';
    $p01 = '';
    $p30 = '';
    if ($mail02nr01 > 0) {
        pegasus_mysql_use("select * from mail02 where nr01=?", $mail02, array($mail02nr01));
        $p85 = $mail02['p85'];
        $p01 = $mail02['p01'];
        $p30 = $mail02['p30'];

        $mail10 = $mail02['mail10'];
        if ($mail10 > 0) {
            $template_text = pegasus_mysql_printfld('mail10', 'p30', ' nr01=? ', array($mail10));
            $p30 = str_replace('##peg_mail_body##', $p30, $template_text);
        }

        $rec = mail00_find_main_record($core_tbl, $core_tbl_nr01, $p30);

        if (is_array($rec)) {
            foreach ($rec as $key => $value) {
                $p30 = str_replace("##" . $key . "##", $value, $p30);
                $p01 = str_replace("##" . $key . "##", $value, $p01);
            }
        }


        $p30 = peg_mail_replace_data_from_multi_join_tables($p30,  $core_tbl, $core_tbl_nr01);

        if (pegasus_module_exists('urls')) {
            $p30 = urls_mail_content_urls($p30,  $core_tbl, $core_tbl_nr01);
        }

        $p30 = str_replace("##us0_email_sign##",   $_SESSION['us0_email_sign'], $p30);

		//Ημερομηνία και ώρα 
		$p30 = str_replace("##email_date##",   date("d-m-Y"), $p30);
		$p30 = str_replace("##email_time##",   date("H:i"), $p30);

        if (function_exists('peg_' . $core_tbl . '_extra_replace_mail00')) {
            //H sinartisi vriskete sto module tou table
            $functionname = 'peg_' . $core_tbl . '_extra_replace_mail00';
            $p30 = $functionname($p30, $core_tbl_nr01);
            $p01 = $functionname($p01, $core_tbl_nr01);
        }
        if (function_exists('sme_' . $core_tbl . '_extra_replace_mail00')) {
            //H sinartisi vriskete sto module tou table
            $functionname = 'sme_' . $core_tbl . '_extra_replace_mail00';
            $p30 = $functionname($p30, $core_tbl_nr01);
            $p01 = $functionname($p01, $core_tbl_nr01);
        }
    }
    return array('p85' => $p85, 'p01' => $p01, 'p30' => $p30);
}

/**
 * Dimiourgei ena Array me ta dedomena mias eggrafis
 * @param string $core_tbl table name 
 * @param string $core_tbl_nr01 
 */
function mail00_find_main_record($core_tbl, $core_tbl_nr01, $p30 = "")
{
    return core00_find_main_record($core_tbl, $core_tbl_nr01, $p30);
}

function peg_mail_replace_data_from_multi_join_tables($text, $core_tbl, $core_tbl_nr01)
{
    return core00_replace_data_from_multi_join_tables($text, $core_tbl, $core_tbl_nr01);
}

/**
 * Vriskei ta pedia tou pinaka "$core_table"
 * @param string $core_table
 * @return mixed
 */

function mail00_find_fields($core_table, $return_array = 0)
{
    $field_dic = $_SESSION['peg_dic_mail_field'];
    $description_dic = $_SESSION['peg_dic_mail_description'];
    $result_arr = core00_find_table_fields($core_table, $field_dic, $description_dic);

    return ($return_array) ? $result_arr
        : pegasus_replace_values_in_sql($result_arr["sql"],  $result_arr["sqlParams"]);
}

/**
 * Vriskei olous tou pinakes poy einai sindedemeni 1-n me ton kurio pinaka
 * @param string $core_table    
 *  //To Onoma toy pinaka
 * @return SQLQuery
 */

function mail00_find_1toN_table_fields($core_table, $return_array = 0)
{
    return core00_find_1toN_table_fields($core_table, $return_array);
}

function peg_mail_validate_array_data(&$array, $dataType)
{
    return core00_validate_array_data($array, $dataType);
}

function peg_mail_get_template($text, $table ){
   return core00_get_template($text, $table );
}

function peg_mail_replace_data($query, $dataType, $template, $values_arr = array())
{
    return core00_replace_data($query, $dataType, $template, $values_arr);
}

function mail00_get_tempate_file($fileName=''){
	
	if($fileName == ''){
		return '';
	}
	
	if(file_exists($fileName)){
		return $fileName;
	}elseif (file_exists('../../pegasus_cloud_app/mail_templates_sme/'.$fileName)){
		return '../../pegasus_cloud_app/mail_templates_sme/'.$fileName;
	}else{
		return  '../../pegasus_cloud_app/mail_templates/'.$fileName;
	}
	
}

function mail00_format_html($mail=''){
		
		$fileName = mail00_get_tempate_file('basic_html.php');
		
		$template = peg_read_file($fileName);	
		$template = str_replace('##text##', $mail, $template);	
		
		return $template;
}

function mail00_send_mail($mail,$p01,$p30, $d00nr01=0, $d65nr01=0,$mail02=0,$p85=0,$tbl='',$tbl_nr01=0, $extra_replace = array(),$extraformvalues=array(),$attachments=array(), $cc = '', $bcc = ''){
    $ret_array = array();
    $ret_array['ok']  = 0;
    $ret_array['msg'] = '';
    $ret_array['mail03nr01'] = 0;

	if(empty($mail)){
		if(!empty($ret_array['msg'])){
			$ret_array['msg'] .= "<br>" ;
		}
        $ret_array['msg'] .= $_SESSION['peg_dic_mail_empty_mail'];
    }
    
    if(empty($p01)){
		if(!empty($ret_array['msg'])){
			$ret_array['msg'] .= "<br>" ;
		}
        $ret_array['msg'] .= $_SESSION['peg_dic_mail_empty_title'];
    }
    
    if(empty($p30)){
		if(!empty($ret_array['msg'])){
			$ret_array['msg'] .= "<br>" ;
		}
        $ret_array['msg'] .= $_SESSION['peg_dic_mail_empty_text'];
    }
    
    
    if(!empty($ret_array['msg'])){
        return $ret_array; 
    }
    if(is_array($extra_replace) && count($extra_replace)>0){
        $p01 = str_replace(array_keys($extra_replace), array_values($extra_replace), $p01);
        $p30 = str_replace(array_keys($extra_replace), array_values($extra_replace), $p30);
    }
    $p01 = str_replace('##send_to_mail##', $mail, $p01);
    $p30 = str_replace('##send_to_mail##', $mail, $p30);
    
    $_file_array = array();
    if($p85>0){
	
        $pdf ;
        $_REQUEST['p85_nr01'] = $p85 ;
        $_REQUEST['dias_main_table'] = $tbl ;
        $_REQUEST['dias_main_nr01'] = $tbl_nr01;
		$request_old=$_REQUEST;
		if(is_array( $extraformvalues) && !empty($extraformvalues)){
			
			foreach($extraformvalues as $key=>$value){
				$_REQUEST[$key]=$value;
			}
		} 
        require('../core_global/print_to_pdf00.php');
        $peg_tmp_pdf_path = '../../tmp/'  . session_id() . '/';
        if($pdf instanceof pegTCPDF){
            $peg_tmp_pdf_path = realpath($peg_tmp_pdf_path);
		}

		$file_name = $peg_tmp_pdf_path. '/print_' .$tbl. '_' .$tbl_nr01. '.pdf';
        if(function_exists('peg_'.$tbl.'_find_mail_attached_filename')){
			$functionname = 'peg_'.$tbl.'_find_mail_attached_filename';			
			$file_name = $peg_tmp_pdf_path. '/'.$functionname($tbl_nr01);
		}

		$pdf->Output( $file_name, 'F' );
		
        $_file_array =  array( $file_name);
		$_REQUEST=$request_old;
    }
    
    if(is_array($attachments) && !empty($attachments)){
        $_file_array=array_merge($_file_array,$attachments);
    }
    /* apostoli e-mail*/
    $from = '';
    $smtp_error = peg_send_mail($from , $mail , $p01 , $p30 , 1  , '' , '' , '' , '' , $_file_array, $cc, $bcc); ;
    
//     var_dump($smtp_error);
    if(!empty($smtp_error)){
        $ret_array['msg']=$smtp_error ;
        return $ret_array;
        
    }
    
    $ret_array['mail03nr01'] = pegasus_mysql_newrec('mail03');
    //add_log_to_db
    $arr1 = array();  $arr2 = array();
    array_push($arr1 , 'nr01'); array_push($arr2 ,$ret_array['mail03nr01'] );
    array_push($arr1 , 'd00nr01'); array_push($arr2 , $d00nr01);
    array_push($arr1 , 'd65nr01'); array_push($arr2 , $d65nr01);
    array_push($arr1 , 'mail');    array_push($arr2 , $mail);
    array_push($arr1 , 'cc');    array_push($arr2 , $cc);
    array_push($arr1 , 'bcc');    array_push($arr2 , $bcc);
    array_push($arr1 , 'dt');      array_push($arr2 , date('Ymd'));
    array_push($arr1 , 'tm');      array_push($arr2 , date('H:i:s'));
    array_push($arr1 , 'p01');     array_push($arr2 , $p01);
    array_push($arr1 , 'p30');     array_push($arr2 , $p30);
    array_push($arr1 , 'mail02');  array_push($arr2 , $mail02);
    pegasus_mysql_insert('mail03', $arr1, $arr2);

    $ret_array['ok']  = 1;
    $ret_array['msg'] = $_SESSION['peg_dic_mail_sent_ok'];
    
    return $ret_array;
}

/**
 * Epistrefei to e-mail toy sinallassomenou katw apo mia katigoria 
 * @param string $core_tbl 
 *      //O pinakas p ginete h apostoli
 * @param intiger[15] $core_tbl_nr01
 *      //O monadikos kwdikos toy pinaka
 * @param intiger[15] $mail02nr01
 *      //O monadikos kwdikou toy protipou keimenoy e-mail
 * @param char[20] $d65pd100
 *      // O kwdikos ths katigorias       
 */
function mail00_find_mail_with_crm000_02($core_tbl ,$core_tbl_nr01, $mail02nr01 = 0, $d65pd100 = '', $return_d65_nr01 = false){

    if(empty($d65pd100) && !empty($mail02nr01)){
        $d65pd100 = pegasus_mysql_printfld('mail02', 'd65pd100', ' nr01 = ? ', array($mail02nr01));
    }
    // if(empty($d65pd100)){
    //     return '';
    // }
    $query = mail00_find_mails_query($core_tbl ,$core_tbl_nr01 ,$d65pd100, 1);
    if(empty($query) || (is_array($query) && empty($query['sql'] ))){
        return '';
    }

	if (!empty($query['sql'])){
		$query['sql'] .= " order by tax ";
	}
	
    pegasus_mysql_use($query['sql'] , $mailtmp, $query['sqlParams']);

    if($d65pd100 == $mailtmp['d65pd100']){
		if($return_d65_nr01){
			return $mailtmp['d65nr01'];
		}
        return $mailtmp['mail']; //Χρησιμοποιείται π.χ. στο gym 
    }else{
        return '';
    }
}


/**
 * Vriskei poia einai ta pithana e-mail poy mporei na ginei eggrafi
 * @param String $core_tbl
 * @param String $core_tbl_nr01
 * @return string
 */
function mail00_find_mails_query($core_tbl ,$core_tbl_nr01 ,$d65pd100 = '', $return_array=0){

    $core_tbl_module = pegasus_mysql_printfld('p50', 'module', 'p01=?', array($core_tbl));
    if(function_exists($core_tbl_module . "_" . $core_tbl . "_find_mails_query")){
        return call_user_func( $core_tbl_module . "_" . $core_tbl . "_find_mails_query", $core_tbl_nr01, $d65pd100, $return_array);
    }


	$prep = mail00_find_fields($core_tbl, 1);

	$query = "select * from (" .$prep['sql'] . ") as tbl 
	where 
		(tbl1 = 'd00' and fld1='nr01') or  
		(tbl2 = 'd00' and fld2='nr01') or 
		(tbl1 = 'a01' and fld1='nr01') or  
		(tbl2 = 'a01' and fld2='nr01') or 
		(tbl1 = 't00' and fld1='p01')  or  
		(tbl2 = 't00' and fld2='p01')  or 
        (tbl1 = 'a00' and fld1='nr01') or  
		(tbl2 = 'a00' and fld2='nr01') or
		(tbl1 = 'hota04' and fld1='nr01') or  
		(tbl2 = 'hota04' and fld2='nr01')
	group by tbl1,fld1,tbl2,fld2 ;";
	

	$array_p20 = array(); 
	
	$res  = pegasus_query($query, $prep['sqlParams']);

	while ($tbl00 = pegasus_fetch_assoc($res)) {
	
		if(strtolower($tbl00['tbl1']) == strtolower($core_tbl)){
			array_push($array_p20 ,  array('tbl1' => $tbl00['tbl1'], 'fld1' => $tbl00['fld1'] , 'tbl2' => $tbl00['tbl2'] , 'fld2' => $tbl00['fld2']) );
		}else{
			array_push($array_p20 ,  array('tbl1' => $tbl00['tbl2'], 'fld1' => $tbl00['fld2'] , 'tbl2' => $tbl00['tbl1'] , 'fld2' => $tbl00['fld1']) );
		}						
	}	
	$query = '';
	$i = 1;
	$values = array();
	foreach($array_p20 as $tbl){
	    $tax_min_val = $i*1;
	    $tax_max_val = $i*10;
		
		$add_to_values_array = 0;
		if( strtolower($tbl['tbl2'])=='d00'){
			if(!empty($query)){ $query .= ' UNION ';}
			$query .= "(select d65.p01 as mail, d00.nr01 as d00nr01, d65.nr01 as d65nr01, 
			p51.desc02 as fld, if(d65.pd100 = '$d65pd100', '$tax_min_val', '$tax_max_val' ) as 
			tax, d65.pd100 as d65pd100, d65.p02 as d65p02, d65.p300 as d65p300 from 
			(select * from " .$core_tbl. " where nr01=:nr01) as tbl join  
			d00 on tbl." . $tbl['fld1'] . "=d00.nr01 join d65 on d65.p00=d00.nr01 join p51 
			on p51.p02=:p02_".$i."_d  and desc05=:desc05_".$i." order by tax )" ;

			$add_to_values_array = 1;
		}	
		
		if( strtolower($tbl['tbl2'])=='a01'){
			if(!empty($query)){ $query .= ' UNION ';}
			$query .= "(select d65.p01 as mail, d00.nr01 as d00nr01, d65.nr01 as d65nr01, 
			p51.desc02 as fld, if(d65.pd100 = '$d65pd100', '$tax_min_val', '$tax_max_val' ) as 
			tax, d65.pd100 as d65pd100, d65.p02 as d65p02, d65.p300 as d65p300  from 
			(select * from " .$core_tbl. " where nr01=:nr01) as tbl join  
			a01 on tbl.".$tbl['fld1']."=a01.nr01 join  d00 on a01.pnr01=d00.nr01 join  
			d65 on d65.p00=d00.nr01 join p51 on p51.p02=:p02_".$i."_d
			and desc05=:desc05_".$i." order by tax)" ; 

			$add_to_values_array = 1;
		}	
		
		if( strtolower($tbl['tbl2'])=='t00'){

			if(pegasus_mysql_table_exists('a01') && pegasus_mysql_table_exists('a00')){
				$t00_join = "
				left join  a01 on tbl.".$tbl['fld1']."=a01.p21
				left join  a00 on tbl.".$tbl['fld1']."=a00.p21	
				join  d00 on ( 
					(a00.pnr01=d00.nr01 && a00.p21 like '50%') || 
					(a01.pnr01=d00.nr01 && a01.p21 like '30%')
					) ";
			}
			else if(pegasus_mysql_table_exists('a01') ){
				$t00_join = "
				join  a01 on tbl.".$tbl['fld1']."=a01.p21
				join d00 on a01.pnr01=d00.nr01  ";
			}
			else if(pegasus_mysql_table_exists('a00') ){
				$t00_join = "
				join  a00 on tbl.".$tbl['fld1']."=a00.p21
				join d00 on a00.pnr01=d00.nr01  ";
			}

			if(!empty($query)){ $query .= ' UNION ';}
			$query .= "(select d65.p01 as mail, d00.nr01 as d00nr01, d65.nr01 as d65nr01, 
			p51.desc02 as fld, if(d65.pd100 = '$d65pd100', '$tax_min_val', '$tax_max_val' ) as tax, 
			d65.pd100 as d65pd100, d65.p02 as d65p02, d65.p300 as d65p300  from (select * 
			from " .$core_tbl. " where nr01=:nr01) as tbl 
			".$t00_join."
			join  d65 on d65.p00=d00.nr01 
			join p51 on p51.p02=:p02_".$i."_d and 
			desc05=:desc05_".$i." order by tax  )" ;
			
			$add_to_values_array = 1;

		}	
		
		if( strtolower($tbl['tbl2'])=='a00'){
			if(!empty($query)){ $query .= ' UNION ';}
            $query .= "(select d65.p01 as mail, d00.nr01 as d00nr01, d65.nr01 as d65nr01, 
			p51.desc02 as fld, if(d65.pd100 = '".$d65pd100."', ".$tax_min_val.", ".$tax_max_val.") as tax, 
			d65.pd100 as d65pd100, d65.p02 as d65p02, d65.p300 as d65p300  from (select * 
			from " .$core_tbl. " where nr01=:nr01 ) as tbl join  a00 
			on tbl.".$tbl['fld1']."=a00.nr01 join  d00 on a00.pnr01=d00.nr01 join  
			d65 on d65.p00=d00.nr01 join p51 on p51.p02=:p02_".$i."_d and 
			desc05=:desc05_".$i." order by tax  )" ;

			$add_to_values_array = 1;
		}
		
		if(strtolower($tbl['tbl2'])=='hota04'){
			if(!empty($query)){ $query .= ' UNION ';}
            $query .= "(select hota04.p045 as mail, 0 as d00nr01, 0 as d65nr01, p51.desc02 as 
			fld, 9999999 as tax, 0 as d65pd100, 0 as d65p02, 0 as d65p300  from  (select * 
			from " .$core_tbl. " where nr01=:nr01 ) as tbl join 
			hota04 on tbl.".$tbl['fld1']."=hota04.nr01  and hota04.pnr01=0/*Μόνο αν δεν έχει συναλλασσόμενο*/ 
			join p51 on p51.p02='hota04_d' and desc05='p045' order by tax )";

			$add_to_values_array = 1;	
		}

		if($add_to_values_array == 1){
			$values['nr01'] = $core_tbl_nr01;
			$values['p02_'.$i. '_d'] = $tbl['tbl1'] . '_d';
			$values['desc05_'.$i] = $tbl['fld1'];
			$i++;	
		}
		
	}

	if ($return_array){
		return array(
			'sql' => $query, 
			'sqlParams' => $values
		);
	} else {
		return pegasus_replace_values_in_sql($query, $values);
	}

}
