/**
 * @class Functions.domains.global
 * 
 * @member WebApp.view
 * 
 *  ##Properties
 *  
 *  The global variables of the module
 *  
 *   
 *  ##Methods
 * 
 	- General functions
 	- After draw functions
 *  
 *   
 */
/**
 * The request XSR on function {@link massexport_exportAction}
 * @type {string}
 */ 
var massexport_exportActionReq='';
function massexport_exportAction(container_id){
	var massExport_params = {};
	
	massExport_params.container_id 	= container_id;
	massExport_params.fname 		= pegGetVal('fname', container_id);
	massExport_params.ftype 		= pegGetVal('ftype', container_id);
	massExport_params.exp_no_titles = pegGetVal('exp_no_titles', container_id);
	massExport_params.tbl 			= pegGetVal('tbl', container_id);
	massExport_params.grid_d		= pegGetVal('grid_d', container_id);
	massExport_params.grid_name		= pegGetVal('grid_name', container_id);
	massExport_params.desc05		= pegGetVal('desc05', container_id);
	massExport_params.module		= pegGetVal('module', container_id);
	massExport_params.par_con_id	= pegGetVal('par_con_id', container_id);
	massExport_params.confirm 		= 1;	
	massExport_params.decimal_number_separator =  pegGetVal('decimal_number_separator', container_id);


	if(massexport_exportActionReq!=''){
	   if(massexport_exportActionReq.id>0){ 
		  Ext.ux.AjaxDefer.abort(massexport_exportActionReq);  
	   }
    }
	
	massexport_exportActionReq = pegAjax(
		'/' + main_path + '/massexport01/exportData00.php', 
		massExport_params , 
		function(jsondata){
			massexport_exportActionReq = '';
			if(jsondata.confirm==0){
				pegAlert(jsondata.msg);
			}else{
			
				pegConfirmBox( '', jsondata.msg , function(but){
					if(but=='yes'){
						massexport_task.start(); 	
						massexport_exportAction_loop(massExport_params.container_id, 0);
					}
				});
			}	 
		} , 
		'json'
	);
	

}

function massexport_exportAction_loop(container_id , execForTime){
	
	if(execForTime==undefined){
		execForTime = 0;
	}
	
	var massExport_params = {};
	massExport_params.container_id	= container_id;
	massExport_params.exec_for_time = execForTime;
	
	massexport_exportActionReq = pegAjax('/' + main_path + '/massexport01/exportData01.php' , massExport_params  , function(json_data){
		if(json_data.gotonext == 1){
			massexport_exportAction_loop(json_data.container_id , json_data.execForTime);
		}else{
			massexport_task.stop();
			Ext.getCmp(container_id +'_progressbar00').wait();
			Ext.getCmp(container_id +'_progressbar00').reset();
			if(json_data.ok==1){
				pegConfirmBox( '' , json_data.msg , function(but){
					 if(but=='yes'){
						 massexport_exportActionDownload(massExport_params.container_id)
					 }else{
						 massexport_exportActionRemove(massExport_params.container_id)
					 }
			 	});
				//pegMsgBox(json_data.msg);
			}else{
				pegAlert(json_data.msg);
			}
		}
	} , 'json');	
	
}
function massexport_exportActionDownload(container_id ){
	var massExport_params = {};
	
	var win0=0;
	if(win0){
		win0.close();
	}
	win0=window.open('/' + main_path + '/massexport01/exportData02.php?container_id=' +  container_id  , 'print00');
	
}

function massexport_exportActionRemove(container_id ){
	var massExport_params = {};
	massExport_params.container_id = container_id;
	pegAjax('/' + main_path + '/massexport01/exportData03.php' , massExport_params );
}

/**
 * The task runner {@link massexport__massexport_data_afterDraw_listeners}
 * @type {Ext.util.TaskRunner}
 */ 
var massexport_task={};
function massexport__massexport_data_afterDraw_listeners(container_id){
	var screen = pegGetCmp(container_id);
	var but = pegGetCmp(container_id , 'but');
	
	
//	Ext.onReady(function(){
		var massexport_updateTaskRunner = function () {
			if(!Ext.getCmp(container_id + '_progressbar00')){
				massexport_task.stop();
			}

			if(Ext.getCmp(container_id + '_progressbar00').wait()==false){
				massexport_task.stop();
			}


	        pegAjax('/' + main_path + '/massexport01/exec_task.php' , {'container_id' : container_id} , function(jsondata){
				var progressbar00 = pegGetCmp(container_id,'progressbar00');
				if(progressbar00){
					if(jsondata.text==''){
						progressbar00.updateProgress( '1', '', true );
					  }else{
						progressbar00.updateProgress( '1', jsondata.text , true );
					  }
				}else{
					massexport_task.stop();
				}
				
			 });
		};

		var massexport_runner = new Ext.util.TaskRunner();
		massexport_task = massexport_runner.newTask({
		     run: massexport_updateTaskRunner,
		     interval: 500
		});
		// console.info('massexport_task' , massexport_task);
//	});
		
	but.setHandler(function(){
//		Ext.getStore('peg_store_'+container_id+'_fields').load();   
		massexport_exportAction(container_id);
	});
}