<?php

// die(var_dump(get_declared_classes()));
require_once '../massexport_classes/includePHPExcel.php';
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\IOFactory;

class MassExport{
	/**
	 * To path gia ton tmp fakelo
	 * @var unknown
	 */
	private static $tmpPath = '../../tmp/massexportdata';
	/**
	 * O subfolder sto TMP Path.
	 * @var string
	 */
	private $subfolder;
	/**
	 * Kathe poses eggrafes tha kanei return
	 * @var Integer
	 */
	private static $step = 300;
	/**
	 * To Object gia export
	* @var \PhpOffice\PhpSpreadsheet\Spreadsheet
	*/
 	private $expObject ;
	/**
	 * Boolean metavliti
	 * gia to ean tha extupwnei toys 
	 * titlos
	 * @var boolean
	 */
	private $titlesTrigger ;
	
	private $endTrigger;
	/**
	 * Ta pedia poy ginontai export
	 * @var array(
	 * 		'FielName' => array(
	 * 			type => 
	 * 			desc =>
	 *  		length =>
	 *  		decimal =>
	 * 		)
	 * )
	 */
	private $expFields;
	private $expQuery;
	private $expWhereArray;

	private $expQuery00;
	private $expQuery00Code;
	private $expQueryAfter;
	private $expQueryAfterCode;
	/**
	 * To onoma tou arxeiou
	 * @var unknown
	 */
	private $fileName;
	/**
	 * To exeption toy arxeioy
	 * @var unknown
	 */
	private $fileExtension;
	private $output_encoding;

	/**
	 * To m type toy file
	 * Genete init sto file exeption
	 * @var MType pf file
	 */
	private $mtype;
	/**
	 * Gia poia fora ekteleite
	 * @var unknown
	 */
	private $execForTime;
	private $totalRec;
	
	private $startColumn;
	private $startRow;
	
	private $data; 
	
	
	public $module;
	public $table;
	public $container_id;

	private $decimal_number_separator = 0;
	private $exp_no_titles = 0;
	
	function __construct($massexport_ar){
		$this->setFileName($massexport_ar["fname"]);
		$this->setFileExtension($massexport_ar["ftype"]);
		$this->_setOutputEncoding($massexport_ar["output_encoding"]);
		$this->_setExportField($massexport_ar["exp_fld_json"]);
		$this->_setExportQuery($massexport_ar["exp_data_query"] , $massexport_ar["exp_data_queryWhereParams"] ); 
		 
		$this->expQuery00          = $massexport_ar["exp_data_query00"];
		$this->expQuery00Code      = $massexport_ar["exp_data_query00_code"];
		$this->expQueryAfter       = $massexport_ar["exp_data_query_after"];
		$this->expQueryAfterCode   = $massexport_ar["exp_data_query_after_code"];
		 
		$this->module 			   = $massexport_ar["module"];
		$this->table  	    	   = $massexport_ar["tbl"];
		$this->container_id        = $massexport_ar["container_id"];

		$this->decimal_number_separator = $massexport_ar['decimal_number_separator'];
		$this->exp_no_titles 			= $massexport_ar['exp_no_titles'];

		if($massexport_ar['cntexp']>0){
			$this->totalRec = $massexport_ar['cntexp'];
		}else {
			$this->totalRec = -1;
		}
		/*  
		 $cacheMethod = PHPExcel_CachedObjectStorageFactory::cache_to_sqlite3;
		 if (!PHPExcel_Settings::setCacheStorageMethod($cacheMethod)) {
		 	die($cacheMethod . " caching method is not available" . EOL);
		 }
		  */
		$this->endTrigger = FALSE;
		$this->subfolder 	= date('d');

		$ret = @is_dir(MassExport::$tmpPath.'/'.$this->subfolder.'/');
		if(!$ret){
			$this->_createExportDir();	
		}

	  	// $cacheMethod = PHPExcel_CachedObjectStorageFactory::cache_to_discISAM;
		$cacheSettings = array( 
		    'dir' => realpath(MassExport::$tmpPath)
		);
		// if(!PHPExcel_Settings::setCacheStorageMethod($cacheMethod, $cacheSettings)){
		// 	die($cacheMethod . " caching method is not available" );
	 	// }
		 
	
		
		
	}
	

	
	function __destruct(){
		/* $mode = 'a';
		if($this->execForTime==0){
			$mode = 'w';
		}
		$fp = fopen(MassExport::$tmpPath.'/massexport.log', $mode );
		fprintf($fp, "Exec for time %d \n \tCurrent memory usage: %f MB \n\tPeak memory usage: %f MB \n  ",$this->execForTime,(memory_get_usage(true) / 1024 / 1024),(memory_get_peak_usage(true) / 1024 / 1024)  );
		fclose($fp); */
	}
	
	public function hasMore(){
		return !($this->endTrigger);
	}
	public function getLogText(){
		
		return str_replace(
				array('##fromrec##' ,'##torec##'), 
				array((($this->execForTime*MassExport::$step) +1),(($this->execForTime+1)*MassExport::$step) ), 
				$_SESSION['peg_dic_massexport_cp_ins']
		);
		
	}
	/**
	 * Epistre to path tou arxeioy
	 * @return string
	 */
	public function getFilePath(){
		return MassExport::$tmpPath."/".$this->subfolder."/";
	}
	
	public function getMtype(){
		return $this->mtype;
	}
	public function getFullFileName(){
		return $this->fileName.'.'.$this->fileExtension;
	}

	public function setExecForTime($i){
		if($i>=0){
			$this->execForTime = (int) $i;
		}
		if(($this->execForTime*MassExport::$step) >=  $this->totalRec and $this->totalRec >0 ){
			$this->endTrigger = true;
		}
		
		//$this->_setExcelRow();
	}
	
	private function _setExcelRow($i=0){
		if($i>0){
			$this->excelRow = $i;
		}
		$this->excelRow = $this->execForTime*MassExport::$step;
		if($this->excelRow == 0){
			$this->excelRow = 2;
		}
	}
	
	/**
	 * Kanei Set to onoma toy arxeioy
	 * @param sring $filename
	 */
	public function setFileName($filename){
		if(!empty($filename)){
			$this->fileName = $filename;
			return ;
		}
		if(empty($this->fileName )){
			$this->fileName = "Undefined";
		}
		
	}
	/**
	 * Kanei Set to file Extension
	 * @param unknown $fileExtension
	 */
	public function setFileExtension($fileExtension){
		if(!empty($fileExtension) && in_array($fileExtension, array('xlsx','txt','csv'))){
			//TODO Check the file extension from an array
			$this->fileExtension = $fileExtension;
		}
		if(empty($this->fileExtension )){
			$this->fileExtension = "xlsx";
		}
		if(strtolower($this->fileExtension)=='xlsx'){
			$this->mtype = 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet';
		}
	}
	
	public function saveToSTDOUT(){
		$this->{'_saveToStdOut'.ucwords($this->fileExtension)}();
	}

	private function _saveToStdOutTxt(){
		$file_content = file_get_contents($this->getFilePath().$this->getFullFileName());
		peg_write_file('php://output', $file_content);
	}

	private function _saveToStdOutXlsx(){
		$this->expObject = \PhpOffice\PhpSpreadsheet\IOFactory::load($this->getFilePath().$this->getFullFileName());
		$objWriter 		 = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($this->expObject, 'Xlsx');
		$objWriter->save('php://output');
	}

	private function _saveToStdOutCsv(){
		$file_content = file_get_contents($this->getFilePath().$this->getFullFileName());
		peg_write_file('php://output', $file_content);
	}
	
	/**
	 * Kanei initializei to object
	 */
	public function initObject(){
		if($this->execForTime==0 and file_exists($this->getFilePath().$this->getFullFileName())){
			throw new Exception("File exist. Can not overwrite");
		}

		$this->{'_initObject'.ucwords($this->fileExtension)}();
	}

	private function _initObjectXlsx(){
		if($this->execForTime==0){
			$this->_initExcelObject();
		}else{
			$this->expObject = \PhpOffice\PhpSpreadsheet\IOFactory::load($this->getFilePath().$this->getFullFileName());
			$this->expObject->setActiveSheetIndex(0);
		}
		list ($this->startColumn, $this->startRow) = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::coordinateFromString("A1");
	}

	private function _initObjectTxt(){		
		$this->expObject = new stdClass();
		if($this->execForTime==0){
			$this->expObject->txt = '';

			if($this->exp_no_titles!=1){
				$this->_pushDataTitlesToObjectTxt();
			}
		}else{
			$this->expObject->txt = file_get_contents($this->getFilePath().$this->getFullFileName());
		}
	}

	private function _initObjectCsv(){	
		if($this->execForTime==0){
			$this->expObject = new parseCSV();
			$this->expObject->delimiter 	  = ';';
			$this->expObject->input_encoding  = 'UTF-8';
			$this->expObject->output_encoding = 'ISO-8859-7';	

			if($this->exp_no_titles!=1){
				$this->_pushDataTitlesToObjectCsv();
			}
		}else{
			$this->expObject = new parseCSV($this->getFilePath().$this->getFullFileName());
		}		
	}
	
	
	/**
	 * Diavazei ta dedomena kai ta kanei se
	 * @return number ton ariymo twn dedomenwn pou diavasai
	 */
	public function readData(){
		$this->data = array();

		/* Before Query */
		$query00_array = $this->_setExportQuery00Array(($this->execForTime+1), MassExport::$step);
		//peg_write_file("../../tmp/massexport_query00_array_".$this->execForTime, print_r($query00_array,1));
		foreach ($query00_array as $qq) {
			if (is_array($qq)) {
				$sql 		= $qq['sql'];
				$sqlParams  = $qq['sqlParams'];
			} else {
				$sql 		= $qq;
				$sqlParams  = array();
			}
			if(strpos($sql, ';')>0){
				pegasus_query($sql, $sqlParams);
			}
		}

		
		$result = pegasus_query(
			$this->expQuery . " limit ".($this->execForTime*MassExport::$step)." , ".MassExport::$step." ",
			$this->expWhereArray	
		);


		/* After Query */
		$query_after_array = $this->_setExportQueryAfterArray(($this->execForTime+1), MassExport::$step);		
		//peg_write_file("../../tmp/massexport_query_after_array_".$this->execForTime, print_r($query_after_array,1));
		foreach ($query_after_array as $qq) {
			if (is_array($qq)) {
				$sql 		= $qq['sql'];
				$sqlParams  = $qq['sqlParams'];
			} else {
				$sql 		= $qq;
				$sqlParams 	= array();
			}
			if(strpos($sql, ';')>0){
				pegasus_query($sql, $sqlParams);
			}
		}
		
		$resultNum = 0;
		$hasFieldAr = (count($this->expFields) > 1);
		while ($tb = pegasus_fetch_assoc($result)) {

			if($hasFieldAr){
				$arr = array();
				foreach ($this->expFields as $fld) {
					if (!empty($fld['browse_value'])) {
						if ($fld['browse_value_code'] == 1) {
							$arr[$fld['name']] = eval($fld['browse_value']);
						} else {
							$arr[$fld['name']] = $fld['browse_value'];
						}
					}
					else{
						$arr[$fld['name']] = $tb[$fld['name']];
					}
					
				}
				$this->data[] = $arr;
				unset($arr);
			}
			else{
				$this->data[] = $tb;
			}

			
			$resultNum++;
		}
		if($resultNum<MassExport::$step){
			$this->endTrigger = TRUE;
		}
		return $resultNum;
	}
	
	/**
	 * Kanei push to $this->data sto object
	 */
	public function pushDataToObject(){
		$this->{'_pushDataToObject'.ucwords($this->fileExtension)}();
	}

	private function _pushDataToObjectXlsx(){
		$currentRow   = ($this->expObject->getActiveSheet()->getHighestRow()+1);
		$startDataRow = $this->startRow+2;	

		if($this->exp_no_titles==1){
			if($this->execForTime==0){
				$currentRow = $this->expObject->getActiveSheet()->getHighestRow();
			}
			$startDataRow = $this->startRow;
		}
		
		foreach ($this->data as $rowData){
			$currentColumn = $this->startColumn;
			foreach ($this->expFields as $key => $field){
				$this->_setExcelCell($this->expObject->setActiveSheetIndex(0)->getCell($currentColumn . $currentRow), $rowData[$key], $field);
				++$currentColumn;
			}
			++$currentRow;
		}

		if($this->endTrigger){
			$currentColumn = $this->startColumn;
			foreach($this->expFields as $key => $field) {
				if ($field['browse_sum']=='sum') {
					$this->expObject->getActiveSheet()->getCell($currentColumn . $currentRow)->setValue('=SUM(' . $currentColumn . $startDataRow .':' . $currentColumn . ($currentRow - 1) . ')');
				}
				++$currentColumn;
			}	
		}
	}

	private function _pushDataTitlesToObjectTxt(){

		$total_length = 0;
		foreach ($this->expFields as $key => $field){
			$total_length += ($field['db_type']=='M' && $field['length']<60) ? 60 : $field['length'];
			if($field['decimal']>0){
				$total_length++;
			}
		}

		$txt_line	 = '';
		$txt_line_00 = pegasus_print_space($total_length);
		$txt_line_01 = pegasus_print_space($total_length);
		$start 		 = 0;
		foreach ($this->expFields as $key => $field){
			$length = $field['length'];
			if($field['db_type']=='N'){
				if($field['decimal']>0){
					$length++;
				}
			}

			$spaces_length  = $length - peg_strlen($key);
			$value 			= ($spaces_length>0) ? $key . pegasus_print_space($spaces_length) : peg_substr($key, 0, $length);
			$txt_line_00 	= pegasus_mb_substr_replace($txt_line_00, $value, $start, $length);

			$spaces_length  = $length - peg_strlen($field['desc']);
			$value 			= ($spaces_length>0) ? $field['desc'] . pegasus_print_space($spaces_length) : peg_substr($field['desc'], 0, $length);			
			$txt_line_01 	= pegasus_mb_substr_replace($txt_line_01, $value, $start, $length);

			$start += $length;
		}
		
		$txt_line  = trim($txt_line_00);
		$txt_line .= chr(13) . chr(10);
		$txt_line .= trim($txt_line_01);
		$txt_line .= chr(13) . chr(10);

		$this->expObject->txt = $txt_line;
	}

	private function _pushDataToObjectTxt(){

		$total_length = 0;
		foreach ($this->expFields as $key => $field){
			$total_length += ($field['db_type']=='M' && $field['length']<60) ? 60 : $field['length'];
			if($field['decimal']>0){
				$total_length++;
			}
		}

		$txt_line = '';
		foreach ($this->data as $rowData){
			//Πιθανο θεμα με μηκος χαρακτηρα
			$txt_line_tmp = pegasus_print_space($total_length*2);
			$start 		  = 0;
			foreach ($this->expFields as $key => $field){
				$length = ($field['db_type']=='M' && $field['length']<60) ? 60 : $field['length'];

				if($field['db_type']=='N'){
					if($field['decimal']>0){
						$length++;
					}
					$value = $rowData[$key];
					if($this->decimal_number_separator == 1) {
						$value = peg002_format_number($value, $field['decimal'], 0, '', ',');
					}else{
						$value = peg002_format_number($value, $field['decimal'], 0, '', '.');
					}
				}elseif($field['db_type']=='D'){
					$value = peg_dateToStr($rowData[$key], 'd/m/y');
				}elseif($field['db_type']=='L'){
					$value = ($rowData[$key]) ? 1 : 0;
				}else{
					$spaces_length = ($length - peg_strlen($rowData[$key]));
					$value = ($spaces_length>0) ? $rowData[$key] . pegasus_print_space($spaces_length) : peg_substr($rowData[$key], 0, $length);
									
				}
				
				//$value = $start.','.$length;
				$txt_line_tmp = pegasus_mb_substr_replace($txt_line_tmp, $value, $start, $length);
				$start += $length;
			}
			
			$txt_line .= trim($txt_line_tmp);
            $txt_line .= chr(13) . chr(10);
		}

		if(!empty($this->output_encoding)){
			$txt_line = iconv('UTF-8', $this->output_encoding, $txt_line);	
		}
		
		$this->expObject->txt .= $txt_line;
	}

	
	private function _pushDataTitlesToObjectCsv(){

		$this->expObject->input_encoding  = 'UTF-8';
		$this->expObject->output_encoding = 'ISO-8859-7';

		foreach ($this->expFields as $key => $field){
			$this->expObject->titles[] = $key;
			$this->expObject->desc[]   = iconv($this->expObject->input_encoding, $this->expObject->output_encoding, $field['desc']);
		}
	}

	private function _pushDataToObjectCsv(){
	
		$this->expObject->delimiter 	  = ';';
		$this->expObject->input_encoding  = 'UTF-8';
		$this->expObject->output_encoding = 'ISO-8859-7';		

		$body_data = array();

		//Προσθέτουμε τα ονόματα των πεδίων κάθε στήλης Δ: 10200871 ΠΠΥ: 10019699
		if(is_array($this->expObject->desc) && count($this->expObject->desc)>0){
			$body_data[] = $this->expObject->desc;
		}

		foreach ($this->data as $rowData){
			$body_data_row = array();
			foreach ($this->expFields as $key => $field){
				if(pegasus_check_utf8($rowData[$key])){
					if(
						$field['db_type'] == 'N'
						&& $this->decimal_number_separator == 1
					) {
						$value = str_replace('.',',',iconv($this->expObject->input_encoding, $this->expObject->output_encoding, $rowData[$key]));
					} else {
						$value =  iconv($this->expObject->input_encoding, $this->expObject->output_encoding, $rowData[$key]);
					}
				}
				$body_data_row[] = $value;
			}
			$body_data[] = $body_data_row;
		}

		$this->expObject->data = $body_data;
	}
	
	private function _setExcelCell( $cel ,$value, $type = array()){
		if(!($cel instanceof \PhpOffice\PhpSpreadsheet\Cell\Cell)){
			throw new Exception("Not PHPExcel_Cell");
		}
		if(strtoupper($type['db_type']) == 'V' || strtoupper($type['db_type']) == 'C' ||  ( strtoupper($type['db_type']) == 'M' and  strtoupper($type['type'])!='TINYMCE'  ) ){
// 			$cel->setDataType()$objRichText2 = new PHPExcel_RichText();
			if(!empty($value)){
				//Εδώ υπάρχουν περιπτώσεις που έχουμε μεταβλητή Variable και είναι δεκαδικός αριθμός οπότε θέλω να εμφανίζεται όπως είναι και όχι ως string
				if(strlen($value) < 12 or strpos($value, '.') == true){
					$objText = new \PhpOffice\PhpSpreadsheet\RichText\TextElement($value);
				
					$cel->setValue($objText->getText());
				}else{
					//ΠΠΥ 10029768 - Σε νούμερα με μέγεθος < 12 τα εμφάνιζε ως scientific
					$cel->setValueExplicit($value, \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING);
				}
			}
		}elseif ( strtoupper($type['db_type']) == 'M' and  strtoupper($type['type'])=='TINYMCE'  ){
			
			$text = html_entity_decode($value, ENT_COMPAT , "UTF-8");
			$ttt = new html2text($text);
			$text = $ttt->get_text();
// 			$cel->setValue($text );
			$type['type'] = 'MEMO';
			$this->_setExcelCell($cel, $text ,$type);
			/* Den paizei logo tou encode
			$wizard = new PHPExcel_Helper_HTML;
			$cel->setValue($wizard->toRichTextObject($value)); */
		}elseif (strtoupper($type['db_type']) == 'N'){
			//$cel->setFormatCode('#,##0.00');
			// E: 10000458
			if($this->decimal_number_separator == 1) {
				$value = str_replace('.',',',$value);
				$cel->setValueExplicit($value, \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING);
			} else {
				$cel->setValueExplicit($value, \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_NUMERIC);
			}
		}elseif (strtoupper($type['db_type']) == 'L'){
			//$cel->setValueExplicit($value, PHPExcel_Cell_DataType::TYPE_NUMERIC);
			if($value)
				$cel->setValue(true);
			else 
				$cel->setValue(false);
		}elseif (strtoupper($type['db_type']) == 'D'){
			$cel->setValueExplicit($value, \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING);
			//->setCellValue('C10', PHPExcel_Shared_Date::PHPToExcel( $dateTimeNow ));
		}else {
			$cel->setValue("Underfinted Type ='".$type['db_type']."' " );
		}
		
		
	}
	
	/**
	 * Kanei right to object
	 */
	public function writeObject(){
		$this->{'_writeObject'.ucwords($this->fileExtension)}();
	}

	private function _writeObjectXlsx(){
		//list ($startColumn, $startRow) = PHPExcel_Cell::coordinateFromString("A1");
		$currentColumn = $this->startColumn;
		foreach($this->expFields as $cellValue){
			$this->expObject->getActiveSheet()->getColumnDimension($currentColumn)->setAutoSize(true);
			++$currentColumn;
		}
		
		// Rename worksheet
		//ΠΠΥ: 10030791
		$title_len = $this->expObject->getActiveSheet()::SHEET_TITLE_MAXIMUM_LENGTH;
		$this->expObject->getActiveSheet()->setTitle(substr($this->module.'-' .$this->table, 0, $title_len));
		// Set active sheet index to the first sheet, so Excel opens this as the first sheet
		$this->expObject->setActiveSheetIndex(0);
		
		
		$objWriter = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($this->expObject, 'Xlsx');
		//$objWriter->setOffice2003Compatibility(true);
		$objWriter->save($this->getFilePath().$this->getFullFileName());
	}

	private function _writeObjectTxt(){
		//$fp = fopen($this->getFilePath().$this->getFullFileName(), 'a+');
		$fp = fopen($this->getFilePath().$this->getFullFileName(), 'w+');
		fwrite($fp, $this->expObject->txt);
	}
	
	private function _writeObjectCsv(){
		$this->expObject->save($this->getFilePath().$this->getFullFileName(), array(), $this->execForTime, array());
	}

	private function _setOutputEncoding($output_encoding){
		$this->output_encoding = (isset($output_encoding)) ? $output_encoding : '';
	}
	
	/**
	 * Kanei set to query apo to opoio tha vgoune ta dedomena
	 * @param unknown $query
	 * @throws Exception
	 */
	public function _setExportQuery($query, $whereArray = array()){
		if(!empty($query)){
			$this->expQuery = $query;
			$this->expWhereArray =  $whereArray;
		}else 
			throw new Exception("Empty query");
	}
	
	private function _setExportField($data){
		$this->expFields = json_decode($data, true);
		if($this->expFields ===NULL){
			throw new Exception(" Json decode error " . json_last_error());
		}
	}

	private function _setExportQuery00Array($page=0, $limit=0){
		$limit 			= ($limit>0) ? $limit : MassExport::$step;
		$container_id 	= $this->container_id;

		$query00 		= '';
		$query00_array 	= array();
		if(!empty($this->expQuery00)){
			if ($this->expQuery00Code==1) {
				$query00 = eval($this->expQuery00);
				if (is_array($query00)) {
					$query00_array = $query00;
				}
			}else{
				$query00 = $this->expQuery00;
			}
		}
		
		if (empty($query00_array) && !is_array($query00)) {
			$query00_array = explode('/*peg_end*/', $query00);
		}

		return $query00_array;
	}

	private function _setExportQueryAfterArray($page=0, $limit=0){
		$limit 			= ($limit>0) ? $limit : MassExport::$step;
		$container_id 	= $this->container_id;
		
		$query_after 	   = '';
		$query_after_array = array();
		if (!empty($this->expQueryAfter)) {
			if ($this->expQueryAfterCode==1) {
				$query_after =  eval($this->expQueryAfter);
				if (is_array($query_after)) {
					$query_after_array = $query_after;
				}
			} else {
				$query_after =  $this->expQueryAfter;
			}
		}
		
		if (empty($query_after_array) && !is_array($query_after)) {
			$query_after_array = explode('/*peg_end*/', $query_after);
		}

		return $query_after_array;
	}
	
	/**
	 * Kanei initializei ena office object
	 * @throws Exception
	 */
	private function _initExcelObject(){
		if(!(is_array($this->expFields))){
			throw new Exception("You must initialize fields before _initExcelObject " . var_export($this->expFields) );
		}
	
		$this->expObject = new Spreadsheet();

		// die(var_dump(array($_SESSION['copy'],trim($_SESSION['z06_copy']))));
		$copy = '';
		if(!empty($_SESSION['copy'])){
			$copy = $_SESSION['copy'];
		}else{
			$copy = $_SESSION['z06_copy'];
		}
		//Εαν το $copy έρθει ως null από τα παραπάνω if/else χτυπάει γιατί το setCreator παίρνει string 
		$copy = !is_null($copy) ? $copy : '';
		$this->expObject->getProperties()->setCreator($copy)
			->setLastModifiedBy($copy)
			->setTitle($this->fileName)
			->setSubject("Office 2007 XLSX Export")
			->setDescription("Export for module ".$this->module ." table ".$this->table." document for Office 2007 XLSX")
			->setKeywords("Export for module ".$this->module ." table ".$this->table." Pegasus Hermes Application");
		$this->expObject->setActiveSheetIndex(0);
	
		list ($startColumn, $startRow) = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::coordinateFromString("A1");
		$currentColumn =$startColumn;

		
		if($this->exp_no_titles!=1){
			foreach($this->expFields as $key => $cellValue) {
				$this->expObject->getActiveSheet()->setCellValue($currentColumn . $startRow, $key);
				
				//$ttt = str_replace('<br>', '\n', $cellValue['desc']);
				//$objText = new PHPExcel_RichText_TextElement($cellValue['desc']);
				$this->_setExcelCell($this->expObject->setActiveSheetIndex(0)->getCell($currentColumn . ($startRow+1)), $cellValue['desc'], array('db_type'=>'M','type' => 'TINYMCE'  ));
				
				++$currentColumn;
			}
		}	
	}

	/**
	 * To export dir einai ayto /tmp/massexportdata/date('d')/
	 * oloi xrisimopoioun to idio mias kai mono enas mporei na gracei to arxeio
	 * Ean trexei gia proti fora ths sigkekrimenhs hmeras tha diagrapsei kai ola ta dir 
	 * twn allwn hmervn
	 * @throws Exception
	 */
	private function _createExportDir(){
		//Thelw na kanw delete mono otan dimiourgo mono ton fakelo ths hmeras 
		$deleteAction = true;
		
		$ret = @is_dir(MassExport::$tmpPath);
		if(!$ret){
			$deleteAction = false;
			$ret = @mkdir(MassExport::$tmpPath);
			if(!$ret){
				throw new Exception("Can not create " . MassExport::$tmpPath);
			}
		}
		$ret = @is_dir(MassExport::$tmpPath . '/' . $this->subfolder);
		if(!$ret){
			$ret = @mkdir(MassExport::$tmpPath. '/' . $this->subfolder);
			if(!$ret){
				throw new Exception("Can not create " . MassExport::$tmpPath. '/' . $this->subfolder);
			}
		}else{
			$deleteAction = false;
		}
		if($deleteAction){
			$this->_deleteExportDir(array($this->subfolder));
		}
	}
	/**
	 * Diagrafei olois rous upofakelous toy MassExport::$tmpPath
	 * ektos apo aytous poy einai sto orisma $notDeleteAr = arra('24',....);
	 * @param array $notDeleteAr ta directory poy den thlw na diagrafoune
	 */
	private function _deleteExportDir($notDeleteAr = array()){
		$mode = 'a';
		
		$subDirAr = peg_scandir(MassExport::$tmpPath);
		foreach ($subDirAr as $subDir) {
			if(!(in_array($subDir, $notDeleteAr))){
				pegasus_delete_directory(MassExport::$tmpPath.'/'.$subDir);
			
			}
		}
		
	}
	
}