<?php

    function mydt_mydt10_d_initialize($data,$mmnr01,$mnr01,$_d,$container_id){

        // Ε: 10000859
        $data['auth_cd_readonly'] = true;

        // Πλέον θέλω τα mydt11, mydt12 να παίζουν με tmp
        pegasus_make_all_tmp_recs('mydt10', $data, $data['nr01'], 0, 'mydt10_d-' . $data['nr01']);

        //* Ton mydt11 τον διαβάζω από tmp. Για τον mydt12 δεν χρειάζεται, δεν μπορεί να πειραχτεί και ενημερώνεται πάντα μετά την καταχώρηση του mydt10 αυτόματα
        pegasusSetGlobalVar(
            $container_id . '_where_grid_mydt11',
            array(
                'sql' => 'peg_tmp_mydt11.mydt10=:mydt10 AND
                          peg_flag <> 9 AND
                          peg_mmnr01  = :peg_mmnr01 AND
                          peg_mnr01   = :peg_mnr01 AND
                          peg_sess_id = :peg_sess_id', 
                'sqlParams' => 
                    array(
                        'mydt10'     => $data['nr01'],
                        'peg_mmnr01' => $mmnr01,
                        'peg_mnr01'  => $mnr01,
                        'peg_sess_id'=> session_id() 
                )
            )
        );
        pegasusSetGlobalVar( $container_id . '_where_grid_mydt12'    ,  array('sql'=>'mydt12.mydt10=:mydt10' ,'sqlParams' => array('mydt10' => $data['nr01']) ));
        pegasusSetGlobalVar( $container_id . '_where_grid_mydt13'    ,  array('sql'=>'mydt13.mydt10=:mydt10' ,'sqlParams' => array('mydt10' => $data['nr01']) ));
        pegasusSetGlobalVar( $container_id . '_where_grid_mydt14'    ,  array('sql'=>'mydt14.mydt10=:mydt10' ,'sqlParams' => array('mydt10' => $data['nr01']) ));
        if(pegasus_module_exists('dc00') && pegasus_mysql_table_exists('dc0003')){
            pegasusSetGlobalVar( $container_id . '_where_grid_dc0003',  array('sql'=>'dc0003.mydt10=:mydt10' ,'sqlParams' => array('mydt10' => $data['nr01']) ));
        }
        if($data['rel_nr']>0){
            // $data['message']  = '<div class="warning_message">'.$_SESSION['peg_dic_mydt_mydt10_is_related']. '</div>';
            //* Link στο αντίστοιχο mydata παραστατικό
            $tmp_link = ' <a href="'."javascript:peg002_addTab_d('' , 'mydt10', 'mydt10_d', 'mydt', '', '".$data['rel_nr']."');void(0);".'">' . $data['rel_nr'] . '</a>';
            $data['message'] = '<div class="warning_message">' . $_SESSION['peg_dic_mydt_mydt10_is_related'] .' '. $tmp_link . '</div>';
        }

        // Δικαίωμα Τροποποίησης myDATA Παραστατικών
        if(   (!pegasus_check_permission('mydt_master') && $data['einv'] == 0)
            || (!pegasus_check_permission('einv_master') && $data['einv'] != 0)
            || $data['p09'] != 0
        ) {
            $data['mydt_mydt10_d10_readonly'] = 1;
            $data['mydt_mydt10_d11_readonly'] = 1;
            $data['mydt_mydt10_d12_readonly'] = 1;
            $data['mydt_mydt10_d13_readonly'] = 1;
            $data['mydt_mydt10_d14_readonly'] = 1;
            $data['mydt_mydt10_d16_readonly'] = 1;

            // Πεδία που εμφανίζονται έξω από τα tabs.
            $data['uid_readonly'] = 1;
            $data['mark_readonly'] = 1;
            $data['qrurl_readonly'] = 1;
            $data['dmark_readonly'] = 1;
            $data['entuid_readonly'] = 1;
            $data['p03_readonly'] = 1;
            
        }

        //* Αν είναι ηλεκτρονική κάνουμε όλο το mydt10 readonly για να μην εμφανίζεται καταχώρηση/ενημέρωση
        // Δεν το κάνουμε για τις περιπτώσεις δικαιώματος και δημιουργία από myDATA για να μπορεί να καταχωρείται η αντιστοίχιση.
        if(!pegasus_check_permission('einv_master') && $data['einv'] != 0) {
            $data['readonly'] = 1;
        }


        // Εμφανίζω το toolbar item για την ενημέρωση αντίστοιχων αναλυτικών γραμμών
        $data['mydt_mydt10_d13_grid_mydt_update_linerel_hidden'] = false;

        if(empty($data['message'])){
            $data['message_hidden']=1;
        }

        if(pegasus_module_exists('einv')) {
            $data['mydt_mydt10_d_einv_hidden'] = 0;
            $data['mydt_mydt10_d_auth_cd_hidden'] = 0;
        }
        /**
         * Ε: 10000859
         * 
         * Αν o USER έχει το mydt_master και το παραστατικό είναι για ηλεκτρονική τιμολόγηση 
         * Pegasus και είναι σε κατάσταση transmission failure 2 αλλά δεν έχει πάρει 
         * Authorization Code τότε επιτρέπουμε την καταχώρηση του Authorization Code.
         */
        if(
            pegasus_module_exists('einv')
            && pegasus_check_permission('mydt_master')
            &&  $data['einv'] == 1
            &&  $data['tr_fail'] == 2
            &&  empty($data['auth_cd'])
        ) {
            $data['auth_cd_readonly'] = false;
        }
        
        return $data;
    }

    function mydt_mydt10_d54_initialize($data,$mmnr01,$mnr01,$_d,$container_id){
        global $PegInput;
        $PegInput->addVar(new peg_input_alphanumeric('mydt10_invtype'));

        $data['p01']  = pegasus_mysql_printfld('q31', 'p03', 'p01="620016" and p05=?', array($PegInput->getRequest('mydt10_invtype'))); //είδος πραστατικού
        $data['p02']  = pegasus_mysql_printfld('q31', 'p03', 'p01="620018" and p05=?', array($PegInput->getRequest('mydt10_invtype'))); //είδος πραστατικού
  
        return $data;
    }

    function mydt_mydt10_d_execute_after_save($data){
        require_once('../mydt_libs/mydt_mydt10.php');

        mydt_mydt10::create_mydt12_records($data['tbl'], $data['tbl_nr01']);
    }

    function mydt_mydt11_d_initialize($data,$mmnr01,$mnr01,$_d,$container_id){

        pegasus_mysql_use("SELECT einv, p09 FROM mydt10 WHERE nr01=? ", $mydt10, array($data['mydt10']));
        if(    (!pegasus_check_permission('mydt_master') && $mydt10['einv'] == 0)
            || (!pegasus_check_permission('einv_master') && $mydt10['einv'] != 0)
            || $mydt10['p09'] != 0
        ) {
            $data['readonly'] = 1;
        }else{
            $related_mydt10 = pegasus_mysql_printfld('mydt10', 'nr01', 'rel_nr = ?', array($data['mydt10']));
            if(empty($related_mydt10)) {
                $data['linerel_readonly'] = 1; // Αν δεν έχει αντίστοιχο παραστατικό, το κάνω readonly. 
            }else{
                //To Where για το selectbox του linerel
                pegasusSetGlobalVar(
                    $container_id. '_where_linerel' ,    
                    array(
                        'sql'       =>  ' mydt11.mydt10 = :rel_mydt10',
                        'sqlParams' =>  array(
                            'rel_mydt10' => $related_mydt10
                    )
                ));
            }
        }
        
        return $data;
    }

    /**
     * Custom actions για το grid στο tab "Αναλυτικές Γραμμές Παραστατικού" 
     *
     * @param retArray ο πίνακας όπου βάζουμε τα Toolbar Grid Actions
     * @param id Πρέπει να έρχεται συμπληρωμένο. Είναι το όνομα του grid
     * @return array
     */
    function mydt_mydt10_d13_custom_actions_peg002($retArray = array(), $id = ''){
        /* Ενημέρωση γραμμών από το αντίστοιχο παραστατικό */
        $peg_handler = 'mydt_toolbar_item_mydt11_update_linerel(
                                    screen.getContainer_ID(),
                                    \'' . $id . '\');';
        $retArray[] = array(
            'xtype' => 'pegasusToolBarGridAction',
            'peg_custom_id' => 'mydt_update_linerel',
            'icon' => 'mydt_images/mydt_update_linerel_16x16.png',
            'text' =>  $_SESSION['peg_dic_mydt_mydt11_update_linerel_toolbar_text'],
            'peg_handler' => $peg_handler
        );

        return $retArray;
    }

    function mydt_mydt12_d_initialize($data,$mmnr01,$mnr01,$_d,$container_id){
        $data['readonly'] = 1;
        return $data;
    }

    function mydt__mydtres_d_initialize($data,$mmnr01,$mnr01,$_d,$container_id){
        require_once('../mydt_libs/mydt_mydt10.php');


        $einv_data = array(0);
        $data["mydt__mydtres_d_einv_ls_data"] = array(
            array('p01' => 0, 'p02' => 'Χωρίς')
        );
        if(pegasus_module_exists('einv')) {
            $data["mydt__mydtres_d_einv_ls_data"][] = array('p01' => 1, 'p02' => 'Pegasus e-Invoicing');
            $einv_data[] = 1;
        }
        if(pegasus_module_exists('einv01')) {
            $data["mydt__mydtres_d_einv_ls_data"][] = array('p01' => 2, 'p02' => 'Softone e-Invoicing');
            $einv_data[] = 2;
        }
        if(pegasus_module_exists('einv02')) {
            $data["mydt__mydtres_d_einv_ls_data"][] = array('p01' => 3, 'p02' => 'ΙΛΥΔΑ e-Invoicing');
            $einv_data[] = 3;
        }
        $data['einv'] = "#".implode('#',$einv_data).'#';
        
        //Create invoices
        $data['t_p01']  = '01000101';
        if (pegasus_module_exists('stores')) {
            $client_stores = peg_stores_get_all_stores_multi();
            $data['stores'] = $client_stores ;
            $data['stores_search'] = $client_stores ;
        }
        //$data['stores'] =  '#' . pegasus_mysql_printfld('t07' , "GROUP_CONCAT(DISTINCT p01 ORDER BY  p01 ASC SEPARATOR '#')" , "nr01>0" ) . '#';
        $stores_st = mydt_mydt10::make_store_where($data['stores']);
        if(!empty($stores_st['sql'])){
            $p08 =   explode( ';', pegasus_mysql_printfld('mydt10' , "max(concat(p08d, ';', p08t) )" , " p03 in (:". $stores_st['sql'].") " ,  $stores_st['sqlParams'] ))  ;
        }else{
            $p08 =   explode( ';', pegasus_mysql_printfld('mydt10' , "max(concat(p08d, ';', p08t) )" , " nr01>0 ")) ;
        }
        
        if(empty( $p08[0])){
            $p08[0] = $_SESSION['mydt00_p104'];
            $p08[1] = '';
        }        

        $data['t_p07d'] = $p08[0];  
        $data['t_p07t'] = $p08[1];

        $data['t_p08d'] = date('Y-m-d');
        $data['t_p08t'] = '23:59:59';

        
        //search filters
        $data['show_only']  = 0; //το show_only δεν αρχικοποιείται στην initialize
        $data['mydt10_p01'] = 0;
        $data['related']    = 0;
        $data['classified'] = 0;
        $data['errors']     = 0;
        
        $data['dt_from'] = date('Y-01-01');
        $data['dt_to']   = date('Y-12-31');

        // $data['en_mark_search_on_receive'] = 1; //* Αφαιρέθηκε.
        $data['rcv_dt_from'] = $_SESSION['mydt00_p104'];

        $sql = 'mydt10.issuedate>=:dt_from and mydt10.issuedate<=:dt_to ';
        $sqlParams = array('dt_from' => $data['dt_from'], 'dt_to' => $data['dt_to']);
        if (pegasus_module_exists('stores')) {
            $stores = explode('#',trim($client_stores,'#'));
            if($stores[0]===''){
                $stores=array();
            }
            if(!empty($stores)){
                $stores= pegasus_mysql_create_in($stores);
                $sql .= " AND mydt10.p03 IN (".$stores['sql'].")";
                $sqlParams = array_merge($sqlParams,$stores['sqlParams']);
            }
        }

        $sql .= " AND LOCATE(mydt10.einv,:einv) > 0 ";
        $sqlParams = array_merge($sqlParams,array('einv' => $data['einv']));

        $sql .= " AND mydt10.tr_fail = :tr_fail ";
        $sqlParams = array_merge($sqlParams,array('tr_fail' => $data['tr_fail']));

        $table_query = "SELECT * FROM (
            SELECT mydt10.*,
        
                ifnull( (SELECT sum(if(mydt12_in.mydt57_p00='' || mydt12_in.mydt61_p00='', 1, 0))
                        FROM mydt12 AS mydt12_in
                        WHERE mydt12_in.mydt10=mydt10.nr01
                        GROUP BY mydt12_in.mydt10), 0) AS nomarked_esodo, 
                                            
                ifnull( (SELECT sum(if(mydt12_in.mydt57_p00='' || mydt12_in.mydt61_p00='', 0, 1))
                        FROM mydt12 AS mydt12_in
                        WHERE mydt12_in.mydt10=mydt10.nr01
                        GROUP BY mydt12_in.mydt10), 0) AS marked_esodo,
                                            
                        ifnull( (SELECT sum(if(mydt12_in.mydt58_p00='' || mydt12_in.mydt62_p00='', 1, 0))
                        FROM mydt12 AS mydt12_in
                        WHERE mydt12_in.mydt10=mydt10.nr01
                        GROUP BY mydt12_in.mydt10), 0) AS nomarked_exodo, 

                        ifnull( (SELECT sum(if(mydt12_in.mydt58_p00='' || mydt12_in.mydt62_p00='', 0, 1))
                        FROM mydt12 AS mydt12_in
                        WHERE mydt12_in.mydt10=mydt10.nr01
                        GROUP BY mydt12_in.mydt10), 0) AS marked_exodo									
            FROM mydt10
        ) as mydt10 WHERE ";

        pegasusSetGlobalVar(
            $container_id . '_grid_query',
            array(
                'sql' => $table_query.$sql,
                'sqlParams' => $sqlParams
            )
        );
        // pegasusSetGlobalVar(
        //     $container_id . '_where_grid',
        //     array(
        //         'sql' => $sql,
        //         'sqlParams' => $sqlParams
        //     )
        // );
        return  $data;
    }

    function mydt_mydt42_d_initialize($data,$mmnr01,$mnr01,$_d,$container_id){

        if(substr($mmnr01,0,9) == 'mydt50_d-'){
            $data['p01'] = pegasus_mysql_printfld('mydt50' , 'p00' , 'nr01=:mydt50_nr01' , array('mydt50_nr01' => $mnr01));
            $data['p01_readonly'] = 1;
        }

        return $data;
    }

    function mydt_mydt50_d_initialize($data,$mmnr01,$mnr01,$_d,$container_id){

        pegasus_make_all_tmp_recs('mydt50' , $data , $data['nr01'] , $_REQUEST['rec_copy_nr01'] , 'mydt50_d-'.$data['nr01'] );
        pegasusSetGlobalVar( 
            $container_id . '_where_grid01'  ,  
            array(
                'sql' => 'mydt65.p01=:mydt65_p01',	
                'sqlParams' => array('mydt65_p01' => $data['p00'])
            )
        );
        
        
        pegasusSetGlobalVar( 
            $container_id . '_where_grid02'  ,  
            array(
                'sql' => 'peg_tmp_mydt42.p01=:mydt42_p01',	
                'sqlParams' => array('mydt42_p01' => $data['p00'])
            )
        );

        return $data;
    }

        /**
     * Tables / _d Previews initialize
     * @param array $data
     * @param string $mmnr01
     * @param string $mnr01
     * @param string $_d
     * @param string $container_id
     * @return array
     */
    function mydt_mydt70_d_initialize($data,$mmnr01,$mnr01,$_d,$container_id){

        $p01_where = ' q30.p01 in (select p50.p01 from p50 join p55 on p55.p00 = p50.module and p55.en = 1) AND q30.p03 <> "#"';

        pegasusSetGlobalVar( $container_id . 'p01_where', $p01_where);

        mydt_mydt70_d_set_grid_query($container_id, $data);

        return $data;
    }

    function mydt_mydt70_d_set_grid_query($container_id, $data){

        $mydt70_d_params = array();
        $query = '';
        $sysxetish = '';
        
        if(($data['p01'])!=null && $data['p01']>0){
            $sysxetish = " && q30.nr01=:sys ";
            $mydt70_d_params['sys'] = $data['p01'];
        }
        
        $query = "
            select 
                concat('select ', 
                    '\"', q30.nr01 , '\" as p01, ' ,  
                     q30.p01 , '.' , q30.p101 , ' as p03,' ,
                    ' ifnull(q31.nr01,  0) as nr01,',
                     q30.p03 , '.' , q30.p201 , ' as p05,' ,    
                    q30.p02 , ' as vp03,' ,  
                    q30.p04 , ' as vp05' ,
                    
                    ' from ' , q30.p01 , 
                    ' left join q31 on q31.p01=\"', q30.nr01 , '\" && q31.p03=' , q30.p01 , '.' , q30.p101 , 
                    ' left join ' , q30.p03 , ' on q31.p05=' ,   q30.p03 , '.' , q30.p201  
                    
                    
                    ) as ttt,
                q30.* 
                from q30
                join p50 on q30.p01 = p50.p01
                join p55 on p55.p00 = p50.module and p55.en = 1 
                where 
                q30.module='mydt'
                ".$sysxetish."  
       ";
           
        $res = pegasus_query($query,$mydt70_d_params);
        
        $sql_query = '';
        
        while ($q30 = pegasus_fetch_assoc($res)) {
            
            if(!empty($sql_query)){
                $sql_query .= " UNION ALL ";
            }
                   
            $sql_query .= $q30['ttt'];
                         
        }
        //echo $sql_query;   
        pegasusSetGlobalVar( $container_id . '_query', $sql_query);
        //var_dump(pegasusGetGlobalVar( $container_id . '_query'));         
    }

    function peg_mydt_debugs_logs($p01, $request, $response){
        if($_SESSION['mydt00_comm_logs']==1){
            $arr1 = array(); $arr2 = array();
            array_push($arr1, 'nr01'); array_push($arr2, pegasus_mysql_newrec('mydt90'));
            array_push($arr1, 'dt');   array_push($arr2, date('Y-m-d'));
            array_push($arr1, 'tm');   array_push($arr2, date('H:i'));
            array_push($arr1, 'p01');  array_push($arr2, $p01);
            array_push($arr1, 'p30');  array_push($arr2, $request);
            array_push($arr1, 'p31');  array_push($arr2, $response);
            pegasus_mysql_insert('mydt90' , $arr1 , $arr2);
        }
    }

    function mydt_after_update(){
        pegasus_mysql_use('select rel, ver from p55 where p00="mydt"', $version);
        
        if ($version['ver'] == 1 && $version['rel'] <= 99) {
            if(file_exists('../mydt_app_health/mydt_app_health_mydt40.php'))
            unlink('../mydt_app_health/mydt_app_health_mydt40.php');
        }
        if ($version['ver'] == 1 && $version['rel'] <= 99) {
            if(file_exists('../mydt_app_health/mydt_app_health_mydt50.php'))
            unlink('../mydt_app_health/mydt_app_health_mydt50.php');
        }
        
        if ($version['ver'] == 1 && $version['rel'] <= 33) {
            unlink('../mydt01/mydt10_create.php');
        }

        if ($version['ver'] == 1 && $version['rel'] <= 37) {
            if(!empty($_SESSION['mydt00_user_id'])){
                pegasus_mysql_update("mydt00", array("p102"), array("1"),"nr01>0");
                pegasusWriteSession('mydt00');
                pegasusReadSession('mydt00');
            }

            if(empty(pegasus_mysql_printfld('mydt57','nr01', 'p00="category1_95"'))){
                pegasus_mysql_insert("mydt57", array("nr01" , "p00" , "p01"), array( pegasus_mysql_newrec('mydt57') , 'category1_95' , 'Λοιπά Πληροφοριακά Στοιχεία Εσόδων (+) / (-)'));
            }
        }

        if ($version['ver'] == 1 && $version['rel'] <= 40) { 
            pegasus_query('select * from mydt40 where  nr01 in (8 , 9, 10) and p05 = "E3_561_004" and p06= "16"');
        }

        if ($version['ver'] == 1 && $version['rel'] <= 41) {
            pegasus_mysql_delete("q31","p01='620042' && p03='3' && p05='2'");
        }

        if ($version['ver'] == 1 && $version['rel'] <= 50) {
            require_once('../mydt_libs/mydt_sync.php');
            $mydt = new mydt_sync();

            //Συντελεστές παρακράτησης φόρου
            $mydt->download_table('mydt53');

            //Συντελεστές λοιπών φόρων
            $mydt->download_table('mydt54');

            //Συντελεστές τελών
            $mydt->download_table('mydt56');
        }

        // Σειρά στο λεκτικό του παραστατικού
        if ($version['ver'] == 1 && $version['rel'] <= 51) {
            pegasus_mysql_update("mydt00", array("p103"), array("1"),"nr01>0");
            pegasusWriteSession('mydt00');
            pegasusReadSession('mydt00');
        }

        // Σειρά στο λεκτικό του παραστατικού
        if ($version['ver'] == 1 && $version['rel'] <= 55) {
            pegasus_mysql_update("mydt00", array("p104"), array("2021-01-01"),"nr01>0");
            pegasusWriteSession('mydt00');
            pegasusReadSession('mydt00');
        }

        // Διαγραφη τις συσχετισης για αποστολή φόρου 
        if ($version['ver'] == 1 && $version['rel'] <= 58) {
            pegasus_mysql_delete("mydt65", " nr01=1063 and p01='8.2' and p03='category1_7' and p04='E3_881_001' ");
        }
        
        //Ενημερωση q31 μονο για τις εγγραφες του transport αν υπαρχει το module
        if ($version['ver'] == 1 && $version['rel'] <= 62 && pegasus_module_exists('tran')) {
            pegasus_mysql_drop_table('z_q31_mydata');

            //upload.sql
            pegasus_mysql_upload_sql('../mydt_sql/restore_default_values/q31_mydata.sql');

            $sql="insert into q31
            (nr01, p01, p03, p05, 
            remfdate, remftime, remfuser, remdate, remtime, remuser)
            select peg_new_nr01('q31', 1) as nr01,
                tbl01.*
            from
            (       
                select z_q31_mydata.p01 as p01, 
                    z_q31_mydata.p03 as p03, 
                    z_q31_mydata.p05 as p05, 
                    curdate() as remfdate, 
                    curtime() as remftime, 
                    '@auto@smep90' as remfuser,
                    curdate() as remdate, 
                    curtime() as remtime, 
                    '@auto@restore_default_values' as remuser
                from z_q31_mydata
                left join q31 on q31.p01=z_q31_mydata.p01
                            && q31.p03=z_q31_mydata.p03
                            && q31.p05=z_q31_mydata.p05
                where q31.nr01 is null and z_q31_mydata.p01 in ('620031', '620032' ,'620030')
            ) as tbl01;
            ";
            pegasus_query($sql);

            //drop_table
            pegasus_mysql_drop_table('z_q31_mydata');
        }
        if ($version['ver'] == 1 && $version['rel'] <= 282) {
            require_once('../mydt_libs/mydt_sync.php');
            $mydt = new mydt_sync();

            //Ειδη παραστατικου
            $mydt->download_table('mydt50');
        }


        if ($version['ver'] == 1 && $version['rel'] <= 110) {
            require_once('../mydt_libs/mydt_sync.php');
            $mydt = new mydt_sync();

            //Kατηγορία Παρακρατούμενων Φόρων
            $mydt->download_table('mydt53');
        }

        if ($version['ver'] == 1 && $version['rel'] <= 132) {
            // Κατηγορίες Παραστατικών > Όχι Ποσότητα/ΜΜ
            pegasus_mysql_update("mydt50", array("p105"), array("1"), " p00 <> '1.1' and p00 <> '11.1'");
        }

        //Ενημερωση q31 μονο για τις εγγραφες των ΜΜ
        if ($version['ver'] == 1 && $version['rel'] <= 134) {
            // Update τις συσχετίσεις ΜΜ που ειχαν γινει για p01 = 620058 (για τις εγκαταστάσεις που είχαν πάρει το moderator update)
            pegasus_mysql_update('q31', array('p01'), array("620060"), 'p01 = 620058 AND p03 IN ( "ΤΕΜ", "ΖΕΥ", "ΚΙΛ", "ΚΜ", "ΚΥΤ", "ΜΕΤ", "ΜΗΚ", "ΡΟΛ", "ΣΕΤ", "ΤΜ", "ΦΙΑ", "ΦΥΛ")');

            // Προσθήκη των συσχετίσεων ΜΜ για q31.p01 = 620060
            pegasus_mysql_drop_table('z_q31_mydata');

            //upload.sql
            pegasus_mysql_upload_sql('../mydt_sql/restore_default_values/q31_mydata.sql');

            $sql="insert into q31
            (nr01, p01, p03, p05, 
            remfdate, remftime, remfuser, remdate, remtime, remuser)
            select peg_new_nr01('q31', 1) as nr01,
                tbl01.*
            from
            (       
                select z_q31_mydata.p01 as p01, 
                    z_q31_mydata.p03 as p03, 
                    z_q31_mydata.p05 as p05, 
                    curdate() as remfdate, 
                    curtime() as remftime, 
                    '@auto@smep90' as remfuser,
                    curdate() as remdate, 
                    curtime() as remtime, 
                    '@auto@restore_default_values' as remuser
                from z_q31_mydata
                left join q31 on q31.p01=z_q31_mydata.p01
                            && q31.p03=z_q31_mydata.p03
                            && q31.p05=z_q31_mydata.p05
                where q31.nr01 is null and z_q31_mydata.p01 in ('620060')
            ) as tbl01;
            ";
            pegasus_query($sql);

            //drop_table
            pegasus_mysql_drop_table('z_q31_mydata');
        }

        if ($version['ver'] == 1 && $version['rel'] <= 135) {
            // Κατηγορίες Παραστατικών > Όχι Ποσότητα/ΜΜ
            pegasus_mysql_update("mydt50", array("p106"), array("1"), " p00 in ('1.5', '2.1', '2.2', '2.3', '2.4', '7.1', '8.1', '8.2', '11.2')");
        }
        
        if($version['ver'] == 1 && $version['rel'] <= 180) {
            require('../mydt_libs/mydt_sync.php');
            $mydt = new mydt_sync();

            //Ειδη παραστατικου
            $ret_array = $mydt->download_table('mydt50');

            //Συντελεστές ΦΠΑ
            $ret_array = $mydt->download_table('mydt51');

            //Κωδικοί Εξαίρεσης από ΦΠΑ
            $ret_array = $mydt->download_table('mydt52');

            //Συντελεστές παρακράτησης φόρου
            $ret_array = $mydt->download_table('mydt53');

            //Συντελεστές λοιπών φόρων
            $ret_array = $mydt->download_table('mydt54');

            //Συντελεστές Χαρτοσήμου
            $ret_array = $mydt->download_table('mydt55');

            //Συντελεστές τελών
            $ret_array = $mydt->download_table('mydt56');

            //Χαρακτηρισμοί εσόδων
            $ret_array = $mydt->download_table('mydt57');

            //Χαρακτηρισμοί εξόδων
            $ret_array = $mydt->download_table('mydt58');

            //Μονάδες Μέτρησης
            $ret_array = $mydt->download_table('mydt59');

            //Επισημάνσεις
            $ret_array = $mydt->download_table('mydt60');

            //Επισημάνσεις
            $ret_array = $mydt->download_table('mydt60');

            //Επισημάνσεις
            $ret_array = $mydt->download_table('mydt60');

            //Χαρακτηρισμός E3 Εσόδου
            $ret_array = $mydt->download_table('mydt61');

            //Χαρακτηρισμός E3 Εξοδου
            $ret_array = $mydt->download_table('mydt62');

            //Σκοποί Διακίνησης
            $ret_array = $mydt->download_table('mydt63');

            //Σκοποί Διακίνησης
            $ret_array = $mydt->download_table('mydt64');
            
            //Συνδυασμοί Χαρακτηριστικών - Ε3
            $ret_array = $mydt->download_table('mydt65');

            //Ειδική Κατηγορία Παραστατικού
            $ret_array = $mydt->download_table('mydt66');

            //Τύπος Απόκλισης Παραστατικού
            $ret_array = $mydt->download_table('mydt67');

            //Κωδικοί Καυσίμων
            $ret_array = $mydt->download_table('mydt68');
        }

        if($version['ver'] == 1 && $version['rel'] <= 189) {
            //* Ανέβηκαν λανθασμένα από την Τοπική τα πεδία
            //* p015, p016 στον mydt11
            //* p016 στον mydt12
            //* Με την παρακάτω after_update ελέγχω αν τα πεδία δεν υπάρχουν στον p51 αλλά υπάρχουν στον πίνακα (mydt11, mydt12)
            //* Αν ναι, σβήνω τα πεδία

            //? Η λογική είναι ότι αν τα πεδία υπάρχουν στον πίνακα αλλά όχι στον p51, τότε δεν έχουν προστεθεί στο Web, αλλά
            //? ανέβηκαν από το PIM. Κάνοντας αυτόν τον διπλό έλεγχο, εξασφαλίζουμε πως αν μελλοντικά προστεθούν αυτά τα πεδία στο Web
            //? και κάποιος λάβει αυτή την αναβάθμιση, δεν θα του σβήσει τα πεδία.
            $p015_where = 'p02 = :p02 AND module = :module AND desc05 = :desc05';
            $p015_whereVals = array('p02' => 'mydt11_d', 'module' => 'mydt', 'desc05' => 'p015');
            $p016_where = 'p02 = :p02 AND module = :module AND desc05 = :desc05';
            $p016_whereVals = array('p02' => 'mydt11_d', 'module' => 'mydt', 'desc05' => 'p016');
            $p016_mydt12_whereVals = array('p02' => 'mydt12_d', 'module' => 'mydt', 'desc05' => 'p016');

            $p015_exists = false;
            $p016_exists = false;
            $p016_mydt12_exists = false;
            if(pegasus_mysql_printfld('p51', 'nr01', $p015_where, $p015_whereVals) > 0) {
                $p015_exists = true;
            }
            if(pegasus_mysql_printfld('p51', 'nr01', $p016_where, $p016_whereVals) > 0) {
                $p016_exists = true;
            }
            if(pegasus_mysql_printfld('p51', 'nr01', $p016_where, $p016_mydt12_whereVals) > 0) {
                $p016_mydt12_exists = true;
            }

            if(pegasus_mysql_table_field_exists('mydt11', 'p015', 0, false) && !$p015_exists) {
                pegasus_query("ALTER TABLE mydt11 DROP p015");
            }

            if(pegasus_mysql_table_field_exists('mydt11', 'p016', 0, false) && !$p016_exists) {
                pegasus_query("ALTER TABLE mydt11 DROP p016");
            }

            if(pegasus_mysql_table_field_exists('mydt12', 'p016', 0, false) && !$p016_mydt12_exists) {
                pegasus_query("ALTER TABLE mydt12 DROP p016");
            }
        }

        if ($version['ver'] == 1 && $version['rel'] <= 203) {
            pegasus_mysql_use("select count(*) as cnt from mydt10" , $mydt10);
            if($mydt10['cnt']==0){
                pegasus_mysql_update("mydt00", array("p103"), array(1),"nr01>0");
            }
        }

        if($version['ver'] == 1 && $version['rel'] <= 219) {
            require('../mydt_libs/mydt_sync.php');
            $mydt = new mydt_sync();

            //Ειδη παραστατικου
            $mydt->download_table('mydt50');

            //Διαγράφουμε ολες τις συνδεσεις στο q31 αν ειναι κενο to mydt10
            if(pegasus_mysql_printfld('mydt10' , 'count(*)' , 'nr01>0') == 0){
                pegasus_mysql_backup_table('q31');
                pegasus_query("delete q31 from q31 join q30 on q31.p01=q30.nr01 and q30.module='mydt';");
                mydt_update_q31();
            }

            
        }
        if ($version['ver'] == 1 && $version['rel'] <= 255) {
            require_once('../mydt_libs/mydt_sync.php');
            $mydt = new mydt_sync();

            //Ειδη παραστατικου
            $mydt->download_table('mydt50');
        }

        if ($version['ver'] == 1 && $version['rel'] <= 270) {
           if(file_exists('../mydt01/mydt_mydt10_d56_set_grid_where_global_var.php')) {
            unlink('../mydt01/mydt_mydt10_d56_set_grid_where_global_var.php');
           }
        }

        if ($version['ver'] == 1 && $version['rel'] <= 289) {
           $queryP97 = 'select * from p97 where nr01!=140000000000000';
           $resP97 = pegasus_query($queryP97);
           while ($row = pegasus_fetch($resP97)) {
               $arr1 = array();			$arr2 = array();
               array_push($arr1, 'nr01');			array_push($arr2, pegasus_mysql_newrec('p97p96'));
               array_push($arr1, 'en');			    array_push($arr2, 1);
               array_push($arr1, 'p96');			array_push($arr2, 'mydt.send_income_classif');
               array_push($arr1, 'p97');			array_push($arr2, $row['nr01']);
               pegasus_mysql_insert('p97p96', $arr1, $arr2);

               $arr1 = array();			$arr2 = array();
               array_push($arr1, 'nr01');			array_push($arr2, pegasus_mysql_newrec('p97p96'));
               array_push($arr1, 'en');			    array_push($arr2, 1);
               array_push($arr1, 'p96');			array_push($arr2, 'mydt.send_expences_classif');
               array_push($arr1, 'p97');			array_push($arr2, $row['nr01']);
               pegasus_mysql_insert('p97p96', $arr1, $arr2);
           }
        }
        if ($version['ver'] == 1 && $version['rel'] <= 293) {
            $nr01  = pegasus_mysql_printfld("p97p96", "nr01", " p96 = :p96 and p97 = 140000000000000", array( "p96" => "mydt.send_income_classif"));
            if($nr01 > 0 ){
                pegasus_mysql_update("p97p96", array("en"), array("1"), "nr01 = ? ", 0, 1, 1, array($nr01));
            }
            $nr01  = pegasus_mysql_printfld("p97p96", "nr01", " p96 = :p96 and p97 = 140000000000000", array( "p96" => "mydt.send_expences_classif"));
            if($nr01 > 0 ){
                pegasus_mysql_update("p97p96", array("en"), array("1"), "nr01 = ? ", 0, 1, 1, array($nr01));
            }
        }

        if ($version['ver'] == 1 && $version['rel'] <= 296) {
            require_once('../mydt_libs/mydt_sync.php');
            $mydt = new mydt_sync();

            //Ειδη παραστατικου
            $mydt->download_table('mydt50');
        }

        if ($version['ver'] == 1 && $version['rel'] <= 300) {
            if(file_exists('../mydt_sql/mydt10p200202_100.sql')){
                unlink('../mydt_sql/mydt10p200202_100.sql');
            }
        }

        if ($version['ver'] == 1 && $version['rel'] <= 319) {
            require_once('../mydt_libs/mydt_sync.php');
            $mydt = new mydt_sync();

            //Ειδη παραστατικου
            $mydt->download_table('mydt50');
        }

        if ($version['ver'] == 1 && $version['rel'] <= 354) {
            require_once('../mydt_libs/mydt_sync.php');
            $mydt = new mydt_sync();

            //Ειδη παραστατικου
            $mydt->download_table('mydt50');
        }

        if ($version['ver'] == 1 && $version['rel'] <= 359) {
            // * Αλλαγή του Ε3 Εξόδου του default i10 για Παροχή Υπηρεσιών σε Ε3_585_009. Ο προηγούμενος που είχαμε δεν ήταν επιτρεπτός. Έχει γίνει σχετική αλλαγή και σε q31_mydata.sql
            $arr1 = array(); $arr2 = array();
            array_push($arr1, 'p05'); array_push($arr2, 'E3_585_009');
            pegasus_mysql_update('q31', $arr1, $arr2, 'p01 = 620023 and p03 = 1000000005 and p05 = "E3_202_001"');
        }

        if ($version['ver'] == 1 && $version['rel'] <= 374) {
            require_once('../mydt_libs/mydt_sync.php');
            $mydt = new mydt_sync();

            // Σκοποί διακίνησης
            $mydt->download_table('mydt63');
        }

        if ($version['ver'] == 1 && $version['rel'] <= 389) {
            require_once('../mydt_libs/mydt_sync.php');
            $mydt = new mydt_sync();

            // Κατηγορίες Εξαίρεσης ΦΠΑ
            $mydt->download_table('mydt52');
        }
    }

    function mydt_update_q31(){
        //drop_table
        pegasus_mysql_drop_table('z_q31_mydata');

        //upload.sql
        pegasus_mysql_upload_sql('../mydt_sql/restore_default_values/q31_mydata.sql');

        $sql = peg_read_file('../mydt_sql/restore_default_values/smep9003.sql');
        pegasus_query($sql);

        //drop_table
        pegasus_mysql_drop_table('z_q31_mydata');

        // Room Tax Invoice - update q31
        if(pegasus_mysql_table_exists('hota98')){
            pegasus_query( 
                "   insert into q31 (nr01, p01, p03, p05)
                    select 
                        peg_new_nr01('q31', 0) as nr01, 
                        '620014' as p01, 
                        hota98.p06 as p03, 
                        '8.2' as p05 
                    from 
                        hota98  
                    left join q31 on q31.p01=620014 and
                        q31.p03=hota98.p06 and
                        q31.p05=8.2
                        
                    where 	
                        hota98.nr01=1 and q31.nr01 is null;");
        }
    }
    function peg_mydt_mydt10_ondelete($data , $permDeny=array() , $mmnr01="" , $check_perm_only=0){
        if($check_perm_only && (!pegasus_check_permission('einv_del') && $data['einv'] != 0)){
            array_push($permDeny, array('type' => 'DENY', 'message' => $_SESSION['peg_dic_mydt_mydt10_delete_deny']));
        }
        return $permDeny;
    }
    function peg_mydt_mydt10_d_onsave($data , $permDeny=array() , $mmnr01 = '' , $checkOnlyPerm = false){

        if(!$checkOnlyPerm){
            if ($data['rel_nr'] > 0) {
                //pegasus_mysql_use("select * from mydt10 where nr01=:nr01;" , $mydt10 , array('nr01'=>$data['rel_nr']));
                $arr1 = array(); $arr2 = array();
                array_push($arr1, 'uid');     array_push($arr2, $data['uid']);
                array_push($arr1, 'mark');    array_push($arr2, $data['mark']);
                array_push($arr1, 'fuelinv'); array_push($arr2, $data['fuelinv']);
                pegasus_mysql_update('mydt10',  $arr1, $arr2, "nr01=:nr01", 0, 1, 1, array('nr01' => $data['rel_nr']));
            }else{
                $rel_nr =  pegasus_mysql_printfld('mydt10' , 'rel_nr' , 'nr01=:nr01', array('nr01' => $data['nr01']));
                if ($rel_nr > 0) {
                    $arr1 = array(); $arr2 = array();
                    array_push($arr1, 'uid');     array_push($arr2, '');
                    array_push($arr1, 'mark');    array_push($arr2, '');
                    array_push($arr1, 'fuelinv'); array_push($arr2, '0');
                    pegasus_mysql_update('mydt10',  $arr1, $arr2, "nr01=:nr01", 0, 1, 1, array('nr01' => $rel_nr ));

                    // $data['rel_nr] κενό ΚΑΙ $rel_nr > 0 = Έχω ακυρώσει συσχέτιση
                    // Διαγράφω τις αναλυτικές γραμμές του παραστατικού χωρίς tbl / tbl_nr01
                    pegasus_mysql_delete('mydt11', 'mydt10 = :mydt10_rel_nr AND tbl = "" AND tbl_nr01 = 0', 1, array('mydt10_rel_nr' => $rel_nr));
                    // Ενημερώνω τα linerel των αναλυτικών γραμμών του παραστατικού τα οποία έχουν tbl / tbl_nr01 με 0 (τα έχω κάνει delete από πάνω αυτά που δεν έχουν).
                    pegasus_mysql_update('mydt11', array('linerel'), array(0), 'mydt10 = :mydt10_rel_nr', 0, 1, 1, array('mydt10_rel_nr' => $rel_nr));
                    require_once('../mydt_libs/mydt_mydt10.php');
                    // Σβήνω όλα τα mydt12 του παραστατικού.
                    pegasus_mysql_delete('mydt12', 'mydt10 = :mydt10_rel_nr', 1, array('mydt10_rel_nr' => $rel_nr));

                    pegasus_mysql_use('SELECT tbl, tbl_nr01 FROM mydt10 WHERE nr01 = :nr01', $related_mydt10, array('nr01' => $rel_nr));
                    // Δημιουργεί τις mydt12 εγγραφές αν έχει παραμείνει κάτι στον mydt11.
                    mydt_mydt10::create_mydt12_records($related_mydt10['tbl'], $related_mydt10['tbl_nr01']);
                }

            }
        }

        return array($data, $permDeny);
    }

    function mydt_send_to_aade($mydt10_nr01 , $only_if_auto=false){
        $mydt10_nr01_arr = explode(';' , $mydt10_nr01);
        
        require_once('../mydt_libs/mydt_stats.php');
        $stats_data = mydt_stats::getRecordsTotals($mydt10_nr01_arr);

        if(
            $stats_data['not_sent_recs'] == 0 &&
            $stats_data['not_sent_delete_recs'] == 0 &&
            $stats_data['classified_recs_esoda'] == 0 &&
            $stats_data['classified_recs_exoda'] == 0 ){

            $ret_arr=array();
            $ret_arr['ok']=0;
            if($stats_data['total_recs']=='1'){
                if($stats_data['total_recs'] == $stats_data['einv_recs']){
                    $ret_arr['msg']= $_SESSION['peg_dic_mydt_mydt10_mydata_is_already_updated_einv_one'];
                }else{
                    $ret_arr['msg']= $_SESSION['peg_dic_mydt_mydt10_mydata_is_already_updated_one'];
                }
            }else{
                if($stats_data['total_recs'] == $stats_data['einv_recs']){
                    $ret_arr['msg']= $_SESSION['peg_dic_mydt_mydt10_mydata_is_already_updated_einv_many'];
                }else{
                    $ret_arr['msg']= $_SESSION['peg_dic_mydt_mydt10_mydata_is_already_updated_many'];
                }
            }
            return $ret_arr;
        }

        $ret_arr00 = array();
        $ret_arr01 = array();
        $ret_arr02 = array();
        $ret_arr03 = array();

        $ret_arr00_tmp = array();
        $ret_arr02_tmp = array();
        $ret_arr03_tmp = array();

        $mydt_xml = new mydt_xml();
            
        $mydt01 = $mydt_xml->find_mydt01_array($mydt10_nr01_arr);
        if(count($mydt01)==0){
            $mydt01 = array(array('nr01'=>'-2'));
        }

        $ret_arr00['ok']   = 1;


        // Βρισκει τις ξεχωριστες εγγραφες ανα ομαδα καταστηματος
        foreach($mydt01 as $mydt01_data){

            $correlated = 0;
            while( $correlated<=1){
                try{               
                    //π.χ ο φόρος θα πρέπει να φύγει μετά το related παραστατικό της κράτησης 
                    $xml_string_arr = $mydt_xml->invoicesDoc_create_xml($mydt10_nr01_arr, $mydt01_data['nr01'] , $correlated);
                    $mydt_sync = new mydt_sync();

                    if(is_countable($xml_string_arr['nr01_array']) && count($xml_string_arr['nr01_array'])>0){
                        $ret_arr00_tmp[$mydt01_data['nr01']][$correlated] = $mydt_sync->invoiceDoc_send($xml_string_arr['xml'] , $xml_string_arr['nr01_array'], $mydt01_data['nr01']);
                    }
                } catch (Exception $e) {
                    $ret_arr00_tmp[$mydt01_data['nr01']][$correlated]['ok']   = 0;
                    $ret_arr00_tmp[$mydt01_data['nr01']][$correlated]['msg']  = $e->getMessage();    
                }
                    
                $correlated++;
            }


            if($stats_data['total_recs']=='1'){ //Εφόσον έστειλε 1 
                
                // echo '<pre>' .print_r($ret_arr00_tmp, 1). '</pre>';
                if( $ret_arr00_tmp[$mydt01_data['nr01']][0]['ok'] != 1 and $ret_arr00_tmp[$mydt01_data['nr01']][1]['ok'] != 1){
                    $ret_arr00['ok'] = 0;
                }
    
                if(!empty($ret_arr00_tmp[$mydt01_data['nr01']][0]['msg']) || !empty($ret_arr00_tmp[$mydt01_data['nr01']][1]['msg'])){
                    $ret_arr00['msg'] .= $ret_arr00_tmp[$mydt01_data['nr01']][0]['msg'] . $ret_arr00_tmp[$mydt01_data['nr01']][1]['msg'] ; 
                }

            }else{ //Αν έστειλε πολλά
                if( $ret_arr00_tmp[$mydt01_data['nr01']][0]['ok'] == 0 and $ret_arr00_tmp[$mydt01_data['nr01']][1]['ok'] == 0){
                    $ret_arr00['ok'] = 0;
                }
    
                if(!empty($ret_arr00_tmp[$mydt01_data['nr01']][0]['msg'])){
                    if(!empty($mydt01_data['t05_p02'])){
                        $ret_arr00['msg'] .= $mydt01_data['t05_p02'] . '<br>' . $ret_arr00_tmp[$mydt01_data['nr01']][0]['msg'] . ' (' .$_SESSION['peg_dic_mydt_not_correlated'].') ' ; 
                    }else{
                        $ret_arr00['msg'] .= $ret_arr00_tmp[$mydt01_data['nr01']][0]['msg'] . ' (' .$_SESSION['peg_dic_mydt_not_correlated'].') ' ;                         
                    }
                }
            
                if(!empty($ret_arr00_tmp[$mydt01_data['nr01']][1]['msg'])){
                    $ret_arr00['msg'] .= $ret_arr00_tmp[$mydt01_data['nr01']][1]['msg']. ' (' .$_SESSION['peg_dic_mydt_correlated'].') '; 
                }    
            }
        }
            

        // invoiceDoc_cancel Βρίσκει αυτα που εχουν διαγραφει και τα στελνει
        try{
            $mydt_sync = new mydt_sync();
            $ret_arr01 = $mydt_sync->invoiceDoc_cancel($mydt10_nr01_arr);
 
        } catch (Exception $e) {
            $ret_arr01['ok']   = 0;
            $ret_arr01['msg']  = $e->getMessage();    
        }


        // Αποστολή Χαρακτηρισμών Παραστατικών Εσοδων
        foreach($mydt01 as $mydt01_data){
            //echo print_r($mydt01_data ,true);
            try{

                $mydt_classification = new mydt_classification($mydt10_nr01_arr , $mydt01_data['nr01']);
                $invoicesData = $mydt_classification->find_incomes_for_classification();
                // echo print_r($invoicesData ,true);
                if(!empty($invoicesData)){
                    if(pegasus_check_permission('mydt.send_income_classif')){
                        foreach ($invoicesData as $nr01 => $data_array) {
                            
                            $mydt_xml = new mydt_xml();
                            $ret_arr = $mydt_xml->incomeClassificationsDoc_create_xml($data_array);
                            $xmlString = $ret_arr['xml'];
    
                            // echo  $xmlString;
                            // die();
    
                            $mydt_sync = new mydt_sync();
                            $ret_00 =$mydt_sync->classification_send($xmlString, 1 , $nr01 , $mydt01_data['nr01']);
                            
                            $ret_arr02_tmp['ok']   = 1;
                            if(!empty($ret_arr02_tmp['msg'])) { $ret_arr02_tmp['msg'] .= '<br>'; }
                            $ret_arr02_tmp['msg'] .= $ret_00['msg'];
                        }
                    }else{
                        $ret_arr02_tmp['ok']   = 0;
                        $ret_arr02_tmp['msg']  = $_SESSION['peg_dic_mydt_no_perm_send_income_classif'];
                    }
                }
            } catch (Exception $e) {
                $ret_arr02_tmp['ok']   = 0;
                $ret_arr02_tmp['msg']  = $e->getMessage();    
            }
            if( $ret_arr02_tmp['ok'] == 0){
                $ret_arr02['ok'] = 0;
            }
            $ret_arr02['msg'] .= $ret_arr02_tmp['msg'];   
        }


        // Αποστολή Χαρακτηρισμών Παραστατικών Εξοδων
        foreach($mydt01 as $mydt01_data){
            try{

                $mydt_classification = new mydt_classification($mydt10_nr01_arr , $mydt01_data['nr01']);
                $invoicesData = $mydt_classification->find_expences_for_classification();
                if(!empty($invoicesData)){
                    if(pegasus_check_permission('mydt.send_expences_classif')){
                        foreach ($invoicesData as $nr01 => $data_array) {
                        
                            $postPerInvoice = 0;
                            
                            while($postPerInvoice < 2){
                        
                                if(isset( $data_array[$postPerInvoice] )){
                                    $data_array00 = $data_array[$postPerInvoice];    
                                    $mydt_xml = new mydt_xml();
                                    $ret_arr = $mydt_xml->expensesClassificationsDoc_create_xml($data_array00 , $postPerInvoice);
                                    $xmlString = $ret_arr['xml'];
        
                                    $mydt_sync = new mydt_sync();
                                    $ret_00 = $mydt_sync->classification_send($xmlString , 2 , $nr01 , $mydt01_data['nr01'] , $postPerInvoice);
                                    
                                    $ret_arr03_tmp['ok']   = 1;
                                    if(!empty($ret_arr03_tmp['msg'])) { $ret_arr03_tmp['msg'] .= '<br>'; }
                                    $ret_arr03_tmp['msg'] .= $ret_00['msg'];
        
                                    if($ret_00['ok'] == 0) {
                                        $ret_arr03_tmp['ok']   = 0;
                                    }
                                }
        
                                $postPerInvoice++;
                            }
                        }
                    }else{
                        $ret_arr03_tmp['ok']   = 0;
                        $ret_arr03_tmp['msg']  = $_SESSION['peg_dic_mydt_no_perm_send_expences_classif'];
                    }
                }
            } catch (Exception $e) {
                $ret_arr03_tmp['ok']   = 0;
                $ret_arr03_tmp['msg']  = $e->getMessage();    
            }
            $ret_arr03['ok'] = 1;
            if( $ret_arr03_tmp['ok'] == 0){
                $ret_arr03['ok'] = 0;
            }
            $ret_arr03['msg'] .= $ret_arr03_tmp['msg'];   
        }

        
        $ret_arr['ok']   = 0;   
        if($ret_arr00['ok']==1 or $ret_arr01['ok']==1 or $ret_arr02['ok']==1 or $ret_arr03['ok']==1){
            $ret_arr['ok']   = 1;  
        }
    
        //Create Invoice
        if( !empty($ret_arr00['msg']) ){
            $ret_arr['msg']  .= (empty($ret_arr01['msg']) && empty($ret_arr02['msg']) && empty($ret_arr03['msg']) )  ? '' : '<br><b>' .$_SESSION['peg_dic_mydt_mydt10_send_invoices']. ':</b><br>';
            $ret_arr['msg']  .= $ret_arr00['msg'] ;
        }

        //invoice Cancel
        if( !empty($ret_arr01['msg']) ){
            $ret_arr['msg']  .=(empty($ret_arr00['msg']) && empty($ret_arr02['msg']) && empty($ret_arr03['msg']) )  ? '' :  '<br><b>' . $_SESSION['peg_dic_mydt_mydt10_send_deleted_invoices']. ':</b><br>';
            $ret_arr['msg']  .= $ret_arr01['msg'];
        }

        //Αποστολή Χαρακτηρισμών Παραστατικών Εσοδων
        if( !empty($ret_arr02['msg']) ){
            $ret_arr['msg']  .= (empty($ret_arr00['msg']) && empty($ret_arr01['msg']) && empty($ret_arr03['msg']) )  ? '' : '<br><b>' . $_SESSION['peg_dic_mydt_mydt10_send_incomes_classifications']. ':</b><br>';
            $ret_arr['msg']  .= $ret_arr02['msg']; 
        }

        //Αποστολή Χαρακτηρισμών Παραστατικών Εξοδων
        if( !empty($ret_arr03['msg']) ){
            $ret_arr['msg']  .= (empty($ret_arr00['msg']) && empty($ret_arr01['msg']) && empty($ret_arr02['msg']) )  ? '' : '<br><b>' . $_SESSION['peg_dic_mydt_mydt10_send_expenses_classifications']. ':</b><br>';
            $ret_arr['msg']  .= $ret_arr03['msg'];
        }

        // echo '<pre>';
        // echo '0';
        // echo print_r($ret_arr00 , true);
        // echo '1';
        // echo print_r($ret_arr01 , true);
        // echo '2';
        // echo print_r($ret_arr02 , true);
        // echo '3';
        // echo print_r($ret_arr03 , true);
        // echo '</pre>';

        return $ret_arr;
                        
    }

    function mydt_invoice_exist_message($message , $tbl , $tbl_nr01){
    
        pegasus_mysql_use("select * from mydt10 where tbl=:tbl and tbl_nr01=:tbl_nr01 ;", $mydt10 ,  array('tbl' => $tbl, 'tbl_nr01' => $tbl_nr01) );
        
        if( $tbl == 'a55' ){
            if( !empty($mydt10['mark'])  and $mydt10['p05']==0 ){
                $message00 =  (!empty($message)) ? '<br>' . $message : '';
                $message = $_SESSION["peg_dic_mydt_mydt10_mydata_is_already_exists"] . $message00;
            }    
        }


 

        return $message;
    }

    function mydt_create_n_send($tbl, $tbl_nr01, $only_if_auto, $tr_fail_flag=0)
    {
        require_once('../mydt_libs/mydt_mydt10.php');
        require_once('../mydt_libs/mydt_sync.php');
        require_once('../mydt_libs/mydt_mydt10_xml.php');
        require_once('../mydt_libs/mydt_classifications.php');

        $ret_arr = array();
        $ret_arr[0]['ok']  = 0;
        // $ret_arr[0]['die'] = 0; // 06-11-2023 - Removed, logic replaced with "has_msg_from_mydt_send_to_aade"
        $ret_arr[0]['msg'] = '';

        if (pegasus_mysql_printfld($tbl, 'count(*)', 'nr01=:nr01', array('nr01' => $tbl_nr01)) == 0) {
            $ret_arr[0]['ok']   = 0;
            $ret_arr[0]['msg']  =  $_SESSION['peg_dic_mydt_record_doesnt_exists'];
        
            return $ret_arr;
        }

        // 13/06/2025 - Αν είναι Παραστατικό Πελάτη ή Απόδειξη Πελάτη και είναι χειρόγραφή, δεν φτιάχνουμε mydt10
        if(mydt_check_if_xeir_and_customer_invoice($tbl, $tbl_nr01) == 1) {
            $ret_arr[0]['ok']   = 0;
            $ret_arr[0]['msg']  = $_SESSION['peg_dic_mydt_mydt10_xeir_n_cust_deny'];
            return $ret_arr;
        }
        
        if(pegasus_mysql_printfld('mydt10', 'einv', 'tbl=:tbl and tbl_nr01=:tbl_nr01', array('tbl'=>$tbl,'tbl_nr01'=>$tbl_nr01))>0) {
            $ret_arr[0]['ok']   = 0;
            $ret_arr[0]['msg']  =  $_SESSION['peg_dic_mydt_mydt10_has_einv'];
        
            return $ret_arr;
        }
        
        if(pegasus_module_exists('invtrans00') && $tbl == 'a60' && $only_if_auto == false) {
            pegasus_mysql_use('SELECT p03, p04, p05 FROM a60 WHERE nr01 = :tbl_nr01', $a60, array('tbl_nr01' => $tbl_nr01));
            if(pegasus_module_exists('stores')) {
                if(!empty($a60['p03'])) {
                    $p03_t07p01 = pegasus_mysql_printfld('i16', 't07p01', 'p00 = :p03', array("p03" => $a60['p03']));
                }
            
                if(!empty($a60['p04'])) {
                    $p04_t07p01 = pegasus_mysql_printfld('i16', 't07p01', 'p00 = :p04', array("p04" => $a60['p04']));
                }
                if (
                    (isset($p03_t07p01) && $p03_t07p01 != $a60['p0121'] && $p03_t07p01 != -1 && $a60['p0121'] != -1) &&
                    (isset($p04_t07p01) && $p04_t07p01 != $a60['p0121'] && $p04_t07p01 != -1 && $a60['p0121'] != -1)
                ) {
                    $ret_arr[0]['ok']  = 0;
                    $ret_arr[0]['msg'] = $_SESSION['peg_dic_invtrans00_warehouse_store_mismatch'];
                    return $ret_arr; 
                }
            }
        }

        // Τα παραστατικά διακίνησης δεν μπορούν να ξανασταλούν στο myDATA
        if($tbl == 'a55' || $tbl == 'a60') {
            pegasus_mysql_use('SELECT mark, invtype, isdlvno FROM mydt10 WHERE tbl = :tbl AND tbl_nr01 = :tbl_nr01', $mydt10_00, array('tbl' => $tbl, 'tbl_nr01' => $tbl_nr01));
            if(!empty($mydt10_00['mark']) && ($mydt10_00['invtype'] == '9.3' || $mydt10_00['isdlvno'] == 1)) {
                $ret_arr[0]['ok']  = 0;
                $ret_arr[0]['has_pegasus_error'] = 1;
                $ret_arr[0]['msg'] = $_SESSION['peg_dic_mydt_mydt10_isdlvno_w_mark'];
                return $ret_arr;
            }
        }


        try {


            $tbl_nr01_tosend = mydt_mydt10::get_eidiko_akirotiko_nr01($tbl, $tbl_nr01);
            if ($tbl_nr01_tosend > 0) {
                $tbl_nr01 = $tbl_nr01_tosend;
            }
            $mydt_mydt10 = new mydt_mydt10($tbl, $tbl_nr01);

            if(
                (mydt_mydt10::check_is_akyromeno($tbl, $tbl_nr01) == false) 
            ) {
                // Αν το πρωτογενές δεν έχει ειδικό ακυρωτικό, ούτε ΜΑΡΚ Διαγραφής 
                //    και έχει τσεκαρισμένο το "Διαγράφηκε", αφαιρούμε το check.
                // Προστέθηκε για την περίπτωση που κάποιος σημειώσει παραστατικό για διαγραφή από το myDATA: Dashboard και δεν κάνει Αποστολή στην ΑΑΔΕ.
                //    ώστε να μην το στείλει για ακύρωση από την καταχώρηση/ενημέρωση του πρωτογενούς.
                if(
                    pegasus_mysql_printfld("mydt10", 'p05', 'tbl=:tbl and tbl_nr01=:tbl_nr01', array('tbl' => $tbl, 'tbl_nr01' => $tbl_nr01)) == 1
                    AND
                    pegasus_mysql_printfld("mydt10", 'dmark', 'tbl=:tbl and tbl_nr01=:tbl_nr01', array('tbl' => $tbl, 'tbl_nr01' => $tbl_nr01)) == ''
                ) {
                    pegasus_mysql_update('mydt10', array('p05'), array(0), 'tbl=:tbl and tbl_nr01=:tbl_nr01', 0, 1, 1, array('tbl' => $tbl, 'tbl_nr01' => $tbl_nr01));
                }
            }
            
            // Αν έχει εκδοθεί Ειδικό Ακυρωτικό και υπάρχει ήδη εγγραφή mydata παραστατικού για το παραστατικό που ακυρώθηκε
            // που δεν έχει ενημερώσει την ΑΑΔΕ (κένο mark και κενό dmark)
            //      Τη διαγράφουμε.
            if(
                mydt_mydt10::check_is_akyromeno($tbl, $tbl_nr01) and   
                pegasus_mysql_printfld("mydt10" , 'count(*)' , " tbl=:tbl and tbl_nr01=:tbl_nr01 and mark='' and dmark=''" , array('tbl' => $tbl, 'tbl_nr01' => $tbl_nr01))>0
            ){
                $mydt10_nr01_to_del = pegasus_mysql_printfld('mydt10', 'nr01', 'tbl=:tbl and tbl_nr01=:tbl_nr01', array('tbl' => $tbl, 'tbl_nr01' => $tbl_nr01));
                pegasus_mysql_delete('mydt10', 'nr01=:mydt10_nr01',   0, array('mydt10_nr01' => $mydt10_nr01_to_del));
                pegasus_mysql_delete('mydt11', 'mydt10=:mydt10_nr01', 0, array('mydt10_nr01' => $mydt10_nr01_to_del));
                pegasus_mysql_delete('mydt12', 'mydt10=:mydt10_nr01', 0, array('mydt10_nr01' => $mydt10_nr01_to_del));
                // E: 10000857
                pegasus_mysql_delete('mydt13', 'mydt10=:mydt10_nr01', 0, array('mydt10_nr01' => $mydt10_nr01_to_del));
                // E: 10001024
                pegasus_mysql_delete('mydt14', 'mydt10=:mydt10_nr01', 0, array('mydt10_nr01' => $mydt10_nr01_to_del));
            }
            
            if(
                mydt_mydt10::check_is_akyromeno($tbl, $tbl_nr01) and   
                pegasus_mysql_printfld("mydt10" , 'count(*)' , " tbl=:tbl and tbl_nr01=:tbl_nr01" , array('tbl' => $tbl, 'tbl_nr01' => $tbl_nr01))<1
            ){              
                if($tbl_nr01_tosend>0){
                    $ret_arr[0]['ok']   = 0;
                    $ret_arr[0]['msg']  = $_SESSION['peg_dic_mydt_canceled_invoice_has_not_been_updated'];
                    return $ret_arr;

                }else{    
                    $ret_arr[0]['ok']   = 0;
                    $ret_arr[0]['msg']  = $_SESSION['peg_dic_mydt_is_canceled_nothing_to_send'];
                    return $ret_arr;
                }
            }

            if(
                mydt_mydt10::check_is_akyromeno($tbl, $tbl_nr01) and   
                pegasus_mysql_printfld("mydt10" , 'count(*)' , " tbl=:tbl and tbl_nr01=:tbl_nr01 and dmark!='' and p02_1=0" , array('tbl' => $tbl, 'tbl_nr01' => $tbl_nr01))>0
            ){
                $ret_arr[0]['ok']   = 0;
                $ret_arr[0]['msg']  = $_SESSION['peg_dic_mydt_the_cancellation_has_beeb_sent_to_mydt'];
                return $ret_arr;               
            }

            
            // O ελεγχος $mydt_mydt10->check_before_update() θα δει αν υπαρχουν record για αποστολη ελεγχει μονο τις εγραφες που δεν ειανι ακυρωτικά και δεν ειναι ακυρωμενες κια εχουν συνδεσεις με το q31
            // Αρα δεν αθ προχωρησει στην περιπτωση που εκδίδω ενα ακυρωτικό που θελω να μου διαγραψει τη μαμά εγγραφη σε αυτην την περιπτωση δεν αθ προχωραω στον ελεγχο
            if (
                !$mydt_mydt10->check_before_update() &&
                empty($tbl_nr01_tosend)  
            ) {
                $ret_arr[0]['ok']   = 0;
                $ret_arr[0]['msg']  = $_SESSION['peg_dic_mydt_no_definitions_for_this_record'];
                return $ret_arr;
            }

            // Αν είναι τσεκαρισμένο το πεδίο "Δεν Ενημερώνετα Αυτόματα"
            if(!empty(pegasus_mysql_printfld("mydt10", "p010", "tbl=:tbl and tbl_nr01=:tbl_nr01", array('tbl' => $tbl, 'tbl_nr01' => $tbl_nr01)))) {
                $ret_arr[0]['ok']   = 0;
                $ret_arr[0]['msg']  = $_SESSION['peg_dic_mydt_mydt10_no_auto_update'];
                return $ret_arr;
            }
            
            // Αν είναι αντιστοιχισμένο.
            pegasus_mysql_use(" SELECT count(*) as cnt
                                FROM mydt10 as t1
                                JOIN mydt10 as t2 ON t1.nr01 = t2.rel_nr
                                WHERE 
                                    t1.tbl = :tbl
                                    AND t1.tbl_nr01 = :tbl_nr01",
                                $mydt10_rel,
                                array('tbl' => $tbl, 'tbl_nr01' => $tbl_nr01)
                            );
            if($mydt10_rel['cnt'] > 0) {
                $ret_arr[0]['ok']   = 0;
                $ret_arr[0]['msg']  = $_SESSION['peg_dic_mydt_mydt10_is_related_err'];
                return $ret_arr;
            }

            pegasus_mysql_use("select * from mydt10 where tbl=:tbl and tbl_nr01=:tbl_nr01;", $mydt10, array('tbl' => $tbl, 'tbl_nr01' => $tbl_nr01));
            if ($mydt10['nr01'] > 0 and $mydt10['p01'] == 1) {
                pegasus_mysql_update('mydt10', array('p02_1'), array('1'), "tbl=:tbl and tbl_nr01=:tbl_nr01", 0, 1, 1, array('tbl' => $tbl, 'tbl_nr01' => $tbl_nr01));
            }

            if ($mydt10['nr01'] > 0 and $mydt10['p01'] == 2) {
                pegasus_mysql_update('mydt10', array('p02_1'), array('1'), "tbl=:tbl and tbl_nr01=:tbl_nr01", 0, 1, 1, array('tbl' => $tbl, 'tbl_nr01' => $tbl_nr01));
            }

            $mydt_mydt10->execute_update();


            ///if global var exists, set rel and save
            if(!empty(pegasusGetGlobalVar($tbl.'_'.$tbl_nr01. '_mydata_mydt10_nr01'))){

                $mydata_mydt10_nr01 = pegasusGetGlobalVar($tbl.'_'.$tbl_nr01. '_mydata_mydt10_nr01');
                
                mydt_mydt10_set_relation($tbl, $tbl_nr01, $mydata_mydt10_nr01);

                pegasusUnSetGlobalVar($tbl.'_'.$tbl_nr01. '_mydata_mydt10_nr01');
            }

            // Update transmission_failure if set
            if($tr_fail_flag == 1) {
                pegasus_mysql_update('mydt10', array('tr_fail'), array(3), "tbl=:tbl and tbl_nr01=:tbl_nr01", 0, 1, 1, array('tbl' => $tbl, 'tbl_nr01' => $tbl_nr01));
            }

            $res = pegasus_query("select * from mydt10 where (tbl=:tbl && tbl_nr01=:tbl_nr01) || (tbl=:tbl1 && tbl_nr01=:tbl_nr01 && p02_1=1);", array('tbl' => $tbl, 'tbl1' => '#' . $tbl . '#', 'tbl_nr01' => $tbl_nr01));
            $i = 0;
            while ($mydt10 = pegasus_fetch_assoc($res)) {
                // Aν εχει λαθος 
                if (!empty($mydt10['p04'])) {
                    $ret_arr[$i]['ok']   = 0;
                    $ret_arr[$i]['msg']  = mydt_mydt10::find_errors_descriptions($mydt10['p04']);
                    $ret_arr[$i]['has_pegasus_error'] = 1;
                } elseif ( ($only_if_auto && $_SESSION['mydt00_p102'] == 1) || !$only_if_auto) {
                    // 31/12/2024 - Πλέον κάνουμε αποστολή και όταν έχουμε only_if_auto = false (toolbar item επαναδημιουργίας παραστατικού)
                    // 31/12/2024 - αν δηλαδή πλέον πατήσουμε το πλήκτρο "Eνημέρωση - Δημιουργία και αποστολή Παραστατικου ΜyData" θα εκτελέσει και αποστολή στο myDATA μετά την δημιουργία, ανεξαρτήτως αν είναι ενεργή η αυτόματη αποστολή
                    // 31/12/2024 - Το χρειαστήκαμε αρχικά για την επαναποστολή στα tran09 και είπαμε να το κάνουμε για όλα ώστε να έχει νόημα αυτό το toolbar item.
                    $ret_arr[$i] = mydt_send_to_aade($mydt10['nr01'], $only_if_auto); 
                    if(!empty($ret_arr[$i]['msg'])) {
                        $ret_arr[$i]['has_msg_from_mydt_send_to_aade'] = 1; 
                    }
                    $ret_arr[$i]['nr01'] = $mydt10['nr01'];

                    if(pegasus_module_exists('dc00') &&  pegasus_mysql_table_exists('dc0003') && function_exists('dc00_send_dc0003')){
						//Συνδεση με ψηφιακο πελατολογιο
                        $dc_ret_array = dc00_send_dc0003($mydt10['nr01']);
                        $ret_arr[$i]['msg'] .= '<br>'.$dc_ret_array['succeed'];
                        $ret_arr[$i]['msg'] .= '<br>'.$dc_ret_array['failed'];	

                        //Εμφανιζω μηνυμα για ολοκληρωση 
				        $ret_arr[$i]['dc0001_arr'] = $dc_ret_array['dc0001_arr'];
					}

                } else {
                    $ret_arr[$i]['ok']   = 1;
                    $ret_arr[$i]['msg']  = $_SESSION['peg_dic_mydt_mydt10_record_created'];
                    $ret_arr[$i]['nr01'] = $mydt10['nr01'];
                }
               
                $i++;
            }
        } catch (Exception $e) {
            $ret_arr[0]['ok']  = 0;
            $ret_arr[0]['msg'] = $e->getMessage();
        }

        $msg_tit = '';
        if ($tbl == 'a55') {
            pegasus_mysql_use("select concat( a10.p02 , ' ' , a55.p701 ,  a55.p06  ) as tit from a55 join a10 on a55.p05=a10.p01 where a55.nr01=:tbl_nr01;", $a55, array('tbl_nr01' => $tbl_nr01));
            $msg_tit =  '<u>' . $a55['tit'] .  ':</u> ';
        }
        if ($tbl == 'a56') {
            pegasus_mysql_use("select concat( a11.p02 , ' ' , a56.p701 ,  a56.p06  ) as tit from a56 join a11 on a56.p05=a11.p01 where a56.nr01=:tbl_nr01;", $a55, array('tbl_nr01' => $tbl_nr01));
            $msg_tit =  '<u>' . $a55['tit'] .  ':</u> ';
        }

        $i = 0;
        while (isset($ret_arr[$i]['ok'])) {
            if (!empty($msg_tit) && !empty($ret_arr[$i]['msg'])) {
                $ret_arr[$i]['msg'] = $msg_tit . $ret_arr[$i]['msg'];
            }
            $i++;
        }
        
        return $ret_arr;
    }
    function mydt_mydt10_set_relation($tbl, $tbl_nr01, $mydt10_nr01){

        $new_mydt10_nr01 = pegasus_mysql_printfld('mydt10', 'nr01', 'tbl=:tbl and tbl_nr01=:tbl_nr01', array('tbl' => $tbl, 'tbl_nr01' => $tbl_nr01));

        $screen = new screen();
        $screen->container_id = pegasus_container_id_create(0 , session_id() , 'mydt10_d');
        $screen->module       = 'mydt';
        $screen->_d           = 'mydt10_d';
        $screen->table        = 'mydt10';
        $screen->nr01         = $mydt10_nr01;
        $screen->read_data_from_db();
        $screen->read_params_from_db();

        $screen->data['rel_nr'] = $new_mydt10_nr01;
        $_REQUEST = $screen->data;
        $_REQUEST['no_confirm'] = 1;
        $ret = $screen->save_data();
        peg_close_d($screen->container_id);
    }
    /**
     * Ελέγχει αν το παραστατικό έχει εκδοθεί Χ ώρα πριν την προσπάθεια αποστολής
     * Αν την ξεπερνά, επιστρέφει οκ 0.
     * Χρησιμοποίεται στον έλεγχο αποστολής στο mydata για να επιλέξει ο χρήστης αν θέλει να το στείλει με transmission_failure
     */
    function mydt_check_for_tran_failure($tbl, $tbl_nr01) {
        // p01 / p014 = Ημερομηνία
        // p02 / p017 = Ώρα
        $valid_tbls = array('a55', 'a56', 't08', 'tran01', 'a60', 'tran09');
        if(!in_array($tbl, $valid_tbls)) {
            return array(
                'ok'	=> 1,
                'msg'	=> ''
            );
        }

        //Το query μου φέρνει αποτελέσματα όταν το παραστατικό έχει κοπεί σε διάστημα 2 λεπτών, ή όταν έχει tr_fail = 2
        $query = "	SELECT a55.nr01 AS nr01
                    FROM a55
                    LEFT JOIN mydt10 ON mydt10.tbl_nr01 = a55.nr01 AND mydt10.tbl = 'a55'
                    LEFT JOIN q31 ON q31.p03 = a55.p05 AND q31.p01 = '620014'
                    WHERE a55.nr01 = :tbl_nr01
                    AND (
                            mydt10.tr_fail = 2
                            OR q31.p01 IS NULL
                            OR a55.pweb01 = 1
                            OR STR_TO_DATE(CONCAT(IFNULL(a55.p01,'0100-01-01'),' ',IFNULL(a55.p02,'00:00:00')),'%Y-%m-%d %H:%i:%s') >= CAST(:date_time AS DATETIME) - INTERVAL 24 HOUR
                    )
        ";
        if($tbl == 'a56') {
            $query = "	SELECT a56.nr01
                        FROM a56
                        LEFT JOIN mydt10 ON mydt10.tbl = 'a56' AND mydt10.tbl_nr01 = a56.nr01
                        LEFT JOIN q31 ON q31.p03 = a56.p05 and q31.p01 = '620017'
                        WHERE a56.nr01 = :tbl_nr01
                        AND (
                                mydt10.tr_fail = 2
                                OR q31.p01 IS NULL
                                OR a56.pweb01 = 1
                                OR STR_TO_DATE(CONCAT(IFNULL(a56.p01,'0100-01-01'),' ',IFNULL(a56.p02,'00:00:00')),'%Y-%m-%d %H:%i:%s') >= CAST(:date_time AS DATETIME) - INTERVAL 24 HOUR
                        )
            ";
        }
        if($tbl == 't08') {
            $query = "	SELECT t08.nr01
                        FROM t08
                        LEFT JOIN mydt10 ON mydt10.tbl = 't08' AND mydt10.tbl_nr01 = t08.nr01
                        LEFT JOIN q31 ON q31.p03 = t08.p05 and q31.p01 = '620019' 
                        WHERE t08.nr01 = :tbl_nr01
                        AND (
                                mydt10.tr_fail = 2
                                OR q31.p01 IS NULL
                                OR  STR_TO_DATE(CONCAT(IFNULL(t08.p01,'0100-01-01'),' ',IFNULL(t08.p02,'00:00:00')),'%Y-%m-%d %H:%i:%s') >= CAST(:date_time AS DATETIME) - INTERVAL 24 HOUR
                        )
            ";
        }
        if($tbl == 'tran01') {
            $query = "	SELECT tran01.nr01
                        FROM tran01
                        LEFT JOIN mydt10 ON mydt10.tbl = 'tran01' AND mydt10.tbl_nr01 = tran01.nr01
                        LEFT JOIN q31 ON q31.p03 = tran01.p105 and q31.p01 = '620030'
                        WHERE tran01.nr01 = :tbl_nr01
                        AND (
                                mydt10.tr_fail = 2
                                OR q31.p01 IS NULL
                                OR STR_TO_DATE(CONCAT(IFNULL(tran01.p014,'0100-01-01'),' ',IFNULL(tran01.p017,'00:00:00')),'%Y-%m-%d %H:%i:%s') >= CAST(:date_time AS DATETIME) - INTERVAL 24 HOUR   
                        )
            ";
        }
        if($tbl == 'a60') {
            $query = "	SELECT a60.nr01 AS nr01
                        FROM a60
                        LEFT JOIN mydt10 ON mydt10.tbl_nr01 = a60.nr01 AND mydt10.tbl = 'a60'
                        LEFT JOIN q31 ON q31.p03 = a60.p05 AND q31.p01 = '620072'
                        WHERE a60.nr01 = :tbl_nr01
                        AND (
                                mydt10.tr_fail = 2
                                OR q31.p01 IS NULL
                                OR STR_TO_DATE(CONCAT(IFNULL(a60.p01,'0100-01-01'),' ',IFNULL(a60.p02,'00:00:00')),'%Y-%m-%d %H:%i:%s') >= CAST(:date_time AS DATETIME) - INTERVAL 24 HOUR
                        )
            ";
        }
        if($tbl == 'tran09') {
            $query = "	SELECT tran09.nr01
                        FROM tran09
                        LEFT JOIN mydt10 ON mydt10.tbl = 'tran09' AND mydt10.tbl_nr01 = tran09.nr01
                        LEFT JOIN q31 ON q31.p03 = tran09.p101 and q31.p01 = '620075'
                        WHERE tran09.nr01 = :tbl_nr01
                        AND (
                                mydt10.tr_fail = 2
                                OR q31.p01 IS NULL
                                OR STR_TO_DATE(CONCAT(IFNULL(tran09.p02,'0100-01-01'),' ', '00:00:00'),'%Y-%m-%d %H:%i:%s') >= CAST(:date_time AS DATETIME) - INTERVAL 24 HOUR   
                        )
            ";
        }
        $queryParams = array(
            'tbl_nr01' => $tbl_nr01,
            'date_time' => date('Y-m-d H:i:00')
        );
        // echo '<pre>' .pegasus_replace_values_in_sql($query, $queryParams). '</pre>';
        $res = pegasus_query($query, $queryParams);
        $rs  = pegasus_fetch_assoc($res);

        //print_r($rs);

        //Το query μου φέρνει αποτελέσματα όταν το παραστατικό έχει κοπεί σε διάστημα 2 λεπτών, άρα μπορεί να ξαναφύγει χωρίς tr_fail
        if($rs['nr01'] > 0) {
            return array(
                'ok'	=> 1,
                'msg'	=> ''
            );
        }

        $res_mydt10 = array();
        $query_mydt10 = "SELECT mydt10.series, mydt10.aa FROM mydt10 WHERE tbl = :tbl and tbl_nr01 = :tbl_nr01";
    
        pegasus_mysql_use($query_mydt10, $res_mydt10, array('tbl' => $tbl, 'tbl_nr01' => $tbl_nr01));

        $ret_arr = array(
            'ok'	=> 0,
            'msg'	=> str_replace("#invoice#", ($res_mydt10['series'].$res_mydt10['aa']), $_SESSION['peg_dic_mydt_invoice_transmission_failure_confirm'])
        );

        if(in_array($tbl, array('a55','a56'))){
            //Έλεγχος Παραστατικού Σε Αναμονη
            if(pegasus_mysql_printfld($tbl, 'pweb01', 'nr01=:nr01', array('nr01' => $tbl_nr01))==1){
                $ret_arr['msg'] = '';	
            }
        }

        return $ret_arr;
        
    }
    function mydt_mydt10_d51_initialize($data,$mmnr01,$mnr01,$_d,$container_id){
        if($_d == 'mydt10_d51'){

            $data['message'] ="<div class='success_message'> ".$_SESSION['peg_dic_mydt_mydt10_d51_message']." </div>" ;
            $data['dt_from'] = date('Y-m-d', mktime(0, 0, 0, 1, 1, date('Y')));
		    $data['dt_to'] = date('Y-m-d');
            $query = "  SELECT
                            IF(mydt10_2.nr01 IS NULL, 0, 1)                         AS p00,
                            mydt10_1.nr01                                           AS nr01,
                            mydt10_1.nr01                                           AS nr01_1,
                            IFNULL(mydt10_2.nr01, 0)                                AS nr01_2,
                            mydt10_1.series                                         AS p01_1,
                            IFNULL(mydt10_2.series, '')                             AS p01_2,
                            mydt10_1.aa                                             AS p02_1,
                            IFNULL(mydt10_2.aa, '')                                 AS p02_2,
                            mydt10_1.issuedate                                      AS p03_1,
                            CAST(IFNULL(mydt10_2.issuedate, '01000101') AS DATE)    AS p03_2,
                            mydt10_1.tgross_val                                     AS p04_1,
                            IFNULL(mydt10_2.tgross_val, 0)                          AS p04_2,
                            mydt10_1.is_vat                                         AS p05_1,
                            CASE mydt10_1.is_name
                            -- suppliers_exists WHEN '' THEN IFNULL((SELECT a00_in.p19 FROM a00 AS a00_in WHERE a00_in.p20 = mydt10_1.is_vat LIMIT 1),'')
                                                WHEN '' THEN ''
                                ELSE mydt10_1.is_name
                            END                                                     AS p06_1,
                            IFNULL(mydt10_2.is_name, '')                            AS p101,
                            IFNULL(mydt10_2.cp_name, '')                            AS p102,
                            CASE mydt10_2.tbl
                                -- invcust_exists    WHEN 'a55'      THEN concat(a10.p00, ' ', a55.p701, ' ', a55.p06)
                                -- receipts_exists   WHEN 't08'      THEN concat(t10.p00, ' ', t08.p701, ' ', t08.p06)
                                -- tran_exists       WHEN 'tran01'   THEN concat(tran20.p00, ' ', tran01.sp00, ' ', tran01.p00)
                                WHEN '' THEN '' 
                                ELSE ''
                            END                                                     AS parastatiko,
                            mydt10_2.tbl                                            AS tbl, 
                            mydt10_2.tbl_nr01                                       AS tbl_nr01
                            FROM mydt10         AS mydt10_1 
                            LEFT JOIN mydt10    AS mydt10_2 ON mydt10_2.tbl <> '' 
                                                            AND mydt10_2.rel_nr = 0 
                                                            AND mydt10_2.p00 = mydt10_1.p00 
                                                            AND mydt10_2.p01 = mydt10_1.p01 
                                                            AND mydt10_2.uid = '' 
                                                            AND mydt10_2.mark = '' 
                                                            AND mydt10_2.p09 = 0 
                                                            AND mydt10_2.p02 = 0 
                                                            AND mydt10_2.issuedate = mydt10_1.issuedate 
                                                            AND mydt10_2.is_vat = mydt10_1.is_vat 
                                                            AND mydt10_2.cp_vat = mydt10_1.cp_vat 
                                                            AND mydt10_2.tgross_val = mydt10_1.tgross_val 
                                                            AND CAST(mydt10_2.aa AS signed) = CAST(mydt10_1.aa AS signed) 
                            -- invcust_exists LEFT JOIN a55 ON  mydt10_2.tbl='a55' and a55.nr01=  mydt10_2.tbl_nr01
                            -- invcust_exists LEFT JOIN a10 ON a55.p05 = a10.p01

                            -- receipts_exists LEFT JOIN t08 ON  mydt10_2.tbl='t08' and t08.nr01=  mydt10_2.tbl_nr01  
                            -- receipts_exists LEFT JOIN t10 ON t08.p05 = t10.p01  

                            -- tran_exists    LEFT JOIN tran01 ON  mydt10_2.tbl='tran01' and tran01.nr01=  mydt10_2.tbl_nr01
                            -- tran_exists    LEFT JOIN tran20 ON tran01.p105 = tran20.p01
                            WHERE 1 = 1
                            AND mydt10_1.issuedate >= CAST( :dt_from AS DATE) 
                            AND mydt10_1.issuedate <= CAST( :dt_to AS DATE) 
                            AND mydt10_1.p09 = 1 
                            AND mydt10_1.rel_nr = 0 
                            AND mydt10_1.p05 = 0 
                            AND mydt10_1.dmark = '' 
                            ORDER BY    mydt10_1.issuedate,
                                        mydt10_1.is_vat,
                                        mydt10_1.cp_vat,
                                        mydt10_1.series,
                                        mydt10_1.aa";

            $params = array(
                'dt_from' => $data['dt_from'], 
                'dt_to' => $data['dt_to']
            );
            if(pegasus_module_exists('suppliers')){
                $query = str_replace('-- suppliers_exists', '', $query);
            }
            if(pegasus_module_exists('invcust')){
                $query = str_replace('-- invcust_exists', '', $query);
            }
            if(pegasus_module_exists('receipts')){
                $query = str_replace('-- receipts_exists', '', $query);
            }
            if(pegasus_module_exists('tran')){
                $query = str_replace('-- tran_exists', '', $query);
            }
            pegasusSetGlobalVar($container_id.'_mydt10_d51_grid_query', array('sql' => $query, 
                'sqlParams' => $params
            ));
        }
        return $data;
    }
    function mydt_mydt10_d55_initialize($data,$mmnr01,$mnr01,$_d,$container_id){
        if($_d == 'mydt10_d55'){

            $data['dt_from'] = date('Y-m-d', mktime(0, 0, 0, 1, 1, date('Y')));
		    $data['dt_to'] = date('Y-m-d');

            $query = "SELECT 
                    mydt10.nr01 as mydt10,
                    if(@mydt10_nr01<>mydt10.nr01 , @print:=1 , @print:=0 ),  
                    @mydt10_nr01:=mydt10.nr01,
                    
                    
                    if(@print<>0 , mydt10.mark,  '')  as mydt10_mark,
                    /*mydt10.uid,*/
                    
                    if(@print<>0 , mydt10.series,  '')  as mydt10_series,
                    if(@print<>0 , mydt10.aa,  '')  as mydt10_aa,
                    if(@print<>0 , mydt10.is_vat,  '')  as mydt10_is_vat,
                    if(@print<>0 , mydt10.is_name,  '') as mydt10_is_name ,
                    if(@print<>0 , mydt10.cp_vat,  '')  as mydt10_cp_vat,
                    if(@print<>0 , mydt10.cp_name,  '')  as mydt10_cp_name,
                    if(@print<>0 , mydt10.issuedate,  '')  as mydt10_issuedate,
                    
                    if( mydt10.entuid<>'', 1, 0 ) as mydt_up_ok,
                    mydt12.linenumber,
                    mydt12.linerel,
                    mydt12.nr01 as nr01,

                    mydt58.p00 as mydt58_p00,
                    mydt58.p01 as mydt58_p01,
                    
                    mydt62.p00 as mydt62_p00,
                    mydt62.p01 as mydt62_p01,
                    
                    mydt62_fpa.p00 as mydt62_fpa_p00,
                    mydt62_fpa.p01 as mydt62_fpa_p01,
                    
                    
                    mydt57.p00 as mydt57_p00,
                    mydt57.p01 as mydt57_p01,
                    
                    mydt61.p00 as mydt61_p00,
                    mydt61.p01 as mydt61_p01,
                    
                    concat(' (' , mydt51.p00 , ') ' , mydt51.p01) as mydt51_p01,
                    concat(' (' , mydt52.p00 , ') ' , mydt52.p01) as mydt52_p01,
                    mydt12.netvalue as netvalue,
                    mydt12.fpavalue as fpavalue,
                    
                    if(@print<>0 , mydt10.nr01 , 0) as mydt10_nr01,
                    if(@print<>0 , mydt10.entuid,  '')  as mydt10_entuid
                    
                    /*if(@print=1 , mydt10.tgross_val,  '') as mydt10_tgross_val ,
                    mydt12.*
                    */
                    
                    
                    from mydt10 
                    left join mydt12 on mydt12.mydt10=mydt10.nr01 
                    
                    left join mydt57 on mydt12.mydt57_p00=mydt57.p00
                    left join mydt58 on mydt12.mydt58_p00=mydt58.p00
                    left join mydt61 on mydt12.mydt61_p00=mydt61.p00
                    left join mydt62 on mydt12.mydt62_p00=mydt62.p00
                    left join mydt62 as mydt62_fpa  on mydt12.mydt62_p01=mydt62_fpa.p00
                    
                    left join mydt51 on mydt12.vatcat=mydt51.p00
                    left join mydt52 on mydt12.vatexcat=mydt52.p00
                    
                    join mydt10 as mydt10_from_mydata on mydt10_from_mydata.rel_nr=mydt10.nr01 
                    
                    where mydt10.p01=2 
                          && mydt10.issuedate >= CAST( :dt_from AS DATE) 
                          && mydt10.issuedate <= CAST( :dt_to AS DATE) ";
 
            $params = array('dt_from'   => $data['dt_from'], 
                            'dt_to'     => $data['dt_to']);

            // die(pegasus_replace_values_in_sql($query, $params));
            pegasusSetGlobalVar($container_id.'_mydt10_d55_grid_query', 
                                array('sql' => $query, 
                                      'sqlParams' => $params));
        }
        return $data;

    }
    function mydt_mydt10_d52_initialize(
        $data = array(),
        $mmnr01 = '',
        $mnr01 = 0,
        $_d = '',
        $container_id = ''
    ) {
        if($_d == 'mydt10_d52') {
            $data['message'] ="<div class='success_message'> ".$_SESSION['peg_dic_mydt_mydt10_d52_message']." </div>" ;
            $data['dt_from'] = date('Y-m-d', mktime(0, 0, 0, 1, 1, date('Y')));
		    $data['dt_to'] = date('Y-m-d');
            mydt_mydt10_d52_set_grid_where_global_var(
                $data['dt_from'],
                $data['dt_to'],
                $container_id
            );
        }
        return $data;
    }
    function mydt_mydt10_d53_initialize(
        $data = array(),
        $mmnr01 = '',
        $mnr01 = 0,
        $_d = '',
        $container_id = ''
    ) {
        if($_d == 'mydt10_d53') {
            $data['message'] ="<div class='success_message'> ".$_SESSION['peg_dic_mydt_mydt10_d53_message']." </div>" ;
            $data['dt_from'] = date('Y-m-d', mktime(0, 0, 0, 1, 1, date('Y')));
		    $data['dt_to'] = date('Y-m-d');
            mydt_mydt10_d53_set_grid_where_global_var(
                $data['dt_from'],
                $data['dt_to'],
                $container_id
            );
        }
        return $data;
    }
    function mydt_mydt10_d56_initialize(
        $data = array(),
        $mmnr01 = '',
        $mnr01 = 0,
        $_d = '',
        $container_id = ''
    ) {
        $data['message'] ="<div class='success_message'> ".$_SESSION['peg_dic_mydt_mydt10_d56_message']." </div>" ;
        return $data;
    }
    function mydt_mydt10_d52_set_grid_where_global_var(
        $dt_from = '0100-01-01',
        $dt_to = '0100-01-01',
        $container_id = ''
    ) {
        //switch
        $query = "  SELECT
                        IF(mydt10_2.nr01 IS NULL, 0, 1)                         AS p00,
                        mydt10_1.nr01                                           AS nr01,
                        mydt10_1.nr01                                           AS nr01_1,
                        IFNULL(mydt10_2.nr01, 0)                                AS nr01_2,
                        mydt10_1.series                                         AS p01_1,
                        IFNULL(mydt10_2.series, '')                             AS p01_2,
                        mydt10_1.aa                                             AS p02_1,
                        IFNULL(mydt10_2.aa, '')                                 AS p02_2,
                        mydt10_1.issuedate                                      AS p03_1,
                        CAST(IFNULL(mydt10_2.issuedate, '0100-01-01') AS DATE)  AS p03_2,
                        mydt10_1.tgross_val                                     AS p04_1,
                        IFNULL(mydt10_2.tgross_val, 0)                          AS p04_2,
                        mydt10_1.is_vat                                         AS p05_1,
                        CASE mydt10_1.is_name
                        -- suppliers_exists WHEN '' THEN IFNULL((SELECT a00_in.p19 FROM a00 AS a00_in WHERE a00_in.p20 = mydt10_1.is_vat LIMIT 1),'')
                                            WHEN '' THEN ''
                            ELSE mydt10_1.is_name
                        END                                                     AS p06_1,
                        IFNULL(mydt10_2.is_name, '')                            AS p101,
                        IFNULL(mydt10_2.cp_name, '')                            AS p102,
                        CASE mydt10_2.tbl
                            -- invcust_exists    WHEN 'a55'      THEN concat(a10.p00, ' ', a55.p701, ' ', a55.p06)
                            -- receipts_exists   WHEN 't08'      THEN concat(t10.p00, ' ', t08.p701, ' ', t08.p06)
                            -- tran_exists       WHEN 'tran01'   THEN concat(tran20.p00, ' ', tran01.sp00, ' ', tran01.p00)
                            WHEN '' THEN '' 
                            ELSE ''
                        END                                                     AS parastatiko,
                        mydt10_2.tbl                                            AS tbl, 
                        mydt10_2.tbl_nr01                                       AS tbl_nr01
                    FROM mydt10         AS mydt10_1 
                    LEFT JOIN mydt10    AS mydt10_2 ON mydt10_2.tbl <> '' 
                                                    AND mydt10_2.rel_nr = 0 
                                                    AND mydt10_2.p00 = mydt10_1.p00 
                                                    AND mydt10_2.p01 = mydt10_1.p01 
                                                    AND mydt10_2.uid = '' 
                                                    AND mydt10_2.mark = '' 
                                                    AND mydt10_2.p09 = 0 
                                                    AND mydt10_2.p02 = 0 
                                                    AND mydt10_2.issuedate = mydt10_1.issuedate 
                                                    AND mydt10_2.is_vat = mydt10_1.is_vat 
                                                    AND mydt10_2.cp_vat = mydt10_1.cp_vat 
                                                    AND mydt10_2.tgross_val = mydt10_1.tgross_val 
                                                    AND CAST(mydt10_2.aa AS signed) = CAST(mydt10_1.aa AS signed)
                    -- invcust_exists   LEFT JOIN a55 on  mydt10_2.tbl='a55' and a55.nr01=  mydt10_2.tbl_nr01
                    -- invcust_exists   LEFT JOIN a10 on a55.p05 = a10.p01

                    -- tran_exists      LEFT JOIN tran01 on  mydt10_2.tbl='tran01' and tran01.nr01=  mydt10_2.tbl_nr01
                    -- tran_exists      LEFT JOIN tran20 on tran01.p105 = tran20.p01

                    -- receipts_exists  LEFT JOIN t08 on  mydt10_2.tbl='t08' and t08.nr01=  mydt10_2.tbl_nr01  
                    -- receipts_exists  LEFT JOIN t10 on t08.p05 = t10.p01  
                    WHERE 1 = 1
                    AND mydt10_1.issuedate >= CAST( :dt_from AS DATE) 
                    AND mydt10_1.issuedate <= CAST( :dt_to AS DATE) 
                    AND (mydt10_1.mark = 0 OR mydt10_1.mark = '')   /* Μοναδικός Αριθμός (ΜΑΡΚ) */
                    AND (mydt10_1.einv = 1 OR mydt10_1.einv = 3 )   /* Συμμετέχει στην Ηλ. Τιμολόγηση: Συμμετέχει με Pegasus ή με ΥΛΙΔΑ*/
                    AND mydt10_1.tr_fail = 2                        /* Αδυναμία Διαβίβασης:  Aδυναμία επικοινωνίας του Παρόχου με το myDATA */
                    ORDER BY    mydt10_1.issuedate,
                                mydt10_1.is_vat,
                                mydt10_1.cp_vat,
                                mydt10_1.series,
                                mydt10_1.aa
        ";
        $params = array(
            'dt_from'   => $dt_from, 
            'dt_to'     => $dt_to
        );
        if(pegasus_module_exists('suppliers')){
            $query = str_replace('-- suppliers_exists', '', $query);
        }
        if(pegasus_module_exists('invcust')){
            $query = str_replace('-- invcust_exists', '', $query);
        }
        if(pegasus_module_exists('receipts')){
            $query = str_replace('-- receipts_exists', '', $query);
        }
        if(pegasus_module_exists('tran')){
            $query = str_replace('-- tran_exists', '', $query);
        }
        pegasusSetGlobalVar(
            $container_id.'_mydt10_d52_grid_query', 
            array(
                'sql' => $query, 
                'sqlParams' => $params
            )
        );
    }
    function mydt_mydt10_d53_set_grid_where_global_var(
        $dt_from = '0100-01-01',
        $dt_to = '0100-01-01',
        $container_id = ''
    ) {
        $query = "  SELECT
                        IF(mydt10_2.nr01 IS NULL, 0, 1)                         AS p00,
                        mydt10_1.nr01                                           AS nr01,
                        mydt10_1.nr01                                           AS nr01_1,
                        IFNULL(mydt10_2.nr01, 0)                                AS nr01_2,
                        mydt10_1.series                                         AS p01_1,
                        IFNULL(mydt10_2.series, '')                             AS p01_2,
                        mydt10_1.aa                                             AS p02_1,
                        IFNULL(mydt10_2.aa, '')                                 AS p02_2,
                        mydt10_1.issuedate                                      AS p03_1,
                        CAST(IFNULL(mydt10_2.issuedate, '01000101') AS DATE)    AS p03_2,
                        mydt10_1.tgross_val                                     AS p04_1,
                        IFNULL(mydt10_2.tgross_val, 0)                          AS p04_2,
                        mydt10_1.is_vat                                         AS p05_1,
                        CASE mydt10_1.is_name
                        -- suppliers_exists WHEN '' THEN IFNULL((SELECT a00_in.p19 FROM a00 AS a00_in WHERE a00_in.p20 = mydt10_1.is_vat LIMIT 1),'')
                                            WHEN '' THEN ''
                            ELSE mydt10_1.is_name
                        END                                                     AS p06_1,
                        IFNULL(mydt10_2.is_name, '')                            AS p101,
                        IFNULL(mydt10_2.cp_name, '')                            AS p102,
                        CASE mydt10_2.tbl
                            -- invcust_exists   WHEN 'a55'      THEN concat(a10.p00, ' ', a55.p701, ' ', a55.p06)
                            -- receipts_exists  WHEN 't08'      THEN concat(t10.p00, ' ', t08.p701, ' ', t08.p06)
                            -- tran_exists      WHEN 'tran01'   THEN concat(tran20.p00, ' ', tran01.sp00, ' ', tran01.p00)
                                                WHEN ''         THEN ''
                            ELSE ''
                        END                                                     AS parastatiko,
                        mydt10_2.tbl                                            AS tbl, 
                        mydt10_2.tbl_nr01                                       AS tbl_nr01          
                    FROM mydt10         AS mydt10_1 
                    LEFT JOIN mydt10    AS mydt10_2 ON mydt10_2.tbl <> '' 
                                                    AND mydt10_2.rel_nr = 0 
                                                    AND mydt10_2.p00 = mydt10_1.p00 
                                                    AND mydt10_2.p01 = mydt10_1.p01 
                                                    AND mydt10_2.uid = '' 
                                                    AND mydt10_2.mark = '' 
                                                    AND mydt10_2.p09 = 0 
                                                    AND mydt10_2.p02 = 0 
                                                    AND mydt10_2.issuedate = mydt10_1.issuedate 
                                                    AND mydt10_2.is_vat = mydt10_1.is_vat 
                                                    AND mydt10_2.cp_vat = mydt10_1.cp_vat 
                                                    AND mydt10_2.tgross_val = mydt10_1.tgross_val 
                                                    AND CAST(mydt10_2.aa AS signed) = CAST(mydt10_1.aa AS signed)
                    -- invcust_exists LEFT JOIN a55 on  mydt10_2.tbl='a55' and a55.nr01=  mydt10_2.tbl_nr01
                    -- invcust_exists LEFT JOIN a10 on a55.p05 = a10.p01

                    -- receipts_exists LEFT JOIN t08 on  mydt10_2.tbl='t08' and t08.nr01=  mydt10_2.tbl_nr01  
                    -- receipts_exists LEFT JOIN t10 on t08.p05 = t10.p01  

                    -- tran_exists    LEFT JOIN tran01 on  mydt10_2.tbl='tran01' and tran01.nr01=  mydt10_2.tbl_nr01
                    -- tran_exists    LEFT JOIN tran20 on tran01.p105 = tran20.p01
                    WHERE 1 = 1
                    AND mydt10_1.issuedate >= CAST( :dt_from AS DATE) 
                    AND mydt10_1.issuedate <= CAST( :dt_to AS DATE)
                    AND (mydt10_1.mark = 0 OR mydt10_1.mark = '')   /* Μοναδικός Αριθμός (ΜΑΡΚ) */
                    AND mydt10_1.einv = 1                           /* Συμμετέχει στην Ηλ. Τιμολόγηση: Συμμετέχει με Pegasus */
                    AND mydt10_1.tr_fail != 2                       /* Αδυναμία Διαβίβασης:  Aδυναμία επικοινωνίας του Παρόχου με το myDATA */
                    ORDER BY    mydt10_1.issuedate,
                                mydt10_1.is_vat,
                                mydt10_1.cp_vat,
                                mydt10_1.series,
                                mydt10_1.aa
        ";
        $params = array(
            'dt_from'   => $dt_from, 
            'dt_to'     => $dt_to
        );
        if(pegasus_module_exists('suppliers')){
            $query = str_replace('-- suppliers_exists', '', $query);
        }
        if(pegasus_module_exists('invcust')){
            $query = str_replace('-- invcust_exists', '', $query);
        }
        if(pegasus_module_exists('receipts')){
            $query = str_replace('-- receipts_exists', '', $query);
        }
        if(pegasus_module_exists('tran')){
            $query = str_replace('-- tran_exists', '', $query);
        }
        pegasusSetGlobalVar(
            $container_id.'_mydt10_d53_grid_query', 
            array(
                'sql' => $query, 
                'sqlParams' => $params
            )
        );
    }
    function mydt_mydt10_d52_einv_get_multiple_by_mydt01_nr01(
        $nr01 = 0
    ) {
        $dic = array(
            'success'   => $_SESSION['peg_dic_mydt_mydt10_d53_success'],
            'warn'      => $_SESSION['peg_dic_mydt_mydt10_d53_warn']
        );
        if(!pegasus_module_exists('einv')) {
            return array(
                'ok'    => 0,
                'msg'   => $_SESSION['peg_dic_mydt_mydt10_d52_error_module'],
                'dic'   => $dic
            );
        }
        $mydt10 = array();
        pegasus_mysql_use("SELECT * FROM mydt10 WHERE nr01 = :nr01", $mydt10, array('nr01' => $nr01));
        if(empty($mydt10)) {
            $message = str_replace(
                '#nr01#',
                $nr01,
                $_SESSION['peg_dic_mydt_mydt10_d52_error_mydt01_not_found']
            );
            return array(
                'ok'    => 1,
                'data'  => array(
                    'toast'     => array('message' => $message, 'type' => 'alert')
                ),
                'dic'   => $dic
            );
        }

        $resp = einv00_check_and_save($mydt10['tbl'], $mydt10['tbl_nr01']);
        if($resp['ok'] != 1) {
            $message = "[$nr01] ".$resp['msg'];
            return array(
                'ok'    => 1,
                'data'  => array(
                    'toast'     => array('message' => $message, 'type' => 'alert')
                ),
                'dic'   => $dic
            );
        }
        return array(
            'ok'    => 1,
            'data'  => array(),
            'dic'   => $dic
        );
    }
    function mydt_mydt10_d56_grid_query() {
        $query = "  SELECT 
                        mydt13.*,
                        mydt10.tbl      AS mydt10_tbl,
                        mydt10.tbl_nr01 AS mydt10_tbl_nr01
                    FROM mydt13
                    JOIN mydt10 ON mydt10.nr01 = mydt13.mydt10
                    JOIN t19 ON t19.p_sign = mydt13.p_sign /* Δ: 10164644 ΠΠΥ: 10016358*/
                    WHERE 1 = 1
                    AND mydt10.einv = 1
                    AND mydt10.mark != ''
                    AND mydt13.`type` = 7
                    AND mydt13.einv_dt <= '0100-01-01'
                    AND mydt13.einv_tm = ''
        ";

        $params = array();
        return array(
                'sql' => $query, 
                'sqlParams' => $params
        );
    }
    function mydt_mydt10_d53_einv_get_multiple_by_mydt01_nr01(
        $nr01 = 0
    ) {
        $dic = array(
            'success'   => $_SESSION['peg_dic_mydt_mydt10_d53_success'],
            'warn'      => $_SESSION['peg_dic_mydt_mydt10_d53_warn']
        );
        if(!pegasus_module_exists('einv')) {
            return array(
                'ok'    => 0,
                'msg'   => $_SESSION['peg_dic_mydt_mydt10_d53_error_module'],
                'dic'   => $dic
            );
        }
        $mydt10 = array();
        pegasus_mysql_use("SELECT * FROM mydt10 WHERE nr01 = :nr01", $mydt10, array('nr01' => $nr01));
        if(empty($mydt10)) {
            $message = str_replace(
                '#nr01#',
                $nr01,
                $_SESSION['peg_dic_mydt_mydt10_d53_error_mydt01_not_found']
            );
            return array(
                'ok'    => 1,
                'data'  => array(
                    'toast'     => array('message' => $message, 'type' => 'alert')
                ),
                'dic'   => $dic
            );
        }
        $resp = einv00_check_for_tran_failure($mydt10['tbl'], $mydt10['tbl_nr01']);
        $transmission_failure = 0;
        if($resp['ok'] == 0) {
            $transmission_failure = 1;
        }
        $resp = einv00_check_and_save($mydt10['tbl'], $mydt10['tbl_nr01'],$transmission_failure);
        if($resp['ok'] != 1) {
            $message = "[$nr01] ".$resp['msg'];
            if($resp['einv'] == 0) {
                $message = "[$nr01] {$_SESSION['peg_dic_mydt_einv_check_fail']}";
            }
            return array(
                'ok'    => 1,
                'data'  => array(
                    'toast'     => array('message' => $message, 'type' => 'alert')
                ),
                'dic'   => $dic
            );
        }
        return array(
            'ok'    => 1,
            'data'  => array(),
            'dic'   => $dic
        );
    }
    function mydt_mydt10_get_tbl_data_by_nr01(
        $mydt10_nr01 = 0
    ) {
        $mydt10 = array();
        pegasus_mysql_use("SELECT * FROM mydt10 WHERE nr01 = :nr01", $mydt10, array('nr01' => $mydt10_nr01));
        if(empty($mydt10)) {
            // Το παραστατικό (mydt10) #nr01# δεν βρέθηκε.
            return array(
                'ok'    => 0,
                'msg'  => str_replace(
                    array(
                        '#nr01#'
                    ),
                    array(
                        $mydt10_nr01
                    ),
                    $_SESSION['peg_dic_mydt_mydt10_d53_error_mydt01_not_found']
                ),
            );
        }
        $data = array();
        switch ($mydt10['tbl']) {
            case 'a55' :
                $data = array(
                    'table'     => 'a55',
                    '_d'        => 'a55_d',
                    'module'    => 'invcust',
                    'nr01'      => $mydt10['tbl_nr01']
                );
                break;
            case 'a56' :
                $data = array(
                    'table'     => 'a56',
                    '_d'        => 'a56_d',
                    'module'    => 'invsupp',
                    'nr01'      => $mydt10['tbl_nr01']
                );
                break;
            case 'tran01' :
                $data = array(
                    'table'     => 'tran01',
                    '_d'        => 'tran01_d',
                    'module'    => 'tran',
                    'nr01'      => $mydt10['tbl_nr01']
                );
                break;
            case 't08' :
                $data = array(
                    'table'     => 't08',
                    '_d'        => 't08_d',
                    'module'    => 'receipts',
                    'nr01'      => $mydt10['tbl_nr01']
                );
                break;
        }
        return array(
            'ok'    => 1,
            'data'  => $data,
        );
    }

    function mydt_mydt10_d56_resend_mydt13($nr01 = 0) {
        $dic = array(
            'success'   => $_SESSION['peg_dic_mydt_mydt10_d56_success'],
            'warn'      => $_SESSION['peg_dic_mydt_mydt10_d56_warn']
        );
        if(!pegasus_module_exists('einv')) {
            return array(
                'ok'    => 0,
                'msg'   => $_SESSION['peg_dic_mydt_mydt10_d56_error_module']
            );
        }
        $mydt13 = array();
        pegasus_mysql_use("SELECT * FROM mydt13 WHERE nr01 = :nr01 AND mark = ''", $mydt13, array('nr01' => $nr01));
        if(empty($mydt13)) {
            $message = str_replace(
                '#nr01#',
                $nr01,
                $_SESSION['peg_dic_mydt_mydt10_d56_error_mydt01_not_found']
            );
            return array(
                'ok'    => 1,
                'data'  => array(
                    'toast'     => array('message' => $message, 'type' => 'alert')
                ),
                'dic'   => $dic
            );
        }
        
        $einv_update_invoice_resp = einv_update_invoice($nr01);

		if($einv_update_invoice_resp['ok'] != 1) {
            $message = "[$nr01] ".$einv_update_invoice_resp['msg'];
            return array(
                'ok'    => 1,
                'data'  => array(
                    'toast'     => array('message' => $message, 'type' => 'alert')
                ),
                'dic'   => $dic
            );
        }
        $where = "
            type = :type
            AND amount = :amount 
            AND p_sign = :p_sign
            AND mydt10 = :mydt10
        ";
        foreach($einv_update_invoice_resp['data']['einv05'] as $payment) {
            $values =  array(	
                'amount' => $payment['amount'],
                'type' 	 => $payment['type'],
                'p_sign' => $payment['p_sign'],
                'mydt10' => $mydt13['mydt10']
            );
            $mydt13_nr01 = pegasus_mysql_printfld('mydt13', 'nr01', $where, $values);
            if(empty($mydt13_nr01)) {
                continue;
            }
            $update = array(
                'mark'      => $einv_update_invoice_resp['data']['paymentMethodMark'],
                'p_info'    => $payment['p_info'],
                'einv_dt'   => date("Y-m-d"),
                'einv_tm'   => date("H:i")
            );
            pegasus_mysql_update(
                'mydt13', 
                array_keys($update),
                array_values($update),
                'nr01 = :nr01',
                0, 1, 1,
                array('nr01' => $mydt13_nr01)
            );
        }
        return array(
            'ok'    => 1,
            'data'  => array(),
            'dic'   => $dic
        );
    }

    /**
     * Ελέγχει αν το πρωτογενές παραστατικό αφορά σε πελάτη και είναι χειρόγραφο και ο τύπος είναι ορισμένος προς αποστολή.
     *
     * @param string    $tbl
     * @param int       $tbl_nr01
     * @return int      1/0
     */
    function mydt_check_if_xeir_and_customer_invoice($tbl, $tbl_nr01) {
        $ret = 0;
        if($tbl == 'a55') {
            $q = " SELECT 
                        ifnull( (select q31_in.p05
                                    from q31 as q31_in
                                    where q31_in.p01=620068
                                    && q31_in.p03=a10.p01
                                    limit 1), 
                        ifnull( (select q31_in.p05
                                    from q31 as q31_in
                                    where q31_in.p01=620014
                                    && q31_in.p03=a10.p01
                                    limit 1), '')) as invtype,
                        a55.p08
                    FROM a55
                    JOIN a10 on a55.p05 = a10.p01
                    WHERE a55.nr01 = :tbl_nr01";
            $v = array('tbl_nr01' => $tbl_nr01);
            pegasus_mysql_use($q, $a55, $v);
            if(!empty($a55['invtype']) && $a55['p08'] == 1) {
                $ret = 1;
            } 
        }elseif($tbl == 't08') {
            $q = " SELECT 
                        ifnull((select q31_in.p05
                            from q31 as q31_in
                            where q31_in.p01=620019
                            && q31_in.p03=t10.p01
                            limit 1), '') as invtype,
                        t08.p08,
                        t08.p03
                    FROM t08
                    JOIN t10 on t08.p05 = t10.p01
                    WHERE t08.nr01 = :tbl_nr01";
            $v = array('tbl_nr01' => $tbl_nr01);
            pegasus_mysql_use($q, $t08, $v);
            if(!empty($t08['invtype']) && $t08['p08'] == 1 && mb_substr($t08['p03'], 0, 2) == '30') {
                $ret = 1;
            }
        }else{
            $ret = 0;
        }

        return $ret;
    }