<?php 
    require_once('../mydt00/header.php');
    require_once('../mydt_libs/mydt_sync.php');
    require_once('../mydt_libs/mydt_mydt10.php');

    global $PegInput;

    // $PegInput->addVar(new peg_input_number('en_mark_search_on_receive'));
    $PegInput->addVar(new peg_input_alphanumeric('rcv_mark'));
    $PegInput->addVar(new peg_input_number('rcv_ent_vat'));
    $PegInput->addVar(new peg_input_alphanumeric('rcv_dt_from'));
    $PegInput->addVar(new peg_input_alphanumeric('rcv_dt_to'));
    $PegInput->addVar(new peg_input_number('rcv_rec_vat'));
    $PegInput->addVar(new peg_input_alphanumeric('rcv_invtype'));
    $PegInput->addVar(new peg_input_alphanumeric('rcv_maxmark'));
    $PegInput->addVar(new peg_input_alphanumeric('but_receive_all'));
    // $en_mark_search_on_receive = $PegInput->getRequest('en_mark_search_on_receive');
    $rcv_mark = $PegInput->getRequest('rcv_mark');
    $rcv_ent_vat = $PegInput->getRequest('rcv_ent_vat');
    $rcv_dt_from = $PegInput->getRequest('rcv_dt_from');
    $rcv_dt_to = $PegInput->getRequest('rcv_dt_to');
    $rcv_rec_vat = $PegInput->getRequest('rcv_rec_vat');
    $rcv_invtype = $PegInput->getRequest('rcv_invtype');
    $rcv_maxmark = $PegInput->getRequest('rcv_maxmark');
    $but_receive_all = $PegInput->getRequest('but_receive_all');

    if(!pegasus_check_permission('mydt.dashboard_buttons')){
        $ret_arr['ok'] = 0;  
        $message = str_replace("##button_label##", $but_receive_all, $_SESSION['peg_dic_mydt_dashboard_buttons_perm_deny']);
        $ret_arr['msg']  = $message;
        echo json_encode($ret_arr);
        return;    
    }
    
    $params = array();
    $params['rcv_mark']     = $rcv_mark;
    $params['rcv_ent_vat']  = $rcv_ent_vat;
    // Μόνο αν δεν είναι κενά γιατί η peg_dateToStr επιστρέφει τη σημερινή ημερομηνία αν κληθεί με κενό.
    if($rcv_dt_from != ''){
        $params['rcv_dt_from']  = peg_dateToStr($rcv_dt_from , 'd/m/Y'); // Format που δέχεται το myDATA
    }
    if($rcv_dt_to != ''){
        $params['rcv_dt_to']    = peg_dateToStr($rcv_dt_to , 'd/m/Y'); // Format που δέχεται το myDATA
    }
    $params['rcv_rec_vat']  = $rcv_rec_vat;
    $params['rcv_invtype']  = $rcv_invtype;
    $params['rcv_maxmark']  = $rcv_maxmark;


    try{
        //για να ξερω ποιες εγγραφες επηρεαστηκαν
        $p_mydt10tot = '@tot@_' . date('Ymd') .  '_' . rand(0, 99999);

        $mydt_sync = new mydt_sync();
        // $ret_arr = $mydt_sync->invoiceDoc_get($en_mark_search_on_receive,$p_mydt10tot, $params);
        /**
         * 22/02/2023 - Removed "$en_mark_search_on_receive" parameter.
         */
        $ret_arr = $mydt_sync->invoiceDoc_get($p_mydt10tot, $params);

        
        // φτιαχνει mydt12 σε ολα τα records ειναι λαθος θα επρεπε μονο για τα nr01 πιο πανω
        mydt_mydt10::create_mydt12_records('',0,'',$p_mydt10tot);

        //unset του p_mydt10tot  στις εγγραφές που επηρέαστηκαν και δημιουργήθηκαν οι mydt12
        pegasus_mysql_update('mydt10', array('remguc'), array(''), 'mydt10.remguc=:p_mydt10tot', 0, 1, 1, array('p_mydt10tot' => $p_mydt10tot));

    }

    catch (Exception $e) {
        $ret_arr['ok']   = 0;
        $ret_arr['msg']  = $e->getMessage();    
    }
 


    echo json_encode($ret_arr);
?>