<?php
require('../mydt00/header.php');
global $PegInput;

require_once('../mydt_libs/mydt_mydt10.php');
require_once('../mydt_libs/mydt_mydt12.php');

$PegInput->addVar(new peg_input_alphanumeric('mydt10_nr01'));
$mydt10_nr01_str = $PegInput->getRequest('mydt10_nr01');
$PegInput->addVar(new peg_input_alphanumeric('but_remake_sel'));
$but_remake_sel = $PegInput->getRequest('but_remake_sel');

if(!pegasus_check_permission('mydt.dashboard_buttons')){
    $ret_arr['ok'] = 0;  
    $message = str_replace("##button_label##", $but_remake_sel , $_SESSION['peg_dic_mydt_dashboard_buttons_perm_deny']);
    $ret_arr['msg']  = $message;
    echo json_encode($ret_arr);
    return;    
}

$ret_arr = array();
$ret_arr['debug'] = array();
$mydt10_nr01_arr = explode(';', $mydt10_nr01_str);
$mydt10_nr01_arr = array_filter($mydt10_nr01_arr);
$selected = count($mydt10_nr01_arr);
$einv_cnt = 0;
$is_dlv_w_mark_cnt = 0;
try {
    foreach($mydt10_nr01_arr as $key) {
        //mydt10.einv = 0 => Χωρίς einv
        pegasus_mysql_use('SELECT 
                                mydt10.tbl as tbl, 
                                mydt10.tbl_nr01 as tbl_nr01, 
                                mydt10.einv as einv, 
                                if((mydt10.isdlvno = 1 OR mydt50.p107 = 1) AND mydt10.mark <> "", 1, 0) as is_dlv_w_mark
                            FROM mydt10
                            LEFT JOIN mydt50 ON mydt50.p00 = mydt10.invtype
                            WHERE mydt10.nr01 = ?', 
        $mydt10, array($key));

        if($mydt10['einv'] > 0){
            $einv_cnt++;
        }

        if($mydt10['is_dlv_w_mark'] > 0) {
            $is_dlv_w_mark_cnt++;
        }

        
        if($mydt10['einv'] == 0 && $mydt10['is_dlv_w_mark'] == 0){
            // Σημειώνω το παραστατικό myDATA "προς επαναποστολή = 1" στα παραστατικά με τη σήμανση "Έκλεισε" γιατί αλλιώς δεν παίζει η επαναδημιουργία.
            pegasus_mysql_update('mydt10', array('p02_1'), array(1), 'nr01 = ? and p02=1', 0, 1, 1, array($key));
            $ret_arr['debug'][] = $mydt10;

            $mydt_mydt10 = new mydt_mydt10($mydt10['tbl'], $mydt10['tbl_nr01']);
            $mydt_mydt10->execute_update();
        }

    }

    //Να φτιάξω καλύτερα το μήνυμα να μετράει πόσα δεν στάλθηκαν. Αν είναι 0 τα σταλμένα ok=0
    if($einv_cnt == $selected){
        $ret_arr['ok'] = 0;
        $ret_arr['msg'] = $_SESSION['peg_dic_mydt_mydt10_invoices_recreated_unsuccessfully'];
    }elseif($is_dlv_w_mark_cnt == $selected){
        $ret_arr['ok'] = 0;
        $ret_arr['msg'] = $_SESSION['peg_dic_mydt_mydt10_invoices_recreated_unsuccessfully_err2'];
    }else{
        $ret_arr['ok']   = 1;  
        $ret_arr['msg']  = str_replace(array("##success##", "##total##" ), array($selected-$einv_cnt-$is_dlv_w_mark_cnt, $selected), $_SESSION['peg_dic_mydt_mydt10_invoices_recreated_successfully']);   
        if($einv_cnt > 0){
            $ret_arr['msg'] .= "<br>". $_SESSION['peg_dic_mydt_mydt10_invoices_recreated_unsuccessfully'] ;
            $ret_arr['ok'] = 0;
            $ret_arr['refresh'] = 1; //Για να κάνει refresh το grid όταν έχω fail και τουλ. 1 success  
        }
        if($is_dlv_w_mark_cnt > 0){
            $ret_arr['msg'] .= "<br>". $_SESSION['peg_dic_mydt_mydt10_invoices_recreated_unsuccessfully_err2'] ;
            $ret_arr['ok'] = 0;
            $ret_arr['refresh'] = 1; //Για να κάνει refresh το grid όταν έχω fail και τουλ. 1 success  
        }
    }
}catch(Exception $e) {
    $ret_arr['ok']   = 0;
    $ret_arr['msg']  = $e->getMessage();
}

 
echo json_encode($ret_arr);
