<?php
    /**
     * Η κλάση αυτή χρησιμοποιείται για να υπολογίσουμε πεδία του mydt10 πριν αυτό δμιουργηθεί, 
     * π.χ. κατά τη δμημιουργία υπογραφής σε υπο έκδοση παραστατικά, όπου το mydt10 δεν έχει ακόμη δημιουργηθεί 
     */
    class mydt_before_mydt10{

        public static function find_a55_totals($tbl_nr01){


            $sql = peg_read_file('../mydt_sql/a55/mydt10p200202_100.sql');
            $sql = str_replace( '{peg_dek}',  '2' , $sql);
            $sql = str_replace( '{p_mydt10tbl1}',  '(SELECT "a55" AS tbl , nr01 AS tbl_nr01 FROM a55 WHERE nr01=:tbl_nr01)' , $sql);
            

            $totals_query = 
            "SELECT ptbl AS ptbl, 
                ptbl_nr01 AS ptbl_nr01, 
                sum(if(fpavalue<>0 && (feestype<>'' || otaxpcat<>'') , fees_am + otax_am ,  netvalue)) AS netvalue, 
                sum(fpavalue) AS fpavalue, 
                sum(wthhld_am) AS wthhld_am, 
                sum(if(fpavalue<>0 && otaxpcat<>'' , 0 , otax_am)) AS otax_am, 
                sum(if(fpavalue<>0 && feestype<>'' , 0 , fees_am)) AS fees_am,
                sum(stampvalue) AS stampvalue, 
                sum(deducvalue) AS deducvalue, 
                /*v1.55*/
                        IF(group_concat(fuelcode SEPARATOR '') <> '', 1, 0) AS has_fuelcode
                FROM ({p_mydt10tbl2}) as ttt
                GROUP BY  ptbl, ptbl_nr01";

            $totals_query = str_replace( '{p_mydt10tbl2}',  $sql , $totals_query);
        
            //echo pegasus_replace_values_in_sql($totals_query, array("tbl_nr01" => $tbl_nr01));
            pegasus_mysql_use($totals_query, $totals, array("tbl_nr01" => $tbl_nr01));
           
           
            return [
                "tnetvalue"     => $totals["netvalue"], 
                "tvat_am"       => $totals["fpavalue"], 
                "twthhld_am"    => $totals["wthhld_am"], 
                "ttax_am"       => $totals["otax_am"], 
                "tfees_am"      => $totals["fees_am"], 
                "tstamp_am"     => $totals["stampvalue"], 
                "tdeduction"    => $totals["deducvalue"], 
                "tgross_val"    => $totals["netvalue"] + $totals["fpavalue"] -  $totals["wthhld_am"] + $totals["otax_am"] +  $totals["fees_am"] + $totals["stampvalue"] -  $totals["deducvalue"], 
                "fuelinv"       => $totals["has_fuelcode"]
            ];
        }
        public static function mydt_find_issuer_vat($t07_p01){
       
            if(!pegasus_module_exists("stores")){
                return $_SESSION["cor000_f00p204"];
            }
            $query = 
            "SELECT 
                IF(t05.p204 <> '' && t05.p204 is not null  ,t05.p204, cor000.f00p204) AS is_vat,
                t05.p204, cor000.f00p204
                FROM    cor000
                left join t07 on t07.p01=:t07_p01
                left join t05 on t05.p01=t07.p07 
            ";
    
            pegasus_mysql_use($query, $tbl1, array('t07_p01' => $t07_p01));
            return $tbl1["is_vat"];
        }
    
        public static function mydt_find_issuer_branch($t07_p01){
            if(!pegasus_module_exists("stores")){
                return 0;
            }
            $query = 
            "SELECT 
                IF(IFNULL(t07.p06, 0) = '', 0, IFNULL(t07.p06, 0)) AS is_branch
                FROM    cor000
                left join t07 on t07.p01=:t07_p01
            ";
    
            pegasus_mysql_use($query, $tbl1, array('t07_p01' => $t07_p01));
            return $tbl1["is_branch"];
    
        }
    
        public static function mydt_find_series($tbl, $tbl_nr01){
    
            switch ($tbl) {
                case 'a55':
                    $query =
                        "SELECT 
                            if( ifnull(mydt00.p103, 0)=1, concat(ifnull(a10.p00, ''), if(a55.p701='', '', '-'), a55.p701),a55.p701) as series
                            FROM a55 
                            LEFT JOIN a10 on a10.p01 = a55.p05 
                            LEFT JOIN mydt00 on mydt00.nr01 = 1 
                            WHERE a55.nr01 = ? 
                        ";
                    break;
                case 'a56':
                    $query =
                        "SELECT 
                            if( ifnull(mydt00.p103, 0)=1, concat(ifnull(a11.p00, ''), if(a56.p701='', '', '-'), a56.p701),a56.p701) as series
                            FROM a56 
                            LEFT JOIN a11 on a11.p01 = a56.p05 
                            LEFT JOIN mydt00 on mydt00.nr01 = 1 
                            WHERE a56.nr01 = ? 
                            ";
                    break;
    
                case 't08':
                    $query =
                        "SELECT 
                            if( ifnull(mydt00.p103, 0)=1, concat(ifnull(t10.p00, ''), if(t08.p701='', '', '-'), t08.p701),t08.p701) as series
                            FROM t08 
                            LEFT JOIN t10 on t10.p01 = t08.p05 
                            LEFT JOIN mydt00 on mydt00.nr01 = 1 
                            WHERE t08.nr01 = ? 
                            ";
                    break;
    
                case 'tran01':
                    $query =
                        "SELECT 
                            if( ifnull(mydt00.p103, 0)=1, concat(ifnull(tran20.p00, ''), if(tran01.sp00='', '', '-'), tran01.sp00), tran01.sp00) as series
                            FROM tran01 
                            LEFT JOIN tran20 on tran20.p01 = tran01.p105 
                            WHERE tran01.nr01 = ? 
                            ";
                    break;
    
                default:
                    break;
            }
    
            pegasus_mysql_use($query, $res, array($tbl_nr01));
    
            return ($res["series"] == '')? 0 : $res["series"];
    
        }
    
        public static function mydt_find_invtype($tbl, $tbl_nr01){
            switch ($tbl) {
                case 'a55':
                    $query =
                        "SELECT 
                            q31.p05 as mydt50_p00
                            FROM q31
                            JOIN a10 ON q31.p03=a10.p01
                            JOIN a55 ON a55.p05=a10.p01
    
                            WHERE q31.p01 in (620014 , 620068 ) and a55.nr01 = ?  
                            /* Απορία αν το δελτίο διακίνησης μπορεί να έχει υπογραφη - φανταζομαι πως όχι .. αν οχι, πρέπει να τον έχω κόψει πιο προν στην πληρωμη  */
                        ";
                    break;
                case 'a56':
                    //TODO
                    break;
                case 't08':
                  //TODO
                    break;
                case 'tran01':
                  //TODO
                    break;
                default:
                    break;
            }
            pegasus_mysql_use($query, $res, array($tbl_nr01));
    
            return ($res["mydt50_p00"] == '')? '' : $res["mydt50_p00"];
        }
    }