insert into {p_mydt10tbl1}
(tbl, tbl_nr01, p00, p01, p03, p06, p07, p08d, p08t,
currency, exchrate, slfpricing,
mvpurpose, vatpaysusp,
vehiclenum, spinvcat, invvarty,
series, aa, issuedate, issuetime, invtype, paytype,  
is_country, is_vat, is_name, is_address, is_city, is_zip, is_tbl, is_nr01,
cp_country, cp_vat, cp_name, cp_address, cp_city, cp_zip, cp_tbl, cp_nr01,
dispdate, disptime, ldstreet, ldzip, ldnumber, ldcity, dlvstreet, dlvzip, dlvnumber, dlvcity,
ss_branch, cs_branch, othmvpur, p103, 
/*v1.105*/ p_notes)

SELECT tbl as tbl,
       tbl_nr01 as tbl_nr01,
       p00 as p00,
       p01 as p01,
       p03 as p03,
       p06 as p06,
       p07 as p07,
       p08d as p08d,
       p08t as p08t,
       currency as currency,
       exchrate as exchrate,
       slfpricing as slfpricing,      
       mvpurpose as mvpurpose,
       vatpaysusp as vatpaysusp,      
       vehiclenum as vehiclenum,
       spinvcat   as spinvcat,
       invvarty   as invvarty,
       series as series,
       aa as aa,
       issuedate as issuedate,
       issuetime as issuetime,
       invtype as invtype,
       paytype as paytype,
       
       ''             as is_country,
       '{nt_p101[1]}' as is_vat,
       '{nt_p101[2]}' as is_name,
       '{nt_p101[3]}' as is_address,
       '{nt_p101[4]}' as is_city,
       '{nt_p101[5]}' as is_zip,
       '{nt_p101[6]}' as is_tbl,
       '{nt_p101[7]}' as is_nr01,
       a_country as cp_country,
       /*v1.104*/
       /*a_vat     as cp_vat,*/
       if( mvpurpose IN ('8','19'), '{nt_p101[1]}', a_vat) as cp_vat,       
       a_name    as cp_name,
       a_address as cp_address,
       a_city    as cp_city,
       a_zip     as cp_zip,
       a_tbl     as cp_tbl,
       a_nr01    as cp_nr01,

       dispdate  as dispdate,
       disptime  as disptime,

       ldstreet   as ldstreet, 
       ldzip      as ldzip, 
       ldnumber   as ldnumber, 
       ldcity     as ldcity,
       dlvstreet  as dlvstreet, 
       dlvzip     as dlvzip, 
       dlvnumber  as dlvnumber, 
       dlvcity    as dlvcity,
       /*v1.88*/
       ss_branch  as ss_branch, 
       cs_branch  as cs_branch,
       othmvpur   as othmvpur, 
       if(p103_1<>'', p103_1, p103_2) as p103, 
       /*v1.105*/
       p_notes as p_notes

FROM
(
      /***********************************************
             Παραστατικά Eσωτερικής διακινησης προς αποστολή
             q30.nr01=620072
      ***********************************************/
      (
      SELECT 'a60' as tbl,
            a60.nr01 as tbl_nr01,
            1 as p00, /* 3 = Δελτιο Διακινησης ---- Νομίζω εδώ το θέλουμε 1 όπως κάνουμε στο 299_900*/
            1 as p01, /* 1 = αποστολη */
            a60.p0121 as p03, /* Καταστημα*/
            0 as p06, /* Καθεστως ΦΠΑ */
            0 as p07, /* Κ.Κ. Λογιστηριου */ /** TODO Na to ελέγξω αυτό **/
            a60.remdate as p08d,
            a60.remtime as p08t,            
            '' as currency,
            '1' as exchrate,
            0 as slfpricing,
            /*v1.81*/
            ifnull( (select q31_in.p05
                    from q31 as q31_in,
                        erpa13 as erpa13_in
                    where q31_in.p01=620057
                        && q31_in.p03=erpa13_in.nr01
                        && erpa13_in.p01=a60.p012
                    limit 1), '19') as mvpurpose,
            0 as vatpaysusp,      
            
            
            a60.p702 as vehiclenum,
            '' as spinvcat,
            /**invoice variation type**/
            '' as invvarty,
            
            /**στοιχεία παραστατικού*/
            concat('ΣΔΑ-',
                if( ifnull(mydt00.p103, 0)=1,
                    concat(ifnull(a30.p00, ''), if(a60.p701='', '', '-'), a60.p701),
                    a60.p701
                )
            ) as series, /**- - -> Να βάλω το ΣΔΑ εδώ καρφωτά **/
            a60.p06  as aa,
            a60.p01 as issuedate,
            a60.p02 as issuetime,
            ifnull(mydt50.p00, '') as invtype,
            
            /**paytype**/          
            '' as paytype,
            
            /*αντισυμβαλλόμενος*/
            /**ΣΤΑ COUNTERPART ΌΛΑ ΚΕΝΑ ΚΑΙ ΤΟ ΑΦΜ ΜΕ 9 ΜΗΔΕΝΙΚΑ **/
            '' as a_country,
            '000000000' as a_vat,
            '-' as a_name,
            '-' as a_address,
            '-' a_city,
            '00000' as a_zip,
            /* Web v1.153 */
            '' as a_tbl,
            '' as a_nr01,

            if(a60.d_p01 > cast('0100-01-01' as date) , a60.d_p01 , cast('0100-01-01' as date)) as dispdate,
            if(a60.d_p02 = '', '', concat(a60.d_p02, ':00')) AS disptime,

            /*v1.88*/
            a60.ldstreet  as ldstreet, 
            a60.ldzip     as ldzip, 
            a60.ldnumber  as ldnumber, 
            a60.ldcity    as ldcity,
            a60.dlvstreet as dlvstreet, 
            a60.dlvzip    as dlvzip, 
            a60.dlvnumber as dlvnumber, 
            a60.dlvcity   as dlvcity,
            a60.ss_branch as ss_branch, 
            a60.cs_branch as cs_branch, 

            if(a60.p012='', 'Εσωτερική Διακίνηση', a60.p012) as othmvpur, 
            /*Εκτυπωτής παραστατικού αν δεν είναι χειρόγραφο*/
            if( a60.p08=0, ifnull(a30.p08, ''),  '') as p103_1,
            if( a60.p08=0, ifnull(f02.p010, ''), '') as p103_2, 
           
           /*v1.105*/
           concat(   if( ifnull(mydt00.p112, 0)=1 && a60.p011<>'', 
                         concat(a60.p011, char(13), char(10)), 
                         ''
                       ), 
                     if( ifnull(mydt00.p113, 0)=1 && ifnull(a60.p30, '')<>'', 
                         concat(ifnull(a60.p30, ''), char(13), char(10)), 
                         ''
                       )
                 ) as p_notes  

      FROM q31
      LEFT JOIN a30 ON q31.p03=a30.p01
      LEFT JOIN a60 ON a60.p05=a30.p01
                    && a60.p01>=cast('{odbcdtos(nt_p01)}' as date)
                    && a60.p01<=cast('{odbcdtos(nt_p02)}' as date)
                    && a60.remdate>=cast('{odbcdtos(nt_p07d)}' as date)
                    && a60.remdate<=cast('{odbcdtos(nt_p08d)}' as date)
                    && concat(a60.remdate, a60.remtime)>=concat(cast('{odbcdtos(nt_p07d)}' as date), '{nt_p07t}')
                    && concat(a60.remdate, a60.remtime)<=concat(cast('{odbcdtos(nt_p08d)}' as date), '{nt_p08t}')
                   
                    ##start_module_exist_stores##
                    && a60.p0121 in (##store_in_sql##)                
                    ##end_module_exist_stores##  
             
      LEFT JOIN mydt50 ON mydt50.p00=q31.p05
      LEFT JOIN i16 as i16_loading ON i16_loading.p00=a60.p03
      LEFT JOIN i16 as i16_delivery ON i16_delivery.p00=a60.p04
      LEFT JOIN f02 ON f02.nr01=1
      LEFT JOIN mydt00 ON mydt00.nr01=1
      WHERE q31.p01=620072 
         && a60.nr01 is not null
         && a30.nr01 is not null
         && {p_mydt10where}
         && {nt_napost}=1
      GROUP BY a60.nr01
      {p_mydt10limit}
      )

) as tbl01;          
/*peg_end*/