SELECT 
       count(*) as cnt 

FROM 
       (
              SELECT tbl as tbl, 
                     tbl_nr01 as tbl_nr01, 
                     p00 as p00, 
                     p01 as p01, 
                     p03 as p03, 
                     p06 as p06, 
                     p07 as p07, 
                     p08d as p08d, 
                     p08t as p08t, 
                     currency as currency, 
                     exchrate as exchrate, 
                     series as series, 
                     aa as aa, 
                     issuedate as issuedate, 
                     invtype as invtype, 
                     paytype as paytype, 
                     vehiclenum as vehiclenum,
                     
                     ''             as is_country,
                     '{nt_p101[1]}' as is_vat, 
                     '{nt_p101[2]}' as is_name, 
                     '{nt_p101[3]}' as is_address, 
                     '{nt_p101[4]}' as is_city, 
                     '{nt_p101[5]}' as is_zip,
                     /* Web v1.153 */
                     '{nt_p101[6]}' as is_tbl,
                     '{nt_p101[7]}' as is_nr01,
                     a_country as cp_country,
                     a_vat     as cp_vat, 
                     a_name    as cp_name, 
                     a_address as cp_address, 
                     a_city    as cp_city, 
                     a_zip     as cp_zip,
                     /* Web v1.153 */
                     a_tbl     as cp_tbl,
                     a_nr01    as cp_nr01

              FROM
              (
              /***********************************************
                     Παραστατικά προς αποστολή
                     q30.nr01=620072
              ***********************************************/
              (
              SELECT 'a60' as tbl, 
                     a60.nr01 as tbl_nr01, 
                     1 as p00,
                     1 as p01,
                     a60.p0121 as p03, 
                     0 as p06, 
                     0 as p07, 
                     a60.remdate as p08d, 
                     a60.remtime as p08t,             
                     '' as currency, 
                     '1' as exchrate,
                     
                     /**στοιχεία παραστατικού*/
                     a60.p701 as series, 
                     a60.p06  as aa, 
                     a60.p01 as issuedate, 
                     ifnull( (select q31_in.p05
                                   from q31 as q31_in
                                   where q31_in.p01=620072
                                   && q31_in.p03=a30.p01
                                   limit 1), '') as invtype,
                     
                     /**paytype**/           
                     '' as paytype,
                     /*Αρ. Κυκλοφορίας*/
                     a60.p702 as vehiclenum,
                     /*αντισυμβαλλόμενος*/
                    /**ΣΤΑ COUNTERPART ΌΛΑ ΚΕΝΑ ΚΑΙ ΤΟ ΑΦΜ ΜΕ 9 ΜΗΔΕΝΙΚΑ **/
                    '' as a_country,
                    '000000000' as a_vat,
                    '' as a_name,
                    '' as a_address,
                    '' as a_city,
                    '' as a_zip,
                    /* Web v1.153 */
                    '' as a_tbl,
                    '' as a_nr01
              FROM q31
              LEFT JOIN a30 ON q31.p03=a30.p01
              LEFT JOIN a60 ON a60.p05=a30.p01
                            && a60.p01>=cast('{odbcdtos(nt_p01)}' as date)
                            && a60.p01<=cast('{odbcdtos(nt_p02)}' as date)
                            && a60.remdate>=cast('{odbcdtos(nt_p07d)}' as date)
                            && a60.remdate<=cast('{odbcdtos(nt_p08d)}' as date)
                            && concat(a60.remdate, a60.remtime)>=concat(cast('{odbcdtos(nt_p07d)}' as date), '{nt_p07t}')
                            && concat(a60.remdate, a60.remtime)<=concat(cast('{odbcdtos(nt_p08d)}' as date), '{nt_p08t}')

                            ##start_module_exist_stores##
                            && a60.p0121 in (##store_in_sql##)                 
                            ##end_module_exist_stores##
                            
              /** LEFT JOIN a01 ON a01.nr01=a55.p03 **/
              /** LEFT JOIN d22 ON d22.p01=a01.p4_3 **/
              WHERE q31.p01 = 620072 
                     && a60.nr01 is not null
                     && a30.nr01 is not null
                     && {p_mydt10where} 
              GROUP BY a60.nr01
              )
       ) as tbl01
       )
       as tttttt;       