SELECT *
FROM
(
  SELECT mydt10.nr01, 
         mydt10.issueDate as issueDate,
         mydt10.uid as uid,
         mydt10.mark as mark,

         mydt12.nr01 as nr01_1, 
         /*v1.58*/
         if(mydt12.linerel=0, mydt12.linenumber, mydt12.linerel) as lineNumber,
         mydt12.linerel as linerel,
         mydt12.mydt61_p00 as classificationType,
         mydt12.mydt57_p00 as classificationCategory,
         mydt12.netvalue + mydt12.wthhld_am + mydt12.fees_am + mydt12.otax_am as amount,

         ifnull( (select sum(if(mydt12_in.mydt57_p00='' && mydt12_in.mydt61_p00='', 1, 0))
                  from mydt12 as mydt12_in
                  where mydt12_in.mydt10=mydt10.nr01 && mydt12_in.isinfo=0
                  group by mydt12_in.mydt10), 0) as nomarked, 
         ifnull( (select sum(if(mydt12_in.mydt57_p00='' && mydt12_in.mydt61_p00='', 0, 1))
                  from mydt12 as mydt12_in
                  where mydt12_in.mydt10=mydt10.nr01 && mydt12_in.isinfo=0
                  group by mydt12_in.mydt10), 0) as marked
                  
         
   FROM mydt10

   join mydt12 on mydt12.mydt10=mydt10.nr01
   
   ##start_module_exist_stores##
   left join t07 on mydt10.p03=t07.p01
   left join t05 on t05.p01=t07.p07
   left join mydt01 on mydt01.p100=t05.p01                               
   ##end_module_exist_stores##


   WHERE  mydt10.mark<>''
      && (mydt10.entuid='' || mydt10.p02_1=1)
      && mydt10.p00=1
      && mydt10.p01=2
      && mydt10.nr01 in (##mydt10_nr01s##)
   
      ##mydt10_nr01_where##
      && mydt10.p09=0
      && mydt12.isinfo=0
   /*v1.58*/
   /*ORDER BY mydt10.issueDate, mydt10.nr01, mydt12.linenumber */
) as tbl01
WHERE nomarked=0
   && marked<>0
/*v1.58*/   
ORDER BY tbl01.issueDate, tbl01.nr01, tbl01.linerel, tbl01.linenumber   ;
